/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.calcnode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mmc.mps.common.model.MPSPlanProgramModel;
import kd.mmc.mps.common.model.MPSPlanProgramWorkCenterModel;
import kd.mmc.mps.common.util.MPSScheduleUtils;

public class MPSInitOrderToGroup {
    public Map<Long, Long> getOrderToGroupDefine(DataSet orderData, Map<String, Object> capacityData, DynamicObject plan) {
        List<Map<String, Object>> scheduleOrderList = this.getScheduleOrder(orderData);
        this.getSortOrderList(plan, scheduleOrderList);
        HashMap orderToMatType = new HashMap(scheduleOrderList.size());
        ArrayList moreGroupOrderId = new ArrayList(scheduleOrderList.size());
        Map orderIdToGroupDefineIdMap = MPSScheduleUtils.getOrderToGroupMap(scheduleOrderList, orderToMatType, (Boolean)false, moreGroupOrderId);
        capacityData.put("moreGroupOrderId", moreGroupOrderId);
        capacityData.put("orderIdToGroupDefineIdMap", orderIdToGroupDefineIdMap);
        capacityData.put("scheduleOrderList", scheduleOrderList);
        return orderIdToGroupDefineIdMap;
    }

    private void getSortOrderList(DynamicObject plan, List<Map<String, Object>> scheduleOrderList) {
        if (plan.getDynamicObject("prioritydefine") != null) {
            Long prioritydefineId = plan.getDynamicObject("prioritydefine").getLong("id");
            List sortScheduleOrderList = (List)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IPriorityCalculationService", (String)"calPlanPriorityModel", (Object[])new Object[]{prioritydefineId, scheduleOrderList});
            scheduleOrderList.clear();
            scheduleOrderList.addAll(sortScheduleOrderList);
        }
    }

    public List<Map<String, Object>> getScheduleOrder(DataSet orderData) {
        ArrayList<Map<String, Object>> scheduleOrderList = new ArrayList<Map<String, Object>>(10);
        if (orderData != null) {
            String[] fieldNames = orderData.getRowMeta().getFieldNames();
            while (orderData.hasNext()) {
                Row next = orderData.next();
                HashMap<String, Object> message = new HashMap<String, Object>(16);
                for (String filedName : fieldNames) {
                    message.put(filedName, next.get(filedName));
                }
                Object sourceentryid = message.get("sourceentryid");
                if (sourceentryid != null && Long.parseLong(sourceentryid.toString()) != 0L) {
                    message.put("sourcebillid_old", message.get("sourcebillid"));
                    message.put("sourcebillid", sourceentryid);
                }
                scheduleOrderList.add(message);
            }
        }
        return scheduleOrderList;
    }

    public void getGroupIdToBeginDay(MPSPlanProgramModel mpsPlanProgramModel, Map<String, Object> capacityData) {
        List workCenterInfoList = mpsPlanProgramModel.getWorkCenterInfoList();
        Map sourcebillentryidsToAppointData = mpsPlanProgramModel.getSourcebillentryidsToAppointData();
        HashMap workCenterAndgroupIdToBeginDay = new HashMap(workCenterInfoList.size());
        HashMap<Long, String> plantype = new HashMap<Long, String>(workCenterInfoList.size());
        for (MPSPlanProgramWorkCenterModel mpsPlanProgramWorkCenterModel : workCenterInfoList) {
            Long workCenterId = mpsPlanProgramWorkCenterModel.getWorkCenterId();
            Long firstGroupId = mpsPlanProgramWorkCenterModel.getFirstGroupId();
            Integer firstDay = mpsPlanProgramWorkCenterModel.getFirstDay();
            String scheduleType = mpsPlanProgramWorkCenterModel.getScheduleType();
            HashMap<Long, Integer> groupIdAndFirstDay = new HashMap<Long, Integer>(8);
            plantype.put(workCenterId, scheduleType);
            if (firstGroupId != null && firstGroupId != 0L) {
                if (firstDay == null || firstDay == 0) {
                    groupIdAndFirstDay.put(firstGroupId, 0);
                } else {
                    groupIdAndFirstDay.put(firstGroupId, firstDay);
                }
            }
            workCenterAndgroupIdToBeginDay.put(workCenterId, groupIdAndFirstDay);
        }
        capacityData.put("groupIdToPlanTypeMap", plantype);
        capacityData.put("workCenterAndgroupIdToBeginDay", workCenterAndgroupIdToBeginDay);
        capacityData.put("sourcebillentryidsToAppointData", sourcebillentryidsToAppointData);
    }
}

