/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.calcnode;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.mps.calcnode.MPSGetBrachingData;
import kd.mmc.mps.common.model.ReduOrderModel;
import kd.mmc.mps.common.util.MPSScheduleUtils;
import kd.mmc.mps.consts.schedule.SchedulePlanErrors;
import kd.mmc.mps.mservice.exception.PLSWarnException;
import kd.mpscmm.msplan.mservice.service.datafetch.DataFetcher;

public class MPSInitReduOrder {
    List<String> mustInputFileds = Arrays.asList("configure", "materiel_code", "production_org", "sourcebillid", "plan_order_billno");

    public List<ReduOrderModel> getInitReduOrder(DynamicObject plan, Map<String, Object> capacityData, Boolean isCheckDate) {
        Set<Long> orderModelId = this.getOrderModelId(plan);
        DataSet orderDataset = this.getOrderDataset(orderModelId);
        List<ReduOrderModel> reduOrder = null;
        if (orderDataset != null) {
            MPSGetBrachingData mpsGetBrachingData = new MPSGetBrachingData();
            Map<Long, Long> groupToWorkcenter = mpsGetBrachingData.mpsGetBrachingData(plan, orderDataset);
            List<Map<String, Object>> scheduleOrderList = this.getsScheduleplanMessage(orderDataset.copy());
            HashMap orderToMatType = new HashMap(scheduleOrderList.size());
            ArrayList moreGroupOrderId = new ArrayList(scheduleOrderList.size());
            Map orderToGroupMap = MPSScheduleUtils.getOrderToGroupMap(scheduleOrderList, orderToMatType, (Boolean)false, moreGroupOrderId);
            capacityData.put("moreGroupOrderId_reduorder", moreGroupOrderId);
            reduOrder = this.getReduOrder(capacityData, orderToGroupMap, orderDataset, groupToWorkcenter, isCheckDate);
        }
        return reduOrder;
    }

    public List<ReduOrderModel> getInitReduOrderByReport(DataSet orderDataset, Map<Long, Long> groupToWorkcenter, Map<Long, Long> orderToGroupMap) {
        List<ReduOrderModel> reduOrder = null;
        if (orderDataset != null) {
            reduOrder = this.getReduOrderByReport(orderDataset.copy(), groupToWorkcenter, orderToGroupMap);
        }
        return reduOrder;
    }

    public Set<Long> getOrderModelId(DynamicObject plan) {
        DynamicObjectCollection orderEntryColl = plan.getDynamicObjectCollection("data_entryentity");
        HashSet<Long> idSet = new HashSet<Long>(orderEntryColl.size());
        if (orderEntryColl != null && !orderEntryColl.isEmpty()) {
            for (DynamicObject order : orderEntryColl) {
                boolean isCalculate = false;
                if (order.get("dataisincalculate") != null) {
                    isCalculate = order.getBoolean("dataisincalculate");
                }
                if (!isCalculate || order.get("dataresourceconfig") == null) continue;
                idSet.add(order.getLong("dataresourceconfig_id"));
            }
        }
        return idSet;
    }

    public DataSet getOrderDataset(Set<Long> modelIds) {
        DataSet dataSet = null;
        DataFetcher dataFetcher = new DataFetcher();
        for (Long modelId : modelIds) {
            DataSet dsItem = dataFetcher.getDataSet(modelId);
            if (dsItem == null || dsItem.isEmpty()) {
                return dataSet;
            }
            List<String> metas = Arrays.asList(dsItem.getRowMeta().getFieldNames());
            if (!metas.containsAll(this.mustInputFileds)) {
                throw new PLSWarnException(SchedulePlanErrors.fieldMustInputError(), new Object[]{StringUtils.join(this.mustInputFileds, (String)",")});
            }
            if (dataSet == null) {
                dataSet = dsItem;
                continue;
            }
            RowMeta leftRowMeta = dataSet.getRowMeta();
            RowMeta rightRowMeta = dsItem.getRowMeta();
            Field[] leftFields = leftRowMeta.getFields();
            Field[] rightFields = rightRowMeta.getFields();
            HashSet<String> allFieldName = new HashSet<String>(16);
            HashSet<String> leftName = new HashSet<String>(16);
            HashSet<String> rightName = new HashSet<String>(16);
            for (Field leftField : leftFields) {
                allFieldName.add(leftField.getName());
                leftName.add(leftField.getName());
            }
            for (Field rightField : rightFields) {
                allFieldName.add(rightField.getName());
                rightName.add(rightField.getName());
            }
            for (String fieldName : allFieldName) {
                if (!leftName.contains(fieldName)) {
                    dataSet = dataSet.addNullField(fieldName);
                }
                if (rightName.contains(fieldName)) continue;
                dsItem = dsItem.addNullField(fieldName);
            }
            dataSet = dataSet.select(allFieldName.toArray(new String[0]));
            dsItem = dsItem.select(allFieldName.toArray(new String[0]));
            dataSet = dataSet.union(dsItem);
        }
        return dataSet;
    }

    private List<ReduOrderModel> getReduOrderByReport(DataSet dataSet, Map<Long, Long> groupToWorkcenter, Map<Long, Long> orderIdToGroupDefindIdMap) {
        ArrayList<ReduOrderModel> reduOrderModelList = new ArrayList<ReduOrderModel>(8);
        List<String> metas = Arrays.asList(dataSet.getRowMeta().getFieldNames());
        while (dataSet.hasNext()) {
            Long sourceentryid;
            Row schedulePlanDyn = dataSet.next();
            Date pls_date = schedulePlanDyn.getDate("pls_date");
            if (pls_date != null) {
                pls_date = MPSScheduleUtils.getNewDate((Date)pls_date);
            }
            if (pls_date == null) continue;
            HashMap<String, Object> mapEntry = new HashMap<String, Object>(8);
            this.putMessageToMapEntry("sourcebillid", "sourcebillid", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("plan_order_billno", "plan_order_billno", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("sourceentryid", "sourceentryid", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("billtype", "billtype", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("materiel_code", "materiel_code", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("unit", "unit", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("configure", "configure", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("tracknumber", "tracknumber", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("production_org", "production_org", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("scheduleqty", "plsqty", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("requiredate", "pls_date", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("org", "production_org", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("workcentre", "workcenter", schedulePlanDyn, metas, mapEntry);
            Long groupId = orderIdToGroupDefindIdMap.get(schedulePlanDyn.get("sourcebillid"));
            if (groupId == null) {
                groupId = 0L;
            }
            if (metas.contains("sourceentryid")) {
                sourceentryid = schedulePlanDyn.getLong("sourceentryid");
                if (sourceentryid == null || sourceentryid == 0L) {
                    sourceentryid = schedulePlanDyn.getLong("sourcebillid");
                }
            } else {
                sourceentryid = schedulePlanDyn.getLong("sourcebillid");
            }
            ReduOrderModel reduOrderModel = new ReduOrderModel();
            reduOrderModel.setOrderId(sourceentryid);
            BigDecimal plsqty = BigDecimal.ZERO;
            if (metas.contains("plsqty")) {
                plsqty = schedulePlanDyn.getBigDecimal("plsqty");
            }
            Long workcenterId = 0L;
            workcenterId = metas.contains("workcenter") ? schedulePlanDyn.getLong("workcenter") : groupToWorkcenter.get(groupId);
            if (workcenterId == null) {
                workcenterId = 0L;
            }
            reduOrderModel.setWorkCenterId(workcenterId);
            reduOrderModel.setOrderNum(plsqty);
            Date plsdate = null;
            if (metas.contains("pls_date")) {
                plsdate = schedulePlanDyn.getDate("pls_date");
            }
            reduOrderModel.setDate(plsdate);
            reduOrderModel.setOrderMessge(mapEntry);
            reduOrderModelList.add(reduOrderModel);
        }
        return reduOrderModelList;
    }

    private List<ReduOrderModel> getReduOrder(Map<String, Object> capacityData, Map<Long, Long> orderIdToGroupDefindIdMap, DataSet dataSet, Map<Long, Long> groupToWorkcenter, Boolean isCheckDate) {
        ArrayList<ReduOrderModel> reduOrderModelList = new ArrayList<ReduOrderModel>(8);
        List scheduleDay = (List)capacityData.get("planDateList_long");
        Map groupDefineToGroupMap = (Map)capacityData.get("groupDefineToGroupMap");
        List<String> metas = Arrays.asList(dataSet.getRowMeta().getFieldNames());
        while (dataSet.hasNext()) {
            Long sourceentryid;
            Row schedulePlanDyn = dataSet.next();
            Date pls_date = schedulePlanDyn.getDate("pls_date");
            if (pls_date != null) {
                pls_date = MPSScheduleUtils.getNewDate((Date)pls_date);
            }
            if (isCheckDate.booleanValue() && (pls_date == null || !scheduleDay.contains(pls_date.getTime()))) continue;
            HashMap<String, Object> mapEntry = new HashMap<String, Object>(8);
            this.putMessageToMapEntry("sourcebillid", "sourcebillid", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("plan_order_billno", "plan_order_billno", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("sourceentryid", "sourceentryid", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("billtype", "billtype", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("materiel_code", "materiel_code", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("unit", "unit", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("configure", "configure", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("tracknumber", "tracknumber", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("production_org", "production_org", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("scheduleqty", "plsqty", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("requiredate", "pls_date", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("org", "production_org", schedulePlanDyn, metas, mapEntry);
            this.putMessageToMapEntry("workcentre", "workcenter", schedulePlanDyn, metas, mapEntry);
            Long groupDefindeId = orderIdToGroupDefindIdMap.get(schedulePlanDyn.get("sourceentryid"));
            Long groupId = 0L;
            if (groupDefineToGroupMap != null && (groupId = (Long)groupDefineToGroupMap.get(groupDefindeId)) == null) {
                groupId = 0L;
            }
            if (metas.contains("sourceentryid")) {
                sourceentryid = schedulePlanDyn.getLong("sourceentryid");
                if (sourceentryid == null || sourceentryid == 0L) {
                    sourceentryid = schedulePlanDyn.getLong("sourcebillid");
                }
            } else {
                sourceentryid = schedulePlanDyn.getLong("sourcebillid");
            }
            ReduOrderModel reduOrderModel = new ReduOrderModel();
            reduOrderModel.setOrderId(sourceentryid);
            reduOrderModel.setGroupId(groupId);
            reduOrderModel.setGroupDefindId(groupDefindeId);
            BigDecimal plsqty = BigDecimal.ZERO;
            if (metas.contains("plsqty")) {
                plsqty = schedulePlanDyn.getBigDecimal("plsqty");
            }
            reduOrderModel.setOrderNum(plsqty);
            Long workcenterId = 0L;
            workcenterId = metas.contains("workcenter") ? schedulePlanDyn.getLong("workcenter") : groupToWorkcenter.get(groupId);
            if (workcenterId == null) {
                workcenterId = 0L;
            }
            reduOrderModel.setWorkCenterId(workcenterId);
            Date plsdate = null;
            if (metas.contains("pls_date")) {
                plsdate = schedulePlanDyn.getDate("pls_date");
            }
            reduOrderModel.setDate(plsdate);
            reduOrderModel.setOrderMessge(mapEntry);
            reduOrderModelList.add(reduOrderModel);
        }
        return reduOrderModelList;
    }

    private void putMessageToMapEntry(String key, String valueKey, Row schedulePlanDyn, List<String> metas, Map<String, Object> mapEntry) {
        if (metas.contains(valueKey)) {
            mapEntry.put(key, schedulePlanDyn.get(valueKey));
        }
    }

    public List<Map<String, Object>> getsScheduleplanMessage(DataSet dataSet) {
        ArrayList<Map<String, Object>> scheduleOrderList = new ArrayList<Map<String, Object>>(8);
        List<String> metas = Arrays.asList(dataSet.getRowMeta().getFieldNames());
        while (dataSet.hasNext()) {
            Long sourceentryid;
            Row next = dataSet.next();
            HashMap<String, Object> orderMessage = new HashMap<String, Object>(8);
            if (metas.contains("sourceentryid")) {
                sourceentryid = next.getLong("sourceentryid");
                if (sourceentryid == null || sourceentryid == 0L) {
                    sourceentryid = next.getLong("sourcebillid");
                }
            } else {
                sourceentryid = next.getLong("sourcebillid");
            }
            orderMessage.put("sourcebillid", sourceentryid);
            orderMessage.put("materiel_code", next.getLong("materiel_code"));
            orderMessage.put("configure", next.getLong("configure"));
            orderMessage.put("production_org", next.getLong("production_org"));
            orderMessage.put("plan_order_billno", next.getString("plan_order_billno"));
            scheduleOrderList.add(orderMessage);
        }
        return scheduleOrderList;
    }
}

