/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.calcnode;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mps.calcnode.MPSGetCapacityData;
import kd.mmc.mps.calcnode.MPSGetOrderData;
import kd.mmc.mps.calcnode.MPSGetScheduleDay;
import kd.mmc.mps.calcnode.MPSInitOrderToGroup;
import kd.mmc.mps.calcnode.MPSInitReduOrder;
import kd.mmc.mps.calcnode.MPSOrderScheduPlan;
import kd.mmc.mps.calcnode.MpsMatchDimension;
import kd.mmc.mps.common.model.MPSPlanProgramModel;
import kd.mmc.mps.common.model.ReduOrderModel;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.step.ICalcStep;

public class MPSOrderScheduPlanStep
implements ICalcStep {
    private DynamicObject plan;
    private ExecutionEnv env;
    private DynamicObject runlog;
    private int calcCount = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doWork(ExecutionEnv env, int stepIdx) {
        try (AlgoContext algoContext = Algo.newContext();){
            String string = this.doExecute(env, stepIdx);
            return string;
        }
    }

    private String doExecute(ExecutionEnv executionEnv, int stepIdx) {
        StringBuilder message = new StringBuilder();
        this.env = executionEnv;
        String logEntityNumber = this.env.getLogEntityNumber();
        this.runlog = BusinessDataServiceHelper.loadSingle((Object)this.env.getCtxId(), (String)logEntityNumber);
        String planEntityNumber = this.runlog.getString("plangramentity");
        Object planId = this.runlog.get("plangram");
        this.plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)planEntityNumber);
        HashMap<String, Object> capacityData = new HashMap<String, Object>(8);
        MPSGetOrderData mpsGetOrderData = new MPSGetOrderData();
        MPSPlanProgramModel mpsPlanProgramModel = mpsGetOrderData.getPlanProgramModel(this.env);
        DataSet orderData = mpsGetOrderData.getOrderData(this.plan, mpsPlanProgramModel);
        DataSet dataSet = this.filterOrg(orderData, this.runlog);
        MPSInitOrderToGroup mpsInitOrderToGroup = new MPSInitOrderToGroup();
        mpsInitOrderToGroup.getOrderToGroupDefine(dataSet, capacityData, this.plan);
        mpsInitOrderToGroup.getGroupIdToBeginDay(mpsPlanProgramModel, capacityData);
        MPSGetScheduleDay mpsGetScheduleDay = new MPSGetScheduleDay();
        mpsGetScheduleDay.getScheduleDay(mpsPlanProgramModel, this.plan, capacityData);
        MPSGetCapacityData mpsGetCapacityData = new MPSGetCapacityData();
        mpsGetCapacityData.getCapacityData(mpsPlanProgramModel, this.plan, capacityData, this.runlog);
        MPSInitReduOrder mpsInitReduOrder = new MPSInitReduOrder();
        List<ReduOrderModel> initReduOrder = mpsInitReduOrder.getInitReduOrder(this.plan, capacityData, true);
        MpsMatchDimension mpsMatchDimension = new MpsMatchDimension();
        mpsMatchDimension.getDimension(initReduOrder, capacityData, this.plan);
        MPSOrderScheduPlan mpsOrderScheduPlan = new MPSOrderScheduPlan(this.env);
        mpsOrderScheduPlan.saveOrderScheduPlan(this.plan, initReduOrder, capacityData, message);
        this.logCount(stepIdx, logEntityNumber);
        return message.toString();
    }

    private DataSet filterOrg(DataSet dataSet, DynamicObject runlog) {
        long createorg = runlog.getDynamicObject("createorg").getLong("id");
        StringBuilder sb = new StringBuilder("production_org = ");
        sb.append(createorg);
        if (dataSet != null) {
            DataSet filterDataSet = dataSet.filter(sb.toString());
            return filterDataSet;
        }
        return null;
    }

    private void logCount(int stepIdx, String logEntityNumber) {
        this.runlog = BusinessDataServiceHelper.loadSingle((Object)this.env.getCtxId(), (String)logEntityNumber);
        DynamicObjectCollection entryentity = this.runlog.getDynamicObjectCollection("entryentity");
        List list = entryentity.stream().filter(o -> String.valueOf(stepIdx).equals(o.getString("entrystepseq"))).collect(Collectors.toList());
        if (list.size() > 0) {
            ((DynamicObject)list.get(0)).set("entryprocessdata", (Object)this.calcCount);
            SaveServiceHelper.update((DynamicObject)this.runlog);
        }
    }
}

