/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.calcnode;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.LongType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mps.common.util.MPSScheduleUtils;
import kd.mmc.mps.consts.schedule.SchedulePlanErrors;
import kd.mmc.mps.mservice.exception.PLSWarnException;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.step.ICalcStep;

public class MPSSeqNumGeneratorStep
implements ICalcStep {
    private static final Log logger = LogFactory.getLog(MPSSeqNumGeneratorStep.class);
    private static String[] field = new String[]{"orderId", "groupId", "matTypeId", "scheduDate"};

    public String doWork(ExecutionEnv env, int stepIdx) {
        this.MPSSeqNumGenerator(env);
        return "";
    }

    public void MPSSeqNumGenerator(ExecutionEnv env) {
        String logEntityNumber = env.getLogEntityNumber();
        DynamicObject runlog = BusinessDataServiceHelper.loadSingle((Object)env.getCtxId(), (String)logEntityNumber);
        Object planId = runlog.get("plangram");
        String key = "mpscalc-" + env.getCtxId() + "mps_scheduleplan_pre_args";
        String paramStr = MPSScheduleUtils.getJedis().get(key);
        Object[] params = (Object[])JSON.parseObject((String)paramStr, Object[].class);
        List ja = (List)params[0];
        Long from = (Long)params[1];
        Long to = (Long)params[2];
        Boolean islock = (Boolean)params[3];
        ORM orm = ORM.create();
        String fields0 = "id, billno, org,materiel, scheduleqty,datasourceid, sourcebilltypeid, sourcebillno, sourceentryseq, sheduledate, configuredcode,group,changeseq,createtime";
        String fields1 = "id, billno, org,materiel, scheduleqty, datasourceid,sourcebilltypeid, sourcebillno, sourceentryseq, sheduledate, configuredcode,group,changeseq,createtime,entryentity.serialno,entryentity.sequence,entryentity.instocktime,entryentity.ontime,entryentity.id,entryentity.seq";
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((String)"mps_proplanschdef", (String)"id, workshift,workentry.workcenter,workentry.productionrules", (QFilter[])new QFilter[]{new QFilter("id", "=", planId)});
        Map<Long, Map<Long, BigDecimal>> groupBatch = this.getGroupBatch(plan);
        Long id = plan.getDynamicObject("workshift").getLong("id");
        DynamicObject shift = orm.queryOne("mpdm_classsystem", "id, classsystemtime, entryentity.id, entryentity.workstarttime, entryentity.workendtime", new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (shift == null) {
            throw new PLSWarnException(SchedulePlanErrors.planNoShift());
        }
        BigDecimal timespanByHour = BigDecimal.ZERO;
        if (shift != null) {
            timespanByHour = shift.getBigDecimal("classsystemtime");
        }
        for (int i = 0; i < ja.size(); ++i) {
            Long workCenterId = MPSScheduleUtils.getLongValue(ja.get(i));
            QFilter[] filters = null;
            filters = islock != false ? new QFilter[]{new QFilter("workcentre", "=", (Object)workCenterId), new QFilter("billstatus", "=", (Object)"C"), new QFilter("cancel", "=", (Object)Character.valueOf('0')), new QFilter("sheduledate", ">=", (Object)new Timestamp(from)), new QFilter("sheduledate", "<=", (Object)new Timestamp(to))} : new QFilter[]{new QFilter("workcentre", "=", (Object)workCenterId), new QFilter("billstatus", "=", (Object)"C"), new QFilter("cancel", "=", (Object)Character.valueOf('0')), new QFilter("lock", "=", (Object)Character.valueOf('0')), new QFilter("sheduledate", ">=", (Object)new Timestamp(from)), new QFilter("sheduledate", "<=", (Object)new Timestamp(to))};
            QFilter[] filter_lock = new QFilter[]{new QFilter("workcentre", "=", (Object)workCenterId), new QFilter("billstatus", "=", (Object)"C"), new QFilter("cancel", "=", (Object)Character.valueOf('0')), new QFilter("lock", "=", (Object)Character.valueOf('1')), new QFilter("sheduledate", ">=", (Object)new Timestamp(from)), new QFilter("sheduledate", "<=", (Object)new Timestamp(to))};
            try {
                DataSet planDs = this.getSchedulePlan(orm, fields0, filters);
                DataSet detailDs = this.getSchedulePlan(orm, fields1, filters);
                Map<Long, String> dateToGroupSeq = this.getGroupSeq(planDs.copy());
                Map daySlots = MPSScheduleUtils.parseTimeSlots((DataSet)planDs.copy(), (BigDecimal)timespanByHour, (DynamicObjectCollection)shift.getDynamicObjectCollection("entryentity"));
                Map<Long, BigDecimal> groupToBatch = groupBatch.get(workCenterId);
                ArrayList<Long> orderSeq = new ArrayList<Long>(8);
                HashMap<Long, List<Long>> scheduAndorder = new HashMap<Long, List<Long>>(8);
                List<Map<String, Object>> orderList = this.getDetailDs(detailDs.copy(), orderSeq, scheduAndorder, planDs.copy());
                HashMap<Long, Long> orderToMatType = new HashMap<Long, Long>(orderList.size());
                ArrayList moreGroupOrderId = new ArrayList(8);
                Map orderToGroupDefindMap = MPSScheduleUtils.getOrderToGroupMap(orderList, orderToMatType, (Boolean)false, moreGroupOrderId);
                HashMap<Long, Date> orderAndDate = new HashMap<Long, Date>(8);
                Map<Long, Map<String, Object>> detailsIdToMessage = this.sheduToDetails(planDs, daySlots, detailDs, workCenterId, orderAndDate);
                logger.info("orderToGroupDefindMap" + orderToGroupDefindMap.toString());
                Map<Long, List<Long>> otherMap = this.getOtherMap(orderToGroupDefindMap, orderList, detailsIdToMessage);
                logger.info("orderAndDate" + ((Object)orderAndDate).toString());
                HashMap<String, Object> capacityMessage = new HashMap<String, Object>(80);
                DynamicObjectCollection intensiveColl = MPSScheduleUtils.queryIntensiveColl((Map)orderToGroupDefindMap);
                MPSScheduleUtils.getGroupAndGroupDefineRelation((DynamicObjectCollection)intensiveColl, capacityMessage);
                HashMap<Long, Long> entryToGroupMap = new HashMap<Long, Long>(8);
                Map<Long, Long> orderToGroupMap = this.changeOrderGroupDefindToGroup(orderToGroupDefindMap, capacityMessage, scheduAndorder, entryToGroupMap);
                logger.info("orderToGroupMap" + orderToGroupMap.toString());
                logger.info("detailsIdToMessage" + detailsIdToMessage.toString());
                DataSet[] order_sort = this.getJoinDataSet(orderToMatType, detailDs, orderAndDate, entryToGroupMap);
                ArrayList<Long> groupList_sort = new ArrayList<Long>(80);
                Map<Long, Map<Long, List<Long>>> dateAndGroupAndOrderList = this.getGroupOrderList(order_sort, groupList_sort, detailsIdToMessage, orderAndDate);
                logger.info("dateAndGroupAndOrderList" + dateAndGroupAndOrderList.toString());
                this.isExitDay(dateAndGroupAndOrderList, daySlots);
                HashMap<Long, List<Long>> dateAndSortGroup = new HashMap<Long, List<Long>>(8);
                HashMap<Long, List<Object>> dateAndOtherGroup = new HashMap<Long, List<Object>>(8);
                HashMap<Long, List<Map<Long, BigDecimal>>> dateAndGroupBatch = new HashMap<Long, List<Map<Long, BigDecimal>>>(8);
                Map<Long, Boolean> isNeedSortMap = this.judgeIsNeedSort(dateAndGroupAndOrderList, groupToBatch, dateAndSortGroup, dateAndOtherGroup, dateAndGroupBatch, otherMap);
                Map<Long, List<Long>> sort_groupMap = this.sortGroupBatch(dateAndGroupBatch);
                Map<Long, Object> sort_map = this.batchSortOrder(isNeedSortMap, groupToBatch, dateAndGroupAndOrderList, dateAndSortGroup, dateAndOtherGroup, groupList_sort, sort_groupMap, otherMap, orderSeq, dateToGroupSeq);
                Map<Long, List<Long>> againSortOrder = this.againSortOrder(sort_map);
                logger.info("againSortOrder" + againSortOrder.toString());
                this.updateOrderMessage(againSortOrder, detailsIdToMessage, scheduAndorder);
                continue;
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private DataSet getSchedulePlan(ORM orm, String fields0, QFilter[] filters) {
        DataSet planDs = orm.queryDataSet("mpscalc", "mps_scheduleplan", fields0, filters, "sheduledate desc, id asc");
        return planDs;
    }

    private Map<Long, String> getGroupSeq(DataSet planDs_copy) {
        HashMap<Long, String> dateAndChangeSeq = new HashMap<Long, String>(8);
        DataSet[] rows = planDs_copy.filter("changeseq != ' ' and changeseq != null").splitByGroup(new String[]{"sheduledate"});
        DataSet row_top = null;
        for (DataSet row : rows) {
            if (row != null && row.hasNext()) {
                row_top = row.topBy(1, new String[]{"createtime desc"});
            }
            if (row_top == null || !row_top.hasNext()) continue;
            while (row_top.hasNext()) {
                Row top = row_top.next();
                String changeseq = top.getString("changeseq");
                Date sheduledate = top.getDate("sheduledate");
                if (sheduledate == null) continue;
                dateAndChangeSeq.put(sheduledate.getTime(), changeseq);
            }
        }
        logger.info("dateAndChangeSeq" + ((Object)dateAndChangeSeq).toString());
        return dateAndChangeSeq;
    }

    private void isExitDay(Map<Long, Map<Long, List<Long>>> dateAndGroupAndOrderList, Map<Long, List<Object[]>> daySlots) {
        Set<Long> times = daySlots.keySet();
        for (Long time : times) {
            if (dateAndGroupAndOrderList.containsKey(time)) continue;
            HashMap map = new HashMap();
            dateAndGroupAndOrderList.put(time, map);
        }
    }

    private Map<Long, List<Long>> getOtherMap(Map<Long, Long> orderToGroupDefindMap, List<Map<String, Object>> orderList, Map<Long, Map<String, Object>> detailsIdToMessage) {
        HashMap<Long, List<Long>> otherMap = new HashMap<Long, List<Long>>(8);
        for (Map<String, Object> next : orderList) {
            ArrayList<Long> list;
            Long time;
            Long o = (Long)next.get("sourcebillid");
            if (next.get("date") == null) {
                if (detailsIdToMessage == null || detailsIdToMessage.get(o) == null || detailsIdToMessage.get(o).get("schedudate") == null && (Long)detailsIdToMessage.get(o).get("schedudate") == 0L) continue;
                time = (Long)detailsIdToMessage.get(o).get("schedudate");
            } else {
                time = ((Date)next.get("date")).getTime();
                if (detailsIdToMessage != null && detailsIdToMessage.get(o) != null && (detailsIdToMessage.get(o).get("schedudate") != null || (Long)detailsIdToMessage.get(o).get("schedudate") != 0L)) {
                    time = (Long)detailsIdToMessage.get(o).get("schedudate");
                }
            }
            if (orderToGroupDefindMap.containsKey(o)) continue;
            if (otherMap.containsKey(time)) {
                list = (ArrayList<Long>)otherMap.get(time);
                list.add(o);
                continue;
            }
            list = new ArrayList<Long>(8);
            list.add(o);
            otherMap.put(time, list);
        }
        return otherMap;
    }

    private Map<Long, List<Long>> sortGroupBatch(Map<Long, List<Map<Long, BigDecimal>>> dateAndGroupBatch) {
        HashMap<Long, List<Long>> sortMap = new HashMap<Long, List<Long>>(dateAndGroupBatch.size());
        for (Map.Entry<Long, List<Map<Long, BigDecimal>>> mapEntry : dateAndGroupBatch.entrySet()) {
            ArrayList<Long> list = new ArrayList<Long>(8);
            List<Map<Long, BigDecimal>> value = mapEntry.getValue();
            Long key = mapEntry.getKey();
            value.sort(Comparator.comparingInt(e -> Integer.parseInt(((BigDecimal)e.get(e.keySet().toArray()[0])).toString())));
            for (int i = value.size() - 1; i >= 0; --i) {
                Map<Long, BigDecimal> longBigDecimalMap = value.get(i);
                list.add((Long)longBigDecimalMap.keySet().toArray()[0]);
            }
            sortMap.put(key, list);
        }
        return sortMap;
    }

    private void updateOrderMessage(Map<Long, List<Long>> againSortOrderMap, Map<Long, Map<String, Object>> detailsIdToMessage, Map<Long, List<Long>> scheduAndorder) {
        DynamicObject[] load;
        for (Map.Entry<Long, List<Long>> mapEntry : againSortOrderMap.entrySet()) {
            List<Long> againSortOrder = mapEntry.getValue();
            int seq = BigDecimal.ONE.intValue();
            for (Long detailsId : againSortOrder) {
                Map<String, Object> map;
                if (detailsId == null || detailsId == 0L || (map = detailsIdToMessage.get(detailsId)) == null) continue;
                map.put("seq", seq * 100);
                ++seq;
            }
        }
        for (DynamicObject scheduleplan : load = BusinessDataServiceHelper.load((String)"mps_scheduleplan", (String)"id,entryentity.serialno,entryentity.sequence,entryentity.instocktime,entryentity.ontime,entryentity.id,entryentity.id,workcentre,sheduledate,", (QFilter[])new QFilter[]{new QFilter("id", "in", scheduAndorder.keySet())})) {
            DynamicObjectCollection entryentity = scheduleplan.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryentity) {
                Long dynamicObject_id = dynamicObject.getLong("id");
                Map<String, Object> message = detailsIdToMessage.get(dynamicObject_id);
                dynamicObject.set("ontime", null);
                dynamicObject.set("instocktime", null);
                dynamicObject.set("sequence", message.get("seq"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])load);
    }

    private Map<Long, Map<String, Object>> sheduToDetails(DataSet planDs, Map<Long, List<Object[]>> daySlots, DataSet detailDs, Long workCenterId, Map<Long, Date> orderAndDate) {
        HashMap<Long, Map<String, Object>> detailsIdToMessage = new HashMap<Long, Map<String, Object>>(8);
        HashSet<Long> updated = new HashSet<Long>();
        for (Map.Entry<Long, List<Object[]>> entry : daySlots.entrySet()) {
            HashMap<String, Timestamp> sqlParams = new HashMap<String, Timestamp>();
            sqlParams.put("_sheduledate", new Timestamp(entry.getKey()));
            DataSet dayPlanDs = planDs.copy().filter("sheduledate = _sheduledate", sqlParams);
            Iterator<Object[]> daySlotIter = entry.getValue().iterator();
            block1: while (dayPlanDs.hasNext()) {
                Row row = dayPlanDs.next();
                BigDecimal qty = row.getBigDecimal("scheduleqty");
                Long scheduleplanId = row.getLong("id");
                String fStr0 = "materiel = " + row.getLong("materiel");
                fStr0 = fStr0 + " and sourcebilltypeid = " + row.getLong("sourcebilltypeid");
                fStr0 = fStr0 + " and sourcebillno = '" + String.valueOf(row.getString("sourcebillno")) + "'";
                fStr0 = fStr0 + " and configuredcode =" + row.getLong("configuredcode");
                String fStr1 = fStr0 + " and id <> " + scheduleplanId;
                DataSet subDetailDs = detailDs.copy().filter(fStr1).orderBy(new String[]{"id asc", "entryentity.sequence asc", "sourceentryseq asc"});
                String fStr2 = fStr0 + " and id = " + scheduleplanId;
                DataSet subDetailDs2 = detailDs.copy().filter(fStr2).orderBy(new String[]{"id asc", "entryentity.sequence asc", "sourceentryseq asc"});
                while (qty.compareTo(BigDecimal.ZERO) > 0) {
                    Row dRow = null;
                    DataSet tmpDs = subDetailDs2.hasNext() ? subDetailDs2 : subDetailDs;
                    if (tmpDs.hasNext()) {
                        dRow = tmpDs.next();
                    }
                    if (dRow != null) {
                        Long detailId = dRow.getLong("entryentity.id");
                        while (updated.contains(detailId)) {
                            if (!tmpDs.hasNext()) {
                                qty = BigDecimal.ZERO;
                                continue block1;
                            }
                            dRow = tmpDs.next();
                            detailId = dRow.getLong("entryentity.id");
                        }
                        if (daySlotIter.hasNext()) {
                            Object[] settings = daySlotIter.next();
                            updated.add(detailId);
                            HashMap<String, Object> message = new HashMap<String, Object>(8);
                            message.put("scheduleplan", scheduleplanId);
                            message.put("billno", row.getString("billno"));
                            message.put("schedudate", entry.getKey());
                            message.put("workCenterId", workCenterId);
                            message.put("workshift", settings[1]);
                            detailsIdToMessage.put(detailId, message);
                            orderAndDate.put(detailId, new Timestamp(entry.getKey()));
                        }
                    } else {
                        qty = BigDecimal.ZERO;
                        continue block1;
                    }
                    qty = qty.subtract(BigDecimal.ONE);
                }
            }
        }
        return detailsIdToMessage;
    }

    private Map<Long, List<Long>> againSortOrder(Map<Long, Object> sort_map) {
        HashMap<Long, List<Long>> againSortOrderMap = new HashMap<Long, List<Long>>(sort_map.size());
        for (Map.Entry<Long, Object> mapEntry : sort_map.entrySet()) {
            ArrayList<Long> againSortOrder;
            Long date = mapEntry.getKey();
            Object orders = mapEntry.getValue();
            if (orders instanceof List) {
                List orders_object = (List)orders;
                againSortOrder = new ArrayList<Long>(orders_object.size());
                for (Object orderIds : orders_object) {
                    if (orderIds == null) continue;
                    if (orderIds.toString().contains(",")) {
                        String[] splits;
                        for (String split : splits = orderIds.toString().split(",")) {
                            againSortOrder.add(Long.parseLong(split));
                        }
                        continue;
                    }
                    if (orderIds.toString().isEmpty()) continue;
                    againSortOrder.add(Long.parseLong(orderIds.toString()));
                }
                againSortOrderMap.put(date, againSortOrder);
                continue;
            }
            if (!(orders instanceof String[])) continue;
            String[] orders_string = (String[])orders;
            againSortOrder = new ArrayList(orders_string.length);
            for (String orderIds : orders_string) {
                if (orderIds == null || orderIds.isEmpty()) continue;
                if (orderIds.contains(",")) {
                    String[] splits;
                    for (String split : splits = orderIds.split(",")) {
                        againSortOrder.add(Long.parseLong(split));
                    }
                    continue;
                }
                if (orderIds.isEmpty()) continue;
                againSortOrder.add(Long.parseLong(orderIds));
            }
            againSortOrderMap.put(date, againSortOrder);
        }
        return againSortOrderMap;
    }

    private Map<Long, Object> batchSortOrder(Map<Long, Boolean> isNeedSortMap, Map<Long, BigDecimal> groupToBatch, Map<Long, Map<Long, List<Long>>> dateAndGroupAndOrderList, Map<Long, List<Long>> dateAndSortGroup, Map<Long, List<Object>> dateAndotherGroup, List<Long> groupList_sort, Map<Long, List<Long>> dateAndGroupBatch, Map<Long, List<Long>> otherMap, List<Long> orderSeq, Map<Long, String> dateToGroupSeq) {
        HashMap<Long, Object> sortObject = new HashMap<Long, Object>(8);
        for (Map.Entry<Long, Map<Long, List<Long>>> dateAndGroupAndOrder : dateAndGroupAndOrderList.entrySet()) {
            Map<Long, List<Long>> groupAndOrderList = dateAndGroupAndOrder.getValue();
            Long date = dateAndGroupAndOrder.getKey();
            List<Long> groupSortList = dateAndSortGroup.get(date);
            List<Object> otherGroup = dateAndotherGroup.get(date);
            this.removeRepeactOtherGroup(otherGroup);
            List<Long> noGroupOrder = otherMap.get(date);
            List<Long> groups = dateAndGroupBatch.get(date);
            Boolean isNeedSort = isNeedSortMap.get(date);
            if (isNeedSort.booleanValue()) {
                boolean userInterpolationMethod = this.isUserInterpolationMethod(groupSortList, groupAndOrderList, groupToBatch, groupToBatch, otherGroup);
                if (userInterpolationMethod) {
                    BigDecimal index = BigDecimal.ZERO;
                    for (Long l : groups) {
                        List<Long> groupOrderList2 = groupAndOrderList.get(l);
                        int sum = 0;
                        if (groupOrderList2 == null) continue;
                        sum = groupOrderList2.size();
                        int size = 0;
                        int otherGroup_size = otherGroup.size();
                        BigDecimal batch = groupToBatch.get(l);
                        int groupOrderList_size = groupOrderList2.size();
                        BigDecimal divide = BigDecimal.valueOf(groupOrderList_size).divide(batch, 10, 0);
                        if (otherGroup_size == 0) {
                            otherGroup_size = divide.intValue();
                        } else {
                            if (size == 0) {
                                otherGroup.add(0, "");
                            }
                            ++otherGroup_size;
                        }
                        BigDecimal space_num = BigDecimal.valueOf(otherGroup_size).divide(divide, 2, 4);
                        index = space_num.setScale(0, 0);
                        StringBuilder sb = new StringBuilder();
                        BigDecimal allSpace = BigDecimal.ZERO;
                        for (Long orderId : groupOrderList2) {
                            int i;
                            int k;
                            ++size;
                            if ((batch = batch.subtract(BigDecimal.ONE)).compareTo(BigDecimal.ZERO) > 0) {
                                if (size == sum) {
                                    if (sb.length() != 0) {
                                        sb.append(orderId);
                                        k = Integer.parseInt(index.toString()) - otherGroup.size();
                                        for (i = 0; i < k; ++i) {
                                            otherGroup.add("");
                                        }
                                        otherGroup.add(Integer.parseInt(index.toString()), sb.toString());
                                        sb.setLength(0);
                                        continue;
                                    }
                                    k = Integer.parseInt(index.toString()) - otherGroup.size();
                                    for (i = 0; i < k; ++i) {
                                        otherGroup.add("");
                                    }
                                    otherGroup.add(Integer.parseInt(index.toString()), orderId);
                                    continue;
                                }
                                sb.append(orderId).append(",");
                                continue;
                            }
                            sb.append(orderId);
                            k = Integer.parseInt(index.toString()) - otherGroup.size();
                            for (i = 0; i < k; ++i) {
                                otherGroup.add("");
                            }
                            otherGroup.add(Integer.parseInt(index.toString()), sb.toString());
                            allSpace = space_num.add(index);
                            index = allSpace.setScale(0, 0);
                            sb.setLength(0);
                            batch = groupToBatch.get(l);
                        }
                    }
                    sortObject.put(date, otherGroup);
                    continue;
                }
                Map<Long, String[]> map = this.batchSortOrder_old(groupList_sort, groupToBatch, groupAndOrderList, date, groups, noGroupOrder);
                sortObject.put(date, map.get(date));
                continue;
            }
            String groupSeq = dateToGroupSeq.get(date);
            logger.info("groupSeq" + groupSeq);
            if (groupSeq == null || groupSeq.isEmpty()) {
                for (Long l : groupSortList) {
                    List<Long> list = groupAndOrderList.get(l);
                    if (list == null) continue;
                    otherGroup.addAll(list);
                }
                ArrayList<Object> listSeq = new ArrayList<Object>(otherGroup.size());
                listSeq.addAll(otherGroup);
                sortObject.put(date, listSeq);
                continue;
            }
            ArrayList<Long> list = new ArrayList<Long>(8);
            if (groupSeq.contains(",")) {
                String[] stringArray;
                for (String ids : stringArray = groupSeq.split(",")) {
                    Long groupId4 = Long.parseLong(ids);
                    List<Long> groupOrderList3 = groupAndOrderList.get(groupId4);
                    if (groupOrderList3 != null) {
                        list.addAll(groupOrderList3);
                    }
                    if (!groupSortList.contains(groupId4)) continue;
                    groupSortList.remove(groupId4);
                }
            } else {
                Long l = Long.parseLong(groupSeq);
                List<Long> list2 = groupAndOrderList.get(l);
                if (list2 != null) {
                    list.addAll(list2);
                }
                if (groupSortList.contains(l)) {
                    groupSortList.remove(l);
                }
            }
            for (Long l : groupSortList) {
                List<Long> groupOrderList4 = groupAndOrderList.get(l);
                if (groupOrderList4 == null) continue;
                list.addAll(groupOrderList4);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(8);
            arrayList.addAll(list);
            for (Object o : otherGroup) {
                if (arrayList.contains(o)) continue;
                arrayList.add(o);
            }
            for (Long id : orderSeq) {
                if (arrayList.contains(id)) continue;
                arrayList.remove(id);
            }
            sortObject.put(date, arrayList);
        }
        return sortObject;
    }

    private void removeRepeactOtherGroup(List<Object> otherGroup) {
        ArrayList<Object> otherGroup_clone = new ArrayList<Object>(otherGroup.size());
        if (otherGroup != null) {
            for (Object object : otherGroup) {
                if (otherGroup_clone.contains(object)) continue;
                otherGroup_clone.add(object);
            }
        }
        otherGroup.clear();
        otherGroup.addAll(otherGroup_clone);
    }

    private boolean isUserInterpolationMethod(List<Long> groupSortList, Map<Long, List<Long>> groupAndOrderList, Map<Long, BigDecimal> toBatch, Map<Long, BigDecimal> groupToBatch, List<Object> otherGroup) {
        if (groupSortList.size() > 0) {
            Long firstGroup = groupSortList.get(0);
            int first_size = groupAndOrderList.get(firstGroup).size();
            if (groupToBatch == null || groupToBatch.size() == 0) {
                return false;
            }
            BigDecimal first_batch = groupToBatch.get(firstGroup);
            if (first_batch == null || first_batch.compareTo(BigDecimal.ZERO) == 0) {
                return false;
            }
            BigDecimal divide = BigDecimal.valueOf(first_size).divide(first_batch, 10, 0);
            return divide.intValueExact() <= otherGroup.size();
        }
        return false;
    }

    private Map<Long, String[]> batchSortOrder_old(List<Long> groupList_sort, Map<Long, BigDecimal> groupToBatch, Map<Long, List<Long>> groupAndOrderList, Long date, List<Long> groups, List<Long> noGroupOrder) {
        HashMap<Long, String[]> dateAndOrders = new HashMap<Long, String[]>(groupAndOrderList.size());
        int noGroupOrder_size = 0;
        if (noGroupOrder != null) {
            noGroupOrder_size = noGroupOrder.size();
        }
        int num = noGroupOrder_size;
        for (Map.Entry<Long, List<Long>> entry : groupAndOrderList.entrySet()) {
            List<Long> value = entry.getValue();
            Long key = entry.getKey();
            if (groupToBatch.containsKey(key)) {
                BigDecimal batch = groupToBatch.get(key);
                if (batch != null && value != null && value.size() > 0) {
                    BigDecimal divide = new BigDecimal(value.size()).divide(batch, 10, 0);
                    num += divide.intValue();
                    continue;
                }
                if (value == null) continue;
                num += value.size();
                continue;
            }
            num += value.size();
        }
        ArrayList<Long> groups_clone = new ArrayList<Long>(8);
        groups_clone.addAll(groups);
        for (Long id : groupList_sort) {
            if (groups_clone.contains(id)) continue;
            groups_clone.add(id);
        }
        String[] stringArray = new String[num];
        int index = 0;
        ArrayList<Long> otherGroupList = new ArrayList<Long>(8);
        if (noGroupOrder != null) {
            for (Long id : noGroupOrder) {
                if (otherGroupList.contains(id)) continue;
                otherGroupList.add(id);
            }
        }
        for (Long groupId : groups_clone) {
            List<Long> orderLists = groupAndOrderList.get(groupId);
            int sum = 0;
            if (orderLists == null) continue;
            sum = orderLists.size();
            int size = 0;
            if (groupToBatch.containsKey(groupId)) {
                BigDecimal batch = groupToBatch.get(groupId);
                StringBuilder sb = new StringBuilder();
                block4: for (Long orderId : orderLists) {
                    int k;
                    ++size;
                    if ((batch = batch.subtract(BigDecimal.ONE)).compareTo(BigDecimal.ZERO) > 0) {
                        if (size == sum) {
                            sb.append(orderId);
                            if (index + 1 <= num) {
                                stringArray[index] = sb.toString();
                                ++index;
                            } else {
                                k = 0;
                                for (String s : stringArray) {
                                    if (s == null) {
                                        stringArray[k] = sb.toString();
                                        break;
                                    }
                                    ++k;
                                }
                            }
                        }
                        sb.append(orderId).append(",");
                        continue;
                    }
                    if (index <= num - 1) {
                        sb.append(orderId);
                        stringArray[index] = sb.toString();
                        index += 2;
                        sb.setLength(0);
                        batch = groupToBatch.get(groupId);
                        continue;
                    }
                    k = 0;
                    for (String s : stringArray) {
                        if (s == null) {
                            sb.append(orderId);
                            stringArray[k] = sb.toString();
                            sb.setLength(0);
                            batch = groupToBatch.get(groupId);
                            continue block4;
                        }
                        ++k;
                    }
                }
                continue;
            }
            for (Long id : orderLists) {
                if (otherGroupList.contains(id)) continue;
                otherGroupList.add(id);
            }
        }
        int otherGroup_index = 0;
        for (int y = 0; y < stringArray.length; ++y) {
            if (stringArray[y] != null) continue;
            if (otherGroup_index >= otherGroupList.size()) break;
            stringArray[y] = ((Long)otherGroupList.get(otherGroup_index)).toString();
            ++otherGroup_index;
        }
        dateAndOrders.put(date, stringArray);
        return dateAndOrders;
    }

    private Map<Long, Map<Long, List<Long>>> getGroupOrderList(DataSet[] order_sorts, List<Long> groupList_sort, Map<Long, Map<String, Object>> detailsIdToMessage, Map<Long, Date> orderAndDate) {
        HashMap<Long, Map<Long, List<Long>>> dateAndGroupAndOrderList = new HashMap<Long, Map<Long, List<Long>>>(8);
        for (DataSet order_sort : order_sorts) {
            Date scheduDate = null;
            HashMap<Long, ArrayList<Long>> groupAndOrderList = new HashMap<Long, ArrayList<Long>>(8);
            while (order_sort.hasNext()) {
                ArrayList<Long> groupOrderList;
                Row row = order_sort.next();
                Long groupId = row.getLong("groupId");
                Long orderId = row.getLong("entryentity.id");
                scheduDate = row.getDate("scheduDate");
                if (scheduDate == null) {
                    scheduDate = orderAndDate.get(orderId);
                }
                logger.info("groupIdAndorderId" + groupId + "||" + orderId + "||" + scheduDate);
                if (groupAndOrderList.containsKey(groupId)) {
                    groupOrderList = (ArrayList<Long>)groupAndOrderList.get(groupId);
                    groupOrderList.add(orderId);
                } else {
                    if (!detailsIdToMessage.containsKey(orderId)) continue;
                    if (!groupList_sort.contains(groupId)) {
                        groupList_sort.add(groupId);
                    }
                    groupOrderList = new ArrayList<Long>();
                    groupOrderList.add(orderId);
                    groupAndOrderList.put(groupId, groupOrderList);
                }
                logger.info("groupAndOrderList" + ((Object)groupAndOrderList).toString());
            }
            if (scheduDate == null) continue;
            dateAndGroupAndOrderList.put(scheduDate.getTime(), groupAndOrderList);
        }
        return dateAndGroupAndOrderList;
    }

    private DataSet[] getJoinDataSet(Map<Long, Long> orderToMatType, DataSet detailDs, Map<Long, Date> orderAndDate, Map<Long, Long> entryToGroupMap) {
        List<Object[]> listObject = this.getListObject(orderToMatType, orderAndDate, entryToGroupMap);
        logger.info("listObject" + listObject.toString());
        DataType[] dataType = new DataType[]{new LongType(), new LongType(), new LongType(), new DateType()};
        RowMeta rowMeta = new RowMeta(field, dataType);
        Algo algo = Algo.create((String)"scm");
        DataSet dataSet = algo.createDataSet(listObject, rowMeta);
        JoinDataSet join = detailDs.join(dataSet, JoinType.LEFT);
        DataSet finish = join.on("entryentity.id", "orderId").select(new String[]{"entryentity.id", "materiel", "configuredcode", "id", "entryentity.seq"}, field).finish();
        DataSet order_sort = finish.copy().orderBy(new String[]{"id desc", "entryentity.seq asc", "groupId asc", "materiel asc", "configuredcode asc"});
        DataSet[] dataSets = order_sort.splitByGroup(new String[]{"scheduDate"});
        return dataSets;
    }

    private Map<Long, Boolean> judgeIsNeedSort(Map<Long, Map<Long, List<Long>>> dateAndGroupAndOrderList, Map<Long, BigDecimal> groupToBatch, Map<Long, List<Long>> dateAndSortGroup, Map<Long, List<Object>> dateAndOtherGroup, Map<Long, List<Map<Long, BigDecimal>>> dateAndGroupBatch, Map<Long, List<Long>> otherMap) {
        HashMap<Long, Boolean> judgeIsNeedSortMap = new HashMap<Long, Boolean>(dateAndGroupAndOrderList.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> dateAndGroupAndOrder : dateAndGroupAndOrderList.entrySet()) {
            ArrayList<Long> sortGroup = new ArrayList<Long>(8);
            ArrayList<Long> otherGroup = new ArrayList<Long>(8);
            Map<Long, List<Long>> groupAndOrderList = dateAndGroupAndOrder.getValue();
            Long date = dateAndGroupAndOrder.getKey();
            List<Long> noGroupOrderList = otherMap.get(date);
            BigDecimal maxBatch = BigDecimal.ZERO;
            BigDecimal otherBatch = BigDecimal.ZERO;
            if (noGroupOrderList != null) {
                otherGroup.addAll(noGroupOrderList);
                otherBatch = otherBatch.add(new BigDecimal(noGroupOrderList.size()));
            }
            ArrayList groupBatchList = new ArrayList(8);
            for (Map.Entry<Long, List<Long>> mapEntry : groupAndOrderList.entrySet()) {
                Long key = mapEntry.getKey();
                List<Long> orderList = mapEntry.getValue();
                if (groupToBatch == null) {
                    if (key == null) continue;
                    otherGroup.addAll(orderList);
                    continue;
                }
                if (groupToBatch.containsKey(key)) {
                    HashMap<Long, BigDecimal> groupBatch = new HashMap<Long, BigDecimal>(8);
                    BigDecimal value = groupToBatch.get(key);
                    BigDecimal batch = BigDecimal.valueOf(orderList.size()).divide(value, 10, 0);
                    groupBatch.put(key, batch);
                    groupBatchList.add(groupBatch);
                    if (batch.compareTo(maxBatch) > 0) {
                        otherBatch = otherBatch.add(maxBatch);
                        maxBatch = batch;
                        sortGroup.add(0, key);
                        continue;
                    }
                    sortGroup.add(key);
                    otherBatch = otherBatch.add(batch);
                    continue;
                }
                otherGroup.addAll(orderList);
                otherBatch = otherBatch.add(BigDecimal.valueOf(orderList.size()));
            }
            dateAndGroupBatch.put(date, groupBatchList);
            dateAndSortGroup.put(date, sortGroup);
            dateAndOtherGroup.put(date, otherGroup);
            if (maxBatch.compareTo(BigDecimal.ONE) < 0) {
                judgeIsNeedSortMap.put(date, false);
                continue;
            }
            if (maxBatch.subtract(BigDecimal.ONE).compareTo(otherBatch) <= 0) {
                judgeIsNeedSortMap.put(date, true);
                continue;
            }
            judgeIsNeedSortMap.put(date, false);
        }
        return judgeIsNeedSortMap;
    }

    private List<Object[]> getListObject(Map<Long, Long> orderToMatType, Map<Long, Date> orderAndDate, Map<Long, Long> entryToGroupMap) {
        ArrayList<Object[]> objectList = new ArrayList<Object[]>(orderAndDate.size());
        for (Map.Entry<Long, Date> mapEntry : orderAndDate.entrySet()) {
            Object[] objects = new Object[4];
            Date date = mapEntry.getValue();
            Long orderId = mapEntry.getKey();
            Long matTypeId = orderToMatType.get(orderId);
            Long group = entryToGroupMap.get(orderId);
            objects[0] = orderId;
            objects[1] = group;
            objects[2] = matTypeId;
            objects[3] = date;
            objectList.add(objects);
        }
        return objectList;
    }

    private Map<Long, Long> changeOrderGroupDefindToGroup(Map<Long, Long> orderToGroupDefindMap, Map<String, Object> capacityMessage, Map<Long, List<Long>> scheduAndorder, Map<Long, Long> entryToGroupMap) {
        HashMap<Long, Long> orderToGroupMap = new HashMap<Long, Long>(orderToGroupDefindMap.size());
        Map groupDefineToGroupMap = (Map)capacityMessage.get("groupDefineToGroupMap");
        for (Map.Entry<Long, Long> mapEntry : orderToGroupDefindMap.entrySet()) {
            Long groupDefine = mapEntry.getValue();
            Long orderId = mapEntry.getKey();
            Long group = (Long)groupDefineToGroupMap.get(groupDefine);
            orderToGroupMap.put(orderId, group);
            List<Long> entrys = scheduAndorder.get(orderId);
            for (Long id : entrys) {
                entryToGroupMap.put(id, group);
            }
        }
        return orderToGroupMap;
    }

    private Map<Long, Map<Long, BigDecimal>> getGroupBatch(DynamicObject plan) {
        DynamicObject[] load;
        HashMap<Long, Map<Long, BigDecimal>> workCenterToGroupBatch = new HashMap<Long, Map<Long, BigDecimal>>();
        HashMap<Long, Long> produceToWorkcenter = new HashMap<Long, Long>(8);
        DynamicObjectCollection workentry = plan.getDynamicObjectCollection("workentry");
        for (DynamicObject dynamicObject : workentry) {
            Long workcenterId = dynamicObject.getDynamicObject("workcenter").getLong("id");
            Long productionruleId = dynamicObject.getDynamicObject("productionrules").getLong("id");
            produceToWorkcenter.put(productionruleId, workcenterId);
        }
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"mps_productionrules", (String)"id,e_entryentity,e_entryentity.e_group,e_entryentity.e_qty,subentryentity.s_group,subentryentity.s_qty,subentryentity", (QFilter[])new QFilter[]{new QFilter("id", "in", produceToWorkcenter.keySet())})) {
            DynamicObjectCollection e_entryentitys = dynamicObject.getDynamicObjectCollection("e_entryentity");
            HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>(8);
            for (DynamicObject e_entryentity : e_entryentitys) {
                DynamicObjectCollection subentryentitys;
                Long e_group = e_entryentity.getDynamicObject("e_group").getLong("id");
                BigDecimal e_qty = e_entryentity.getBigDecimal("e_qty");
                if (e_qty.compareTo(BigDecimal.ZERO) > 0) {
                    map.put(e_group, e_qty);
                }
                if ((subentryentitys = e_entryentity.getDynamicObjectCollection("subentryentity")) == null || subentryentitys.size() == 0) continue;
                for (DynamicObject subentryentity : subentryentitys) {
                    DynamicObject s_group = subentryentity.getDynamicObject("s_group");
                    if (s_group == null) continue;
                    Long s_groupid = subentryentity.getDynamicObject("s_group").getLong("id");
                    BigDecimal s_qty = subentryentity.getBigDecimal("s_qty");
                    if (s_qty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    map.put(s_groupid, s_qty);
                }
            }
            if (map.size() == 0) continue;
            Long id = (Long)produceToWorkcenter.get(dynamicObject.getLong("id"));
            workCenterToGroupBatch.put(id, map);
        }
        return workCenterToGroupBatch;
    }

    private List<Map<String, Object>> getDetailDs(DataSet detailDs, List<Long> orderSeq, Map<Long, List<Long>> scheduAndorder, DataSet planDs) {
        Long id;
        ArrayList<Map<String, Object>> scheduList = new ArrayList<Map<String, Object>>(8);
        while (planDs.hasNext()) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            Row next = planDs.next();
            id = next.getLong("id");
            fieldMap.put("sourcebillid", id);
            fieldMap.put("materiel_code", next.get("materiel"));
            fieldMap.put("configure", next.get("configuredcode"));
            fieldMap.put("production_org", next.get("org"));
            fieldMap.put("plan_order_billno", next.get("billno"));
            fieldMap.put("date", next.get("sheduledate"));
            scheduList.add(fieldMap);
        }
        while (detailDs.hasNext()) {
            List<Long> order;
            Row next = detailDs.next();
            Long detailId = next.getLong("entryentity.id");
            id = next.getLong("id");
            orderSeq.add(detailId);
            if (scheduAndorder.containsKey(id)) {
                order = scheduAndorder.get(id);
                order.add(detailId);
                continue;
            }
            order = new ArrayList<Long>(8);
            order.add(detailId);
            scheduAndorder.put(id, order);
        }
        return scheduList;
    }
}

