/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.calcnode;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mps.common.util.MPSScheduleUtils;
import kd.mmc.mps.common.util.ReportQueryUtils;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.step.ICalcStep;

public class MPSStartWorkTimeGeneratorStep
implements ICalcStep {
    private Map<String, Integer> materialAdvPeriods = new HashMap<String, Integer>();
    private Integer planInStockTime = -1;
    public static final DBRoute SCM_Route = DBRoute.of((String)"scm");

    public String doWork(ExecutionEnv env, int stepIdx) {
        StringBuilder stringBuilder = new StringBuilder();
        this.mpsStartWorkTimeGenerator(env, stringBuilder);
        this.logCount(stepIdx, env.getLogEntityNumber(), env.getCtxId());
        return stringBuilder.toString();
    }

    public void mpsStartWorkTimeGenerator(ExecutionEnv env, StringBuilder stringBuilder) {
        String key = "mpscalc-" + env.getCtxId() + "mps_scheduleplan_pre_args";
        String logEntityNumber = env.getLogEntityNumber();
        DynamicObject runlog = BusinessDataServiceHelper.loadSingle((Object)env.getCtxId(), (String)logEntityNumber);
        Object planId = runlog.get("plangram");
        String paramStr = MPSScheduleUtils.getJedis().get(key);
        Object[] params = (Object[])JSON.parseObject((String)paramStr, Object[].class);
        List ja = (List)params[0];
        Long from = (Long)params[1];
        Long to = (Long)params[2];
        ORM orm = ORM.create();
        String sql = this.getUpdateSql();
        String fields0 = "id, billno, materiel, scheduleqty, sourcebilltypeid, sourcebillno, sourceentryseq, sheduledate, configuredcode";
        String fields1 = "id,entryentity.serialno,entryentity.sequence,entryentity.ontime,entryentity.instocktime,materiel,sheduledate,org,entryentity.id";
        DynamicObject plan = orm.queryOne("mps_proplanschdef", "id, workshift", new QFilter[]{new QFilter("id", "=", planId)});
        Map<Long, String> workcenterMessage = this.getWorkcenterMessage(ja);
        for (int i = 0; i < ja.size(); ++i) {
            Long workCenterId = MPSScheduleUtils.getLongValue(ja.get(i));
            HashMap<Long, BigDecimal> workshiftTime = new HashMap<Long, BigDecimal>(16);
            Map<Long, Object[]> planWorkCenter = this.getPlanWorkCenter(plan, workshiftTime);
            Object[] objects = planWorkCenter.get(workCenterId);
            if (objects == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3:%s\u4e0d\u5728\u8ba1\u5212\u65b9\u6848\u7684\u5de5\u4f5c\u4e2d\u5fc3\u8303\u56f4\uff0c\u4e0d\u4f1a\u8ba1\u7b97\u4e0a\u7ebf\u65f6\u95f4\u3002", (String)"MPSStartWorkTimeGeneratorStep_1", (String)"mmc-mps-mservice-calcnode", (Object[])new Object[0]), workcenterMessage.get(workCenterId));
                stringBuilder.append(msg);
                return;
            }
            Object object = objects[0];
            BigDecimal timespanByHour = (BigDecimal)workshiftTime.get(object);
            if (timespanByHour == null) {
                return;
            }
            DynamicObject shift = orm.queryOne("mpdm_classsystem", "id, classsystemtime, entryentity.id, entryentity.workstarttime, entryentity.workendtime", new QFilter[]{new QFilter("id", "=", object)});
            QFilter[] filters = MPSScheduleUtils.getQFilter((Long)workCenterId, (Long)from, (Long)to);
            ArrayList<Object[]> updates = new ArrayList<Object[]>(5000);
            try {
                DataSet planDs = this.getSchedulePlan(orm, fields0, filters);
                Map daySlots = MPSScheduleUtils.parseTimeSlots((DataSet)planDs.copy(), (BigDecimal)timespanByHour, (DynamicObjectCollection)shift.getDynamicObjectCollection("entryentity"));
                QFilter groupFilter = MPSScheduleUtils.parseDetailFilters((DataSet)planDs.copy());
                groupFilter.and("entryentity.sequence", "!=", (Object)0);
                DataSet detailDs = this.getScheduleEntrydetail(orm, fields1, groupFilter);
                this.dayCalc(sql, daySlots, detailDs, updates);
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
            if (updates.size() > 0) {
                this.executeData(sql, updates);
            }
            updates.clear();
        }
    }

    private Map<Long, String> getWorkcenterMessage(List<?> ja) {
        HashMap<Long, String> workcenterMessage = new HashMap<Long, String>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"mpdm_workcentre", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", ja)});
        for (DynamicObject dynamicObject : query) {
            workcenterMessage.put(dynamicObject.getLong("id"), dynamicObject.getString("number"));
        }
        return workcenterMessage;
    }

    private Map<Long, Object[]> getPlanWorkCenter(DynamicObject queryplan, Map<Long, BigDecimal> workshiftTime) {
        StringBuilder tipMessage = new StringBuilder();
        Map planWorkCenter = ReportQueryUtils.getPlanWorkCenter((DynamicObject)queryplan, workshiftTime, (StringBuilder)tipMessage);
        return planWorkCenter;
    }

    private void executeData(String sql, List<Object[]> updates) {
        DB.executeBatch((DBRoute)SCM_Route, (String)sql, updates);
    }

    private DataSet getScheduleEntrydetail(ORM orm, String fields1, QFilter groupFilter) {
        DataSet dataSet = orm.queryDataSet("mpscalc", "mps_scheduleplan", fields1, new QFilter[]{groupFilter}, "sheduledate desc,entryentity.sequence asc");
        return dataSet;
    }

    private DataSet getSchedulePlan(ORM orm, String fields0, QFilter[] filters) {
        DataSet planDs = orm.queryDataSet("mpscalc", "mps_scheduleplan", fields0, filters, "sheduledate desc, id asc");
        return planDs;
    }

    protected void dayCalc(String sql, Map<Long, List<Object[]>> daySlots, DataSet detailDs, List<Object[]> updates) {
        ArrayList<Long> alreadyExit = new ArrayList<Long>(16);
        TreeMap<Long, List<Object[]>> rsMappingMap = new TreeMap<Long, List<Object[]>>(daySlots);
        for (Map.Entry entry : rsMappingMap.entrySet()) {
            DataSet copy = detailDs.copy();
            DataSet dataSet = copy.orderBy(new String[]{"sheduledate asc"});
            Iterator daySlotIter = ((List)entry.getValue()).iterator();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                this.loadMaterialAdvPeriod(row.getLong("materiel"), row.getLong("org"));
                Long detailId = row.getLong("entryentity.id");
                if (!daySlotIter.hasNext() || alreadyExit.contains(detailId)) continue;
                Object[] settings = (Object[])daySlotIter.next();
                alreadyExit.add(detailId);
                updates.add(this.wrapUpdateParams(settings, detailId));
                if (updates.size() != 5000) continue;
                this.executeData(sql, updates);
                updates.clear();
            }
        }
    }

    private void loadMaterialAdvPeriod(Long materialId, Long productOrgUnitId) {
        String key = String.format("%s - %s", materialId, productOrgUnitId);
        this.planInStockTime = this.materialAdvPeriods.get(key);
        if (this.planInStockTime == null) {
            Row row;
            QFilter mFilter = new QFilter("masterid", "=", (Object)materialId);
            QFilter qFilterUseOrg = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_materialplan", (Long)productOrgUnitId);
            QFilter dataFilter = new QFilter("status", "=", (Object)"C");
            QFilter[] filters = new QFilter[]{dataFilter, mFilter, qFilterUseOrg};
            try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), "mpdm_materialplan", "id, fixedleadtime", filters, "id asc");){
                if (ds.hasNext()) {
                    row = ds.next();
                    this.planInStockTime = row.getInteger("fixedleadtime");
                }
            }
            if (this.planInStockTime == null) {
                ds = ORM.create().queryDataSet(this.getClass().getName(), "msplan_invlevel", "id, entryentity.bd_material, entryentity.leadtime", filters, "id asc");
                var9_9 = null;
                try {
                    if (ds.hasNext()) {
                        row = ds.next();
                        this.planInStockTime = row.getInteger("fixedleadtime");
                    }
                }
                catch (Throwable throwable) {
                    var9_9 = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (var9_9 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                var9_9.addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
            if (this.planInStockTime == null) {
                this.planInStockTime = 0;
            }
            this.materialAdvPeriods.put(key, this.planInStockTime);
        }
    }

    protected String getUpdateSql() {
        String sql = "update t_mps_schplanentry set fontime = ?, finstocktime = ? where FEntryID = ?";
        return sql;
    }

    protected Object[] wrapUpdateParams(Object[] settings, Long detailId) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis((Long)settings[0]);
        cal.add(6, this.planInStockTime);
        return new Object[]{new Timestamp((Long)settings[0]), new Timestamp(cal.getTimeInMillis()), detailId};
    }

    private void logCount(int stepIdx, String logEntityNumber, Long logid) {
        DynamicObject runlog = BusinessDataServiceHelper.loadSingle((Object)logid, (String)logEntityNumber);
        DynamicObjectCollection entryentity = runlog.getDynamicObjectCollection("entryentity");
        List list = entryentity.stream().filter(o -> String.valueOf(stepIdx).equals(o.getString("entrystepseq"))).collect(Collectors.toList());
        if (list.size() > 0) {
            ((DynamicObject)list.get(0)).set("entryprocessdata", (Object)100);
            SaveServiceHelper.update((DynamicObject)runlog);
        }
    }
}

