/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.common.consts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.mrp.common.consts.InitSQLConst;
import kd.mmc.mrp.common.util.MulLangTableDataInitUtil;

public class InitDataConst {
    public static final String[] insertFields = new String[]{"fid", "f_bill_obj_id", "f_r_sale_org", "f_bill_no", "f_bill_id", "f_r_biz_date", "f_billentry_id", "f_billentry_seq", "f_bal_obj_id", "f_s_org", "f_s_billnum", "f_bal_id", "fbalentryid", "f_s_entryseq", "f_s_materiel", "f_qty", "f_s_unit", "f_s_baseunit", "f_base_qty", "f_create_date", "fexpiredate", "fisweak", "f_creater_id", "freservesource", "f_ori_qty", "fchange_type"};
    public static final String[] selectFields = new String[]{"id", "bill_obj", "r_sale_org", "bill_no", "bill_id", "r_biz_date", "billentry_id", "billentry_seq", "bal_obj", "s_org", "s_billnum", "bal_id", "bal_entryid", "s_entryseq", "s_materiel", "qty", "s_unit", "s_baseunit", "base_qty", "create_date", "expiredate", "isweak", "creater", "reservesource"};
    public static final String[] cfgSelectFields = new String[]{"id", "group", "billobject", "billoperation", "filter_value", "filter_value_tag", "description", "enable", "creator", "createtime", "modifier", "modifytime"};
    public static final String[] cfgInsertFields = new String[]{"fid", "fstatus", "fresourceid", "fgroupid", "fbillobject", "fbilloperation", "ffiltervalue", "ffiltervalue_tag", "fdescription", "fenable", "fcreatorid", "fcreatetime", "fmodifierid", "fmodifytime", "fresourcetype"};
    public static final String[] cfgEntryFields = new String[]{"fid", "fentryid", "fseq", "foperation"};

    public static boolean isEn_US() {
        return StringUtils.equalsIgnoreCase((CharSequence)ResManager.getLanguage(), (CharSequence)"en_US");
    }

    public Map<String, Map<String, List<Object[]>>> getSql(String entity, Long orgId, String defaultctrlstrategy, Map<String, String> cellsdatas, Map<String, String> xmls, String appId) {
        switch (entity) {
            case "mrp_algoregister": {
                return this.getAlgoSql2Param(orgId, defaultctrlstrategy, appId);
            }
            case "mrp_businessplan": {
                return this.getBizSql2Param(orgId, defaultctrlstrategy, cellsdatas, xmls, appId);
            }
            case "mrp_calplanconfig": {
                return this.getCalcSql2Param(orgId, defaultctrlstrategy, appId);
            }
            case "mrp_billfieldtransfer": {
                return this.getTrsfSql2Param(orgId, defaultctrlstrategy, appId);
            }
            case "mrp_resourceregister_cf": {
                return this.getResSql2Param(orgId, defaultctrlstrategy, appId);
            }
            case "mrp_grossdemand_define": {
                return this.getGrossSql2Param(orgId, defaultctrlstrategy);
            }
            case "mrp_stocksupply_policy": {
                return this.getStocksupplySql2Param(orgId, defaultctrlstrategy);
            }
            case "mrp_definitionsupply": {
                return this.getDefSupplySql2Param(orgId, defaultctrlstrategy);
            }
            case "mrp_planprogram": {
                return this.getProgramSql2Param(orgId, defaultctrlstrategy, appId);
            }
        }
        return new HashMap<String, Map<String, List<Object[]>>>(0);
    }

    public Map<String, Long> getDataIds(String entity) {
        switch (entity) {
            case "mrp_algoregister": {
                return this.getAlgoIds();
            }
            case "mrp_businessplan": {
                return this.getBizIds();
            }
            case "mrp_calplanconfig": {
                return this.getCalcIds();
            }
            case "mrp_billfieldtransfer": {
                return this.getTrsfIds();
            }
            case "mrp_resourceregister_cf": {
                return this.getResIds();
            }
            case "mrp_grossdemand_define": {
                return this.getGrossIds();
            }
            case "mrp_stocksupply_policy": {
                return this.getStocksupplyIds();
            }
            case "mrp_definitionsupply": {
                return this.getDefSupplyIds();
            }
            case "mrp_planprogram": {
                return this.getPlanProgramIds();
            }
        }
        return new HashMap<String, Long>(0);
    }

    private Map<String, Long> getPlanProgramIds() {
        HashMap<String, Long> planProgramIds = new HashMap<String, Long>(1);
        planProgramIds.put("900", 1992172261439797248L);
        return planProgramIds;
    }

    private Map<String, Long> getDefSupplyIds() {
        HashMap<String, Long> defSupplyId = new HashMap<String, Long>(1);
        defSupplyId.put("70", 1992168065021867008L);
        return defSupplyId;
    }

    private Map<String, Long> getStocksupplyIds() {
        HashMap<String, Long> stocksupplyIds = new HashMap<String, Long>(1);
        stocksupplyIds.put("MRP-001", 1992165739917833216L);
        return stocksupplyIds;
    }

    protected Map<String, Long> getAlgoIds() {
        HashMap<String, Long> algoIds = new HashMap<String, Long>(10);
        algoIds.put("BZSF-170", 1296361343208853504L);
        algoIds.put("BZSF-180", 1296361927081129984L);
        algoIds.put("BZSF-190", 1377382241222525952L);
        algoIds.put("BZSF-160", 1291129337680022528L);
        algoIds.put("BZSF-112", 1239701772017172480L);
        algoIds.put("BZSF-111", 1238288764904670208L);
        algoIds.put("BZSF-115", 1133260278583251968L);
        algoIds.put("BZSF-120", 1018057286788107264L);
        algoIds.put("BZSF-030", 1018053723433257984L);
        algoIds.put("BZSF-110", 1077499953846184960L);
        algoIds.put("BZSF-101", 1448588572364915712L);
        algoIds.put("BZSF-100", 1011391041783215104L);
        algoIds.put("BZSF-091", 1448644360173277184L);
        algoIds.put("BZSF-090", 980327654114769920L);
        algoIds.put("BZSF-080", 980327654106382336L);
        algoIds.put("BZSF-070", 980327654123159552L);
        algoIds.put("BZSF-060", 980327654089604096L);
        algoIds.put("BZSF-050", 980327654139935744L);
        algoIds.put("BZSF-040", 980327654106381312L);
        algoIds.put("BZSF-020", 980327654131548160L);
        algoIds.put("BZSF-011", 1464547947545916416L);
        algoIds.put("BZSF-010", 980327654123158528L);
        algoIds.put("BZSF-102", 1488279446984092672L);
        algoIds.put("BZSF-103", 1514051994782864384L);
        algoIds.put("BZSF-210", 1447072981703504896L);
        algoIds.put("BZSF-211", 1782016601755763712L);
        algoIds.put("BZSF-220", 1447072305330041856L);
        algoIds.put("BZSF-230", 1447072305338431488L);
        algoIds.put("BZSF-240", 1447072305313265664L);
        algoIds.put("BZSF-121", 1540012575394127872L);
        return algoIds;
    }

    protected Map<String, Long> getBizIds() {
        HashMap<String, Long> bizIds = new HashMap<String, Long>(4);
        bizIds.put("YWFA-Orignal", 1077500332524722176L);
        bizIds.put("YWFA-SP", 1448644860453082112L);
        bizIds.put("YWFA-SelectPlan", 1447075569169642496L);
        bizIds.put("YWFA-SelectMaterial", 1526908077910095872L);
        return bizIds;
    }

    protected Map<String, Long> getCalcIds() {
        HashMap<String, Long> calcIds = new HashMap<String, Long>(4);
        calcIds.put("JSFA-Orignal", 1077500764504482816L);
        calcIds.put("JSFA-SP", 1468861709467813888L);
        calcIds.put("JSFA-SelectPlan", 1446979616806809600L);
        calcIds.put("JSFA-SelectMaterial", 1526908799791758336L);
        return calcIds;
    }

    protected Map<String, Long> getTrsfIds() {
        HashMap<String, Long> trsfIds = new HashMap<String, Long>(14);
        trsfIds.put("YS-BOM-bomregist", 962925544213630976L);
        trsfIds.put("YS-REQ-001", 1019614409087004672L);
        trsfIds.put("YS-REQ-002", 1019614408164257792L);
        trsfIds.put("YS-REQ-003", 1019614403357585408L);
        trsfIds.put("YS-REQ-004", 1005802947428222976L);
        trsfIds.put("YS-REQ-005", 1067478024938605568L);
        trsfIds.put("YS-REQ-006", 973715393191398400L);
        trsfIds.put("YS-REQ-SUP", 1078041234464837632L);
        trsfIds.put("YS-REQ-SUP_SINGLE_ORG", 1977651619982068736L);
        trsfIds.put("YS-REQ-008", 1247202796302814208L);
        trsfIds.put("YS-SUP-006", 1245512022473325568L);
        trsfIds.put("YS-Require-BOM", 962938205651391488L);
        trsfIds.put("YS-SUP-001", 996334374087561216L);
        trsfIds.put("YS-SUP-002", 1019614409246389248L);
        trsfIds.put("YS-SUP-003", 1019614408390751232L);
        trsfIds.put("YS-SUP-004", 1019614409137337344L);
        trsfIds.put("YS-SUP-005", 976007551319598080L);
        trsfIds.put("YS-REQ-007", 1181114675790629888L);
        trsfIds.put("YS-REQ-Planorder", 1228983485314631680L);
        trsfIds.put("BOM-COP-bomregist", 1281137808701963264L);
        trsfIds.put("YS-SUP-007", 1281137811671530496L);
        trsfIds.put("YS-REQ-009", 1313064178679872512L);
        trsfIds.put("YS-SUP-008", 1313081634475521024L);
        trsfIds.put("YS-REQ-SPPlanorder", 1448552481838612480L);
        trsfIds.put("YS-SUP-009", 1448556155503656960L);
        trsfIds.put("YS-SUP-010", 1465244867050406912L);
        trsfIds.put("SP-MN-REQ", 1463618556829632512L);
        trsfIds.put("YS-REQ-011", 1393295046425479168L);
        trsfIds.put("YS-REQ-012", 1468731981389892608L);
        return trsfIds;
    }

    protected Map<String, Long> getResIds() {
        HashMap<String, Long> resIds = new HashMap<String, Long>(3);
        resIds.put("bomregist", 962843094548526080L);
        resIds.put("supplyresource", 962960690602102784L);
        resIds.put("requireresource", 962938347762799616L);
        resIds.put("SP-requireresource", 1448562494908941312L);
        resIds.put("SP-supplyresource", 1448564628190675968L);
        return resIds;
    }

    protected Map<String, Long> getGrossIds() {
        HashMap<String, Long> grossSqlIds = new HashMap<String, Long>(1);
        grossSqlIds.put("MXQDY-Orignal", 1215218702123830272L);
        return grossSqlIds;
    }

    protected Map<String, Map<String, List<Object[]>>> getAlgoSql2Param(Long orgId, String defaultctrlstrategy, String appId) {
        HashMap<String, Map<String, List<Object[]>>> algoSql = new HashMap<String, Map<String, List<Object[]>>>(16);
        AlgoParam algoParam = new AlgoParam(orgId, defaultctrlstrategy, 980327654123158528L, "1M=G=/0VMBP3", "BZSF-010", ResManager.getLocaleString((String)"\u521d\u59cb\u5316\u8ba1\u5212\u65e5\u5386", (String)"InitDataConst_0", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMCalculateDateRange", appId);
        algoSql.put("BZSF-010", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 980327654131548160L, "1M=G=2MLJD7W", "BZSF-020", ResManager.getLocaleString((String)"\u6e05\u7406\u5386\u53f2\u6570\u636e", (String)"InitDataConst_1", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMClearPlanOrder", appId);
        algoSql.put("BZSF-020", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1018053723433257984L, "1O5XPIVMA0BP", "BZSF-030", ResManager.getLocaleString((String)"\u540c\u6b65\u7269\u6599\u8ba1\u5212\u4fe1\u606f", (String)"InitDataConst_2", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMaterialIPlanSync", appId);
        algoSql.put("BZSF-030", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 980327654106381312L, "1M=G=2MLJD7X", "BZSF-040", ResManager.getLocaleString((String)"\u786e\u5b9a\u8ba1\u7b97\u7269\u6599\u8303\u56f4", (String)"InitDataConst_3", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPGetMaterialData", appId);
        algoSql.put("BZSF-040", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 980327654139935744L, "1M=G=2MLJD7Y", "BZSF-050", ResManager.getLocaleString((String)"\u521d\u59cb\u5316BOM\u7ed3\u6784\u6811", (String)"InitDataConst_4", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMGetBOMData", appId);
        algoSql.put("BZSF-050", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 980327654089604096L, "1M=G=2MLJD7Z", "BZSF-060", ResManager.getLocaleString((String)"\u83b7\u53d6\u9884\u5b9a\u4e49\u9700\u6c42\u6570\u636e", (String)"InitDataConst_5", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMGetRequirementData", appId);
        algoSql.put("BZSF-060", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 980327654123159552L, "1M=G=2MLJD8+", "BZSF-070", ResManager.getLocaleString((String)"\u83b7\u53d6\u9884\u5b9a\u4e49\u4f9b\u5e94\u6570\u636e", (String)"InitDataConst_6", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMGetSupplymentData", appId);
        algoSql.put("BZSF-070", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 980327654106382336L, "1M=G=2MLJD8/", "BZSF-080", ResManager.getLocaleString((String)"\u51c0\u9700\u6c42\u8ba1\u7b97", (String)"InitDataConst_7", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMCalcNetDemandData", appId);
        algoSql.put("BZSF-080", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 980327654114769920L, "1M=G=2MLJD80", "BZSF-090", ResManager.getLocaleString((String)"\u4fdd\u5b58\u8ba1\u7b97\u8fc7\u7a0b\u6570\u636e", (String)"InitDataConst_8", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMSaveProcessDatas", appId);
        algoSql.put("BZSF-090", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1011391041783215104L, "1M=G=2MLJD81", "BZSF-100", ResManager.getLocaleString((String)"\u4fdd\u5b58\u8ba1\u5212\u8ba2\u5355", (String)"InitDataConst_9", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMSavePlanOrderDatas", appId);
        algoSql.put("BZSF-100", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1077499953846184960L, "1M=G=2MLJD82", "BZSF-110", ResManager.getLocaleString((String)"\u751f\u6210\u6267\u884c\u7ed3\u679c\u8868", (String)"InitDataConst_10", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMCreatePegInfo", appId);
        algoSql.put("BZSF-110", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1018057286788107264L, "1O5XPJE6JC0O", "BZSF-120", ResManager.getLocaleString((String)"\u5220\u9664\u7269\u6599\u8ba1\u5212\u4fe1\u606f", (String)"InitDataConst_11", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMaterialPlanDel", appId);
        algoSql.put("BZSF-120", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1133260278583251968L, "1J6AT8W=42X9", "BZSF-115", ResManager.getLocaleString((String)"\u751f\u6210\u6bdb\u9700\u6c42\u6765\u6e90", (String)"InitDataConst_12", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMGetGrossdemandSource", appId);
        algoSql.put("BZSF-115", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1238288764904670208L, "1W2HY0KC1G4/", "BZSF-111", ResManager.getLocaleString((String)"\u751f\u6210\u8c03\u6574\u5efa\u8bae", (String)"InitDataConst_13", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.adjust.MRPEdcAdjustCalStep", appId);
        algoSql.put("BZSF-111", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1239701772017172480L, "1W99YL9D4Y/V", "BZSF-112", ResManager.getLocaleString((String)"\u751f\u6210\u91c7\u8d2d\u9884\u6d4b", (String)"InitDataConst_14", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPSavePurForecast", appId);
        algoSql.put("BZSF-112", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1291129337680022528L, "20KNZD9=R2O/", "BZSF-160", ResManager.getLocaleString((String)"\u4fdd\u5b58\u5907\u6599\u9884\u6d4b", (String)"InitDataConst_15", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPSaveStockForecast", appId);
        algoSql.put("BZSF-160", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1296361343208853504L, "217QIY68=CGW", "BZSF-170", ResManager.getLocaleString((String)"\u751f\u6210\u4ea4\u5355\u8ba1\u5212", (String)"InitDataConst_16", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPSaveDocumentsPlan", appId);
        algoSql.put("BZSF-170", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1296361927081129984L, "217QN5YIASZ=", "BZSF-180", ResManager.getLocaleString((String)"\u751f\u6210\u751f\u4ea7\u9884\u6d4b", (String)"InitDataConst_17", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPSaveProductionForecast", appId);
        algoSql.put("BZSF-180", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1377382241222525952L, "2A5WYU1NLQLW", "BZSF-190", ResManager.getLocaleString((String)"\u6295\u653e\u9884\u7f6e\u53cd\u5199\u63d2\u4ef6", (String)"InitDataConst_18", (String)"mmc-mrp-common"), "2", "kd.mpscmm.msplan.mservice.service.mrp.algoregister.DropDataCtrlService", ResManager.getLocaleString((String)"\u7528\u4e8e\u6295\u653e\u53cd\u5199\u63d2\u4ef6\uff0c\u53ef\u652f\u6301\u6269\u5c55", (String)"InitDataConst_19", (String)"mmc-mrp-common"), appId);
        algoSql.put("BZSF-190", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1464547947545916416L, "2KWHGUJCZ7/O", "BZSF-011", ResManager.getLocaleString((String)"\u83b7\u53d6\u6a21\u62df\u8ba1\u5212\u9009\u5355\u9700\u6c42\u6e05\u5355", (String)"InitDataConst_20", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPGetSimulationRequireList", appId);
        algoSql.put("BZSF-011", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1448588572364915712L, "2IY0J4H49HPG", "BZSF-101", ResManager.getLocaleString((String)"\u4fdd\u5b58\u6a21\u62df\u8ba1\u5212\u8ba2\u5355", (String)"InitDataConst_21", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMSaveSimulateOrderDatas", appId);
        algoSql.put("BZSF-101", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1448644360173277184L, "2IY=ZNZFVKBM", "BZSF-091", ResManager.getLocaleString((String)"\u4fdd\u5b58\u6a21\u62df\u8ba1\u7b97\u8fc7\u7a0b\u6570\u636e", (String)"InitDataConst_22", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMSaveSimulateDatas", appId);
        algoSql.put("BZSF-091", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1488279446984092672L, "2NT6LVR2D514", "BZSF-102", ResManager.getLocaleString((String)"\u8ba1\u7b97\u6700\u957f\u8def\u5f84", (String)"InitDataConst_501", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMCalcLongestPath", appId);
        algoSql.put("BZSF-102", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1514051994782864384L, "2QZO3+8B8LQ0", "BZSF-103", ResManager.getLocaleString((String)"\u53ef\u4ea4\u6570\u91cf\u8ba1\u7b97", (String)"InitDataConst_515", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMCalcInventoryQty", appId);
        algoSql.put("BZSF-103", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1447072981703504896L, "2IQSC17L1GG3", "BZSF-210", ResManager.getLocaleString((String)"\u83b7\u53d6\u9009\u5355\u9700\u6c42\u6e05\u5355", (String)"InitDataConst_509", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPGetSelectBillRequireList", appId);
        algoSql.put("BZSF-210", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1447072305330041856L, "2IQS888OT3GA", "BZSF-220", ResManager.getLocaleString((String)"\u91ca\u653e\u7269\u6599\u8303\u56f4\u5185\u7684\u9884\u7559\u5173\u7cfb", (String)"InitDataConst_510", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPReleaseReserveRecord", appId);
        algoSql.put("BZSF-220", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1447072305338431488L, "2IQS888OT3GC", "BZSF-230", ResManager.getLocaleString((String)"\u83b7\u53d6\u7269\u6599\u8303\u56f4\u5185\u7684\u9884\u7559\u5173\u7cfb", (String)"InitDataConst_511", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPGetReserveRecordData", appId);
        algoSql.put("BZSF-230", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1782016601755763712L, "3KWG4H62JUTM", "BZSF-211", ResManager.getLocaleString((String)"\u83b7\u53d6\u9700\u6c42\u914d\u7f6e\u53f7", (String)"InitDataConst_632", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPGetRequireConfigList", appId);
        algoSql.put("BZSF-211", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1447072305313265664L, "2IQS888OT3G9", "BZSF-240", ResManager.getLocaleString((String)"\u4fdd\u5b58\u9884\u7559\u5173\u7cfb\u8bb0\u5f55", (String)"InitDataConst_512", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPSaveReserveRelationDatas", appId);
        algoSql.put("BZSF-240", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, 1540012575394127872L, "2U50Q=8=HF/V", "BZSF-121", ResManager.getLocaleString((String)"\u81ea\u52a8\u5ba1\u6838\u6295\u653e\u8ba1\u5212\u8ba2\u5355", (String)"InitDataConst_518", (String)"mmc-mrp-common"), "1", "kd.mmc.mrp.controlnode.framework.step.MRPMAutoAuditPlanOrderDatas", appId);
        algoSql.put("BZSF-121", InitDataConst.getAlgoParam(algoParam));
        return algoSql;
    }

    private static String getRealAppId(String appId) {
        String result = "0";
        if ("mrp".equals(appId)) {
            return result;
        }
        result = "msplan".equals(appId) || "msmpmm".equals(appId) ? "1" : appId;
        return result;
    }

    protected static Map<String, List<Object[]>> getAlgoParam(AlgoParam algoParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object[]>> map = new LinkedHashMap<String, List<Object[]>>(InitSQLConst.algoSql.length);
        for (int i = 0; i < InitSQLConst.algoSql.length; ++i) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(1);
            switch (i) {
                case 0: 
                case 1: {
                    Object[] p = new Object[]{algoParam.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{algoParam.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{algoParam.id, "V1.0", algoParam.orgId, algoParam.id, algoParam.orgId, "C", algoParam.defaultctrlstrategy, algoParam.number, algoParam.classPath, nowTime, userId, "1", nowTime, userId, algoParam.type, MulLangTableDataInitUtil.getDefaultLocaleValue(algoParam.remark), InitDataConst.getRealAppId(algoParam.appId)};
                    params.add(p);
                    break;
                }
                case 4: {
                    params.addAll(MulLangTableDataInitUtil.getInsertMulLangTableParams(algoParam.id, algoParam.name, algoParam.remark));
                    break;
                }
            }
            map.put(InitSQLConst.algoSql[i], params);
        }
        return map;
    }

    protected Map<String, Map<String, List<Object[]>>> getBizSql2Param(Long orgId, String defaultctrlstrategy, Map<String, String> cellsdatas, Map<String, String> xmls, String appId) {
        HashMap<String, Map<String, List<Object[]>>> bizSql = new HashMap<String, Map<String, List<Object[]>>>(16);
        ArrayList<BizEntryParam> bizEntrys = new ArrayList<BizEntryParam>(16);
        bizEntrys.add(new BizEntryParam(1157992612003612672L, 1, 980327654106382336L));
        bizEntrys.add(new BizEntryParam(1157992612003612673L, 2, 980327654089604096L));
        bizEntrys.add(new BizEntryParam(1157992612003612674L, 3, 980327654123159552L));
        bizEntrys.add(new BizEntryParam(1157992612003612675L, 4, 980327654131548160L));
        bizEntrys.add(new BizEntryParam(1157992612003612676L, 5, 980327654139935744L));
        bizEntrys.add(new BizEntryParam(1157992612003612677L, 6, 1011391041783215104L));
        bizEntrys.add(new BizEntryParam(1157992612003612678L, 7, 980327654106381312L));
        bizEntrys.add(new BizEntryParam(1157992612003612679L, 8, 980327654114769920L));
        bizEntrys.add(new BizEntryParam(1157992612003612680L, 9, 1077499953846184960L));
        bizEntrys.add(new BizEntryParam(1157992612003612681L, 10, 980327654123158528L));
        bizEntrys.add(new BizEntryParam(1173877693956269058L, 11, 1018057286788107264L));
        bizEntrys.add(new BizEntryParam(1173877693956269064L, 12, 1018053723433257984L));
        bizEntrys.add(new BizEntryParam(1216673752444706816L, 13, 1133260278583251968L));
        bizEntrys.add(new BizEntryParam(1242000049752290308L, 14, 1238288764904670208L));
        bizEntrys.add(new BizEntryParam(1242000049752290311L, 15, 1239701772017172480L));
        bizEntrys.add(new BizEntryParam(1301314920830374927L, 16, 1540012575394127872L));
        BizParam bizParam = new BizParam(orgId, defaultctrlstrategy, 1077500332524722176L, "1M=X21/2SDA=", "YWFA-Orignal", ResManager.getLocaleString((String)"\u4e1a\u52a1\u65b9\u6848-\u5168\u5c40\u8ba1\u5212", (String)"InitDataConst_23", (String)"mmc-mrp-common"), cellsdatas.getOrDefault("YWFA-Orignal", ""), xmls.getOrDefault("YWFA-Orignal", ""), bizEntrys, appId);
        bizSql.put("YWFA-Orignal", InitDataConst.getBizParam(bizParam));
        bizEntrys = new ArrayList(16);
        bizEntrys.add(new BizEntryParam(1489233999397165056L, 1, 980327654106382336L));
        bizEntrys.add(new BizEntryParam(1489233999397165057L, 2, 980327654089604096L));
        bizEntrys.add(new BizEntryParam(1489233999397165058L, 3, 1018057286788107264L));
        bizEntrys.add(new BizEntryParam(1489233999397165059L, 4, 980327654123159552L));
        bizEntrys.add(new BizEntryParam(1489233999397165060L, 5, 1448588572364915712L));
        bizEntrys.add(new BizEntryParam(1489233999397165061L, 6, 980327654106381312L));
        bizEntrys.add(new BizEntryParam(1489233999397165062L, 7, 1018053723433257984L));
        bizEntrys.add(new BizEntryParam(1489233999397165063L, 8, 1488279446984092672L));
        bizEntrys.add(new BizEntryParam(1489233999397165064L, 9, 1448644360173277184L));
        bizEntrys.add(new BizEntryParam(1489233999397165065L, 10, 980327654139935744L));
        bizEntrys.add(new BizEntryParam(1489233999397165066L, 11, 980327654123158528L));
        bizParam = new BizParam(orgId, defaultctrlstrategy, 1448644860453082112L, "2IYA1A4S72RS", "YWFA-SP", ResManager.getLocaleString((String)"\u4e1a\u52a1\u65b9\u6848-\u6a21\u62df\u8ba1\u5212", (String)"InitDataConst_507", (String)"mmc-mrp-common"), cellsdatas.getOrDefault("YWFA-SP", ""), xmls.getOrDefault("YWFA-SP", ""), bizEntrys, appId);
        bizSql.put("YWFA-SP", InitDataConst.getBizParam(bizParam));
        bizEntrys = new ArrayList(16);
        bizEntrys.add(new BizEntryParam(1494792761390425088L, 1, 980327654106382336L));
        bizEntrys.add(new BizEntryParam(1494792761390425089L, 2, 980327654089604096L));
        bizEntrys.add(new BizEntryParam(1494792761390425090L, 3, 1447072305338431488L));
        bizEntrys.add(new BizEntryParam(1494792761390425091L, 4, 980327654123159552L));
        bizEntrys.add(new BizEntryParam(1494792761390425092L, 5, 980327654131548160L));
        bizEntrys.add(new BizEntryParam(1494792761390425093L, 6, 1447072305313265664L));
        bizEntrys.add(new BizEntryParam(1494792761390425094L, 7, 980327654106381312L));
        bizEntrys.add(new BizEntryParam(1494792761390425095L, 8, 1011391041783215104L));
        bizEntrys.add(new BizEntryParam(1494792761390425096L, 9, 980327654114769920L));
        bizEntrys.add(new BizEntryParam(1494792761390425097L, 10, 980327654139935744L));
        bizEntrys.add(new BizEntryParam(1494792761390425098L, 11, 1447072981703504896L));
        bizEntrys.add(new BizEntryParam(1494792761390425099L, 12, 1447072305330041856L));
        bizEntrys.add(new BizEntryParam(1494792761390425100L, 13, 980327654123158528L));
        bizEntrys.add(new BizEntryParam(1494792761390425101L, 14, 1540012575394127872L));
        bizParam = new BizParam(orgId, defaultctrlstrategy, 1447075569169642496L, "2IQSUXK4Q9YN", "YWFA-SelectPlan", ResManager.getLocaleString((String)"\u4e1a\u52a1\u65b9\u6848-\u9009\u5355\u8ba1\u5212", (String)"InitDataConst_513", (String)"mmc-mrp-common"), cellsdatas.getOrDefault("YWFA-SelectPlan", ""), xmls.getOrDefault("YWFA-SelectPlan", ""), bizEntrys, appId);
        bizSql.put("YWFA-SelectPlan", InitDataConst.getBizParam(bizParam));
        bizEntrys = new ArrayList(16);
        bizEntrys.add(new BizEntryParam(1526908166971947008L, 1, 980327654106382336L));
        bizEntrys.add(new BizEntryParam(1526908166971947009L, 2, 980327654089604096L));
        bizEntrys.add(new BizEntryParam(1526908166971947010L, 3, 1447072305338431488L));
        bizEntrys.add(new BizEntryParam(1526908166971947011L, 4, 980327654123159552L));
        bizEntrys.add(new BizEntryParam(1526908166971947012L, 5, 980327654131548160L));
        bizEntrys.add(new BizEntryParam(1526908166971947013L, 6, 1447072305313265664L));
        bizEntrys.add(new BizEntryParam(1526908166971947014L, 7, 980327654106381312L));
        bizEntrys.add(new BizEntryParam(1526908166971947015L, 8, 1011391041783215104L));
        bizEntrys.add(new BizEntryParam(1526908166971947016L, 9, 980327654114769920L));
        bizEntrys.add(new BizEntryParam(1526908166971947017L, 10, 980327654139935744L));
        bizEntrys.add(new BizEntryParam(1526908166971947018L, 11, 1447072305330041856L));
        bizEntrys.add(new BizEntryParam(1526908166971947019L, 12, 980327654123158528L));
        bizEntrys.add(new BizEntryParam(1526908166971947020L, 13, 1540012575394127872L));
        bizEntrys.add(new BizEntryParam(1782020171880220675L, 14, 1782016601755763712L));
        bizParam = new BizParam(orgId, defaultctrlstrategy, 1526908077910095872L, "2SJ970O58WRD", "YWFA-SelectMaterial", ResManager.getLocaleString((String)"\u4e1a\u52a1\u65b9\u6848-\u9009\u6599\u8ba1\u5212", (String)"InitDataConst_516", (String)"mmc-mrp-common"), cellsdatas.getOrDefault("YWFA-SelectMaterial", ""), xmls.getOrDefault("YWFA-SelectMaterial", ""), bizEntrys, appId);
        bizSql.put("YWFA-SelectMaterial", InitDataConst.getBizParam(bizParam));
        return bizSql;
    }

    public LocaleString getName4EntityNumber(String num) {
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"JSFA-Orignal")) {
            return ResManager.getLocaleString((String)"\u8ba1\u7b97\u65b9\u6848-\u5168\u5c40\u8ba1\u5212", (String)"InitDataConst_24", (String)"mmc-mrp-common");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"YWFA-Orignal")) {
            return ResManager.getLocaleString((String)"\u4e1a\u52a1\u65b9\u6848-\u5168\u5c40\u8ba1\u5212", (String)"InitDataConst_23", (String)"mmc-mrp-common");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"JSFA-SP")) {
            return ResManager.getLocaleString((String)"\u8ba1\u7b97\u65b9\u6848-\u6a21\u62df\u8ba1\u5212", (String)"InitDataConst_506", (String)"mmc-mrp-common");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"YWFA-SP")) {
            return ResManager.getLocaleString((String)"\u4e1a\u52a1\u65b9\u6848-\u6a21\u62df\u8ba1\u5212", (String)"InitDataConst_507", (String)"mmc-mrp-common");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"JSFA-SelectPlan")) {
            return ResManager.getLocaleString((String)"\u8ba1\u7b97\u65b9\u6848-\u9009\u5355\u8ba1\u5212", (String)"InitDataConst_514", (String)"mmc-mrp-common");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"YWFA-SelectPlan")) {
            return ResManager.getLocaleString((String)"\u4e1a\u52a1\u65b9\u6848-\u9009\u5355\u8ba1\u5212", (String)"InitDataConst_513", (String)"mmc-mrp-common");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"JSFA-SelectMaterial")) {
            return ResManager.getLocaleString((String)"\u8ba1\u7b97\u65b9\u6848-\u9009\u6599\u8ba1\u5212", (String)"InitDataConst_517", (String)"mmc-mrp-common");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"YWFA-SelectMaterial")) {
            return ResManager.getLocaleString((String)"\u4e1a\u52a1\u65b9\u6848-\u9009\u6599\u8ba1\u5212", (String)"InitDataConst_516", (String)"mmc-mrp-common");
        }
        return new LocaleString(num);
    }

    protected static Map<String, List<Object[]>> getBizParam(BizParam bizParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object[]>> map = new LinkedHashMap<String, List<Object[]>>(InitSQLConst.bizSql.length);
        for (int i = 0; i < InitSQLConst.bizSql.length; ++i) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(1);
            switch (i) {
                case 0: 
                case 1: 
                case 5: {
                    Object[] p = new Object[]{bizParam.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{bizParam.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{bizParam.id, bizParam.cellsdata_tag, bizParam.orgId, bizParam.id, bizParam.orgId, "C", bizParam.defaultctrlstrategy, bizParam.number, "", nowTime, userId, "1", nowTime, bizParam.xml_tag, userId, "", "V1.0", InitDataConst.getRealAppId(bizParam.appId)};
                    params.add(p);
                    break;
                }
                case 4: {
                    params.addAll(MulLangTableDataInitUtil.getInsertMulLangTableParams(bizParam.id, bizParam.name));
                    break;
                }
                case 6: {
                    Object[] p;
                    for (BizEntryParam bizEntry : bizParam.bizEntrys) {
                        p = new Object[]{bizEntry.entryId};
                        params.add(p);
                    }
                    break;
                }
                case 7: {
                    Object[] p;
                    for (BizEntryParam bizEntry : bizParam.bizEntrys) {
                        p = new Object[]{bizParam.id, bizEntry.entryId, bizEntry.seq, bizEntry.algomodel};
                        params.add(p);
                    }
                    break;
                }
            }
            map.put(InitSQLConst.bizSql[i], params);
        }
        return map;
    }

    protected static Map<String, List<Object[]>> getCalcParam(CalcParam calcParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object[]>> map = new LinkedHashMap<String, List<Object[]>>(InitSQLConst.calcSql.length);
        for (int i = 0; i < InitSQLConst.calcSql.length; ++i) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(1);
            switch (i) {
                case 0: 
                case 1: 
                case 5: {
                    Object[] p = new Object[]{calcParam.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{calcParam.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{calcParam.id, nowTime, "1", calcParam.orgId, calcParam.id, calcParam.orgId, "C", userId, calcParam.defaultctrlstrategy, calcParam.number, "V1.0", userId, nowTime, InitDataConst.getRealAppId(calcParam.appId)};
                    params.add(p);
                    break;
                }
                case 4: {
                    params.addAll(MulLangTableDataInitUtil.getInsertMulLangTableParams(calcParam.id, calcParam.name));
                    break;
                }
                case 6: {
                    Object[] p;
                    for (CalcEntryParam calcEntryParam : calcParam.calcEntrys) {
                        p = new Object[]{calcEntryParam.entryId};
                        params.add(p);
                    }
                    break;
                }
                case 7: {
                    Object[] p;
                    for (CalcEntryParam calcEntryParam : calcParam.calcEntrys) {
                        p = new Object[]{calcParam.id, calcEntryParam.runtype, calcEntryParam.entryId, calcEntryParam.seq, calcEntryParam.bizplan};
                        params.add(p);
                    }
                    break;
                }
            }
            map.put(InitSQLConst.calcSql[i], params);
        }
        return map;
    }

    protected Map<String, Map<String, List<Object[]>>> getCalcSql2Param(Long orgId, String defaultctrlstrategy, String appId) {
        HashMap<String, Map<String, List<Object[]>>> calcSql = new HashMap<String, Map<String, List<Object[]>>>(1);
        ArrayList<CalcEntryParam> entrys = new ArrayList<CalcEntryParam>(16);
        entrys.add(new CalcEntryParam(1077500764571591680L, 1, "mrp_globalplan", 1077500332524722176L));
        CalcParam calcParam = new CalcParam(orgId, defaultctrlstrategy, 1077500764504482816L, "1MDR8Z0ABD/X", "JSFA-Orignal", ResManager.getLocaleString((String)"\u8ba1\u7b97\u65b9\u6848-\u5168\u5c40\u8ba1\u5212", (String)"InitDataConst_24", (String)"mmc-mrp-common"), entrys, appId);
        calcSql.put("JSFA-Orignal", InitDataConst.getCalcParam(calcParam));
        entrys = new ArrayList(16);
        entrys.add(new CalcEntryParam(1468861709509757952L, 1, "mrp_simulation", 1448644860453082112L));
        calcParam = new CalcParam(orgId, defaultctrlstrategy, 1468861709467813888L, "2LE5H4LSEQ70", "JSFA-SP", ResManager.getLocaleString((String)"\u8ba1\u7b97\u65b9\u6848-\u6a21\u62df\u8ba1\u5212", (String)"InitDataConst_506", (String)"mmc-mrp-common"), entrys, appId);
        calcSql.put("JSFA-SP", InitDataConst.getCalcParam(calcParam));
        entrys = new ArrayList(16);
        entrys.add(new CalcEntryParam(1446979617117188096L, 1, "mrp_selectbillplan", 1447075569169642496L));
        calcParam = new CalcParam(orgId, defaultctrlstrategy, 1446979616806809600L, "2IQAXPPU8TGS", "JSFA-SelectPlan", ResManager.getLocaleString((String)"\u8ba1\u7b97\u65b9\u6848-\u9009\u5355\u8ba1\u5212", (String)"InitDataConst_514", (String)"mmc-mrp-common"), entrys, appId);
        calcSql.put("JSFA-SelectPlan", InitDataConst.getCalcParam(calcParam));
        entrys = new ArrayList(16);
        entrys.add(new CalcEntryParam(1526908799833700352L, 1, "mrp_selectmaterialplan", 1526908077910095872L));
        calcParam = new CalcParam(orgId, defaultctrlstrategy, 1526908799791758336L, "2SJ9B=NIW32/", "JSFA-SelectMaterial", ResManager.getLocaleString((String)"\u8ba1\u7b97\u65b9\u6848-\u9009\u6599\u8ba1\u5212", (String)"InitDataConst_517", (String)"mmc-mrp-common"), entrys, appId);
        calcSql.put("JSFA-SelectMaterial", InitDataConst.getCalcParam(calcParam));
        return calcSql;
    }

    private static String getTfsAppId(String appId) {
        String result = "B";
        if ("mrp".equals(appId)) {
            return result;
        }
        result = "mds".equals(appId) ? "A" : ("sfc".equals(appId) ? "C" : ("msplan".equals(appId) || "msmpmm".equals(appId) ? "D" : appId));
        return result;
    }

    protected static Map<String, List<Object[]>> getTrsfParam(TrsfParam trsfParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object[]>> map = new LinkedHashMap<String, List<Object[]>>(InitSQLConst.trsfSql.length);
        for (int i = 0; i < InitSQLConst.trsfSql.length; ++i) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(1);
            switch (i) {
                case 0: 
                case 1: 
                case 5: {
                    Object[] p = new Object[]{trsfParam.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{trsfParam.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{trsfParam.id, "V1.0", trsfParam.orgId, trsfParam.orgId, trsfParam.id, "C", trsfParam.defaultctrlstrategy, trsfParam.number, trsfParam.srcbill, nowTime, "0", "1", trsfParam.destbill, userId, userId, nowTime, trsfParam.ismatchdim, InitDataConst.getTfsAppId(trsfParam.appId), MulLangTableDataInitUtil.getDefaultLocaleValue(trsfParam.name)};
                    params.add(p);
                    break;
                }
                case 4: {
                    params.addAll(MulLangTableDataInitUtil.getInsertMulLangTableParams(trsfParam.id, trsfParam.name));
                    break;
                }
                case 6: 
                case 8: {
                    Object[] p;
                    for (TrsfEntryParam entryParam : trsfParam.entryParams) {
                        p = new Object[]{entryParam.entryId};
                        params.add(p);
                    }
                    break;
                }
                case 7: {
                    Object[] p;
                    for (TrsfEntryParam entryParam : trsfParam.entryParams) {
                        p = new Object[]{trsfParam.id, entryParam.calculateexc_tag, entryParam.calculateexc, entryParam.destfieldflag, MulLangTableDataInitUtil.getDefaultLocaleValue(entryParam.sourcefieldname), entryParam.entryId, entryParam.calculatetext, entryParam.sourcefieldflag, MulLangTableDataInitUtil.getDefaultLocaleValue(entryParam.destfieldname), entryParam.destentityflag, entryParam.converttype, entryParam.sourceentityflag, entryParam.seq};
                        params.add(p);
                    }
                    break;
                }
                case 9: {
                    for (TrsfEntryParam entryParam : trsfParam.entryParams) {
                        params.addAll(MulLangTableDataInitUtil.getInsertMulLangTableParams(entryParam.entryId, entryParam.sourcefieldname, entryParam.destfieldname));
                    }
                    break;
                }
            }
            map.put(InitSQLConst.trsfSql[i], params);
        }
        return map;
    }

    protected Map<String, Map<String, List<Object[]>>> getTrsfSql2Param(Long orgId, String defaultctrlstrategy, String appId) {
        HashMap<String, Map<String, List<Object[]>>> trsfSql = new HashMap<String, Map<String, List<Object[]>>>(16);
        ArrayList<TrsfEntryParam> entrys = new ArrayList<TrsfEntryParam>(16);
        entrys.add(new TrsfEntryParam(975362587204042752L, 1, "", "", "", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "createorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_26", (String)"mmc-mrp-common"), "createorg", "0"));
        entrys.add(new TrsfEntryParam(975362587204042754L, 2, "", "", "", "entryentity.bomtype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.BOM\u7c7b\u578b", (String)"InitDataConst_27", (String)"mmc-mrp-common"), "entryentity.bomtype", "type", ResManager.getLocaleString((String)"\u5355\u636e\u5934.BOM\u7c7b\u578b", (String)"InitDataConst_28", (String)"mmc-mrp-common"), "type", "0"));
        entrys.add(new TrsfEntryParam(975362587204042755L, 3, "", "", "", "entryentity.bomnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.BOM\u7f16\u7801", (String)"InitDataConst_29", (String)"mmc-mrp-common"), "entryentity.bomnumber", "number", ResManager.getLocaleString((String)"\u5355\u636e\u5934.BOM\u7f16\u7801", (String)"InitDataConst_30", (String)"mmc-mrp-common"), "number", "0"));
        entrys.add(new TrsfEntryParam(975362587204042757L, 4, "", "entry.entryqtynumerator /  entry.entryqtydenominator", ResManager.loadKDString((String)"\u7528\u91cf\uff1a\u5206\u5b50 /  \u7528\u91cf\uff1a\u5206\u6bcd", (String)"InitDataConst_32", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.qty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6d88\u8017\u5b9a\u989d", (String)"InitDataConst_33", (String)"mmc-mrp-common"), "entryentity.qty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(975362587204042758L, 5, "", "", "", "entryentity.balanceperiod", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u63d0\u524d\u671f\u504f\u7f6e\u65f6\u95f4", (String)"InitDataConst_34", (String)"mmc-mrp-common"), "entryentity.balanceperiod", "entry.entryleadtime", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u63d0\u524d\u671f\u504f\u7f6e\u65f6\u95f4(\u5929)", (String)"InitDataConst_35", (String)"mmc-mrp-common"), "entry.entryleadtime", "0"));
        entrys.add(new TrsfEntryParam(975362587204042760L, 6, "", "", "", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_36", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "createorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_26", (String)"mmc-mrp-common"), "createorg", "0"));
        entrys.add(new TrsfEntryParam(975362587204042761L, 7, "", "", "", "entryentity.bomversion", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.BOM\u7248\u672c", (String)"InitDataConst_37", (String)"mmc-mrp-common"), "entryentity.bomversion", "version", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7248\u672c\u53f7", (String)"InitDataConst_38", (String)"mmc-mrp-common"), "version", "0"));
        entrys.add(new TrsfEntryParam(975362587204042762L, 8, "", "", "", "entryentity.moduleversion", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6BOM\u7248\u672c", (String)"InitDataConst_39", (String)"mmc-mrp-common"), "entryentity.moduleversion", "entry.entryversion", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u7248\u672c\u53f7", (String)"InitDataConst_40", (String)"mmc-mrp-common"), "entry.entryversion", "0"));
        entrys.add(new TrsfEntryParam(975362587204042763L, 9, "", "", "", "entryentity.moduleproorg", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_41", (String)"mmc-mrp-common"), "entryentity.moduleproorg", "createorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_26", (String)"mmc-mrp-common"), "createorg", "0"));
        entrys.add(new TrsfEntryParam(975362587204042764L, 10, "", "", "", "entryentity.modulesupplyorg", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_42", (String)"mmc-mrp-common"), "entryentity.modulesupplyorg", "entry.entrysupplyorg", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7", (String)"InitDataConst_622", (String)"mmc-mrp-common"), "entry.entrysupplyorg", "0"));
        entrys.add(new TrsfEntryParam(975362587204042765L, 11, "", "id", ResManager.loadKDString((String)"BOM.\u5185\u7801", (String)"InitDataConst_44", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.bomid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.BOMID", (String)"InitDataConst_45", (String)"mmc-mrp-common"), "entryentity.bomid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(975362587204042766L, 12, "", "entry.id", ResManager.loadKDString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u5185\u7801", (String)"InitDataConst_47", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.bomentryid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.BOM\u5206\u5f55ID", (String)"InitDataConst_48", (String)"mmc-mrp-common"), "entryentity.bomentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(975362587204042767L, 13, "", "", "", "entryentity.ecnversion", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.ECN\u7248\u672c", (String)"InitDataConst_49", (String)"mmc-mrp-common"), "entryentity.ecnversion", "ecnversion", ResManager.getLocaleString((String)"\u5355\u636e\u5934.ECN\u7248\u672c", (String)"InitDataConst_50", (String)"mmc-mrp-common"), "ecnversion", "0"));
        entrys.add(new TrsfEntryParam(975362587204042768L, 14, "", "", "", "entryentity.moduleecnversion", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6ECN\u7248\u672c", (String)"InitDataConst_51", (String)"mmc-mrp-common"), "entryentity.moduleecnversion", "entry.entryecnverion", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.ECN\u7248\u672c", (String)"InitDataConst_52", (String)"mmc-mrp-common"), "entry.entryecnverion", "0"));
        entrys.add(new TrsfEntryParam(975362587204042769L, 15, "", "pdm_mftbom.material.masterid.baseunit", ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_54", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.unit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_55", (String)"mmc-mrp-common"), "entryentity.unit", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(975362587204042770L, 16, "", "", "", "entryentity.moduleunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_56", (String)"mmc-mrp-common"), "entryentity.moduleunit", "entry.entryunit", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_57", (String)"mmc-mrp-common"), "entry.entryunit", "0"));
        entrys.add(new TrsfEntryParam(975362587204042771L, 17, "", "", "", "entryentity.moduletype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u7c7b\u578b", (String)"InitDataConst_58", (String)"mmc-mrp-common"), "entryentity.moduletype", "entry.entrytype", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u7ec4\u4ef6\u7c7b\u578b", (String)"InitDataConst_59", (String)"mmc-mrp-common"), "entry.entrytype", "0"));
        entrys.add(new TrsfEntryParam(975362587204042772L, 18, "", "", "", "entryentity.modulecustype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u7528\u91cf\u7c7b\u578b", (String)"InitDataConst_60", (String)"mmc-mrp-common"), "entryentity.modulecustype", "entry.entryqtytype", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u7528\u91cf\u7c7b\u578b", (String)"InitDataConst_61", (String)"mmc-mrp-common"), "entry.entryqtytype", "0"));
        entrys.add(new TrsfEntryParam(975362587204042773L, 19, "", "", "", "entryentity.modulenumerator", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u7528\u91cf:\u5206\u5b50", (String)"InitDataConst_62", (String)"mmc-mrp-common"), "entryentity.modulenumerator", "entry.entryqtynumerator", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u7528\u91cf\uff1a\u5206\u5b50", (String)"InitDataConst_63", (String)"mmc-mrp-common"), "entry.entryqtynumerator", "0"));
        entrys.add(new TrsfEntryParam(975362587204042774L, 20, "", "", "", "entryentity.moduledenominator", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u7528\u91cf:\u5206\u6bcd", (String)"InitDataConst_64", (String)"mmc-mrp-common"), "entryentity.moduledenominator", "entry.entryqtydenominator", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u7528\u91cf\uff1a\u5206\u6bcd", (String)"InitDataConst_65", (String)"mmc-mrp-common"), "entry.entryqtydenominator", "0"));
        entrys.add(new TrsfEntryParam(975362587204042777L, 21, "", "", "", "entryentity.modulesupplytype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u4f9b\u5e94\u7c7b\u578b", (String)"InitDataConst_66", (String)"mmc-mrp-common"), "entryentity.modulesupplytype", "entry.entrytype", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u7ec4\u4ef6\u7c7b\u578b", (String)"InitDataConst_59", (String)"mmc-mrp-common"), "entry.entrytype", "0"));
        entrys.add(new TrsfEntryParam(1010907784989913088L, 22, "", "", "", "entryentity.ctrlstrategy", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ba1\u63a7\u7b56\u7565", (String)"InitDataConst_67", (String)"mmc-mrp-common"), "entryentity.ctrlstrategy", "ctrlstrategy", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u63a7\u5236\u7b56\u7565", (String)"InitDataConst_68", (String)"mmc-mrp-common"), "ctrlstrategy", "0"));
        entrys.add(new TrsfEntryParam(1013149839363418112L, 23, "", "", "", "entryentity.moduleloss", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u56fa\u5b9a\u635f\u8017", (String)"InitDataConst_69", (String)"mmc-mrp-common"), "entryentity.moduleloss", "entry.entryfixscrap", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u56fa\u5b9a\u635f\u8017", (String)"InitDataConst_70", (String)"mmc-mrp-common"), "entry.entryfixscrap", "0"));
        entrys.add(new TrsfEntryParam(1013149839363418113L, 24, "", "", "", "entryentity.modulewaste", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u53d8\u52a8\u635f\u8017\u7387", (String)"InitDataConst_71", (String)"mmc-mrp-common"), "entryentity.modulewaste", "entry.entryscraprate", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u53d8\u52a8\u635f\u8017\u7387\uff08%\uff09", (String)"InitDataConst_72", (String)"mmc-mrp-common"), "entry.entryscraprate", "0"));
        entrys.add(new TrsfEntryParam(1029611240227352576L, 25, "", "", "", "entryentity.isjump", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u662f\u5426\u8df3\u5c42", (String)"InitDataConst_73", (String)"mmc-mrp-common"), "entryentity.isjump", "entry.entryisjumplevel", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u8df3\u5c42", (String)"InitDataConst_74", (String)"mmc-mrp-common"), "entry.entryisjumplevel", "0"));
        entrys.add(new TrsfEntryParam(1077567773476941824L, 26, "", "", "", "entryentity.validdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u751f\u6548\u65e5\u671f", (String)"InitDataConst_75", (String)"mmc-mrp-common"), "entryentity.validdate", "entry.entryvaliddate", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u751f\u6548\u65e5\u671f", (String)"InitDataConst_76", (String)"mmc-mrp-common"), "entry.entryvaliddate", "0"));
        entrys.add(new TrsfEntryParam(1077567773476941825L, 27, "", "", "", "entryentity.invaliddate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u5931\u6548\u65e5\u671f", (String)"InitDataConst_77", (String)"mmc-mrp-common"), "entryentity.invaliddate", "entry.entryinvaliddate", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u5931\u6548\u65e5\u671f", (String)"InitDataConst_78", (String)"mmc-mrp-common"), "entry.entryinvaliddate", "0"));
        entrys.add(new TrsfEntryParam(975362587204042753L, 28, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "materialid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4e3b\u7269\u6599", (String)"InitDataConst_80", (String)"mmc-mrp-common"), "materialid", "0"));
        entrys.add(new TrsfEntryParam(975362587204042756L, 29, "", "", "", "entryentity.comboxmateriel", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u7269\u6599", (String)"InitDataConst_81", (String)"mmc-mrp-common"), "entryentity.comboxmateriel", "entry.entrymaterialid", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u5b50\u7269\u6599", (String)"InitDataConst_82", (String)"mmc-mrp-common"), "entry.entrymaterialid", "0"));
        entrys.add(new TrsfEntryParam(1223746150981483520L, 31, "", "", "", "entryentity.entryreplaceplan", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u66ff\u4ee3\u65b9\u6848", (String)"InitDataConst_83", (String)"mmc-mrp-common"), "entryentity.entryreplaceplan", "entry.entryreplaceplan", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u66ff\u4ee3\u65b9\u6848", (String)"InitDataConst_84", (String)"mmc-mrp-common"), "entry.entryreplaceplan", "0"));
        entrys.add(new TrsfEntryParam(1223746150981483521L, 32, "", "", "", "entryentity.entryisreplaceplanmm", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u66ff\u4ee3\u4e3b\u6599", (String)"InitDataConst_85", (String)"mmc-mrp-common"), "entryentity.entryisreplaceplanmm", "entry.entryisreplaceplanmm", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u66ff\u4ee3\u4e3b\u6599", (String)"InitDataConst_86", (String)"mmc-mrp-common"), "entry.entryisreplaceplanmm", "0"));
        entrys.add(new TrsfEntryParam(1223746150981483522L, 33, "", "", "", "entryentity.entryisreplace", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u66ff\u4ee3\u4ef6", (String)"InitDataConst_87", (String)"mmc-mrp-common"), "entryentity.entryisreplace", "entry.entryisreplace", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u66ff\u4ee3\u4ef6", (String)"InitDataConst_88", (String)"mmc-mrp-common"), "entry.entryisreplace", "0"));
        entrys.add(new TrsfEntryParam(1223746150981483523L, 34, "", "", "", "entryentity.entrypriority", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u66ff\u4ee3\u4f18\u5148\u7ea7", (String)"InitDataConst_89", (String)"mmc-mrp-common"), "entryentity.entrypriority", "entry.reppriority", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u4f18\u5148\u7ea7", (String)"InitDataConst_90", (String)"mmc-mrp-common"), "entry.reppriority", "0"));
        entrys.add(new TrsfEntryParam(1223746150981483524L, 35, "", "entry.entryreplaceplan.replacestra", ResManager.loadKDString((String)"\u66ff\u4ee3\u7b56\u7565", (String)"InitDataConst_92", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.replacestra", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u66ff\u4ee3\u7b56\u7565", (String)"InitDataConst_93", (String)"mmc-mrp-common"), "entryentity.replacestra", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1223746150981483525L, 36, "", "entry.entryreplaceplan.replacemethod", ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u5f0f", (String)"InitDataConst_95", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.replacemethod", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u66ff\u4ee3\u65b9\u5f0f", (String)"InitDataConst_96", (String)"mmc-mrp-common"), "entryentity.replacemethod", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1305651387467808768L, 37, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u914d\u7f6e\u53f7", (String)"InitDataConst_97", (String)"mmc-mrp-common"), "entryentity.configuredcode", "configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_98", (String)"mmc-mrp-common"), "configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1306553939654737920L, 38, "", "", "", "entryentity.entryconfiguredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u914d\u7f6e\u53f7", (String)"InitDataConst_99", (String)"mmc-mrp-common"), "entryentity.entryconfiguredcode", "entry.entryconfiguredcode", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u914d\u7f6e\u53f7", (String)"InitDataConst_100", (String)"mmc-mrp-common"), "entry.entryconfiguredcode", "0"));
        entrys.add(new TrsfEntryParam(1389935183938978816L, 39, "", "entry.seq", ResManager.loadKDString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u5e8f\u53f7", (String)"InitDataConst_102", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.bomentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.BOM\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_103", (String)"mmc-mrp-common"), "entryentity.bomentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1389934927113355264L, 40, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_104", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "auxproperty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_105", (String)"mmc-mrp-common"), "auxproperty", "0"));
        entrys.add(new TrsfEntryParam(1391190341264080896L, 41, "", "", "", "entryentity.entrymaterialflexprop", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_106", (String)"mmc-mrp-common"), "entryentity.entrymaterialflexprop", "entry.entryauxproperty", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_107", (String)"mmc-mrp-common"), "entry.entryauxproperty", "0"));
        entrys.add(new TrsfEntryParam(1781844479506918400L, 42, "", "", "", "entryentity.entrywarehouse", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u4ed3\u5e93", (String)"InitDataConst_623", (String)"mmc-mrp-common"), "entryentity.entrywarehouse", "entry.entrywarehouse", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u9ed8\u8ba4\u53d1\u6599\u4ed3\u5e93", (String)"InitDataConst_624", (String)"mmc-mrp-common"), "entry.entrywarehouse", "0"));
        entrys.add(new TrsfEntryParam(1781844479506918401L, 43, "", "", "", "entryentity.entrylocation", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u4ed3\u4f4d", (String)"InitDataConst_625", (String)"mmc-mrp-common"), "entryentity.entrylocation", "entry.entrylocation", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u9ed8\u8ba4\u53d1\u6599\u4ed3\u4f4d", (String)"InitDataConst_626", (String)"mmc-mrp-common"), "entry.entrylocation", "0"));
        entrys.add(new TrsfEntryParam(1781844479506918402L, 44, "", "pdm_mftbom.type.purpose", ResManager.loadKDString((String)"\u7528\u9014", (String)"InitDataConst_627", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.purpose", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.BOM\u7c7b\u578b.\u7528\u9014", (String)"InitDataConst_628", (String)"mmc-mrp-common"), "entryentity.purpose", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1781844479506918403L, 45, "", "", "", "entryentity.featuretype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u7279\u5f81\u7c7b", (String)"InitDataConst_630", (String)"mmc-mrp-common"), "entryentity.featuretype", "entry.featuretype", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4fe1\u606f.\u7279\u5f81\u7c7b", (String)"InitDataConst_631", (String)"mmc-mrp-common"), "entry.featuretype", "0"));
        entrys.add(new TrsfEntryParam(1936879705592479744L, 46, "", "entry.entrymaterial.iskeypart", ResManager.loadKDString((String)"\u5173\u952e\u4ef6", (String)"InitDataConst_603", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.iskeymateriel", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u662f\u5426\u5173\u952e\u7269\u6599", (String)"InitDataConst_604", (String)"mmc-mrp-common"), "entryentity.iskeymateriel", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        TrsfParam trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 962925544213630976L, "1MH1PSD8WAV4", "YS-BOM-bomregist", ResManager.getLocaleString((String)"\u5236\u9020BOM\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_108", (String)"mmc-mrp-common"), "pdm_mftbom", "mrp_bomexpand_model_inh", "0", entrys, appId);
        trsfSql.put("YS-BOM-bomregist", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1281137810245467136L, 1, "", "", "", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "createorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_26", (String)"mmc-mrp-common"), "createorg", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467137L, 2, "", "", "", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_36", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "createorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_26", (String)"mmc-mrp-common"), "createorg", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467138L, 3, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "material.masterid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4ea7\u54c1\u7f16\u7801.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_109", (String)"mmc-mrp-common"), "material.masterid", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467139L, 4, "", "id", ResManager.loadKDString((String)"BOM.\u5185\u7801", (String)"InitDataConst_44", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.bomid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.BOMID", (String)"InitDataConst_45", (String)"mmc-mrp-common"), "entryentity.bomid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1281137810245467140L, 5, "", "copentry.id", ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1.\u5185\u7801", (String)"InitDataConst_111", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.bomentryid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.BOM\u5206\u5f55ID", (String)"InitDataConst_48", (String)"mmc-mrp-common"), "entryentity.bomentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1281137810245467141L, 6, "", "", "", "entryentity.bomtype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.BOM\u7c7b\u578b", (String)"InitDataConst_27", (String)"mmc-mrp-common"), "entryentity.bomtype", "type", ResManager.getLocaleString((String)"\u5355\u636e\u5934.BOM\u7c7b\u578b", (String)"InitDataConst_28", (String)"mmc-mrp-common"), "type", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467142L, 7, "", "", "", "entryentity.qty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6d88\u8017\u5b9a\u989d", (String)"InitDataConst_33", (String)"mmc-mrp-common"), "entryentity.qty", "copentry.copentryqty", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u6570\u91cf", (String)"InitDataConst_112", (String)"mmc-mrp-common"), "copentry.copentryqty", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467143L, 8, "", "copentry.seq", ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1.\u5e8f\u53f7", (String)"InitDataConst_114", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.bomentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.BOM\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_103", (String)"mmc-mrp-common"), "entryentity.bomentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1281137810245467144L, 9, "", "", "", "entryentity.bomnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.BOM\u7f16\u7801", (String)"InitDataConst_29", (String)"mmc-mrp-common"), "entryentity.bomnumber", "number", ResManager.getLocaleString((String)"\u5355\u636e\u5934.BOM\u7f16\u7801", (String)"InitDataConst_30", (String)"mmc-mrp-common"), "number", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467145L, 10, "", "", "", "entryentity.moduleversion", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6BOM\u7248\u672c", (String)"InitDataConst_39", (String)"mmc-mrp-common"), "entryentity.moduleversion", "copentry.copentryversion", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u7248\u672c\u53f7", (String)"InitDataConst_115", (String)"mmc-mrp-common"), "copentry.copentryversion", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467146L, 11, "", "", "", "entryentity.moduleproorg", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_41", (String)"mmc-mrp-common"), "entryentity.moduleproorg", "createorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_26", (String)"mmc-mrp-common"), "createorg", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467147L, 12, "", "", "", "entryentity.modulesupplyorg", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_42", (String)"mmc-mrp-common"), "entryentity.modulesupplyorg", "createorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_26", (String)"mmc-mrp-common"), "createorg", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467149L, 14, "", "", "", "entryentity.unit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_55", (String)"mmc-mrp-common"), "entryentity.unit", "material.masterid.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4ea7\u54c1\u7f16\u7801.\u7269\u6599\u7f16\u7801.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_116", (String)"mmc-mrp-common"), "material.masterid.baseunit", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467148L, 13, "", "", "", "entryentity.moduleunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_56", (String)"mmc-mrp-common"), "entryentity.moduleunit", "copentry.copentryunit", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_117", (String)"mmc-mrp-common"), "copentry.copentryunit", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467150L, 15, "", "", "", "entryentity.modulenumerator", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u7528\u91cf:\u5206\u5b50", (String)"InitDataConst_62", (String)"mmc-mrp-common"), "entryentity.modulenumerator", "copentry.copentryqty", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u6570\u91cf", (String)"InitDataConst_112", (String)"mmc-mrp-common"), "copentry.copentryqty", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467151L, 16, "", "1", "1", "entryentity.moduledenominator", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u7528\u91cf:\u5206\u6bcd", (String)"InitDataConst_64", (String)"mmc-mrp-common"), "entryentity.moduledenominator", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1281137810245467152L, 17, "", "", "", "entryentity.ctrlstrategy", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ba1\u63a7\u7b56\u7565", (String)"InitDataConst_67", (String)"mmc-mrp-common"), "entryentity.ctrlstrategy", "ctrlstrategy", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u63a7\u5236\u7b56\u7565", (String)"InitDataConst_68", (String)"mmc-mrp-common"), "ctrlstrategy", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467153L, 18, "", "", "", "entryentity.comboxmateriel", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u7269\u6599", (String)"InitDataConst_81", (String)"mmc-mrp-common"), "entryentity.comboxmateriel", "copentry.copentrymaterial.masterid", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u4ea7\u54c1\u7f16\u7801.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_118", (String)"mmc-mrp-common"), "copentry.copentrymaterial.masterid", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467154L, 19, "", "", "", "entryentity.coptype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4ea7\u54c1\u7c7b\u578b", (String)"InitDataConst_119", (String)"mmc-mrp-common"), "entryentity.coptype", "copentry.copentrytype", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u4ea7\u54c1\u7c7b\u578b", (String)"InitDataConst_120", (String)"mmc-mrp-common"), "copentry.copentrytype", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467155L, 20, "", "", "", "entryentity.copoperation", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4ea7\u51fa\u5de5\u5e8f", (String)"InitDataConst_121", (String)"mmc-mrp-common"), "entryentity.copoperation", "copentry.copentryoperation", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u4ea7\u51fa\u5de5\u5e8f", (String)"InitDataConst_122", (String)"mmc-mrp-common"), "copentry.copentryoperation", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467156L, 21, "", "\"1\"", "\"1\"", "entryentity.iscopdata", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u662f\u5426\u8054\u526f\u4ea7\u54c1\u6570\u636e", (String)"InitDataConst_123", (String)"mmc-mrp-common"), "entryentity.iscopdata", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1402897890040349696L, 22, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_104", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "auxproperty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_105", (String)"mmc-mrp-common"), "auxproperty", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467157L, 23, "", "", "", "entryentity.entrymaterialflexprop", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_106", (String)"mmc-mrp-common"), "entryentity.entrymaterialflexprop", "copentry.copentryauxproperty", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_124", (String)"mmc-mrp-common"), "copentry.copentryauxproperty", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467158L, 24, "", "", "", "entryentity.remark", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5907\u6ce8", (String)"InitDataConst_125", (String)"mmc-mrp-common"), "entryentity.remark", "copentry.copentryremark", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u5907\u6ce8", (String)"InitDataConst_126", (String)"mmc-mrp-common"), "copentry.copentryremark", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467159L, 25, "", "", "", "entryentity.validdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u751f\u6548\u65e5\u671f", (String)"InitDataConst_75", (String)"mmc-mrp-common"), "entryentity.validdate", "copentry.copentryvaliddate", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u751f\u6548\u65e5\u671f", (String)"InitDataConst_127", (String)"mmc-mrp-common"), "copentry.copentryvaliddate", "0"));
        entrys.add(new TrsfEntryParam(1281137810245467160L, 26, "", "", "", "entryentity.invaliddate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u5931\u6548\u65e5\u671f", (String)"InitDataConst_77", (String)"mmc-mrp-common"), "entryentity.invaliddate", "copentry.copentryinvaliddate", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u5931\u6548\u65e5\u671f", (String)"InitDataConst_128", (String)"mmc-mrp-common"), "copentry.copentryinvaliddate", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1281137808701963264L, "2/IOHAWSM9NM", "BOM-COP-bomregist", ResManager.getLocaleString((String)"BOM\u8054\u526f\u4ea7\u54c1-BOM\u5c55\u5f00\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_129", (String)"mmc-mrp-common"), "pdm_mftbom", "mrp_bomexpand_model_inh", "0", entrys, appId);
        trsfSql.put("BOM-COP-bomregist", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1078053504574057506L, 1, "", "", "", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "detailentity.prodorg", ResManager.getLocaleString((String)"\u660e\u7ec6\u5355\u636e\u4f53.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_130", (String)"mmc-mrp-common"), "detailentity.prodorg", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057508L, 2, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "detailentity.materialid", ResManager.getLocaleString((String)"\u660e\u7ec6\u5355\u636e\u4f53.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_131", (String)"mmc-mrp-common"), "detailentity.materialid", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057509L, 3, "", "detailentity.materialid.baseunit", ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_54", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057510L, 4, "", "id", ResManager.loadKDString((String)"\u8ba1\u5212\u5904\u7406(\u540e\u53f0).\u5185\u7801", (String)"InitDataConst_135", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057513L, 5, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_137", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057514L, 6, "", "detailentity.id", ResManager.loadKDString((String)"\u660e\u7ec6\u5355\u636e\u4f53.\u5185\u7801", (String)"InitDataConst_140", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_141", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057515L, 7, "", "detailentity.seq", ResManager.loadKDString((String)"\u660e\u7ec6\u5355\u636e\u4f53.\u5e8f\u53f7", (String)"InitDataConst_143", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_144", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057517L, 8, "", "detailentity.materialid.number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"InitDataConst_146", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.materialnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_147", (String)"mmc-mrp-common"), "entryentity.materialnumber", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1123870674180387840L, 9, "", "'SOP'", "'SOP'", "entryentity.demandsourcetype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b", (String)"InitDataConst_148", (String)"mmc-mrp-common"), "entryentity.demandsourcetype", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057511L, 10, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.billdate", "detailentity.datenode", ResManager.getLocaleString((String)"\u660e\u7ec6\u5355\u636e\u4f53.\u65f6\u95f4\u70b9", (String)"InitDataConst_150", (String)"mmc-mrp-common"), "detailentity.datenode", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057512L, 11, "", "", "", "entryentity.demandqty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_151", (String)"mmc-mrp-common"), "entryentity.demandqty", "detailentity.fcqty", ResManager.getLocaleString((String)"\u660e\u7ec6\u5355\u636e\u4f53.\u539f\u59cb\u6570\u91cf", (String)"InitDataConst_152", (String)"mmc-mrp-common"), "detailentity.fcqty", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1019614409087004672L, "1MH1PT5YGBEC", "YS-REQ-001", ResManager.getLocaleString((String)"\u51c0\u9700\u6c42\u8ba1\u5212-\u9700\u6c42\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_153", (String)"mmc-mrp-common"), "mds_data", "mrp_demandbill_model_inh", "0", entrys, appId);
        trsfSql.put("YS-REQ-001", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1155608858874395648L, 1, "", "", "", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "createorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_26", (String)"mmc-mrp-common"), "createorg", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057484L, 3, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "material", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_154", (String)"mmc-mrp-common"), "material", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057485L, 4, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "unit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_155", (String)"mmc-mrp-common"), "unit", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057486L, 5, "", "", "", "entryentity.demandqty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_151", (String)"mmc-mrp-common"), "entryentity.demandqty", "qty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6570\u91cf", (String)"InitDataConst_156", (String)"mmc-mrp-common"), "qty", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057487L, 6, String.format("{\"items\":[{\"id\":\"2/WL6G/LNQYZ\",\"seq\":1,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"2/WL3ADPND9K\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"saftytype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2/WL3ADT=2XF\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"2/WL3ADPND9K\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"saftytype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2/WL3ADT=2XF\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"NOW()\",\"exprTran\":\"NOW()\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"NOW()\"},\"exprDesc\":\"NOW()\"},\"select\":\"ByCondition\"},{\"id\":\"2/WL6G/LO0DA\",\"seq\":2,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"2/WL5AI0J=/4\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"saftytype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2/WL5AI0JKFH\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"2/WL5AI0J=/4\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"saftytype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2/WL5AI0JKFH\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"effecttime\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"select\":\"ByCondition\"}],\"description\":\"NOW()\\\\%s\"}", ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b \u7b49\u4e8e \u56fa\u5b9a\u5b89\u5168\u5e93\u5b58", (String)"InitDataConst_772", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b \u7b49\u4e8e \u56fa\u5b9a\u5b89\u5168\u5e93\u5b58", (String)"InitDataConst_772", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b \u7b49\u4e8e \u56fa\u5b9a\u5b89\u5168\u5e93\u5b58", (String)"InitDataConst_772", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b \u4e0d\u7b49\u4e8e \u56fa\u5b9a\u5b89\u5168\u5e93\u5b58", (String)"InitDataConst_773", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b \u4e0d\u7b49\u4e8e \u56fa\u5b9a\u5b89\u5168\u5e93\u5b58", (String)"InitDataConst_773", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b \u4e0d\u7b49\u4e8e \u56fa\u5b9a\u5b89\u5168\u5e93\u5b58", (String)"InitDataConst_773", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"InitDataConst_774", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"InitDataConst_774", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"InitDataConst_774", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"InitDataConst_774", (String)"mmc-mrp-common", (Object[])new Object[0])), "NOW()", ResManager.loadKDString((String)"NOW()\\\u751f\u6548\u65e5\u671f", (String)"InitDataConst_157", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.billdate", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "2"));
        entrys.add(new TrsfEntryParam(1078053504574057488L, 7, "", "id", ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58.\u5185\u7801", (String)"InitDataConst_159", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057489L, 8, String.format("{\"items\":[{\"id\":\"2/WLD0S6NBM+\",\"seq\":1,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s)\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"2/WL9SHUDBKB\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"saftytype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2/WL9SHUDN/P\",\"value\":\"B\"},{\"id\":\"4=A/41PG0AC4\",\"value\":\"C\"}],\"baseDataIds\":[],\"lock\":false}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"2/WL9SHUDBKB\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"17\\\",\\\"fieldName\\\":\\\"saftytype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2/WL9SHUDN/P\\\",\\\"value\\\":\\\"B\\\"},{\\\"id\\\":\\\"4=A/41PG0AC4\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[],\\\"lock\\\":false}],\\\"forList\\\":false}\",\"initialized\":false,\"exprDesc\":\"%s\",\"localeExprTran\":{\"zh_CN\":\"%s\"}},\"formula\":{\"expression\":\"1\",\"exprTran\":\"1\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"1\",\"localeExprTran\":{\"zh_CN\":\"1\"}},\"select\":\"ByCondition\"},{\"id\":\"2/WLD0SCXGFC\",\"seq\":2,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"2/WL=UA=58Y=\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"saftytype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2/WL=UA=5JCN\",\"value\":\"A\"}],\"baseDataIds\":[],\"lock\":false}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"2/WL=UA=58Y=\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"saftytype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2/WL=UA=5JCN\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[],\\\"lock\\\":false}],\\\"forList\\\":false}\",\"initialized\":false,\"exprDesc\":\"%s\",\"localeExprTran\":{\"zh_CN\":\"%s\"}},\"formula\":{\"expression\":\"0\",\"exprTran\":\"0\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"0\",\"localeExprTran\":{\"zh_CN\":\"0\"}},\"select\":\"ByCondition\"}],\"description\":\"1\\\\0\"}", ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b \u5728\u2026\u2026\u4e2d (\u52a8\u6001\u5b89\u5168\u5e93\u5b58,\u52a8\u6001\u5b89\u5168\u5e93\u5b58\uff08\u5929\uff09", (String)"InitDataConst_775", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b \u5728\u2026\u2026\u4e2d (\u52a8\u6001\u5b89\u5168\u5e93\u5b58,\u52a8\u6001\u5b89\u5168\u5e93\u5b58\uff08\u5929\uff09", (String)"InitDataConst_775", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b \u5728\u2026\u2026\u4e2d (\u52a8\u6001\u5b89\u5168\u5e93\u5b58,\u52a8\u6001\u5b89\u5168\u5e93\u5b58\uff08\u5929\uff09", (String)"InitDataConst_775", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b \u7b49\u4e8e \u56fa\u5b9a\u5b89\u5168\u5e93\u5b58", (String)"InitDataConst_772", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b \u7b49\u4e8e \u56fa\u5b9a\u5b89\u5168\u5e93\u5b58", (String)"InitDataConst_772", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b \u7b49\u4e8e \u56fa\u5b9a\u5b89\u5168\u5e93\u5b58", (String)"InitDataConst_772", (String)"mmc-mrp-common", (Object[])new Object[0])), "1", "1\\0", "entryentity.istock", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u662f\u5426\u5e93\u5b58\u6570\u636e", (String)"InitDataConst_160", (String)"mmc-mrp-common"), "entryentity.istock", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "2"));
        entrys.add(new TrsfEntryParam(1155071311991585792L, 9, "", "\"SS\"", "\"SS\"", "entryentity.demandsourcetype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b", (String)"InitDataConst_148", (String)"mmc-mrp-common"), "entryentity.demandsourcetype", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057493L, 10, "", "", "", "entryentity.invaliddate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5931\u6548\u65f6\u95f4", (String)"InitDataConst_161", (String)"mmc-mrp-common"), "entryentity.invaliddate", "loseeffecttime", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5931\u6548\u65e5\u671f", (String)"InitDataConst_162", (String)"mmc-mrp-common"), "loseeffecttime", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057494L, 11, "", "", "", "entryentity.safeinvtype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5b89\u5168\u5e93\u5b58\u7c7b\u578b", (String)"InitDataConst_163", (String)"mmc-mrp-common"), "entryentity.safeinvtype", "saftytype", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5b89\u5168\u5e93\u5b58\u7c7b\u578b", (String)"InitDataConst_164", (String)"mmc-mrp-common"), "saftytype", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057491L, 12, "", "mds_safetystock.material.number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"InitDataConst_146", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.materialnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_147", (String)"mmc-mrp-common"), "entryentity.materialnumber", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1391275004766716928L, 13, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_104", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "auxpty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_105", (String)"mmc-mrp-common"), "auxpty", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1019614408164257792L, "1MH1PT5YGBED", "YS-REQ-002", ResManager.getLocaleString((String)"\u5b89\u5168\u5e93\u5b58-\u9700\u6c42\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_166", (String)"mmc-mrp-common"), "mds_safetystock", "mrp_demandbill_model_inh", "0", entrys, appId);
        trsfSql.put("YS-REQ-002", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1078053498282601472L, 1, String.format("{\"items\":[{\"id\":\"3KM+=2ZKBRFT\",\"seq\":1,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3KM+7+BFDJ39\",\"leftBracket\":\"\",\"compareType\":\"37\",\"fieldName\":\"supplyorgid.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KM+7+BFCT58\",\"value\":\"\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3KM+7+BFDJ39\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"37\\\",\\\"fieldName\\\":\\\"supplyorgid.number\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3KM+7+BFCT58\\\",\\\"value\\\":\\\"\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"org\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"select\":\"ByCondition\"},{\"id\":\"3KM+=2ZKB/HS\",\"seq\":2,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3KM+9BHH8BNV\",\"leftBracket\":\"\",\"compareType\":\"9\",\"fieldName\":\"supplyorgid.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KM+9BHH7LPU\",\"value\":\"\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3KM+9BHH8BNV\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"9\\\",\\\"fieldName\\\":\\\"supplyorgid.number\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3KM+9BHH7LPU\\\",\\\"value\\\":\\\"\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"stockentry.supplyorgid\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"select\":\"ByCondition\"}],\"description\":\"%s\\\\%s\"}", ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7.\u7f16\u7801 \u4e3a\u7a7a", (String)"InitDataConst_776", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7.\u7f16\u7801 \u4e3a\u7a7a", (String)"InitDataConst_776", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7.\u7f16\u7801 \u4e3a\u7a7a", (String)"InitDataConst_776", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7.\u7f16\u7801 \u4e0d\u4e3a\u7a7a", (String)"InitDataConst_778", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7.\u7f16\u7801 \u4e0d\u4e3a\u7a7a", (String)"InitDataConst_778", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7.\u7f16\u7801 \u4e0d\u4e3a\u7a7a", (String)"InitDataConst_778", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7", (String)"InitDataConst_779", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7", (String)"InitDataConst_779", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7", (String)"InitDataConst_779", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7", (String)"InitDataConst_779", (String)"mmc-mrp-common", (Object[])new Object[0])), "org", ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\\\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7", (String)"InitDataConst_653", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "2"));
        entrys.add(new TrsfEntryParam(1078053498282601473L, 2, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "stockentry.materielmasterid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599(\u4e3b\u6570\u636e)", (String)"InitDataConst_168", (String)"mmc-mrp-common"), "stockentry.materielmasterid", "0"));
        entrys.add(new TrsfEntryParam(1078053498282601474L, 3, "", "id", ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355.\u5185\u7801", (String)"InitDataConst_170", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053498282601475L, 4, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_137", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1078053498282601476L, 5, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.billdate", "stockentry.demanddate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "stockentry.demanddate", "0"));
        entrys.add(new TrsfEntryParam(1078053498282601477L, 6, "", "", "", "entryentity.demandqty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_151", (String)"mmc-mrp-common"), "entryentity.demandqty", "stockentry.cansendqty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u53ef\u53d1\u6570\u91cf", (String)"InitDataConst_171", (String)"mmc-mrp-common"), "stockentry.cansendqty", "0"));
        entrys.add(new TrsfEntryParam(1078053498282601479L, 8, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "stockentry.materialunitid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_174", (String)"mmc-mrp-common"), "stockentry.materialunitid", "0"));
        entrys.add(new TrsfEntryParam(1078053498282601480L, 9, "", "stockentry.id", ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u5185\u7801", (String)"InitDataConst_176", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_141", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053498282601481L, 10, "", "stockentry.seq", ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u5e8f\u53f7", (String)"InitDataConst_178", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_144", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053498282601483L, 11, "", "stockentry.materialid.number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"InitDataConst_146", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.productorgnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u751f\u4ea7\u7ec4\u7ec7\u7f16\u7801", (String)"InitDataConst_180", (String)"mmc-mrp-common"), "entryentity.productorgnumber", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1155066487048779776L, 12, "", "\"WIP\"", "\"WIP\"", "entryentity.demandsourcetype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b", (String)"InitDataConst_148", (String)"mmc-mrp-common"), "entryentity.demandsourcetype", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1305657018027206656L, 13, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u914d\u7f6e\u53f7", (String)"InitDataConst_97", (String)"mmc-mrp-common"), "entryentity.configuredcode", "stockentry.entryconfiguredcode", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u7ec4\u4ef6\u914d\u7f6e\u53f7", (String)"InitDataConst_181", (String)"mmc-mrp-common"), "stockentry.entryconfiguredcode", "0"));
        entrys.add(new TrsfEntryParam(1305799772464164864L, 14, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_182", (String)"mmc-mrp-common"), "entryentity.tracknumber", "orderentryid.tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u751f\u4ea7\u5de5\u5355\u884c\u53f7.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_183", (String)"mmc-mrp-common"), "orderentryid.tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1391285765329125376L, 15, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_104", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "stockentry.childauxpropertyid", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_184", (String)"mmc-mrp-common"), "stockentry.childauxpropertyid", "0"));
        entrys.add(new TrsfEntryParam(1779828639861364736L, 16, "", "", "", "entryentity.warehouse", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4ed3\u5e93", (String)"InitDataConst_533", (String)"mmc-mrp-common"), "entryentity.warehouse", "stockentry.warehouseid", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u4ed3\u5e93", (String)"InitDataConst_534", (String)"mmc-mrp-common"), "stockentry.warehouseid", "0"));
        entrys.add(new TrsfEntryParam(1873236652642592768L, 17, "", "orderentryid", ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u884c\u53f7", (String)"InitDataConst_717", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.supplybillid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u4f9b\u5e94\u5355\u636e\u5185\u7801", (String)"InitDataConst_713", (String)"mmc-mrp-common"), "entryentity.supplybillid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1873236652642592769L, 18, "", "", "", "entryentity.product", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4ea7\u54c1\u7269\u6599", (String)"InitDataConst_714", (String)"mmc-mrp-common"), "entryentity.product", "productmasterid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4ea7\u54c1(\u4e3b\u6570\u636e)", (String)"InitDataConst_718", (String)"mmc-mrp-common"), "productmasterid", "0"));
        entrys.add(new TrsfEntryParam(1873236652642592770L, 19, "", "1", ResManager.loadKDString((String)"\u662f", (String)"InitDataConst_369", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.isdependent", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u72ec\u7acb\u9700\u6c42\u8f6c\u76f8\u5173\u9700\u6c42", (String)"InitDataConst_715", (String)"mmc-mrp-common"), "entryentity.isdependent", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "3"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1019614403357585408L, "1MH1PT5YGBEE", "YS-REQ-003", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u6e05\u5355-\u9700\u6c42\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_185", (String)"mmc-mrp-common"), "pom_mftstock", "mrp_demandbill_model_inh", "0", entrys, appId);
        trsfSql.put("YS-REQ-003", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1078053504574057542L, 1, "", "", "", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5e93\u5b58\u7ec4\u7ec7", (String)"InitDataConst_186", (String)"mmc-mrp-common"), "org", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057544L, 2, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "material", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599", (String)"InitDataConst_187", (String)"mmc-mrp-common"), "material", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057545L, 3, "", "ABS( baseqty )", ResManager.loadKDString((String)"ABS( \u5e93\u5b58\u91cf\uff08\u57fa\u672c\u5355\u4f4d\uff09 )", (String)"InitDataConst_189", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.demandqty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_151", (String)"mmc-mrp-common"), "entryentity.demandqty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057546L, 4, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_190", (String)"mmc-mrp-common"), "baseunit", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057547L, 5, "", "NOW()", "NOW()", "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.billdate", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057548L, 6, "", "id", ResManager.loadKDString((String)"\u5373\u65f6\u5e93\u5b58\u4f59\u989d\u8868.\u5185\u7801", (String)"InitDataConst_192", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057551L, 7, "", "im_inv_realbalance.material.number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"InitDataConst_146", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.materialnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_147", (String)"mmc-mrp-common"), "entryentity.materialnumber", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1311589101002039296L, 8, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u914d\u7f6e\u53f7", (String)"InitDataConst_97", (String)"mmc-mrp-common"), "entryentity.configuredcode", "configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_98", (String)"mmc-mrp-common"), "configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1317940964743979008L, 9, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_182", (String)"mmc-mrp-common"), "entryentity.tracknumber", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_194", (String)"mmc-mrp-common"), "tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1392591726362755072L, 10, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_104", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "auxpty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_105", (String)"mmc-mrp-common"), "auxpty", "0"));
        entrys.add(new TrsfEntryParam(1782710025123358720L, 11, "", "", "", "entryentity.warehouse", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4ed3\u5e93", (String)"InitDataConst_533", (String)"mmc-mrp-common"), "entryentity.warehouse", "warehouse", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4ed3\u5e93", (String)"InitDataConst_318", (String)"mmc-mrp-common"), "warehouse", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1005802947428222976L, "1MH1PT5YGBEF", "YS-REQ-004", ResManager.getLocaleString((String)"\u8d1f\u5e93\u5b58-\u9700\u6c42\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_195", (String)"mmc-mrp-common"), "im_inv_realbalance", "mrp_demandbill_model_inh", "0", entrys, appId);
        trsfSql.put("YS-REQ-004", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1078053504574057564L, 1, "", "", "", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "orgsite", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_196", (String)"mmc-mrp-common"), "orgsite", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057565L, 2, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "materiel", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_154", (String)"mmc-mrp-common"), "materiel", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057566L, 3, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_155", (String)"mmc-mrp-common"), "baseunit", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057567L, 4, "", "", "", "entryentity.demandqty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_151", (String)"mmc-mrp-common"), "entryentity.demandqty", "matchqty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u65e5\u751f\u4ea7\u8ba1\u5212\u5339\u914d\u6570\u91cf", (String)"InitDataConst_197", (String)"mmc-mrp-common"), "matchqty", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057568L, 5, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.billdate", "fntime", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u51b2\u51cf\u65e5\u671f", (String)"InitDataConst_508", (String)"mmc-mrp-common"), "fntime", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057569L, 6, "", "id", ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u5206\u914d\u5173\u8054\u51b2\u51cf\u7ed3\u679c.\u5185\u7801", (String)"InitDataConst_199", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057570L, 7, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_137", (String)"mmc-mrp-common"), "entryentity.billnumber", "number", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9500\u552e\u8ba2\u5355\u53f7", (String)"InitDataConst_200", (String)"mmc-mrp-common"), "number", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057571L, 8, "", "", "", "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_144", (String)"mmc-mrp-common"), "entryentity.billentryseq", "orderseq", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u884c\u53f7", (String)"InitDataConst_201", (String)"mmc-mrp-common"), "orderseq", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057573L, 9, "", "\"ORDER\"", "\"ORDER\"", "entryentity.demandsourcetype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b", (String)"InitDataConst_148", (String)"mmc-mrp-common"), "entryentity.demandsourcetype", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1067478024938605568L, "1MH1PT5YGBEG", "YS-REQ-005", ResManager.getLocaleString((String)"\u9500\u552e\u8ba2\u5355\uff08\u51b2\u51cf\uff09-\u9700\u6c42\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_202", (String)"mmc-mrp-common"), "mds_dpsfnresult", "mrp_demandbill_model_inh", "0", entrys, appId);
        trsfSql.put("YS-REQ-005", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(975362581894052865L, 1, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "billentry.materialmasterid", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_203", (String)"mmc-mrp-common"), "billentry.materialmasterid", "0"));
        entrys.add(new TrsfEntryParam(975362581894052866L, 2, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.billdate", "billentry.reqdate", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_204", (String)"mmc-mrp-common"), "billentry.reqdate", "0"));
        entrys.add(new TrsfEntryParam(975362581894052867L, 3, "", "", "", "entryentity.demandqty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_151", (String)"mmc-mrp-common"), "entryentity.demandqty", "billentry.qty", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u6570\u91cf", (String)"InitDataConst_205", (String)"mmc-mrp-common"), "billentry.qty", "0"));
        entrys.add(new TrsfEntryParam(975362581894052868L, 4, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "billentry.baseunit", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_206", (String)"mmc-mrp-common"), "billentry.baseunit", "0"));
        entrys.add(new TrsfEntryParam(975362581894052869L, 5, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_137", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(975362581894052870L, 6, "", "id", ResManager.loadKDString((String)"\u9700\u6c42\u7533\u8bf7\u5355.\u5185\u7801", (String)"InitDataConst_208", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(975362581894052871L, 7, "", "billentry.id", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5185\u7801", (String)"InitDataConst_210", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_141", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(975362581894052872L, 8, "", "billentry.seq", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5e8f\u53f7", (String)"InitDataConst_212", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_144", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(975362581894052873L, 9, "", "", "", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_213", (String)"mmc-mrp-common"), "org", "0"));
        entrys.add(new TrsfEntryParam(1394022803644089344L, 10, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_104", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "billentry.auxpty", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_214", (String)"mmc-mrp-common"), "billentry.auxpty", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 973715393191398400L, "1MH1PT5YGBEH", "YS-REQ-006", ResManager.getLocaleString((String)"\u9700\u6c42\u7533\u8bf7\u5355-\u9700\u6c42\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_215", (String)"mmc-mrp-common"), "pm_requirapplybill", "mrp_demandbill_model_inh", "0", entrys, appId);
        trsfSql.put("YS-REQ-006", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1078053504574057562L, 1, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599", (String)"InitDataConst_216", (String)"mmc-mrp-common"), "entryentity.material", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057563L, 2, "{\"expression\":\"\\\"(@supplyData.#ISTOCK = 1 or @requireData.#MATERIALATTR = 10040) <> 1\\\"\",\"exprTran\":\"\\\"(@supplyData.#ISTOCK = 1 or @requireData.#MATERIALATTR = 10040) <> 1\\\"\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"\\\"(@supplyData.#ISTOCK = 1 or @requireData.#MATERIALATTR = 10040) <> 1\\\"\"},\"exprDesc\":\"\\\"(@supplyData.#ISTOCK = 1 or @requireData.#MATERIALATTR = 10040) <> 1\\\"\"}", "\"(@supplyData.#ISTOCK = 1 or @requireData.#MATERIALATTR = 10040) <> 1\"", "\"(@supplyData.#ISTOCK = 1 or @requireData.#MATERIALATTR = 10040) <> 1\"", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_217", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_36", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "4"));
        entrys.add(new TrsfEntryParam(1302334879404441600L, 3, "{\"expression\":\"\\\"@requireData.#IS_TRACK_MATCH  = 1 and @supplyData.#INV_IS_TRACK_MATCH = 1\\\"\",\"exprTran\":\"\\\"@requireData.#IS_TRACK_MATCH  = 1 and @supplyData.#INV_IS_TRACK_MATCH = 1\\\"\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"\\\"@requireData.#IS_TRACK_MATCH  = 1 and @supplyData.#INV_IS_TRACK_MATCH = 1\\\"\"},\"exprDesc\":\"\\\"@requireData.#IS_TRACK_MATCH  = 1 and @supplyData.#INV_IS_TRACK_MATCH = 1\\\"\"}", "\"@requireData.#IS_TRACK_MATCH  = 1 and @supplyData.#INV_IS_TRACK_MATCH = 1\"", "\"@requireData.#IS_TRACK_MATCH  = 1 and @supplyData.#INV_IS_TRACK_MATCH = 1\"", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_218", (String)"mmc-mrp-common"), "entryentity.tracknumber", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_182", (String)"mmc-mrp-common"), "entryentity.tracknumber", "4"));
        entrys.add(new TrsfEntryParam(1305785445300551680L, 4, "{\"expression\":\"\\\"@requireData.#CONFIGPROPERTIES = 2\\\"\",\"exprTran\":\"\\\"@requireData.#CONFIGPROPERTIES = 2\\\"\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"\\\"@requireData.#CONFIGPROPERTIES = 2\\\"\"},\"exprDesc\":\"\\\"@requireData.#CONFIGPROPERTIES = 2\\\"\"}", "\"@requireData.#CONFIGPROPERTIES = 2\"", "\"@requireData.#CONFIGPROPERTIES = 2\"", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u914d\u7f6e\u53f7", (String)"InitDataConst_219", (String)"mmc-mrp-common"), "entryentity.configuredcode", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u914d\u7f6e\u53f7", (String)"InitDataConst_97", (String)"mmc-mrp-common"), "entryentity.configuredcode", "4"));
        entrys.add(new TrsfEntryParam(1781836025618814976L, 5, "{\"expression\":\"\\\"@supplyData.#SUPPLY_STRATEGY= 'C'\\\"\",\"exprTran\":\"\\\"@supplyData.#SUPPLY_STRATEGY= 'C'\\\"\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"\\\"@supplyData.#SUPPLY_STRATEGY= 'C'\\\"\"},\"exprDesc\":\"\\\"@supplyData.#SUPPLY_STRATEGY= 'C'\\\"\"}", "\"@supplyData.#SUPPLY_STRATEGY= 'C'\"", "\"@supplyData.#SUPPLY_STRATEGY= 'C'\"", "entryentity.requireorg", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_549", (String)"mmc-mrp-common"), "entryentity.requireorg", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "4"));
        entrys.add(new TrsfEntryParam(1781836025618814977L, 6, "", "", "", "entryentity.planscope", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ba1\u5212\u8303\u56f4", (String)"InitDataConst_614", (String)"mmc-mrp-common"), "entryentity.planscope", "entryentity.planscope", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ba1\u5212\u8303\u56f4", (String)"InitDataConst_621", (String)"mmc-mrp-common"), "entryentity.planscope", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1078041234464837632L, "1MH1PT5YGBEI", "YS-REQ-SUP", ResManager.getLocaleString((String)"\u9700\u6c42\u5355\u636e-\u4f9b\u5e94\u5355\u636e\u5b57\u6bb5\u6620\u5c04\uff08\u591a\u7ec4\u7ec7\uff09", (String)"InitDataConst_220", (String)"mmc-mrp-common"), "mrp_demandbill_model_inh", "mrp_supply_model_inh", "1", entrys, appId);
        trsfSql.put("YS-REQ-SUP", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1977651620258892800L, 1, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599", (String)"InitDataConst_216", (String)"mmc-mrp-common"), "entryentity.material", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "0"));
        entrys.add(new TrsfEntryParam(1977651620258892801L, 2, "{\"expression\":\"\\\"@supplyData.#ISTOCK <> 1\\\"\",\"exprTran\":\"\\\"@supplyData.#ISTOCK <> 1\\\"\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"\\\"@supplyData.#ISTOCK <> 1\\\"\"},\"exprDesc\":\"\\\"@supplyData.#ISTOCK <> 1\\\"\"}", "\"@supplyData.#ISTOCK <> 1\"", "\"@supplyData.#ISTOCK <> 1\"", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_217", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_36", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "4"));
        entrys.add(new TrsfEntryParam(1977651620258892802L, 3, "{\"expression\":\"\\\"@requireData.#IS_TRACK_MATCH  = 1 and @supplyData.#INV_IS_TRACK_MATCH = 1\\\"\",\"exprTran\":\"\\\"@requireData.#IS_TRACK_MATCH  = 1 and @supplyData.#INV_IS_TRACK_MATCH = 1\\\"\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"\\\"@requireData.#IS_TRACK_MATCH  = 1 and @supplyData.#INV_IS_TRACK_MATCH = 1\\\"\"},\"exprDesc\":\"\\\"@requireData.#IS_TRACK_MATCH  = 1 and @supplyData.#INV_IS_TRACK_MATCH = 1\\\"\"}", "\"@requireData.#IS_TRACK_MATCH  = 1 and @supplyData.#INV_IS_TRACK_MATCH = 1\"", "\"@requireData.#IS_TRACK_MATCH  = 1 and @supplyData.#INV_IS_TRACK_MATCH = 1\"", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_218", (String)"mmc-mrp-common"), "entryentity.tracknumber", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_182", (String)"mmc-mrp-common"), "entryentity.tracknumber", "4"));
        entrys.add(new TrsfEntryParam(1977651620258892803L, 4, "{\"expression\":\"\\\"@requireData.#CONFIGPROPERTIES = 2\\\"\",\"exprTran\":\"\\\"@requireData.#CONFIGPROPERTIES = 2\\\"\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"\\\"@requireData.#CONFIGPROPERTIES = 2\\\"\"},\"exprDesc\":\"\\\"@requireData.#CONFIGPROPERTIES = 2\\\"\"}", "\"@requireData.#CONFIGPROPERTIES = 2\"", "\"@requireData.#CONFIGPROPERTIES = 2\"", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u914d\u7f6e\u53f7", (String)"InitDataConst_219", (String)"mmc-mrp-common"), "entryentity.configuredcode", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u914d\u7f6e\u53f7", (String)"InitDataConst_97", (String)"mmc-mrp-common"), "entryentity.configuredcode", "4"));
        entrys.add(new TrsfEntryParam(1977651620258892804L, 5, "{\"expression\":\"\\\"@supplyData.#SUPPLY_STRATEGY= 'C'\\\"\",\"exprTran\":\"\\\"@supplyData.#SUPPLY_STRATEGY= 'C'\\\"\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"\\\"@supplyData.#SUPPLY_STRATEGY= 'C'\\\"\"},\"exprDesc\":\"\\\"@supplyData.#SUPPLY_STRATEGY= 'C'\\\"\"}", "\"@supplyData.#SUPPLY_STRATEGY= 'C'\"", "\"@supplyData.#SUPPLY_STRATEGY= 'C'\"", "entryentity.requireorg", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_549", (String)"mmc-mrp-common"), "entryentity.requireorg", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "4"));
        entrys.add(new TrsfEntryParam(1977651620258892805L, 6, "", "", "", "entryentity.planscope", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ba1\u5212\u8303\u56f4", (String)"InitDataConst_614", (String)"mmc-mrp-common"), "entryentity.planscope", "entryentity.planscope", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ba1\u5212\u8303\u56f4", (String)"InitDataConst_621", (String)"mmc-mrp-common"), "entryentity.planscope", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1977651619982068736L, "46XQPIJ9/482", "YS-REQ-SUP_SINGLE_ORG", ResManager.getLocaleString((String)"\u9700\u6c42\u5355\u636e-\u4f9b\u5e94\u5355\u636e\u5b57\u6bb5\u6620\u5c04\uff08\u5355\u7ec4\u7ec7\uff09", (String)"InitDataConst_760", (String)"mmc-mrp-common"), "mrp_demandbill_model_inh", "mrp_supply_model_inh", "1", entrys, appId);
        trsfSql.put("YS-REQ-SUP_SINGLE_ORG", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1247202796327980032L, 1, String.format("{\"items\":[{\"id\":\"3KM/BC=NGB7Y\",\"seq\":1,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3KM/=CNQINMX\",\"leftBracket\":\"\",\"compareType\":\"37\",\"fieldName\":\"supplyorgid.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KM/=CNQJDKY\",\"value\":\"\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3KM/=CNQINMX\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"37\\\",\\\"fieldName\\\":\\\"supplyorgid.number\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3KM/=CNQJDKY\\\",\\\"value\\\":\\\"\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"org\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"select\":\"ByCondition\"},{\"id\":\"3KM/BC=NH25Z\",\"seq\":2,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3KM/APOQDGJ6\",\"leftBracket\":\"\",\"compareType\":\"9\",\"fieldName\":\"supplyorgid.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KM/APOQE7H7\",\"value\":\"\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3KM/APOQDGJ6\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"9\\\",\\\"fieldName\\\":\\\"supplyorgid.number\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3KM/APOQE7H7\\\",\\\"value\\\":\\\"\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"stockentry.supplyorgid\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"select\":\"ByCondition\"}],\"description\":\"%s\\\\%s\"}", ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7.\u7f16\u7801 \u4e3a\u7a7a", (String)"InitDataConst_776", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7.\u7f16\u7801 \u4e3a\u7a7a", (String)"InitDataConst_776", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7.\u7f16\u7801 \u4e3a\u7a7a", (String)"InitDataConst_776", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7.\u7f16\u7801 \u4e0d\u4e3a\u7a7a", (String)"InitDataConst_778", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7.\u7f16\u7801 \u4e0d\u4e3a\u7a7a", (String)"InitDataConst_778", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7.\u7f16\u7801 \u4e0d\u4e3a\u7a7a", (String)"InitDataConst_778", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7", (String)"InitDataConst_779", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7", (String)"InitDataConst_779", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7", (String)"InitDataConst_779", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7", (String)"InitDataConst_779", (String)"mmc-mrp-common", (Object[])new Object[0])), "org", ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\\\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7", (String)"InitDataConst_653", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "2"));
        entrys.add(new TrsfEntryParam(1247202796327980033L, 2, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "stockentry.materielmasterid", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u7269\u6599(\u4e3b\u6570\u636e)", (String)"InitDataConst_221", (String)"mmc-mrp-common"), "stockentry.materielmasterid", "0"));
        entrys.add(new TrsfEntryParam(1247202796327980034L, 3, "", "id", ResManager.loadKDString((String)"\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355.\u5185\u7801", (String)"InitDataConst_223", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1247202796327980035L, 4, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_137", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1247202796327980036L, 5, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.billdate", "stockentry.demanddate", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_224", (String)"mmc-mrp-common"), "stockentry.demanddate", "0"));
        entrys.add(new TrsfEntryParam(1247202796327980037L, 6, "", "", "", "entryentity.demandqty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_151", (String)"mmc-mrp-common"), "entryentity.demandqty", "stockentry.cansendqty", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u53ef\u53d1\u6570\u91cf", (String)"InitDataConst_225", (String)"mmc-mrp-common"), "stockentry.cansendqty", "0"));
        entrys.add(new TrsfEntryParam(1247202796327980038L, 7, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "stockentry.materialunitid", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_226", (String)"mmc-mrp-common"), "stockentry.materialunitid", "0"));
        entrys.add(new TrsfEntryParam(1247202796327980039L, 8, "", "stockentry.id", ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u5185\u7801", (String)"InitDataConst_228", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_141", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1247202796327980040L, 9, "", "stockentry.seq", ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u5e8f\u53f7", (String)"InitDataConst_230", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_144", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1305662133274535936L, 10, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u914d\u7f6e\u53f7", (String)"InitDataConst_97", (String)"mmc-mrp-common"), "entryentity.configuredcode", "stockentry.entryconfiguredcode", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u7ec4\u4ef6\u914d\u7f6e\u53f7", (String)"InitDataConst_181", (String)"mmc-mrp-common"), "stockentry.entryconfiguredcode", "0"));
        entrys.add(new TrsfEntryParam(1305820865476374528L, 11, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_182", (String)"mmc-mrp-common"), "entryentity.tracknumber", "orderentryid.tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u59d4\u5916\u5de5\u5355\u884c\u53f7.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_231", (String)"mmc-mrp-common"), "orderentryid.tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1392596270991803392L, 12, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_104", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "stockentry.childauxpropertyid", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_184", (String)"mmc-mrp-common"), "stockentry.childauxpropertyid", "0"));
        entrys.add(new TrsfEntryParam(1779835695838276608L, 13, "", "", "", "entryentity.warehouse", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4ed3\u5e93", (String)"InitDataConst_533", (String)"mmc-mrp-common"), "entryentity.warehouse", "stockentry.warehouseid", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u660e\u7ec6.\u4f9b\u8d27\u4ed3\u5e93", (String)"InitDataConst_534", (String)"mmc-mrp-common"), "stockentry.warehouseid", "0"));
        entrys.add(new TrsfEntryParam(1873237127915956224L, 14, "", "orderentryid", ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u884c\u53f7", (String)"InitDataConst_724", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.supplybillid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u4f9b\u5e94\u5355\u636e\u5185\u7801", (String)"InitDataConst_713", (String)"mmc-mrp-common"), "entryentity.supplybillid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1873237127915956225L, 15, "", "", "", "entryentity.product", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4ea7\u54c1\u7269\u6599", (String)"InitDataConst_714", (String)"mmc-mrp-common"), "entryentity.product", "productmasterid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4ea7\u54c1(\u4e3b\u6570\u636e)", (String)"InitDataConst_718", (String)"mmc-mrp-common"), "productmasterid", "0"));
        entrys.add(new TrsfEntryParam(1873237127915956226L, 16, "", "1", ResManager.loadKDString((String)"\u662f", (String)"InitDataConst_369", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.isdependent", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u72ec\u7acb\u9700\u6c42\u8f6c\u76f8\u5173\u9700\u6c42", (String)"InitDataConst_715", (String)"mmc-mrp-common"), "entryentity.isdependent", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "3"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1247202796302814208L, "1XL8RUFJKWOB", "YS-REQ-008", ResManager.getLocaleString((String)"\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355-\u9700\u6c42\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_232", (String)"mmc-mrp-common"), "om_mftstock", "mrp_demandbill_model_inh", "0", entrys, appId);
        trsfSql.put("YS-REQ-008", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1181114676109396992L, 1, String.format("{\"items\":[{\"id\":\"3KLXZONTFU/M\",\"seq\":1,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3KLXWVD15382\",\"leftBracket\":\"\",\"compareType\":\"37\",\"fieldName\":\"entrysupplyorgunitid.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLXWVD4RSGK\",\"value\":\"\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3KLXWVD15382\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"37\\\",\\\"fieldName\\\":\\\"entrysupplyorgunitid.number\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3KLXWVD4RSGK\\\",\\\"value\\\":\\\"\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"proorpurorg\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"select\":\"ByCondition\"},{\"id\":\"3KLXZONTF21L\",\"seq\":2,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3KLXY5R3C2D=\",\"leftBracket\":\"\",\"compareType\":\"9\",\"fieldName\":\"entrysupplyorgunitid.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLXY5R3BBF9\",\"value\":\"\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3KLXY5R3C2D=\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"9\\\",\\\"fieldName\\\":\\\"entrysupplyorgunitid.number\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3KLXY5R3BBF9\\\",\\\"value\\\":\\\"\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"entryentity.entrysupplyorgunitid\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"select\":\"ByCondition\"}],\"description\":\"%s\\\\%s\"}", ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u4f9b\u8d27\u7ec4\u7ec7.\u7f16\u7801 \u4e3a\u7a7a", (String)"InitDataConst_780", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u4f9b\u8d27\u7ec4\u7ec7.\u7f16\u7801 \u4e3a\u7a7a", (String)"InitDataConst_780", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u4f9b\u8d27\u7ec4\u7ec7.\u7f16\u7801 \u4e3a\u7a7a", (String)"InitDataConst_780", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_391", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_391", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_391", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u4f9b\u8d27\u7ec4\u7ec7.\u7f16\u7801 \u4e0d\u4e3a\u7a7a", (String)"InitDataConst_781", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u4f9b\u8d27\u7ec4\u7ec7.\u7f16\u7801 \u4e0d\u4e3a\u7a7a", (String)"InitDataConst_781", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u4f9b\u8d27\u7ec4\u7ec7.\u7f16\u7801 \u4e0d\u4e3a\u7a7a", (String)"InitDataConst_781", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u8d27\u7ec4\u7ec7", (String)"InitDataConst_782", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u8d27\u7ec4\u7ec7", (String)"InitDataConst_782", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u8d27\u7ec4\u7ec7", (String)"InitDataConst_782", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_391", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u8d27\u7ec4\u7ec7", (String)"InitDataConst_782", (String)"mmc-mrp-common", (Object[])new Object[0])), "proorpurorg", ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\\\u4f9b\u8d27\u7ec4\u7ec7", (String)"InitDataConst_670", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "2"));
        entrys.add(new TrsfEntryParam(1181114676109396993L, 2, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "entryentity.entrymaterial", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7ec4\u4ef6\u7f16\u7801", (String)"InitDataConst_233", (String)"mmc-mrp-common"), "entryentity.entrymaterial", "0"));
        entrys.add(new TrsfEntryParam(1181114676109396994L, 3, "", "id", ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355.\u5185\u7801", (String)"InitDataConst_235", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1181114676109396995L, 4, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "entryentity.entryunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_55", (String)"mmc-mrp-common"), "entryentity.entryunit", "0"));
        entrys.add(new TrsfEntryParam(1181114676109396996L, 5, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_137", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1181114676109396997L, 6, "", "entryentity.id", ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u5185\u7801", (String)"InitDataConst_176", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_141", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1181114676109396998L, 7, "", "entryentity.seq", ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u5e8f\u53f7", (String)"InitDataConst_178", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_144", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1181114676109396999L, 8, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.billdate", "entryentity.entryrequiredate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.entryrequiredate", "0"));
        entrys.add(new TrsfEntryParam(1181114676109397000L, 9, "", "entryentity.entryrequireqty -  entryentity.entrydroprequireqty ", ResManager.loadKDString((String)"\u9700\u6c42\u6570\u91cf -  \u5df2\u6295\u653e\u9700\u6c42\u6570\u91cf", (String)"InitDataConst_239", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.demandqty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_151", (String)"mmc-mrp-common"), "entryentity.demandqty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1305666352752748544L, 10, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u914d\u7f6e\u53f7", (String)"InitDataConst_97", (String)"mmc-mrp-common"), "entryentity.configuredcode", "entryentity.entryconfiguredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u914d\u7f6e\u53f7", (String)"InitDataConst_97", (String)"mmc-mrp-common"), "entryentity.entryconfiguredcode", "0"));
        entrys.add(new TrsfEntryParam(1305666352752748545L, 11, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_182", (String)"mmc-mrp-common"), "entryentity.tracknumber", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_194", (String)"mmc-mrp-common"), "tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1392613401384976384L, 12, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_104", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "entryentity.entryauxproperty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_240", (String)"mmc-mrp-common"), "entryentity.entryauxproperty", "0"));
        entrys.add(new TrsfEntryParam(1779816228831898624L, 13, "", "", "", "entryentity.warehouse", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4ed3\u5e93", (String)"InitDataConst_533", (String)"mmc-mrp-common"), "entryentity.warehouse", "entryentity.entrywarehouse", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4f9b\u8d27\u4ed3\u5e93", (String)"InitDataConst_608", (String)"mmc-mrp-common"), "entryentity.entrywarehouse", "0"));
        entrys.add(new TrsfEntryParam(1873235877098961920L, 14, "", "id", ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355.\u5185\u7801", (String)"InitDataConst_235", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.supplybillid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u4f9b\u5e94\u5355\u636e\u5185\u7801", (String)"InitDataConst_713", (String)"mmc-mrp-common"), "entryentity.supplybillid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1873235877098961921L, 15, "", "", "", "entryentity.product", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4ea7\u54c1\u7269\u6599", (String)"InitDataConst_714", (String)"mmc-mrp-common"), "entryentity.product", "material", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_154", (String)"mmc-mrp-common"), "material", "0"));
        entrys.add(new TrsfEntryParam(1873235877098961922L, 16, "", "1", ResManager.loadKDString((String)"\u662f", (String)"InitDataConst_369", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.isdependent", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u72ec\u7acb\u9700\u6c42\u8f6c\u76f8\u5173\u9700\u6c42", (String)"InitDataConst_715", (String)"mmc-mrp-common"), "entryentity.isdependent", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "3"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1181114675790629888L, "1PLKVB05DXS0", "YS-REQ-007", ResManager.getLocaleString((String)"\u8ba1\u5212\u8ba2\u5355\u5206\u5f55-\u9700\u6c42\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_241", (String)"mmc-mrp-common"), "mrp_planorder", "mrp_demandbill_model_inh", "0", entrys, appId);
        trsfSql.put("YS-REQ-007", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1313064180315651072L, 1, "", "", "", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_213", (String)"mmc-mrp-common"), "org", "0"));
        entrys.add(new TrsfEntryParam(1313064180315651074L, 3, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "materiel", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_154", (String)"mmc-mrp-common"), "materiel", "0"));
        entrys.add(new TrsfEntryParam(1313064180315651075L, 4, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u914d\u7f6e\u53f7", (String)"InitDataConst_97", (String)"mmc-mrp-common"), "entryentity.configuredcode", "configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_98", (String)"mmc-mrp-common"), "configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1313064180315651076L, 5, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_242", (String)"mmc-mrp-common"), "baseunit", "0"));
        entrys.add(new TrsfEntryParam(1313064180315651077L, 6, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.billdate", "demanddate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_243", (String)"mmc-mrp-common"), "demanddate", "0"));
        entrys.add(new TrsfEntryParam(1313064180315651078L, 7, "", "demandqty - transferqty", ResManager.loadKDString((String)"\u9700\u6c42\u57fa\u672c\u6570\u91cf - \u5df2\u8c03\u62e8\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_520", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.demandqty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_151", (String)"mmc-mrp-common"), "entryentity.demandqty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1313064180315651079L, 8, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_182", (String)"mmc-mrp-common"), "entryentity.tracknumber", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_194", (String)"mmc-mrp-common"), "tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1313064180315651080L, 9, "", "id", ResManager.loadKDString((String)"\u534f\u540c\u8ba1\u5212\u8ba2\u5355.\u5185\u7801", (String)"InitDataConst_246", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1313064180315651081L, 10, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_137", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1394030565321080832L, 11, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_104", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "auxproperty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_105", (String)"mmc-mrp-common"), "auxproperty", "0"));
        entrys.add(new TrsfEntryParam(1779840231181134848L, 12, "", "", "", "entryentity.warehouse", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4ed3\u5e93", (String)"InitDataConst_533", (String)"mmc-mrp-common"), "entryentity.warehouse", "supplywarehouse", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4f9b\u8d27\u4ed3\u5e93", (String)"InitDataConst_612", (String)"mmc-mrp-common"), "supplywarehouse", "0"));
        entrys.add(new TrsfEntryParam(1916055551381347328L, 13, "", "", "", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_36", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "supplyorg", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_36", (String)"mmc-mrp-common"), "supplyorg", "0"));
        entrys.add(new TrsfEntryParam(1916055551381347329L, 14, "", "", "", "entryentity.demand_supply_strategy", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u4f9b\u5e94\u89c4\u5219", (String)"InitDataConst_728", (String)"mmc-mrp-common"), "entryentity.demand_supply_strategy", "supplyrule", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4f9b\u5e94\u89c4\u5219", (String)"InitDataConst_617", (String)"mmc-mrp-common"), "supplyrule", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1313064178679872512L, "250=70PZA9WR", "YS-REQ-009", ResManager.getLocaleString((String)"\u534f\u540c\u8ba1\u5212\u8ba2\u5355-\u9700\u6c42\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_247", (String)"mmc-mrp-common"), "mrp_collaborativeorder", "mrp_demandbill_model_inh", "0", entrys, appId);
        trsfSql.put("YS-REQ-009", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1228983485348186112L, 1, "", "", "", "org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_213", (String)"mmc-mrp-common"), "org", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "0"));
        entrys.add(new TrsfEntryParam(1228983485348186113L, 2, "", "", "", "proorpurorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_196", (String)"mmc-mrp-common"), "proorpurorg", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_36", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "0"));
        entrys.add(new TrsfEntryParam(1228983485348186114L, 3, "", "", "", "material", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_154", (String)"mmc-mrp-common"), "material", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "0"));
        entrys.add(new TrsfEntryParam(1228983485348186116L, 4, "", "", "", "unit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_155", (String)"mmc-mrp-common"), "unit", "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "0"));
        entrys.add(new TrsfEntryParam(1228983485348186117L, 5, "", "", "", "availabledate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u53ef\u7528\u65e5\u671f", (String)"InitDataConst_356", (String)"mmc-mrp-common"), "availabledate", "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u65e5\u671f", (String)"InitDataConst_249", (String)"mmc-mrp-common"), "entryentity.billdate", "0"));
        entrys.add(new TrsfEntryParam(1228983485348186118L, 6, "", "", "", "demandbill", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u5355\u636e\u7f16\u7801", (String)"InitDataConst_250", (String)"mmc-mrp-common"), "demandbill", "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_137", (String)"mmc-mrp-common"), "entryentity.billnumber", "0"));
        entrys.add(new TrsfEntryParam(1228983485348186119L, 7, "", "", "", "demandseq", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_251", (String)"mmc-mrp-common"), "demandseq", "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_144", (String)"mmc-mrp-common"), "entryentity.billentryseq", "0"));
        entrys.add(new TrsfEntryParam(1228983485348186120L, 8, "", "", "", "demandbillid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u5355\u636eID", (String)"InitDataConst_252", (String)"mmc-mrp-common"), "demandbillid", "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "0"));
        entrys.add(new TrsfEntryParam(1228983485348186121L, 9, "", "", "", "demandbillentryid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_253", (String)"mmc-mrp-common"), "demandbillentryid", "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_141", (String)"mmc-mrp-common"), "entryentity.billentryid", "0"));
        entrys.add(new TrsfEntryParam(1392616420730209280L, 10, "", "", "", "auxproperty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_105", (String)"mmc-mrp-common"), "auxproperty", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_104", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "0"));
        entrys.add(new TrsfEntryParam(1997205246849331200L, 11, String.format("{\"items\":[{\"id\":\"49B4J4Z63+ZX\",\"seq\":1,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"49B4GJ32U/56\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"demandsourcetype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"49B4GJ32U/UF\",\"value\":\"ID\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"49B4GJ32U/56\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"demandsourcetype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"49B4GJ32U/UF\\\",\\\"value\\\":\\\"ID\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"exprDesc\":\"%s\",\"localeExprTran\":{\"zh_CN\":\"%s\"}},\"formula\":{\"expression\":\"entryentity.allowdrop\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"%s\",\"localeExprTran\":{\"zh_CN\":\"%s\"}},\"select\":\"ByCondition\"},{\"id\":\"49B4J4Z9QEUO\",\"seq\":2,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"49B4IA1VWM42\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"demandsourcetype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"49B4IA1VWMTB\",\"value\":\"ID\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"49B4IA1VWM42\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"demandsourcetype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"49B4IA1VWMTB\\\",\\\"value\\\":\\\"ID\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"exprDesc\":\"%s\",\"localeExprTran\":{\"zh_CN\":\"%s\"}},\"formula\":{\"expression\":\"'1'\",\"exprTran\":\"'1'\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"'1'\",\"localeExprTran\":{\"zh_CN\":\"'1'\"}},\"select\":\"ByCondition\"}],\"description\":\"%s\\\\'1'\"}", ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b \u7b49\u4e8e ID", (String)"InitDataConst_783", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b \u7b49\u4e8e ID", (String)"InitDataConst_783", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b \u7b49\u4e8e ID", (String)"InitDataConst_783", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u5141\u8bb8\u6295\u653e", (String)"InitDataConst_784", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u5141\u8bb8\u6295\u653e", (String)"InitDataConst_784", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u5141\u8bb8\u6295\u653e", (String)"InitDataConst_784", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b \u4e0d\u7b49\u4e8e ID", (String)"InitDataConst_785", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b \u4e0d\u7b49\u4e8e ID", (String)"InitDataConst_785", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b \u4e0d\u7b49\u4e8e ID", (String)"InitDataConst_785", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u5141\u8bb8\u6295\u653e", (String)"InitDataConst_784", (String)"mmc-mrp-common", (Object[])new Object[0])), "entryentity.allowdrop", ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u5141\u8bb8\u6295\u653e\\'1'", (String)"InitDataConst_767", (String)"mmc-mrp-common", (Object[])new Object[0]), "allowdrop", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5141\u8bb8\u6295\u653e", (String)"InitDataConst_730", (String)"mmc-mrp-common"), "allowdrop", " ", MulLangTableDataInitUtil.string2LocaleString(" "), " ", "2"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1228983485314631680L, "1UYY9MC+C7QJ", "YS-REQ-Planorder", ResManager.getLocaleString((String)"\u9700\u6c42\u5355\u636e-\u8ba1\u5212\u8ba2\u5355\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_254", (String)"mmc-mrp-common"), "mrp_demandbill_model_inh", "mrp_planorder", "0", entrys, appId);
        trsfSql.put("YS-REQ-Planorder", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1448552481897333760L, 1, "", "", "", "org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_213", (String)"mmc-mrp-common"), "org", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "0"));
        entrys.add(new TrsfEntryParam(1448552481897333761L, 2, "", "", "", "proorpurorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_196", (String)"mmc-mrp-common"), "proorpurorg", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_36", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "0"));
        entrys.add(new TrsfEntryParam(1448552481897333762L, 3, "", "", "", "material", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_154", (String)"mmc-mrp-common"), "material", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "0"));
        entrys.add(new TrsfEntryParam(1448552481897333763L, 4, "", "", "", "unit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_155", (String)"mmc-mrp-common"), "unit", "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "0"));
        entrys.add(new TrsfEntryParam(1448552481897333764L, 5, "", "", "", "availabledate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u53ef\u7528\u65e5\u671f", (String)"InitDataConst_356", (String)"mmc-mrp-common"), "availabledate", "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.billdate", "0"));
        entrys.add(new TrsfEntryParam(1448552481897333765L, 6, "", "", "", "demandbill", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u5355\u636e\u7f16\u7801", (String)"InitDataConst_250", (String)"mmc-mrp-common"), "demandbill", "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_137", (String)"mmc-mrp-common"), "entryentity.billnumber", "0"));
        entrys.add(new TrsfEntryParam(1448552481897333766L, 7, "", "", "", "demandseq", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_251", (String)"mmc-mrp-common"), "demandseq", "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_144", (String)"mmc-mrp-common"), "entryentity.billentryseq", "0"));
        entrys.add(new TrsfEntryParam(1448552481897333767L, 8, "", "", "", "demandbillid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u5355\u636eID", (String)"InitDataConst_252", (String)"mmc-mrp-common"), "demandbillid", "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "0"));
        entrys.add(new TrsfEntryParam(1448552481897333768L, 9, "", "", "", "demandbillentryid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_253", (String)"mmc-mrp-common"), "demandbillentryid", "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_141", (String)"mmc-mrp-common"), "entryentity.billentryid", "0"));
        entrys.add(new TrsfEntryParam(1448552481897333769L, 10, "", "", "", "auxproperty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_105", (String)"mmc-mrp-common"), "auxproperty", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_104", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "0"));
        entrys.add(new TrsfEntryParam(1997356871802997760L, 11, String.format("{\"items\":[{\"id\":\"49B4J4Z63+ZX\",\"seq\":1,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"49B4GJ32U/56\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"demandsourcetype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"49B4GJ32U/UF\",\"value\":\"ID\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"49B4GJ32U/56\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"demandsourcetype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"49B4GJ32U/UF\\\",\\\"value\\\":\\\"ID\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"exprDesc\":\"%s\",\"localeExprTran\":{\"zh_CN\":\"%s\"}},\"formula\":{\"expression\":\"entryentity.allowdrop\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"%s\",\"localeExprTran\":{\"zh_CN\":\"%s\"}},\"select\":\"ByCondition\"},{\"id\":\"49B4J4Z9QEUO\",\"seq\":2,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"49B4IA1VWM42\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"demandsourcetype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"49B4IA1VWMTB\",\"value\":\"ID\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"49B4IA1VWM42\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"demandsourcetype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"49B4IA1VWMTB\\\",\\\"value\\\":\\\"ID\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"exprDesc\":\"%s\",\"localeExprTran\":{\"zh_CN\":\"%s\"}},\"formula\":{\"expression\":\"'1'\",\"exprTran\":\"'1'\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"'1'\",\"localeExprTran\":{\"zh_CN\":\"'1'\"}},\"select\":\"ByCondition\"}],\"description\":\"%s\\\\'1'\"}", ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b \u7b49\u4e8e ID", (String)"InitDataConst_783", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b \u7b49\u4e8e ID", (String)"InitDataConst_783", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b \u7b49\u4e8e ID", (String)"InitDataConst_783", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u5141\u8bb8\u6295\u653e", (String)"InitDataConst_784", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u5141\u8bb8\u6295\u653e", (String)"InitDataConst_784", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u5141\u8bb8\u6295\u653e", (String)"InitDataConst_784", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b \u4e0d\u7b49\u4e8e ID", (String)"InitDataConst_785", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b \u4e0d\u7b49\u4e8e ID", (String)"InitDataConst_785", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b \u4e0d\u7b49\u4e8e ID", (String)"InitDataConst_785", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u5141\u8bb8\u6295\u653e", (String)"InitDataConst_784", (String)"mmc-mrp-common", (Object[])new Object[0])), "entryentity.allowdrop", ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u5141\u8bb8\u6295\u653e\\'1'", (String)"InitDataConst_767", (String)"mmc-mrp-common", (Object[])new Object[0]), "allowdrop", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5141\u8bb8\u6295\u653e", (String)"InitDataConst_730", (String)"mmc-mrp-common"), "allowdrop", " ", MulLangTableDataInitUtil.string2LocaleString(" "), " ", "2"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1448552481838612480L, "2IXVT4U6I=VC", "YS-REQ-SPPlanorder", ResManager.getLocaleString((String)"\u9700\u6c42\u5355\u636e-\u6a21\u62df\u8ba1\u5212\u8ba2\u5355\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_255", (String)"mmc-mrp-common"), "mrp_demandbill_model_inh", "mrp_simulateorder", "0", entrys, appId);
        trsfSql.put("YS-REQ-SPPlanorder", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1463618556880087040L, 1, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "entryentity.material", ResManager.getLocaleString((String)"\u6a21\u62df\u6982\u8981.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_256", (String)"mmc-mrp-common"), "entryentity.material", "0"));
        entrys.add(new TrsfEntryParam(1463618556880087041L, 2, "", "id", ResManager.loadKDString((String)"\u6a21\u62df\u8ba1\u5212.\u5185\u7801", (String)"InitDataConst_258", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1463618556880087042L, 3, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.billdate", "entryentity.requiredate", ResManager.getLocaleString((String)"\u6a21\u62df\u6982\u8981.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_259", (String)"mmc-mrp-common"), "entryentity.requiredate", "0"));
        entrys.add(new TrsfEntryParam(1463618556880087043L, 4, "", "", "", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "entryentity.requireorg", ResManager.getLocaleString((String)"\u6a21\u62df\u6982\u8981.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_260", (String)"mmc-mrp-common"), "entryentity.requireorg", "0"));
        entrys.add(new TrsfEntryParam(1463618556880087044L, 5, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_137", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6a21\u62df\u7f16\u53f7", (String)"InitDataConst_261", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1463618556880087045L, 6, "", "", "", "entryentity.demandqty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_151", (String)"mmc-mrp-common"), "entryentity.demandqty", "entryentity.qty", ResManager.getLocaleString((String)"\u6a21\u62df\u6982\u8981.\u6570\u91cf", (String)"InitDataConst_262", (String)"mmc-mrp-common"), "entryentity.qty", "0"));
        entrys.add(new TrsfEntryParam(1463618556880087046L, 7, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "entryentity.unit", ResManager.getLocaleString((String)"\u6a21\u62df\u6982\u8981.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_263", (String)"mmc-mrp-common"), "entryentity.unit", "0"));
        entrys.add(new TrsfEntryParam(1463627567528503296L, 8, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u914d\u7f6e\u53f7", (String)"InitDataConst_97", (String)"mmc-mrp-common"), "entryentity.configuredcode", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u6a21\u62df\u6982\u8981.\u914d\u7f6e\u53f7", (String)"InitDataConst_264", (String)"mmc-mrp-common"), "entryentity.configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1463627567528503297L, 9, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_104", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "entryentity.auxpty", ResManager.getLocaleString((String)"\u6a21\u62df\u6982\u8981.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_265", (String)"mmc-mrp-common"), "entryentity.auxpty", "0"));
        entrys.add(new TrsfEntryParam(1463627567528503298L, 10, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_182", (String)"mmc-mrp-common"), "entryentity.tracknumber", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u6a21\u62df\u6982\u8981.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_266", (String)"mmc-mrp-common"), "entryentity.tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1463660078694443008L, 11, "", "entryentity.seq", ResManager.loadKDString((String)"\u6a21\u62df\u6982\u8981.\u5e8f\u53f7", (String)"InitDataConst_268", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_144", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1463660078694443009L, 12, "", "entryentity.id", ResManager.loadKDString((String)"\u6a21\u62df\u6982\u8981.\u5185\u7801", (String)"InitDataConst_270", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_141", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1463618556829632512L, "2KS0UCUBVQBN", "SP-MN-REQ", ResManager.getLocaleString((String)"\u6a21\u62df\u8ba1\u5212\u624b\u5de5\u5f55\u5165-\u9700\u6c42\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_271", (String)"mmc-mrp-common"), "mrp_simulation", "mrp_demandbill_model_inh", "0", entrys, appId);
        trsfSql.put("SP-MN-REQ", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1393295046702303232L, 1, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_137", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1393295046702303233L, 2, "", "", "", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "billentry.e_stockorg", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u53d1\u8d27\u7ec4\u7ec7", (String)"InitDataConst_272", (String)"mmc-mrp-common"), "billentry.e_stockorg", "0"));
        entrys.add(new TrsfEntryParam(1393295046702303234L, 3, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "billentry.materialmasterid", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u7269\u6599", (String)"InitDataConst_273", (String)"mmc-mrp-common"), "billentry.materialmasterid", "0"));
        entrys.add(new TrsfEntryParam(1393295046702303235L, 4, "", "id", ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355.\u5185\u7801", (String)"InitDataConst_275", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1393295046702303236L, 5, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.billdate", "billentry.deliverydate", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u53d1\u8d27\u65e5\u671f", (String)"InitDataConst_276", (String)"mmc-mrp-common"), "billentry.deliverydate", "0"));
        entrys.add(new TrsfEntryParam(1393295046702303237L, 6, "", "", "", "entryentity.billtype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_277", (String)"mmc-mrp-common"), "entryentity.billtype", "billtype", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_278", (String)"mmc-mrp-common"), "billtype", "0"));
        entrys.add(new TrsfEntryParam(1393295046702303238L, 7, "", "billentry.baseqty -  billentry.invbaseqty ", ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf -  \u5df2\u51fa\u5e93\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_280", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.demandqty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_151", (String)"mmc-mrp-common"), "entryentity.demandqty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1393295046702303239L, 8, "", "billentry.id", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5185\u7801", (String)"InitDataConst_210", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_141", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1393295046702303240L, 9, "", "billentry.seq", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5e8f\u53f7", (String)"InitDataConst_212", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_144", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1393295046702303241L, 10, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "billentry.baseunit", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_206", (String)"mmc-mrp-common"), "billentry.baseunit", "0"));
        entrys.add(new TrsfEntryParam(1393295046702303242L, 11, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u914d\u7f6e\u53f7", (String)"InitDataConst_97", (String)"mmc-mrp-common"), "entryentity.configuredcode", "billentry.configuredcode", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u914d\u7f6e\u53f7", (String)"InitDataConst_283", (String)"mmc-mrp-common"), "billentry.configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1393295046702303243L, 12, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_182", (String)"mmc-mrp-common"), "entryentity.tracknumber", "billentry.tracknumber", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_284", (String)"mmc-mrp-common"), "billentry.tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1393295046702303244L, 13, "", "'SO'", "'SO'", "entryentity.demandsourcetype", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u6765\u6e90\u53f7.\u9700\u6c42\u7c7b\u578b", (String)"InitDataConst_148", (String)"mmc-mrp-common"), "entryentity.demandsourcetype", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1393326720668437504L, 14, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_104", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "billentry.auxpty", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_214", (String)"mmc-mrp-common"), "billentry.auxpty", "0"));
        entrys.add(new TrsfEntryParam(1779810801150864384L, 15, "", "", "", "entryentity.warehouse", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4ed3\u5e93", (String)"InitDataConst_533", (String)"mmc-mrp-common"), "entryentity.warehouse", "billentry.warehouse", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u4ed3\u5e93", (String)"InitDataConst_605", (String)"mmc-mrp-common"), "billentry.warehouse", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1393295046425479168L, "2C4465CV=J+E", "YS-REQ-011", ResManager.getLocaleString((String)"\u9500\u552e\u8ba2\u5355-\u9700\u6c42\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_285", (String)"mmc-mrp-common"), "sm_salorder", "mrp_demandbill_model_inh", "0", entrys, appId);
        trsfSql.put("YS-REQ-011", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1468731981440347136L, 1, "", "", "", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u5212\u7ec4\u7ec7", (String)"InitDataConst_286", (String)"mmc-mrp-common"), "org", "0"));
        entrys.add(new TrsfEntryParam(1468731981440347137L, 2, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "detailentity.materialid", ResManager.getLocaleString((String)"\u660e\u7ec6\u5355\u636e\u4f53.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_131", (String)"mmc-mrp-common"), "detailentity.materialid", "0"));
        entrys.add(new TrsfEntryParam(1468731981440347138L, 3, "", "detailentity.materialid.baseunit", ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_54", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_133", (String)"mmc-mrp-common"), "entryentity.baseunit", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1468731981440347139L, 4, "", "id", ResManager.loadKDString((String)"\u8ba1\u5212\u5904\u7406(\u540e\u53f0).\u5185\u7801", (String)"InitDataConst_135", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636eID", (String)"InitDataConst_136", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1468731981440347140L, 5, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_137", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1468731981440347141L, 6, "", "detailentity.id", ResManager.loadKDString((String)"\u660e\u7ec6\u5355\u636e\u4f53.\u5185\u7801", (String)"InitDataConst_140", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_141", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1468731981440347142L, 7, "", "detailentity.seq", ResManager.loadKDString((String)"\u660e\u7ec6\u5355\u636e\u4f53.\u5e8f\u53f7", (String)"InitDataConst_143", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_144", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1468731981440347143L, 8, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_149", (String)"mmc-mrp-common"), "entryentity.billdate", "detailentity.datenode", ResManager.getLocaleString((String)"\u660e\u7ec6\u5355\u636e\u4f53.\u65f6\u95f4\u70b9", (String)"InitDataConst_150", (String)"mmc-mrp-common"), "detailentity.datenode", "0"));
        entrys.add(new TrsfEntryParam(1468731981440347144L, 9, "", "", "", "entryentity.demandqty", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_151", (String)"mmc-mrp-common"), "entryentity.demandqty", "detailentity.fcqty", ResManager.getLocaleString((String)"\u660e\u7ec6\u5355\u636e\u4f53.\u539f\u59cb\u6570\u91cf", (String)"InitDataConst_152", (String)"mmc-mrp-common"), "detailentity.fcqty", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1468731981389892608L, "2LDJ8TWL1UA0", "YS-REQ-012", ResManager.getLocaleString((String)"\u9884\u6d4b\u8ba1\u5212-\u9700\u6c42\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_287", (String)"mmc-mrp-common"), "mds_data", "mrp_demandbill_model_inh", "0", entrys, appId);
        trsfSql.put("YS-REQ-012", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1245512022506880000L, 1, String.format("{\"items\":[{\"id\":\"4/BM7LBJFUEY\",\"seq\":1,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"4/BM5E5QMPXW\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"supplyrule\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"4/BM5E5QMP8M\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"4/BM5E5QMPXW\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"supplyrule\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"4/BM5E5QMP8M\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"entrustdept\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"select\":\"ByCondition\"},{\"id\":\"4/BM7LBJFTRO\",\"seq\":2,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"4/BM6TVODQ6H\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"supplyrule\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"4/BM6TVODPI8\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"4/BM6TVODQ6H\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"supplyrule\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"4/BM6TVODPI8\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"org\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"select\":\"ByCondition\"}],\"description\":\"%s\\\\%s\"}", ResManager.loadKDString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219 \u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_786", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219 \u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_786", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219 \u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_786", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_787", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_787", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_787", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219 \u4e0d\u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_788", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219 \u4e0d\u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_788", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219 \u4e0d\u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_788", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_787", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0])), "entrustdept", ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7\\\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_769", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_217", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "2"));
        entrys.add(new TrsfEntryParam(1245512022506880001L, 2, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599", (String)"InitDataConst_216", (String)"mmc-mrp-common"), "entryentity.material", "treeentryentity.materielmasterid", ResManager.getLocaleString((String)"\u5206\u5f55.\u7269\u6599(\u4e3b\u6570\u636e)", (String)"InitDataConst_288", (String)"mmc-mrp-common"), "treeentryentity.materielmasterid", "0"));
        entrys.add(new TrsfEntryParam(1245512022506880002L, 3, "", "treeentryentity.baseqty  -  treeentryentity.purpushqty", ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf  -  \u4e0b\u63a8\u91c7\u8d2d\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_290", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.qty", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9884\u8ba1\u5165\u5e93\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_291", (String)"mmc-mrp-common"), "entryentity.qty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1245512022506880003L, 4, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u65e5\u671f", (String)"InitDataConst_292", (String)"mmc-mrp-common"), "entryentity.billdate", "treeentryentity.planendtime", ResManager.getLocaleString((String)"\u5206\u5f55.\u8ba1\u5212\u5b8c\u5de5\u65f6\u95f4", (String)"InitDataConst_293", (String)"mmc-mrp-common"), "treeentryentity.planendtime", "0"));
        entrys.add(new TrsfEntryParam(1245512022506880004L, 5, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_294", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1245512022506880005L, 6, "", "id", ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355.\u5185\u7801", (String)"InitDataConst_296", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636eID", (String)"InitDataConst_297", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1245512022506880006L, 7, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_298", (String)"mmc-mrp-common"), "entryentity.baseunit", "treeentryentity.unit", ResManager.getLocaleString((String)"\u5206\u5f55.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_299", (String)"mmc-mrp-common"), "treeentryentity.unit", "0"));
        entrys.add(new TrsfEntryParam(1245512022506880007L, 8, "", "treeentryentity.id", ResManager.loadKDString((String)"\u5206\u5f55.\u5185\u7801", (String)"InitDataConst_301", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_302", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1245512022506880008L, 9, "", "treeentryentity.seq", ResManager.loadKDString((String)"\u5206\u5f55.\u5e8f\u53f7", (String)"InitDataConst_304", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_305", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1307837082374320128L, 10, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_218", (String)"mmc-mrp-common"), "entryentity.tracknumber", "treeentryentity.tracknumber", ResManager.getLocaleString((String)"\u5206\u5f55.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_306", (String)"mmc-mrp-common"), "treeentryentity.tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1307837082374320129L, 11, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u914d\u7f6e\u53f7", (String)"InitDataConst_219", (String)"mmc-mrp-common"), "entryentity.configuredcode", "treeentryentity.configuredcode", ResManager.getLocaleString((String)"\u5206\u5f55.\u914d\u7f6e\u53f7", (String)"InitDataConst_307", (String)"mmc-mrp-common"), "treeentryentity.configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1392599451180205056L, 12, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_308", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "treeentryentity.auxproperty", ResManager.getLocaleString((String)"\u5206\u5f55.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_309", (String)"mmc-mrp-common"), "treeentryentity.auxproperty", "0"));
        entrys.add(new TrsfEntryParam(1452275420358518784L, 13, String.format("{\"items\":[{\"id\":\"2JCPD0M6ODWB\",\"seq\":1,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"2JCPAKOAFF0C\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"producttype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2JCPAKOAG6NN\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"2JCPAKOAFF0C\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"producttype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2JCPAKOAG6NN\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"exprDesc\":\"%s\",\"localeExprTran\":{\"zh_CN\":\"%s\"}},\"formula\":{\"expression\":\"'0'\",\"exprTran\":\"'0'\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"'0'\",\"localeExprTran\":{\"zh_CN\":\"'0'\"}},\"select\":\"ByCondition\"},{\"id\":\"2JCPD0M=AKP4\",\"seq\":2,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"2JCPC3HMA6F3\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"producttype\",\"rightBracket\":\"\",\"logic\":\"1\",\"value\":[{\"id\":\"2JCPC3HTKSFE\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2JCPC3HTKSFF\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"producttype\",\"rightBracket\":\"\",\"logic\":\"1\",\"value\":[{\"id\":\"2JCPC3HTK/U5\",\"value\":\"B\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"2JCPC3HMA6F3\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"producttype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"1\\\",\\\"value\\\":[{\\\"id\\\":\\\"2JCPC3HTKSFE\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]},{\\\"id\\\":\\\"2JCPC3HTKSFF\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"producttype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"1\\\",\\\"value\\\":[{\\\"id\\\":\\\"2JCPC3HTK/U5\\\",\\\"value\\\":\\\"B\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"exprDesc\":\"%s\",\"localeExprTran\":{\"zh_CN\":\"%s\"}},\"formula\":{\"expression\":\"'1'\",\"exprTran\":\"'1'\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"'1'\",\"localeExprTran\":{\"zh_CN\":\"'1'\"}},\"select\":\"ByCondition\"}],\"description\":\"'0'\\\\'1'\"}", ResManager.loadKDString((String)"\u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u4e3b\u4ea7\u54c1", (String)"InitDataConst_789", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u4e3b\u4ea7\u54c1", (String)"InitDataConst_789", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u4e3b\u4ea7\u54c1", (String)"InitDataConst_789", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u8054\u4ea7\u54c1   or    \u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u526f\u4ea7\u54c1", (String)"InitDataConst_790", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u8054\u4ea7\u54c1   or    \u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u526f\u4ea7\u54c1", (String)"InitDataConst_790", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u8054\u4ea7\u54c1   or    \u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u526f\u4ea7\u54c1", (String)"InitDataConst_790", (String)"mmc-mrp-common", (Object[])new Object[0])), "'0'", "'0'\\'1'", "entryentity.copsupply", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8054\u526f\u4ea7\u54c1\u4f9b\u5e94", (String)"InitDataConst_310", (String)"mmc-mrp-common"), "entryentity.copsupply", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "2"));
        entrys.add(new TrsfEntryParam(1453666681774724096L, 14, "", "", "", "entryentity.yield", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u6210\u54c1\u7387\uff08%\uff09", (String)"InitDataConst_311", (String)"mmc-mrp-common"), "entryentity.yield", "treeentryentity.yieldrate", ResManager.getLocaleString((String)"\u5206\u5f55.\u6210\u54c1\u7387", (String)"InitDataConst_312", (String)"mmc-mrp-common"), "treeentryentity.yieldrate", "0"));
        entrys.add(new TrsfEntryParam(1781827712600561664L, 15, "", "", "", "entryentity.requireorg", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_549", (String)"mmc-mrp-common"), "entryentity.requireorg", "entrustdept", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_618", (String)"mmc-mrp-common"), "entrustdept", "0"));
        entrys.add(new TrsfEntryParam(1781827712600561665L, 16, "", "", "", "entryentity.planscope", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ba1\u5212\u8303\u56f4", (String)"InitDataConst_614", (String)"mmc-mrp-common"), "entryentity.planscope", "treeentryentity.planscope", ResManager.getLocaleString((String)"\u5206\u5f55.\u8ba1\u5212\u8303\u56f4", (String)"InitDataConst_619", (String)"mmc-mrp-common"), "treeentryentity.planscope", "0"));
        entrys.add(new TrsfEntryParam(1781827712600561666L, 17, "", "", "", "entryentity.supply_strategy", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u89c4\u5219", (String)"InitDataConst_616", (String)"mmc-mrp-common"), "entryentity.supply_strategy", "treeentryentity.supplyrule", ResManager.getLocaleString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219", (String)"InitDataConst_620", (String)"mmc-mrp-common"), "treeentryentity.supplyrule", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1245512022473325568L, "1XL9DR90BOUH", "YS-SUP-006", ResManager.getLocaleString((String)"\u59d4\u5916\u5de5\u5355-\u4f9b\u5e94\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_313", (String)"mmc-mrp-common"), "om_mftorder", "mrp_supply_model_inh", "0", entrys, appId);
        trsfSql.put("YS-SUP-006", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(976016300000172032L, 1, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "entryentity.material", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u7269\u6599", (String)"InitDataConst_79", (String)"mmc-mrp-common"), "entryentity.material", "0"));
        entrys.add(new TrsfEntryParam(1018752488834125824L, 2, "", "", "", "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_25", (String)"mmc-mrp-common"), "entryentity.productionorgunit", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_36", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "0"));
        entrys.add(new TrsfEntryParam(1302335114772106240L, 3, "{\"expression\":\"\\\"@requireData.#CONFIGPROPERTIES = 2\\\"\",\"exprTran\":\"\\\"@requireData.#CONFIGPROPERTIES = 2\\\"\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"\\\"@requireData.#CONFIGPROPERTIES = 2\\\"\",\"localeExprTran\":{\"zh_CN\":\"\\\"@requireData.#CONFIGPROPERTIES = 2\\\"\"}}", "\"@requireData.#CONFIGPROPERTIES = 2\"", "\"@requireData.#CONFIGPROPERTIES = 2\"", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u914d\u7f6e\u53f7", (String)"InitDataConst_97", (String)"mmc-mrp-common"), "entryentity.configuredcode", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u4f53.\u914d\u7f6e\u53f7", (String)"InitDataConst_97", (String)"mmc-mrp-common"), "entryentity.configuredcode", "4"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 962938205651391488L, "1MH1PT5YGBEJ", "YS-Require-BOM", ResManager.getLocaleString((String)"\u9700\u6c42\u4e0eBOM\u5339\u914d\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_314", (String)"mmc-mrp-common"), "mrp_demandbill_model_inh", "mrp_bomexpand_model_inh", "1", entrys, appId);
        trsfSql.put("YS-Require-BOM", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1078053504574057531L, 1, "", "", "", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_217", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5e93\u5b58\u7ec4\u7ec7", (String)"InitDataConst_186", (String)"mmc-mrp-common"), "org", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057532L, 2, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599", (String)"InitDataConst_216", (String)"mmc-mrp-common"), "entryentity.material", "material", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599", (String)"InitDataConst_187", (String)"mmc-mrp-common"), "material", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057533L, 3, "", "baseunit", ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_54", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.baseunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_298", (String)"mmc-mrp-common"), "entryentity.baseunit", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057534L, 4, "", "", "", "entryentity.qty", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9884\u8ba1\u5165\u5e93\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_291", (String)"mmc-mrp-common"), "entryentity.qty", "baseqty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5e93\u5b58\u91cf\uff08\u57fa\u672c\u5355\u4f4d\uff09", (String)"InitDataConst_316", (String)"mmc-mrp-common"), "baseqty", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057535L, 5, "", "", "", "entryentity.stock", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4ed3\u5e93", (String)"InitDataConst_317", (String)"mmc-mrp-common"), "entryentity.stock", "warehouse", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4ed3\u5e93", (String)"InitDataConst_318", (String)"mmc-mrp-common"), "warehouse", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057536L, 6, "", "", "", "entryentity.stockindex", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4ed3\u4f4d", (String)"InitDataConst_503", (String)"mmc-mrp-common"), "entryentity.stockindex", "location", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4ed3\u4f4d", (String)"InitDataConst_504", (String)"mmc-mrp-common"), "location", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057537L, 7, "", "1", "1", "entryentity.istock", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u662f\u5426\u5e93\u5b58\u6570\u636e", (String)"InitDataConst_319", (String)"mmc-mrp-common"), "entryentity.istock", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057538L, 8, "", "id", ResManager.loadKDString((String)"\u5373\u65f6\u5e93\u5b58\u4f59\u989d\u8868.\u5185\u7801", (String)"InitDataConst_192", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636eID", (String)"InitDataConst_297", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1155616987443913728L, 9, "", "im_inv_realbalance.warehouse.name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"InitDataConst_321", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.warehousename", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4ed3\u5e93\u540d\u79f0", (String)"InitDataConst_322", (String)"mmc-mrp-common"), "entryentity.warehousename", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1155616987443913729L, 10, "", "im_inv_realbalance.location.name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"InitDataConst_321", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.locationname", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4ed3\u4f4d\u540d\u79f0", (String)"InitDataConst_324", (String)"mmc-mrp-common"), "entryentity.locationname", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1307833924952707072L, 11, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u914d\u7f6e\u53f7", (String)"InitDataConst_219", (String)"mmc-mrp-common"), "entryentity.configuredcode", "configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_98", (String)"mmc-mrp-common"), "configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1317941786408251392L, 12, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_218", (String)"mmc-mrp-common"), "entryentity.tracknumber", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_194", (String)"mmc-mrp-common"), "tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1392604183579853824L, 13, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_308", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "auxpty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_105", (String)"mmc-mrp-common"), "auxpty", "0"));
        entrys.add(new TrsfEntryParam(1635017416842947584L, 14, "", "id", ResManager.loadKDString((String)"\u5373\u65f6\u5e93\u5b58\u4f59\u989d\u8868.\u5185\u7801", (String)"InitDataConst_192", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_302", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1840700990467130368L, 15, "", "", "", "entryentity.stocktype", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5e93\u5b58\u7c7b\u578b", (String)"InitDataConst_720", (String)"mmc-mrp-common"), "entryentity.stocktype", "invtype", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5e93\u5b58\u7c7b\u578b", (String)"InitDataConst_721", (String)"mmc-mrp-common"), "invtype", "0"));
        entrys.add(new TrsfEntryParam(1840700990467130369L, 16, "", "", "", "entryentity.stockstatus", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5e93\u5b58\u72b6\u6001", (String)"InitDataConst_722", (String)"mmc-mrp-common"), "entryentity.stockstatus", "invstatus", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5e93\u5b58\u72b6\u6001", (String)"InitDataConst_723", (String)"mmc-mrp-common"), "invstatus", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 996334374087561216L, "1MH1PT5YGBEK", "YS-SUP-001", ResManager.getLocaleString((String)"\u5373\u65f6\u5e93\u5b58-\u4f9b\u5e94\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_325", (String)"mmc-mrp-common"), "im_inv_realbalance", "mrp_supply_model_inh", "0", entrys, appId);
        trsfSql.put("YS-SUP-001", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1078053504574057553L, 1, String.format("{\"items\":[{\"id\":\"4/BLPUA8QZD+\",\"seq\":1,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"4/BLNJ5IZ3YK\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"supplyrule\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"4/BLNJ5IZ39A\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"4/BLNJ5IZ3YK\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"supplyrule\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"4/BLNJ5IZ39A\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"entrustdept\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"select\":\"ByCondition\"},{\"id\":\"4/BLPUA8QYPQ\",\"seq\":2,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"4/BLP78RKZXK\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"supplyrule\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"4/BLP78RKZ8A\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"4/BLP78RKZXK\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"supplyrule\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"4/BLP78RKZ8A\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"org\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"select\":\"ByCondition\"}],\"description\":\"%s\\\\%s\"}", ResManager.loadKDString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219 \u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_786", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219 \u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_786", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219 \u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_786", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_787", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_787", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_787", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219 \u4e0d\u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_788", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219 \u4e0d\u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_788", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219 \u4e0d\u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_788", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_787", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_777", (String)"mmc-mrp-common", (Object[])new Object[0])), "entrustdept", ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7\\\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_769", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_217", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "2"));
        entrys.add(new TrsfEntryParam(1078053504574057554L, 2, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599", (String)"InitDataConst_216", (String)"mmc-mrp-common"), "entryentity.material", "treeentryentity.materielmasterid", ResManager.getLocaleString((String)"\u5206\u5f55.\u7269\u6599(\u4e3b\u6570\u636e)", (String)"InitDataConst_288", (String)"mmc-mrp-common"), "treeentryentity.materielmasterid", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057555L, 3, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u65e5\u671f", (String)"InitDataConst_292", (String)"mmc-mrp-common"), "entryentity.billdate", "treeentryentity.planendtime", ResManager.getLocaleString((String)"\u5206\u5f55.\u8ba1\u5212\u5b8c\u5de5\u65f6\u95f4", (String)"InitDataConst_293", (String)"mmc-mrp-common"), "treeentryentity.planendtime", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057556L, 4, "", "treeentryentity.baseqty- treeentryentity.quainwaqty -  treeentryentity.unquainwaqty   -  treeentryentity.scrinwaqty", ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf- \u5408\u683c\u54c1\u5165\u5e93\u57fa\u672c\u6570\u91cf -  \u4e0d\u5408\u683c\u54c1\u5165\u5e93\u57fa\u672c\u6570\u91cf   -  \u62a5\u5e9f\u54c1\u5165\u5e93\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_327", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.qty", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9884\u8ba1\u5165\u5e93\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_291", (String)"mmc-mrp-common"), "entryentity.qty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057557L, 5, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_294", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057558L, 6, "", "treeentryentity.baseunit", ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_54", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.baseunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_298", (String)"mmc-mrp-common"), "entryentity.baseunit", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057559L, 7, "", "id", ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355.\u5185\u7801", (String)"InitDataConst_330", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636eID", (String)"InitDataConst_297", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057560L, 8, "", "treeentryentity.id", ResManager.loadKDString((String)"\u5206\u5f55.\u5185\u7801", (String)"InitDataConst_301", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_302", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057561L, 9, "", "treeentryentity.seq", ResManager.loadKDString((String)"\u5206\u5f55.\u5e8f\u53f7", (String)"InitDataConst_304", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_305", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1305667109254316033L, 10, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_218", (String)"mmc-mrp-common"), "entryentity.tracknumber", "treeentryentity.tracknumber", ResManager.getLocaleString((String)"\u5206\u5f55.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_306", (String)"mmc-mrp-common"), "treeentryentity.tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1305785738415292416L, 11, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u914d\u7f6e\u53f7", (String)"InitDataConst_219", (String)"mmc-mrp-common"), "entryentity.configuredcode", "treeentryentity.configuredcode", ResManager.getLocaleString((String)"\u5206\u5f55.\u914d\u7f6e\u53f7", (String)"InitDataConst_307", (String)"mmc-mrp-common"), "treeentryentity.configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1394041060962861056L, 12, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_308", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "treeentryentity.auxproperty", ResManager.getLocaleString((String)"\u5206\u5f55.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_309", (String)"mmc-mrp-common"), "treeentryentity.auxproperty", "0"));
        entrys.add(new TrsfEntryParam(1449127863222539264L, 13, String.format("{\"items\":[{\"id\":\"2IR+SS733HMO\",\"seq\":1,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"2IR+S=E+VO/U\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"producttype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2IR+S=E63HDV\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"2IR+S=E+VO/U\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"producttype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2IR+S=E63HDV\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"'0'\",\"exprTran\":\"'0'\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"'0'\"},\"exprDesc\":\"'0'\"},\"select\":\"ByCondition\"},{\"id\":\"2IR+U=N1OQKJ\",\"seq\":2,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"2IR+U7WDQYHP\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"producttype\",\"rightBracket\":\"\",\"logic\":\"1\",\"value\":[{\"id\":\"2IR+U7WDQZ5Z\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2IR+U7WDQYHQ\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"producttype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2IR+U7WDQZ6+\",\"value\":\"B\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"2IR+U7WDQYHP\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"producttype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"1\\\",\\\"value\\\":[{\\\"id\\\":\\\"2IR+U7WDQZ5Z\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]},{\\\"id\\\":\\\"2IR+U7WDQYHQ\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"producttype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2IR+U7WDQZ6+\\\",\\\"value\\\":\\\"B\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"'1'\",\"exprTran\":\"'1'\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"'1'\"},\"exprDesc\":\"'1'\"},\"select\":\"ByCondition\"}],\"description\":\"'0'\\\\'1'\"}", ResManager.loadKDString((String)"\u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u4e3b\u4ea7\u54c1", (String)"InitDataConst_789", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u4e3b\u4ea7\u54c1", (String)"InitDataConst_789", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u4e3b\u4ea7\u54c1", (String)"InitDataConst_789", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u8054\u4ea7\u54c1   or    \u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u526f\u4ea7\u54c1", (String)"InitDataConst_790", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u8054\u4ea7\u54c1   or    \u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u526f\u4ea7\u54c1", (String)"InitDataConst_790", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u8054\u4ea7\u54c1   or    \u5206\u5f55.\u4ea7\u54c1\u7c7b\u578b \u7b49\u4e8e \u526f\u4ea7\u54c1", (String)"InitDataConst_790", (String)"mmc-mrp-common", (Object[])new Object[0])), "\"0\"", "\"0\"\\\"1\"", "entryentity.copsupply", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8054\u526f\u4ea7\u54c1\u4f9b\u5e94", (String)"InitDataConst_310", (String)"mmc-mrp-common"), "entryentity.copsupply", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "2"));
        entrys.add(new TrsfEntryParam(1453661526094297088L, 14, "", "", "", "entryentity.yield", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u6210\u54c1\u7387\uff08%\uff09", (String)"InitDataConst_311", (String)"mmc-mrp-common"), "entryentity.yield", "treeentryentity.yieldrate", ResManager.getLocaleString((String)"\u5206\u5f55.\u6210\u54c1\u7387", (String)"InitDataConst_312", (String)"mmc-mrp-common"), "treeentryentity.yieldrate", "0"));
        entrys.add(new TrsfEntryParam(1781819850990038016L, 15, "", "", "", "entryentity.requireorg", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_549", (String)"mmc-mrp-common"), "entryentity.requireorg", "entrustdept", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_618", (String)"mmc-mrp-common"), "entrustdept", "0"));
        entrys.add(new TrsfEntryParam(1781819850990038017L, 16, "", "", "", "entryentity.planscope", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ba1\u5212\u8303\u56f4", (String)"InitDataConst_614", (String)"mmc-mrp-common"), "entryentity.planscope", "treeentryentity.planscope", ResManager.getLocaleString((String)"\u5206\u5f55.\u8ba1\u5212\u8303\u56f4", (String)"InitDataConst_619", (String)"mmc-mrp-common"), "treeentryentity.planscope", "0"));
        entrys.add(new TrsfEntryParam(1781819850990038018L, 17, "", "", "", "entryentity.supply_strategy", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u89c4\u5219", (String)"InitDataConst_616", (String)"mmc-mrp-common"), "entryentity.supply_strategy", "treeentryentity.supplyrule", ResManager.getLocaleString((String)"\u5206\u5f55.\u4f9b\u5e94\u89c4\u5219", (String)"InitDataConst_620", (String)"mmc-mrp-common"), "treeentryentity.supplyrule", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1019614409246389248L, "1MH1PT5YGBEL", "YS-SUP-002", ResManager.getLocaleString((String)"\u751f\u4ea7\u5de5\u5355-\u4f9b\u5e94\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_333", (String)"mmc-mrp-common"), "pom_mftorder", "mrp_supply_model_inh", "0", entrys, appId);
        trsfSql.put("YS-SUP-002", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1078053504574057479L, 1, "", "id", ResManager.loadKDString((String)"\u91c7\u8d2d\u7533\u8bf7\u5355.\u5185\u7801", (String)"InitDataConst_335", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636eID", (String)"InitDataConst_297", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057472L, 2, "", "", "", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_217", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "billentry.entryrecorg", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u6536\u8d27\u7ec4\u7ec7", (String)"InitDataConst_336", (String)"mmc-mrp-common"), "billentry.entryrecorg", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057473L, 3, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599", (String)"InitDataConst_216", (String)"mmc-mrp-common"), "entryentity.material", "billentry.materialmasterid", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u4e3b\u7269\u6599(\u5c01\u5b58)", (String)"InitDataConst_337", (String)"mmc-mrp-common"), "billentry.materialmasterid", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057474L, 4, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u65e5\u671f", (String)"InitDataConst_292", (String)"mmc-mrp-common"), "entryentity.billdate", "billentry.reqdate", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_204", (String)"mmc-mrp-common"), "billentry.reqdate", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057475L, 5, "", "", "", "entryentity.billtype", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_338", (String)"mmc-mrp-common"), "entryentity.billtype", "billtype", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_278", (String)"mmc-mrp-common"), "billtype", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057476L, 6, "", "billentry.baseqty -  billentry.orderbaseqty", ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf -  \u7d2f\u8ba1\u8ba2\u8d27\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_340", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.qty", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9884\u8ba1\u5165\u5e93\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_291", (String)"mmc-mrp-common"), "entryentity.qty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057477L, 7, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_294", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057478L, 8, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_298", (String)"mmc-mrp-common"), "entryentity.baseunit", "billentry.baseunit", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_206", (String)"mmc-mrp-common"), "billentry.baseunit", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057480L, 9, "", "billentry.id", ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u5185\u7801", (String)"InitDataConst_176", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_302", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057481L, 10, "", "billentry.seq", ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u5e8f\u53f7", (String)"InitDataConst_178", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_305", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1305738032351143936L, 11, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_218", (String)"mmc-mrp-common"), "entryentity.tracknumber", "billentry.tracknumber", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_284", (String)"mmc-mrp-common"), "billentry.tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1392607815134085120L, 12, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_308", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "billentry.auxpty", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_214", (String)"mmc-mrp-common"), "billentry.auxpty", "0"));
        entrys.add(new TrsfEntryParam(1781799109208889344L, 13, "", "", "", "entryentity.stock", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4ed3\u5e93", (String)"InitDataConst_317", (String)"mmc-mrp-common"), "entryentity.stock", "billentry.warehouse", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u6536\u8d27\u4ed3\u5e93", (String)"InitDataConst_613", (String)"mmc-mrp-common"), "billentry.warehouse", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1019614408390751232L, "1MH1PT5YGBEM", "YS-SUP-003", ResManager.getLocaleString((String)"\u91c7\u8d2d\u7533\u8bf7\u5355-\u4f9b\u5e94\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_343", (String)"mmc-mrp-common"), "pm_purapplybill", "mrp_supply_model_inh", "0", entrys, appId);
        trsfSql.put("YS-SUP-003", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1078053504574057496L, 1, "", "", "", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_217", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "billentry.entryrecorg", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u6536\u8d27\u7ec4\u7ec7", (String)"InitDataConst_336", (String)"mmc-mrp-common"), "billentry.entryrecorg", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057497L, 2, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599", (String)"InitDataConst_216", (String)"mmc-mrp-common"), "entryentity.material", "billentry.materialmasterid", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u4e3b\u7269\u6599(\u5c01\u5b58)", (String)"InitDataConst_337", (String)"mmc-mrp-common"), "billentry.materialmasterid", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057498L, 3, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u65e5\u671f", (String)"InitDataConst_292", (String)"mmc-mrp-common"), "entryentity.billdate", "billentry.deliverdate", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u4ea4\u8d27\u65e5\u671f", (String)"InitDataConst_344", (String)"mmc-mrp-common"), "billentry.deliverdate", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057499L, 4, "", "", "", "entryentity.billtype", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_338", (String)"mmc-mrp-common"), "entryentity.billtype", "billtype", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_278", (String)"mmc-mrp-common"), "billtype", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057500L, 5, "", "billentry.baseqty -  billentry.receivebaseqty", ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf -  \u5df2\u6536\u8d27\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_346", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.qty", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9884\u8ba1\u5165\u5e93\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_291", (String)"mmc-mrp-common"), "entryentity.qty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057501L, 6, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_294", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057502L, 7, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_298", (String)"mmc-mrp-common"), "entryentity.baseunit", "billentry.baseunit", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_206", (String)"mmc-mrp-common"), "billentry.baseunit", "0"));
        entrys.add(new TrsfEntryParam(1078053504574057503L, 8, "", "id", ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355.\u5185\u7801", (String)"InitDataConst_348", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636eID", (String)"InitDataConst_297", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057504L, 9, "", "billentry.id", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5185\u7801", (String)"InitDataConst_210", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_302", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1078053504574057505L, 10, "", "billentry.seq", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5e8f\u53f7", (String)"InitDataConst_212", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_305", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1305739570696022016L, 11, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_218", (String)"mmc-mrp-common"), "entryentity.tracknumber", "billentry.tracknumber", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_284", (String)"mmc-mrp-common"), "billentry.tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1392609686632529920L, 12, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_308", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "billentry.auxpty", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_214", (String)"mmc-mrp-common"), "billentry.auxpty", "0"));
        entrys.add(new TrsfEntryParam(1781800532017469440L, 13, "", "", "", "entryentity.stock", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4ed3\u5e93", (String)"InitDataConst_317", (String)"mmc-mrp-common"), "entryentity.stock", "billentry.warehouse", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u6536\u8d27\u4ed3\u5e93", (String)"InitDataConst_613", (String)"mmc-mrp-common"), "billentry.warehouse", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1019614409137337344L, "1MH1PT5YGBEN", "YS-SUP-004", ResManager.getLocaleString((String)"\u91c7\u8d2d\u8ba2\u5355-\u4f9b\u5e94\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_349", (String)"mmc-mrp-common"), "pm_purorderbill", "mrp_supply_model_inh", "0", entrys, appId);
        trsfSql.put("YS-SUP-004", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1465244867100738560L, 1, "", "", "", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_217", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "billentry.entryrecorg", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u6536\u8d27\u7ec4\u7ec7", (String)"InitDataConst_336", (String)"mmc-mrp-common"), "billentry.entryrecorg", "0"));
        entrys.add(new TrsfEntryParam(1465244867100738561L, 2, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599", (String)"InitDataConst_216", (String)"mmc-mrp-common"), "entryentity.material", "billentry.material.masterid", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u7269\u6599\u7f16\u7801.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_350", (String)"mmc-mrp-common"), "billentry.material.masterid", "0"));
        entrys.add(new TrsfEntryParam(1465244867100738562L, 3, "", "billentry.baseqty -  billentry.receivebaseqty", ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf -  \u5df2\u6536\u8d27\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_346", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.qty", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9884\u8ba1\u5165\u5e93\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_291", (String)"mmc-mrp-common"), "entryentity.qty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1465244867100738563L, 4, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u65e5\u671f", (String)"InitDataConst_292", (String)"mmc-mrp-common"), "entryentity.billdate", "billentry.deliverdate", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u4ea4\u8d27\u65e5\u671f", (String)"InitDataConst_344", (String)"mmc-mrp-common"), "billentry.deliverdate", "0"));
        entrys.add(new TrsfEntryParam(1465244867100738564L, 5, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_294", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1465244867100738565L, 6, "", "id", ResManager.loadKDString((String)"\u59d4\u5916\u8ba2\u5355.\u5185\u7801", (String)"InitDataConst_354", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636eID", (String)"InitDataConst_297", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1465244867100738566L, 7, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_298", (String)"mmc-mrp-common"), "entryentity.baseunit", "billentry.baseunit", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_206", (String)"mmc-mrp-common"), "billentry.baseunit", "0"));
        entrys.add(new TrsfEntryParam(1465244867100738567L, 8, "", "billentry.id", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5185\u7801", (String)"InitDataConst_210", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_302", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1465244867100738568L, 9, "", "billentry.seq", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5e8f\u53f7", (String)"InitDataConst_212", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_305", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1465244867100738569L, 10, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_218", (String)"mmc-mrp-common"), "entryentity.tracknumber", "billentry.tracknumber", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_284", (String)"mmc-mrp-common"), "billentry.tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1465244867100738570L, 11, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u914d\u7f6e\u53f7", (String)"InitDataConst_219", (String)"mmc-mrp-common"), "entryentity.configuredcode", "billentry.configuredcode", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u914d\u7f6e\u53f7", (String)"InitDataConst_283", (String)"mmc-mrp-common"), "billentry.configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1465244867100738571L, 12, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_308", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "billentry.auxpty", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_214", (String)"mmc-mrp-common"), "billentry.auxpty", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1465244867050406912L, "2KZUP9QAAV9U", "YS-SUP-010", ResManager.getLocaleString((String)"\u59d4\u5916\u8ba2\u5355-\u4f9b\u5e94\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_355", (String)"mmc-mrp-common"), "pm_om_purorderbill", "mrp_supply_model_inh", "0", entrys, appId);
        trsfSql.put("YS-SUP-010", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(976016296552478720L, 1, String.format("{\"items\":[{\"id\":\"4/5/KTITSKYP\",\"seq\":1,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"4/5/I0TFPQ2C\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"supplyrule\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"4/5/I0TFQGPN\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"4/5/I0TFPQ2C\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"supplyrule\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"4/5/I0TFQGPN\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"org\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"select\":\"ByCondition\"},{\"id\":\"4/5/KTITTBK+\",\"seq\":2,\"ifconstant\":0,\"selectType\":\"ByCondition\",\"condition\":{\"expression\":\"\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"4/5/KBMGO10X\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"supplyrule\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"4/5/KBMGOTO6\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"4/5/KBMGO10X\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"supplyrule\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"4/5/KBMGOTO6\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"formula\":{\"expression\":\"proorpurorg\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%s\"},\"exprDesc\":\"%s\"},\"select\":\"ByCondition\"}],\"description\":\"%s\\\\%s\"}", ResManager.loadKDString((String)"\u4f9b\u5e94\u89c4\u5219 \u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_791", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u89c4\u5219 \u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_791", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u89c4\u5219 \u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_791", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_388", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_388", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_388", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u89c4\u5219 \u4e0d\u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_792", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u89c4\u5219 \u4e0d\u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_792", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u89c4\u5219 \u4e0d\u7b49\u4e8e \u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"InitDataConst_792", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_391", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_391", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_391", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_388", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_391", (String)"mmc-mrp-common", (Object[])new Object[0])), "org", ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\\\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_771", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_217", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "2"));
        entrys.add(new TrsfEntryParam(976016296552478722L, 2, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u65e5\u671f", (String)"InitDataConst_292", (String)"mmc-mrp-common"), "entryentity.billdate", "availabledate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u53ef\u7528\u65e5\u671f", (String)"InitDataConst_356", (String)"mmc-mrp-common"), "availabledate", "0"));
        entrys.add(new TrsfEntryParam(976016296552478723L, 3, "", "orderqty -  dropqty ", ResManager.loadKDString((String)"\u8ba2\u5355\u6570\u91cf -  \u6295\u653e\u6570\u91cf", (String)"InitDataConst_358", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.qty", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9884\u8ba1\u5165\u5e93\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_291", (String)"mmc-mrp-common"), "entryentity.qty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(976016296552478725L, 4, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_294", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(976016296552478726L, 5, "", "id", ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355.\u5185\u7801", (String)"InitDataConst_235", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636eID", (String)"InitDataConst_297", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(976016296552478721L, 6, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599", (String)"InitDataConst_216", (String)"mmc-mrp-common"), "entryentity.material", "material", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_154", (String)"mmc-mrp-common"), "material", "0"));
        entrys.add(new TrsfEntryParam(1159462256321256448L, 7, "", "", "", "entryentity.yield", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u6210\u54c1\u7387\uff08%\uff09", (String)"InitDataConst_311", (String)"mmc-mrp-common"), "entryentity.yield", "yield", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6210\u54c1\u7387", (String)"InitDataConst_360", (String)"mmc-mrp-common"), "yield", "0"));
        entrys.add(new TrsfEntryParam(976016296552478724L, 8, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_298", (String)"mmc-mrp-common"), "entryentity.baseunit", "unit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_155", (String)"mmc-mrp-common"), "unit", "0"));
        entrys.add(new TrsfEntryParam(1305187544790484992L, 9, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_218", (String)"mmc-mrp-common"), "entryentity.tracknumber", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_194", (String)"mmc-mrp-common"), "tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1307836417996673024L, 10, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u914d\u7f6e\u53f7", (String)"InitDataConst_219", (String)"mmc-mrp-common"), "entryentity.configuredcode", "configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_98", (String)"mmc-mrp-common"), "configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1392611305281553408L, 11, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_308", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "auxproperty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_105", (String)"mmc-mrp-common"), "auxproperty", "0"));
        entrys.add(new TrsfEntryParam(1781802562438092800L, 12, "", "", "", "entryentity.requireorg", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_549", (String)"mmc-mrp-common"), "entryentity.requireorg", "org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_213", (String)"mmc-mrp-common"), "org", "0"));
        entrys.add(new TrsfEntryParam(1781802562438092801L, 13, "", "", "", "entryentity.planscope", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ba1\u5212\u8303\u56f4", (String)"InitDataConst_614", (String)"mmc-mrp-common"), "entryentity.planscope", "planscope", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u5212\u8303\u56f4", (String)"InitDataConst_615", (String)"mmc-mrp-common"), "planscope", "0"));
        entrys.add(new TrsfEntryParam(1781802562438092802L, 14, "", "", "", "entryentity.supply_strategy", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u89c4\u5219", (String)"InitDataConst_616", (String)"mmc-mrp-common"), "entryentity.supply_strategy", "supplyrule", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4f9b\u5e94\u89c4\u5219", (String)"InitDataConst_617", (String)"mmc-mrp-common"), "supplyrule", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 976007551319598080L, "1MH1PT5YGBEO", "YS-SUP-005", ResManager.getLocaleString((String)"\u8ba1\u5212\u8ba2\u5355-\u4f9b\u5e94\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_361", (String)"mmc-mrp-common"), "mrp_planorder", "mrp_supply_model_inh", "0", entrys, appId);
        trsfSql.put("YS-SUP-005", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1281137811822525440L, 1, "", "", "", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_217", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "proorpurorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_196", (String)"mmc-mrp-common"), "proorpurorg", "0"));
        entrys.add(new TrsfEntryParam(1281137811822525441L, 2, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u65e5\u671f", (String)"InitDataConst_292", (String)"mmc-mrp-common"), "entryentity.billdate", "availabledate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u53ef\u7528\u65e5\u671f", (String)"InitDataConst_356", (String)"mmc-mrp-common"), "availabledate", "0"));
        entrys.add(new TrsfEntryParam(1281137811822525442L, 3, "", "( orderqty -  dropqty  )  *  copentry.copentryqty", ResManager.loadKDString((String)"( \u8ba2\u5355\u6570\u91cf -  \u6295\u653e\u6570\u91cf  )  *  \u5355\u4e2a\u6570\u91cf", (String)"InitDataConst_363", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.qty", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9884\u8ba1\u5165\u5e93\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_291", (String)"mmc-mrp-common"), "entryentity.qty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1281137811822525443L, 4, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_294", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1281137811822525444L, 5, "", "id", ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355.\u5185\u7801", (String)"InitDataConst_235", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636eID", (String)"InitDataConst_297", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1281137811822525445L, 6, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599", (String)"InitDataConst_216", (String)"mmc-mrp-common"), "entryentity.material", "copentry.copentrymaterial", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u4ea7\u54c1\u7f16\u7801", (String)"InitDataConst_364", (String)"mmc-mrp-common"), "copentry.copentrymaterial", "0"));
        entrys.add(new TrsfEntryParam(1281137811822525446L, 7, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_298", (String)"mmc-mrp-common"), "entryentity.baseunit", "copentry.copentryunit", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u4ea7\u54c1\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_365", (String)"mmc-mrp-common"), "copentry.copentryunit", "0"));
        entrys.add(new TrsfEntryParam(1285297406841245696L, 8, "", "copentry.id", ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1.\u5185\u7801", (String)"InitDataConst_111", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_302", (String)"mmc-mrp-common"), "entryentity.billentryid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1285297406841245697L, 9, "", "copentry.seq", ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1.\u5e8f\u53f7", (String)"InitDataConst_114", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billentryseq", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_305", (String)"mmc-mrp-common"), "entryentity.billentryseq", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1305744252948572160L, 10, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_218", (String)"mmc-mrp-common"), "entryentity.tracknumber", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_194", (String)"mmc-mrp-common"), "tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1392624744854979584L, 11, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_308", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "copentry.copentryauxproperty", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_124", (String)"mmc-mrp-common"), "copentry.copentryauxproperty", "0"));
        entrys.add(new TrsfEntryParam(1444208388321060864L, 12, "", "1", ResManager.loadKDString((String)"\u662f", (String)"InitDataConst_369", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.copsupply", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8054\u526f\u4ea7\u54c1\u4f9b\u5e94", (String)"InitDataConst_310", (String)"mmc-mrp-common"), "entryentity.copsupply", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "3"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1281137811671530496L, "2/IOHB5NVV6M", "YS-SUP-007", ResManager.getLocaleString((String)"\u8ba1\u5212\u8ba2\u5355\uff08\u8054\u526f\u4ea7\u54c1\uff09-\u4f9b\u5e94\u5355\u636e\u6620\u5c04", (String)"InitDataConst_370", (String)"mmc-mrp-common"), "mrp_planorder", "mrp_supply_model_inh", "0", entrys, appId);
        trsfSql.put("YS-SUP-007", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1313081634584572928L, 1, "", "", "", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_217", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_213", (String)"mmc-mrp-common"), "org", "0"));
        entrys.add(new TrsfEntryParam(1313081634584572929L, 2, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599", (String)"InitDataConst_216", (String)"mmc-mrp-common"), "entryentity.material", "materiel", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_154", (String)"mmc-mrp-common"), "materiel", "0"));
        entrys.add(new TrsfEntryParam(1313081634584572930L, 3, "", "demandqty - transferqty", ResManager.loadKDString((String)"\u9700\u6c42\u57fa\u672c\u6570\u91cf - \u5df2\u8c03\u62e8\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_520", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.qty", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9884\u8ba1\u5165\u5e93\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_291", (String)"mmc-mrp-common"), "entryentity.qty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1313081634584572931L, 4, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_298", (String)"mmc-mrp-common"), "entryentity.baseunit", "baseunit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_242", (String)"mmc-mrp-common"), "baseunit", "0"));
        entrys.add(new TrsfEntryParam(1313081634584572932L, 5, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_218", (String)"mmc-mrp-common"), "entryentity.tracknumber", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_194", (String)"mmc-mrp-common"), "tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1313081634584572933L, 6, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u914d\u7f6e\u53f7", (String)"InitDataConst_219", (String)"mmc-mrp-common"), "entryentity.configuredcode", "configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_98", (String)"mmc-mrp-common"), "configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1313081634584572934L, 7, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u65e5\u671f", (String)"InitDataConst_292", (String)"mmc-mrp-common"), "entryentity.billdate", "demanddate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_243", (String)"mmc-mrp-common"), "demanddate", "0"));
        entrys.add(new TrsfEntryParam(1313081634584572935L, 8, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_294", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1313081634584572936L, 9, "", "id", ResManager.loadKDString((String)"\u534f\u540c\u8ba1\u5212\u8ba2\u5355.\u5185\u7801", (String)"InitDataConst_246", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636eID", (String)"InitDataConst_297", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1394033070654357504L, 10, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_308", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "auxproperty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_105", (String)"mmc-mrp-common"), "auxproperty", "0"));
        entrys.add(new TrsfEntryParam(1781829028764768256L, 11, "", "", "", "entryentity.planscope", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ba1\u5212\u8303\u56f4", (String)"InitDataConst_614", (String)"mmc-mrp-common"), "entryentity.planscope", "planscope", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u5212\u8303\u56f4", (String)"InitDataConst_615", (String)"mmc-mrp-common"), "planscope", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1313081634475521024L, "250=70Z5D82P", "YS-SUP-008", ResManager.getLocaleString((String)"\u534f\u540c\u8ba1\u5212\u8ba2\u5355-\u4f9b\u5e94\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_372", (String)"mmc-mrp-common"), "mrp_collaborativeorder", "mrp_supply_model_inh", "0", entrys, appId);
        trsfSql.put("YS-SUP-008", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1448556155528823808L, 1, "", "", "", "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_217", (String)"mmc-mrp-common"), "entryentity.supplyorgunit", "proorpurorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_196", (String)"mmc-mrp-common"), "proorpurorg", "0"));
        entrys.add(new TrsfEntryParam(1448556155528823809L, 2, "", "", "", "entryentity.billdate", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u4f9b\u5e94\u65e5\u671f", (String)"InitDataConst_292", (String)"mmc-mrp-common"), "entryentity.billdate", "availabledate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u53ef\u7528\u65e5\u671f", (String)"InitDataConst_356", (String)"mmc-mrp-common"), "availabledate", "0"));
        entrys.add(new TrsfEntryParam(1448556155528823810L, 3, "", "orderqty -  dropqty ", ResManager.loadKDString((String)"\u8ba2\u5355\u6570\u91cf -  \u6295\u653e\u6570\u91cf", (String)"InitDataConst_358", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.qty", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u9884\u8ba1\u5165\u5e93\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_291", (String)"mmc-mrp-common"), "entryentity.qty", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1448556155528823811L, 4, "", "", "", "entryentity.billnumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636e\u7f16\u7801", (String)"InitDataConst_294", (String)"mmc-mrp-common"), "entryentity.billnumber", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_138", (String)"mmc-mrp-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1448556155528823812L, 5, "", "id", ResManager.loadKDString((String)"\u6a21\u62df\u8ba1\u5212\u8ba2\u5355.\u5185\u7801", (String)"InitDataConst_374", (String)"mmc-mrp-common", (Object[])new Object[0]), "entryentity.billid", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u5355\u636eID", (String)"InitDataConst_297", (String)"mmc-mrp-common"), "entryentity.billid", "", MulLangTableDataInitUtil.string2LocaleString(""), "", "1"));
        entrys.add(new TrsfEntryParam(1448556155528823813L, 6, "", "", "", "entryentity.material", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599", (String)"InitDataConst_216", (String)"mmc-mrp-common"), "entryentity.material", "material", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_154", (String)"mmc-mrp-common"), "material", "0"));
        entrys.add(new TrsfEntryParam(1448556155528823814L, 7, "", "", "", "entryentity.yield", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u6210\u54c1\u7387\uff08%\uff09", (String)"InitDataConst_311", (String)"mmc-mrp-common"), "entryentity.yield", "yield", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6210\u54c1\u7387", (String)"InitDataConst_360", (String)"mmc-mrp-common"), "yield", "0"));
        entrys.add(new TrsfEntryParam(1448556155528823815L, 8, "", "", "", "entryentity.baseunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_298", (String)"mmc-mrp-common"), "entryentity.baseunit", "unit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_155", (String)"mmc-mrp-common"), "unit", "0"));
        entrys.add(new TrsfEntryParam(1448556155528823816L, 9, "", "", "", "entryentity.tracknumber", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_218", (String)"mmc-mrp-common"), "entryentity.tracknumber", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_194", (String)"mmc-mrp-common"), "tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1448556155528823817L, 10, "", "", "", "entryentity.configuredcode", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u914d\u7f6e\u53f7", (String)"InitDataConst_219", (String)"mmc-mrp-common"), "entryentity.configuredcode", "configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_98", (String)"mmc-mrp-common"), "configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1448556155528823818L, 11, "", "", "", "entryentity.materialflexprops", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e.\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_308", (String)"mmc-mrp-common"), "entryentity.materialflexprops", "auxproperty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_105", (String)"mmc-mrp-common"), "auxproperty", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1448556155503656960L, "2IXWGXUWREAC", "YS-SUP-009", ResManager.getLocaleString((String)"\u6a21\u62df\u8ba1\u5212\u8ba2\u5355-\u4f9b\u5e94\u5355\u636e\u5b57\u6bb5\u6620\u5c04", (String)"InitDataConst_375", (String)"mmc-mrp-common"), "mrp_simulateorder", "mrp_supply_model_inh", "0", entrys, appId);
        trsfSql.put("YS-SUP-009", InitDataConst.getTrsfParam(trsfParam));
        return trsfSql;
    }

    protected static Map<String, List<Object[]>> getResRegisParam(ResRegisParam resRegisParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object[]>> map = new LinkedHashMap<String, List<Object[]>>(InitSQLConst.resSql.length);
        for (int i = 0; i < InitSQLConst.resSql.length; ++i) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(1);
            switch (i) {
                case 0: 
                case 1: 
                case 5: {
                    Object[] p = new Object[]{resRegisParam.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{resRegisParam.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{resRegisParam.id, "V1.0", resRegisParam.type, resRegisParam.orgId, resRegisParam.orgId, resRegisParam.id, "C", resRegisParam.defaultctrlstrategy, resRegisParam.businessentity, resRegisParam.number, nowTime, resRegisParam.relativetransfer, "1", resRegisParam.relativeresource, userId, resRegisParam.businesstype, userId, nowTime, resRegisParam.outputmapping, resRegisParam.outputtype, resRegisParam.outtosupply, InitDataConst.getRealAppId(resRegisParam.appId), MulLangTableDataInitUtil.getDefaultLocaleValue(resRegisParam.name)};
                    params.add(p);
                    break;
                }
                case 4: {
                    params.addAll(MulLangTableDataInitUtil.getInsertMulLangTableParams(resRegisParam.id, resRegisParam.name));
                    break;
                }
                case 6: 
                case 13: {
                    Object[] p;
                    for (ResRegisEntryParam entryParam : resRegisParam.entryParams) {
                        p = new Object[]{entryParam.entryId};
                        params.add(p);
                    }
                    break;
                }
                case 7: {
                    Object[] p;
                    for (ResRegisEntryParam entryParam : resRegisParam.entryParams) {
                        p = new Object[]{resRegisParam.id, entryParam.formuladesc, entryParam.bizdatatype, entryParam.signid, entryParam.srctype, entryParam.entryId, entryParam.datatype, MulLangTableDataInitUtil.getDefaultLocaleValue(entryParam.signname), entryParam.seq, entryParam.defaultvalue};
                        params.add(p);
                    }
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    Object[] p;
                    if (i == 8 || i == 9) {
                        for (ResDataConfigParam configParam : resRegisParam.resDataConfigParams) {
                            p = new Object[]{configParam.id};
                            params.add(p);
                        }
                    } else if (i == 10) {
                        for (ResDataConfigParam configParam : resRegisParam.resDataConfigParams) {
                            p = new Object[]{configParam.pkId};
                            params.add(p);
                        }
                    } else if (i == 11) {
                        for (ResDataConfigParam configParam : resRegisParam.resDataConfigParams) {
                            p = new Object[]{configParam.id, configParam.billfieldtransfer, configParam.filter, nowTime, "1", resRegisParam.id, Character.valueOf(configParam.issystemdesign), configParam.id, "C", userId, configParam.filter_tag, configParam.number, configParam.sourcetype, MulLangTableDataInitUtil.getDefaultLocaleValue(configParam.name)};
                            params.add(p);
                        }
                    } else {
                        for (ResDataConfigParam configParam : resRegisParam.resDataConfigParams) {
                            params.addAll(MulLangTableDataInitUtil.getInsertMulLangTableParams(configParam.id, configParam.name));
                        }
                    }
                    break;
                }
                case 14: {
                    for (ResRegisEntryParam entryParam : resRegisParam.entryParams) {
                        params.addAll(MulLangTableDataInitUtil.getInsertMulLangTableParams(entryParam.entryId, entryParam.signname));
                    }
                    break;
                }
            }
            map.put(InitSQLConst.resSql[i], params);
        }
        return map;
    }

    protected Map<String, Map<String, List<Object[]>>> getResSql2Param(Long orgId, String defaultctrlstrategy, String appId) {
        HashMap<String, Map<String, List<Object[]>>> resSql = new HashMap<String, Map<String, List<Object[]>>>(16);
        ArrayList<ResRegisEntryParam> entryParams = new ArrayList<ResRegisEntryParam>(16);
        entryParams.add(new ResRegisEntryParam(1160136768402731008L, 1, "number", ResManager.getLocaleString((String)"\u7f16\u7801", (String)"InitDataConst_146", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731009L, 2, "name", ResManager.getLocaleString((String)"\u540d\u79f0", (String)"InitDataConst_321", (String)"mmc-mrp-common"), "4", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731010L, 3, "status", ResManager.getLocaleString((String)"\u6570\u636e\u72b6\u6001", (String)"InitDataConst_379", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731011L, 4, "creator", ResManager.getLocaleString((String)"\u521b\u5efa\u4eba", (String)"InitDataConst_381", (String)"mmc-mrp-common"), "12", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731012L, 5, "modifier", ResManager.getLocaleString((String)"\u4fee\u6539\u4eba", (String)"InitDataConst_383", (String)"mmc-mrp-common"), "13", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731013L, 6, "enable", ResManager.getLocaleString((String)"\u4f7f\u7528\u72b6\u6001", (String)"InitDataConst_384", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731014L, 7, "createtime", ResManager.getLocaleString((String)"\u521b\u5efa\u65f6\u95f4", (String)"InitDataConst_385", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731015L, 8, "modifytime", ResManager.getLocaleString((String)"\u4fee\u6539\u65f6\u95f4", (String)"InitDataConst_387", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731016L, 9, "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_388", (String)"mmc-mrp-common"), "14", "B", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731017L, 10, "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_391", (String)"mmc-mrp-common"), "14", "B", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731018L, 11, "entryentity.material", ResManager.getLocaleString((String)"\u7269\u6599", (String)"InitDataConst_392", (String)"mmc-mrp-common"), "16", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731019L, 12, "entryentity.materialattr", ResManager.getLocaleString((String)"\u7269\u6599\u5c5e\u6027", (String)"InitDataConst_393", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731020L, 13, "entryentity.planstrategy", ResManager.getLocaleString((String)"\u5236\u9020\u7b56\u7565", (String)"InitDataConst_394", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731021L, 14, "entryentity.isolatedrule", ResManager.getLocaleString((String)"\u9694\u79bb\u89c4\u5219", (String)"InitDataConst_396", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731022L, 15, "entryentity.bomid", MulLangTableDataInitUtil.string2LocaleString("BOMID"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731023L, 16, "entryentity.bomentryid", ResManager.getLocaleString((String)"BOM\u5206\u5f55ID", (String)"InitDataConst_397", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731024L, 17, "entryentity.bomdate", ResManager.getLocaleString((String)"BOM\u65e5\u671f", (String)"InitDataConst_398", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731025L, 18, "entryentity.bomtype", ResManager.getLocaleString((String)"BOM\u7c7b\u578b", (String)"InitDataConst_399", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731026L, 19, "entryentity.qty", ResManager.getLocaleString((String)"\u6d88\u8017\u5b9a\u989d", (String)"InitDataConst_400", (String)"mmc-mrp-common"), "10", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731027L, 20, "entryentity.balanceperiod", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u63d0\u524d\u671f\u504f\u7f6e\u65f6\u95f4", (String)"InitDataConst_402", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731028L, 21, "entryentity.bomnumber", ResManager.getLocaleString((String)"BOM\u7f16\u7801", (String)"InitDataConst_404", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731029L, 22, "entryentity.bomentryseq", ResManager.getLocaleString((String)"BOM\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_405", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731030L, 23, "entryentity.bomversion", ResManager.getLocaleString((String)"BOM\u7248\u672c", (String)"InitDataConst_406", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731031L, 24, "entryentity.moduleversion", ResManager.getLocaleString((String)"\u7ec4\u4ef6BOM\u7248\u672c", (String)"InitDataConst_407", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731032L, 25, "entryentity.moduleproorg", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_408", (String)"mmc-mrp-common"), "14", "B", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731033L, 26, "entryentity.modulesupplyorg", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_409", (String)"mmc-mrp-common"), "14", "B", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731034L, 27, "entryentity.comboxmaterielattr", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u7269\u6599\u5c5e\u6027", (String)"InitDataConst_410", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731035L, 28, "entryentity.ecnversion", ResManager.getLocaleString((String)"ECN\u7248\u672c", (String)"InitDataConst_411", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731036L, 29, "entryentity.moduleecnversion", ResManager.getLocaleString((String)"\u7ec4\u4ef6ECN\u7248\u672c", (String)"InitDataConst_412", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731037L, 30, "entryentity.manuperiod", ResManager.getLocaleString((String)"\u751f\u4ea7\u504f\u7f6e\u671f", (String)"InitDataConst_413", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731038L, 31, "entryentity.unit", ResManager.getLocaleString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_414", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731039L, 32, "entryentity.moduleunit", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_415", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731040L, 33, "entryentity.moduletype", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u7c7b\u578b", (String)"InitDataConst_416", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731041L, 34, "entryentity.modulenumerator", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u7528\u91cf:\u5206\u5b50", (String)"InitDataConst_417", (String)"mmc-mrp-common"), "10", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731042L, 35, "entryentity.moduledenominator", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u7528\u91cf:\u5206\u6bcd", (String)"InitDataConst_418", (String)"mmc-mrp-common"), "10", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731043L, 36, "entryentity.moduleloss", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u56fa\u5b9a\u635f\u8017", (String)"InitDataConst_419", (String)"mmc-mrp-common"), "10", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731044L, 37, "entryentity.modulewaste", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u53d8\u52a8\u635f\u8017\u7387", (String)"InitDataConst_420", (String)"mmc-mrp-common"), "10", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731045L, 38, "entryentity.modulecustype", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u7528\u91cf\u7c7b\u578b", (String)"InitDataConst_421", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731046L, 39, "entryentity.modulesupplytype", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u4f9b\u5e94\u7c7b\u578b", (String)"InitDataConst_422", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731047L, 40, "entryentity.entryreplaceplan", ResManager.getLocaleString((String)"\u66ff\u4ee3\u65b9\u6848", (String)"InitDataConst_423", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731048L, 41, "entryentity.entryisreplaceplanmm", ResManager.getLocaleString((String)"\u66ff\u4ee3\u4e3b\u6599", (String)"InitDataConst_424", (String)"mmc-mrp-common"), "11", "", "false", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731049L, 42, "entryentity.entryisreplace", ResManager.getLocaleString((String)"\u66ff\u4ee3\u4ef6", (String)"InitDataConst_426", (String)"mmc-mrp-common"), "11", "", "false", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731050L, 43, "entryentity.entrypriority", ResManager.getLocaleString((String)"\u66ff\u4ee3\u4f18\u5148\u7ea7", (String)"InitDataConst_427", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731051L, 44, "entryentity.replacestra", ResManager.getLocaleString((String)"\u66ff\u4ee3\u7b56\u7565", (String)"InitDataConst_92", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731052L, 45, "entryentity.replacemethod", ResManager.getLocaleString((String)"\u66ff\u4ee3\u65b9\u5f0f", (String)"InitDataConst_95", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731053L, 46, "entryentity.validdate", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u751f\u6548\u65e5\u671f", (String)"InitDataConst_428", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731054L, 47, "entryentity.invaliddate", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u5931\u6548\u65e5\u671f", (String)"InitDataConst_429", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731055L, 48, "entryentity.ctrlstrategy", ResManager.getLocaleString((String)"\u7ba1\u63a7\u7b56\u7565", (String)"InitDataConst_430", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731056L, 49, "entryentity.ispassreq", ResManager.getLocaleString((String)"\u662f\u5426\u4f20\u9012", (String)"InitDataConst_431", (String)"mmc-mrp-common"), "11", "", "false", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731057L, 50, "entryentity.isjump", ResManager.getLocaleString((String)"\u662f\u5426\u8df3\u5c42", (String)"InitDataConst_432", (String)"mmc-mrp-common"), "11", "", "false", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731058L, 51, "entryentity.billstatusfield", ResManager.getLocaleString((String)"\u5355\u636e\u72b6\u6001", (String)"InitDataConst_433", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731059L, 52, "entryentity.projectnumber", ResManager.getLocaleString((String)"\u9879\u76ee\u53f7", (String)"InitDataConst_434", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731060L, 53, "entryentity.endtracknumber", ResManager.getLocaleString((String)"\u7ed3\u675f\u8ddf\u8e2a\u53f7", (String)"InitDataConst_435", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731061L, 54, "entryentity.begintracknumber", ResManager.getLocaleString((String)"\u5f00\u59cb\u8ddf\u8e2a\u53f7", (String)"InitDataConst_436", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136768402731062L, 55, "entryentity.comboxmateriel", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u7269\u6599", (String)"InitDataConst_437", (String)"mmc-mrp-common"), "16", "A", "", "", ""));
        ArrayList<ResDataConfigParam> resDataConfigParams = new ArrayList<ResDataConfigParam>(16);
        resDataConfigParams.add(new ResDataConfigParam(962936861200797696L, "1MH2JSA=/57Y", "bom-regist", ResManager.getLocaleString((String)"BOM\u6570\u636e\u6e90", (String)"InitDataConst_438", (String)"mmc-mrp-common"), 962925544213630976L, '0', "", "{\"filterRow\":[{\"id\":\"1MCNZL55HAU3\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"status\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1MCNZL55HPMR\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"1MCNZL55HAU4\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"enable\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1MCNZL55HPMS\",\"value\":\"1\"}],\"baseDataIds\":[]},{\"id\":\"1MCNZL55HAU5\",\"leftBracket\":\"\",\"compareType\":\"21\",\"fieldName\":\"entryqtynumerator\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1MCNZL55HPMT\",\"value\":\"0\"}],\"baseDataIds\":[]},{\"id\":\"1MCNZL55HAU6\",\"leftBracket\":\"\",\"compareType\":\"21\",\"fieldName\":\"entryqtydenominator\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1MCNZL55HPMU\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1282558898322068480L, "2/IOJBRDPZ1Q", "bom-cop-regist", ResManager.getLocaleString((String)"\u8054\u526f\u4ea7\u54c1BOM", (String)"InitDataConst_439", (String)"mmc-mrp-common"), 1281137808701963264L, '0', "", "{\"filterRow\":[{\"id\":\"2/ILLQKFKYR6\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"status\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2/ILLQKFKY1Y\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2/ILLQKFKYR7\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"enable\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2/ILLQKFKY1Z\",\"value\":\"1\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        ResRegisParam resRegisParam = new ResRegisParam(orgId, defaultctrlstrategy, 962843094548526080L, "1MH2JS7R7CXF", "bomregist", ResManager.getLocaleString((String)"BOM\u6a21\u578b", (String)"InitDataConst_440", (String)"mmc-mrp-common"), "03", "01", "mrp_bomexpand_model_inh", 0L, 0L, 0L, "", 0L, entryParams, resDataConfigParams, appId);
        resSql.put("bomregist", InitDataConst.getResRegisParam(resRegisParam));
        entryParams = new ArrayList(16);
        entryParams.add(new ResRegisEntryParam(1160136772496247808L, 1, "number", ResManager.getLocaleString((String)"\u7f16\u7801", (String)"InitDataConst_146", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247809L, 2, "name", ResManager.getLocaleString((String)"\u540d\u79f0", (String)"InitDataConst_321", (String)"mmc-mrp-common"), "4", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247810L, 3, "status", ResManager.getLocaleString((String)"\u6570\u636e\u72b6\u6001", (String)"InitDataConst_379", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247811L, 4, "creator", ResManager.getLocaleString((String)"\u521b\u5efa\u4eba", (String)"InitDataConst_381", (String)"mmc-mrp-common"), "12", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247812L, 5, "modifier", ResManager.getLocaleString((String)"\u4fee\u6539\u4eba", (String)"InitDataConst_383", (String)"mmc-mrp-common"), "13", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247813L, 6, "enable", ResManager.getLocaleString((String)"\u4f7f\u7528\u72b6\u6001", (String)"InitDataConst_384", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247814L, 7, "createtime", ResManager.getLocaleString((String)"\u521b\u5efa\u65f6\u95f4", (String)"InitDataConst_385", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247815L, 8, "modifytime", ResManager.getLocaleString((String)"\u4fee\u6539\u65f6\u95f4", (String)"InitDataConst_387", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247816L, 9, "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_391", (String)"mmc-mrp-common"), "14", "B", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247817L, 10, "entryentity.material", ResManager.getLocaleString((String)"\u7269\u6599", (String)"InitDataConst_392", (String)"mmc-mrp-common"), "16", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247818L, 11, "entryentity.materialattr", ResManager.getLocaleString((String)"\u7269\u6599\u5c5e\u6027", (String)"InitDataConst_393", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247819L, 12, "entryentity.planstrategy", ResManager.getLocaleString((String)"\u5236\u9020\u7b56\u7565", (String)"InitDataConst_394", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247820L, 13, "entryentity.isolatedrule", ResManager.getLocaleString((String)"\u9694\u79bb\u89c4\u5219", (String)"InitDataConst_396", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247821L, 14, "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u65e5\u671f", (String)"InitDataConst_441", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247822L, 15, "entryentity.billtype", ResManager.getLocaleString((String)"\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_442", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247823L, 16, "entryentity.biztype", ResManager.getLocaleString((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"InitDataConst_443", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247824L, 17, "entryentity.usablestoqty", ResManager.getLocaleString((String)"\u53ef\u7528\u5e93\u5b58\u91cf", (String)"InitDataConst_444", (String)"mmc-mrp-common"), "10", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247825L, 18, "entryentity.qty", ResManager.getLocaleString((String)"\u9884\u8ba1\u5165\u5e93\u91cf", (String)"InitDataConst_445", (String)"mmc-mrp-common"), "10", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247826L, 19, "entryentity.computingperiod", ResManager.getLocaleString((String)"\u8ba1\u7b97\u671f\u95f4", (String)"InitDataConst_446", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247827L, 20, "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u7f16\u7801", (String)"InitDataConst_447", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247828L, 21, "entryentity.billstatusfield", ResManager.getLocaleString((String)"\u5355\u636e\u72b6\u6001", (String)"InitDataConst_433", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247829L, 22, "entryentity.produnit", ResManager.getLocaleString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_414", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247830L, 23, "entryentity.baseunit", ResManager.getLocaleString((String)"\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_448", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247831L, 24, "entryentity.projectnumber", ResManager.getLocaleString((String)"\u9879\u76ee\u53f7", (String)"InitDataConst_434", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247832L, 25, "entryentity.tracknumber", ResManager.getLocaleString((String)"\u8ddf\u8e2a\u53f7", (String)"InitDataConst_449", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247833L, 26, "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636eID", (String)"InitDataConst_450", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247834L, 27, "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_451", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247835L, 28, "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_452", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247836L, 29, "entryentity.istock", ResManager.getLocaleString((String)"\u662f\u5426\u5e93\u5b58\u6570\u636e", (String)"InitDataConst_453", (String)"mmc-mrp-common"), "11", "", "false", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247837L, 30, "entryentity.yield", ResManager.getLocaleString((String)"\u6210\u54c1\u7387\uff08%\uff09", (String)"InitDataConst_454", (String)"mmc-mrp-common"), "10", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247838L, 31, "entryentity.stock", ResManager.getLocaleString((String)"\u4ed3\u5e93", (String)"InitDataConst_455", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247839L, 32, "entryentity.stockindex", ResManager.getLocaleString((String)"\u4ed3\u4f4d", (String)"InitDataConst_456", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247840L, 33, "entryentity.stocktype", ResManager.getLocaleString((String)"\u5e93\u5b58\u7c7b\u578b", (String)"InitDataConst_457", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247841L, 34, "entryentity.stockstatus", ResManager.getLocaleString((String)"\u5e93\u5b58\u72b6\u6001", (String)"InitDataConst_458", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247842L, 35, "entryentity.supplyorgname", ResManager.getLocaleString((String)"\u5e93\u5b58\u7ec4\u7ec7\u540d\u79f0", (String)"InitDataConst_459", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247843L, 36, "entryentity.warehousename", ResManager.getLocaleString((String)"\u4ed3\u5e93\u540d\u79f0", (String)"InitDataConst_460", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247844L, 37, "entryentity.locationname", ResManager.getLocaleString((String)"\u4ed3\u4f4d\u540d\u79f0", (String)"InitDataConst_461", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136772496247845L, 38, "entryentity.warehousenumber", ResManager.getLocaleString((String)"\u4ed3\u5e93\u7f16\u7801", (String)"InitDataConst_462", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        resDataConfigParams = new ArrayList(16);
        resDataConfigParams.add(new ResDataConfigParam(1018922143968185344L, "1MH2JTS6493S", "SJYPZ-SUP-001", ResManager.getLocaleString((String)"\u5373\u65f6\u5e93\u5b58", (String)"InitDataConst_463", (String)"mmc-mrp-common"), 996334374087561216L, '0', "", "{\"filterRow\":[{\"id\":\"1M55IJD+HBON\",\"leftBracket\":\"\",\"compareType\":\"21\",\"fieldName\":\"baseqty\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1M55IJD+HQH=\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(967449431219693568L, "1MH2JTJQ5GL3", "SJYPZ-SUP-002", ResManager.getLocaleString((String)"\u751f\u4ea7\u5de5\u5355", (String)"InitDataConst_464", (String)"mmc-mrp-common"), 1019614409246389248L, '0', "", "{\"filterRow\":[{\"id\":\"2FT6+AH2CTVJ\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"taskstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT6+AH2AZU3\",\"value\":\"A\"},{\"id\":\"2FT6+AH2CTVK\",\"value\":\"B\"},{\"id\":\"2FT6+AH2AZU4\",\"value\":\"D\"}],\"baseDataIds\":[]},{\"id\":\"2FT6+AH2CTVL\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"bizstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT6+AH2AZU5\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2FT6+AH2CTVM\",\"leftBracket\":\"(((\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"1\",\"value\":[{\"id\":\"2FT6+AH2AZU6\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2FT6+AH2CTVN\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT6+AH2AZU7\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"2FT6+AH2CTVO\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"sourcebilltype\",\"rightBracket\":\")\",\"logic\":\"1\",\"value\":[{\"id\":\"2FT6+AH2AZU8\",\"value\":\"mrp_planorder\"}],\"baseDataIds\":[]},{\"id\":\"2FT6+AH2CTVP\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT6+AH2AZU9\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2FT6+AH2CTVQ\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"transactiontype.transactiontype.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT6+AH2AZU=\",\"value\":\"401\"}],\"baseDataIds\":[{\"id\":\"2FT6+AH2CTVR\",\"value\":\"738166303168232448\"}]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(962968236230461440L, "1MH2JTFMO=KK", "SJYPZ-SUP-003", ResManager.getLocaleString((String)"\u91c7\u8d2d\u7533\u8bf7\u5355", (String)"InitDataConst_465", (String)"mmc-mrp-common"), 1019614408390751232L, '0', "", "{\"filterRow\":[{\"id\":\"2KZWO5V=UG99\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowclosestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KZWO5V=TPN+\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2KZWO5V=UG9=\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowterminatestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KZWO5V=TPN/\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2KZWO5V=UG9A\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"closestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KZWO5V=TPN0\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2KZWO5V=UG9B\",\"leftBracket\":\"(((\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"1\",\"value\":[{\"id\":\"2KZWO5V=TPN1\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2KZWO5V=UG9C\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"2KZWO5V=TPN2\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"2KZWO5V=UG9D\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"srcbillentity\",\"rightBracket\":\")\",\"logic\":\"1\",\"value\":[{\"id\":\"2KZWO5V=TPN3\",\"value\":\"mrp_planorder\"}],\"baseDataIds\":[]},{\"id\":\"2KZWO5V=UG9E\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"2KZWO5V=TPN4\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2KZWO5V=UG9F\",\"leftBracket\":\"\",\"compareType\":\"9\",\"fieldName\":\"reqdate\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KZWO5V=TPN5\",\"value\":\"\"}],\"baseDataIds\":[]},{\"id\":\"2KZWO5V=UG9G\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"billtype.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KZWO5V=TPN6\",\"value\":\"pm_purapplybill_EMS_BT_S\"},{\"id\":\"2KZWO5V=UG9H\",\"value\":\"pm_PurApplyBill_STD_BT_S\"}],\"baseDataIds\":[{\"id\":\"2KZWO5V=TPN7\",\"value\":\"539008374826629120\"},{\"id\":\"2KZWO5V=UG9I\",\"value\":\"1002796011481277440\"}]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1079657214567803904L, "1MH2JTVQ+3X=", "SJYPZ-SUP-004", ResManager.getLocaleString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"InitDataConst_466", (String)"mmc-mrp-common"), 1019614409137337344L, '0', "", "{\"filterRow\":[{\"id\":\"3KVE71WN=R73\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowclosestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KVE71WN=/92\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KVE71WN=R74\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowterminatestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KVE71WN=/93\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KVE71WN=R75\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"closestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KVE71WN=/94\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KVE71WN=R76\",\"leftBracket\":\"(((\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"1\",\"value\":[{\"id\":\"3KVE71WN=/95\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KVE71WN=R77\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"3KVE71WN=/96\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"3KVE71WN=R78\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"srcbillentity\",\"rightBracket\":\")\",\"logic\":\"1\",\"value\":[{\"id\":\"3KVE71WN=/97\",\"value\":\"mrp_planorder\"}],\"baseDataIds\":[]},{\"id\":\"3KVE71WN=R79\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"3KVE71WN=/98\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3KVE71WN=R7=\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"billtype.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KVE71WN=/99\",\"value\":\"pm_PurOrderBill_EMS_BT_S\"},{\"id\":\"3KVE71WN=R7A\",\"value\":\"pm_PurOrderBill_STD_BT_S\"}],\"baseDataIds\":[{\"id\":\"3KVE71WN=/9=\",\"value\":\"539008795674673152\"},{\"id\":\"3KVE71WN=R7B\",\"value\":\"1005695800258488320\"}]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(980345552879270912L, "1MH2JTN1RI+L", "SJYPZ-SUP-005", ResManager.getLocaleString((String)"\u8ba1\u5212\u8ba2\u5355", (String)"InitDataConst_467", (String)"mmc-mrp-common"), 976007551319598080L, '0', "", "{\"filterRow\":[{\"id\":\"1M55EABADIVX\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1M55EABADXOJ\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1245592901841372160L, "1XL9E9YZO71S", "SJYPZ-SUP-006", ResManager.getLocaleString((String)"\u59d4\u5916\u5de5\u5355", (String)"InitDataConst_468", (String)"mmc-mrp-common"), 1245512022473325568L, '0', "", "{\"filterRow\":[{\"id\":\"2FT61+6SJ82B\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"taskstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT61+6SL23S\",\"value\":\"A\"},{\"id\":\"2FT61+6SJ82C\",\"value\":\"B\"},{\"id\":\"2FT61+6SL23T\",\"value\":\"D\"}],\"baseDataIds\":[]},{\"id\":\"2FT61+6SJ82D\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"bizstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT61+6SL23U\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2FT61+6SJ82E\",\"leftBracket\":\"(((\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"1\",\"value\":[{\"id\":\"2FT61+6SL23V\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2FT61+6SJ82F\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT61+6SL23W\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"2FT61+6SJ82G\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"sourcebilltype\",\"rightBracket\":\")\",\"logic\":\"1\",\"value\":[{\"id\":\"2FT61+6SL23X\",\"value\":\"mrp_planorder\"}],\"baseDataIds\":[]},{\"id\":\"2FT61+6SJ82H\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT61+6SL23Y\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2FT61+6SJ82I\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"transactiontype.transactiontype.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT61+6SL23Z\",\"value\":\"601\"}],\"baseDataIds\":[{\"id\":\"2FT61+6SJ82J\",\"value\":\"1213802446967548928\"}]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1281148003368876032L, "2/IOJBRDPZ1S", "SJYPZ-SUP-007", ResManager.getLocaleString((String)"\u8ba1\u5212\u8ba2\u5355\uff08\u8054\u526f\u4ea7\u54c1\uff09", (String)"InitDataConst_469", (String)"mmc-mrp-common"), 1281137811671530496L, '0', "", "{\"filterRow\":[{\"id\":\"2/BV+KBBRMOT\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2/BV+KBBRM/J\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2/BV+KBBRMOU\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"copentrytype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2/BV+KBBRM/K\",\"value\":\"10720\"},{\"id\":\"2/BV+KBBRMOV\",\"value\":\"10730\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1313083040506884096L, "250WS6P5DBA6", "SJYPZ-SUP-008", ResManager.getLocaleString((String)"\u534f\u540c\u8ba1\u5212\u8ba2\u5355", (String)"InitDataConst_470", (String)"mmc-mrp-common"), 1313081634475521024L, '0', "", "{\"filterRow\":[{\"id\":\"239UXN1JP5O6\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"239UXN1JP5+Y\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1465252855689577472L, "2KZW6H/V2MN+", "SJYPZ-SUP-020", ResManager.getLocaleString((String)"\u59d4\u5916\u8ba2\u5355", (String)"InitDataConst_471", (String)"mmc-mrp-common"), 1465244867050406912L, '0', "", "{\"filterRow\":[{\"id\":\"2KZWL6=GA=OY\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowclosestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KZWL6=G=J1N\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2KZWL6=GA=OZ\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowterminatestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KZWL6=G=J1O\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2KZWL6=GA=P+\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"closestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KZWL6=G=J1P\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2KZWL6=GA=P/\",\"leftBracket\":\"((\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"1\",\"value\":[{\"id\":\"2KZWL6=G=J1Q\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2KZWL6=GA=P0\",\"leftBracket\":\"(\",\"compareType\":\"17\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KZWL6=G=J1R\",\"value\":\"A\"},{\"id\":\"2KZWL6=GA=P1\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"2KZWL6=G=J1S\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"srcbillentity\",\"rightBracket\":\"))\",\"logic\":\"0\",\"value\":[{\"id\":\"2KZWL6=GA=P2\",\"value\":\"mrp_planorder\"}],\"baseDataIds\":[]},{\"id\":\"2KZWL6=G=J1T\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"billtype.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KZWL6=GA=P3\",\"value\":\"pm_om_purorderbill_BT_S\"}],\"baseDataIds\":[{\"id\":\"2KZWL6=G=J1U\",\"value\":\"970978758402036736\"}]}],\"forList\":false}", "mrp"));
        resRegisParam = new ResRegisParam(orgId, defaultctrlstrategy, 962960690602102784L, "1MH2JTD3S2CQ", "supplyresource", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6a21\u578b", (String)"InitDataConst_472", (String)"mmc-mrp-common"), "01", "01", "mrp_supply_model_inh", 0L, 0L, 0L, "", 976007551319598080L, entryParams, resDataConfigParams, appId);
        resSql.put("supplyresource", InitDataConst.getResRegisParam(resRegisParam));
        entryParams = new ArrayList(16);
        entryParams.add(new ResRegisEntryParam(1160136769207913472L, 1, "number", ResManager.getLocaleString((String)"\u7f16\u7801", (String)"InitDataConst_146", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913473L, 2, "name", ResManager.getLocaleString((String)"\u540d\u79f0", (String)"InitDataConst_321", (String)"mmc-mrp-common"), "4", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913474L, 3, "status", ResManager.getLocaleString((String)"\u6570\u636e\u72b6\u6001", (String)"InitDataConst_379", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913475L, 4, "creator", ResManager.getLocaleString((String)"\u521b\u5efa\u4eba", (String)"InitDataConst_381", (String)"mmc-mrp-common"), "12", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913476L, 5, "modifier", ResManager.getLocaleString((String)"\u4fee\u6539\u4eba", (String)"InitDataConst_383", (String)"mmc-mrp-common"), "13", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913477L, 6, "enable", ResManager.getLocaleString((String)"\u4f7f\u7528\u72b6\u6001", (String)"InitDataConst_384", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913478L, 7, "createtime", ResManager.getLocaleString((String)"\u521b\u5efa\u65f6\u95f4", (String)"InitDataConst_385", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913479L, 8, "modifytime", ResManager.getLocaleString((String)"\u4fee\u6539\u65f6\u95f4", (String)"InitDataConst_387", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913480L, 9, "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_388", (String)"mmc-mrp-common"), "14", "B", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913481L, 10, "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_391", (String)"mmc-mrp-common"), "14", "B", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913482L, 11, "entryentity.material", ResManager.getLocaleString((String)"\u7269\u6599", (String)"InitDataConst_392", (String)"mmc-mrp-common"), "16", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913483L, 12, "entryentity.materialattr", ResManager.getLocaleString((String)"\u7269\u6599\u5c5e\u6027", (String)"InitDataConst_393", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913484L, 13, "entryentity.planstrategy", ResManager.getLocaleString((String)"\u5236\u9020\u7b56\u7565", (String)"InitDataConst_394", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913485L, 14, "entryentity.isolatedrule", ResManager.getLocaleString((String)"\u9694\u79bb\u89c4\u5219", (String)"InitDataConst_396", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913486L, 15, "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636eID", (String)"InitDataConst_450", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913487L, 16, "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u65e5\u671f", (String)"InitDataConst_441", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913488L, 17, "entryentity.billtype", ResManager.getLocaleString((String)"\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_442", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913489L, 18, "entryentity.biztype", ResManager.getLocaleString((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"InitDataConst_443", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913490L, 19, "entryentity.demandqty", ResManager.getLocaleString((String)"\u9700\u6c42\u6570\u91cf", (String)"InitDataConst_473", (String)"mmc-mrp-common"), "10", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913491L, 20, "entryentity.computingperiod", ResManager.getLocaleString((String)"\u8ba1\u7b97\u671f\u95f4", (String)"InitDataConst_446", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913492L, 21, "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u7f16\u7801", (String)"InitDataConst_447", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913493L, 22, "entryentity.billstatusfield", ResManager.getLocaleString((String)"\u5355\u636e\u72b6\u6001", (String)"InitDataConst_433", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913494L, 23, "entryentity.produnit", ResManager.getLocaleString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_414", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913495L, 24, "entryentity.baseunit", ResManager.getLocaleString((String)"\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_448", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913496L, 25, "entryentity.projectnumber", ResManager.getLocaleString((String)"\u9879\u76ee\u53f7", (String)"InitDataConst_434", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913497L, 26, "entryentity.tracknumber", ResManager.getLocaleString((String)"\u8ddf\u8e2a\u53f7", (String)"InitDataConst_449", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913498L, 27, "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_451", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913499L, 28, "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_452", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913500L, 29, "entryentity.istock", ResManager.getLocaleString((String)"\u662f\u5426\u5e93\u5b58\u6570\u636e", (String)"InitDataConst_453", (String)"mmc-mrp-common"), "11", "", "false", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913501L, 30, "entryentity.isdemand", ResManager.getLocaleString((String)"\u662f\u5426\u9884\u6d4b\u9700\u6c42", (String)"InitDataConst_474", (String)"mmc-mrp-common"), "11", "", "false", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913502L, 31, "entryentity.ecnversion", ResManager.getLocaleString((String)"ECN\u7248\u672c", (String)"InitDataConst_411", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913503L, 32, "entryentity.demandsourcetype", ResManager.getLocaleString((String)"\u9700\u6c42\u6765\u6e90\u7c7b\u578b", (String)"InitDataConst_475", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913504L, 33, "entryentity.materialname", ResManager.getLocaleString((String)"\u7269\u6599\u540d\u79f0", (String)"InitDataConst_476", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913505L, 34, "entryentity.materialnumber", ResManager.getLocaleString((String)"\u7269\u6599\u7f16\u7801", (String)"InitDataConst_477", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913506L, 35, "entryentity.productorgname", ResManager.getLocaleString((String)"\u751f\u4ea7\u7ec4\u7ec7\u540d\u79f0", (String)"InitDataConst_478", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913507L, 36, "entryentity.productorgnumber", ResManager.getLocaleString((String)"\u751f\u4ea7\u7ec4\u7ec7\u7f16\u7801", (String)"InitDataConst_479", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913508L, 37, "entryentity.mdsdemandtype", ResManager.getLocaleString((String)"\u9700\u6c42\u7c7b\u578b", (String)"InitDataConst_480", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913509L, 38, "entryentity.invaliddate", ResManager.getLocaleString((String)"\u5931\u6548\u65f6\u95f4", (String)"InitDataConst_481", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913510L, 39, "entryentity.safeinvdays", ResManager.getLocaleString((String)"\u5b89\u5168\u5e93\u5b58\u5c55\u671b\u671f", (String)"InitDataConst_482", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913511L, 40, "entryentity.safeinvtype", ResManager.getLocaleString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b", (String)"InitDataConst_483", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1160136769207913512L, 41, "entryentity.bomnumber", ResManager.getLocaleString((String)"BOM\u7f16\u7801", (String)"InitDataConst_404", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        resDataConfigParams = new ArrayList(16);
        resDataConfigParams.add(new ResDataConfigParam(1018652116748652544L, "1MH2JSUC7UUP", "SJYPZ-REQ-001", ResManager.getLocaleString((String)"\u51c0\u9700\u6c42\u8ba1\u5212", (String)"InitDataConst_484", (String)"mmc-mrp-common"), 1019614409087004672L, '0', "", "{\"filterRow\":[{\"id\":\"2L8DZS0CP5T3\",\"leftBracket\":\"\",\"compareType\":\"21\",\"fieldName\":\"fcqty\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2L8DZS0CP53V\",\"value\":\"0\"}],\"baseDataIds\":[]},{\"id\":\"2L8DZS0CP5T4\",\"leftBracket\":\"\",\"compareType\":\"9\",\"fieldName\":\"prodorg.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2L8DZS0CP53W\",\"value\":\"\"}],\"baseDataIds\":[]},{\"id\":\"2L8DZS0CP5T5\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"fcvrnnum.group.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2L8DZS0CP53X\",\"value\":\"1\"}],\"baseDataIds\":[{\"id\":\"2L8DZS0CP5T6\",\"value\":\"859139225407615000\"}]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1078219665676709888L, "1MH2JT09F47=", "SJYPZ-REQ-002", ResManager.getLocaleString((String)"\u5b89\u5168\u5e93\u5b58", (String)"InitDataConst_485", (String)"mmc-mrp-common"), 1019614408164257792L, '0', "", "{\"filterRow\":[{\"id\":\"1M54KGLUPKC8\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"status\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1M54KGLUP6JL\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"1M54KGLUPKC9\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"enable\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1M54KGLUP6JM\",\"value\":\"1\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1078980451135151104L, "1MH2JT96J+PI", "SJYPZ-REQ-003", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u6e05\u5355", (String)"InitDataConst_486", (String)"mmc-mrp-common"), 1019614403357585408L, '0', "", "{\"filterRow\":[{\"id\":\"3KLZOWAIEIEY\",\"leftBracket\":\"\",\"compareType\":\"21\",\"fieldName\":\"cansendqty\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZOWAIF9CZ\",\"value\":\"0\"}],\"baseDataIds\":[]},{\"id\":\"3KLZOWAIEIEZ\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"orderentryid.bizstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZOWAIF9D+\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KLZOWAIEIF+\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"orderentryid.taskstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZOWAIF9D/\",\"value\":\"A\"},{\"id\":\"3KLZOWAIEIF/\",\"value\":\"B\"},{\"id\":\"3KLZOWAIF9D0\",\"value\":\"D\"}],\"baseDataIds\":[]},{\"id\":\"3KLZOWAIEIF0\",\"leftBracket\":\"((\",\"compareType\":\"67\",\"fieldName\":\"orderentryid.sourcebilltype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZOWAIF9D1\",\"value\":\"mrp_planorder\"}],\"baseDataIds\":[]},{\"id\":\"3KLZOWAIEIF1\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"1\",\"value\":[{\"id\":\"3KLZOWAIF9D2\",\"value\":\"A\"},{\"id\":\"3KLZOWAIEIF2\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"3KLZOWAIF9D3\",\"leftBracket\":\"(\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"))\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZOWAIEIF3\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3KLZOWAIF9D4\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"isjumplevel\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZOWAIEIF4\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1078219830345084928L, "1MH2JT56O7WH", "SJYPZ-REQ-004", ResManager.getLocaleString((String)"\u8d1f\u5e93\u5b58", (String)"InitDataConst_487", (String)"mmc-mrp-common"), 1005802947428222976L, '0', "", "{\"filterRow\":[{\"id\":\"1PLQB0E+PK7I\",\"leftBracket\":\"\",\"compareType\":\"36\",\"fieldName\":\"baseqty\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1PLQB0E+NU7M\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1078219453075828736L, "1MH2JSY9KCD9", "SJYPZ-REQ-005", ResManager.getLocaleString((String)"\u9500\u552e\u8ba2\u5355\uff08\u51b2\u51cf\uff09", (String)"InitDataConst_488", (String)"mmc-mrp-common"), 1067478024938605568L, '0', "", "{\"filterRow\":[{\"id\":\"1M54PSKRF823\",\"leftBracket\":\"\",\"compareType\":\"83\",\"fieldName\":\"fnqty\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1M54PSKREV9G\",\"value\":\"0\"}],\"baseDataIds\":[]},{\"id\":\"1M54PSKRF824\",\"leftBracket\":\"\",\"compareType\":\"9\",\"fieldName\":\"orgsite.name\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1M54PSKREV9H\",\"value\":\"\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(962947433724170240L, "1MH2JSQ+VE8M", "SJYPZ-REQ-006", ResManager.getLocaleString((String)"\u9700\u6c42\u7533\u8bf7\u5355", (String)"InitDataConst_489", (String)"mmc-mrp-common"), 973715393191398400L, '0', "", "{\"filterRow\":[{\"id\":\"2DXLYMQTPCES\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2DXLYMQTTCM9\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2DXLYMQTPCET\",\"leftBracket\":\"\",\"compareType\":\"9\",\"fieldName\":\"reqdate\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2DXLYMQTTCM=\",\"value\":\"\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1181116955797516288L, "1PLL4QHMTV=A", "SJYPZ-REQ-007", ResManager.getLocaleString((String)"\u8ba1\u5212\u8ba2\u5355\u5206\u5f55", (String)"InitDataConst_490", (String)"mmc-mrp-common"), 1181114675790629888L, '0', "", "{\"filterRow\":[{\"id\":\"3KLZNYLLYUL/\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZNYLLY2N+\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3KLZNYLLYUL0\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"ordertype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZNYLLY2N/\",\"value\":\"10030\"},{\"id\":\"3KLZNYLLYUL1\",\"value\":\"10050\"}],\"baseDataIds\":[]},{\"id\":\"3KLZNYLLY2N0\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"entryisjumplevel\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZNYLLYUL2\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1247207017123204096L, "1XL91VEF2BCV", "SJYPZ-REQ-008", ResManager.getLocaleString((String)"\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355", (String)"InitDataConst_491", (String)"mmc-mrp-common"), 1247202796302814208L, '0', "", "{\"filterRow\":[{\"id\":\"3KLZQP4MJ59T\",\"leftBracket\":\"\",\"compareType\":\"21\",\"fieldName\":\"cansendqty\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZQP4MJX7U\",\"value\":\"0\"}],\"baseDataIds\":[]},{\"id\":\"3KLZQP4MJ59U\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"orderentryid.bizstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZQP4MJX7V\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KLZQP4MJ59V\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"orderentryid.taskstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZQP4MJX7W\",\"value\":\"A\"},{\"id\":\"3KLZQP4MJ59W\",\"value\":\"B\"},{\"id\":\"3KLZQP4MJX7X\",\"value\":\"D\"}],\"baseDataIds\":[]},{\"id\":\"3KLZQP4MJ59X\",\"leftBracket\":\"((\",\"compareType\":\"67\",\"fieldName\":\"orderentryid.sourcebilltype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZQP4MJX7Y\",\"value\":\"mrp_planorder\"}],\"baseDataIds\":[]},{\"id\":\"3KLZQP4MJ59Y\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"1\",\"value\":[{\"id\":\"3KLZQP4MJX7Z\",\"value\":\"A\"},{\"id\":\"3KLZQP4MJ59Z\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"3KLZQP4MJX8+\",\"leftBracket\":\"(\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"))\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZQP4MJ5=+\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3KLZQP4MJX8/\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"isjumplevel\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KLZQP4MJ5=/\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1313068163914595328L, "250WPDFKJ+R6", "SJYPZ-REQ-009", ResManager.getLocaleString((String)"\u534f\u540c\u8ba1\u5212\u8ba2\u5355", (String)"InitDataConst_470", (String)"mmc-mrp-common"), 1313064178679872512L, '0', "", "{\"filterRow\":[{\"id\":\"239TWEXBC2H7\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"239TWEXBC35G\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1779825890142727168L, "3KLZTTPB8AK0", "SJYPZ-REQ-010", ResManager.getLocaleString((String)"\u9500\u552e\u8ba2\u5355", (String)"InitDataConst_495", (String)"mmc-mrp-common"), 1393295046425479168L, '0', "", "{\"filterRow\":[{\"id\":\"3KWA5OMCFW1H\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KWA5OMCFWQR\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3KWA5OMCFW1I\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowclosestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KWA5OMCFWQS\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KWA5OMCFW1J\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowterminatestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KWA5OMCFWQT\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KWA5OMCFW1K\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"material.masterid.suite\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KWA5OMCFWQU\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resRegisParam = new ResRegisParam(orgId, defaultctrlstrategy, 962938347762799616L, "1MH2JSFOCAVP", "requireresource", ResManager.getLocaleString((String)"\u9700\u6c42\u6a21\u578b", (String)"InitDataConst_492", (String)"mmc-mrp-common"), "02", "01", "mrp_demandbill_model_inh", 962843094548526080L, 962938205651391488L, 1228983485314631680L, "mrp_planorder", 0L, entryParams, resDataConfigParams, appId);
        resSql.put("requireresource", InitDataConst.getResRegisParam(resRegisParam));
        entryParams = new ArrayList(16);
        entryParams.add(new ResRegisEntryParam(1448562494959271936L, 1, "number", ResManager.getLocaleString((String)"\u7f16\u7801", (String)"InitDataConst_146", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271937L, 2, "name", ResManager.getLocaleString((String)"\u540d\u79f0", (String)"InitDataConst_321", (String)"mmc-mrp-common"), "4", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271938L, 3, "status", ResManager.getLocaleString((String)"\u6570\u636e\u72b6\u6001", (String)"InitDataConst_379", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271939L, 4, "creator", ResManager.getLocaleString((String)"\u521b\u5efa\u4eba", (String)"InitDataConst_381", (String)"mmc-mrp-common"), "12", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271940L, 5, "modifier", ResManager.getLocaleString((String)"\u4fee\u6539\u4eba", (String)"InitDataConst_383", (String)"mmc-mrp-common"), "13", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271941L, 6, "enable", ResManager.getLocaleString((String)"\u4f7f\u7528\u72b6\u6001", (String)"InitDataConst_384", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271942L, 7, "createtime", ResManager.getLocaleString((String)"\u521b\u5efa\u65f6\u95f4", (String)"InitDataConst_385", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271943L, 8, "modifytime", ResManager.getLocaleString((String)"\u4fee\u6539\u65f6\u95f4", (String)"InitDataConst_387", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271944L, 9, "entryentity.productionorgunit", ResManager.getLocaleString((String)"\u9700\u6c42\u7ec4\u7ec7", (String)"InitDataConst_388", (String)"mmc-mrp-common"), "14", "B", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271945L, 10, "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_391", (String)"mmc-mrp-common"), "14", "B", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271946L, 11, "entryentity.material", ResManager.getLocaleString((String)"\u7269\u6599", (String)"InitDataConst_392", (String)"mmc-mrp-common"), "16", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271947L, 12, "entryentity.materialattr", ResManager.getLocaleString((String)"\u7269\u6599\u5c5e\u6027", (String)"InitDataConst_393", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271948L, 13, "entryentity.planstrategy", ResManager.getLocaleString((String)"\u5236\u9020\u7b56\u7565", (String)"InitDataConst_394", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271949L, 14, "entryentity.isolatedrule", ResManager.getLocaleString((String)"\u9694\u79bb\u89c4\u5219", (String)"InitDataConst_396", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271950L, 15, "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636eID", (String)"InitDataConst_450", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271951L, 16, "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u65e5\u671f", (String)"InitDataConst_441", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271952L, 17, "entryentity.billtype", ResManager.getLocaleString((String)"\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_442", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271953L, 18, "entryentity.biztype", ResManager.getLocaleString((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"InitDataConst_443", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271954L, 19, "entryentity.demandqty", ResManager.getLocaleString((String)"\u9700\u6c42\u6570\u91cf", (String)"InitDataConst_473", (String)"mmc-mrp-common"), "10", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271955L, 20, "entryentity.computingperiod", ResManager.getLocaleString((String)"\u8ba1\u7b97\u671f\u95f4", (String)"InitDataConst_446", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271956L, 21, "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u7f16\u7801", (String)"InitDataConst_447", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271957L, 22, "entryentity.billstatusfield", ResManager.getLocaleString((String)"\u5355\u636e\u72b6\u6001", (String)"InitDataConst_433", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271958L, 23, "entryentity.produnit", ResManager.getLocaleString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_414", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271959L, 24, "entryentity.baseunit", ResManager.getLocaleString((String)"\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_448", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271960L, 25, "entryentity.projectnumber", ResManager.getLocaleString((String)"\u9879\u76ee\u53f7", (String)"InitDataConst_434", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271961L, 26, "entryentity.tracknumber", ResManager.getLocaleString((String)"\u8ddf\u8e2a\u53f7", (String)"InitDataConst_449", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271962L, 27, "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_451", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271963L, 28, "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_452", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271964L, 29, "entryentity.istock", ResManager.getLocaleString((String)"\u662f\u5426\u5e93\u5b58\u6570\u636e", (String)"InitDataConst_453", (String)"mmc-mrp-common"), "11", "", "false", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271965L, 30, "entryentity.isdemand", ResManager.getLocaleString((String)"\u662f\u5426\u9884\u6d4b\u9700\u6c42", (String)"InitDataConst_474", (String)"mmc-mrp-common"), "11", "", "false", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271966L, 31, "entryentity.ecnversion", ResManager.getLocaleString((String)"ECN\u7248\u672c", (String)"InitDataConst_411", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271967L, 32, "entryentity.demandsourcetype", ResManager.getLocaleString((String)"\u9700\u6c42\u6765\u6e90\u7c7b\u578b", (String)"InitDataConst_475", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271968L, 33, "entryentity.materialname", ResManager.getLocaleString((String)"\u7269\u6599\u540d\u79f0", (String)"InitDataConst_476", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271969L, 34, "entryentity.materialnumber", ResManager.getLocaleString((String)"\u7269\u6599\u7f16\u7801", (String)"InitDataConst_477", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271970L, 35, "entryentity.productorgname", ResManager.getLocaleString((String)"\u751f\u4ea7\u7ec4\u7ec7\u540d\u79f0", (String)"InitDataConst_478", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271971L, 36, "entryentity.productorgnumber", ResManager.getLocaleString((String)"\u751f\u4ea7\u7ec4\u7ec7\u7f16\u7801", (String)"InitDataConst_479", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271972L, 37, "entryentity.mdsdemandtype", ResManager.getLocaleString((String)"\u9700\u6c42\u7c7b\u578b", (String)"InitDataConst_480", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271973L, 38, "entryentity.invaliddate", ResManager.getLocaleString((String)"\u5931\u6548\u65f6\u95f4", (String)"InitDataConst_481", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271974L, 39, "entryentity.safeinvdays", ResManager.getLocaleString((String)"\u5b89\u5168\u5e93\u5b58\u5c55\u671b\u671f", (String)"InitDataConst_482", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271975L, 40, "entryentity.safeinvtype", ResManager.getLocaleString((String)"\u5b89\u5168\u5e93\u5b58\u7c7b\u578b", (String)"InitDataConst_483", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448562494959271976L, 41, "entryentity.bomnumber", ResManager.getLocaleString((String)"BOM\u7f16\u7801", (String)"InitDataConst_404", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        resDataConfigParams = new ArrayList(16);
        resDataConfigParams.add(new ResDataConfigParam(1448562495370314752L, "2IXXO3KIP3RP", "SJYPZ-REQ-011", ResManager.getLocaleString((String)"\u51c0\u9700\u6c42\u8ba1\u5212", (String)"InitDataConst_484", (String)"mmc-mrp-common"), 1019614409087004672L, '0', "", "{\"filterRow\":[{\"id\":\"2QV6YQ68MJ4T\",\"leftBracket\":\"\",\"compareType\":\"21\",\"fieldName\":\"fcqty\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2QV6YQ68MIGJ\",\"value\":\"0\"}],\"baseDataIds\":[]},{\"id\":\"2QV6YQ68MJ4U\",\"leftBracket\":\"\",\"compareType\":\"9\",\"fieldName\":\"prodorg.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2QV6YQ68MIGK\",\"value\":\"\"}],\"baseDataIds\":[]},{\"id\":\"2QV6YQ68MJ4V\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"fcvrnnum.group.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2QV6YQ68MIGL\",\"value\":\"1\"}],\"baseDataIds\":[{\"id\":\"2QV6YQ68MJ4W\",\"value\":\"859139225407615000\"}]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448562495370314753L, "2IXXO3KIP3RQ", "SJYPZ-REQ-012", ResManager.getLocaleString((String)"\u5b89\u5168\u5e93\u5b58", (String)"InitDataConst_485", (String)"mmc-mrp-common"), 1019614408164257792L, '0', "", "{\"filterRow\":[{\"id\":\"1M54KGLUPKC8\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"status\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1M54KGLUP6JL\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"1M54KGLUPKC9\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"enable\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1M54KGLUP6JM\",\"value\":\"1\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448562495370314754L, "2IXXO3KIP3RR", "SJYPZ-REQ-013", ResManager.getLocaleString((String)"\u7ec4\u4ef6\u6e05\u5355", (String)"InitDataConst_486", (String)"mmc-mrp-common"), 1019614403357585408L, '0', "", "{\"filterRow\":[{\"id\":\"3KW2RK0ZNCQT\",\"leftBracket\":\"\",\"compareType\":\"21\",\"fieldName\":\"cansendqty\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW2RK0ZMMSS\",\"value\":\"0\"}],\"baseDataIds\":[]},{\"id\":\"3KW2RK0ZNCQU\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"orderentryid.bizstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW2RK0ZMMST\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KW2RK0ZNCQV\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"orderentryid.taskstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW2RK0ZMMSU\",\"value\":\"A\"},{\"id\":\"3KW2RK0ZNCQW\",\"value\":\"B\"},{\"id\":\"3KW2RK0ZMMSV\",\"value\":\"D\"}],\"baseDataIds\":[]},{\"id\":\"3KW2RK0ZNCQX\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW2RK0ZMMSW\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3KW2RK0ZNCQY\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"isjumplevel\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW2RK0ZMMSX\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448562495370314755L, "2IXXO3KIP3RS", "SJYPZ-REQ-014", ResManager.getLocaleString((String)"\u8d1f\u5e93\u5b58", (String)"InitDataConst_487", (String)"mmc-mrp-common"), 1005802947428222976L, '0', "", "{\"filterRow\":[{\"id\":\"1PLQB0E+PK7I\",\"leftBracket\":\"\",\"compareType\":\"36\",\"fieldName\":\"baseqty\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1PLQB0E+NU7M\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448562495370314756L, "2IXXO3KIP3RT", "SJYPZ-REQ-015", ResManager.getLocaleString((String)"\u9500\u552e\u8ba2\u5355\uff08\u51b2\u51cf\uff09", (String)"InitDataConst_488", (String)"mmc-mrp-common"), 1067478024938605568L, '0', "", "{\"filterRow\":[{\"id\":\"1M54PSKRF823\",\"leftBracket\":\"\",\"compareType\":\"83\",\"fieldName\":\"fnqty\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1M54PSKREV9G\",\"value\":\"0\"}],\"baseDataIds\":[]},{\"id\":\"1M54PSKRF824\",\"leftBracket\":\"\",\"compareType\":\"9\",\"fieldName\":\"orgsite.name\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1M54PSKREV9H\",\"value\":\"\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448562495370314757L, "2IXXO3KIP3RU", "SJYPZ-REQ-016", ResManager.getLocaleString((String)"\u9700\u6c42\u7533\u8bf7\u5355", (String)"InitDataConst_489", (String)"mmc-mrp-common"), 973715393191398400L, '0', "", "{\"filterRow\":[{\"id\":\"2DXLYMQTPCES\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2DXLYMQTTCM9\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2DXLYMQTPCET\",\"leftBracket\":\"\",\"compareType\":\"9\",\"fieldName\":\"reqdate\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2DXLYMQTTCM=\",\"value\":\"\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448562495370314758L, "2IXXO3KIP3RV", "SJYPZ-REQ-017", ResManager.getLocaleString((String)"\u8ba1\u5212\u8ba2\u5355\u5206\u5f55", (String)"InitDataConst_490", (String)"mmc-mrp-common"), 1181114675790629888L, '0', "", "{\"filterRow\":[{\"id\":\"3KW2T+KU0C6Z\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW2T+KU/M8Y\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3KW2T+KU0C7+\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"ordertype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW2T+KU/M8Z\",\"value\":\"10030\"},{\"id\":\"3KW2T+KU0C7/\",\"value\":\"10050\"}],\"baseDataIds\":[]},{\"id\":\"3KW2T+KU/M9+\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"entryisjumplevel\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW2T+KU0C70\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448562495370314759L, "2IXXO3KIP3RW", "SJYPZ-REQ-018", ResManager.getLocaleString((String)"\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355", (String)"InitDataConst_491", (String)"mmc-mrp-common"), 1247202796302814208L, '0', "", "{\"filterRow\":[{\"id\":\"3KW2TRFWTF62\",\"leftBracket\":\"\",\"compareType\":\"21\",\"fieldName\":\"cansendqty\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW2TRG+FLAM\",\"value\":\"0\"}],\"baseDataIds\":[]},{\"id\":\"3KW2TRG+EVCL\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"orderentryid.bizstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW2TRG+FLAN\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KW2TRG+EVCM\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"orderentryid.taskstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW2TRG+FLAO\",\"value\":\"A\"},{\"id\":\"3KW2TRG+EVCN\",\"value\":\"B\"},{\"id\":\"3KW2TRG+FLAP\",\"value\":\"D\"}],\"baseDataIds\":[]},{\"id\":\"3KW2TRG+EVCO\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW2TRG+FLAQ\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3KW2TRG+EVCP\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"isjumplevel\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW2TRG+FLAR\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448562495370314760L, "2IXXO3KIP3RX", "SJYPZ-REQ-019", ResManager.getLocaleString((String)"\u534f\u540c\u8ba1\u5212\u8ba2\u5355", (String)"InitDataConst_470", (String)"mmc-mrp-common"), 1313064178679872512L, '0', "", "{\"filterRow\":[{\"id\":\"239TWEXBC2H7\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"239TWEXBC35G\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1463630118755854336L, "2KS3+MMEB/LO", "SJYPZ-REQ-021", ResManager.getLocaleString((String)"\u6a21\u62df\u8ba1\u5212", (String)"InitDataConst_494", (String)"mmc-mrp-common"), 1463618556829632512L, '0', "", "{\"filterRow\":[{\"id\":\"2KT9R0F72C6X\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KT9R0F72CW5\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2KT9R0F72C6Y\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"closestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KT9R0F72CW6\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"2KT9R0F72C6Z\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"simulationstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KT9R0F72CW7\",\"value\":\"A\"},{\"id\":\"2KT9R0F72C7+\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"2KT9R0F72CW8\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"sourcetype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2KT9R0F72C7/\",\"value\":\"B\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1465290400490076160L, "2L+171ZS98I2", "SJYPZ-REQ-022", ResManager.getLocaleString((String)"\u9500\u552e\u8ba2\u5355", (String)"InitDataConst_495", (String)"mmc-mrp-common"), 1393295046425479168L, '0', "", "{\"filterRow\":[{\"id\":\"3ICVNUY0OY+C\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3ICVNUY0OYNM\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3ICVNUY0OY+D\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowclosestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3ICVNUY0OYNN\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3ICVNUY0OY+E\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowterminatestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3ICVNUY0OYNO\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3ICVNUY0OY+F\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"material.masterid.suite\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3ICVNUY0OYNP\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resRegisParam = new ResRegisParam(orgId, defaultctrlstrategy, 1448562494908941312L, "2IXXO3G+/T+U", "SP-requireresource", ResManager.getLocaleString((String)"\u9700\u6c42\u6a21\u578b-\u6a21\u62df\u8ba1\u5212", (String)"InitDataConst_496", (String)"mmc-mrp-common"), "02", "01", "mrp_demandbill_model_inh", 962843094548526080L, 962938205651391488L, 1448552481838612480L, "mrp_simulateorder", 0L, entryParams, resDataConfigParams, appId);
        resSql.put("SP-requireresource", InitDataConst.getResRegisParam(resRegisParam));
        entryParams = new ArrayList(16);
        entryParams.add(new ResRegisEntryParam(1448564628232617984L, 1, "number", ResManager.getLocaleString((String)"\u7f16\u7801", (String)"InitDataConst_146", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617985L, 2, "name", ResManager.getLocaleString((String)"\u540d\u79f0", (String)"InitDataConst_321", (String)"mmc-mrp-common"), "4", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617986L, 3, "status", ResManager.getLocaleString((String)"\u6570\u636e\u72b6\u6001", (String)"InitDataConst_379", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617987L, 4, "creator", ResManager.getLocaleString((String)"\u521b\u5efa\u4eba", (String)"InitDataConst_381", (String)"mmc-mrp-common"), "12", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617988L, 5, "modifier", ResManager.getLocaleString((String)"\u4fee\u6539\u4eba", (String)"InitDataConst_383", (String)"mmc-mrp-common"), "13", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617989L, 6, "enable", ResManager.getLocaleString((String)"\u4f7f\u7528\u72b6\u6001", (String)"InitDataConst_384", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617990L, 7, "createtime", ResManager.getLocaleString((String)"\u521b\u5efa\u65f6\u95f4", (String)"InitDataConst_385", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617991L, 8, "modifytime", ResManager.getLocaleString((String)"\u4fee\u6539\u65f6\u95f4", (String)"InitDataConst_387", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617992L, 9, "entryentity.supplyorgunit", ResManager.getLocaleString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_391", (String)"mmc-mrp-common"), "14", "B", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617993L, 10, "entryentity.material", ResManager.getLocaleString((String)"\u7269\u6599", (String)"InitDataConst_392", (String)"mmc-mrp-common"), "16", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617994L, 11, "entryentity.materialattr", ResManager.getLocaleString((String)"\u7269\u6599\u5c5e\u6027", (String)"InitDataConst_393", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617995L, 12, "entryentity.planstrategy", ResManager.getLocaleString((String)"\u5236\u9020\u7b56\u7565", (String)"InitDataConst_394", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617996L, 13, "entryentity.isolatedrule", ResManager.getLocaleString((String)"\u9694\u79bb\u89c4\u5219", (String)"InitDataConst_396", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617997L, 14, "entryentity.billdate", ResManager.getLocaleString((String)"\u5355\u636e\u65e5\u671f", (String)"InitDataConst_441", (String)"mmc-mrp-common"), "1", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617998L, 15, "entryentity.billtype", ResManager.getLocaleString((String)"\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_442", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232617999L, 16, "entryentity.biztype", ResManager.getLocaleString((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"InitDataConst_443", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618000L, 17, "entryentity.usablestoqty", ResManager.getLocaleString((String)"\u53ef\u7528\u5e93\u5b58\u91cf", (String)"InitDataConst_444", (String)"mmc-mrp-common"), "10", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618001L, 18, "entryentity.qty", ResManager.getLocaleString((String)"\u9884\u8ba1\u5165\u5e93\u91cf", (String)"InitDataConst_445", (String)"mmc-mrp-common"), "10", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618002L, 19, "entryentity.computingperiod", ResManager.getLocaleString((String)"\u8ba1\u7b97\u671f\u95f4", (String)"InitDataConst_446", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618003L, 20, "entryentity.billnumber", ResManager.getLocaleString((String)"\u5355\u636e\u7f16\u7801", (String)"InitDataConst_447", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618004L, 21, "entryentity.billstatusfield", ResManager.getLocaleString((String)"\u5355\u636e\u72b6\u6001", (String)"InitDataConst_433", (String)"mmc-mrp-common"), "23", "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618005L, 22, "entryentity.produnit", ResManager.getLocaleString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_414", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618006L, 23, "entryentity.baseunit", ResManager.getLocaleString((String)"\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_448", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618007L, 24, "entryentity.projectnumber", ResManager.getLocaleString((String)"\u9879\u76ee\u53f7", (String)"InitDataConst_434", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618008L, 25, "entryentity.tracknumber", ResManager.getLocaleString((String)"\u8ddf\u8e2a\u53f7", (String)"InitDataConst_449", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618009L, 26, "entryentity.billid", ResManager.getLocaleString((String)"\u5355\u636eID", (String)"InitDataConst_450", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618010L, 27, "entryentity.billentryid", ResManager.getLocaleString((String)"\u5355\u636e\u5206\u5f55ID", (String)"InitDataConst_451", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618011L, 28, "entryentity.billentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u5206\u5f55\u884c\u53f7", (String)"InitDataConst_452", (String)"mmc-mrp-common"), "7", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618012L, 29, "entryentity.istock", ResManager.getLocaleString((String)"\u662f\u5426\u5e93\u5b58\u6570\u636e", (String)"InitDataConst_453", (String)"mmc-mrp-common"), "11", "", "false", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618013L, 30, "entryentity.yield", ResManager.getLocaleString((String)"\u6210\u54c1\u7387\uff08%\uff09", (String)"InitDataConst_454", (String)"mmc-mrp-common"), "10", "", "0", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618014L, 31, "entryentity.stock", ResManager.getLocaleString((String)"\u4ed3\u5e93", (String)"InitDataConst_455", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618015L, 32, "entryentity.stockindex", ResManager.getLocaleString((String)"\u4ed3\u4f4d", (String)"InitDataConst_456", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618016L, 33, "entryentity.stocktype", ResManager.getLocaleString((String)"\u5e93\u5b58\u7c7b\u578b", (String)"InitDataConst_457", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618017L, 34, "entryentity.stockstatus", ResManager.getLocaleString((String)"\u5e93\u5b58\u72b6\u6001", (String)"InitDataConst_458", (String)"mmc-mrp-common"), "18", "A", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618018L, 35, "entryentity.supplyorgname", ResManager.getLocaleString((String)"\u5e93\u5b58\u7ec4\u7ec7\u540d\u79f0", (String)"InitDataConst_459", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618019L, 36, "entryentity.warehousename", ResManager.getLocaleString((String)"\u4ed3\u5e93\u540d\u79f0", (String)"InitDataConst_460", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618020L, 37, "entryentity.locationname", ResManager.getLocaleString((String)"\u4ed3\u4f4d\u540d\u79f0", (String)"InitDataConst_461", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1448564628232618021L, 38, "entryentity.warehousenumber", ResManager.getLocaleString((String)"\u4ed3\u5e93\u7f16\u7801", (String)"InitDataConst_462", (String)"mmc-mrp-common"), "2", "C", "", "", ""));
        resDataConfigParams = new ArrayList(16);
        resDataConfigParams.add(new ResDataConfigParam(1448564628903706624L, "2IXY1NXJFT/6", "SJYPZ-SUP-009", ResManager.getLocaleString((String)"\u5373\u65f6\u5e93\u5b58", (String)"InitDataConst_463", (String)"mmc-mrp-common"), 996334374087561216L, '0', "", "{\"filterRow\":[{\"id\":\"1M55IJD+HBON\",\"leftBracket\":\"\",\"compareType\":\"21\",\"fieldName\":\"baseqty\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1M55IJD+HQH=\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448564628903706625L, "2IXY1NXJFT/7", "SJYPZ-SUP-010", ResManager.getLocaleString((String)"\u751f\u4ea7\u5de5\u5355", (String)"InitDataConst_464", (String)"mmc-mrp-common"), 1019614409246389248L, '0', "", "{\"filterRow\":[{\"id\":\"2FT6+AH2CTVJ\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"taskstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT6+AH2AZU3\",\"value\":\"A\"},{\"id\":\"2FT6+AH2CTVK\",\"value\":\"B\"},{\"id\":\"2FT6+AH2AZU4\",\"value\":\"D\"}],\"baseDataIds\":[]},{\"id\":\"2FT6+AH2CTVL\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"bizstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT6+AH2AZU5\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2FT6+AH2CTVM\",\"leftBracket\":\"(((\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"1\",\"value\":[{\"id\":\"2FT6+AH2AZU6\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2FT6+AH2CTVN\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT6+AH2AZU7\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"2FT6+AH2CTVO\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"sourcebilltype\",\"rightBracket\":\")\",\"logic\":\"1\",\"value\":[{\"id\":\"2FT6+AH2AZU8\",\"value\":\"mrp_planorder\"}],\"baseDataIds\":[]},{\"id\":\"2FT6+AH2CTVP\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT6+AH2AZU9\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2FT6+AH2CTVQ\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"transactiontype.transactiontype.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT6+AH2AZU=\",\"value\":\"401\"}],\"baseDataIds\":[{\"id\":\"2FT6+AH2CTVR\",\"value\":\"738166303168232448\"}]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448564628903706626L, "2IXY1NXJFT/8", "SJYPZ-SUP-011", ResManager.getLocaleString((String)"\u91c7\u8d2d\u7533\u8bf7\u5355", (String)"InitDataConst_465", (String)"mmc-mrp-common"), 1019614408390751232L, '0', "", "{\"filterRow\":[{\"id\":\"3KW33PLSQH=G\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowclosestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW33PLSPRBF\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KW33PLSQH=H\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowterminatestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW33PLSPRBG\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KW33PLSQH=I\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"closestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW33PLSPRBH\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KW33PLSQH=J\",\"leftBracket\":\"(((\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"1\",\"value\":[{\"id\":\"3KW33PLSPRBI\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KW33PLSQH=K\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW33PLSPRBJ\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"3KW33PLSQH=L\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"srcbillentity\",\"rightBracket\":\")\",\"logic\":\"1\",\"value\":[{\"id\":\"3KW33PLSPRBK\",\"value\":\"mrp_planorder\"}],\"baseDataIds\":[]},{\"id\":\"3KW33PLSQH=M\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW33PLSPRBL\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3KW33PLSQH=N\",\"leftBracket\":\"\",\"compareType\":\"9\",\"fieldName\":\"reqdate\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW33PLSPRBM\",\"value\":\"\"}],\"baseDataIds\":[]},{\"id\":\"3KW33PLSQH=O\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"billtype.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW33PLSPRBN\",\"value\":\"pm_purapplybill_EMS_BT_S\"},{\"id\":\"3KW33PLSQH=P\",\"value\":\"pm_PurApplyBill_STD_BT_S\"}],\"baseDataIds\":[{\"id\":\"3KW33PLSPRBO\",\"value\":\"539008374826629120\"},{\"id\":\"3KW33PLSQH=Q\",\"value\":\"1002796011481277440\"}]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448564628903706627L, "2IXY1NXJFT/9", "SJYPZ-SUP-012", ResManager.getLocaleString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"InitDataConst_466", (String)"mmc-mrp-common"), 1019614409137337344L, '0', "", "{\"filterRow\":[{\"id\":\"3KW34WO1MB24\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowclosestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW34WO59H7O\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KW34WO58R9N\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowterminatestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW34WO59H7P\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KW34WO58R9O\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"closestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW34WO59H7Q\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KW34WO58R9P\",\"leftBracket\":\"(((\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"1\",\"value\":[{\"id\":\"3KW34WO59H7R\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3KW34WO58R9Q\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW34WO59H7S\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"3KW34WO58R9R\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"srcbillentity\",\"rightBracket\":\")\",\"logic\":\"1\",\"value\":[{\"id\":\"3KW34WO59H7T\",\"value\":\"mrp_planorder\"}],\"baseDataIds\":[]},{\"id\":\"3KW34WO58R9S\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW34WO59H7U\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3KW34WO58R9T\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"billtype.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KW34WO59H7V\",\"value\":\"pm_PurOrderBill_EMS_BT_S\"},{\"id\":\"3KW34WO58R9U\",\"value\":\"pm_PurOrderBill_STD_BT_S\"}],\"baseDataIds\":[{\"id\":\"3KW34WO59H7W\",\"value\":\"539008795674673152\"},{\"id\":\"3KW34WO58R9V\",\"value\":\"1005695800258488320\"}]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448564628903706628L, "2IXY1NXJFT/=", "SJYPZ-SUP-013", ResManager.getLocaleString((String)"\u8ba1\u5212\u8ba2\u5355", (String)"InitDataConst_467", (String)"mmc-mrp-common"), 976007551319598080L, '0', "", "{\"filterRow\":[{\"id\":\"1M55EABADIVX\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1M55EABADXOJ\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448564628903706629L, "2IXY1NXJFT/A", "SJYPZ-SUP-014", ResManager.getLocaleString((String)"\u59d4\u5916\u5de5\u5355", (String)"InitDataConst_468", (String)"mmc-mrp-common"), 1245512022473325568L, '0', "", "{\"filterRow\":[{\"id\":\"2FT61+6SJ82B\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"taskstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT61+6SL23S\",\"value\":\"A\"},{\"id\":\"2FT61+6SJ82C\",\"value\":\"B\"},{\"id\":\"2FT61+6SL23T\",\"value\":\"D\"}],\"baseDataIds\":[]},{\"id\":\"2FT61+6SJ82D\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"bizstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT61+6SL23U\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2FT61+6SJ82E\",\"leftBracket\":\"(((\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"1\",\"value\":[{\"id\":\"2FT61+6SL23V\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2FT61+6SJ82F\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT61+6SL23W\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"2FT61+6SJ82G\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"sourcebilltype\",\"rightBracket\":\")\",\"logic\":\"1\",\"value\":[{\"id\":\"2FT61+6SL23X\",\"value\":\"mrp_planorder\"}],\"baseDataIds\":[]},{\"id\":\"2FT61+6SJ82H\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\")\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT61+6SL23Y\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2FT61+6SJ82I\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"transactiontype.transactiontype.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2FT61+6SL23Z\",\"value\":\"601\"}],\"baseDataIds\":[{\"id\":\"2FT61+6SJ82J\",\"value\":\"1213802446967548928\"}]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448564628903706630L, "2IXY1NXJFT/B", "SJYPZ-SUP-015", ResManager.getLocaleString((String)"\u8ba1\u5212\u8ba2\u5355\uff08\u8054\u526f\u4ea7\u54c1\uff09", (String)"InitDataConst_469", (String)"mmc-mrp-common"), 1281137811671530496L, '0', "", "{\"filterRow\":[{\"id\":\"2/BV+KBBRMOT\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2/BV+KBBRM/J\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2/BV+KBBRMOU\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"copentrytype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2/BV+KBBRM/K\",\"value\":\"10720\"},{\"id\":\"2/BV+KBBRMOV\",\"value\":\"10730\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1448564628903706631L, "2IXY1NXJFT/C", "SJYPZ-SUP-016", ResManager.getLocaleString((String)"\u534f\u540c\u8ba1\u5212\u8ba2\u5355", (String)"InitDataConst_470", (String)"mmc-mrp-common"), 1313081634475521024L, '0', "", "{\"filterRow\":[{\"id\":\"239UXN1JP5O6\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"239UXN1JP5+Y\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resDataConfigParams.add(new ResDataConfigParam(1490446457289851904L, "2O1KHUFEIIQB", "SJYPZ-SUP-021", ResManager.getLocaleString((String)"\u59d4\u5916\u8ba2\u5355", (String)"InitDataConst_471", (String)"mmc-mrp-common"), 1465244867050406912L, '0', "", "{\"filterRow\":[{\"id\":\"2O1KGFU7UYZ+\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowclosestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2O1KGFU7UZM8\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2O1KGFU7UYZ/\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowterminatestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2O1KGFU7UZM9\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2O1KGFUAGC4H\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowclosestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2O1KGFUAGCTR\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2O1KGFUAGC4I\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2O1KGFUAGCTS\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2O1KGFUAGC4J\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2O1KGFUAGCTT\",\"value\":\"A\"},{\"id\":\"2O1KGFUAGC4K\",\"value\":\"B\"}],\"baseDataIds\":[]},{\"id\":\"2O1KGFUAGCTU\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"srcbillentity\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2O1KGFUAGC4L\",\"value\":\"mrp_planorder\"}],\"baseDataIds\":[]},{\"id\":\"2O1KGFUAGCTV\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"billtype.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2O1KGFUAGC4M\",\"value\":\"pm_om_purorderbill_BT_S\"}],\"baseDataIds\":[]}],\"forList\":false}", "mrp"));
        resRegisParam = new ResRegisParam(orgId, defaultctrlstrategy, 1448564628190675968L, "2IXY1NQ3CKL5", "SP-supplyresource", ResManager.getLocaleString((String)"\u4f9b\u5e94\u6a21\u578b-\u6a21\u62df\u8ba1\u5212", (String)"InitDataConst_497", (String)"mmc-mrp-common"), "01", "01", "mrp_supply_model_inh", 0L, 0L, 0L, "", 1448556155503656960L, entryParams, resDataConfigParams, appId);
        resSql.put("SP-supplyresource", InitDataConst.getResRegisParam(resRegisParam));
        return resSql;
    }

    private static Map<String, List<Object[]>> getGrossParam(GrossParam grossParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object[]>> map = new LinkedHashMap<String, List<Object[]>>(InitSQLConst.grossSql.length);
        for (int i = 0; i < InitSQLConst.grossSql.length; ++i) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(1);
            switch (i) {
                case 0: 
                case 1: 
                case 5: {
                    Object[] p = new Object[]{grossParam.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{grossParam.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{grossParam.id, grossParam.codetype, grossParam.orgId, grossParam.id, grossParam.orgId, "C", grossParam.defaultctrlstrategy, grossParam.number, nowTime, userId, "1", nowTime, userId, "V1.0"};
                    params.add(p);
                    break;
                }
                case 4: {
                    Object[] p = new Object[]{grossParam.id, grossParam.pkId, ResManager.getLanguage(), grossParam.name, grossParam.safetystock, grossParam.supplysluggishtype};
                    params.add(p);
                    break;
                }
            }
            map.put(InitSQLConst.grossSql[i], params);
        }
        return map;
    }

    protected Map<String, Map<String, List<Object[]>>> getGrossSql2Param(Long orgId, String defaultctrlstrategy) {
        HashMap<String, Map<String, List<Object[]>>> grossSql = new HashMap<String, Map<String, List<Object[]>>>(16);
        grossSql.put("MXQDY-Orignal", InitDataConst.getGrossParam(new GrossParam(orgId, defaultctrlstrategy, 1215218702123830272L, "1T9+CWIQ4XZN", "MXQDY-Orignal", ResManager.loadKDString((String)"\u6bdb\u9700\u6c42\u5b9a\u4e49-\u539f\u59cb", (String)"InitDataConst_498", (String)"mmc-mrp-common", (Object[])new Object[0]), 0L, ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\uff08\u63d0\u524d\uff09", (String)"InitDataConst_499", (String)"mmc-mrp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InitDataConst_500", (String)"mmc-mrp-common", (Object[])new Object[0]))));
        return grossSql;
    }

    protected Map<String, Map<String, List<Object[]>>> getProgramSql2Param(Long orgId, String defaultctrlstrategy, String appId) {
        ArrayList<PlanProreEntryParam> planProreEntryParams = new ArrayList<PlanProreEntryParam>(8);
        planProreEntryParams.add(new PlanProreEntryParam(1992172261557237770L, 1, " ", "B", "im_inv_realbalance"));
        planProreEntryParams.add(new PlanProreEntryParam(1992172261557237771L, 2, "0,1,2", "B", "pom_mftorder"));
        planProreEntryParams.add(new PlanProreEntryParam(1992172261557237772L, 3, "0,1,2", "B", "pm_purapplybill"));
        planProreEntryParams.add(new PlanProreEntryParam(1992172261557237773L, 4, "0,1,2", "B", "pm_purapplybill"));
        planProreEntryParams.add(new PlanProreEntryParam(1992172261557237774L, 5, "0,1,2", "B", "mrp_planorder"));
        planProreEntryParams.add(new PlanProreEntryParam(1992172261557237775L, 6, "0,1,2", "B", "om_mftorder"));
        planProreEntryParams.add(new PlanProreEntryParam(1992172261557237776L, 7, "0,1,2", "B", "mrp_collaborativeorder"));
        planProreEntryParams.add(new PlanProreEntryParam(1992172261557237777L, 8, "0,1,2", "B", "pm_om_purorderbill"));
        ArrayList<PlanProorgEntryParam> planProorgEntryParams = new ArrayList<PlanProorgEntryParam>(1);
        planProorgEntryParams.add(new PlanProorgEntryParam(1992172261557236747L, 1, 1992165739917833216L, 1992168065021867008L, 0L, orgId));
        ArrayList<PlanProscEntryParam> planProscEntryParams = new ArrayList<PlanProscEntryParam>(9);
        planProscEntryParams.add(new PlanProscEntryParam(1992172261557236738L, 1, 99, "im_inv_realbalance", 1018922143968185344L, true));
        planProscEntryParams.add(new PlanProscEntryParam(1992172261557236739L, 2, 90, "pom_mftorder", 967449431219693568L, true));
        planProscEntryParams.add(new PlanProscEntryParam(1992172261557236740L, 3, 80, "pm_purapplybill", 962968236230461440L, true));
        planProscEntryParams.add(new PlanProscEntryParam(1992172261557236741L, 4, 95, "pm_purorderbill", 1079657214567803904L, true));
        planProscEntryParams.add(new PlanProscEntryParam(1992172261557236742L, 5, 80, "mrp_planorder", 980345552879270912L, true));
        planProscEntryParams.add(new PlanProscEntryParam(1992172261557236743L, 6, 90, "om_mftorder", 1245592901841372160L, true));
        planProscEntryParams.add(new PlanProscEntryParam(1992172261557236744L, 7, 80, "mrp_planorder", 1281148003368876032L, true));
        planProscEntryParams.add(new PlanProscEntryParam(1992172261557236745L, 8, 80, "mrp_collaborativeorder", 1313083040506884096L, true));
        planProscEntryParams.add(new PlanProscEntryParam(1992172261557236746L, 9, 95, "pm_om_purorderbill", 1465252855689577472L, true));
        ArrayList<PlanProEntryParam> planProEntryParams = new ArrayList<PlanProEntryParam>(10);
        planProEntryParams.add(new PlanProEntryParam(1992172261557237760L, 1, "mds_data", 1018652116748652544L, true));
        planProEntryParams.add(new PlanProEntryParam(1992172261557237761L, 2, "mds_safetystock", 1078219665676709888L, true));
        planProEntryParams.add(new PlanProEntryParam(1992172261557237762L, 3, "pom_mftstock", 1078980451135151104L, true));
        planProEntryParams.add(new PlanProEntryParam(1992172261557237763L, 4, "im_inv_realbalance", 1078219830345084928L, true));
        planProEntryParams.add(new PlanProEntryParam(1992172261557237764L, 5, "mds_dpsfnresult", 1078219453075828736L, false));
        planProEntryParams.add(new PlanProEntryParam(1992172261557237765L, 6, "pm_requirapplybill", 962947433724170240L, true));
        planProEntryParams.add(new PlanProEntryParam(1992172261557237766L, 7, "mrp_planorder", 1181116955797516288L, true));
        planProEntryParams.add(new PlanProEntryParam(1992172261557237767L, 8, "om_mftstock", 1247207017123204096L, true));
        planProEntryParams.add(new PlanProEntryParam(1992172261557237768L, 9, "mrp_collaborativeorder", 1313068163914595328L, true));
        planProEntryParams.add(new PlanProEntryParam(1992172261557237769L, 10, "sm_salorder", 1779825890142727168L, false));
        PlanProgramParam planProgramParam = new PlanProgramParam(orgId, defaultctrlstrategy, 1992172261439797248L, "48P=U6GMOS+1", "900", ResManager.loadKDString((String)"MRP/MPS\u6807\u51c6\u8ba1\u5212\u65b9\u6848", (String)"InitDataConst_633", (String)"mmc-mrp-common", (Object[])new Object[0]), "A", 962960690602102784L, true, true, "A", 1992172261439797248L, orgId, true, true, true, true, true, true, true, true, 180, 1000, "C", true, '1', 962938347762799616L, 1078041234464837632L, "A", '1', "A", true, "0", "0", planProreEntryParams, planProorgEntryParams, planProscEntryParams, planProEntryParams);
        HashMap<String, Map<String, List<Object[]>>> planProgramSql = new HashMap<String, Map<String, List<Object[]>>>(16);
        planProgramSql.put("900", InitDataConst.getProgramParam(planProgramParam));
        return planProgramSql;
    }

    protected static Map<String, List<Object[]>> getProgramParam(PlanProgramParam planProgramParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object[]>> map = new LinkedHashMap<String, List<Object[]>>(InitSQLConst.programSql.length);
        for (int i = 0; i < InitSQLConst.programSql.length; ++i) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(1);
            switch (i) {
                case 0: 
                case 1: 
                case 5: 
                case 8: 
                case 11: 
                case 14: {
                    Object[] p = new Object[]{planProgramParam.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{planProgramParam.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{planProgramParam.createorg, planProgramParam.defaultctrlstrategy, planProgramParam.id, planProgramParam.number, planProgramParam.type, planProgramParam.supplymodel, planProgramParam.isreplace, planProgramParam.isbatchpolicy, planProgramParam.appmode, planProgramParam.masterid, planProgramParam.org, planProgramParam.considerbatchstr, planProgramParam.islossrate, planProgramParam.isyield, planProgramParam.isadjust, planProgramParam.ismps, planProgramParam.hiloinv, planProgramParam.ismrp, planProgramParam.planoutlook, planProgramParam.isreorderpoint, planProgramParam.dropbatchcount, planProgramParam.safestockeffectset, Character.valueOf(planProgramParam.outofdate), planProgramParam.demandmodel, planProgramParam.relativetransfer, planProgramParam.computemode, Character.valueOf(planProgramParam.scoutofdate), planProgramParam.adjusteffectset, planProgramParam.issafestock, userId, nowTime, "1", "C", userId, nowTime, planProgramParam.isreserve, planProgramParam.releasemode, planProgramParam.ocpweakreserve};
                    params.add(p);
                    break;
                }
                case 4: {
                    Object[] p = new Object[]{planProgramParam.id, planProgramParam.pkId, ResManager.getLanguage(), planProgramParam.name};
                    params.add(p);
                    break;
                }
                case 6: {
                    Object[] p;
                    for (PlanProreEntryParam planproreentryParam : planProgramParam.planProreEntryParams) {
                        p = new Object[]{planproreentryParam.entryId};
                        params.add(p);
                    }
                    break;
                }
                case 7: {
                    Object[] p;
                    for (PlanProreEntryParam planproreentryParam : planProgramParam.planProreEntryParams) {
                        p = new Object[]{planProgramParam.id, planproreentryParam.resulttype, planproreentryParam.entryId, planproreentryParam.adjuststrategy, planproreentryParam.seq, planproreentryParam.entryentitytype};
                        params.add(p);
                    }
                    break;
                }
                case 9: {
                    Object[] p;
                    for (PlanProorgEntryParam planProorgEntryParam : planProgramParam.planProorgEntryParams) {
                        p = new Object[]{planProorgEntryParam.entryId};
                        params.add(p);
                    }
                    break;
                }
                case 10: {
                    Object[] p;
                    for (PlanProorgEntryParam planProorgEntryParam : planProgramParam.planProorgEntryParams) {
                        p = new Object[]{planProgramParam.id, planProorgEntryParam.entryinvstrategy, planProorgEntryParam.entryplanscope, planProorgEntryParam.entryId, planProorgEntryParam.seq, planProorgEntryParam.entrydemandorg, planProorgEntryParam.entrysupplynet};
                        params.add(p);
                    }
                    break;
                }
                case 12: {
                    Object[] p;
                    for (PlanProscEntryParam planProscEntryParam : planProgramParam.planProscEntryParams) {
                        p = new Object[]{planProscEntryParam.entryId};
                        params.add(p);
                    }
                    break;
                }
                case 13: {
                    Object[] p;
                    for (PlanProscEntryParam planProscEntryParam : planProgramParam.planProscEntryParams) {
                        p = new Object[]{planProgramParam.id, planProscEntryParam.supplypriority, planProscEntryParam.entryisscmrpoperat, planProscEntryParam.entryId, planProscEntryParam.seq, planProscEntryParam.entrysupplyres, planProscEntryParam.resourceregisters};
                        params.add(p);
                    }
                    break;
                }
                case 15: {
                    Object[] p;
                    for (PlanProEntryParam planProEntryParam : planProgramParam.planProEntryParams) {
                        p = new Object[]{planProEntryParam.entryId};
                        params.add(p);
                    }
                    break;
                }
                case 16: {
                    Object[] p;
                    for (PlanProEntryParam planProEntryParam : planProgramParam.planProEntryParams) {
                        p = new Object[]{planProgramParam.id, planProEntryParam.entryismrpoperat, planProEntryParam.entryId, planProEntryParam.resourceregister, planProEntryParam.seq, planProEntryParam.entrydemandsrc};
                        params.add(p);
                    }
                    break;
                }
            }
            map.put(InitSQLConst.programSql[i], params);
        }
        return map;
    }

    protected Map<String, Map<String, List<Object[]>>> getStocksupplySql2Param(Long orgId, String defaultctrlstrategy) {
        ArrayList<StockTypeEntryParam> stockTypeEntryParams = new ArrayList<StockTypeEntryParam>(8);
        stockTypeEntryParams.add(new StockTypeEntryParam(688884005529250816L, true, 1992165751888377858L, 1));
        stockTypeEntryParams.add(new StockTypeEntryParam(688884099724930048L, true, 1992165751888377859L, 2));
        stockTypeEntryParams.add(new StockTypeEntryParam(688884217048001536L, true, 1992165751888377860L, 3));
        stockTypeEntryParams.add(new StockTypeEntryParam(688884312753630208L, true, 1992165751888377861L, 4));
        stockTypeEntryParams.add(new StockTypeEntryParam(688884427652393984L, true, 1992165751888377862L, 5));
        stockTypeEntryParams.add(new StockTypeEntryParam(688884505809054720L, false, 1992165751888377863L, 6));
        stockTypeEntryParams.add(new StockTypeEntryParam(688884593092520960L, false, 1992165751888377864L, 7));
        stockTypeEntryParams.add(new StockTypeEntryParam(1798584511282282496L, false, 1992165751888377865L, 8));
        ArrayList<StockStatusEntryParam> stockStatusEntryParams = new ArrayList<StockStatusEntryParam>(8);
        stockStatusEntryParams.add(new StockStatusEntryParam(691928582720825344L, true, 1992165751888376833L, 1));
        stockStatusEntryParams.add(new StockStatusEntryParam(691930349319792640L, true, 1992165751888376834L, 2));
        stockStatusEntryParams.add(new StockStatusEntryParam(691930486079203328L, false, 1992165751888376835L, 3));
        stockStatusEntryParams.add(new StockStatusEntryParam(691928796160567296L, false, 1992165751888376836L, 4));
        stockStatusEntryParams.add(new StockStatusEntryParam(1083822835358873600L, true, 1992165751888376837L, 5));
        stockStatusEntryParams.add(new StockStatusEntryParam(1536101894978546688L, false, 1992165751888376838L, 6));
        StocksupplyParam stocksupplyParam = new StocksupplyParam(orgId, defaultctrlstrategy, 1992165739917833216L, "48P9LRGPRF9Y", "MRP-001", ResManager.loadKDString((String)"MRP\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9884\u7f6e", (String)"InitDataConst_634", (String)"mmc-mrp-common", (Object[])new Object[0]), 99, 1992165751888376832L, 1, orgId, BigDecimal.ONE, '1', stockStatusEntryParams, stockTypeEntryParams);
        HashMap<String, Map<String, List<Object[]>>> stocksupplyParamSql = new HashMap<String, Map<String, List<Object[]>>>(16);
        stocksupplyParamSql.put("MRP-001", this.getStocksupplyParam(stocksupplyParam));
        return stocksupplyParamSql;
    }

    private Map<String, List<Object[]>> getStocksupplyParam(StocksupplyParam stocksupplyParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object[]>> map = new LinkedHashMap<String, List<Object[]>>(InitSQLConst.stockSupplySql.length);
        for (int i = 0; i < InitSQLConst.stockSupplySql.length; ++i) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(1);
            switch (i) {
                case 0: 
                case 1: 
                case 5: 
                case 8: 
                case 11: {
                    Object[] p = new Object[]{stocksupplyParam.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{stocksupplyParam.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{stocksupplyParam.id, stocksupplyParam.orgId, stocksupplyParam.id, stocksupplyParam.orgId, "C", stocksupplyParam.defaultctrlstrategy, stocksupplyParam.number, nowTime, Character.valueOf('1'), userId, "1", nowTime, userId};
                    params.add(p);
                    break;
                }
                case 4: {
                    Object[] p = new Object[]{stocksupplyParam.id, stocksupplyParam.pkId, ResManager.getLanguage(), stocksupplyParam.name};
                    params.add(p);
                    break;
                }
                case 6: {
                    Object[] p;
                    for (StockTypeEntryParam stockTypeEntryParams : stocksupplyParam.stockTypeEntryParams) {
                        p = new Object[]{stockTypeEntryParams.entryid};
                        params.add(p);
                    }
                    break;
                }
                case 7: {
                    Object[] p;
                    for (StockTypeEntryParam stockTypeEntryParams : stocksupplyParam.stockTypeEntryParams) {
                        p = new Object[]{stockTypeEntryParams.stocktypeId, stocksupplyParam.id, stockTypeEntryParams.ismrp, stockTypeEntryParams.entryid, stockTypeEntryParams.seq};
                        params.add(p);
                    }
                    break;
                }
                case 9: {
                    Object[] p;
                    for (StockStatusEntryParam stockStatusEntryParam : stocksupplyParam.stockStatusEntryParams) {
                        p = new Object[]{stockStatusEntryParam.entryid};
                        params.add(p);
                    }
                    break;
                }
                case 10: {
                    Object[] p;
                    for (StockStatusEntryParam stockStatusEntryParam : stocksupplyParam.stockStatusEntryParams) {
                        p = new Object[]{stockStatusEntryParam.stocktypeId, stocksupplyParam.id, stockStatusEntryParam.ismrp, stockStatusEntryParam.entryid, stockStatusEntryParam.seq};
                        params.add(p);
                    }
                    break;
                }
                case 12: {
                    Object[] p = new Object[]{stocksupplyParam.entryid};
                    params.add(p);
                    break;
                }
                case 13: {
                    Object[] p = new Object[]{stocksupplyParam.id, stocksupplyParam.integerfield, stocksupplyParam.entryid, stocksupplyParam.seq, stocksupplyParam.storageorgid, stocksupplyParam.decimalfield};
                    params.add(p);
                    break;
                }
            }
            map.put(InitSQLConst.stockSupplySql[i], params);
        }
        return map;
    }

    protected Map<String, Map<String, List<Object[]>>> getDefSupplySql2Param(Long orgId, String defaultctrlstrategy) {
        OrgTpyParam orgTpyParam = new OrgTpyParam(1992167305743791104L, "48P9X257FS06", "MRP-001", ResManager.loadKDString((String)"MRP\u4f9b\u5e94\u7ec4\u7ec7\u5206\u7c7b", (String)"InitDataConst_635", (String)"mmc-mrp-common", (Object[])new Object[0]));
        DefSupplyParam defSupplyParam = new DefSupplyParam(1992168065021867008L, "48P=0LW1URQR", "70", ResManager.loadKDString((String)"\u8de8\u5e93\u5b58\u7ec4\u7ec7\u9886\u6599", (String)"InitDataConst_636", (String)"mmc-mrp-common", (Object[])new Object[0]), 1992167305743791104L, orgId, BigDecimal.ONE, true, 1992168065088975872L, 1, "A", defaultctrlstrategy, orgTpyParam);
        HashMap<String, Map<String, List<Object[]>>> stocksupplyParamSql = new HashMap<String, Map<String, List<Object[]>>>(16);
        stocksupplyParamSql.put("70", this.getDefSupplySaram(defSupplyParam));
        return stocksupplyParamSql;
    }

    private Map<String, List<Object[]>> getDefSupplySaram(DefSupplyParam defSupplyParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object[]>> map = new LinkedHashMap<String, List<Object[]>>(InitSQLConst.defSupplySql.length);
        for (int i = 0; i < InitSQLConst.defSupplySql.length; ++i) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(1);
            switch (i) {
                case 0: 
                case 1: {
                    Object[] p = new Object[]{defSupplyParam.orgTpy.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{defSupplyParam.orgTpy.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{defSupplyParam.orgTpy.id, nowTime, userId, Character.valueOf('1'), nowTime, defSupplyParam.orgTpy.id, "C", userId, defSupplyParam.orgTpy.number};
                    params.add(p);
                    break;
                }
                case 4: {
                    Object[] p = new Object[]{defSupplyParam.orgTpy.id, defSupplyParam.orgTpy.pkId, ResManager.getLanguage(), defSupplyParam.orgTpy.name};
                    params.add(p);
                    break;
                }
                case 5: 
                case 6: 
                case 10: {
                    Object[] p = new Object[]{defSupplyParam.id};
                    params.add(p);
                    break;
                }
                case 7: {
                    Object[] p = new Object[]{defSupplyParam.pkId};
                    params.add(p);
                    break;
                }
                case 8: {
                    Object[] p = new Object[]{defSupplyParam.id, defSupplyParam.createorg, defSupplyParam.id, defSupplyParam.createorg, "C", defSupplyParam.defaultctrlstrategy, defSupplyParam.number, nowTime, userId, Character.valueOf('1'), nowTime, defSupplyParam.defsupplytype, userId};
                    params.add(p);
                    break;
                }
                case 9: {
                    Object[] p = new Object[]{defSupplyParam.id, defSupplyParam.pkId, ResManager.getLanguage(), defSupplyParam.name};
                    params.add(p);
                    break;
                }
                case 11: {
                    Object[] p = new Object[]{defSupplyParam.entryId};
                    params.add(p);
                    break;
                }
                case 12: {
                    Object[] p = new Object[]{defSupplyParam.id, defSupplyParam.isupgrade, defSupplyParam.entryId, defSupplyParam.seq, defSupplyParam.defsupplytype, defSupplyParam.createorg, defSupplyParam.supplyproportion, defSupplyParam.supplyrule};
                    params.add(p);
                    break;
                }
            }
            map.put(InitSQLConst.defSupplySql[i], params);
        }
        return map;
    }

    protected static class DefSupplyParam {
        Long id;
        String pkId;
        String number;
        String name;
        Long defsupplytype;
        Long createorg;
        BigDecimal supplyproportion;
        boolean isupgrade;
        Long entryId;
        int seq;
        String supplyrule;
        String defaultctrlstrategy;
        OrgTpyParam orgTpy;

        public DefSupplyParam(Long id, String pkId, String number, String name, Long defsupplytype, Long createorg, BigDecimal supplyproportion, boolean isupgrade, Long entryId, int seq, String supplyrule, String defaultctrlstrategy, OrgTpyParam orgTpy) {
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.defsupplytype = defsupplytype;
            this.createorg = createorg;
            this.supplyproportion = supplyproportion;
            this.isupgrade = isupgrade;
            this.entryId = entryId;
            this.seq = seq;
            this.supplyrule = supplyrule;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.orgTpy = orgTpy;
        }
    }

    protected static class OrgTpyParam {
        Long id;
        String pkId;
        String number;
        String name;

        protected OrgTpyParam(Long id, String pkId, String number, String name) {
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
        }
    }

    protected static class StockTypeEntryParam {
        Long stocktypeId;
        boolean ismrp;
        Long entryid;
        int seq;

        protected StockTypeEntryParam(Long stocktypeId, boolean ismrp, Long entryid, int seq) {
            this.stocktypeId = stocktypeId;
            this.ismrp = ismrp;
            this.entryid = entryid;
            this.seq = seq;
        }
    }

    protected static class StockStatusEntryParam {
        Long stocktypeId;
        boolean ismrp;
        Long entryid;
        int seq;

        protected StockStatusEntryParam(Long stocktypeId, boolean ismrp, Long entryid, int seq) {
            this.stocktypeId = stocktypeId;
            this.ismrp = ismrp;
            this.entryid = entryid;
            this.seq = seq;
        }
    }

    protected static class StocksupplyParam {
        Long orgId;
        String defaultctrlstrategy;
        Long id;
        String pkId;
        String number;
        String name;
        int integerfield;
        Long entryid;
        int seq;
        Long storageorgid;
        BigDecimal decimalfield;
        List<StockStatusEntryParam> stockStatusEntryParams;
        List<StockTypeEntryParam> stockTypeEntryParams;

        protected StocksupplyParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, String name, int integerfield, Long entryid, int seq, Long storageorgid, BigDecimal decimalfield, char stocksetup, List<StockStatusEntryParam> stockStatusEntryParams, List<StockTypeEntryParam> stockTypeEntryParams) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.integerfield = integerfield;
            this.entryid = entryid;
            this.seq = seq;
            this.storageorgid = storageorgid;
            this.decimalfield = decimalfield;
            this.stockStatusEntryParams = stockStatusEntryParams;
            this.stockTypeEntryParams = stockTypeEntryParams;
        }
    }

    protected static class PlanProEntryParam {
        Long entryId;
        int seq;
        String entrydemandsrc;
        Long resourceregister;
        boolean entryismrpoperat;

        protected PlanProEntryParam(Long entryId, int seq, String entrydemandsrc, Long resourceregister, boolean entryismrpoperat) {
            this.entryId = entryId;
            this.seq = seq;
            this.entrydemandsrc = entrydemandsrc;
            this.resourceregister = resourceregister;
            this.entryismrpoperat = entryismrpoperat;
        }
    }

    protected static class PlanProscEntryParam {
        Long entryId;
        int seq;
        int supplypriority;
        String entrysupplyres;
        Long resourceregisters;
        boolean entryisscmrpoperat;

        protected PlanProscEntryParam(Long entryId, int seq, int supplypriority, String entrysupplyres, Long resourceregisters, boolean entryisscmrpoperat) {
            this.entryId = entryId;
            this.seq = seq;
            this.supplypriority = supplypriority;
            this.entrysupplyres = entrysupplyres;
            this.resourceregisters = resourceregisters;
            this.entryisscmrpoperat = entryisscmrpoperat;
        }
    }

    protected static class PlanProorgEntryParam {
        Long entryId;
        int seq;
        Long entryinvstrategy;
        Long entrysupplynet;
        Long entryplanscope;
        Long entrydemandorg;

        protected PlanProorgEntryParam(Long entryId, int seq, Long entryinvstrategy, Long entrysupplynet, Long entryplanscope, Long entrydemandorg) {
            this.entryId = entryId;
            this.seq = seq;
            this.entryinvstrategy = entryinvstrategy;
            this.entrysupplynet = entrysupplynet;
            this.entryplanscope = entryplanscope;
            this.entrydemandorg = entrydemandorg;
        }
    }

    protected static class PlanProreEntryParam {
        Long entryId;
        int seq;
        String resulttype;
        String adjuststrategy;
        String entryentitytype;

        protected PlanProreEntryParam(Long entryId, int seq, String resulttype, String adjuststrategy, String entryentitytype) {
            this.entryId = entryId;
            this.seq = seq;
            this.resulttype = resulttype;
            this.adjuststrategy = adjuststrategy;
            this.entryentitytype = entryentitytype;
        }
    }

    protected static class PlanProgramParam {
        Long createorg;
        String defaultctrlstrategy;
        Long id;
        String pkId;
        String number;
        String name;
        String type;
        Long supplymodel;
        boolean isreplace;
        boolean isbatchpolicy;
        String appmode;
        Long masterid;
        Long org;
        boolean considerbatchstr;
        boolean islossrate;
        boolean isyield;
        boolean isadjust;
        boolean ismps;
        boolean hiloinv;
        boolean ismrp;
        boolean isreorderpoint;
        int planoutlook;
        int dropbatchcount;
        String safestockeffectset;
        boolean isreserve;
        char outofdate;
        Long demandmodel;
        Long relativetransfer;
        String computemode;
        char scoutofdate;
        String adjusteffectset;
        boolean issafestock;
        String releasemode;
        String ocpweakreserve;
        List<PlanProreEntryParam> planProreEntryParams;
        List<PlanProorgEntryParam> planProorgEntryParams;
        List<PlanProscEntryParam> planProscEntryParams;
        List<PlanProEntryParam> planProEntryParams;

        protected PlanProgramParam(Long createorg, String defaultctrlstrategy, Long id, String pkId, String number, String name, String type, Long supplymodel, boolean isreplace, boolean isbatchpolicy, String appmode, Long masterid, Long org, boolean considerbatchstr, boolean islossrate, boolean isyield, boolean isadjust, boolean ismps, boolean hiloinv, boolean ismrp, boolean isreorderpoint, int planoutlook, int dropbatchcount, String safestockeffectset, boolean isreserve, char outofdate, Long demandmodel, Long relativetransfer, String computemode, char scoutofdate, String adjusteffectset, boolean issafestock, String releasemode, String ocpweakreserve, List<PlanProreEntryParam> planProreEntryParams, List<PlanProorgEntryParam> planProorgEntryParams, List<PlanProscEntryParam> planProscEntryParams, List<PlanProEntryParam> planProEntryParams) {
            this.createorg = createorg;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.type = type;
            this.supplymodel = supplymodel;
            this.isreplace = isreplace;
            this.isbatchpolicy = isbatchpolicy;
            this.appmode = appmode;
            this.masterid = masterid;
            this.org = org;
            this.considerbatchstr = considerbatchstr;
            this.islossrate = islossrate;
            this.isyield = isyield;
            this.isadjust = isadjust;
            this.ismps = ismps;
            this.hiloinv = hiloinv;
            this.ismrp = ismrp;
            this.isreorderpoint = isreorderpoint;
            this.planoutlook = planoutlook;
            this.dropbatchcount = dropbatchcount;
            this.safestockeffectset = safestockeffectset;
            this.isreserve = isreserve;
            this.outofdate = outofdate;
            this.demandmodel = demandmodel;
            this.relativetransfer = relativetransfer;
            this.computemode = computemode;
            this.scoutofdate = scoutofdate;
            this.adjusteffectset = adjusteffectset;
            this.issafestock = issafestock;
            this.releasemode = releasemode;
            this.ocpweakreserve = ocpweakreserve;
            this.planProreEntryParams = planProreEntryParams;
            this.planProorgEntryParams = planProorgEntryParams;
            this.planProscEntryParams = planProscEntryParams;
            this.planProEntryParams = planProEntryParams;
        }
    }

    private static class GrossParam {
        Long orgId;
        String defaultctrlstrategy;
        Long id;
        String pkId;
        String number;
        String name;
        Long codetype;
        String safetystock;
        String supplysluggishtype;

        private GrossParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, String name, Long codetype, String safetystock, String supplysluggishtype) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.codetype = codetype;
            this.safetystock = safetystock;
            this.supplysluggishtype = supplysluggishtype;
        }
    }

    protected static class ResDataConfigParam {
        Long id;
        String pkId;
        String number;
        LocaleString name;
        Long billfieldtransfer;
        char issystemdesign;
        String filter;
        String filter_tag;
        String sourcetype;

        protected ResDataConfigParam(Long id, String pkId, String number, LocaleString name, Long billfieldtransfer, char issystemdesign, String filter, String filter_tag, String sourcetype) {
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.billfieldtransfer = billfieldtransfer;
            this.issystemdesign = issystemdesign;
            this.filter = filter;
            this.filter_tag = filter_tag;
            this.sourcetype = sourcetype;
        }
    }

    protected static class ResRegisEntryParam {
        Long entryId;
        int seq;
        String signid;
        LocaleString signname;
        String datatype;
        String bizdatatype;
        String defaultvalue;
        String srctype;
        String formuladesc;

        protected ResRegisEntryParam(Long entryId, int seq, String signid, LocaleString signname, String datatype, String bizdatatype, String defaultvalue, String srctype, String formuladesc) {
            this.entryId = entryId;
            this.seq = seq;
            this.signid = signid;
            this.signname = signname;
            this.datatype = datatype;
            this.bizdatatype = bizdatatype;
            this.defaultvalue = defaultvalue;
            this.srctype = srctype;
            this.formuladesc = formuladesc;
        }
    }

    protected static class ResRegisParam {
        Long orgId;
        String defaultctrlstrategy;
        Long id;
        String pkId;
        String number;
        LocaleString name;
        String type;
        String businesstype;
        String businessentity;
        Long relativeresource;
        Long relativetransfer;
        Long outputmapping;
        String outputtype;
        Long outtosupply;
        List<ResRegisEntryParam> entryParams;
        List<ResDataConfigParam> resDataConfigParams;
        String appId;

        protected ResRegisParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, LocaleString name, String type, String businesstype, String businessentity, Long relativeresource, Long relativetransfer, Long outputmapping, String outputtype, Long outtosupply, List<ResRegisEntryParam> entryParams, List<ResDataConfigParam> resDataConfigParams, String appId) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.type = type;
            this.businesstype = businesstype;
            this.businessentity = businessentity;
            this.relativeresource = relativeresource;
            this.relativetransfer = relativetransfer;
            this.outputmapping = outputmapping;
            this.outputtype = outputtype;
            this.outtosupply = outtosupply;
            this.entryParams = entryParams;
            this.resDataConfigParams = resDataConfigParams;
            this.appId = appId;
        }
    }

    protected static class TrsfEntryParam {
        Long entryId;
        int seq;
        String calculateexc_tag;
        String calculateexc;
        String calculatetext;
        String destfieldflag;
        LocaleString destfieldname;
        String destentityflag;
        String sourcefieldflag;
        LocaleString sourcefieldname;
        String sourceentityflag;
        String converttype;

        protected TrsfEntryParam(Long entryId, int seq, String calculateexc_tag, String calculateexc, String calculatetext, String destfieldflag, LocaleString destfieldname, String destentityflag, String sourcefieldflag, LocaleString sourcefieldname, String sourceentityflag, String converttype) {
            this.entryId = entryId;
            this.seq = seq;
            if ("1".equalsIgnoreCase(converttype) || "3".equalsIgnoreCase(converttype)) {
                calculateexc_tag = MulLangTableDataInitUtil.formatFormulaJson(calculateexc, calculatetext);
            }
            this.calculateexc_tag = calculateexc_tag;
            this.calculateexc = calculateexc;
            this.calculatetext = calculatetext;
            this.destfieldflag = destfieldflag;
            this.destfieldname = destfieldname;
            this.destentityflag = destentityflag;
            this.sourcefieldflag = sourcefieldflag;
            this.sourcefieldname = sourcefieldname;
            this.sourceentityflag = sourceentityflag;
            this.converttype = converttype;
        }
    }

    protected static class TrsfParam {
        Long orgId;
        String defaultctrlstrategy;
        Long id;
        String pkId;
        String number;
        LocaleString name;
        String srcbill;
        String destbill;
        String ismatchdim;
        String appId;
        List<TrsfEntryParam> entryParams;

        protected TrsfParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, LocaleString name, String srcbill, String destbill, String ismatchdim, List<TrsfEntryParam> entryParams, String appId) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.srcbill = srcbill;
            this.destbill = destbill;
            this.ismatchdim = ismatchdim;
            this.entryParams = entryParams;
            this.appId = appId;
        }
    }

    protected static class CalcEntryParam {
        Long entryId;
        int seq;
        String runtype;
        Long bizplan;

        protected CalcEntryParam(Long entryId, int seq, String runtype, Long bizplan) {
            this.entryId = entryId;
            this.seq = seq;
            this.runtype = runtype;
            this.bizplan = bizplan;
        }
    }

    protected static class CalcParam {
        Long orgId;
        String defaultctrlstrategy;
        Long id;
        String pkId;
        String number;
        LocaleString name;
        List<CalcEntryParam> calcEntrys;
        String appId;

        protected CalcParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, LocaleString name, List<CalcEntryParam> calcEntrys, String appId) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.calcEntrys = calcEntrys;
            this.appId = appId;
        }
    }

    protected static class BizEntryParam {
        Long entryId;
        int seq;
        Long algomodel;

        protected BizEntryParam(Long entryId, int seq, Long algomodel) {
            this.entryId = entryId;
            this.seq = seq;
            this.algomodel = algomodel;
        }
    }

    protected static class BizParam {
        Long orgId;
        String defaultctrlstrategy;
        Long id;
        String pkId;
        String number;
        LocaleString name;
        String cellsdata_tag;
        String xml_tag;
        List<BizEntryParam> bizEntrys;
        String appId;

        protected BizParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, LocaleString name, String cellsdata_tag, String xml_tag, List<BizEntryParam> bizEntrys, String appId) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.cellsdata_tag = cellsdata_tag;
            this.xml_tag = xml_tag;
            this.bizEntrys = bizEntrys;
            this.appId = appId;
        }
    }

    protected static class AlgoParam {
        Long orgId;
        String defaultctrlstrategy;
        Long id;
        String pkId;
        String number;
        LocaleString name;
        String type;
        String classPath;
        LocaleString remark;
        String appId;

        protected AlgoParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, LocaleString name, String type, String classPath, String appId) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.type = type;
            this.classPath = classPath;
            this.remark = MulLangTableDataInitUtil.string2LocaleString("");
            this.appId = appId;
        }

        protected AlgoParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, LocaleString name, String type, String classPath, LocaleString remark, String appId) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.type = type;
            this.classPath = classPath;
            this.remark = remark;
            this.appId = appId;
        }
    }
}

