/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.common.util;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.Tuple;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class BaseDataUtils {
    private static final String algoKey = "FctImportUtils";

    private BaseDataUtils() {
        throw new KDBizException("not supported");
    }

    public static Map<Object, Tuple<String, String>> getMaterialId2NumberAndName(Set<Object> materialIds) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", materialIds)};
        HashMap materialId2NumberAndName = Maps.newHashMapWithExpectedSize((int)materialIds.size());
        try (DataSet dataSet = ORM.create().queryDataSet(algoKey, "bd_material", "id, number, name", filters);){
            for (Row row : dataSet) {
                materialId2NumberAndName.put(row.get(0), Tuple.create((Object)row.getString(1), (Object)row.getString(2)));
            }
        }
        return materialId2NumberAndName;
    }

    public static Map<Object, String> getPersonId2Name(Set<Object> personIds) {
        return BaseDataUtils.getId2Property("bos_user", personIds, "name");
    }

    public static String getPlanId2Number(Long planId) {
        try (DataSet dataSet = ORM.create().queryDataSet(algoKey, "mrp_planprogram", "number", new QFilter("id", "=", (Object)planId).toArray(), null, 1);){
            if (dataSet.hasNext()) {
                String string = dataSet.next().getString(0);
                return string;
            }
            String string = "";
            return string;
        }
    }

    public static Map<Object, String> getUnitId2Name(Set<Object> unitIds) {
        return BaseDataUtils.getId2Property("bd_measureunits", unitIds, "name");
    }

    public static Map<Object, String> getOrgId2Name(Set<Object> orgIds) {
        return BaseDataUtils.getId2Property("bos_org", orgIds, "name");
    }

    public static Map<Object, String> getSupplierId2Name(Set<Object> supplierIds) {
        return BaseDataUtils.getId2Property("bd_supplier", supplierIds, "name");
    }

    public static Map<Object, String> getMaterialId2Number(Set<Object> mids) {
        return BaseDataUtils.getId2Property("bd_material", mids, "number");
    }

    private static Map<Object, String> getId2Property(String entityId, Set<Object> ids, String property) {
        HashMap id2Property;
        QFilter[] filters;
        if (ids == null) {
            filters = null;
            id2Property = new HashMap(16);
        } else {
            filters = new QFilter[]{new QFilter("id", "in", ids)};
            id2Property = Maps.newHashMapWithExpectedSize((int)ids.size());
        }
        try (DataSet dataSet = ORM.create().queryDataSet(algoKey, entityId, "id, " + property, filters);){
            for (Row row : dataSet) {
                id2Property.put(row.get(0), row.getString(1));
            }
        }
        return id2Property;
    }

    public static void dumpDataSet(DataSet ds, String str) {
        ds = ds.copy();
        if (str == null) {
            RowMeta rowMeta = ds.getRowMeta();
            String[] fieldNames = rowMeta.getFieldNames();
            int cols = rowMeta.getFieldCount();
            for (int i = 0; i < cols; ++i) {
                System.out.print(fieldNames[i] + "\t\t");
            }
            System.out.println();
            for (Row row : ds) {
                for (int i = 0; i < cols; ++i) {
                    System.out.print(row.get(i));
                    System.out.print("\t");
                }
                System.out.println();
            }
        } else {
            String[] split = str.split(",");
            for (String value : split) {
                System.out.print(value + "\t\t");
            }
            System.out.println();
            for (Row row : ds) {
                for (String s : split) {
                    System.out.print(row.get(s));
                    System.out.print("\t");
                }
                System.out.println();
            }
        }
    }
}

