/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.common.util;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Toolbar;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.NetAddressUtils;

public class CalSetingUtils {
    public static final String BASE_TASK = "kd.mmc.mrp.task.BaseCalcRunningTask";
    public static final String BTNSAVE = "bar_save";
    public static final String C_END = "end";
    public static final String C_START = "start";
    public static final int CANCEL = 2;
    public static final String CO_BASENUMBER = "number";
    public static final String CO_STATUS = "status";
    public static final String CO_CYCLETYPED = "cycletyped";
    public static final String CO_DAYSOFMON = "daysofmon";
    public static final String CO_DAYSOFWEEK = "daysofweek";
    public static final String CO_EXE = "tasktype";
    public static final String CO_JOBID = "jobid";
    public static final String CO_LOSEDATE = "losedate";
    public static final String CO_PLANID = "planid";
    public static final String CO_PREDTIME = "predtime";
    public static final String CO_REPEAT = "repeat";
    public static final String CO_REPEATTYPE = "repeattype";
    public static final String CO_RUNNINGTYPE = "runningtype";
    public static final String CO_RUNSTATUS = "runstatus";
    public static final String CO_PLAN = "plan";
    public static final int HMS = 60;
    public static final String LOCALIP = "127.0.0.1";
    private static final Logger logger = Logger.getLogger(CalSetingUtils.class.getName());
    public static final String OP = "op";
    public static final String RTIMD = "0";
    public static final String RWEEK = "0";
    public static final int SAVE = 0;

    public static boolean beforeNow(int h, int m, int s) {
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(System.currentTimeMillis());
        Calendar pred = Calendar.getInstance();
        pred.set(1, now.get(1));
        pred.set(2, now.get(2));
        pred.set(5, now.get(5));
        pred.set(11, h);
        pred.set(12, m);
        pred.set(13, s);
        return pred.compareTo(now) > 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    private static boolean bigger(Calendar c1, Calendar c2, int c) {
        return c1.get(c) > c2.get(c);
    }

    public static int compare(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(d2);
        if (CalSetingUtils.bigger(c1, c2, 1)) {
            return 1;
        }
        if (CalSetingUtils.lower(c1, c2, 1)) {
            return -1;
        }
        if (CalSetingUtils.bigger(c1, c2, 2)) {
            return 1;
        }
        if (CalSetingUtils.lower(c1, c2, 2)) {
            return -1;
        }
        if (CalSetingUtils.bigger(c1, c2, 5)) {
            return 1;
        }
        if (CalSetingUtils.lower(c1, c2, 5)) {
            return -1;
        }
        return 0;
    }

    public static String createExp(String key, Map<String, Object> m) {
        List days = (List)m.get(key);
        CharSequence[] array = days.toArray(new String[days.size()]);
        return String.join((CharSequence)",", array);
    }

    public static String getHostIpAddress() {
        return NetAddressUtils.getLocalIpAddress();
    }

    public static Calendar getStarttime(int pred, String rt) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        if (StringUtils.equals((CharSequence)"0", (CharSequence)rt)) {
            c.add(13, 60);
            return c;
        }
        int h = pred / 60 / 60;
        int m = pred / 60 % 60;
        int s = pred % 60;
        if (CalSetingUtils.beforeNow(h, m, s)) {
            c.add(5, 1);
            c.set(11, h);
            c.set(12, m);
            c.set(13, s);
            return c;
        }
        c.set(11, h);
        c.set(12, m);
        c.set(13, s);
        return c;
    }

    public static String getTaskId() {
        DynamicObject taskname = BusinessDataServiceHelper.loadSingle((String)"sch_taskdefine", (String)CO_BASENUMBER, (QFilter[])new QFilter[]{new QFilter("classname", "=", (Object)BASE_TASK)});
        if (taskname == null) {
            return null;
        }
        return String.valueOf(taskname.getPkValue());
    }

    public static void unrelease(DynamicObject obj) {
        String planId = obj.getString(CO_PLANID);
        String jobId = obj.getString(CO_JOBID);
        JobDispatcherProxy jdp = new JobDispatcherProxy();
        ScheduleDao sdao = ExecutorService.getInstance().getObjectFactory().getScheduleDao();
        TaskDao tdao = ExecutorService.getInstance().getObjectFactory().getTaskDao();
        if (!jobId.isEmpty()) {
            jdp.deleteJob(jobId);
        }
        if (!planId.isEmpty()) {
            jdp.deletePlan(planId);
            tdao.deleteTaskByScheduleId(planId);
            sdao.disableSchedule(planId);
        }
    }

    public static String runSgl(DynamicObject task) {
        String rt = task.getString(CO_RUNNINGTYPE);
        Date losedate = task.getDate(CO_LOSEDATE);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        if (losedate != null && CalSetingUtils.comp(c.getTime(), losedate)) {
            return ResManager.loadKDString((String)"\u8ba1\u7b97\u8bf7\u6c42\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"CalSetingUtils_0", (String)"mmc-mrp-common", (Object[])new Object[0]);
        }
        JobDispatcherProxy jdp = new JobDispatcherProxy();
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        ScheduleDao sdao = ExecutorService.getInstance().getObjectFactory().getScheduleDao();
        TaskDao tdao = ExecutorService.getInstance().getObjectFactory().getTaskDao();
        String planId = task.getString(CO_PLANID);
        String jobId = task.getString(CO_JOBID);
        if (!planId.isEmpty()) {
            sdao.disableSchedule(planId);
            jdp.deleteJob(jobId);
            jdp.deletePlan(planId);
            tdao.deleteTaskByScheduleId(planId);
        }
        JobInfo jobInfo = CalSetingUtils.initJobInfo(task, Caltype.XQJH_CAL.ordinal(), CO_BASENUMBER);
        jobId = jdp.createJob(jobInfo);
        task.set(CO_JOBID, (Object)jobId);
        PlanInfo planInfo = CalSetingUtils.initPlanInfo(jobId, task);
        planId = jdp.createPlan(planInfo);
        boolean isSuccess = sdao.existed(planId);
        for (int count = 0; !isSuccess && count <= 3; ++count) {
            planId = jdp.createPlan(planInfo);
            isSuccess = sdao.existed(planId);
        }
        if (!planId.isEmpty() && "2".equals(task.getString(CO_REPEATTYPE))) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"sch_schedule");
            obj.set("repeatmode", (Object)"def");
            SaveServiceHelper.update((DynamicObject)obj);
        }
        task.set(CO_PLANID, (Object)planId);
        if ("0".equals(rt)) {
            JobClient.dispatch((JobInfo)jobInfo);
        } else {
            scheduleManager.enableSchedule(planId);
            scheduleManager.enableJob(jobId);
        }
        task.set("ISRELEASE", (Object)Boolean.TRUE);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{task});
        return "";
    }

    public static JobInfo initJobInfo(DynamicObject task, int calsType, String uniquekey) {
        String reqId = task.getString(uniquekey);
        String jobNum = "JOB-" + reqId;
        JobInfo jobInfo = new JobInfo();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", task.get("name"));
        params.put(CO_BASENUMBER, task.get(CO_BASENUMBER));
        jobInfo.setId(jobNum);
        jobInfo.setAppId("mrp");
        jobInfo.setNumber(jobNum);
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8c03\u5ea6\u65b9\u6848%s", (String)"CalSetingUtils_1", (String)"mmc-mrp-common", (Object[])new Object[0]), reqId));
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setRunConcurrently(true);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        String className = CalSetingUtils.getTaskId();
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setTaskClassname(BASE_TASK);
        jobInfo.setParams(params);
        return jobInfo;
    }

    public static PlanInfo initPlanInfo(String jobId, DynamicObject task) {
        PlanInfo planInfo = new PlanInfo();
        String reqId = task.getString(CO_BASENUMBER);
        String rt = task.getString(CO_RUNNINGTYPE);
        Date losd = task.getDate(CO_LOSEDATE);
        String planNum = "PLAN-" + reqId;
        planInfo.setNumber(planNum);
        planInfo.setJobId(jobId);
        CalSetingUtils.setLostdate(planInfo, losd);
        Integer pred = task.getInt(CO_PREDTIME);
        Calendar starttime = CalSetingUtils.getStarttime(pred, rt);
        planInfo.setStartTime(starttime);
        planInfo.setName(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8c03\u5ea6\u65b9\u6848%s", (String)"CalSetingUtils_1", (String)"mmc-mrp-common", (Object[])new Object[0]), reqId));
        task.set(CO_JOBID, (Object)jobId);
        String repeattype = task.getString(CO_REPEATTYPE);
        if (!task.getBoolean(CO_REPEAT)) {
            planInfo.setRepeatMode(RepeatModeEnum.NONE);
            return planInfo;
        }
        if ("0".equals(repeattype)) {
            planInfo.setRepeatMode(RepeatModeEnum.ByWeeks);
            String daysExp = task.getString(CO_DAYSOFWEEK);
            planInfo.setWeekdaysExp(daysExp);
            planInfo.setPeriod(1);
        } else if ("1".equals(repeattype)) {
            planInfo.setRepeatMode(RepeatModeEnum.ByMonths);
            String daysExp = task.getString(CO_DAYSOFMON);
            planInfo.setDaysExp(daysExp);
            planInfo.setPeriod(1);
        } else if ("2".equals(repeattype)) {
            String plan = task.getString(CO_PLAN);
            planInfo.setCronExpression(plan);
            planInfo.setPeriod(1);
        }
        planInfo.setHost(CalSetingUtils.getHostIpAddress());
        return planInfo;
    }

    public static boolean comp(Date comp, Date now) {
        Calendar nCal = Calendar.getInstance();
        nCal.setTime(now);
        Calendar cCal = Calendar.getInstance();
        cCal.setTime(comp);
        if (cCal.get(1) > nCal.get(1)) {
            return true;
        }
        if (cCal.get(1) < nCal.get(1)) {
            return false;
        }
        if (cCal.get(2) > nCal.get(2)) {
            return true;
        }
        if (cCal.get(2) < nCal.get(2)) {
            return false;
        }
        return cCal.get(5) >= nCal.get(5);
    }

    public static boolean isEmpty(Object[] obj) {
        return obj == null || obj.length < 1;
    }

    public static boolean isWeek(Map<String, Object> csetting) {
        String week = (String)csetting.get(CO_REPEATTYPE);
        return StringUtils.equals((CharSequence)"0", (CharSequence)week) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object load(IDataModel dm, String key) {
        return dm.getValue(key);
    }

    private static boolean lower(Calendar c1, Calendar c2, int c) {
        return c1.get(c) < c2.get(c);
    }

    public static void refresh(IFormView fv) {
        Toolbar toolbar = (Toolbar)fv.getControl("tbmain");
        toolbar.itemClick("", "refresh");
    }

    public static void clearLogAndStatus(DynamicObject obj, boolean isClearRunStatus) {
        if (isClearRunStatus) {
            obj.set(CO_RUNSTATUS, (Object)"");
        }
        obj.set("dataversionstatus", (Object)"");
        obj.set("dataversionlog", (Object)"");
        obj.set("forecastplanstatus", (Object)"");
        obj.set("forecastplanlog", (Object)"");
        obj.set("forecastplanlogno", (Object)"");
        obj.set("forecastlogid", (Object)0L);
        obj.set("forecastlognumber", (Object)"");
        obj.set("forecastrunstatus", (Object)"");
        obj.set("reqplanlog", (Object)"");
        obj.set("reqplanrunstatus", (Object)"");
        obj.set("mrplog", (Object)"");
        obj.set("mrprunstatus", (Object)"");
        obj.set("mrpexp", (Object)"");
        obj.set("dsplog", (Object)"");
        obj.set("dpsrunstatus", (Object)"");
        obj.set("ecorunlogid", (Object)"");
        obj.set("ecorunstatus", (Object)"");
    }

    public static void runImediatly(Object pk, IFormView fv) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"mrp_plandispatch");
        HashMap<String, Object> params = new HashMap<String, Object>();
        JobInfo jobInfo = new JobInfo();
        String jobId = "JOB-" + bill.getString(CO_BASENUMBER);
        bill.set(CO_JOBID, (Object)jobId);
        CalSetingUtils.clearLogAndStatus(bill, false);
        SaveServiceHelper.update((DynamicObject)bill);
        jobInfo.setId(jobId);
        jobInfo.setName(ResManager.loadKDString((String)"MRP\u8ba1\u7b97\u4efb\u52a1", (String)"CalSetingUtils_2", (String)"mmc-mrp-common", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("mrp");
        boolean connc = true;
        jobInfo.setRunConcurrently(connc);
        String className = CalSetingUtils.getTaskId();
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setTaskClassname(BASE_TASK);
        params.put("name", bill.get("name"));
        params.put(CO_BASENUMBER, bill.get(CO_BASENUMBER));
        jobInfo.setParams(params);
        JobClient.dispatch((JobInfo)jobInfo);
        if (fv != null) {
            fv.setEnable(Boolean.FALSE, new String[]{BTNSAVE});
            fv.showMessage(ResManager.loadKDString((String)"\u8ba1\u7b97\u4efb\u52a1\u5206\u53d1\u6210\u529f\uff0c\u8bf7\u5230\u5217\u8868\u754c\u9762\u67e5\u770b\u3002", (String)"CalSetingUtils_3", (String)"mmc-mrp-common", (Object[])new Object[0]));
            fv.invokeOperation("refresh");
        }
    }

    public static DynamicObject[] selectedData(IFormView view) {
        BillList list = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection rows = list.getSelectedRows();
        String entityName = list.getEntityType().getName();
        if (!rows.isEmpty()) {
            DynamicObject[] cc = new DynamicObject[rows.size()];
            for (int i = 0; i < rows.size(); ++i) {
                Object pk = rows.get(i).getPrimaryKeyValue();
                cc[i] = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName);
            }
            return cc;
        }
        return new DynamicObject[0];
    }

    public static void setLostdate(PlanInfo planInfo, Date lostdate) {
        Calendar lc = Calendar.getInstance();
        if (lostdate == null) {
            lc.set(1, 2099);
            lc.set(2, 11);
            lc.set(5, 31);
        } else {
            lc.setTime(lostdate);
            lc.add(5, 1);
        }
        planInfo.setEndTime(lc);
    }

    public static enum Caltype {
        XQJH_CAL,
        YC_CAL;

    }
}

