/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mmc.mrp.common.util.DateUtils;

public class ForecastUtils {
    private static final String algoKey = "ForecastUtils";

    private ForecastUtils() {
        throw new KDBizException("not supported");
    }

    public static boolean isLastRunLog(String caculatelog) {
        ORM orm = ORM.create();
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)3);
        filters.add(new QFilter("number", "=", (Object)caculatelog));
        filters.add(new QFilter("runtype", "=", (Object)"A"));
        filters.add(new QFilter("calculatestatus", "=", (Object)"A"));
        try (DataSet dataSet = orm.queryDataSet(algoKey, "mrp_caculate_log", "plangram", filters.toArray(new QFilter[0]), null, 1);){
            if (dataSet.hasNext()) {
                long planId = dataSet.next().getLong(0);
                filters.set(0, new QFilter("plangram", "=", (Object)planId));
                try (DataSet logDataSet = orm.queryDataSet(algoKey, "mrp_caculate_log", "number", filters.toArray(new QFilter[0]), "startdate desc", 1);){
                    if (logDataSet.hasNext()) {
                        boolean bl = StringUtils.equals((CharSequence)caculatelog, (CharSequence)logDataSet.next().getString(0));
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public static Long getPlanOrgByRunLog(String caculatelog) {
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)1);
        filters.add(new QFilter("number", "=", (Object)caculatelog));
        Long org = 0L;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mrp_caculate_log", (String)"createorg", (QFilter[])filters.toArray(new QFilter[0]), null, (int)1);){
            if (dataSet.hasNext()) {
                org = dataSet.next().getLong(0);
            }
        }
        return org;
    }

    public static void batchSave(DBRoute dbRoute, String insertSql, List<Object[]> values) {
        int totalCount = values.size();
        if (totalCount > 5000) {
            int times = totalCount / 5000 + 1;
            for (int i = 0; i < times; ++i) {
                int startIndex = i * 5000;
                int endIndex = Math.min(startIndex + 5000, totalCount);
                ForecastUtils.executeBatch(dbRoute, insertSql, values, startIndex, endIndex);
            }
        } else {
            DB.executeBatch((DBRoute)dbRoute, (String)insertSql, values);
        }
    }

    private static void executeBatch(DBRoute dbRoute, String insertSql, List<Object[]> values, int startIndex, int endIndex) {
        DB.executeBatch((DBRoute)dbRoute, (String)insertSql, values.subList(startIndex, endIndex));
    }

    public static Object[] getLastRunNumber() {
        Object[] result = new Object[]{"", 0L};
        QFilter[] filters = new QFilter[]{new QFilter("runtype", "=", (Object)"A"), new QFilter("calculatestatus", "=", (Object)"A"), new QFilter("clearstatus", "!=", (Object)Character.valueOf('B')), new QFilter("operatmodekey", "!=", (Object)"mrp_simulation")};
        try (DataSet dataSet = ORM.create().queryDataSet(algoKey, "mrp_caculate_log", "number,id", filters, "startdate desc", 1);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                result[0] = row.getString("number");
                result[1] = row.getLong("id");
            }
        }
        return result;
    }

    public static Tuple<Set<Long>, Set<Long>> getWasteStockIdsAndOrgIds(ORM orm, long planId) {
        String selectFields = "orgentryentity.entryinvstrategy.stocksetupentry.stocknumber warehouseId, orgentryentity.entryinvstrategy.stocksetupentry.stockorg orgId";
        QFilter filter1 = new QFilter("id", "=", (Object)planId);
        QFilter filter2 = new QFilter("orgentryentity.entryinvstrategy.stocksetupentry.wastewarehouse", "=", (Object)Boolean.TRUE);
        HashSet<Long> warehouseIds = new HashSet<Long>();
        HashSet<Long> orgIds = new HashSet<Long>();
        try (DataSet dataSet = orm.queryDataSet(algoKey, "mrp_planprogram", selectFields, new QFilter[]{filter1, filter2});){
            for (Row row : dataSet) {
                warehouseIds.add(row.getLong("warehouseId"));
                orgIds.add(row.getLong("orgId"));
            }
        }
        return Tuple.create(warehouseIds, orgIds);
    }

    public static Object getDateSetId() {
        return ForecastUtils.getDateSetId(0L);
    }

    public static Object getDateSetId(Long dataSetId) {
        if (dataSetId <= 0L) {
            QFilter qFilter = new QFilter("number", "=", (Object)"ORIGIN_DATE_SET");
            DeleteServiceHelper.delete((String)"mrp_dateset", (QFilter[])new QFilter[]{qFilter});
            String sql = "DELETE FROM t_mrp_dateset WHERE FID = 1236052332324699136;\nINSERT INTO t_mrp_dateset(FID,FNUMBER) VALUES (1236052332324699136,'ORIGIN_DATE_SET'); \nDELETE FROM t_mrp_datesetentry WHERE FID = 1236052332324699136;\nDELETE FROM t_mrp_datesetentry WHERE FENTRYID = 1241823387446312960;\nINSERT INTO t_mrp_datesetentry(FID,FTYPE,FNUM,FENTRYID,FSEQ,FISNATURAL) VALUES (1236052332324699136,'1',28,1241823387446312960,1,'0'); \nDELETE FROM t_mrp_datesetentry WHERE FENTRYID = 1241823387446312961;\nINSERT INTO t_mrp_datesetentry(FID,FTYPE,FNUM,FENTRYID,FSEQ,FISNATURAL) VALUES (1236052332324699136,'2',75,1241823387446312961,2,'0');";
            DB.execute((DBRoute)new DBRoute("scm"), (String)sql);
            return 1236052332324699136L;
        }
        return dataSetId;
    }

    public static CachedDataSet getCachedDataSet(QFilter[] filters, IFormView view, String selectFields) {
        IPageCache pageCache = view.getPageCache();
        String entityId = (String)view.getFormShowParameter().getCustomParam("fctEntityId");
        try (DataSet dataSet = ORM.create().queryDataSet(algoKey, entityId, selectFields, filters, "entryentity.seq");){
            String cacheId = view.getPageId();
            CacheHint cacheHint = new CacheHint();
            cacheHint.setCacheId(cacheId);
            cacheHint.setTimeout(1L, TimeUnit.DAYS);
            CachedDataSet cachedDataSet = dataSet.cache(cacheHint);
            pageCache.put("algoCacheId", cacheId);
            CachedDataSet cachedDataSet2 = cachedDataSet;
            return cachedDataSet2;
        }
    }

    public static String getSelectFields(String entityId) {
        String select = "";
        if ("mrp_pur_fctdata".equals(entityId)) {
            select = "caculatelog, plangram, entryentity.seq seq, entryentity.id entryid, entryentity.material material, entryentity.unit unit, entryentity.remarks remarks, entryentity.operator operator, entryentity.ispublished ispublished, entryentity.publisher publisher, entryentity.publish_time publish_time, entryentity.issplited issplited, entryentity.split_time split_time, entryentity.lastmodifier lastmodifier, entryentity.lastdatetime lastdatetime, entryentity.wasteqty wasteqty, entryentity.totalqty totalqty, entryentity.datatype datatype, entryentity.auxpty auxpty, entryentity.org org, entryentity.purorg purorg, entryentity.supplier supplier, entryentity.date_qty_tag date_qty_tag";
        }
        return select;
    }

    public static Map<Long, Boolean> cancelPublish(List<Object> entryIds) {
        ArrayList mrpEntryIds = Lists.newArrayListWithCapacity((int)(entryIds.size() / 2));
        QFilter qFilter = new QFilter("entryentity.id", "in", entryIds);
        qFilter.and(new QFilter("entryentity.datatype", "=", (Object)"B"));
        String selectField = "caculatelog, entryentity.id entryid";
        String caculatelog = "";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mrp_pur_fctdata", (String)selectField, (QFilter[])new QFilter[]{qFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (StringUtils.isBlank((CharSequence)caculatelog)) {
                    caculatelog = row.getString("caculatelog");
                }
                mrpEntryIds.add(row.getLong("entryid"));
            }
        }
        return (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurForecastService", (String)"cancelPublish", (Object[])new Object[]{caculatelog, mrpEntryIds});
    }

    public static Map<Long, Boolean> forecastInit(List<Object> entryIds) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)1);
        result.put(-1L, Boolean.TRUE);
        if (entryIds.isEmpty()) {
            return result;
        }
        ArrayList params = Lists.newArrayListWithCapacity((int)1);
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        params.add(map);
        ArrayList entrys = Lists.newArrayListWithCapacity((int)(entryIds.size() / 2));
        map.put("entry", entrys);
        String selectField = "dateinfo_tag, caculatelog, createdate, entryentity.id entryid, entryentity.material material, entryentity.unit unit, entryentity.date_qty_tag date_qty_tag";
        QFilter qFilter = new QFilter("entryentity.id", "in", entryIds);
        qFilter.and(new QFilter("entryentity.datatype", "=", (Object)"B"));
        boolean first = true;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List dateCols = Collections.emptyList();
        ObjectMapper objectMapper = SerializationUtils.getObjectMapper2();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mrp_pur_fctdata", (String)selectField, (QFilter[])new QFilter[]{qFilter}, null);){
            while (dataSet.hasNext()) {
                Map date2Qty;
                Row row = dataSet.next();
                if (first) {
                    map.put("plancalcnum", row.getString("caculatelog"));
                    dateCols = (List)SerializationUtils.fromJsonString((String)row.getString("dateinfo_tag"), List.class);
                    Date date = DateUtils.parseDate((String)dateCols.get(0));
                    map.put("startdate", simpleDateFormat.format(date));
                    map.put("planorgid", ForecastUtils.getPlanOrgIdByCalcLogNo(row.getString("caculatelog")));
                    first = false;
                }
                HashMap entry = Maps.newHashMapWithExpectedSize((int)106);
                entry.put("entryid", row.getLong("entryid"));
                entry.put("masterid", row.getLong("material"));
                entry.put("baseunit", row.getLong("unit"));
                String date_qty_tag = row.getString("date_qty_tag");
                try {
                    date2Qty = (Map)objectMapper.readValue(date_qty_tag, HashMap.class);
                }
                catch (JsonProcessingException e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u91c7\u8d2d\u9884\u6d4b\u65f6\u95f4\u5217\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u9884\u6d4b\u6570\u636e\u3002", (String)"ForecastUtils_0", (String)"mmc-mrp-common", (Object[])new Object[0]));
                }
                for (int i = 1; i <= 103; ++i) {
                    String key = i <= 28 ? "day" + i : "week" + (i - 28);
                    Object qtyObj = date2Qty.get(ForecastUtils.getDateCol(dateCols, i - 1));
                    BigDecimal qty = BigDecimal.ZERO;
                    if (qtyObj != null) {
                        qty = new BigDecimal(qtyObj.toString());
                    }
                    entry.put(key, qty);
                }
                entrys.add(entry);
            }
        }
        boolean flag = (Boolean)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurForecastService", (String)"forecastInit", (Object[])new Object[]{params});
        result.put(-1L, flag);
        return result;
    }

    private static Long getPlanOrgIdByCalcLogNo(String calcLogNo) {
        QFilter qFilter = new QFilter("number", "=", (Object)calcLogNo);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mrp_caculate_log", (String)"createorg", (QFilter[])new QFilter[]{qFilter}, null, (int)1);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long l = row.getLong(0);
                return l;
            }
        }
        return 0L;
    }

    private static String getDateCol(List<String> dateCols, int idx) {
        return idx >= dateCols.size() ? "" : dateCols.get(idx);
    }
}

