/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.common.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.service.AssignQueryService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class MRPORGUtil {
    private final Map<String, String> entity2ctrlViewNum = new HashMap<String, String>(2);

    public Map<Long, Set<Long>> batchGetRelationOrg(Map<Long, Set<Long>> createOrg2Pks, String entityType, String ctrlstrategy, Set<Long> requireOrgSet) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        switch (ctrlstrategy) {
            case "1": 
            case "2": {
                for (Map.Entry<Long, Set<Long>> entry : createOrg2Pks.entrySet()) {
                    result.putAll(this.getDisOrgs(entry.getKey(), entry.getValue(), entityType, requireOrgSet, ctrlstrategy));
                }
                break;
            }
            case "6": {
                for (Map.Entry<Long, Set<Long>> entry : createOrg2Pks.entrySet()) {
                    Set<Long> orgSet = this.getControlRangeOrgs(entry.getKey(), entityType, requireOrgSet);
                    for (Long pk : entry.getValue()) {
                        result.put(pk, orgSet);
                    }
                }
                break;
            }
        }
        return result;
    }

    public Set<Long> getRelationOrg(Long createOrgId, Long pk, String entityType, String ctrlstrategy, Set<Long> requireOrgSet) {
        Set<Long> orgSet = new HashSet<Long>(2);
        switch (ctrlstrategy) {
            case "1": 
            case "2": {
                orgSet = this.getDisOrgs(createOrgId, Collections.singleton(pk), entityType, requireOrgSet, ctrlstrategy).getOrDefault(pk, new HashSet(2));
                break;
            }
            case "5": {
                orgSet.addAll(requireOrgSet);
                break;
            }
            case "6": {
                orgSet = this.getControlRangeOrgs(createOrgId, entityType, requireOrgSet);
                break;
            }
            default: {
                orgSet.add(createOrgId);
            }
        }
        return orgSet;
    }

    private Set<Long> getControlRangeOrgs(Long createOrgId, String entityType, Set<Long> requireOrgSet) {
        HashSet<Long> orgSet = new HashSet<Long>(2);
        String ctrlViewNum = this.entity2ctrlViewNum.computeIfAbsent(entityType, k -> MRPORGUtil.getCtrlViewByEntityType(entityType));
        List orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((String)ctrlViewNum, Collections.singletonList(createOrgId), (boolean)true);
        orgSet.add(createOrgId);
        for (Long aLong : orgList) {
            if (!requireOrgSet.contains(aLong)) continue;
            orgSet.add(aLong);
        }
        return orgSet;
    }

    private Map<Long, Set<Long>> getDisOrgs(Long createOrgId, Set<Long> pks, String entityType, final Set<Long> requireOrgSet, String ctrlstrategy) {
        final HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(pks.size());
        for (Long pk : pks) {
            Set orgSet = result.computeIfAbsent(pk, k -> new HashSet(2));
            orgSet.add(createOrgId);
        }
        if (BaseDataCommonService.isNewModel((String)entityType)) {
            AssignQueryService service = new AssignQueryService(entityType);
            Map assignMap = service.assignQueryByData(new ArrayList<Long>(pks), createOrgId, ctrlstrategy);
            for (Map.Entry entry : assignMap.entrySet()) {
                Long dataId = (Long)entry.getKey();
                Set orgSet = result.computeIfAbsent(dataId, k -> new HashSet(2));
                for (Long orgId : (List)entry.getValue()) {
                    if (!requireOrgSet.contains(orgId)) continue;
                    orgSet.add(orgId);
                }
            }
        } else {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
            String dbRouteKey = dataEntityType.getDBRouteKey();
            String baseDataTableName = dataEntityType.getAlias();
            String string = baseDataTableName + "UseReg";
            DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
            SqlBuilder countUseRegSql = new SqlBuilder();
            countUseRegSql.append("select fdataid,fuseorgid from ", new Object[0]);
            countUseRegSql.append(string, new Object[0]);
            countUseRegSql.append(" where fisassign = '1' and ", new Object[0]);
            countUseRegSql.appendIn("fdataid", (Object[])pks.toArray(new Long[0]));
            DB.query((DBRoute)dbRoute, (SqlBuilder)countUseRegSql, (ResultSetHandler)new ResultSetHandler<Integer>(){

                public Integer handle(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        Long fuseorgid = rs.getLong("fuseorgid");
                        Long fdataid = rs.getLong("fdataid");
                        if (!requireOrgSet.contains(fuseorgid)) continue;
                        Set orgSet = result.computeIfAbsent(fdataid, k -> new HashSet(2));
                        orgSet.add(fuseorgid);
                    }
                    return 0;
                }
            });
        }
        return result;
    }

    public static String getCtrlViewByEntityType(String entityType) {
        String ctrlViewNum = "";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"MRPORGUtil.getCtrlViewByEntityType", (String)"bd_basedataview", (String)"basedata, ctrlview.number", (QFilter[])new QFilter[]{new QFilter("basedata", "=", (Object)entityType)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (row.get("ctrlview.number") == null) continue;
                ctrlViewNum = row.getString("ctrlview.number");
            }
        }
        return ctrlViewNum;
    }
}

