/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.common.util;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msplan.mservice.service.datasync.MMCSnapDataVisitor;

public class SnapshotDataUtils {
    private static final MMCSnapDataVisitor snapDataVisitor = new MMCSnapDataVisitor();
    private static final String algoKey = "SnapshotDataUtils";

    public static Long getVersionIdByRunLogNumber(String runLogNum) {
        Long logId = 0L;
        try (DataSet runLog = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mrp_caculate_log", (String)"id, dataversion", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)runLogNum)}, null, (int)1);){
            if (runLog.hasNext()) {
                Row row = runLog.next();
                logId = row.getLong("dataversion");
            }
        }
        return logId;
    }

    public static DataSet queryDataSet(String queryKey, Long versionId, String etStr, String selectFields, QFilter[] filters) {
        return SnapshotDataUtils.queryDataSet(queryKey, versionId, etStr, selectFields, filters, null, -1);
    }

    public static DataSet queryDataSet(String queryKey, Long versionId, String etStr, String selectFields, QFilter[] filters, String orderBys, int top) {
        if (StringUtils.isBlank((CharSequence)queryKey)) {
            queryKey = algoKey;
        }
        DataSet dataSet = null;
        if (versionId == null || versionId <= 0L) {
            dataSet = QueryServiceHelper.queryDataSet((String)queryKey, (String)etStr, (String)selectFields, (QFilter[])filters, (String)orderBys, (int)top);
        } else {
            dataSet = snapDataVisitor.localFastDataVisit(versionId, null, etStr, selectFields, filters, orderBys);
            if (dataSet == null) {
                dataSet = QueryServiceHelper.queryDataSet((String)queryKey, (String)etStr, (String)selectFields, (QFilter[])filters, (String)orderBys, (int)top);
            }
        }
        return dataSet;
    }

    public static DynamicObjectCollection query(Long versionId, String etStr, String selectFields, QFilter[] filters) {
        return SnapshotDataUtils.query(versionId, etStr, selectFields, filters, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObjectCollection query(Long versionId, String etStr, String selectFields, QFilter[] filters, String orderBys) {
        DataSet dataSet = SnapshotDataUtils.queryDataSet(null, versionId, etStr, selectFields, filters, orderBys, -1);
        if (dataSet != null) {
            try {
                DynamicObjectCollection dynamicObjectCollection = ORMUtil.toDynamicObjectCollection((DataSet)dataSet, (String)etStr);
                return dynamicObjectCollection;
            }
            finally {
                dataSet.close();
            }
        }
        return null;
    }
}

