/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.pls.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mmc.mrp.pls.model.Category;
import kd.mmc.mrp.pls.model.WorkCenter;
import kd.mmc.mrp.pls.model.WorkShiftManager;

public class WorkCenterManager {
    private static final String ALGO_KEY = "PLSEnv.";
    private final Map<String, Long> materialMap = new HashMap<String, Long>(16);
    private final Map<String, List<Long>> materialGroupMap = new HashMap<String, List<Long>>(16);
    private final Map<Long, WorkCenter> id2WorkCenter = new HashMap<Long, WorkCenter>(16);
    private final Map<Long, WorkShiftManager> workShiftManagerMap = new LinkedHashMap<Long, WorkShiftManager>(16);

    public WorkCenter computeIfAbsent(Long key, Function<Long, WorkCenter> mappingFunction) {
        return this.id2WorkCenter.computeIfAbsent(key, mappingFunction);
    }

    public void initMaterial(Set<Long> groupIdSet, Row row, StringBuilder sb) {
        if (Category.MATERIAL.getValue().equals(row.getString("category"))) {
            String materialId = row.getString("masterid");
            String createOrgId = row.getString("createorg_1_id");
            sb.setLength(0);
            sb.append(materialId).append('_').append(createOrgId);
            this.materialMap.put(sb.toString(), row.getLong("material_id"));
        } else {
            groupIdSet.add(row.getLong("materialgroup_id"));
        }
    }

    public void initMaterialGroup(Set<Long> groupIdSet) {
        if (groupIdSet.isEmpty()) {
            return;
        }
        QFilter filter1 = new QFilter("mftcontrolentry.materialcontrol", "in", groupIdSet);
        QFilter filter2 = new QFilter("status", "=", (Object)"C");
        QFilter filter3 = new QFilter("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        try (DataSet dataSet = ORM.create().queryDataSet(ALGO_KEY, "bd_materialmftinfo", "mftcontrolentry.materialcontrol,masterid", filters);){
            for (Row row : dataSet) {
                if (!StringUtils.isNotBlank((CharSequence)row.getString(1))) continue;
                List groupIds = this.materialGroupMap.computeIfAbsent(row.getString(1), (? super K k) -> new ArrayList());
                groupIds.add(row.getLong(0));
            }
        }
    }

    public Long getMaterialId(String key) {
        return this.materialMap.get(key);
    }

    public List<Long> getMaterialGroupIds(String key) {
        return this.materialGroupMap.get(key);
    }

    public WorkCenter getWorkCenter(Long key) {
        return this.id2WorkCenter.get(key);
    }

    public int size() {
        return this.id2WorkCenter.size();
    }

    public Map<Long, WorkCenter> getId2WorkCenter() {
        return this.id2WorkCenter;
    }

    public WorkShiftManager getWorkShift(Long key) {
        return this.workShiftManagerMap.get(key);
    }

    public Map<Long, WorkShiftManager> getAllWorkShift() {
        return this.workShiftManagerMap;
    }

    public void putWorkShift(Long key, WorkShiftManager workShiftManager) {
        this.workShiftManagerMap.put(key, workShiftManager);
    }
}

