/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.pls.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public final class QueryUtils {
    private static final String ALGO_KEY = "QueryUtils";
    private static final String ID = "id";

    private QueryUtils() {
        throw new UnsupportedOperationException();
    }

    public static Map<Long, Object> getId2PropertyValueForSingle(String entityName, Set<Long> ids, String singleProperty) {
        QFilter[] filters = new QFilter[]{new QFilter(ID, "in", ids)};
        try (DataSet dataSet = ORM.create().queryDataSet(ALGO_KEY + entityName, entityName, "id, " + singleProperty, filters);){
            if (dataSet.hasNext()) {
                HashMap result = Maps.newHashMapWithExpectedSize((int)ids.size());
                for (Row row : dataSet) {
                    result.put(row.getLong(0), row.get(1));
                }
                HashMap hashMap = result;
                return hashMap;
            }
            Map<Long, Object> map = Collections.emptyMap();
            return map;
        }
    }

    public static List<Object> getPropertyValuesForSingle(String entityName, Set<Long> ids, String singleProperty) {
        QFilter[] filters = new QFilter[]{new QFilter(ID, "in", ids)};
        try (DataSet dataSet = ORM.create().queryDataSet(ALGO_KEY + entityName, entityName, singleProperty, filters);){
            if (dataSet.hasNext()) {
                ArrayList values = Lists.newArrayListWithExpectedSize((int)ids.size());
                for (Row row : dataSet) {
                    values.add(row.get(0));
                }
                ArrayList arrayList = values;
                return arrayList;
            }
            List<Object> list = Collections.emptyList();
            return list;
        }
    }

    public static List<Tuple<Object, Object>> getPropertyValuesForDouble(String entityName, Set<Long> ids, String doubleProperty) {
        QFilter[] filters = new QFilter[]{new QFilter(ID, "in", ids)};
        try (DataSet dataSet = ORM.create().queryDataSet(ALGO_KEY + entityName, entityName, doubleProperty, filters);){
            if (dataSet.hasNext()) {
                ArrayList values = Lists.newArrayListWithExpectedSize((int)ids.size());
                for (Row row : dataSet) {
                    values.add(new Tuple(row.get(0), row.get(1)));
                }
                ArrayList arrayList = values;
                return arrayList;
            }
            List<Tuple<Object, Object>> list = Collections.emptyList();
            return list;
        }
    }
}

