/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.rpt.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.common.enums.MaterialAttrEnum;
import kd.mmc.mrp.rpt.entity.InvQueryRangeInfo;
import kd.mmc.mrp.rpt.entity.RptSchemeInfo;

public class CalcDocumentsPlanUtils {
    private static final String[] TRANsACTION_Type_S = new String[]{"401", "601"};
    private static final String[] FIX_FIELDS = new String[]{"supmaterial", "supplyorg", "demandmodel", "operator", "goodprodinvqty", "defprodinvqty", "nonstandardqty"};
    private static final DataType[] FIX_TYPES = new DataType[]{DataType.LongType, DataType.LongType, DataType.StringType, DataType.LongType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType};
    protected static final String[] invFields = new String[]{"id", "material", "qty"};
    protected static final DataType[] invFieldsType = new DataType[]{DataType.LongType, DataType.LongType, DataType.BigDecimalType};
    protected static final String[] materialPlanFields = new String[]{"masterid", "createorg", "operator", "demandmodel"};
    protected static final DataType[] materialPlanTypes = new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType, DataType.StringType};

    public static DataSet createNewDataSet(String algoKey, Map<String, Object> params, DataSet dataSet) {
        List trendsFields = (List)params.get("trendsFields");
        List trendsTypes = (List)params.get("trendsTypes");
        Map keyToStartTime = (Map)params.get("keyToStartTime");
        Map keyToEndTime = (Map)params.get("keyToEndTime");
        Date endDate = (Date)params.get("endDate");
        String[] rptFields = (String[])ArrayUtils.addAll((Object[])FIX_FIELDS, (Object[])trendsFields.toArray(new String[trendsFields.size()]));
        DataType[] rptFieldTypes = (DataType[])ArrayUtils.addAll((Object[])FIX_TYPES, (Object[])trendsTypes.toArray(new DataType[trendsTypes.size()]));
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])rptFields, (DataType[])rptFieldTypes);
        Algo algo = Algo.create((String)algoKey);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        while (dataSet.hasNext()) {
            BigDecimal adjustqty;
            Row row = dataSet.next();
            long supmaterial = row.getLong("supmaterial") == null ? 0L : row.getLong("supmaterial");
            long supplyorg = row.getLong("supplyorg") == null ? 0L : row.getLong("supplyorg");
            long operator = row.getLong("operator") == null ? 0L : row.getLong("operator");
            String demandmodel = row.getString("demandmodel") == null ? "" : row.getString("demandmodel");
            BigDecimal goodprodinvqty = row.getBigDecimal("goodprodinvqty") == null ? BigDecimal.ZERO : row.getBigDecimal("goodprodinvqty");
            BigDecimal defprodinvqty = row.getBigDecimal("defprodinvqty") == null ? BigDecimal.ZERO : row.getBigDecimal("defprodinvqty");
            BigDecimal nonstandardqty = row.getBigDecimal("nonstandardqty") == null ? BigDecimal.ZERO : row.getBigDecimal("nonstandardqty");
            Date demanddate = row.getDate("demanddate");
            Date adjustdate = row.getDate("adjustdate");
            BigDecimal supplyqty = row.getBigDecimal("supplyqty") == null ? BigDecimal.ZERO : row.getBigDecimal("supplyqty");
            BigDecimal bigDecimal = adjustqty = row.getBigDecimal("adjustqty") == null ? BigDecimal.ZERO : row.getBigDecimal("adjustqty");
            if (adjustdate != null) {
                demanddate = adjustdate;
            }
            if (BigDecimal.ZERO.compareTo(adjustqty) != 0) {
                supplyqty = adjustqty;
            }
            Object[] values = new Object[rptFields.length];
            values[0] = supmaterial;
            values[1] = supplyorg;
            values[2] = demandmodel;
            values[3] = operator;
            values[4] = goodprodinvqty;
            values[5] = defprodinvqty;
            values[6] = nonstandardqty;
            for (int i = FIX_FIELDS.length; i < values.length; ++i) {
                String fieldKey = rptFields[i];
                Date startTime = (Date)keyToStartTime.get(fieldKey);
                Date endTime = (Date)keyToEndTime.get(fieldKey);
                if (demanddate.compareTo(endDate) >= 0) continue;
                if (i == FIX_FIELDS.length) {
                    if (demanddate.compareTo(endTime) < 0) {
                        values[i] = supplyqty;
                        continue;
                    }
                    values[i] = BigDecimal.ZERO;
                    continue;
                }
                values[i] = demanddate.compareTo(startTime) >= 0 && demanddate.compareTo(endTime) < 0 ? supplyqty : BigDecimal.ZERO;
            }
            dataSetBuilder.append(values);
        }
        dataSet = dataSetBuilder.build();
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(FIX_FIELDS);
        for (String trendsField : trendsFields) {
            groupbyDataSet = groupbyDataSet.sum(trendsField);
        }
        dataSet = groupbyDataSet.finish();
        return dataSet;
    }

    public static DataSet relateDataSet(DataSet calDetailDataSet, DataSet materialPlanDataSet, DataSet materialInvDataSet, DataSet materialGoodDataSet, DataSet materialNoStandardDataSet) {
        Object[] fieldsArray = calDetailDataSet.getRowMeta().getFieldNames();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"demandmodel"});
        DataSet dataSet = calDetailDataSet.leftJoin(materialPlanDataSet).on("supmaterial", "masterid").on("supplyorg", "createorg").select((String[])fieldsArray).finish();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"defprodinvqty"});
        dataSet = dataSet.leftJoin(materialInvDataSet).on("supmaterial", "material").select((String[])fieldsArray).finish();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"goodprodinvqty"});
        dataSet = dataSet.leftJoin(materialGoodDataSet).on("supmaterial", "material").select((String[])fieldsArray).finish();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"nonstandardqty"});
        dataSet = dataSet.leftJoin(materialNoStandardDataSet).on("supmaterial", "masterid").select((String[])fieldsArray).finish();
        return dataSet;
    }

    public static DataSet queryMaterialInvQty(String algoKey, Set<Long> materialIds, Set<Long> storageOrgs, Set<Long> warehouses, Set<Long> locations, RptSchemeInfo rptSchemeInfo) {
        algoKey = algoKey + "_queryMaterialInvQty";
        Map<String, InvQueryRangeInfo> rptSchemeEffect = CalcDocumentsPlanUtils.getRptSchemeEffect(rptSchemeInfo);
        HashSet openLocationWarehouse = new HashSet();
        InvQueryRangeInfo invQueryRangeInfo = rptSchemeEffect.get("defprodinvqty");
        if (invQueryRangeInfo != null) {
            warehouses.clear();
            locations.clear();
            warehouses.addAll(invQueryRangeInfo.getWarehouse());
            locations.addAll(invQueryRangeInfo.getLocation());
        }
        QFilter[] locationFilters = new QFilter[]{new QFilter("id", "in", warehouses), new QFilter("entryentity.location", "in", locations), new QFilter("isopenlocation", "=", (Object)Boolean.TRUE)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_warehouse", (String)"id,entryentity.location", (QFilter[])locationFilters, null);){
            dataSet.forEach(row -> openLocationWarehouse.add(row.getLong("id")));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "in", storageOrgs));
        qFilters.add(new QFilter("warehouse", "in", warehouses));
        qFilters.add(new QFilter("material", "in", materialIds));
        String selectStr = "id,material,warehouse,location,qty";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_inv_realbalance", (String)selectStr, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])invFields, (DataType[])invFieldsType);
        Algo algo = Algo.create((String)algoKey);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        while (dataSet.hasNext()) {
            Row row2 = dataSet.next();
            long id = row2.getLong("id");
            long material = row2.getLong("material");
            long warehouse = row2.getLong("warehouse");
            long location = row2.getLong("location");
            BigDecimal qty = row2.getBigDecimal("qty");
            if (openLocationWarehouse.contains(warehouse) && !locations.contains(location)) continue;
            Object[] values = new Object[]{id, material, qty};
            dataSetBuilder.append(values);
        }
        dataSet = dataSetBuilder.build();
        dataSet = dataSet.groupBy(new String[]{"material"}).sum("qty", "defprodinvqty").finish();
        return dataSet;
    }

    public static DataSet queryMaterialGoodInvQty(String algoKey, Set<Long> materialIds, Set<Long> storageOrgs, Set<Long> warehouses, Set<Long> locations, RptSchemeInfo rptSchemeInfo) {
        algoKey = algoKey + "_queryMaterialInvQty";
        Map<String, InvQueryRangeInfo> rptSchemeEffect = CalcDocumentsPlanUtils.getRptSchemeEffect(rptSchemeInfo);
        HashSet openLocationWarehouse = new HashSet();
        InvQueryRangeInfo invQueryRangeInfo = rptSchemeEffect.get("defprodinvqty");
        if (invQueryRangeInfo != null) {
            warehouses.clear();
            locations.clear();
            warehouses.addAll(invQueryRangeInfo.getWarehouse());
            locations.addAll(invQueryRangeInfo.getLocation());
        }
        QFilter[] locationFilters = new QFilter[]{new QFilter("id", "in", warehouses), new QFilter("entryentity.location", "in", locations), new QFilter("isopenlocation", "=", (Object)Boolean.TRUE)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_warehouse", (String)"id,entryentity.location", (QFilter[])locationFilters, null);){
            dataSet.forEach(row -> openLocationWarehouse.add(row.getLong("id")));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "in", storageOrgs));
        qFilters.add(new QFilter("warehouse", "in", warehouses));
        qFilters.add(new QFilter("material", "in", materialIds));
        String selectStr = "id,material,warehouse,location,qty";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_inv_realbalance", (String)selectStr, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])invFields, (DataType[])invFieldsType);
        Algo algo = Algo.create((String)algoKey);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        while (dataSet.hasNext()) {
            Row row2 = dataSet.next();
            long id = row2.getLong("id");
            long material = row2.getLong("material");
            long warehouse = row2.getLong("warehouse");
            long location = row2.getLong("location");
            BigDecimal qty = row2.getBigDecimal("qty");
            if (openLocationWarehouse.contains(warehouse) && !locations.contains(location)) continue;
            Object[] values = new Object[]{id, material, qty};
            dataSetBuilder.append(values);
        }
        dataSet = dataSetBuilder.build();
        dataSet = dataSet.groupBy(new String[]{"material"}).sum("qty", "goodprodinvqty").finish();
        return dataSet;
    }

    public static DataSet queryMaterialNoStandardQty(String algoKey, long versionId, Set<Long> materialSet) {
        algoKey = algoKey + "_queryNoStandardQty";
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"masterid", "nonstandardqty"}, (DataType[])new DataType[]{DataType.LongType, DataType.BigDecimalType});
        DataSetBuilder dataSetBuilder = Algo.create((String)algoKey).createDataSetBuilder(rowMeta);
        return dataSetBuilder.build();
    }

    public static DataSet queryMaterialPlanInfo(String algoKey, Set<Long> materialIds, Set<Long> supplyorgIds) {
        Object demandModel;
        Row row2;
        HashMap groupToStrategy = new HashMap(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mpdm_manustrategy_group", (String)"id,createorg,entryentity.strategynumber,entryentity.strategynumber.demandmodel", (QFilter[])new QFilter[]{new QFilter("createorg", "in", supplyorgIds)}, (String)"id,entryentity.priority");){
            dataSet.forEach(row -> groupToStrategy.put(row.getLong("id"), row.getString("entryentity.strategynumber.demandmodel")));
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])materialPlanFields, (DataType[])materialPlanTypes);
        Algo algo = Algo.create((String)algoKey);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        DynamicObject strategyObj = QueryServiceHelper.queryOne((String)"mpdm_manustrategy", (String)"id,demandmodel", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"MTS10")});
        if (strategyObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3aMTS10\u7684\u8ba1\u5212\u6a21\u5f0f\u3002", (String)"CalcDocumentsPlanUtils_0", (String)"mmc-mrp-common", (Object[])new Object[0]));
        }
        String defaultDemandModel = strategyObj.getString("demandmodel");
        LinkedHashSet<String> materialAndOrgKey = new LinkedHashSet<String>(8);
        HashMap shareMaterialDatas = new HashMap(8);
        String selectStr = "id,masterid,createorg,manufacturegroup,ctrlstrategy,planmode,operator";
        DynamicObject config = QueryServiceHelper.queryOne((String)"mrp_runconfig", (String)"id,param", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"MATERIAL_PLAN_INFO_SETTINGS")});
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        qFilterList.add(new QFilter("masterid", "in", materialIds));
        if (config == null || !StringUtils.equals((CharSequence)"IGNORE", (CharSequence)config.getString("param"))) {
            qFilterList.add(new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1")));
        }
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        HashMap<String, Object> materialDemandModelMap = new HashMap<String, Object>();
        HashSet<Long> invMaterialIds = new HashSet<Long>(8);
        HashSet<String> invMaterialAndOrg = new HashSet<String>(8);
        try (Object dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mpdm_materialplan", (String)selectStr, (QFilter[])qFilters, (String)"id DESC");){
            while (dataSet.hasNext()) {
                String planmode;
                HashMap<String, Object> datas;
                row2 = dataSet.next();
                demandModel = (String)groupToStrategy.get(row2.getLong("manufacturegroup"));
                if (StringUtils.isEmpty((CharSequence)demandModel)) {
                    demandModel = defaultDemandModel;
                }
                long materialId = row2.getLong("masterid");
                long createorg = row2.getLong("createorg");
                long operator = row2.getLong("operator");
                String ctrlstrategy = row2.getString("ctrlstrategy");
                if (StringUtils.equals((CharSequence)"5", (CharSequence)ctrlstrategy) && (datas = (HashMap<String, Object>)shareMaterialDatas.get(materialId)) == null) {
                    datas = new HashMap<String, Object>(2);
                    datas.put("operator", operator);
                    datas.put("demandmodel", demandModel);
                    shareMaterialDatas.put(materialId, datas);
                }
                if (StringUtils.equals((CharSequence)"C", (CharSequence)(planmode = row2.getString("planmode"))) || StringUtils.equals((CharSequence)"D", (CharSequence)planmode)) {
                    invMaterialIds.add(materialId);
                    invMaterialAndOrg.add(materialId + "_" + createorg);
                }
                materialAndOrgKey.add(materialId + "_" + createorg);
                materialDemandModelMap.put(materialId + "_" + createorg, demandModel);
            }
        }
        dataSet = materialIds.iterator();
        while (dataSet.hasNext()) {
            long materialId = (Long)dataSet.next();
            demandModel = supplyorgIds.iterator();
            while (demandModel.hasNext()) {
                Map datas;
                long orgId = (Long)demandModel.next();
                String key2 = materialId + "_" + orgId;
                if (materialAndOrgKey.contains(key2) || (datas = (Map)shareMaterialDatas.get(materialId)) == null) continue;
                materialDemandModelMap.put(key2, (String)datas.get("demandmodel"));
            }
        }
        selectStr = "id,masterid,createorg,manustrategy.demandmodel AS demandmodel,ctrlstrategy";
        qFilterList.clear();
        qFilterList.add(new QFilter("masterid", "in", invMaterialIds));
        qFilterList.add(new QFilter("status", "=", (Object)"C"));
        qFilterList.add(new QFilter("enable", "=", (Object)"1"));
        qFilters = qFilterList.toArray(new QFilter[0]);
        dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_materialinventoryinfo", (String)selectStr, (QFilter[])qFilters, (String)"id DESC");
        Throwable throwable = null;
        try {
            while (dataSet.hasNext()) {
                row2 = dataSet.next();
                long materialId = row2.getLong("masterid");
                long createorgId = row2.getLong("createorg");
                String demandModel2 = row2.getString("demandmodel");
                String key3 = materialId + "_" + createorgId;
                if (!invMaterialAndOrg.contains(key3) || !StringUtils.isNotBlank((CharSequence)demandModel2)) continue;
                materialDemandModelMap.put(key3, demandModel2);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (dataSet != null) {
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        materialDemandModelMap.forEach((key, value) -> {
            Object[] row = new Object[4];
            String[] split = key.split("_");
            row[0] = split[0];
            row[1] = split[1];
            row[2] = 0L;
            row[3] = value;
            dataSetBuilder.append(row);
        });
        return dataSetBuilder.build();
    }

    public static DataSet dealDatasWithResource(DataSet querySet) {
        DataSet demandBillTypeQuerySet = querySet.copy().filter("reqsourcebillno  = null or reqsourcebillno = '' ");
        DataSet filterSet = demandBillTypeQuerySet.copy().groupBy(new String[]{"billid", "billentryid"}).min("cast(llc as Integer)", "llc").finish();
        filterSet = filterSet.addField("cast(llc as String)", "llcStr");
        demandBillTypeQuerySet = demandBillTypeQuerySet.join(filterSet).on("billid", "billid").on("billentryid", "billentryid").on("llc", "llcStr").select(demandBillTypeQuerySet.getRowMeta().getFieldNames()).finish();
        DataSet reqsourceQuerySet = querySet.filter("reqsourcebillno  !=null and reqsourcebillno !=''");
        DataSet reqSourceFilterSet = reqsourceQuerySet.copy().groupBy(new String[]{"reqsourcebillno"}).min("cast(llc as Integer)", "llc").finish();
        reqSourceFilterSet = reqSourceFilterSet.addField("cast(llc as String)", "llcStr");
        reqsourceQuerySet = reqsourceQuerySet.join(reqSourceFilterSet).on("reqsourcebillno", "reqsourcebillno").on("llc", "llcStr").select(reqsourceQuerySet.getRowMeta().getFieldNames()).finish();
        querySet = demandBillTypeQuerySet.union(reqsourceQuerySet);
        querySet = querySet.filter(ResManager.loadKDString((String)"materialattr <> '10040' and adjustsuggest <>'\u5efa\u8bae\u53d6\u6d88' and supplybillf7<>'im_inv_realbalance'", (String)"CalcDocumentsPlanUtils_1", (String)"mmc-mrp-common", (Object[])new Object[0]));
        return querySet;
    }

    public static DataSet queryMrpCalcDetail(String algoKey, String planNo, RptSchemeInfo rptSchemeInfo) {
        algoKey = algoKey + "_queryMrpCalcDetail";
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        qFilterList.add(new QFilter("caculatelog", "=", (Object)planNo));
        qFilterList.add(new QFilter("entryentity.materialattr", "!=", (Object)MaterialAttrEnum.PURCHASEDPART.getValue()));
        qFilterList.add(new QFilter("entryentity.demandqty", "!=", (Object)BigDecimal.ZERO));
        qFilterList.add(new QFilter("entryentity.supplyqty", "!=", (Object)BigDecimal.ZERO));
        List<Long> source = rptSchemeInfo.getSource();
        DynamicObjectCollection dataConfigs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", source)});
        if (dataConfigs != null && dataConfigs.size() != 0) {
            ArrayList billType = new ArrayList(8);
            dataConfigs.forEach(dataConfig -> billType.add(dataConfig.getString("name")));
            qFilterList.add(new QFilter("entryentity.demandbilltype", "in", billType));
        }
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        String selectStr = "caculatelog,entryentity.id as id,entryentity.demandbilltype as demandbilltype,entryentity.billno as billno,entryentity.llc as llc,entryentity.materialattr as materialattr,entryentity.adjustsuggest as adjustsuggest,entryentity.supplybillf7.number as supplybillf7,entryentity.supmaterial as supmaterial,entryentity.supmaterial.number as materialNumber,entryentity.supplyorg.number as supplyOrgNumber,entryentity.supplyoperator as  operator,entryentity.supplyorg as supplyorg,entryentity.supplydate as supplydate,entryentity.demanddate as demanddate,entryentity.demandqty as demandqty,entryentity.supplyqty as supplyqty,entryentity.adjustqty as adjustqty,entryentity.adjustdate as adjustdate,entryentity.billid as billid,entryentity.billentryid as billentryid,entryentity.billentryseq as billentryseq,entryentity.reqsourcebillno as reqsourcebillno";
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"mrp_calcdetail", (String)selectStr, (QFilter[])qFilters, null);
    }

    public static void createDocumentsDatas(DataSet dataSet, String planNo, Map<String, Object> params) {
        List trendsFields = (List)params.get("trendsFields");
        Map keyToCaption = (Map)params.get("keyToCaption");
        Map keyToSequence = (Map)params.get("keyToSequence");
        ORM orm = ORM.create();
        long id = orm.genLongId("mrp_rpt_decuments_datas");
        DynamicObject head = orm.newDynamicObject("mrp_rpt_decuments_datas");
        head.set("id", (Object)id);
        head.set("billno", (Object)planNo);
        head.set("billstatus", (Object)"A");
        head.set("planid", (Object)planNo);
        head.set("creator", (Object)RequestContext.get().getCurrUserId());
        head.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{head});
        ArrayList<Object> entryValues = new ArrayList<Object>(8);
        ArrayList<Object[]> subEntryValues = new ArrayList<Object[]>(8);
        int idSize = 1;
        for (Row ignored : dataSet.copy()) {
            ++idSize;
        }
        long[] newEntryIds = ID.genLongIds((int)idSize);
        String entrySql = "insert into t_mrp_decuments_datafix (fid, fentryid, fseq, fmaterial, fsupplyorg, fdemandmodel, foperator, freleasestatus, fiscommitment, fgoodprodinvqty, fdefprodinvqty, fnonstandardqty ) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String subEntrySql = "insert into t_mrp_decuments_datasub (fentryid, fdetailid, fseq, ffieldkey, ffieldcaption, ffieldvalue, fsequence ) values (?, ?, ?, ?, ?, ?, ?)";
        int seq = 0;
        if (dataSet.isEmpty()) {
            Object[] entry = new Object[]{id, newEntryIds[seq], seq + 1, 0, 0, " ", 0, "A", "A", 0, 0, 0};
            entryValues.add(entry);
            int subSeq = 0;
            long[] subIds = ID.genLongIds((int)trendsFields.size());
            for (String trendsField : trendsFields) {
                Object[] subEntry = new Object[]{newEntryIds[seq], subIds[subSeq], subSeq + 1, trendsField, keyToCaption.getOrDefault(trendsField, ""), BigDecimal.ZERO, keyToSequence.getOrDefault(trendsField, "")};
                subEntryValues.add(subEntry);
                ++subSeq;
            }
        }
        for (Row row : dataSet) {
            Object[] entry = new Object[]{id, newEntryIds[seq], seq + 1, row.get("supmaterial"), row.get("supplyorg"), row.get("demandmodel"), row.get("operator"), "A", "A", row.get("goodprodinvqty"), row.get("defprodinvqty"), row.get("nonstandardqty")};
            entryValues.add(entry);
            int subSeq = 0;
            long[] subIds = ID.genLongIds((int)trendsFields.size());
            for (String trendsField : trendsFields) {
                Object[] subEntry = new Object[]{newEntryIds[seq], subIds[subSeq], subSeq + 1, trendsField, keyToCaption.getOrDefault(trendsField, ""), row.get(trendsField) == null ? BigDecimal.ZERO : row.get(trendsField), keyToSequence.getOrDefault(trendsField, "")};
                subEntryValues.add(subEntry);
                ++subSeq;
            }
            ++seq;
        }
        DBRoute dbRoute = DBRoute.of((String)"scm");
        if (entryValues.size() > 0) {
            DB.executeBatch((DBRoute)dbRoute, (String)entrySql, entryValues);
        }
        if (subEntryValues.size() > 0) {
            DB.executeBatch((DBRoute)dbRoute, (String)subEntrySql, subEntryValues);
        }
    }

    public static Map<String, InvQueryRangeInfo> getRptSchemeEffect(RptSchemeInfo rptSchemeInfo) {
        HashMap<String, InvQueryRangeInfo> effectFields = new HashMap<String, InvQueryRangeInfo>();
        List<InvQueryRangeInfo> invQueryRange = rptSchemeInfo.getInvQueryRange();
        for (InvQueryRangeInfo invQueryRangeInfo : invQueryRange) {
            String rptField = invQueryRangeInfo.getRptField();
            if (!StringUtils.equals((CharSequence)"goodprodinvqty", (CharSequence)rptField) && !StringUtils.equals((CharSequence)"defprodinvqty", (CharSequence)rptField)) continue;
            effectFields.put(rptField, invQueryRangeInfo);
        }
        return effectFields;
    }
}

