/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.rpt.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.common.enums.MaterialAttrEnum;
import kd.mmc.mrp.common.util.SnapshotDataUtils;
import kd.mmc.mrp.rpt.entity.InvQueryRangeInfo;
import kd.mmc.mrp.rpt.entity.RptSchemeInfo;

public class CalcProductionForecastUtils {
    public static final Log logger = LogFactory.getLog(CalcProductionForecastUtils.class);
    protected static final String[] materialPlanFields = new String[]{"masterid", "createorg", "operator", "demandmodel"};
    protected static final DataType[] materialPlanTypes = new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType, DataType.StringType};
    protected static final String[] invFields = new String[]{"id", "material", "qty"};
    protected static final DataType[] invFieldsType = new DataType[]{DataType.LongType, DataType.LongType, DataType.BigDecimalType};
    protected static final String[] fixFields = new String[]{"offeringid", "offeringno", "offeringname", "supplyorg", "demandmodel", "operator", "qty", "isdemandmaterial"};
    protected static final DataType[] fixTypes = new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.LongType, DataType.BigDecimalType, DataType.BooleanType};

    public static void createForecastDatas(DataSet dataSet, String planNo, Map<String, Object> params) {
        List trendsFields = (List)params.get("trendsFields");
        Map keyToCaption = (Map)params.get("keyToCaption");
        Map keyToSequence = (Map)params.get("keyToSequence");
        ORM orm = ORM.create();
        long id = orm.genLongId("mrp_rpt_production_datas");
        DynamicObject head = orm.newDynamicObject("mrp_rpt_production_datas");
        head.set("id", (Object)id);
        head.set("billno", (Object)planNo);
        head.set("billstatus", (Object)"A");
        head.set("planid", (Object)planNo);
        head.set("creator", (Object)RequestContext.get().getCurrUserId());
        head.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{head});
        ArrayList<Object> entryValues = new ArrayList<Object>(8);
        ArrayList<Object[]> subEntryValues = new ArrayList<Object[]>(8);
        int idSize = 1;
        for (Row ignored : dataSet.copy()) {
            ++idSize;
        }
        long[] newEntryIds = ID.genLongIds((int)idSize);
        String entrySql = "insert into t_mrp_production_datafix (fid, fentryid, fseq, fofferingno, fofferingname, fofferingid, fsupplyorg, fdemandmodel, foperator, facqstatus, fqty, fisdemandmaterial ) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String subEntrySql = "insert into t_mrp_production_datasub (fentryid, fdetailid, fseq, ffieldkey, ffieldcaption, ffieldvalue, fsequence ) values (?, ?, ?, ?, ?, ?, ?)";
        int seq = 0;
        if (dataSet.isEmpty()) {
            Object[] entry = new Object[]{id, newEntryIds[seq], seq + 1, " ", " ", 0, 0, " ", 0, "A", 0, "0"};
            entryValues.add(entry);
            int subSeq = 0;
            long[] subIds = ID.genLongIds((int)trendsFields.size());
            for (String trendsField : trendsFields) {
                Object[] subEntry = new Object[]{newEntryIds[seq], subIds[subSeq], subSeq + 1, trendsField, keyToCaption.getOrDefault(trendsField, ""), BigDecimal.ZERO, keyToSequence.getOrDefault(trendsField, "")};
                subEntryValues.add(subEntry);
                ++subSeq;
            }
        }
        for (Row row : dataSet) {
            Object[] entry = new Object[]{id, newEntryIds[seq], seq + 1, row.get("offeringno") == null ? " " : row.get("offeringno"), row.get("offeringname") == null ? " " : row.get("offeringname"), row.get("offeringid"), row.get("supplyorg"), row.get("demandmodel"), row.get("operator"), "A", row.get("qty"), row.get("isdemandmaterial")};
            entryValues.add(entry);
            int subSeq = 0;
            long[] subIds = ID.genLongIds((int)trendsFields.size());
            for (String trendsField : trendsFields) {
                Object[] subEntry = new Object[]{newEntryIds[seq], subIds[subSeq], subSeq + 1, trendsField, keyToCaption.getOrDefault(trendsField, ""), row.get(trendsField) == null ? BigDecimal.ZERO : row.get(trendsField), keyToSequence.getOrDefault(trendsField, "")};
                subEntryValues.add(subEntry);
                ++subSeq;
            }
            ++seq;
        }
        DBRoute dbRoute = DBRoute.of((String)"scm");
        if (entryValues.size() > 0) {
            DB.executeBatch((DBRoute)dbRoute, (String)entrySql, entryValues);
        }
        if (subEntryValues.size() > 0) {
            DB.executeBatch((DBRoute)dbRoute, (String)subEntrySql, subEntryValues);
        }
    }

    public static DataSet queryMrpCalcDetail(String algoKey, String planNo, RptSchemeInfo rptSchemeInfo) {
        algoKey = algoKey + "_queryMrpCalcDetail";
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        qFilterList.add(new QFilter("caculatelog", "=", (Object)planNo));
        qFilterList.add(new QFilter("entryentity.materialattr", "=", (Object)MaterialAttrEnum.FABRICATEDPART.getValue()));
        qFilterList.add(new QFilter("entryentity.adjustsuggest", "!=", (Object)ResManager.loadKDString((String)"\u5efa\u8bae\u53d6\u6d88", (String)"CalcProductionForecastUtils_0", (String)"mmc-mrp-common", (Object[])new Object[0])));
        qFilterList.add(new QFilter("entryentity.supplybillf7", "not like", (Object)"%inv%"));
        qFilterList.add(new QFilter("entryentity.demandqty", "!=", (Object)BigDecimal.ZERO));
        qFilterList.add(new QFilter("entryentity.supplyqty", "!=", (Object)BigDecimal.ZERO));
        List<Long> source = rptSchemeInfo.getSource();
        DynamicObjectCollection dataConfigs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", source)});
        if (dataConfigs != null && dataConfigs.size() != 0) {
            ArrayList billType = new ArrayList(8);
            dataConfigs.forEach(dataConfig -> billType.add(dataConfig.getString("name")));
            qFilterList.add(new QFilter("entryentity.demandbilltype", "in", billType));
        }
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        String selectStr = "id,mrpplan,entryentity.material,entryentity.supplyorg,entryentity.demanddate,entryentity.demandqty,entryentity.adjustdate,entryentity.requireoperator,entryentity.billentryseq,entryentity.demandbilltype,entryentity.billno,entryentity.llc,entryentity.reqsourcebillno,entryentity.adjustqty";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mrp_calcdetail", (String)selectStr, (QFilter[])qFilters, null);
        DataSet noResourceDataSet = dataSet.copy().filter("entryentity.reqsourcebillno ==null or entryentity.reqsourcebillno ==''");
        DataSet filterMinSet = noResourceDataSet.groupBy(new String[]{"entryentity.billentryseq", "entryentity.demandbilltype", "entryentity.billno"}).min("cast(entryentity.llc as Integer)", "llc").finish();
        filterMinSet = filterMinSet.addField("'1'", "isdemandmaterial");
        filterMinSet = filterMinSet.addField("cast(llc as String)", "llcStr");
        noResourceDataSet = noResourceDataSet.leftJoin(filterMinSet).on("entryentity.billentryseq", "entryentity.billentryseq").on("entryentity.demandbilltype", "entryentity.demandbilltype").on("entryentity.billno", "entryentity.billno").on("entryentity.llc", "llcStr").select(noResourceDataSet.getRowMeta().getFieldNames(), new String[]{" isdemandmaterial"}).finish();
        String[] fieldNames = noResourceDataSet.getRowMeta().getFieldNames();
        StringBuilder select = new StringBuilder();
        for (String fieldName : fieldNames) {
            if ("isdemandmaterial".equals(fieldName)) continue;
            select.append(fieldName).append(',');
        }
        select.append(" case when isdemandmaterial !=null then isdemandmaterial else  '0' end as isdemandmaterial");
        noResourceDataSet = noResourceDataSet.select(select.toString());
        DataSet resourceDataSet = dataSet.copy().filter("entryentity.reqsourcebillno != null and entryentity.reqsourcebillno != ''");
        DataSet reqSourceFilterSet = resourceDataSet.groupBy(new String[]{"entryentity.reqsourcebillno"}).min("cast(entryentity.llc as Integer)", "llc").finish();
        reqSourceFilterSet = reqSourceFilterSet.addField("'1'", "isdemandmaterial");
        reqSourceFilterSet = reqSourceFilterSet.addField("cast(llc as String)", "llcStr");
        resourceDataSet = resourceDataSet.leftJoin(reqSourceFilterSet).on("entryentity.reqsourcebillno", "entryentity.reqsourcebillno").on("entryentity.llc", "llcStr").select(resourceDataSet.getRowMeta().getFieldNames(), new String[]{" isdemandmaterial"}).finish();
        fieldNames = resourceDataSet.getRowMeta().getFieldNames();
        select = new StringBuilder();
        for (String fieldName : fieldNames) {
            if ("isdemandmaterial".equals(fieldName)) continue;
            select.append(fieldName).append(',');
        }
        select.append(" case when isdemandmaterial !=null then isdemandmaterial else  '0' end as isdemandmaterial");
        resourceDataSet = resourceDataSet.select(select.toString());
        dataSet = noResourceDataSet.union(resourceDataSet);
        return dataSet;
    }

    public static DataSet queryMaterialBaseInfo(String algoKey, Long versionId, Set<Long> materialIds) {
        algoKey = algoKey + "_queryMaterialBaseInfo";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", materialIds)};
        String selectStr = "id,number materialnumber,name materialname";
        return SnapshotDataUtils.queryDataSet(algoKey, versionId, "bd_material", selectStr, qFilters);
    }

    public static DataSet queryMaterialPlanInfo(String algoKey, Set<Long> materialIds, Set<Long> supplyorgIds) {
        Object demandModel;
        Row row2;
        HashMap groupToStrategy = new HashMap(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mpdm_manustrategy_group", (String)"id,createorg,entryentity.strategynumber,entryentity.strategynumber.demandmodel", (QFilter[])new QFilter[]{new QFilter("createorg", "in", supplyorgIds)}, (String)"id,entryentity.priority");){
            dataSet.forEach(row -> groupToStrategy.put(row.getLong("id"), row.getString("entryentity.strategynumber.demandmodel")));
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])materialPlanFields, (DataType[])materialPlanTypes);
        Algo algo = Algo.create((String)algoKey);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        DynamicObject strategyObj = QueryServiceHelper.queryOne((String)"mpdm_manustrategy", (String)"id,demandmodel", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"MTS10")});
        if (strategyObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3aMTS10\u7684\u8ba1\u5212\u6a21\u5f0f\u3002", (String)"CalcProductionForecastUtils_1", (String)"mmc-mrp-common", (Object[])new Object[0]));
        }
        String defaultDemandModel = strategyObj.getString("demandmodel");
        LinkedHashSet<String> materialAndOrgKey = new LinkedHashSet<String>(8);
        HashMap shareMaterialDatas = new HashMap(8);
        String selectStr = "id,masterid,createorg,manufacturegroup,ctrlstrategy,planmode,operator";
        DynamicObject config = QueryServiceHelper.queryOne((String)"mrp_runconfig", (String)"id,param", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"MATERIAL_PLAN_INFO_SETTINGS")});
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        qFilterList.add(new QFilter("masterid", "in", materialIds));
        if (config == null || !StringUtils.equals((CharSequence)"IGNORE", (CharSequence)config.getString("param"))) {
            qFilterList.add(new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1")));
        }
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        HashMap<String, Object> materialDemandModelMap = new HashMap<String, Object>();
        HashSet<Long> invMaterialIds = new HashSet<Long>(8);
        HashSet<String> invMaterialAndOrg = new HashSet<String>(8);
        try (Object dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mpdm_materialplan", (String)selectStr, (QFilter[])qFilters, (String)"id DESC");){
            while (dataSet.hasNext()) {
                String planmode;
                HashMap<String, Object> datas;
                row2 = dataSet.next();
                demandModel = (String)groupToStrategy.get(row2.getLong("manufacturegroup"));
                if (StringUtils.isEmpty((CharSequence)demandModel)) {
                    demandModel = defaultDemandModel;
                }
                long materialId = row2.getLong("masterid");
                long createorg = row2.getLong("createorg");
                long operator = row2.getLong("operator");
                String ctrlstrategy = row2.getString("ctrlstrategy");
                if (StringUtils.equals((CharSequence)"5", (CharSequence)ctrlstrategy) && (datas = (HashMap<String, Object>)shareMaterialDatas.get(materialId)) == null) {
                    datas = new HashMap<String, Object>(2);
                    datas.put("operator", operator);
                    datas.put("demandmodel", demandModel);
                    shareMaterialDatas.put(materialId, datas);
                }
                if (StringUtils.equals((CharSequence)"C", (CharSequence)(planmode = row2.getString("planmode"))) || StringUtils.equals((CharSequence)"D", (CharSequence)planmode)) {
                    invMaterialIds.add(materialId);
                    invMaterialAndOrg.add(materialId + "_" + createorg);
                }
                materialAndOrgKey.add(materialId + "_" + createorg);
                materialDemandModelMap.put(materialId + "_" + createorg, demandModel);
            }
        }
        dataSet = materialIds.iterator();
        while (dataSet.hasNext()) {
            long materialId = (Long)dataSet.next();
            demandModel = supplyorgIds.iterator();
            while (demandModel.hasNext()) {
                Map datas;
                long orgId = (Long)demandModel.next();
                String key2 = materialId + "_" + orgId;
                if (materialAndOrgKey.contains(key2) || (datas = (Map)shareMaterialDatas.get(materialId)) == null) continue;
                materialDemandModelMap.put(key2, (String)datas.get("demandmodel"));
            }
        }
        selectStr = "id,masterid,createorg,manustrategy.demandmodel AS demandmodel,ctrlstrategy";
        qFilterList.clear();
        qFilterList.add(new QFilter("masterid", "in", invMaterialIds));
        qFilterList.add(new QFilter("status", "=", (Object)"C"));
        qFilterList.add(new QFilter("enable", "=", (Object)"1"));
        qFilters = qFilterList.toArray(new QFilter[0]);
        dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_materialinventoryinfo", (String)selectStr, (QFilter[])qFilters, (String)"id DESC");
        Throwable throwable = null;
        try {
            while (dataSet.hasNext()) {
                row2 = dataSet.next();
                long materialId = row2.getLong("masterid");
                long createorgId = row2.getLong("createorg");
                String demandModel2 = row2.getString("demandmodel");
                String key3 = materialId + "_" + createorgId;
                if (!invMaterialAndOrg.contains(key3) || !StringUtils.isNotBlank((CharSequence)demandModel2)) continue;
                materialDemandModelMap.put(key3, demandModel2);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (dataSet != null) {
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        materialDemandModelMap.forEach((key, value) -> {
            Object[] row = new Object[4];
            String[] split = key.split("_");
            row[0] = split[0];
            row[1] = split[1];
            row[2] = 0L;
            row[3] = value;
            dataSetBuilder.append(row);
        });
        return dataSetBuilder.build();
    }

    public static DataSet createNewDataSet(String algoKey, Map<String, Object> params, DataSet dataSet, List<Long> source) {
        List trendsFields = (List)params.get("trendsFields");
        List trendsTypes = (List)params.get("trendsTypes");
        Map keyToStartTime = (Map)params.get("keyToStartTime");
        Map keyToEndTime = (Map)params.get("keyToEndTime");
        Date endDate = (Date)params.get("endDate");
        ArrayList billType = new ArrayList(8);
        if (source != null && !source.isEmpty()) {
            DynamicObjectCollection dataConfigs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", source)});
            dataConfigs.forEach(dataConfig -> billType.add(dataConfig.getString("name")));
        }
        String[] rptFields = (String[])ArrayUtils.addAll((Object[])fixFields, (Object[])trendsFields.toArray(new String[0]));
        DataType[] rptFieldTypes = (DataType[])ArrayUtils.addAll((Object[])fixTypes, (Object[])trendsTypes.toArray(new DataType[0]));
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])rptFields, (DataType[])rptFieldTypes);
        Algo algo = Algo.create((String)algoKey);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long offeringid = row.getLong("entryentity.material");
            String offeringnumber = row.getString("materialnumber");
            String offeringname = row.getString("materialname");
            Long supplyorg = 0L;
            if (row.getLong("entryentity.supplyorg") != null) {
                supplyorg = row.getLong("entryentity.supplyorg");
            }
            Long operator = 0L;
            if (row.getLong("entryentity.requireoperator") != null) {
                operator = row.getLong("entryentity.requireoperator");
            }
            String demandmodel = row.getString("demandmodel") == null ? "" : row.getString("demandmodel");
            BigDecimal qty = row.getBigDecimal("qty") == null ? BigDecimal.ZERO : row.getBigDecimal("qty");
            Date demanddate = row.getDate("entryentity.demanddate");
            BigDecimal demandqty = row.getBigDecimal("entryentity.demandqty") == null ? BigDecimal.ZERO : row.getBigDecimal("entryentity.demandqty");
            String isDemandmaterial = row.getString("isdemandmaterial");
            Object[] values = new Object[rptFields.length];
            values[0] = offeringid;
            values[1] = offeringnumber;
            values[2] = offeringname;
            values[3] = supplyorg;
            values[4] = demandmodel;
            values[5] = operator;
            values[6] = qty;
            values[7] = isDemandmaterial;
            for (int i = fixFields.length; i < values.length; ++i) {
                String fieldKey = rptFields[i];
                Date startTime = (Date)keyToStartTime.get(fieldKey);
                Date endTime = (Date)keyToEndTime.get(fieldKey);
                if (demanddate == null || demanddate.compareTo(endDate) >= 0) continue;
                if (i == fixFields.length) {
                    if (demanddate.compareTo(endTime) < 0) {
                        values[i] = demandqty;
                        continue;
                    }
                    values[i] = BigDecimal.ZERO;
                    continue;
                }
                values[i] = demanddate.compareTo(startTime) >= 0 && demanddate.compareTo(endTime) < 0 ? demandqty : BigDecimal.ZERO;
            }
            dataSetBuilder.append(values);
        }
        dataSet = dataSetBuilder.build();
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(fixFields);
        for (String trendsField : trendsFields) {
            groupbyDataSet = groupbyDataSet.sum(trendsField);
        }
        dataSet = groupbyDataSet.finish();
        return dataSet;
    }

    public static DataSet createRefrenceDataSet(DataSet detailDataSet, DataSet materialBaseDataSet, DataSet materialPlanDataSet, DataSet materialInvDataSet) {
        Object[] fieldsArray = detailDataSet.getRowMeta().getFieldNames();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"materialnumber", "materialname"});
        DataSet dataSet = detailDataSet.leftJoin(materialBaseDataSet).on("entryentity.material", "id").select((String[])fieldsArray).finish();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"demandmodel"});
        dataSet = dataSet.leftJoin(materialPlanDataSet).on("entryentity.material", "masterid").on("entryentity.supplyorg", "createorg").select((String[])fieldsArray).finish();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"qty"});
        dataSet = dataSet.leftJoin(materialInvDataSet).on("entryentity.material", "material").select((String[])fieldsArray).finish();
        return dataSet;
    }

    public static Map<String, Set<Long>> getPlanInfos(Long versionId, long planId) {
        HashSet invstrategySet = new HashSet();
        DynamicObjectCollection planCol = SnapshotDataUtils.query(versionId, "mrp_planprogram", "id,orgentryentity.entryinvstrategy", new QFilter[]{new QFilter("id", "=", (Object)planId)});
        planCol.forEach(dynamicObject -> invstrategySet.add(dynamicObject.getLong("orgentryentity.entryinvstrategy")));
        HashSet storageOrgSet = new HashSet();
        DynamicObjectCollection orgSettingCol = SnapshotDataUtils.query(versionId, "mrp_stocksupply_policy", "id,entryentity.storageorg", new QFilter[]{new QFilter("id", "in", invstrategySet)});
        orgSettingCol.forEach(orgSetting -> storageOrgSet.add(orgSetting.getLong("entryentity.storageorg")));
        HashSet warehouseSet = new HashSet();
        HashSet locationSet = new HashSet();
        HashSet goodWarehouseSet = new HashSet();
        HashSet goodLocationSet = new HashSet();
        DynamicObjectCollection warehouseCol = SnapshotDataUtils.query(versionId, "mrp_stocksupply_policy", "id,stocksetupentry.stocknumber,stocksetupentry.stockindex,stocksetupentry.wastewarehouse", new QFilter[]{new QFilter("id", "in", invstrategySet)});
        warehouseCol.forEach(entry -> {
            boolean isWasteWarehouse = entry.getBoolean("stocksetupentry.wastewarehouse");
            if (isWasteWarehouse) {
                warehouseSet.add(entry.getLong("stocksetupentry.stocknumber"));
                locationSet.add(entry.getLong("stocksetupentry.stockindex"));
            } else {
                goodWarehouseSet.add(entry.getLong("stocksetupentry.stocknumber"));
                goodLocationSet.add(entry.getLong("stocksetupentry.stockindex"));
            }
        });
        HashMap<String, Set<Long>> planInfos = new HashMap<String, Set<Long>>(3);
        planInfos.put("storageorg", storageOrgSet);
        planInfos.put("warehouse", warehouseSet);
        planInfos.put("location", locationSet);
        planInfos.put("goodwarehouse", goodWarehouseSet);
        planInfos.put("goodlocation", goodWarehouseSet);
        return planInfos;
    }

    public static DataSet queryMaterialInventory(String algoKey, Long versionId, Set<Long> materialIds, Set<Long> storageOrgs, Set<Long> warehouses, Set<Long> locations, RptSchemeInfo rptSchemeInfo) {
        Map<String, InvQueryRangeInfo> effectFields = CalcProductionForecastUtils.getRptSchemeEffect(rptSchemeInfo);
        HashSet openLocationWarehouse = new HashSet();
        InvQueryRangeInfo invQueryRangeInfo = effectFields.get("qty");
        if (invQueryRangeInfo != null) {
            warehouses.clear();
            locations.clear();
            warehouses.addAll(invQueryRangeInfo.getWarehouse());
            locations.addAll(invQueryRangeInfo.getLocation());
        }
        QFilter[] locationFilters = new QFilter[]{new QFilter("id", "in", warehouses), new QFilter("entryentity.location", "in", locations), new QFilter("isopenlocation", "=", (Object)Boolean.TRUE)};
        try (DataSet dataSet = SnapshotDataUtils.queryDataSet(algoKey, versionId, "bd_warehouse", "id,entryentity.location", locationFilters);){
            dataSet.forEach(row -> openLocationWarehouse.add(row.getLong("id")));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "in", storageOrgs));
        qFilters.add(new QFilter("warehouse", "in", warehouses));
        qFilters.add(new QFilter("material", "in", materialIds));
        String selectStr = "id,material,warehouse,location,qty";
        DataSet dataSet = SnapshotDataUtils.queryDataSet(algoKey, versionId, "im_inv_realbalance", selectStr, qFilters.toArray(new QFilter[0]));
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])invFields, (DataType[])invFieldsType);
        Algo algo = Algo.create((String)algoKey);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        while (dataSet.hasNext()) {
            Row row2 = dataSet.next();
            long id = row2.getLong("id");
            long material = row2.getLong("material");
            long warehouse = row2.getLong("warehouse");
            long location = row2.getLong("location");
            BigDecimal qty = row2.getBigDecimal("qty");
            if (openLocationWarehouse.contains(warehouse) && !locations.contains(location)) continue;
            Object[] values = new Object[]{id, material, qty};
            dataSetBuilder.append(values);
        }
        dataSet = dataSetBuilder.build();
        dataSet = dataSet.groupBy(new String[]{"material"}).sum("qty").finish();
        return dataSet;
    }

    public static Map<String, InvQueryRangeInfo> getRptSchemeEffect(RptSchemeInfo rptSchemeInfo) {
        HashMap<String, InvQueryRangeInfo> effectFields = new HashMap<String, InvQueryRangeInfo>();
        List<InvQueryRangeInfo> invQueryRange = rptSchemeInfo.getInvQueryRange();
        for (InvQueryRangeInfo invQueryRangeInfo : invQueryRange) {
            String rptField = invQueryRangeInfo.getRptField();
            if (!StringUtils.equals((CharSequence)"threeqty", (CharSequence)rptField) && !StringUtils.equals((CharSequence)"weekqty", (CharSequence)rptField) && !StringUtils.equals((CharSequence)"monthqty", (CharSequence)rptField)) continue;
            effectFields.put(rptField, invQueryRangeInfo);
        }
        return effectFields;
    }
}

