/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.rpt.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.common.enums.MaterialAttrEnum;
import kd.mmc.mrp.rpt.entity.InvQueryRangeInfo;
import kd.mmc.mrp.rpt.entity.RptSchemeInfo;
import kd.mmc.mrp.rpt.util.RptUtils;

public class CalcStockForecastUtils {
    public static final Log logger = LogFactory.getLog(CalcStockForecastUtils.class);
    protected static final String[] fixFields = new String[]{"material", "isserviceuse", "supplyorg", "demandmodel", "operator", "weekqty", "invqty", "monthqty", "threeqty", "dullqty"};
    protected static final DataType[] fixTypes = new DataType[]{DataType.LongType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.LongType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType};
    protected static final String[] invFields = new String[]{"id", "material", "qty"};
    protected static final DataType[] invFieldsType = new DataType[]{DataType.LongType, DataType.LongType, DataType.BigDecimalType};
    protected static final String[] materialPlanFields = new String[]{"masterid", "createorg", "operator", "demandmodel"};
    protected static final DataType[] materialPlanTypes = new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType, DataType.StringType};
    protected static final String[] materialFields = new String[]{"id", "isserviceuse"};
    protected static final DataType[] materialTypes = new DataType[]{DataType.LongType, DataType.StringType};

    public static DataSet dealPbomDatas(String algoKey, DataSet dataSet, Set<Long> supplyOrgs, Map<String, Map<String, Object>> pbomDatas) {
        dataSet = dataSet.addField("0", "ispbom");
        DataSet mtsDataSet = dataSet.copy().filter("demandmodel in ('MTS','STO')");
        DataSet noMtsDataSet = dataSet.copy().filter("demandmodel not in ('MTS','STO')");
        LinkedHashSet<Long> pbomMaterialIds = new LinkedHashSet<Long>(8);
        noMtsDataSet = CalcStockForecastUtils.dealNoMTSAndSTODatas(algoKey, noMtsDataSet, pbomMaterialIds);
        DataSet pbomDataSet = noMtsDataSet.copy().filter("ispbom = 1 ");
        pbomDataSet = pbomDataSet.groupBy(new String[]{"entryentity.material", "entryentity.supplyorg"}).sum("threeqty").sum("invqty").sum("weekqty").sum("monthqty").sum("dullqty").finish();
        DataSet pbomMaterialPlanDataSet = CalcStockForecastUtils.queryMaterialPlanInfo(algoKey, pbomMaterialIds, supplyOrgs);
        pbomDataSet = pbomDataSet.leftJoin(pbomMaterialPlanDataSet).on("entryentity.material", "masterid").on("entryentity.supplyorg", "createorg").select(new String[]{"entryentity.material", "entryentity.supplyorg", "demandmodel", "operator", "threeqty", "invqty", "weekqty", "monthqty", "dullqty"}).finish();
        DataSet pbomMaterialBaseDataSet = CalcStockForecastUtils.queryMaterialBaseInfo(algoKey, pbomMaterialIds);
        pbomDataSet = pbomDataSet.leftJoin(pbomMaterialBaseDataSet).on("entryentity.material", "id").select((String[])ArrayUtils.addAll((Object[])pbomDataSet.getRowMeta().getFieldNames(), (Object[])new String[]{"isserviceuse"})).finish();
        for (Row row : pbomDataSet) {
            long material = row.getLong("entryentity.material");
            long supplyorg = row.getLong("entryentity.supplyorg");
            HashMap<String, Object> datas = new HashMap<String, Object>();
            datas.put("isserviceuse", row.getString("isserviceuse"));
            datas.put("demandmodel", row.getString("demandmodel"));
            datas.put("operator", row.getLong("operator"));
            datas.put("threeqty", row.getBigDecimal("threeqty"));
            datas.put("invqty", row.getBigDecimal("invqty"));
            datas.put("weekqty", row.getBigDecimal("weekqty"));
            datas.put("monthqty", row.getBigDecimal("monthqty"));
            datas.put("dullqty", row.getBigDecimal("dullqty"));
            pbomDatas.put(material + "_" + supplyorg, datas);
        }
        dataSet = mtsDataSet.union(noMtsDataSet);
        return dataSet;
    }

    public static DataSet relateDataSet(DataSet calDetailDataSet, DataSet materialBaseDataSet, DataSet materialPlanDataSet, DataSet materialInvDataSet, DataSet invQtyDataSet, DataSet weekQtyDataSet, DataSet monthQtyDataSet, DataSet dullQtyDataSet) {
        Object[] fieldsArray = calDetailDataSet.getRowMeta().getFieldNames();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"demandmodel"});
        DataSet dataSet = calDetailDataSet.leftJoin(materialPlanDataSet).on("entryentity.material", "masterid").on("entryentity.supplyorg", "createorg").select((String[])fieldsArray).finish();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"isserviceuse"});
        dataSet = dataSet.leftJoin(materialBaseDataSet).on("entryentity.material", "id").select((String[])fieldsArray).finish();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"threeqty"});
        dataSet = dataSet.leftJoin(materialInvDataSet).on("entryentity.material", "material").select((String[])fieldsArray).finish();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"invqty"});
        dataSet = dataSet.leftJoin(invQtyDataSet).on("entryentity.material", "entryentity.material").select((String[])fieldsArray).finish();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"weekqty"});
        dataSet = dataSet.leftJoin(weekQtyDataSet).on("entryentity.material", "material").select((String[])fieldsArray).finish();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"monthqty"});
        dataSet = dataSet.leftJoin(monthQtyDataSet).on("entryentity.material", "material").select((String[])fieldsArray).finish();
        fieldsArray = (String[])ArrayUtils.addAll((Object[])fieldsArray, (Object[])new String[]{"dullqty"});
        dataSet = dataSet.leftJoin(dullQtyDataSet).on("entryentity.material", "entryentity.material").select((String[])fieldsArray).finish();
        return dataSet;
    }

    public static DataSet getInvQtyDataSet(DataSet detailDataSet) {
        DataSet invQtyDataSet = detailDataSet.copy().filter("entryentity.supplybillf7 = 'im_inv_realbalance'");
        invQtyDataSet = invQtyDataSet.groupBy(new String[]{"entryentity.material"}).sum("entryentity.supplyqty", "invqty").finish();
        return invQtyDataSet;
    }

    public static DataSet getDullQtyDataSet(DataSet detailDataSet) {
        DataSet dullQtyDataSet = detailDataSet.copy().filter("entryentity.supplybillf7 = 'im_inv_realbalance'").filter(ResManager.loadKDString((String)"entryentity.adjustsuggest = '\u5efa\u8bae\u53d6\u6d88'", (String)"CalcStockForecastUtils_0", (String)"mmc-mrp-common", (Object[])new Object[0]));
        dullQtyDataSet = dullQtyDataSet.groupBy(new String[]{"entryentity.material"}).sum("entryentity.supplyqty", "dullqty").finish();
        return dullQtyDataSet;
    }

    public static DataSet dealDatasWithResource(DataSet detailDataSet) {
        DataSet calDetailDataSet = detailDataSet.copy().filter("entryentity.supplybillf7 != 'im_inv_realbalance'").filter(ResManager.loadKDString((String)"entryentity.adjustsuggest != '\u5efa\u8bae\u53d6\u6d88'", (String)"CalcStockForecastUtils_1", (String)"mmc-mrp-common", (Object[])new Object[0]));
        DataSet noResourceDataSet = calDetailDataSet.copy().filter("entryentity.reqsourcebillno = null or entryentity.reqsourcebillno = ''");
        DataSet filterSet = noResourceDataSet.groupBy(new String[]{"entryentity.billid", "entryentity.billentryid"}).min("cast(entryentity.llc as Integer)", "llc").finish();
        filterSet = filterSet.addField("cast(llc as String)", "llcStr");
        noResourceDataSet = noResourceDataSet.join(filterSet).on("entryentity.billid", "entryentity.billid").on("entryentity.billentryid", "entryentity.billentryid").on("entryentity.llc", "llcStr").select(noResourceDataSet.getRowMeta().getFieldNames()).finish();
        DataSet resourceDataSet = calDetailDataSet.copy().filter("entryentity.reqsourcebillno  !=null and entryentity.reqsourcebillno !=''");
        DataSet reqSourceFilterSet = resourceDataSet.groupBy(new String[]{"entryentity.reqsourcebillno"}).min("cast(entryentity.llc as Integer)", "llc").finish();
        reqSourceFilterSet = reqSourceFilterSet.addField("cast(llc as String)", "llcStr");
        resourceDataSet = resourceDataSet.join(reqSourceFilterSet).on("entryentity.reqsourcebillno", "entryentity.reqsourcebillno").on("entryentity.llc", "llcStr").select(resourceDataSet.getRowMeta().getFieldNames()).finish();
        return noResourceDataSet.union(resourceDataSet);
    }

    public static DataSet createNewDataSet(String algoKey, Map<String, Object> params, DataSet dataSet, Map<String, Map<String, Object>> pbomDatas) {
        List trendsFields = (List)params.get("trendsFields");
        List trendsTypes = (List)params.get("trendsTypes");
        Map keyToStartTime = (Map)params.get("keyToStartTime");
        Map keyToEndTime = (Map)params.get("keyToEndTime");
        Date endDate = (Date)params.get("endDate");
        String[] rptFields = (String[])ArrayUtils.addAll((Object[])fixFields, (Object[])trendsFields.toArray(new String[0]));
        DataType[] rptFieldTypes = (DataType[])ArrayUtils.addAll((Object[])fixTypes, (Object[])trendsTypes.toArray(new DataType[0]));
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])rptFields, (DataType[])rptFieldTypes);
        Algo algo = Algo.create((String)algoKey);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        while (dataSet.hasNext()) {
            BigDecimal adjustqty;
            Row row = dataSet.next();
            long material = row.getLong("entryentity.material");
            String isserviceuse = row.getString("isserviceuse") == null ? "N" : row.getString("isserviceuse");
            long supplyorg = row.getLong("entryentity.supplyorg") == null ? 0L : row.getLong("entryentity.supplyorg");
            long operator = row.getLong("entryentity.requireoperator") == null ? 0L : row.getLong("entryentity.requireoperator");
            String demandmodel = row.getString("demandmodel") == null ? "" : row.getString("demandmodel");
            BigDecimal threeqty = row.getBigDecimal("threeqty") == null ? BigDecimal.ZERO : row.getBigDecimal("threeqty");
            BigDecimal invqty = row.getBigDecimal("invqty") == null ? BigDecimal.ZERO : row.getBigDecimal("invqty");
            BigDecimal dullqty = row.getBigDecimal("dullqty") == null ? BigDecimal.ZERO : row.getBigDecimal("dullqty");
            BigDecimal weekQty = row.getBigDecimal("weekqty") == null ? BigDecimal.ZERO : row.getBigDecimal("weekqty");
            BigDecimal monthqty = row.getBigDecimal("monthqty") == null ? BigDecimal.ZERO : row.getBigDecimal("monthqty");
            String key = material + "_" + supplyorg;
            Map<String, Object> datas = pbomDatas.get(key);
            if (datas != null) {
                isserviceuse = datas.get("isserviceuse") == null ? "N" : (String)datas.get("isserviceuse");
                operator = datas.get("operator") == null ? 0L : (Long)datas.get("operator");
                demandmodel = datas.get("demandmodel") == null ? " " : (String)datas.get("demandmodel");
                threeqty = datas.get("threeqty") == null ? BigDecimal.ZERO : (BigDecimal)datas.get("threeqty");
                invqty = datas.get("invqty") == null ? BigDecimal.ZERO : (BigDecimal)datas.get("invqty");
                dullqty = datas.get("dullqty") == null ? BigDecimal.ZERO : (BigDecimal)datas.get("dullqty");
                weekQty = datas.get("weekQty") == null ? BigDecimal.ZERO : (BigDecimal)datas.get("weekQty");
                monthqty = datas.get("monthqty") == null ? BigDecimal.ZERO : (BigDecimal)datas.get("monthqty");
            }
            monthqty = monthqty.add(invqty);
            Date demanddate = row.getDate("entryentity.demanddate");
            BigDecimal supplyqty = row.getBigDecimal("entryentity.supplyqty") == null ? BigDecimal.ZERO : row.getBigDecimal("entryentity.supplyqty");
            Date adjustdate = row.getDate("entryentity.adjustdate");
            BigDecimal bigDecimal = adjustqty = row.getBigDecimal("entryentity.adjustqty") == null ? BigDecimal.ZERO : row.getBigDecimal("entryentity.adjustqty");
            if (adjustdate != null) {
                demanddate = adjustdate;
            }
            if (BigDecimal.ZERO.compareTo(adjustqty) != 0) {
                supplyqty = adjustqty;
            }
            Object[] values = new Object[rptFields.length];
            values[0] = material;
            values[1] = isserviceuse;
            values[2] = supplyorg;
            values[3] = demandmodel;
            values[4] = operator;
            values[5] = weekQty;
            values[6] = invqty;
            values[7] = monthqty;
            values[8] = threeqty;
            values[9] = dullqty;
            for (int i = fixFields.length; i < values.length; ++i) {
                String fieldKey = rptFields[i];
                Date startTime = (Date)keyToStartTime.get(fieldKey);
                Date endTime = (Date)keyToEndTime.get(fieldKey);
                if (demanddate == null || demanddate.compareTo(endDate) >= 0) continue;
                if (i == fixFields.length) {
                    if (demanddate.compareTo(endTime) < 0) {
                        values[i] = supplyqty;
                        continue;
                    }
                    values[i] = BigDecimal.ZERO;
                    continue;
                }
                values[i] = demanddate.compareTo(startTime) >= 0 && demanddate.compareTo(endTime) < 0 ? supplyqty : BigDecimal.ZERO;
            }
            dataSetBuilder.append(values);
        }
        dataSet = dataSetBuilder.build();
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(fixFields);
        for (String trendsField : trendsFields) {
            groupbyDataSet = groupbyDataSet.sum(trendsField);
        }
        dataSet = groupbyDataSet.finish();
        return dataSet;
    }

    public static void createStockDatas(DataSet dataSet, String planNo, Map<String, Object> params) {
        List trendsFields = (List)params.get("trendsFields");
        Map keyToCaption = (Map)params.get("keyToCaption");
        Map keyToSequence = (Map)params.get("keyToSequence");
        ORM orm = ORM.create();
        long id = orm.genLongId("mrp_rpt_stock_datas");
        DynamicObject head = orm.newDynamicObject("mrp_rpt_stock_datas");
        head.set("id", (Object)id);
        head.set("billno", (Object)planNo);
        head.set("billstatus", (Object)"A");
        head.set("planid", (Object)planNo);
        head.set("creator", (Object)RequestContext.get().getCurrUserId());
        head.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{head});
        ArrayList<Object> entryValues = new ArrayList<Object>(8);
        ArrayList<Object[]> subEntryValues = new ArrayList<Object[]>(8);
        int idSize = 1;
        for (Row ignored : dataSet.copy()) {
            ++idSize;
        }
        long[] newEntryIds = ID.genLongIds((int)idSize);
        String entrySql = "insert into t_mrp_stock_datafix (fid, fentryid, fseq, fmaterial, fisserviceuse, fsupplyorg, fdemandmodel, foperator, freleasestatus, fthreeqty, fweekqty, finvqty, fmonthqty, fdullqty) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String subEntrySql = "insert into t_mrp_stock_datasub (fentryid, fdetailid, fseq, ffieldkey, ffieldcaption, ffieldvalue, fsequence ) values (?, ?, ?, ?, ?, ?, ?)";
        int seq = 0;
        if (dataSet.isEmpty()) {
            Object[] entry = new Object[]{id, newEntryIds[seq], seq + 1, 0, " ", 0, " ", 0, "A", 0, 0, 0, 0, 0};
            entryValues.add(entry);
            int subSeq = 0;
            long[] subIds = ID.genLongIds((int)trendsFields.size());
            for (String trendsField : trendsFields) {
                Object[] subEntry = new Object[]{newEntryIds[seq], subIds[subSeq], subSeq + 1, trendsField, keyToCaption.getOrDefault(trendsField, ""), BigDecimal.ZERO, keyToSequence.getOrDefault(trendsField, "")};
                subEntryValues.add(subEntry);
                ++subSeq;
            }
        }
        for (Row row : dataSet) {
            Object[] entry = new Object[]{id, newEntryIds[seq], seq + 1, row.get("material"), row.get("isserviceuse"), row.get("supplyorg"), row.get("demandmodel"), row.get("operator"), "A", row.get("threeqty"), row.get("weekqty"), row.get("invqty"), row.get("monthqty"), row.get("dullqty")};
            entryValues.add(entry);
            int subSeq = 0;
            long[] subIds = ID.genLongIds((int)trendsFields.size());
            for (String trendsField : trendsFields) {
                Object[] subEntry = new Object[]{newEntryIds[seq], subIds[subSeq], subSeq + 1, trendsField, keyToCaption.getOrDefault(trendsField, ""), row.get(trendsField) == null ? BigDecimal.ZERO : row.get(trendsField), keyToSequence.get(trendsField)};
                subEntryValues.add(subEntry);
                ++subSeq;
            }
            ++seq;
        }
        DBRoute dbRoute = DBRoute.of((String)"scm");
        if (entryValues.size() > 0) {
            DB.executeBatch((DBRoute)dbRoute, (String)entrySql, entryValues);
        }
        if (subEntryValues.size() > 0) {
            DB.executeBatch((DBRoute)dbRoute, (String)subEntrySql, subEntryValues);
        }
    }

    public static DataSet queryWeekQty(String algoKey, RptSchemeInfo rptSchemeInfo) {
        Map<String, InvQueryRangeInfo> rptSchemeEffect = CalcStockForecastUtils.getRptSchemeEffect(rptSchemeInfo);
        InvQueryRangeInfo invQueryRangeInfo = rptSchemeEffect.get("weekqty");
        String[] fields = new String[]{"material", "weekqty"};
        DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.BigDecimalType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields, (DataType[])dataTypes);
        if (invQueryRangeInfo == null) {
            DataSetBuilder dataSetBuilder = Algo.create((String)algoKey).createDataSetBuilder(rowMeta);
            return dataSetBuilder.build();
        }
        return RptUtils.resolveInvQueryRangeInfo(algoKey, invQueryRangeInfo, rowMeta);
    }

    public static DataSet queryMonthQty(String algoKey, RptSchemeInfo rptSchemeInfo) {
        Map<String, InvQueryRangeInfo> rptSchemeEffect = CalcStockForecastUtils.getRptSchemeEffect(rptSchemeInfo);
        InvQueryRangeInfo invQueryRangeInfo = rptSchemeEffect.get("monthqty");
        String[] fields = new String[]{"material", "monthqty"};
        DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.BigDecimalType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields, (DataType[])dataTypes);
        if (invQueryRangeInfo == null) {
            DataSetBuilder dataSetBuilder = Algo.create((String)algoKey).createDataSetBuilder(rowMeta);
            return dataSetBuilder.build();
        }
        return RptUtils.resolveInvQueryRangeInfo(algoKey, invQueryRangeInfo, rowMeta);
    }

    public static DataSet queryMaterialBaseInfo(String algoKey, Set<Long> materialIds) {
        algoKey = algoKey + "_queryMaterialBaseInfo";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", materialIds)};
        String selectStr = "id,materialtype";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_material", (String)selectStr, (QFilter[])qFilters, null);
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])materialFields, (DataType[])materialTypes);
        DataSetBuilder dataSetBuilder = Algo.create((String)algoKey).createDataSetBuilder(rowMeta);
        dataSet.copy().forEach(row -> {
            Object[] value = new Object[2];
            long id = row.getLong("id");
            String materialtype = row.getString("materialtype");
            String isserviceuse = "N";
            if ("9".equals(materialtype)) {
                isserviceuse = "Y";
            }
            value[0] = id;
            value[1] = isserviceuse;
            dataSetBuilder.append(value);
        });
        dataSet = dataSetBuilder.build();
        return dataSet;
    }

    public static DataSet dealNoMTSAndSTODatas(String algoKey, DataSet noMtsDataSet, Set<Long> materialIds) {
        LinkedHashSet<Long> noMtsMaterials = new LinkedHashSet<Long>();
        noMtsDataSet.copy().forEach(row -> noMtsMaterials.add(row.getLong("entryentity.material")));
        Map<Long, Long> pbomMap = CalcStockForecastUtils.queryProductFamily(algoKey, noMtsMaterials);
        DataSetBuilder noMTSBuilder = Algo.create((String)algoKey).createDataSetBuilder(noMtsDataSet.getRowMeta());
        String[] fieldNames = noMtsDataSet.getRowMeta().getFieldNames();
        noMtsDataSet.copy().forEach(row -> {
            int ispbom = row.getInteger("ispbom");
            long material = row.getLong("entryentity.material");
            if (pbomMap.get(material) != null) {
                ispbom = 1;
            }
            Object[] values = new Object[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldName = fieldNames[i];
                Object value = row.get(fieldName);
                if (StringUtils.equals((CharSequence)"entryentity.material", (CharSequence)fieldName) && pbomMap.get(value) != null) {
                    value = pbomMap.get(value);
                    materialIds.add((Long)value);
                }
                if (StringUtils.equals((CharSequence)"ispbom", (CharSequence)fieldName)) {
                    value = ispbom;
                }
                values[i] = value;
            }
            noMTSBuilder.append(values);
        });
        noMtsDataSet = noMTSBuilder.build();
        return noMtsDataSet;
    }

    public static Map<Long, Long> queryProductFamily(String algoKey, Set<Long> noMtsMaterials) {
        LinkedHashMap<Long, Long> pbomMap = new LinkedHashMap<Long, Long>();
        if (noMtsMaterials.isEmpty()) {
            return pbomMap;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("materielitem", "in", noMtsMaterials), new QFilter("bomtype", "=", (Object)"MBOM")};
        String selectStr = "id,materielitem,materielpbom";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mds_productfamily", (String)selectStr, (QFilter[])qFilters, null);){
            dataSet.forEach(row -> pbomMap.put(row.getLong("materielitem"), row.getLong("materielpbom")));
        }
        return pbomMap;
    }

    public static DataSet queryMrpCalcDetail(String algoKey, String planNo, RptSchemeInfo rptSchemeInfo) {
        algoKey = algoKey + "_queryMrpCalcDetail";
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        qFilterList.add(new QFilter("caculatelog", "=", (Object)planNo));
        qFilterList.add(new QFilter("entryentity.materialattr", "!=", (Object)MaterialAttrEnum.PURCHASEDPART.getValue()));
        qFilterList.add(new QFilter("entryentity.demandqty", "!=", (Object)BigDecimal.ZERO));
        qFilterList.add(new QFilter("entryentity.supplyqty", "!=", (Object)BigDecimal.ZERO));
        List<Long> source = rptSchemeInfo.getSource();
        DynamicObjectCollection dataConfigs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", source)});
        if (dataConfigs != null && dataConfigs.size() != 0) {
            ArrayList billType = new ArrayList(8);
            dataConfigs.forEach(dataConfig -> billType.add(dataConfig.getString("name")));
            qFilterList.add(new QFilter("entryentity.demandbilltype", "in", billType));
        }
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        String selectStr = "id,mrpplan,entryentity.material,entryentity.supplyqty,entryentity.supplyorg,entryentity.demanddate,entryentity.demandqty,entryentity.adjustdate,entryentity.adjustqty,entryentity.demandbillf7,entryentity.supplybillf7,entryentity.adjustsuggest,entryentity.billno,entryentity.requireoperator,entryentity.billentryseq,entryentity.demandbilltype,entryentity.reqsourcebillno,entryentity.billid,entryentity.billentryid,entryentity.llc";
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"mrp_calcdetail", (String)selectStr, (QFilter[])qFilters, null);
    }

    public static DataSet queryMaterialPlanInfo(String algoKey, Set<Long> materialIds, Set<Long> supplyorgIds) {
        Object demandModel;
        Row row2;
        HashMap groupToStrategy = new HashMap(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mpdm_manustrategy_group", (String)"id,createorg,entryentity.strategynumber,entryentity.strategynumber.demandmodel", (QFilter[])new QFilter[]{new QFilter("createorg", "in", supplyorgIds)}, (String)"id,entryentity.priority");){
            dataSet.forEach(row -> groupToStrategy.put(row.getLong("id"), row.getString("entryentity.strategynumber.demandmodel")));
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])materialPlanFields, (DataType[])materialPlanTypes);
        Algo algo = Algo.create((String)algoKey);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        DynamicObject strategyObj = QueryServiceHelper.queryOne((String)"mpdm_manustrategy", (String)"id,demandmodel", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"MTS10")});
        if (strategyObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3aMTS10\u7684\u8ba1\u5212\u6a21\u5f0f\u3002", (String)"CalcStockForecastUtils_2", (String)"mmc-mrp-common", (Object[])new Object[0]));
        }
        String defaultDemandModel = strategyObj.getString("demandmodel");
        LinkedHashSet<String> materialAndOrgKey = new LinkedHashSet<String>(8);
        HashMap shareMaterialDatas = new HashMap(8);
        String selectStr = "id,masterid,createorg,manufacturegroup,ctrlstrategy,planmode,operator";
        DynamicObject config = QueryServiceHelper.queryOne((String)"mrp_runconfig", (String)"id,param", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"MATERIAL_PLAN_INFO_SETTINGS")});
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        qFilterList.add(new QFilter("masterid", "in", materialIds));
        if (config == null || !StringUtils.equals((CharSequence)"IGNORE", (CharSequence)config.getString("param"))) {
            qFilterList.add(new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1")));
        }
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        HashMap<String, Object> materialDemandModelMap = new HashMap<String, Object>();
        HashSet<Long> invMaterialIds = new HashSet<Long>(8);
        HashSet<String> invMaterialAndOrg = new HashSet<String>(8);
        try (Object dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mpdm_materialplan", (String)selectStr, (QFilter[])qFilters, (String)"id DESC");){
            while (dataSet.hasNext()) {
                String planmode;
                HashMap<String, Object> datas;
                row2 = dataSet.next();
                demandModel = (String)groupToStrategy.get(row2.getLong("manufacturegroup"));
                if (StringUtils.isEmpty((CharSequence)demandModel)) {
                    demandModel = defaultDemandModel;
                }
                long materialId = row2.getLong("masterid");
                long createorg = row2.getLong("createorg");
                long operator = row2.getLong("operator");
                String ctrlstrategy = row2.getString("ctrlstrategy");
                if (StringUtils.equals((CharSequence)"5", (CharSequence)ctrlstrategy) && (datas = (HashMap<String, Object>)shareMaterialDatas.get(materialId)) == null) {
                    datas = new HashMap<String, Object>(2);
                    datas.put("operator", operator);
                    datas.put("demandmodel", demandModel);
                    shareMaterialDatas.put(materialId, datas);
                }
                if (StringUtils.equals((CharSequence)"C", (CharSequence)(planmode = row2.getString("planmode"))) || StringUtils.equals((CharSequence)"D", (CharSequence)planmode)) {
                    invMaterialIds.add(materialId);
                    invMaterialAndOrg.add(materialId + "_" + createorg);
                }
                materialAndOrgKey.add(materialId + "_" + createorg);
                materialDemandModelMap.put(materialId + "_" + createorg, demandModel);
            }
        }
        dataSet = materialIds.iterator();
        while (dataSet.hasNext()) {
            long materialId = (Long)dataSet.next();
            demandModel = supplyorgIds.iterator();
            while (demandModel.hasNext()) {
                Map datas;
                long orgId = (Long)demandModel.next();
                String key2 = materialId + "_" + orgId;
                if (materialAndOrgKey.contains(key2) || (datas = (Map)shareMaterialDatas.get(materialId)) == null) continue;
                materialDemandModelMap.put(key2, (String)datas.get("demandmodel"));
            }
        }
        selectStr = "id,masterid,createorg,manustrategy.demandmodel AS demandmodel,ctrlstrategy";
        qFilterList.clear();
        qFilterList.add(new QFilter("masterid", "in", invMaterialIds));
        qFilterList.add(new QFilter("status", "=", (Object)"C"));
        qFilterList.add(new QFilter("enable", "=", (Object)"1"));
        qFilters = qFilterList.toArray(new QFilter[0]);
        dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_materialinventoryinfo", (String)selectStr, (QFilter[])qFilters, (String)"id DESC");
        Throwable throwable = null;
        try {
            while (dataSet.hasNext()) {
                row2 = dataSet.next();
                long materialId = row2.getLong("masterid");
                long createorgId = row2.getLong("createorg");
                String demandModel2 = row2.getString("demandmodel");
                String key3 = materialId + "_" + createorgId;
                if (!invMaterialAndOrg.contains(key3) || !StringUtils.isNotBlank((CharSequence)demandModel2)) continue;
                materialDemandModelMap.put(key3, demandModel2);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (dataSet != null) {
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        materialDemandModelMap.forEach((key, value) -> {
            Object[] row = new Object[4];
            String[] split = key.split("_");
            row[0] = split[0];
            row[1] = split[1];
            row[2] = 0L;
            row[3] = value;
            dataSetBuilder.append(row);
        });
        return dataSetBuilder.build();
    }

    public static DataSet queryMaterialInventory(String algoKey, Set<Long> materialIds, Set<Long> storageOrgs, Set<Long> warehouses, Set<Long> locations, RptSchemeInfo rptSchemeInfo) {
        algoKey = algoKey + "_queryMaterialInventory";
        Map<String, InvQueryRangeInfo> rptSchemeEffect = CalcStockForecastUtils.getRptSchemeEffect(rptSchemeInfo);
        HashSet openLocationWarehouse = new HashSet();
        InvQueryRangeInfo invQueryRangeInfo = rptSchemeEffect.get("threeqty");
        if (invQueryRangeInfo != null) {
            warehouses.clear();
            locations.clear();
            warehouses.addAll(invQueryRangeInfo.getWarehouse());
            locations.addAll(invQueryRangeInfo.getLocation());
        }
        QFilter[] locationFilters = new QFilter[]{new QFilter("id", "in", warehouses), new QFilter("entryentity.location", "in", locations), new QFilter("isopenlocation", "=", (Object)Boolean.TRUE)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_warehouse", (String)"id,entryentity.location", (QFilter[])locationFilters, null);){
            dataSet.forEach(row -> openLocationWarehouse.add(row.getLong("id")));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "in", storageOrgs));
        qFilters.add(new QFilter("warehouse", "in", warehouses));
        qFilters.add(new QFilter("material", "in", materialIds));
        String selectStr = "id,material,warehouse,location,qty";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_inv_realbalance", (String)selectStr, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])invFields, (DataType[])invFieldsType);
        Algo algo = Algo.create((String)algoKey);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        while (dataSet.hasNext()) {
            Row row2 = dataSet.next();
            long id = row2.getLong("id");
            long material = row2.getLong("material");
            long warehouse = row2.getLong("warehouse");
            long location = row2.getLong("location");
            BigDecimal qty = row2.getBigDecimal("qty");
            if (openLocationWarehouse.contains(warehouse) && !locations.contains(location)) continue;
            Object[] values = new Object[]{id, material, qty};
            dataSetBuilder.append(values);
        }
        dataSet = dataSetBuilder.build();
        dataSet = dataSet.groupBy(new String[]{"material"}).sum("qty", "threeqty").finish();
        return dataSet;
    }

    public static Map<String, InvQueryRangeInfo> getRptSchemeEffect(RptSchemeInfo rptSchemeInfo) {
        HashMap<String, InvQueryRangeInfo> effectFields = new HashMap<String, InvQueryRangeInfo>();
        List<InvQueryRangeInfo> invQueryRange = rptSchemeInfo.getInvQueryRange();
        for (InvQueryRangeInfo invQueryRangeInfo : invQueryRange) {
            String rptField = invQueryRangeInfo.getRptField();
            if (!StringUtils.equals((CharSequence)"threeqty", (CharSequence)rptField) && !StringUtils.equals((CharSequence)"weekqty", (CharSequence)rptField) && !StringUtils.equals((CharSequence)"monthqty", (CharSequence)rptField)) continue;
            effectFields.put(rptField, invQueryRangeInfo);
        }
        return effectFields;
    }
}

