/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.rpt.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.util.SnapshotDataUtils;
import kd.mmc.mrp.rpt.enmus.RptTypeEnum;

public class DecumentsPlanUtils {
    private static String algoKey = DecumentsPlanUtils.class.getName();
    private static final String[] TRANsACTION_Type_S = new String[]{"401", "601"};
    private static final String[] FIELDS = new String[]{"invId", "stockindex", "wastewarehouse"};
    private static final DataType[] DATA_TYPES = new DataType[]{DataType.LongType, DataType.LongType, DataType.BooleanType};

    public static DataSet importSaveData(String planNo, Map<String, Map<String, Object>> newDataMap, Map<String, List<Map<String, Object>>> newEntryDataMap, Date now, long userId) {
        QFilter filter = new QFilter("caculatelog", "=", (Object)planNo);
        DynamicObject mrpPlan = QueryServiceHelper.queryOne((String)"mrp_calcdetail", (String)"mrpplan", (QFilter[])filter.toArray());
        if (mrpPlan == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u8fd0\u7b97\u53f7\u5bf9\u5e94\u7684MRP\u8ba1\u7b97\u660e\u7ec6\u8868\u4e2d\u8ba1\u5212\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"DecumentsPlanUtils_0", (String)"mmc-mrp-common", (Object[])new Object[0]));
        }
        Long mrpPlnaId = mrpPlan.getLong("mrpplan");
        DataSet querySet = DecumentsPlanUtils.createMaterialSet(newDataMap);
        HashSet<String> materialNumberSet = new HashSet<String>();
        if (!newDataMap.isEmpty()) {
            for (Map<String, Object> map : newDataMap.values()) {
                materialNumberSet.add((String)map.get("materialNumber"));
            }
        }
        querySet = DecumentsPlanUtils.getMaterialPlanInfo(null, materialNumberSet, querySet);
        DynamicObject schemesObject = DecumentsPlanUtils.queryRptSchemes();
        if (schemesObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u5355\u8ba1\u5212\u62a5\u8868\u5bf9\u5e94\u7684\u62a5\u8868\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"DecumentsPlanUtils_1", (String)"mmc-mrp-common", (Object[])new Object[0]));
        }
        DataSet entity1Set = DecumentsPlanUtils.queryInvData(null, querySet, mrpPlnaId, schemesObject, null);
        querySet = entity1Set == null ? querySet.addField("0", "baseqty1").addField("0", "baseqty2") : querySet.leftJoin(entity1Set).on("supmaterial", "supmaterial").on("supplyorg", "supplyorg").on("operator", "operator").select(querySet.getRowMeta().getFieldNames(), new String[]{"baseqty1", "baseqty2"}).finish();
        DataSet mftStockSet = DecumentsPlanUtils.queryProdBilll(null, null, materialNumberSet);
        querySet = mftStockSet != null ? querySet.leftJoin(mftStockSet).on("supmaterial", "masterid").select(querySet.getRowMeta().getFieldNames(), new String[]{"baseqty3"}).finish() : querySet.addField("0", "baseqty3");
        if (querySet != null && !querySet.isEmpty()) {
            return querySet;
        }
        return null;
    }

    public static DynamicObject queryRptSchemes() {
        QFilter filter = new QFilter("rpttype", "=", (Object)RptTypeEnum.DOCUMENTS_PLAN.getValue());
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        DynamicObject rptSchemeObject = BusinessDataServiceHelper.loadSingleFromCache((String)"mrp_rpt_scheme", (QFilter[])filter.toArray());
        if (rptSchemeObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u5355\u8ba1\u5212\u62a5\u8868\u5bf9\u5e94\u7684\u62a5\u8868\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"DecumentsPlanUtils_1", (String)"mmc-mrp-common", (Object[])new Object[0]));
        }
        return rptSchemeObject;
    }

    public static DataSet queryInvData(Long versionId, DataSet querySet, Long mrpPlnaId, DynamicObject schemesObject, Set<Long> materialIdSet) {
        Set<Long> invStrategyIds;
        DataSet entity1Set = querySet.copy().groupBy(new String[]{"supmaterial", "operator", "supplyorg", "demandmodel"}).finish();
        if (entity1Set.isEmpty()) {
            return null;
        }
        if (materialIdSet == null || materialIdSet.isEmpty()) {
            materialIdSet = new HashSet<Long>();
            for (Row row : querySet.copy()) {
                Long fid = row.getLong("supmaterial");
                materialIdSet.add(fid);
            }
        }
        if (!(invStrategyIds = DecumentsPlanUtils.getInvStrategy(versionId, mrpPlnaId)).isEmpty()) {
            Map<String, Object> invReportMap = DecumentsPlanUtils.getRptSchemeEffect(schemesObject);
            Set<Long> orgsSet = DecumentsPlanUtils.getInvOrgs(versionId, invStrategyIds);
            DataSet srategyInvSet = DecumentsPlanUtils.queryStrategyInvData(versionId, orgsSet, invStrategyIds, materialIdSet);
            if (invReportMap == null || invReportMap.size() == 0) {
                entity1Set = entity1Set.leftJoin(srategyInvSet).on("supmaterial", "material").select(entity1Set.getRowMeta().getFieldNames(), new String[]{"baseqty1", "baseqty2"}).finish();
                return entity1Set;
            }
            Object goodWarehouseSet = invReportMap.get("goodWarehouseSet");
            Object goodLocationSet = invReportMap.get("goodLocationSet");
            Object defWarehouseSet = invReportMap.get("defWarehouseSet");
            Object defLocationSet = invReportMap.get("defLocationSet");
            DataSet goodDataSet = DecumentsPlanUtils.getRealBalance(materialIdSet, orgsSet, goodWarehouseSet, goodLocationSet);
            entity1Set = DecumentsPlanUtils.getInvData(entity1Set, goodDataSet, srategyInvSet, "baseqty1");
            DataSet defDataSet = DecumentsPlanUtils.getRealBalance(materialIdSet, orgsSet, defWarehouseSet, defLocationSet);
            entity1Set = DecumentsPlanUtils.getInvData(entity1Set, defDataSet, srategyInvSet, "baseqty2");
        } else {
            entity1Set = entity1Set.addBalanceField("0", "baseqty1").addBalanceField("0", "baseqty2");
        }
        return entity1Set;
    }

    public static Set<Long> getInvOrgs(Long versionId, Set<Long> invStrategyIds) {
        HashSet<Long> storageOrgSet = new HashSet<Long>();
        DynamicObjectCollection orgSettingCol = SnapshotDataUtils.query(versionId, "mrp_stocksupply_policy", "id,entryentity.storageorg", new QFilter[]{new QFilter("id", "in", invStrategyIds), new QFilter("stocksetup", "=", (Object)"1"), new QFilter("stocksetup", "=", (Object)"3")});
        orgSettingCol.forEach(orgSetting -> storageOrgSet.add(orgSetting.getLong("entryentity.storageorg")));
        return storageOrgSet;
    }

    public static Set<Long> getInvStrategy(Long versionId, long planId) {
        HashSet<Long> invstrategySet = new HashSet<Long>();
        DynamicObjectCollection planCol = SnapshotDataUtils.query(versionId, "mrp_planprogram", "id,orgentryentity.entryinvstrategy", new QFilter[]{new QFilter("id", "=", (Object)planId)});
        planCol.forEach(dynamicObject -> invstrategySet.add(dynamicObject.getLong("orgentryentity.entryinvstrategy")));
        return invstrategySet;
    }

    private static DataSet getInvData(DataSet entity1Set, DataSet invDataSet, DataSet srategyInvSet, String qtyFileds) {
        if (invDataSet == null) {
            entity1Set = entity1Set.leftJoin(srategyInvSet).on("supmaterial", "material").select(entity1Set.getRowMeta().getFieldNames(), new String[]{qtyFileds}).finish();
        } else {
            invDataSet = invDataSet.select("material,baseqty as " + qtyFileds);
            entity1Set = entity1Set.leftJoin(invDataSet).on("supmaterial", "material").select(entity1Set.getRowMeta().getFieldNames(), new String[]{qtyFileds}).finish();
        }
        return entity1Set;
    }

    private static DataSet getRealBalance(Set<Long> materialIdSet, Set<Long> orgsSet, Object warehouseSet, Object locationSet) {
        QFilter invFilter = new QFilter("material", "in", materialIdSet);
        invFilter.and("org", "in", orgsSet);
        QFilter wareHouseSet = null;
        boolean isReport = false;
        if (warehouseSet != null) {
            wareHouseSet = new QFilter("warehouse", "in", warehouseSet);
            isReport = true;
        }
        if (locationSet != null) {
            if (isReport) {
                wareHouseSet.or("location", "in", locationSet);
            } else {
                wareHouseSet = new QFilter("location", "in", locationSet);
            }
            isReport = true;
        }
        if (isReport) {
            invFilter = invFilter.and(wareHouseSet);
            DataSet invAccDataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "_InvCost"), (String)"im_inv_realbalance", (String)"material,baseqty", (QFilter[])invFilter.toArray(), null);
            invAccDataSet = invAccDataSet.groupBy(new String[]{"material"}).sum("baseqty").finish();
            return invAccDataSet;
        }
        return null;
    }

    private static DataSet queryStrategyInvData(Long versionId, Set<Long> orgsSet, Set<Long> invStrategyIds, Set<Long> materialIdSet) {
        QFilter invFilters = null;
        HashSet<Long> notinvsSet = new HashSet<Long>();
        ArrayList<Object[]> invCollect = new ArrayList<Object[]>();
        DynamicObjectCollection warehouseCol = SnapshotDataUtils.query(versionId, "mrp_stocksupply_policy", "id,stocksetup,stocksetupentry.stockorg stockorg,stocksetupentry.stocknumber stocknumber,stocksetupentry.stockindex stockindex,stocksetupentry.wastewarehouse wastewarehouse", new QFilter[]{new QFilter("id", "in", invStrategyIds)});
        for (DynamicObject dynamicObject : warehouseCol) {
            String stockSetUpValue = dynamicObject.getString("stocksetup");
            if ("2".equals(stockSetUpValue)) {
                Long fid = dynamicObject.getLong("stocknumber");
                Long forgid = dynamicObject.getLong("stockorg");
                QFilter filter = new QFilter("org", "=", (Object)forgid);
                filter.and("warehouse", "=", (Object)fid);
                Object[] tempData = new Object[FIELDS.length];
                tempData[0] = fid;
                long localId = dynamicObject.getLong("stockindex");
                if (localId != 0L) {
                    filter.and("location", "=", (Object)localId);
                    tempData[1] = localId;
                } else {
                    tempData[1] = 0L;
                }
                tempData[2] = dynamicObject.getBoolean("wastewarehouse");
                invCollect.add(tempData);
                if (invFilters == null) {
                    invFilters = filter;
                    continue;
                }
                invFilters.or(filter);
                continue;
            }
            if (!"3".equals(stockSetUpValue)) continue;
            notinvsSet.add(dynamicObject.getLong("stocknumber"));
        }
        QFilter invBalanceQty = new QFilter("material", "in", materialIdSet);
        boolean isFirstCondition = false;
        QFilter filterCondion = null;
        if (!orgsSet.isEmpty()) {
            filterCondion = new QFilter("org", "in", orgsSet);
            isFirstCondition = true;
        }
        if (!notinvsSet.isEmpty()) {
            if (filterCondion == null) {
                filterCondion = new QFilter("warehouse", "not in", notinvsSet);
            } else {
                filterCondion.and("warehouse", "not in", notinvsSet);
            }
            isFirstCondition = true;
        }
        if (invFilters != null) {
            if (isFirstCondition) {
                filterCondion.or(invFilters);
            } else {
                filterCondion = invFilters;
            }
        }
        if (filterCondion != null) {
            invBalanceQty.and(filterCondion);
        }
        DataSet invAccDataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "_InvCost"), (String)"im_inv_realbalance", (String)"material,org,warehouse,location,baseqty", (QFilter[])invBalanceQty.toArray(), null);
        invAccDataSet = invAccDataSet.filter("baseqty != 0  ");
        if (!invCollect.isEmpty()) {
            DataSet invSet = DecumentsPlanUtils.createNewDataSet(invCollect, FIELDS, DATA_TYPES);
            invSet = invSet.groupBy(new String[]{"invId", "stockindex", "wastewarehouse"}).finish();
            DataSet invJoinSet = invSet.filter("stockindex = 0");
            invAccDataSet = invAccDataSet.leftJoin(invJoinSet).on("warehouse", "invId").select(invAccDataSet.getRowMeta().getFieldNames(), new String[]{"wastewarehouse"}).finish();
            DataSet localJoinSet = invSet.filter("stockindex != 0").select("invId,stockindex,wastewarehouse as wastewarehouse1");
            invAccDataSet = invAccDataSet.leftJoin(localJoinSet).on("warehouse", "invId").on("location", "stockindex").select(invAccDataSet.getRowMeta().getFieldNames(), new String[]{"wastewarehouse1"}).finish();
            invAccDataSet = invAccDataSet.select("material,case when wastewarehouse1 !=null then wastewarehouse1 else  wastewarehouse end as wastewarehouse,baseqty");
        } else {
            invAccDataSet = invAccDataSet.select("material,false as wastewarehouse,baseqty");
        }
        invAccDataSet = invAccDataSet.select("material, case  when wastewarehouse !=null and wastewarehouse = true then baseqty else 0 end as baseqty2,case when wastewarehouse!=null and wastewarehouse=true then 0 else baseqty  end as baseqty1");
        invAccDataSet = invAccDataSet.groupBy(new String[]{"material"}).sum("baseqty1").sum("baseqty2").finish();
        return invAccDataSet;
    }

    private static DataSet createNewDataSet(Collection<Object[]> collection, String[] fileds, DataType[] types) {
        Algo algo = Algo.create((String)(algoKey + "_invSet"));
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fileds, (DataType[])types);
        return algo.createDataSet(collection, rowMeta);
    }

    public static DataSet queryProdBilll(Long versionId, Set<Long> materialSet, Set<String> materialNumberSet) {
        QFilter filter = new QFilter("transactiontype.transactiontype.number", "not in", (Object)TRANsACTION_Type_S);
        filter.and("treeentryentity.producttype", "=", (Object)"C");
        filter.and("treeentryentity.bizstatus", "!=", (Object)"C");
        if (materialSet != null) {
            filter.and("treeentryentity.material", "in", materialSet);
        }
        if (materialNumberSet != null) {
            filter.and("treeentryentity.material.number", "in", materialNumberSet);
        }
        DataSet mftOrderSet = SnapshotDataUtils.queryDataSet(algoKey, versionId, "pom_mftorder", " treeentryentity.id as entityId,treeentryentity.material as materialId", filter.toArray());
        ArrayList entityIdList = new ArrayList();
        if (mftOrderSet == null || mftOrderSet.isEmpty()) {
            return null;
        }
        mftOrderSet.forEach(row -> entityIdList.add(row.getLong("entityId")));
        QFilter stockFilter = new QFilter("billstatus", "=", (Object)"C");
        stockFilter.and("orderentryid", "in", entityIdList);
        if (materialSet != null) {
            stockFilter.and("stockentry.materialid", "in", materialSet);
        }
        if (materialNumberSet != null) {
            stockFilter.and("stockentry.materialid.number", "in", materialNumberSet);
        }
        DataSet mftStockSet = SnapshotDataUtils.queryDataSet(algoKey, versionId, "pom_mftstock", "orderentryid,productid,stockentry.materialid as masterid,stockentry.actissueqty-stockentry.rejectedqty+stockentry.feedingqty as baseqty3", stockFilter.toArray());
        mftStockSet = mftStockSet.groupBy(new String[]{"orderentryid", "productid", "masterid"}).sum("baseqty3").finish();
        mftStockSet = mftStockSet.filter("productid = masterid");
        return mftStockSet;
    }

    public static Map<String, Object> getLastRunNumber(long mrpPlan) {
        HashSet<Long> planSet = new HashSet<Long>();
        if (mrpPlan == 0L) {
            QFilter schemeFilter = new QFilter("rpttype", "=", (Object)"mrp_documents_plan");
            schemeFilter.and("enable", "=", (Object)"1");
            schemeFilter.and("status", "=", (Object)"C");
            DynamicObjectCollection billPlanCollection = QueryServiceHelper.query((String)"mrp_rpt_scheme", (String)"planid,planid.fbasedataid_id as mrpPlanId", (QFilter[])schemeFilter.toArray());
            billPlanCollection.forEach(dynamicObject -> {
                if (dynamicObject.getLong("mrpPlanId") != 0L) {
                    planSet.add(dynamicObject.getLong("mrpPlanId"));
                }
            });
        } else {
            planSet.add(mrpPlan);
        }
        QFilter filters = new QFilter("runtype", "=", (Object)"A");
        filters.and(new QFilter("calculatestatus", "=", (Object)"A"));
        if (!planSet.isEmpty()) {
            filters.and("plangram", "in", planSet);
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        DataSet dataSet = ORM.create().queryDataSet(algoKey, "mrp_caculate_log", "number,id,plangram", filters.toArray(), "startdate desc", 1);
        if (!dataSet.isEmpty() && dataSet.hasNext()) {
            Row row = dataSet.next();
            returnMap.put("id", row.getLong("id"));
            returnMap.put("number", row.getString("number"));
        }
        return returnMap;
    }

    private static DataSet createMaterialSet(Map<String, Map<String, Object>> newDataMap) {
        String[] fileds = new String[]{"materialNumber", "supplyOrgNumber"};
        DataType[] fixTypes = new DataType[]{DataType.StringType, DataType.StringType};
        ArrayList<Object[]> coll = new ArrayList<Object[]>(newDataMap.size());
        HashSet<String> meterialNumberSet = new HashSet<String>(newDataMap.size());
        HashSet<String> orgNumberSet = new HashSet<String>(newDataMap.size());
        for (Map<String, Object> map : newDataMap.values()) {
            Object[] object = new Object[]{map.get("materialNumber"), map.get("supplyOrgNumber")};
            coll.add(object);
            meterialNumberSet.add(map.get("materialNumber").toString());
            orgNumberSet.add(map.get("supplyOrgNumber").toString());
        }
        DataSet dataSet = DecumentsPlanUtils.createNewDataSet(coll, fileds, fixTypes);
        DataSet materialSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_material", (String)"id as supmaterial,number,name,modelnum", (QFilter[])new QFilter[]{new QFilter("number", "in", meterialNumberSet)}, null);
        DataSet orgSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_org", (String)"id as supplyorg,number", (QFilter[])new QFilter[]{new QFilter("number", "in", orgNumberSet)}, null);
        dataSet = dataSet.join(materialSet).on("materialNumber", "number").select(dataSet.getRowMeta().getFieldNames(), new String[]{"supmaterial", "name", "modelnum"}).finish();
        dataSet = dataSet.join(orgSet).on("supplyOrgNumber", "number").select(dataSet.getRowMeta().getFieldNames(), new String[]{"supplyorg"}).finish();
        return dataSet;
    }

    private static Map<String, Object> getRptSchemeEffect(DynamicObject schemesObject) {
        HashMap<String, Object> invMap = new HashMap<String, Object>();
        HashSet<Long> goodWarehouseSet = new HashSet<Long>();
        HashSet<Long> goodLocationSet = new HashSet<Long>();
        HashSet<Long> defWarehouseSet = new HashSet<Long>();
        HashSet<Long> defLocationSet = new HashSet<Long>();
        DynamicObjectCollection entityCollection = schemesObject.getDynamicObjectCollection("entryentity");
        if (entityCollection == null || entityCollection.size() == 0) {
            return null;
        }
        for (DynamicObject dynamicObject : entityCollection) {
            String rptFiled = dynamicObject.getString("rptfield");
            DynamicObjectCollection warehouseCollect = dynamicObject.getDynamicObjectCollection("warehouse");
            DynamicObjectCollection locationCollect = dynamicObject.getDynamicObjectCollection("location");
            Set<Long> warehouseSet = new HashSet<Long>();
            HashSet<Long> locationSet = new HashSet();
            boolean isExistVaue = false;
            if (locationCollect != null && locationCollect.size() > 0) {
                isExistVaue = true;
                locationSet = locationCollect.stream().map(localObject -> localObject.getLong("fbasedataid_id")).collect(Collectors.toSet());
            } else if (warehouseCollect != null && warehouseCollect.size() > 0) {
                isExistVaue = true;
                warehouseSet = warehouseCollect.stream().map(warehouseObject -> warehouseObject.getLong("fbasedataid_id")).collect(Collectors.toSet());
            }
            if (!isExistVaue) continue;
            switch (rptFiled) {
                case "goodprodinvqty": {
                    DecumentsPlanUtils.setSetToAll(warehouseSet, locationSet, goodWarehouseSet, goodLocationSet);
                    break;
                }
                case "defprodinvqty": {
                    DecumentsPlanUtils.setSetToAll(warehouseSet, locationSet, defWarehouseSet, defLocationSet);
                    break;
                }
            }
        }
        if (goodWarehouseSet.size() > 0) {
            invMap.put("goodWarehouseSet", goodWarehouseSet);
        }
        if (goodLocationSet.size() > 0) {
            invMap.put("goodLocationSet", goodLocationSet);
        }
        if (defWarehouseSet.size() > 0) {
            invMap.put("defWarehouseSet", defWarehouseSet);
        }
        if (defLocationSet.size() > 0) {
            invMap.put("defLocationSet", defLocationSet);
        }
        return invMap;
    }

    private static void setSetToAll(Set<Long> warehouseSet, Set<Long> locationSet, Set<Long> allWarehouseSet, Set<Long> allLocationSet) {
        if (warehouseSet.size() > 0) {
            allWarehouseSet.addAll(warehouseSet);
        }
        if (locationSet.size() > 0) {
            allLocationSet.addAll(locationSet);
        }
    }

    public static BigDecimal getScaleBigdecimal(BigDecimal bigDecimal, Integer scale, int precisionRound) {
        if (bigDecimal == null) {
            return BigDecimal.ZERO.setScale(0);
        }
        return bigDecimal.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(0) : bigDecimal.setScale((int)scale, precisionRound);
    }

    public static int getRoundValue(String precisionaccount) {
        int roundValue = 4;
        switch (precisionaccount) {
            case "1": {
                roundValue = 4;
                break;
            }
            case "2": {
                roundValue = 1;
                break;
            }
            case "3": {
                roundValue = 0;
                break;
            }
        }
        return roundValue;
    }

    private static DataSet getMaterialPlanInfo(Set<Long> materialIdSet, Set<String> materialNumberSet, DataSet entity1Set) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (materialIdSet != null) {
            statusFilter.and("masterid", "in", materialIdSet);
        }
        if (materialNumberSet != null) {
            statusFilter.and("masterid.number", "in", materialNumberSet);
        }
        String[] entityFiledNames = entity1Set.getRowMeta().getFieldNames();
        DataSet materialPlanSet = QueryServiceHelper.queryDataSet((String)(algoKey + "mpdm_materialplan"), (String)"mpdm_materialplan", (String)"masterid,createorg,ctrlstrategy,operator.id as operator,id as planId,manufacturegroup.entryentity.id as id, manufacturegroup.entryentity.strategynumber.demandmodel as demandmodel ,manufacturegroup.entryentity.priority as priority", (QFilter[])statusFilter.toArray(), null);
        DataSet materialPlanMinSet = materialPlanSet.copy().groupBy(new String[]{"masterid", "createorg"}).maxP("priority", "id").finish();
        DataSet materialPlanShareSet = materialPlanSet.copy().filter("ctrlstrategy=='5'");
        materialPlanSet = materialPlanSet.join(materialPlanMinSet).on("id", "id").on("masterid", "masterid").on("createorg", "createorg").select(materialPlanSet.getRowMeta().getFieldNames()).finish();
        materialPlanSet = materialPlanSet.groupBy(new String[]{"masterid", "demandmodel", "createorg", "operator"}).finish();
        materialPlanSet = materialPlanSet.addField("1", "flag");
        entity1Set = entity1Set.leftJoin(materialPlanSet).on("supmaterial", "masterid").on("supplyorg", "createorg").select(entity1Set.getRowMeta().getFieldNames(), new String[]{"demandmodel", "operator", "flag"}).finish();
        DataSet orgPlanSet = entity1Set.filter(" flag =1");
        DataSet onlyMaterialPlanSet = entity1Set.filter(" flag !=1");
        onlyMaterialPlanSet = onlyMaterialPlanSet.select(entityFiledNames);
        DataSet materialPlanPOnlyOneShareSet = materialPlanShareSet.copy().groupBy(new String[]{"masterid"}).count("couNum").finish().filter("couNum = 1");
        materialPlanShareSet = materialPlanShareSet.leftJoin(materialPlanPOnlyOneShareSet).on("masterid", "masterid").select(materialPlanShareSet.getRowMeta().getFieldNames()).finish().addField("0", "flag");
        onlyMaterialPlanSet = onlyMaterialPlanSet.leftJoin(materialPlanShareSet).on("supmaterial", "masterid").select(onlyMaterialPlanSet.getRowMeta().getFieldNames(), new String[]{"demandmodel", "operator", "flag"}).finish();
        entity1Set = orgPlanSet.union(onlyMaterialPlanSet);
        entity1Set = entity1Set.removeFields(new String[]{"flag"});
        return entity1Set;
    }
}

