/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.rpt.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.mmc.mrp.rpt.enmus.TimeTypeEnum;
import kd.mmc.mrp.rpt.entity.InvQueryRangeInfo;
import kd.mmc.mrp.rpt.entity.RptSchemeInfo;
import kd.mmc.mrp.rpt.entity.TimeColumnInfo;
import kd.mmc.mrp.rpt.entity.TimeTypeInfo;

public class RptUtils {
    public static final Log logger = LogFactory.getLog(RptUtils.class);

    public static DataSet getNewDataSet(String algoKey, DataSet dataSet, String[] fixFields, DataType[] fixFieldsType, Map<String, String> columnMap) {
        LinkedHashMap datas = new LinkedHashMap(8);
        for (Row row : dataSet.copy()) {
            long entryId = row.getLong("entryid");
            if (entryId == 0L) continue;
            LinkedHashMap<String, Object> fieldsMap = (LinkedHashMap<String, Object>)datas.get(entryId);
            if (fieldsMap == null) {
                fieldsMap = new LinkedHashMap<String, Object>(8);
                for (String field : fixFields) {
                    fieldsMap.put(field, row.get(field));
                }
            }
            String fieldKey = row.getString("entryentity.subentryentity.fieldkey") == null ? "" : row.getString("entryentity.subentryentity.fieldkey");
            String fieldCaption = row.getString("entryentity.subentryentity.fieldcaption") == null ? "" : row.getString("entryentity.subentryentity.fieldcaption");
            BigDecimal value = row.getBigDecimal("entryentity.subentryentity.fieldvalue");
            fieldsMap.put(fieldKey, value);
            columnMap.put(fieldKey, fieldCaption);
            datas.put(entryId, fieldsMap);
        }
        Set<String> columnSet = columnMap.keySet();
        ArrayList<StringType> dataTypes = new ArrayList<StringType>(columnSet.size());
        boolean isCreateNew = true;
        for (String column : columnSet) {
            if (StringUtils.isNotBlank((CharSequence)column)) {
                dataTypes.add(DataType.StringType);
                continue;
            }
            isCreateNew = false;
        }
        String[] fields = fixFields;
        DataType[] fieldsType = fixFieldsType;
        if (isCreateNew) {
            fields = (String[])ArrayUtils.addAll((Object[])fixFields, (Object[])columnSet.toArray(new String[0]));
            fieldsType = (DataType[])ArrayUtils.addAll((Object[])fixFieldsType, (Object[])dataTypes.toArray(new DataType[0]));
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields, (DataType[])fieldsType);
        Algo algo = Algo.create((String)algoKey);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        for (Map.Entry next : datas.entrySet()) {
            Map map = (Map)next.getValue();
            Object[] row = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                row[i] = map.get(fields[i]);
            }
            dataSetBuilder.append(row);
        }
        return dataSetBuilder.build();
    }

    public static RptSchemeInfo getRptSchemeInfo(long planId, String rptType) {
        QFilter[] qFilters = new QFilter[]{new QFilter("rpttype", "in", (Object)rptType), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        String selectStr = "id,name,rpttype,starttime,passdate,planid,source,entryentity1.timetype,entryentity1.length,entryentity1.displaydate,entryentity1.issumlast,entryentity1.issumlatest,entryentity.rptfield,entryentity.fieldtype,entryentity.ordersource,entryentity.warehouse,entryentity.location";
        DynamicObject rptSchemeObject = BusinessDataServiceHelper.loadSingle((String)"mrp_rpt_scheme", (String)selectStr, (QFilter[])qFilters);
        if (rptSchemeObject == null) {
            return null;
        }
        return RptUtils.getRptSchemeInfo(rptSchemeObject);
    }

    public static RptSchemeInfo getRptSchemeInfo(DynamicObject rptSchemeObject) {
        RptSchemeInfo rptSchemeInfo = new RptSchemeInfo();
        rptSchemeInfo.setNumber(rptSchemeObject.getString("number"));
        rptSchemeInfo.setName(rptSchemeObject.getString("name"));
        rptSchemeInfo.setRptType(rptSchemeObject.getString("rpttype"));
        rptSchemeInfo.setStartTime(rptSchemeObject.getString("starttime"));
        rptSchemeInfo.setPassDate(rptSchemeObject.getBoolean("passdate"));
        ArrayList<Long> source = new ArrayList<Long>();
        DynamicObjectCollection sourceCol = rptSchemeObject.getDynamicObjectCollection("source");
        sourceCol.forEach(obj -> source.add(obj.getLong("fbasedataid_id")));
        rptSchemeInfo.setSource(source);
        ArrayList<Long> planId = new ArrayList<Long>();
        DynamicObjectCollection planCol = rptSchemeObject.getDynamicObjectCollection("planid");
        planCol.forEach(obj -> planId.add(obj.getLong("fbasedataid_id")));
        rptSchemeInfo.setPlan(planId);
        ArrayList<TimeTypeInfo> timeColumn = new ArrayList<TimeTypeInfo>();
        DynamicObjectCollection timeTypeCol = rptSchemeObject.getDynamicObjectCollection("entryentity1");
        String lastTimeType = "";
        for (DynamicObject dynamicObject : timeTypeCol) {
            String timeType = dynamicObject.getString("timetype");
            TimeTypeInfo timeTypeInfo = new TimeTypeInfo();
            timeTypeInfo.setTimetype(timeType);
            timeTypeInfo.setLength(dynamicObject.getInt("length"));
            timeTypeInfo.setDisplaydate(dynamicObject.getString("displaydate"));
            timeTypeInfo.setLasttype(lastTimeType);
            timeTypeInfo.setIssumlatest(dynamicObject.getBoolean("issumlatest"));
            timeColumn.add(timeTypeInfo);
            lastTimeType = timeType;
        }
        rptSchemeInfo.setTimeColumn(timeColumn);
        ArrayList<InvQueryRangeInfo> invQueryRange = new ArrayList<InvQueryRangeInfo>();
        DynamicObjectCollection invQueryRangeCol = rptSchemeObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : invQueryRangeCol) {
            InvQueryRangeInfo invQueryRangeInfo = new InvQueryRangeInfo();
            invQueryRangeInfo.setRptField(dynamicObject.getString("rptfield"));
            ArrayList<Long> warehouse = new ArrayList<Long>();
            DynamicObjectCollection warehouseCol = dynamicObject.getDynamicObjectCollection("warehouse");
            warehouseCol.forEach(obj -> warehouse.add(obj.getLong("fbasedataid_id")));
            invQueryRangeInfo.setWarehouse(warehouse);
            ArrayList<Long> location = new ArrayList<Long>();
            DynamicObjectCollection locationCol = dynamicObject.getDynamicObjectCollection("location");
            locationCol.forEach(obj -> location.add(obj.getLong("fbasedataid_id")));
            invQueryRangeInfo.setLocation(location);
            invQueryRangeInfo.setFieldType(dynamicObject.getString("fieldtype"));
            invQueryRangeInfo.setOrderSource(dynamicObject.getLong("ordersource_id"));
            invQueryRange.add(invQueryRangeInfo);
        }
        rptSchemeInfo.setInvQueryRange(invQueryRange);
        return rptSchemeInfo;
    }

    public static List<TimeColumnInfo> createTimeColumn(TimeTypeInfo timeTypeInfo, Date beginDate, Date lastestDate, String sequence, boolean isPassDate) throws ParseException {
        if (beginDate == null || lastestDate == null) {
            return new ArrayList<TimeColumnInfo>();
        }
        String timetype = timeTypeInfo.getTimetype();
        SimpleDateFormat keySdf = new SimpleDateFormat("yyyyMMdd");
        beginDate = keySdf.parse(keySdf.format(beginDate));
        if (StringUtils.equals((CharSequence)TimeTypeEnum.Day.getValue(), (CharSequence)timetype)) {
            return RptUtils.createDayColumns(timeTypeInfo, beginDate, lastestDate, sequence, isPassDate);
        }
        if (StringUtils.equals((CharSequence)TimeTypeEnum.Week.getValue(), (CharSequence)timetype)) {
            return RptUtils.createWeekColumns(timeTypeInfo, beginDate, lastestDate, sequence, isPassDate);
        }
        if (StringUtils.equals((CharSequence)TimeTypeEnum.Month.getValue(), (CharSequence)timetype)) {
            return RptUtils.createMonthColumns(timeTypeInfo, beginDate, lastestDate, sequence, isPassDate);
        }
        return new ArrayList<TimeColumnInfo>();
    }

    public static List<TimeColumnInfo> createDayColumns(TimeTypeInfo timeTypeInfo, Date beginDate, Date lastestDate, String sequence, boolean isPassDate) throws ParseException {
        ArrayList<TimeColumnInfo> timeColumnInfoList = new ArrayList<TimeColumnInfo>(8);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat keySdf = new SimpleDateFormat("yyyyMMdd");
        if (isPassDate) {
            Date startTime = sdf.parse("1900/01/01");
            TimeColumnInfo timeColumnInfo = new TimeColumnInfo("pasedate", ResManager.loadKDString((String)"\u8fc7\u53bb\u65e5\u671f", (String)"RptUtils_0", (String)"mmc-mrp-common", (Object[])new Object[0]), "0", startTime, beginDate);
            timeColumnInfoList.add(timeColumnInfo);
        }
        int length = timeTypeInfo.getLength();
        if (timeTypeInfo.isIssumlatest()) {
            long days = (lastestDate.getTime() - beginDate.getTime()) / 86400000L;
            length = (int)days + 1;
        }
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < length; ++i) {
            calendar.setTime(beginDate);
            calendar.add(6, i);
            Date startTime = calendar.getTime();
            calendar.add(6, 1);
            Date endTime = calendar.getTime();
            String caption = sdf.format(startTime);
            String key = "key" + keySdf.format(startTime) + sequence;
            TimeColumnInfo timeColumnInfo = new TimeColumnInfo(key, caption, sequence, startTime, endTime);
            timeColumnInfoList.add(timeColumnInfo);
        }
        return timeColumnInfoList;
    }

    public static List<TimeColumnInfo> createWeekColumns(TimeTypeInfo timeTypeInfo, Date beginDate, Date lastestDate, String sequence, boolean isPassDate) throws ParseException {
        int dayOfWeek;
        Calendar calendar;
        ArrayList<TimeColumnInfo> timeColumnInfoList = new ArrayList<TimeColumnInfo>(8);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat keySdf = new SimpleDateFormat("yyyyMMdd");
        if (isPassDate) {
            Date startTime = sdf.parse("1900/01/01");
            TimeColumnInfo timeColumnInfo = new TimeColumnInfo("pasedate", ResManager.loadKDString((String)"\u8fc7\u53bb\u65e5\u671f", (String)"RptUtils_0", (String)"mmc-mrp-common", (Object[])new Object[0]), "0", startTime, beginDate);
            timeColumnInfoList.add(timeColumnInfo);
        }
        int length = timeTypeInfo.getLength();
        if (timeTypeInfo.isIssumlatest()) {
            calendar = Calendar.getInstance();
            calendar.setTime(beginDate);
            dayOfWeek = calendar.get(7);
            int addDay = dayOfWeek == 1 ? 0 : calendar.getFirstDayOfWeek() - dayOfWeek + 6;
            calendar.add(6, addDay);
            Date beginSunday = calendar.getTime();
            calendar.setTime(lastestDate);
            dayOfWeek = calendar.get(7);
            addDay = dayOfWeek == 1 ? 0 : calendar.getFirstDayOfWeek() - dayOfWeek + 6;
            calendar.add(6, addDay);
            Date endSunday = calendar.getTime();
            long weeks = (endSunday.getTime() - beginSunday.getTime()) / 604800000L;
            length = (int)(weeks + 1L);
        }
        calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(beginDate);
        dayOfWeek = calendar.get(7);
        if (dayOfWeek == 1) {
            dayOfWeek = 8;
        }
        calendar.add(6, calendar.getFirstDayOfWeek() - dayOfWeek);
        Date firstMonday = calendar.getTime();
        calendar.add(6, 7);
        Date firstSunday = calendar.getTime();
        for (int i = 0; i < length; ++i) {
            calendar.setTime(firstMonday);
            calendar.add(6, i * 7);
            Date startTime = calendar.getTime();
            calendar.setTime(firstSunday);
            calendar.add(6, i * 7);
            Date endTime = calendar.getTime();
            calendar.add(6, -1);
            Date displayDate = calendar.getTime();
            String caption = sdf.format(beginDate) + "-" + sdf.format(displayDate);
            String key = "key" + keySdf.format(startTime) + sequence;
            TimeColumnInfo timeColumnInfo = new TimeColumnInfo(key, caption, sequence, beginDate, endTime);
            timeColumnInfoList.add(timeColumnInfo);
            beginDate = endTime;
        }
        return timeColumnInfoList;
    }

    public static List<TimeColumnInfo> createMonthColumns(TimeTypeInfo timeTypeInfo, Date beginDate, Date lastestDate, String sequence, boolean isPassDate) throws ParseException {
        ArrayList<TimeColumnInfo> timeColumnInfoList = new ArrayList<TimeColumnInfo>(8);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat keySdf = new SimpleDateFormat("yyyyMMdd");
        if (isPassDate) {
            Date startTime = sdf.parse("1900/01/01");
            TimeColumnInfo timeColumnInfo = new TimeColumnInfo("pasedate", ResManager.loadKDString((String)"\u8fc7\u53bb\u65e5\u671f", (String)"RptUtils_0", (String)"mmc-mrp-common", (Object[])new Object[0]), "0", startTime, beginDate);
            timeColumnInfoList.add(timeColumnInfo);
        }
        int length = timeTypeInfo.getLength();
        Calendar calendar = Calendar.getInstance();
        if (timeTypeInfo.isIssumlatest()) {
            Calendar start = Calendar.getInstance();
            Calendar end = Calendar.getInstance();
            start.setTime(beginDate);
            end.setTime(lastestDate);
            int result = end.get(2) - start.get(2);
            int month = (end.get(1) - start.get(1)) * 12;
            length = Math.abs(result + month) + 1;
        }
        Date firstMonth = beginDate;
        for (int i = 0; i < length; ++i) {
            calendar.setTime(firstMonth);
            calendar.set(5, 1);
            calendar.add(2, i);
            Date startTime = calendar.getTime();
            calendar.add(2, 1);
            Date endTime = calendar.getTime();
            calendar.add(6, -1);
            Date monthEndDay = calendar.getTime();
            String caption = sdf.format(beginDate) + "-" + sdf.format(monthEndDay);
            String key = "key" + keySdf.format(startTime) + sequence;
            TimeColumnInfo timeColumnInfo = new TimeColumnInfo(key, caption, sequence, beginDate, endTime);
            timeColumnInfoList.add(timeColumnInfo);
            beginDate = endTime;
        }
        return timeColumnInfoList;
    }

    public static Map<String, Object> createParams(RptSchemeInfo rptSchemeInfo, Date historyEarlyDate, Date lastestDate) throws ParseException {
        TimeColumnInfo timeColumnInfo;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        List<TimeTypeInfo> timeColumn = rptSchemeInfo.getTimeColumn();
        TimeTypeInfo firstTimeType = timeColumn.get(0);
        Date beginDate = new Date();
        Date endDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        beginDate = sdf.parse(sdf.format(beginDate));
        endDate = sdf.parse(sdf.format(endDate));
        String startTimeType = rptSchemeInfo.getStartTime();
        if (StringUtils.equals((CharSequence)"B", (CharSequence)startTimeType)) {
            beginDate = historyEarlyDate;
        }
        boolean isPassDate = rptSchemeInfo.isPassDate();
        ArrayList<TimeColumnInfo> allTimeList = new ArrayList<TimeColumnInfo>(8);
        List<TimeColumnInfo> firstTimeList = RptUtils.createTimeColumn(firstTimeType, beginDate, lastestDate, "1", isPassDate);
        if (firstTimeList.size() > 0) {
            Date firstEndDate;
            timeColumnInfo = firstTimeList.get(firstTimeList.size() - 1);
            beginDate = firstEndDate = timeColumnInfo.getEndTime();
            endDate = firstEndDate;
        }
        allTimeList.addAll(firstTimeList);
        boolean issumlatest = firstTimeType.isIssumlatest();
        if (!issumlatest) {
            TimeTypeInfo secondTimeType = timeColumn.get(1);
            List<TimeColumnInfo> secondTimeList = RptUtils.createTimeColumn(secondTimeType, beginDate, lastestDate, "2", false);
            if (secondTimeList.size() > 0) {
                Date secondEndDate;
                timeColumnInfo = secondTimeList.get(secondTimeList.size() - 1);
                beginDate = secondEndDate = timeColumnInfo.getEndTime();
                endDate = secondEndDate;
            }
            allTimeList.addAll(secondTimeList);
            issumlatest = secondTimeType.isIssumlatest();
            if (!issumlatest) {
                TimeTypeInfo thridTimeType = timeColumn.get(2);
                List<TimeColumnInfo> thridTimeList = RptUtils.createTimeColumn(thridTimeType, beginDate, lastestDate, "3", false);
                allTimeList.addAll(thridTimeList);
                if (thridTimeList.size() > 0) {
                    timeColumnInfo = thridTimeList.get(thridTimeList.size() - 1);
                    endDate = timeColumnInfo.getEndTime();
                }
            }
        }
        ArrayList<String> trendsFields = new ArrayList<String>(8);
        ArrayList<BigDecimalType> trendsTypes = new ArrayList<BigDecimalType>(8);
        LinkedHashMap<String, String> keyToCaption = new LinkedHashMap<String, String>(8);
        LinkedHashMap<String, String> keyToSequence = new LinkedHashMap<String, String>(8);
        LinkedHashMap<String, Date> keyToStartTime = new LinkedHashMap<String, Date>(8);
        LinkedHashMap<String, Date> keyToEndTime = new LinkedHashMap<String, Date>(8);
        for (TimeColumnInfo columnInfo : allTimeList) {
            String key = columnInfo.getKey();
            String caption = columnInfo.getCaption();
            String sequence = columnInfo.getSequence();
            Date startTime = columnInfo.getStartTime();
            Date endTime = columnInfo.getEndTime();
            keyToCaption.put(key, caption);
            keyToSequence.put(key, sequence);
            keyToStartTime.put(key, startTime);
            keyToEndTime.put(key, endTime);
            trendsFields.add(key);
            trendsTypes.add(DataType.BigDecimalType);
        }
        params.put("trendsFields", trendsFields);
        params.put("trendsTypes", trendsTypes);
        params.put("keyToCaption", keyToCaption);
        params.put("keyToSequence", keyToSequence);
        params.put("keyToStartTime", keyToStartTime);
        params.put("keyToEndTime", keyToEndTime);
        params.put("endDate", endDate);
        return params;
    }

    public static List<String> transformTimeFilters(FilterItemInfo item) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        String propName = item.getPropName();
        String compareType = item.getCompareType();
        Object value = item.getValue();
        ArrayList<String> filters = new ArrayList<String>();
        Date date = new Date();
        date = sdf.parse(sdf.format(date));
        switch (compareType) {
            case "TODAY": {
                filters.add("to_char(" + propName + ",'yyyy-MM-dd') = '" + sdf.format(date) + "'");
                break;
            }
            case "THISWEEK": {
                calendar.setTime(date);
                calendar.set(7, 2);
                filters.add("" + propName + ">= to_date('" + sdf.format(calendar.getTime()) + "','yyyy-MM-dd') ");
                break;
            }
            case "THISMONTH": {
                calendar.setTime(date);
                calendar.set(5, 1);
                filters.add("" + propName + ">= to_date('" + sdf.format(calendar.getTime()) + "','yyyy-MM-dd') ");
                break;
            }
            case "LASTMONTH": {
                calendar.setTime(date);
                calendar.set(5, 1);
                Date thisMonthFirst = calendar.getTime();
                calendar.add(2, -1);
                calendar.set(5, 1);
                Date lastMonthFirst = calendar.getTime();
                filters.add("" + propName + ">= to_date('" + sdf.format(lastMonthFirst) + "','yyyy-MM-dd') and " + propName + "< to_date('" + sdf.format(thisMonthFirst) + "','yyyy-MM-dd')");
                break;
            }
            case "LASTTHREEMONTH": {
                calendar.setTime(date);
                calendar.add(2, -3);
                Date lastThreeMonth = calendar.getTime();
                filters.add("" + propName + ">= to_date('" + sdf.format(lastThreeMonth) + "','yyyy-MM-dd') ");
                break;
            }
            case "=": {
                filters.add("to_char(" + propName + ",'yyyy-MM-dd') = '" + value + "'");
                break;
            }
            case "BETWEEN": {
                if (!(value instanceof ArrayList)) break;
                ArrayList arrayList = (ArrayList)value;
                date = sdf.parse((String)arrayList.get(1));
                calendar.setTime(date);
                calendar.add(6, 1);
                String endTime = sdf.format(calendar.getTime());
                filters.add("" + propName + ">= to_date('" + arrayList.get(0) + "','yyyy-MM-dd') and " + propName + "< to_date('" + endTime + "','yyyy-MM-dd')");
                break;
            }
        }
        return filters;
    }

    public static List<String> transformTextFilters(FilterItemInfo item) {
        String propName = item.getPropName();
        String compareType = item.getCompareType();
        Object value = item.getValue();
        ArrayList<String> filters = new ArrayList<String>();
        switch (compareType) {
            case "LIKE": 
            case "NOT LIKE": {
                filters.add(propName + " " + compareType + " '%" + value + "%' ");
                break;
            }
            case "=": 
            case "<>": {
                filters.add(propName + " " + compareType + " '" + value + "' ");
                break;
            }
            case "lIKE": {
                filters.add(propName + " " + compareType + " '" + value + "%' ");
                break;
            }
            case "like": {
                filters.add(propName + " " + compareType + " '%" + value + "' ");
                break;
            }
            case "ISNULL": {
                filters.add(propName + " is null");
                break;
            }
            case "NOTISNULL": {
                filters.add(propName + " is not null");
                break;
            }
            case "IN": {
                if (value instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)value;
                    StringBuilder inValue = new StringBuilder();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (i == 0) {
                            inValue.append('\'').append(arrayList.get(i)).append('\'');
                            continue;
                        }
                        inValue.append(",'").append(arrayList.get(i)).append('\'');
                    }
                    filters.add(propName + " in (" + inValue + ")");
                    break;
                }
                filters.add(propName + " = '" + value + "' ");
                break;
            }
        }
        return filters;
    }

    public static long getLatestPlanId(String algoKey, String rptType) {
        DataSet dataSet;
        HashSet planSet = new HashSet();
        long planId = 0L;
        QFilter schemeFilter = new QFilter("rpttype", "=", (Object)rptType);
        schemeFilter.and("enable", "=", (Object)"1");
        schemeFilter.and("status", "=", (Object)"C");
        DynamicObjectCollection billPlanCollection = QueryServiceHelper.query((String)"mrp_rpt_scheme", (String)"planid,planid.fbasedataid_id as mrpPlanId", (QFilter[])schemeFilter.toArray());
        billPlanCollection.forEach(dynamicObject -> {
            if (dynamicObject.getLong("mrpPlanId") != 0L) {
                planSet.add(dynamicObject.getLong("mrpPlanId"));
            }
        });
        QFilter filters = new QFilter("runtype", "=", (Object)"A");
        filters.and(new QFilter("calculatestatus", "=", (Object)"A"));
        filters.and(new QFilter("clearstatus", "!=", (Object)Character.valueOf('B')));
        filters.and(new QFilter("operatmodekey", "!=", (Object)"mrp_simulation"));
        if (!planSet.isEmpty()) {
            filters.and("plangram", "in", planSet);
        }
        if ((dataSet = ORM.create().queryDataSet(algoKey, "mrp_caculate_log", "number,id,plangram", filters.toArray(), "startdate desc", 1)).hasNext()) {
            Row row = dataSet.next();
            planId = row.getLong("id");
        }
        return planId;
    }

    public static DataSet resolveInvQueryRangeInfo(String algoKey, InvQueryRangeInfo invQueryRangeInfo, RowMeta rowMeta) {
        String[] fields = rowMeta.getFieldNames();
        DataSetBuilder dataSetBuilder = Algo.create((String)algoKey).createDataSetBuilder(rowMeta);
        String fieldType = invQueryRangeInfo.getFieldType();
        if (!StringUtils.equals((CharSequence)"delivery", (CharSequence)fieldType)) {
            return dataSetBuilder.build();
        }
        long orderSource = invQueryRangeInfo.getOrderSource();
        if (orderSource == 0L) {
            return dataSetBuilder.build();
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1"), new QFilter("id", "=", (Object)orderSource)};
        DynamicObject resource_register = QueryServiceHelper.queryOne((String)"mrp_resourceregister_cf", (String)"id", (QFilter[])qFilters);
        if (resource_register == null) {
            return dataSetBuilder.build();
        }
        QFilter qFilter = new QFilter("cgnumber", "=", (Object)resource_register.getLong("id"));
        DynamicObjectCollection resourceConf = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject res : resourceConf) {
            DataSet dataSet = RptUtils.queryDatasByResId(algoKey, res.getLong("id"));
            if (dataSet == null) {
                return dataSetBuilder.build();
            }
            dataSet.forEach(row -> {
                Object[] value = new Object[]{row.getLong("entryentity.material"), row.getBigDecimal("entryentity.qty")};
                dataSetBuilder.append(value);
            });
        }
        return dataSetBuilder.build().groupBy(new String[]{fields[0]}).sum(fields[1], invQueryRangeInfo.getRptField()).finish();
    }

    public static DataSet queryDatasByResId(String algoKey, Long resourceConfId) {
        ORM orm = ORM.create();
        DynamicObject resourceConf = BusinessDataServiceHelper.loadSingle((Object)resourceConfId, (String)"mrp_resource_dataconfig");
        DynamicObject fieldMapping = resourceConf.getDynamicObject("billfieldtransfer");
        DynamicObject fromBillEntity = (fieldMapping = BusinessDataServiceHelper.loadSingle((Object)fieldMapping.getLong("id"), (String)"mrp_billfieldtransfer")).getDynamicObject("srcbill");
        if (fromBillEntity == null) {
            return null;
        }
        DynamicObject toEntity = fieldMapping.getDynamicObject("destbill");
        if (toEntity == null) {
            return null;
        }
        MainEntityType fromBillMainType = (MainEntityType)orm.getDataEntityType(fromBillEntity.getString("id"));
        QFilter filter = RptUtils.getFilter(resourceConf, fromBillMainType);
        DynamicObjectCollection fielMappingEntry = fieldMapping.getDynamicObjectCollection("entryentity");
        if (fielMappingEntry == null || fielMappingEntry.isEmpty()) {
            return null;
        }
        HashSet<String> mappingToFields = new HashSet<String>();
        String oqlFields = RptUtils.getSelectFields(fielMappingEntry, resourceConf, mappingToFields);
        return orm.queryDataSet(algoKey, fromBillMainType.getName(), oqlFields, new QFilter[]{filter}, null);
    }

    public static QFilter getFilter(DynamicObject resourceConf, MainEntityType fromBillMainType) {
        QFilter filter = null;
        String filterContent = resourceConf.getString("filter_tag");
        if (!StringUtils.isEmpty((CharSequence)filterContent)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterContent, FilterCondition.class);
            FilterBuilder fb = new FilterBuilder(fromBillMainType, filterCondition);
            TimeService timeService = new TimeService();
            fb.setTimeService((ITimeService)timeService);
            UserService userService = new UserService();
            fb.setUserService((IUserService)userService);
            fb.buildFilter(false);
            filter = fb.getQFilter();
        }
        return filter;
    }

    public static String getSelectFields(DynamicObjectCollection fielMappingEntry, DynamicObject resourceConf, Set<String> mappingToFields) {
        StringBuilder oqlFields = new StringBuilder();
        for (DynamicObject mapping : fielMappingEntry) {
            String fromField = mapping.getString("sourcefieldflag");
            String toField = mapping.getString("destfieldflag");
            mappingToFields.add(toField);
            if (!StringUtils.isEmpty((CharSequence)fromField)) {
                oqlFields.append(fromField).append(" as ").append(toField).append(", ");
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)fromField)) continue;
            String formula = mapping.getString("calculateexc_tag");
            boolean isUnSet = StringUtils.isEmpty((CharSequence)formula);
            Map jo = isUnSet ? null : (Map)SerializationUtils.fromJsonString((String)formula, Map.class);
            String string = fromField = jo == null ? null : jo.get("expression").toString();
            if (fromField == null) {
                throw new KDBizException(new ErrorCode("EMPTY_FIELD_CONTENT", String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u201c%1$s, id: %2$s\u201d\u7684\u53d6\u6570\u8bbe\u7f6e\u201c%3$s, id: %4$s\u201d\u5b57\u6bb5\u201c%5$s\u201d\u672a\u8bbe\u7f6e\u3002", (String)"RptUtils_2", (String)"mmc-mrp-common", (Object[])new Object[0]), resourceConf.getString("name"), resourceConf.getString("id"), resourceConf.getString("name"), resourceConf.getString("id"), toField)), new Object[0]);
            }
            if ("true".equalsIgnoreCase(fromField.trim())) {
                fromField = "1";
            } else if ("false".equalsIgnoreCase(fromField.trim())) {
                fromField = "0";
            }
            if (StringUtils.isEmpty((CharSequence)fromField)) continue;
            oqlFields.append('(').append(fromField).append(") as ").append(toField).append(", ");
        }
        return oqlFields.deleteCharAt(oqlFields.length() - 2).toString();
    }
}

