/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.mrp.business.helper.MRPInitHelper;
import kd.mmc.mrp.business.helper.PlanViewOrgHelper;
import kd.mmc.mrp.common.enums.InitContextEnum;

public class MRPInitDataList
extends AbstractListPlugin {
    private static final String INIT_CONFIG = "init_config";
    private static final String INIT = "init";
    private static final String REFRESH = "refresh";
    private static final String MRP_INITDATA = "mrp_initdata";
    private static final String CALC_PLAN_ID = "calcPlanId";
    private static final String INIT_IDS = "init_ids";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ArrayList<Object> orgPks = new ArrayList<Object>(16);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn columnFilter = (CommonFilterColumn)filterColumn;
            if (!columnFilter.getFieldName().startsWith("org")) continue;
            Set orgIds = PlanViewOrgHelper.getOrgIdsByPlanView();
            Long uid = RequestContext.get().getCurrUserId();
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)uid, (String)BizAppServiceHelp.getAppIdByAppNumber((String)"mrp"), (String)MRP_INITDATA, (String)"47150e89000000ac");
            columnFilter.getComboItems().clear();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            ArrayList<QFilter> qfilters = new ArrayList<QFilter>(3);
            QFilter permFilter = null;
            if (!result.hasAllOrgPerm()) {
                permFilter = new QFilter("id", "in", (Object)result.getHasPermOrgs());
                qfilters.add(permFilter);
            }
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIds);
            qfilters.add(enableFilter);
            qfilters.add(pkFilter);
            Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])qfilters.toArray(new QFilter[0]));
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bos_org");
            DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)mainEntityType, null);
            if (orgMap != null) {
                orgColl.addAll(orgMap.values());
            }
            for (DynamicObject org2 : orgColl) {
                Object orgPk = org2.getPkValue();
                orgPks.add(orgPk);
                comboItems.add(new ComboItem(new LocaleString(org2.getLocaleString("name").toString()), orgPk.toString()));
            }
            columnFilter.setComboItems(comboItems);
            ArrayList<String> defaultOrg = new ArrayList<String>();
            long currentOrgId = RequestContext.get().getOrgId();
            boolean match = orgPks.stream().map(org -> Long.valueOf(org.toString())).anyMatch(org -> org.equals(currentOrgId));
            if (!ObjectUtils.isEmpty((Object)orgColl)) {
                defaultOrg.add(match ? String.valueOf(currentOrgId) : String.valueOf(((DynamicObject)orgColl.get(0)).getPkValue()));
            } else {
                defaultOrg.add(String.valueOf(0));
            }
            columnFilter.setDefaultValues(defaultOrg);
            break;
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field != null && field.contains("org")) {
            Set orgIds = PlanViewOrgHelper.getOrgIdsByPlanView();
            QFilter orgFilter = new QFilter("id", "in", (Object)orgIds);
            args.addCustomQFilter(orgFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String key = op.getOperateKey();
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (StringUtils.equalsIgnoreCase((CharSequence)op.getType(), (CharSequence)"donothing") && !this.checkUseOrg(selectedMainOrgIds, args)) {
            return;
        }
        Long useOrgId = (Long)selectedMainOrgIds.get(0);
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)INIT)) {
            StringBuilder msg = new StringBuilder();
            StringBuilder grassMsg = new StringBuilder();
            StringBuilder calcMsg = new StringBuilder();
            List<Long> ids = this.getPkValues(selectedRows);
            QFilter qFilter = new QFilter("id", "in", ids);
            Long calcId = 0L;
            boolean isHavMTO = false;
            Long mtoId = 0L;
            QFilter globalFilter = new QFilter("entryentity.runtype", "=", (Object)"mrp_globalplan");
            QFilter simulationFilter = new QFilter("entryentity.runtype", "=", (Object)"mrp_simulation");
            QFilter selectPlanFilter = new QFilter("entryentity.runtype", "=", (Object)"mrp_selectbillplan");
            QFilter selectMaterialFilter = new QFilter("entryentity.runtype", "=", (Object)"mrp_selectmaterialplan");
            QFilter qtFilter = new QFilter("entryentity.runtype", "=", (Object)"mrp_cps_runner");
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)MRP_INITDATA, (String)"id,inittype,initstatus", (QFilter[])new QFilter[]{qFilter}, null);){
                while (dataSet.hasNext()) {
                    Row row1 = dataSet.next();
                    String inittype = row1.getString("inittype");
                    String initstatus = row1.getString("initstatus");
                    Long id = row1.getLong("id");
                    InitContextEnum initContextEnum = InitContextEnum.fromName((String)inittype);
                    if (initContextEnum == InitContextEnum.AlgoModule || initContextEnum == InitContextEnum.QTAlgoModule) {
                        StringBuilder type = new StringBuilder();
                        if (initContextEnum == InitContextEnum.AlgoModule) {
                            this.appendCalcTypeMsg(type, useOrgId, globalFilter, ResManager.loadKDString((String)"\u3010\u5168\u5c40\u8ba1\u5212\u3011", (String)"MRPInitDataList_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                            this.appendCalcTypeMsg(type, useOrgId, simulationFilter, ResManager.loadKDString((String)"\u3010\u6a21\u62df\u8ba1\u5212\u3011", (String)"MRPInitDataList_8", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                            this.appendCalcTypeMsg(type, useOrgId, selectPlanFilter, ResManager.loadKDString((String)"\u3010\u9009\u5355\u8ba1\u5212\u3011", (String)"MRPInitDataList_9", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                            this.appendCalcTypeMsg(type, useOrgId, selectMaterialFilter, ResManager.loadKDString((String)"\u3010\u9009\u6599\u8ba1\u5212\u3011", (String)"MRPInitDataList_10", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                        } else {
                            this.appendCalcTypeMsg(type, useOrgId, qtFilter, ResManager.loadKDString((String)"\u3010\u9f50\u5957\u5206\u6790\u3011", (String)"MRPInitDataList_11", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                        }
                        if (type.length() <= 0) continue;
                        calcMsg.append(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u65b9\u6848\u914d\u7f6e\u5b58\u5728\u8fd0\u884c\u65b9\u5f0f\u4e3a%1$s\uff0c\u4e14\u5df2\u5ba1\u6838\u3001\u53ef\u7528\u7684\u6570\u636e\uff0c\u4e0d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\u3002%2$s\u7b97\u6cd5\u6a21\u578b\u4e2d\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u3001\u7b97\u6cd5\u6ce8\u518c\u914d\u7f6e\u5df2\u521d\u59cb\u5316\uff0c\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u521d\u59cb\u5316\uff1f\u5982\u9009\u62e9\u662f\uff0c\u5219\u8986\u76d6\u5df2\u6709\u6570\u636e\u3002", (String)"MRPInitDataList_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), type.toString(), "\r\n"));
                        calcId = id;
                        continue;
                    }
                    if (initContextEnum == InitContextEnum.GrossDemand && this.checkIsExist("mrp_grossdemand_define", useOrgId, false, null)) {
                        grassMsg.append(ResManager.loadKDString((String)"\u6bdb\u9700\u6c42\u5b9a\u4e49\u5b58\u5728\u53ef\u7528\u7684\u6570\u636e\uff0c\u4e0d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\u3002", (String)"MRPInitDataList_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                        ids.remove(id);
                        continue;
                    }
                    if (initContextEnum == InitContextEnum.MTOStrategy) {
                        isHavMTO = true;
                        mtoId = id;
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)initstatus, (CharSequence)"1")) continue;
                    if (msg.length() > 0) {
                        msg.append('\uff0c');
                    }
                    msg.append(inittype);
                }
            }
            if (ids.isEmpty()) {
                this.getView().showMessage(grassMsg.toString());
                args.setCancel(true);
                return;
            }
            if (isHavMTO) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5236\u9020\u7b56\u7565\u4e0d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u5ffd\u7565\u8be5\u521d\u59cb\u5316\u9879\u3002", (String)"MRPInitDataList_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                ids.remove(mtoId);
            }
            this.getPageCache().put(CALC_PLAN_ID, calcId.toString());
            this.getPageCache().put(INIT_IDS, SerializationUtils.toJsonString(ids));
            if (msg.length() > 0 || grassMsg.length() > 0 || calcMsg.length() > 0) {
                if (msg.length() > 0) {
                    msg.append(ResManager.loadKDString((String)"\u5df2\u521d\u59cb\u5316\uff0c\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u521d\u59cb\u5316\uff1f\u5982\u9009\u62e9\u662f\uff0c\u5219\u8986\u76d6\u5df2\u6709\u6570\u636e\u3002", (String)"MRPInitDataList_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                }
                ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(key, (IFormPlugin)this);
                confirmCallBack.setView(this.getView());
                StringBuilder tip = new StringBuilder();
                if (grassMsg.length() > 0) {
                    tip.append((CharSequence)grassMsg).append("\r\n");
                }
                if (calcMsg.length() > 0) {
                    tip.append((CharSequence)calcMsg).append("\r\n");
                }
                if (msg.length() > 0) {
                    tip.append((CharSequence)msg).append("\r\n");
                }
                this.getView().showConfirm(tip.toString(), MessageBoxOptions.YesNo, confirmCallBack);
                args.setCancel(true);
                return;
            }
        }
    }

    private void appendCalcTypeMsg(StringBuilder type, long useOrgId, QFilter filter, String msg) {
        if (this.checkIsExist("mrp_calplanconfig", useOrgId, true, filter)) {
            if (type.length() > 0) {
                type.append('\uff0c');
            }
            type.append(msg);
        }
    }

    private boolean checkUseOrg(List<Long> selectedMainOrgIds, BeforeDoOperationEventArgs args) {
        if (selectedMainOrgIds.size() != 1 || selectedMainOrgIds.get(0).equals(0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u7ec4\u7ec7\u3002", (String)"MRPInitDataList_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private List<Long> getPkValues(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> ids = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long id = (Long)row.getPrimaryKeyValue();
            ids.add(id);
        }
        return ids;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)INIT_CONFIG) && e.getOperationResult().isSuccess()) {
            this.invokeInitConfigOp();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)INIT) && e.getOperationResult().isSuccess()) {
            this.invokeInitOp();
        }
    }

    private void invokeInitConfigOp() {
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        if (selectedMainOrgIds.isEmpty()) {
            return;
        }
        MRPInitHelper.initConfigData((long)((Long)selectedMainOrgIds.get(0)));
        this.getView().invokeOperation(REFRESH);
    }

    private void invokeInitOp() {
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        List ids = null;
        if (!selectedMainOrgIds.isEmpty()) {
            String jsonStr;
            Long useOrgId = (Long)selectedMainOrgIds.get(0);
            String calcStr = this.getPageCache().get(CALC_PLAN_ID);
            long calcId = 0L;
            if (StringUtils.isNotBlank((CharSequence)calcStr)) {
                calcId = Long.parseLong(calcStr);
            }
            if (StringUtils.isNotBlank((CharSequence)(jsonStr = this.getPageCache().get(INIT_IDS)))) {
                ids = SerializationUtils.fromJsonStringToList((String)jsonStr, Long.class);
            }
            if (ids == null || ids.isEmpty()) {
                return;
            }
            MRPInitHelper.initMrpData((long)useOrgId, (List)ids, (long)calcId, (String)this.getView().getFormShowParameter().getAppId());
        }
        this.getView().invokeOperation(REFRESH);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"MRPInitDataList_5", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
    }

    private boolean checkIsExist(String entity, long org, boolean isCheckStatus, QFilter otherFilter) {
        QFilter qFilter = new QFilter("createorg", "=", (Object)org);
        if (isCheckStatus) {
            qFilter.and(new QFilter("status", "=", (Object)"C"));
        }
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        if (otherFilter != null) {
            qFilter.and(otherFilter);
        }
        return QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{qFilter});
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && INIT.equals(e.getCallBackId())) {
            this.invokeInitOp();
        }
    }
}

