/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class MrpImportFilePlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String Key_FileName = "filename";
    private static final String Key_FilePanel = "filepanel";
    private static final String Key_btnOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_btnOK});
        AttachmentPanel filePanel = (AttachmentPanel)this.getControl(Key_FilePanel);
        filePanel.addUploadListener((UploadListener)this);
    }

    public void afterUpload(UploadEvent evt) {
        List<String> uploadFileUrls = this.getUploadFileUrls(evt);
        String fieldValue = (String)this.getModel().getValue(Key_FileName);
        String[] fieldValues = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            fieldValues = StringUtils.split((String)fieldValue, (String)";");
        }
        HashSet<String> fileUrls = new HashSet<String>(uploadFileUrls.size());
        for (String fileUrl : uploadFileUrls) {
            fileUrls.add(fileUrl);
        }
        for (String fileUrl : fieldValues) {
            fileUrls.add(fileUrl);
        }
        fieldValue = StringUtils.join((Object[])fileUrls.toArray(), (String)";");
        this.getModel().setValue(Key_FileName, (Object)fieldValue);
    }

    public void afterRemove(UploadEvent evt) {
        String fieldValue = (String)this.getModel().getValue(Key_FileName);
        String[] fieldValues = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            fieldValues = StringUtils.split((String)fieldValue, (String)";");
        }
        HashSet<String> fileUrls = new HashSet<String>(fieldValues.length);
        for (String fileUrl : fieldValues) {
            fileUrls.add(fileUrl);
        }
        List<String> removeFileUrls = this.getUploadFileUrls(evt);
        for (String fileUrl : removeFileUrls) {
            fileUrls.remove(fileUrl);
        }
        fieldValue = StringUtils.join((Object[])fileUrls.toArray(), (String)";");
        this.getModel().setValue(Key_FileName, (Object)fieldValue);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        if (srcCtrl.getKey().equalsIgnoreCase(Key_btnOK)) {
            this.doOK();
        }
    }

    private void doOK() {
        String fileNames = (String)this.getModel().getValue(Key_FileName);
        if (StringUtils.isBlank((CharSequence)fileNames)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9700\u8981\u5bfc\u5165\u7684\u89c4\u5219\u6587\u4ef6(*.zip)\u3002", (String)"MrpImportFilePlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)fileNames);
        this.getView().close();
    }

    private List<String> getUploadFileUrls(UploadEvent evt) {
        ArrayList<String> fileUrls = new ArrayList<String>(evt.getUrls().length);
        for (Object url : evt.getUrls()) {
            fileUrls.add((String)((Map)url).get("url"));
        }
        return fileUrls;
    }
}

