/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.adjust;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.MutexFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.mrp.business.helper.AdjustEntryGridHelper;
import kd.mmc.mrp.business.helper.AdjustSuggestHelper;
import kd.mmc.mrp.business.helper.PlanOperatorGroupHelper;

public class AdjustSuggestPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(AdjustSuggestPlugin.class);
    private static final String ID = "id";
    private static final String EDIT = "EDIT";
    private static final String ADJUSTSUGGESTIDSTR = "AdjustSuggestIdStr";
    private static final String RELEASECONFIRMCALLBACK = "releaseConfirmCallBack";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit planNum = (BasedataEdit)this.getControl("planno");
        planNum.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit schduler = (BasedataEdit)this.getControl("schdulers");
        schduler.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"head", "front", "back", "atlast"});
        EntryGrid grid = (EntryGrid)this.getControl("entryentitys");
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long currentId = AdjustSuggestHelper.getLastCaculateLog();
        this.getModel().setValue("planno", (Object)currentId);
        RequestContext request = RequestContext.get();
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        if (!PermissionServiceHelper.checkPermission((Long)request.getCurrUserId(), (String)"mrp", (String)formId, (String)"4715a0df000000ac")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentitys"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"entryentitys", "entryoperatepanel"});
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        this.isHistoryDatas();
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        AdjustEntryGridHelper.fillDatas((IFormView)this.getView(), (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()));
        RequestContext request = RequestContext.get();
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        if (!PermissionServiceHelper.checkPermission((Long)request.getCurrUserId(), (String)"mrp", (String)formId, (String)"4715a0df000000ac")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentitys"});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"entryentitys", "entryoperatepanel"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("release".equals(operateKey)) {
            if (this.isHistoryDatas()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u5212\u8fd0\u7b97\u53f7\u5df2\u7ecf\u6210\u4e3a\u5386\u53f2\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u91ca\u653e\u3002", (String)"AdjustSuggestPlugin_10", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                return;
            }
            this.releaseDatas();
        } else if ("export".equals(operateKey)) {
            this.doExportData();
        } else if ("import".equals(operateKey)) {
            if (this.isHistoryDatas()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u5212\u8fd0\u7b97\u53f7\u5df2\u7ecf\u6210\u4e3a\u5386\u53f2\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5bfc\u5165\u3002", (String)"AdjustSuggestPlugin_9", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                return;
            }
            this.doImportData();
        } else if ("import_model".equals(operateKey)) {
            this.getPageCache().put("model", "true");
            this.doExportData();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("planno".equals(name)) {
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            parameter.setShowApproved(false);
            parameter.setShowUsed(false);
            parameter.setUseOrgId(0L);
            parameter.setIsolationOrg(false);
            QFilter filter = new QFilter("clearstatus", "!=", (Object)Character.valueOf('B'));
            parameter.getListFilterParameter().getQFilters().add(filter);
            parameter.getListFilterParameter().getQFilters().add(new QFilter("operatmodekey", "!=", (Object)"mrp_simulation"));
        } else if ("schdulers".equals(name)) {
            Set set = PlanOperatorGroupHelper.getOperatorUserByGroup();
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter filter = new QFilter(ID, "in", (Object)set);
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeDatas = e.getChangeSet();
        for (int i = 0; i < changeDatas.length; ++i) {
            ChangeData changeData = changeDatas[i];
            int rowIndex = changeData.getRowIndex();
            if ("adjustdate".equals(key)) {
                if (this.isHistoryDatas()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u5212\u8fd0\u7b97\u53f7\u5df2\u7ecf\u6210\u4e3a\u5386\u53f2\u6570\u636e\uff0c\u672c\u6b21\u4fee\u6539\u4e0d\u4f1a\u4fdd\u5b58\u3002", (String)"AdjustSuggestPlugin_8", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    return;
                }
                Date adjustDate = null;
                if (this.getModel().getValue("adjustdate", rowIndex) != null) {
                    adjustDate = AdjustSuggestHelper.getFormDate((Date)((Date)this.getModel().getValue("adjustdate", rowIndex)), (String)"yyyy-MM-dd");
                }
                Date orinDate = null;
                if (this.getModel().getValue("origindate", rowIndex) != null) {
                    orinDate = AdjustSuggestHelper.getFormDate((Date)((Date)this.getModel().getValue("origindate", rowIndex)), (String)"yyyy-MM-dd");
                }
                Date current = AdjustSuggestHelper.getFormDate((Date)new Date(), (String)"yyyy-MM-dd");
                if (adjustDate != null && adjustDate.compareTo(current) < 0) {
                    this.getModel().setValue("adjustdate", null, rowIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u53ef\u7528\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"AdjustSuggestPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (orinDate != null && adjustDate != null && orinDate.compareTo(adjustDate) == 0) {
                    this.getModel().setValue("adjustdate", null, rowIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u53ef\u7528\u65e5\u671f\u4e0d\u80fd\u7b49\u4e8e\u539f\u53ef\u7528\u65e5\u671f\u3002", (String)"AdjustSuggestPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.updateCurrentData(rowIndex, adjustDate, orinDate);
                continue;
            }
            if ("adjustcause".equals(key)) {
                if (this.isHistoryDatas()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u5212\u8fd0\u7b97\u53f7\u5df2\u7ecf\u6210\u4e3a\u5386\u53f2\u6570\u636e\uff0c\u672c\u6b21\u4fee\u6539\u4e0d\u4f1a\u4fdd\u5b58\u3002", (String)"AdjustSuggestPlugin_8", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    return;
                }
                String reason = "";
                if (this.getModel().getValue("adjustcause") != null) {
                    reason = (String)this.getModel().getValue("adjustcause");
                }
                this.updateCurrentReason(rowIndex, reason);
                continue;
            }
            if ("pageindex".equals(key)) {
                AdjustEntryGridHelper.toPageIndex((IFormView)this.getView(), (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), (int)((Integer)this.getModel().getValue("pageindex")));
                continue;
            }
            if ("pagesize".equals(key)) {
                if (changeData.getNewValue() == null) continue;
                int pagesize = Integer.parseInt((String)changeData.getNewValue());
                AdjustEntryGridHelper.toPageSize((IFormView)this.getView(), (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), (int)pagesize);
                continue;
            }
            if (!"planno".equals(key) || this.getModel().getValue("planno") == null) continue;
            this.isHistoryDatas();
            AdjustEntryGridHelper.fillDatas((IFormView)this.getView(), (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()));
        }
    }

    private boolean isHistoryDatas() {
        boolean isHistory;
        if (this.getModel().getValue("planno") != null) {
            DynamicObject currentLog = (DynamicObject)this.getModel().getValue("planno");
            long currentId = currentLog.getLong(ID);
            if (this.getPageCache().get("isShowHistory") != null) {
                this.setEnableByLog(Boolean.FALSE);
                return true;
            }
            long lastId = AdjustSuggestHelper.getLastCaculateLog((long)currentId);
            if (currentId != lastId) {
                this.setEnableByLog(Boolean.FALSE);
                return true;
            }
            this.setEnableByLog(Boolean.TRUE);
            return false;
        }
        if (this.getModel().getValue("isshowhistory") != null && (isHistory = ((Boolean)this.getModel().getValue("isshowhistory")).booleanValue())) {
            this.setEnableByLog(Boolean.FALSE);
            return true;
        }
        this.setEnableByLog(Boolean.TRUE);
        return false;
    }

    private void setEnableByLog(Boolean flag) {
        this.getView().setEnable(flag, new String[]{"import", "release", "entryentitys"});
    }

    private void updateCurrentData(int rowIndex, Date adjustDate, Date orinDate) {
        DynamicObject adjust = AdjustSuggestHelper.loadSingelBillData((IDataModel)this.getModel(), (int)rowIndex, (String)"adjustdate, adjustsuggest, dealer, dealdate");
        adjust.set("adjustdate", (Object)adjustDate);
        AdjustSuggestHelper.loadDealInfo((IDataModel)this.getModel(), (int)rowIndex, (DynamicObject)adjust);
        if (adjustDate == null) {
            adjust.set("adjustsuggest", (Object)Character.valueOf('0'));
            this.getModel().setValue("adjustsuggest", (Object)Character.valueOf('0'), rowIndex);
        } else if (adjustDate.compareTo(orinDate) > 0) {
            adjust.set("adjustsuggest", (Object)Character.valueOf('1'));
            this.getModel().setValue("adjustsuggest", (Object)Character.valueOf('1'), rowIndex);
        } else {
            adjust.set("adjustsuggest", (Object)Character.valueOf('2'));
            this.getModel().setValue("adjustsuggest", (Object)Character.valueOf('2'), rowIndex);
        }
        SaveServiceHelper.update((DynamicObject)adjust);
    }

    private void updateCurrentReason(int rowIndex, String reason) {
        DynamicObject adjust = AdjustSuggestHelper.loadSingelBillData((IDataModel)this.getModel(), (int)rowIndex, (String)"adjustcause, dealer, dealdate");
        adjust.set("adjustcause", (Object)reason);
        AdjustSuggestHelper.loadDealInfo((IDataModel)this.getModel(), (int)rowIndex, (DynamicObject)adjust);
        SaveServiceHelper.update((DynamicObject)adjust);
    }

    private Set<Long> getIdSet(int[] selectRows) {
        HashSet<Long> idSet = new HashSet<Long>();
        String adjustsuggestidstr = this.getPageCache().get(ADJUSTSUGGESTIDSTR);
        if (adjustsuggestidstr != null) {
            List fromJsonStringToList = (List)SerializationUtils.fromJsonString((String)adjustsuggestidstr, List.class);
            idSet = new HashSet(fromJsonStringToList);
            this.getPageCache().remove(ADJUSTSUGGESTIDSTR);
            return idSet;
        }
        for (int row = 0; row < selectRows.length; ++row) {
            int rowIndex = selectRows[row];
            if (this.getModel().getValue(ID, rowIndex) == null) continue;
            idSet.add((Long)this.getModel().getValue(ID, rowIndex));
        }
        return idSet;
    }

    private void releaseDatas() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentitys");
        if (entryGrid.getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u6761\u8c03\u6574\u5efa\u8bae\u6570\u636e\u3002", (String)"AdjustSuggestPlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] selectRows = entryGrid.getSelectRows();
        Set<Long> idSet = this.getIdSet(selectRows);
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(idSet.size());
        for (Long id : idSet) {
            HashMap<String, Object> mutexRequire = new HashMap<String, Object>();
            mutexRequire.put("dataObjId", id.toString());
            mutexRequire.put("groupId", "mrp");
            mutexRequire.put("entityKey", "mrp_adjustsuggest");
            mutexRequire.put("operationKey", EDIT);
            mutexRequire.put("isStrict", true);
            datas.add(mutexRequire);
        }
        ArrayList<Long> asIds = new ArrayList<Long>(idSet.size());
        StringBuilder message = new StringBuilder();
        this.checkisLock(selectRows, datas, asIds, message);
        if (asIds.size() == 0 && message.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u91ca\u653e\u7ed3\u679c", (String)"AdjustSuggestPlugin_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), message.toString(), MessageTypes.Default);
            return;
        }
        if (asIds.size() > 0 && message.length() > 0) {
            String asIdStr = SerializationUtils.toJsonString(asIds);
            this.getPageCache().put(ADJUSTSUGGESTIDSTR, asIdStr);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5b58\u5728%s\u6761\u6570\u636e\u6b63\u5728\u8fdb\u884c\u91ca\u653e\u64cd\u4f5c\uff0c\u662f\u5426\u7ee7\u7eed\u91ca\u653e\u5176\u4ed6\u6570\u636e?", (String)"AdjustSuggestPlugin_20", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), idSet.size() - asIds.size()), MessageBoxOptions.YesNo, new ConfirmCallBackListener(RELEASECONFIRMCALLBACK, (IFormPlugin)this));
            return;
        }
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"IAdjustSuggestService", (String)"releaseData", (Object[])new Object[]{asIds});
        Map errorMap = (Map)result.get("error");
        List successIds = (List)result.get("success");
        this.showInfo(selectRows, errorMap, successIds, message);
        this.releaseLock(asIds);
        log.info("\u91ca\u653e\u6570\u636e\u6210\u529f\u4e3a\uff1a" + successIds);
        log.info("\u91ca\u653e\u6570\u636e\u9519\u8bef\u4e3a\uff1a" + errorMap.keySet());
        if (message.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u91ca\u653e\u7ed3\u679c", (String)"AdjustSuggestPlugin_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), message.toString(), MessageTypes.Default);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(List<Long> asIds) {
        ArrayList datas = new ArrayList(asIds.size());
        for (Long id : asIds) {
            HashMap<String, Object> mutexRequire = new HashMap<String, Object>();
            mutexRequire.put("dataObjId", id.toString());
            mutexRequire.put("groupId", "mrp");
            mutexRequire.put("entityKey", "mrp_adjustsuggest");
            mutexRequire.put("operationKey", EDIT);
            mutexRequire.put("isStrict", true);
            datas.add(mutexRequire);
        }
        DataMutex mutex = MutexFactory.createDataMutex();
        try {
            mutex.batchRelease(datas);
        }
        finally {
            try {
                mutex.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (RELEASECONFIRMCALLBACK.equals(messageBoxClosedEvent.getCallBackId())) {
            String adjustsuggestidstr = this.getPageCache().get(ADJUSTSUGGESTIDSTR);
            if (adjustsuggestidstr != null) {
                List ids = (List)SerializationUtils.fromJsonString((String)adjustsuggestidstr, List.class);
                this.releaseLock(ids);
            }
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
                this.getPageCache().remove(ADJUSTSUGGESTIDSTR);
                return;
            }
            this.releaseDatas();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkisLock(int[] selectRows, List<Map<String, Object>> datas, List<Long> asIds, StringBuilder message) {
        DataMutex mutex = MutexFactory.createDataMutex();
        try {
            Map batchrequire = mutex.batchrequire(datas);
            HashMap<Long, Long> asIdUserIdMap = new HashMap<Long, Long>(batchrequire.size());
            for (Map.Entry require : batchrequire.entrySet()) {
                String asIdStr = (String)require.getKey();
                Boolean isRequire = (Boolean)require.getValue();
                Long l = Long.valueOf(asIdStr);
                if (isRequire.booleanValue()) {
                    asIds.add(Long.valueOf(asIdStr));
                    continue;
                }
                Map map = mutex.getLockInfo(asIdStr, "mrp", "mrp_adjustsuggest");
                String userIdStr = (String)map.get("userid");
                Long userId = Long.valueOf(userIdStr);
                asIdUserIdMap.put(l, userId);
            }
            QFilter filer = new QFilter(ID, "in", asIdUserIdMap.values());
            Map users = BusinessDataServiceHelper.loadFromCache((String)"bos_usergroup_user", (String)"id,name", (QFilter[])new QFilter[]{filer});
            HashMap<Long, String> errorMap = new HashMap<Long, String>(asIdUserIdMap.size());
            for (Map.Entry entry : asIdUserIdMap.entrySet()) {
                Long asId = (Long)entry.getKey();
                Long userId = (Long)entry.getValue();
                DynamicObject user = (DynamicObject)users.get(userId);
                if (user == null) continue;
                String error = String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdjustSuggestPlugin_19", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), user.getString("name"));
                errorMap.put(asId, error);
            }
            ArrayList<Long> successIds = new ArrayList<Long>(0);
            this.showInfo(selectRows, errorMap, successIds, message);
        }
        finally {
            try {
                mutex.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    private void showInfo(int[] selectRows, Map<Long, String> errorMap, List<Long> successIds, StringBuilder message) {
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            if (this.getModel().getValue(ID, rowIndex) == null) continue;
            Long id = (Long)this.getModel().getValue(ID, rowIndex);
            if (errorMap.containsKey(id)) {
                String messageStr = errorMap.get(id);
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a%2$s\u3002", (String)"AdjustSuggestPlugin_24", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), realSeq, messageStr));
                message.append('\n');
                continue;
            }
            if (!successIds.contains(id)) continue;
            message.append(ResManager.loadKDString((String)"\u7b2c", (String)"AdjustSuggestPlugin_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0])).append(realSeq).append(ResManager.loadKDString((String)"\u884c\u6570\u636e\u91ca\u653e\u6210\u529f\u3002", (String)"AdjustSuggestPlugin_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0])).append('\n');
            this.getModel().setValue("releasestatus", (Object)Boolean.TRUE, rowIndex);
            this.getModel().setValue("releases", (Object)Character.valueOf('1'), rowIndex);
            this.getModel().setValue("dealer", (Object)RequestContext.get().getCurrUserId(), rowIndex);
            this.getModel().setValue("dealdate", (Object)new Date(), rowIndex);
        }
    }

    private void doExportData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentitys");
        if (entryEntity.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u53ef\u5bfc\u51fa\u3002", (String)"AdjustSuggestPlugin_26", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "mrp_adjustexport");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        Plugin plugin = new Plugin();
        plugin.setClassName("kd.mmc.mrp.formplugin.adjust.AdjustSuggestExportPlugin");
        plugin.setEnabled(true);
        if (this.getPageCache().get("model") != null) {
            showParameter.setCustomParam("model", (Object)"true");
            this.getPageCache().remove("model");
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8c03\u6574\u5efa\u8bae\u5bfc\u51fa", (String)"AdjustSuggestPlugin_16", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        showParameter.getFormConfig().getPlugins().add(plugin);
        this.getView().showForm(showParameter);
    }

    private void doImportData() {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "mrp_adjustimport");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        long caculateLogId = 0L;
        if (this.getModel().getValue("planno") != null) {
            DynamicObject caculateLogDyn = (DynamicObject)this.getModel().getValue("planno");
            caculateLogId = caculateLogDyn.getLong(ID);
        }
        showParameter.setCustomParam("caculatelogid", (Object)caculateLogId);
        Plugin plugin = new Plugin();
        plugin.setClassName("kd.mmc.mrp.formplugin.adjust.AdjustSuggestImportPlugin");
        plugin.setEnabled(true);
        showParameter.getFormConfig().getPlugins().add(plugin);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closecallback_import"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u8c03\u6574\u5efa\u8bae\u5bfc\u5165", (String)"AdjustSuggestPlugin_17", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("closecallback_import".equals(closedCallBackEvent.getActionId())) {
            AdjustEntryGridHelper.fillDatas((IFormView)this.getView(), (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String btnKey = source.getKey();
        IDataModel model = this.getModel();
        switch (btnKey) {
            case "head": {
                AdjustEntryGridHelper.atFirst((IDataModel)model);
                break;
            }
            case "front": {
                AdjustEntryGridHelper.toFront((IDataModel)model);
                break;
            }
            case "back": {
                if (this.getPageCache().get("count_cache") == null) break;
                AdjustEntryGridHelper.toBack((IDataModel)model, (int)Integer.parseInt(this.getPageCache().get("count_cache")));
                break;
            }
            case "atlast": {
                if (this.getPageCache().get("count_cache") == null) break;
                AdjustEntryGridHelper.toLast((IDataModel)model, (int)Integer.parseInt(this.getPageCache().get("count_cache")));
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int currentRowIndex = hyperLinkClickEvent.getRowIndex();
        switch (fieldName) {
            case "billno": {
                DynamicObject entryObj = this.getModel().getEntryRowEntity("entryentitys", currentRowIndex);
                if (!this.checkEntryRowIsNotNull(entryObj, currentRowIndex) || !this.checkEntityIsNotNull(entryObj, currentRowIndex)) break;
                DynamicObject entity = entryObj.getDynamicObject("billtype");
                String entityNumber = entity.getString("number");
                MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
                String billNo = entryObj.getString("billno");
                String queryField = "";
                if (mainEntityType.findProperty("billno") != null) {
                    queryField = "billno";
                } else if (mainEntityType.findProperty("number") == null) {
                    queryField = "number";
                }
                if (!StringUtils.isNotBlank((CharSequence)queryField)) break;
                Long billId = 0L;
                QFilter billFilter = new QFilter(queryField, "=", (Object)billNo);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdjustSuggestPlugin", (String)entityNumber, (String)ID, (QFilter[])new QFilter[]{billFilter}, null);){
                    if (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        billId = row.getLong(ID);
                    }
                }
                this.openBillInfoShowPage(entityNumber, billId);
                break;
            }
        }
    }

    public boolean checkEntryRowIsNotNull(DynamicObject entryObj, int currentRowIndex) {
        if (entryObj == null) {
            int currentRow = currentRowIndex + 1;
            String message = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8c03\u6574\u5efa\u8bae\u6570\u636e\u88ab\u8c03\u6574\u6216\u8005\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u540e\u91cd\u8bd5\u3002", (String)"AdjustSuggestPlugin_25", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), currentRow);
            this.getView().showMessage(message);
            return false;
        }
        return true;
    }

    public boolean checkEntityIsNotNull(DynamicObject entryObj, int currentRowIndex) {
        if (entryObj == null || entryObj.get("billtype") == null) {
            int currentRow = currentRowIndex + 1;
            String message = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8c03\u6574\u5efa\u8bae\u6570\u636e\u4f9b\u5e94\u5355\u636e\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u901a\u8fc7\u8d85\u94fe\u63a5\u8fdb\u5165\u6570\u636e\u7f16\u8f91\u754c\u9762\u3002", (String)"AdjustSuggestPlugin_23", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), currentRow);
            this.getView().showMessage(message);
            return false;
        }
        return true;
    }

    private void openBillInfoShowPage(String billNumber, Long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(billNumber);
        showParameter.setPkId((Object)billId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

