/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.calcsetting;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TimeEdit;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mrp.common.util.CalSetingUtils;
import org.quartz.Calendar;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class CalSettingUIPlugin
extends AbstractBillPlugIn {
    private static final String BTNCANCEL = "btncancel";
    private static final String BTNOK = "btnok";
    private static final String BTNRUNNING = "btnrunning";
    private static final String[] MONTHDAY = new String[]{"m1", "m2", "m3", "m4", "m5", "m6", "m7", "m8", "m9", "m10", "m11", "m12", "m13", "m14", "m15", "m16", "m17", "m18", "m19", "m20", "m21", "m22", "m23", "m24", "m25", "m26", "m27", "m28", "m29", "m30", "m31"};
    private static final String[] WEEKDAY = new String[]{"day7", "day1", "day2", "day3", "day4", "day5", "day6"};
    private static final String RUNNINGTYPE = "runningtype";
    private static final String PREDTIME = "predtime";
    private static final String REPEAT = "repeat";
    private static final String LOSEDATE = "losedate";
    private static final String REPEATTYPE = "repeattype";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter p = this.getView().getFormShowParameter();
        Map params = p.getCustomParams();
        if (params.get("id") == null) {
            return;
        }
        Object pk = params.get("id");
        this.initData(pk);
    }

    private void initData(Object pk) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"mrp_plandispatch");
        IDataModel model = this.getModel();
        model.setValue(RUNNINGTYPE, obj.get(RUNNINGTYPE));
        model.setValue(PREDTIME, obj.get(PREDTIME));
        model.setValue(REPEAT, obj.get(REPEAT));
        model.setValue(LOSEDATE, obj.get(LOSEDATE));
        if (obj.getBoolean(REPEAT)) {
            model.setValue(REPEATTYPE, (Object)obj.getString(REPEATTYPE));
            if ("0".equals(obj.getString(REPEATTYPE))) {
                String str = obj.getString("daysofweek");
                String[] arr = str.split(",");
                for (int i = 0; i < arr.length; ++i) {
                    model.setValue("day" + arr[i], (Object)Boolean.TRUE);
                }
            } else if ("1".equals(obj.getString(REPEATTYPE))) {
                String str = obj.getString("daysofmon");
                String[] arr = str.split(",");
                for (int i = 0; i < arr.length; ++i) {
                    model.setValue("m" + arr[i], (Object)Boolean.TRUE);
                }
            } else {
                model.setValue("plan", (Object)obj.getString("plan"));
            }
        }
    }

    private void clearMonthData() {
        for (String m : MONTHDAY) {
            this.getModel().setValue(m, (Object)Boolean.FALSE);
        }
    }

    private void clearWeekData() {
        for (String w : WEEKDAY) {
            this.getModel().setValue(w, (Object)Boolean.FALSE);
        }
    }

    public void click(EventObject evt) {
        Control btn = (Control)evt.getSource();
        HashMap<String, Object> params = new HashMap<String, Object>();
        switch (btn.getKey()) {
            case "btnok": {
                if (!this.checkCron(this.getModel().getValue("plan").toString())) {
                    return;
                }
                if (!this.validOp(params, 0)) break;
                this.getView().returnDataToParent(params);
                this.getView().close();
                break;
            }
            case "btncancel": {
                params.put("op", 2);
                this.getView().returnDataToParent(params);
                this.getView().close();
                break;
            }
        }
    }

    private List<String> getDays(String[] label, boolean isWeek) {
        ArrayList<String> days = new ArrayList<String>();
        int sub = isWeek ? 3 : 1;
        for (String element : label) {
            boolean day = (Boolean)this.getModel().getValue(element);
            if (!day) continue;
            days.add(element.substring(sub));
        }
        return days;
    }

    private List<String> getDaysOfMonth() {
        boolean b = false;
        return this.getDays(MONTHDAY, false);
    }

    private List<String> getDaysOfWeek() {
        boolean b = true;
        return this.getDays(WEEKDAY, true);
    }

    private boolean isMust(String t) {
        return Integer.parseInt(t) == 1;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String dn;
        switch (dn = e.getProperty().getName()) {
            case "runningtype": {
                String type = (String)e.getChangeSet()[0].getNewValue();
                this.setCustomState(this.isMust(type));
                break;
            }
            case "repeat": {
                boolean repeated = (Boolean)e.getChangeSet()[0].getNewValue();
                this.repeatedChanged(repeated);
                break;
            }
            case "repeattype": {
                this.repeattypechg();
                break;
            }
            case "losedate": {
                Date lost = (Date)e.getChangeSet()[0].getNewValue();
                if (null == lost || CalSetingUtils.compare((Date)lost, (Date)new Date(System.currentTimeMillis())) > 0) break;
                this.getModel().setValue(LOSEDATE, null);
                break;
            }
            case "plan": {
                this.checkCron(e.getChangeSet()[0].getNewValue().toString());
                break;
            }
        }
    }

    private boolean checkCron(String cron) {
        if (this.getModel().getValue(REPEATTYPE) == null) {
            return true;
        }
        if (!"2".equals(this.getModel().getValue(REPEATTYPE).toString())) {
            return true;
        }
        try {
            CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
            parser.parse(cron);
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cron);
            List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, (Calendar)null, (int)2);
            long leadTime = Math.abs(((Date)dates.get(1)).getTime() - ((Date)dates.get(0)).getTime());
            if (leadTime < 60000L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"cron\u8868\u8fbe\u5f0f\u7684\u5468\u671f\u8bbe\u7f6e\u6709\u8bef\uff0c\u53ea\u652f\u6301\u5206\u949f\u7ea7\u522b\u7684\u5468\u671f\u3002", (String)"CalSettingUIPlugin_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"cron\u8868\u8fbe\u5f0f\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CalSettingUIPlugin_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK, BTNRUNNING, BTNCANCEL});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
    }

    private void repeatedChanged(boolean repeated) {
        ComboEdit te = (ComboEdit)this.getView().getControl(REPEATTYPE);
        te.setMustInput(repeated);
        this.clearWeekData();
        this.clearMonthData();
    }

    private void repeattypechg() {
        this.clearWeekData();
        this.clearMonthData();
        this.getModel().setValue("plan", (Object)"");
    }

    private void setCustomState(boolean isMust) {
        TimeEdit time = (TimeEdit)this.getView().getControl(PREDTIME);
        time.setMustInput(isMust);
        this.getModel().setValue(PREDTIME, (Object)-1);
        this.getView().setEnable(Boolean.valueOf(isMust), new String[]{PREDTIME});
    }

    private boolean validAndInit(Map<String, Object> h) {
        IDataModel model = this.getModel();
        String rt = (String)model.getValue(RUNNINGTYPE);
        Integer pred = (Integer)model.getValue(PREDTIME);
        if ((pred == null || pred <= 0) && "1".equals(rt)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7ea6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u9884\u7ea6\u65f6\u95f4\u3002", (String)"CalSettingUIPlugin_8", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!this.validDays()) {
            return false;
        }
        h.put(RUNNINGTYPE, rt);
        h.put(LOSEDATE, model.getValue(LOSEDATE));
        h.put(REPEATTYPE, model.getValue(REPEATTYPE));
        h.put(PREDTIME, model.getValue(PREDTIME));
        h.put(REPEAT, model.getValue(REPEAT));
        h.put("plan", model.getValue("plan"));
        h.put("daysofweek", this.getDaysOfWeek());
        h.put("daysofmon", this.getDaysOfMonth());
        return true;
    }

    private boolean validDays() {
        IDataModel model = this.getModel();
        boolean repeat = (Boolean)model.getValue(REPEAT);
        if (repeat) {
            String repeattype = (String)model.getValue(REPEATTYPE);
            if (repeattype == null || "".equals(repeattype)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u590d\u8fd0\u7b97\u9009\u62e9\u65f6\uff0c\u65f6\u95f4\u91cd\u590d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalSettingUIPlugin_9", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                return false;
            }
            if ("0".equals(repeattype) && this.getDaysOfWeek().isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u91cd\u590d\u7c7b\u578b\u4e3a\u5468\u65f6\uff0c\u8bf7\u9009\u62e9\u5468\u5185\u7684\u8ba1\u5212\u6267\u884c\u65f6\u95f4\u3002", (String)"CalSettingUIPlugin_10", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                return false;
            }
            if ("1".equals(repeattype) && this.getDaysOfMonth().isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u91cd\u590d\u7c7b\u578b\u4e3a\u6708\u65f6\uff0c\u8bf7\u9009\u62e9\u6708\u5185\u7684\u8ba1\u5212\u6267\u884c\u65f6\u95f4\u3002", (String)"CalSettingUIPlugin_11", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean validOp(Map<String, Object> params, int op) {
        if (!this.validAndInit(params)) {
            return false;
        }
        params.put("op", op);
        return true;
    }
}

