/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.forecast;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.QtyEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.mmc.mrp.common.util.ForecastUtils;

public abstract class AbstractFctEntryPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private final String algoKey = ((Object)((Object)this)).getClass().getSimpleName();
    private static final Log log = LogFactory.getLog(AbstractFctEntryPlugin.class);

    protected abstract List<String> getDateCols(FormShowParameter var1);

    protected abstract String getUnitFieldKey(String var1);

    protected abstract String getSelectFields();

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        long startTime = System.currentTimeMillis();
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        List<String> dateCols = this.getDateCols(formShowParameter);
        if (dateCols == null) {
            return;
        }
        EntryAp entryAp = this.createDynamicEntryAp(dateCols, formShowParameter.getFormId());
        log.info("[MRP-FCT] Create EntryAp cost " + (System.currentTimeMillis() - startTime) + " ms");
        HashMap entryMap = Maps.newHashMapWithExpectedSize((int)2);
        entryMap.put("id", "entryentity");
        entryMap.put("columns", entryAp.createControl().get("columns"));
        e.getItems().add(entryMap);
        log.info("[MRP-FCT] LoadCustomControlMetas cost " + (System.currentTimeMillis() - startTime) + " ms");
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        long startTime = System.currentTimeMillis();
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        List<String> dateCols = this.getDateCols(formShowParameter);
        if (dateCols == null) {
            return;
        }
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("AbstractFctEntryPlugin", exp.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        for (String dateCol : dateCols) {
            QtyProp qtyProp = new QtyProp();
            qtyProp.setName(dateCol);
            qtyProp.setDisplayName(new LocaleString(dateCol));
            qtyProp.setDbIgnore(true);
            entryType.registerSimpleProperty((DynamicSimpleProperty)qtyProp);
        }
        e.setNewEntityType(newMainType);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        EntryAp entryAp = this.createDynamicEntryAp(dateCols, formShowParameter.getFormId());
        List newItems = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control item : newItems) {
            item.setView(view);
        }
        List items = entryGrid.getItems();
        items.clear();
        items.addAll(newItems);
        log.info("[MRP-FCT] GetEntityType cost " + (System.currentTimeMillis() - startTime) + " ms");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"previous", "next", "first", "last", "selectall", "cancelselect"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        Label label = (Label)this.getControl("selectedcount");
        int count = entryGrid.getSelectRows().length;
        label.setText(String.valueOf(count));
        boolean isNotEmpty = count != 0;
        this.getView().setVisible(Boolean.valueOf(isNotEmpty), new String[]{"panel_selected"});
        String pageCountStr = this.getPageCache().get("pagecount") == null ? "0" : this.getPageCache().get("pagecount");
        this.getView().setVisible(Boolean.valueOf(isNotEmpty && Integer.parseInt(pageCountStr) > 1), new String[]{"selectall"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"cancelselect"});
    }

    public void afterCreateNewData(EventObject e) {
        long startTime = System.currentTimeMillis();
        QFilter[] filters = this.getFilters();
        if (filters == null) {
            return;
        }
        CachedDataSet cachedDataSet = ForecastUtils.getCachedDataSet((QFilter[])filters, (IFormView)this.getView(), (String)this.getSelectFields());
        this.bindData(cachedDataSet, 1);
        log.info("[MRP-FCT] AfterCreateNewData cost " + (System.currentTimeMillis() - startTime) + " ms");
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "previous": {
                this.previous();
                break;
            }
            case "next": {
                this.next();
                break;
            }
            case "last": {
                this.last();
                break;
            }
            case "first": {
                this.first();
                break;
            }
            case "selectall": {
                this.selectAll();
                break;
            }
            case "cancelselect": {
                this.cancelSelect();
                break;
            }
        }
    }

    private void cancelSelect() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.selectRows(-1);
        this.getPageCache().remove("selectAll");
        this.getView().setVisible(Boolean.FALSE, new String[]{"cancelselect", "panel_selected"});
    }

    private void selectAll() {
        IFormView view = this.getView();
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        int[] selectRows = IntStream.range(0, entryRowCount).toArray();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        entryGrid.selectRows(selectRows, 0);
        String rowCount = this.getPageCache().get("rowcount");
        Label label = (Label)this.getControl("selectedcount");
        label.setText(rowCount);
        this.getPageCache().put("selectAll", "1");
        view.setVisible(Boolean.FALSE, new String[]{"selectall"});
        view.setVisible(Boolean.TRUE, new String[]{"cancelselect"});
    }

    private void first() {
        this.getModel().setValue("page", (Object)1);
    }

    private void last() {
        String pageCountStr = this.getPageCache().get("pagecount");
        if (pageCountStr != null) {
            this.getModel().setValue("page", (Object)Integer.valueOf(pageCountStr));
        }
    }

    private void next() {
        int currentPage = (Integer)this.getModel().getValue("page");
        this.getModel().setValue("page", (Object)(currentPage + 1));
    }

    private void previous() {
        int currentPage = (Integer)this.getModel().getValue("page");
        this.getModel().setValue("page", (Object)(currentPage - 1));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.setColumnProperty("count", "isFixed", (Object)true);
        entryGrid.setColumnProperty("count", "sort", (Object)false);
        entryGrid.setColumnProperty("count", "filter", (Object)false);
        view.setEnable(Boolean.FALSE, new String[]{"previous", "first"});
        view.setVisible(Boolean.FALSE, new String[]{"panel_selected", "selectall", "cancelselect"});
        String cacheId = this.getPageCache().get("algoCacheId");
        if (cacheId == null) {
            view.setEnable(Boolean.FALSE, new String[]{"next", "last"});
            return;
        }
        CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)cacheId);
        int rowCount = cachedDataSet.getRowCount();
        log.info("[MRP-FCT] Row count is " + rowCount);
        this.getPageCache().put("rowcount", String.valueOf(rowCount));
        String pageRowStr = (String)this.getModel().getValue("pagerow");
        int pageRow = Integer.parseInt(pageRowStr);
        int pageCount = (rowCount + pageRow - 1) / pageRow;
        this.setPageCount(pageCount);
        if (pageCount <= 1) {
            view.setEnable(Boolean.FALSE, new String[]{"next", "last"});
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (StringUtils.contains((CharSequence)key, (CharSequence)"/")) {
            QtyEdit qtyEdit = new QtyEdit();
            qtyEdit.setKey(key);
            qtyEdit.setEntryKey("entryentity");
            qtyEdit.setView(this.getView());
            e.setControl((Control)qtyEdit);
        }
    }

    public void pageRelease(EventObject e) {
        String cacheId = this.getPageCache().get("algoCacheId");
        if (cacheId != null) {
            CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)cacheId);
            cachedDataSet.close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        CachedDataSet cachedDataSet;
        String cacheId = this.getPageCache().get("algoCacheId");
        if (cacheId == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.getPageCache().remove("selectAll");
        this.getView().setVisible(Boolean.FALSE, new String[]{"panel_selected", "selectall", "cancelselect"});
        String name = e.getProperty().getName();
        int currentPage = (Integer)this.getModel().getValue("page");
        if ("page".equals(name)) {
            int pageCount;
            if (currentPage < 1) {
                this.getModel().setValue("page", (Object)1);
                return;
            }
            String pageCountStr = this.getPageCache().get("pagecount");
            if (pageCountStr != null && currentPage > (pageCount = Integer.parseInt(pageCountStr))) {
                this.getModel().setValue("page", (Object)pageCount);
                return;
            }
        } else {
            int targetPage = 1;
            this.getModel().setValue("page", (Object)targetPage);
            if (currentPage != targetPage) {
                return;
            }
        }
        this.getModel().deleteEntryData("entryentity");
        if (this.getPageCache().get("isDirty") == null) {
            cachedDataSet = Algo.getCacheDataSet((String)cacheId);
        } else {
            cachedDataSet = ForecastUtils.getCachedDataSet((QFilter[])this.getFilters(), (IFormView)this.getView(), (String)this.getSelectFields());
            this.getPageCache().remove("isDirty");
        }
        this.bindData(cachedDataSet, currentPage);
        String pageCountStr = this.getPageCache().get("pagecount");
        int pageCount = Integer.parseInt(pageCountStr);
        this.setPageCount(pageCount);
        this.getView().setEnable(Boolean.valueOf(currentPage != pageCount), new String[]{"next", "last"});
        this.getView().setEnable(Boolean.valueOf(currentPage != 1), new String[]{"previous", "first"});
        log.info("[MRP-FCT] Paging cost " + (System.currentTimeMillis() - startTime) + " ms");
    }

    private void setPageCount(int pageCount) {
        Label label = (Label)this.getControl("pagecount");
        label.setText(String.valueOf(pageCount));
    }

    private void bindData(CachedDataSet cachedDataSet, int currentPage) {
        long startTime = System.currentTimeMillis();
        RowMeta rowMeta = cachedDataSet.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        String[] fields = this.getAllFieldName(fieldNames);
        TableValueSetter tvs = new TableValueSetter(fields);
        String pageRowStr = (String)this.getModel().getValue("pagerow");
        int pageRow = Integer.parseInt(pageRowStr);
        int rowCount = cachedDataSet.getRowCount();
        int pageCount = (rowCount + pageRow - 1) / pageRow;
        this.getPageCache().put("pagecount", String.valueOf(pageCount));
        int startIndex = (currentPage - 1) * pageRow;
        List rows = cachedDataSet.getList(startIndex, pageRow);
        int count = 0;
        ObjectMapper objectMapper = SerializationUtils.getObjectMapper2();
        try {
            for (Row row : rows) {
                Object[] values = new Object[fieldNames.length];
                for (int i = 0; i < fieldNames.length; ++i) {
                    values[i] = row.get(fieldNames[i]);
                }
                tvs.addRow(values);
                String dateColJson = row.getString("date_qty_tag");
                Map date2Qty = (Map)objectMapper.readValue(dateColJson, HashMap.class);
                for (Map.Entry entry : date2Qty.entrySet()) {
                    tvs.set((String)entry.getKey(), entry.getValue(), count);
                }
                ++count;
            }
            int endIndex = Math.min(startIndex + pageRow, rowCount);
            Object[] values = new Object[endIndex - startIndex];
            int i = startIndex;
            int j = 0;
            while (i < endIndex) {
                values[j] = i + 1;
                ++i;
                ++j;
            }
            tvs.addField("count", values);
            long wrapperTime = System.currentTimeMillis();
            log.info("[MRP-FCT] Wrapper tableValueSetter cost " + (wrapperTime - startTime) + " ms");
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", tvs);
            model.endInit();
            this.getView().updateView("entryentity");
            long endTime = System.currentTimeMillis();
            log.info("[MRP-FCT] Update view cost " + (endTime - wrapperTime) + " ms");
            log.info("[MRP-FCT] Bind data cost " + (endTime - startTime) + " ms");
        }
        catch (IOException jsonParseException) {
            throw new KDBizException("Serialize failed " + jsonParseException.getMessage());
        }
    }

    private String[] getAllFieldName(String[] fieldNames) {
        List<String> dateCols = this.getDateCols(this.getView().getFormShowParameter());
        String[] fields = new String[fieldNames.length + dateCols.size()];
        int count = 0;
        String[] stringArray = fieldNames;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String fieldName;
            fields[count] = fieldName = stringArray[i];
            ++count;
        }
        for (String dateCol : dateCols) {
            fields[count++] = dateCol;
        }
        return fields;
    }

    private EntryAp createDynamicEntryAp(List<String> dateCols, String formId) {
        String entityId = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        EntryAp entryAp = this.getEntryApByMeta(formId);
        List items = entryAp.getItems();
        String unitFieldId = this.getUnitFieldKey(formId);
        for (String dateCol : dateCols) {
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            entryFieldAp.setId(dateCol);
            entryFieldAp.setKey(dateCol);
            entryFieldAp.setName(new LocaleString(dateCol));
            entryFieldAp.setFireUpdEvt(true);
            QtyField qtyField = new QtyField();
            qtyField.setId(dateCol);
            qtyField.setKey(dateCol);
            qtyField.setZeroShow(true);
            qtyField.setEntityMetadata(entitymeta);
            qtyField.setScale(10);
            qtyField.setUnitFieldId(unitFieldId);
            qtyField.setDataScope("[0,)");
            entryFieldAp.setField((Field)qtyField);
            items.add(entryFieldAp);
        }
        return entryAp;
    }

    protected EntryAp getEntryApByMeta(String formId) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryentity");
        String entityId = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity);
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        formmeta.bindEntityMetadata(entitymeta);
        for (ControlAp ap : formmeta.getItems()) {
            if (!StringUtils.equals((CharSequence)"entryentity", (CharSequence)ap.getKey())) continue;
            entryAp = (EntryAp)ap;
            break;
        }
        return entryAp;
    }

    private QFilter[] getFilters() {
        List filterStrList = (List)this.getView().getFormShowParameter().getCustomParam("filterData");
        if (filterStrList == null) {
            return null;
        }
        return (QFilter[])filterStrList.stream().map(QFilter::fromSerializedString).toArray(QFilter[]::new);
    }
}

