/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.planexecute;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.utils.DataSourceUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.mservice.service.datafetch.model.FetchDataQueryModule;

public class CPSSelectBillPlanPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"entrybillno"});
        BasedataEdit entrybilltype = (BasedataEdit)this.getView().getControl("entrybilltype");
        if (entrybilltype != null) {
            entrybilltype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int count = this.getModel().getEntryRowCount("entryentity");
        if (count > 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"daterange"});
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        int count = this.getModel().getEntryRowCount("entryentity");
        if (count == 0) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"daterange"});
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if ("entrybillno".equals(fieldKey)) {
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entry.getSelectRows();
            if (this.getModel().getValue("entrybilltype", selectRows[0]) == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7b2c[%s]\u884c\u9700\u6c42\u5355\u636e\u7c7b\u578b\u3002", (String)"CPSSelectBillPlanPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), selectRows[0] + 1));
                evt.setCancel(true);
                return;
            }
            DynamicObject data = (DynamicObject)this.getModel().getValue("entrybilltype", selectRows[0]);
            Long dataSouceid = Long.valueOf(data.getPkValue().toString());
            this.getPageCache().put("dataconf", dataSouceid.toString());
            QFilter qfiltersor = new QFilter("id", "=", (Object)dataSouceid);
            DynamicObject sourfield = QueryServiceHelper.queryOne((String)"mrp_resource_dataconf_rgt", (String)"id,billfieldtransfer,filter_tag", (QFilter[])new QFilter[]{qfiltersor});
            QFilter qfilter = new QFilter("id", "=", (Object)sourfield.getLong("billfieldtransfer"));
            DynamicObjectCollection billfieldentry = QueryServiceHelper.query((String)"mrp_billfieldtransfer", (String)"id,srcbill.id,entryentity.destfieldflag destfieldflag,entryentity.sourcefieldflag sourcefieldflag", (QFilter[])new QFilter[]{qfilter});
            if (billfieldentry == null || billfieldentry.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u672a\u8bbe\u7f6e\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\uff0c\u8bf7\u5148\u8bbe\u7f6e\u6570\u636e\u6e90\u4e2d\u7684\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u3002", (String)"CPSSelectBillPlanPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String entityNumber = ((DynamicObject)billfieldentry.get(0)).getString("srcbill.id");
            String filter = sourfield.getString("filter_tag");
            FilterCondition filterCondition = new FilterCondition();
            if (!StringUtils.isBlank((CharSequence)filter)) {
                filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            }
            filterCondition.setFilter(filter);
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            FilterBuilder fb = new FilterBuilder(mainType, filterCondition);
            fb.buildFilter(false);
            QFilter qFilter = fb.getQFilter();
            if (qFilter == null) {
                qFilter = new QFilter("1", "=", (Object)1);
            }
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)true, (int)2);
            lsp.setFormId("bos_listf7");
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "getdatasource"));
            String dateField = "";
            for (DynamicObject row : billfieldentry) {
                if (!"ENTRYENTITY.CPSDATE".equals(row.getString("destfieldflag").toUpperCase())) continue;
                dateField = row.getString("sourcefieldflag");
            }
            if (this.getModel().getValue("begin") != null && this.getModel().getValue("end") != null) {
                if ("".equals(dateField)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u4e2d\u4f9b\u5e94/\u9700\u6c42\u65e5\u671f\u672a\u914d\u7f6e\u6e90\u5355\u5b57\u6bb5\u6807\u8bc6,\u9009\u62e9\u6570\u636e\u65f6\u8868\u5934\u65e5\u671f\u8303\u56f4\u8fc7\u6ee4\u5c06\u4e0d\u751f\u6548\u3002", (String)"CPSSelectBillPlanPlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                } else {
                    Date begin = (Date)this.getModel().getValue("begin");
                    Date end = (Date)this.getModel().getValue("end");
                    end.setHours(23);
                    end.setMinutes(59);
                    end.setSeconds(59);
                    QFilter beginQF = new QFilter(dateField, ">=", (Object)begin);
                    QFilter endQF = new QFilter(dateField, "<=", (Object)end);
                    qFilter.and(beginQF).and(endQF);
                }
            }
            if (this.getModel().getEntryRowCount("entryentity") != 0) {
                int count = this.getModel().getEntryRowCount("entryentity");
                ArrayList<Long> idList = new ArrayList<Long>(count);
                ArrayList<Long> entryIdList = new ArrayList<Long>(count);
                String entityKey = "";
                for (int i = 0; i < count; ++i) {
                    DynamicObject dataSource;
                    if (this.getModel().getValue("entrybilltype", i) == null || !(dataSource = (DynamicObject)this.getModel().getValue("entrybilltype", i)).getPkValue().equals(data.getPkValue())) continue;
                    if (this.getModel().getValue("billid", i) != null && (Long)this.getModel().getValue("billid", i) != 0L) {
                        idList.add((Long)this.getModel().getValue("billid", i));
                    }
                    if (this.getModel().getValue("billentryid", i) != null && (Long)this.getModel().getValue("billentryid", i) != 0L) {
                        entryIdList.add((Long)this.getModel().getValue("billentryid", i));
                    }
                    if (!"".equals(entityKey) || "".equals(this.getModel().getValue("billentrykey", i))) continue;
                    entityKey = (String)this.getModel().getValue("billentrykey", i);
                }
                if (entryIdList.isEmpty()) {
                    if (!idList.isEmpty()) {
                        qFilter.and(new QFilter("id", "not in", idList));
                    }
                } else if (!"".equals(entityKey)) {
                    qFilter.and(new QFilter(entityKey + ".id", "not in", entryIdList));
                }
            }
            lsp.getListFilterParameter().getQFilters().add(qFilter);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Control con = (Control)e.getSource();
        String key = con.getKey();
        if ("entrybilltype".equals(key)) {
            DynamicObject entrydres;
            if (this.getModel().getValue("plangram") == null) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u9f50\u5957\u65b9\u6848\u201d\u3002", (String)"CPSSelectBillPlanPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject plangram = (DynamicObject)this.getModel().getValue("plangram");
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            listShowParameter.getListFilterParameter().getQFilters().clear();
            ArrayList<Object> ids = new ArrayList<Object>();
            List<String> requireBills = Arrays.asList("pom_mftstock", "om_mftstock", "mrp_planorder", "om_componentlist");
            List<String> supplyBills = Arrays.asList("pom_mftorder", "om_mftorder", "mrp_planorder", "pm_om_purorderbill");
            HashSet<String> set = new HashSet<String>(4);
            DynamicObjectCollection entrys = plangram.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                entrydres = entry.getDynamicObject("resourceregister");
                String entity = entry.getString("entrydemandsrc.id");
                boolean ismrp = entry.getBoolean("entryismrpoperat");
                if (ismrp && entrydres != null && !requireBills.contains(entity)) {
                    ids.add(entrydres.getPkValue());
                }
                if (!ismrp || !requireBills.contains(entity)) continue;
                switch (entity) {
                    case "pom_mftstock": {
                        set.add("pom_mftorder");
                        break;
                    }
                    case "om_mftstock": {
                        set.add("om_mftorder");
                        break;
                    }
                    case "mrp_planorder": {
                        set.add("mrp_planorder");
                        break;
                    }
                    case "om_componentlist": {
                        set.add("pm_om_purorderbill");
                        break;
                    }
                }
            }
            entrys = plangram.getDynamicObjectCollection("scentryentity");
            for (DynamicObject entry : entrys) {
                entrydres = entry.getDynamicObject("resourceregisters");
                boolean ismrp = entry.getBoolean("entryisscmrpoperat");
                String entity = entry.getString("entrysupplyres.id");
                if (entrydres == null || !supplyBills.contains(entity) || !ismrp && !set.contains(entity)) continue;
                ids.add(entrydres.getPkValue());
            }
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
        }
    }

    private TableValueSetter createEntrys(AbstractFormDataModel model) {
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("entrybilltype", new Object[0]);
        vs.addField("entrybillno", new Object[0]);
        vs.addField("entryseq", new Object[0]);
        vs.addField("entrymaterial", new Object[0]);
        vs.addField("entryunit", new Object[0]);
        vs.addField("requireorg", new Object[0]);
        vs.addField("demandqty", new Object[0]);
        vs.addField("demanddate", new Object[0]);
        vs.addField("billtype", new Object[0]);
        vs.addField("configuredcode", new Object[0]);
        vs.addField("tracknumber", new Object[0]);
        vs.addField("auxpty", new Object[0]);
        vs.addField("billid", new Object[0]);
        vs.addField("billentryid", new Object[0]);
        vs.addField("billentrykey", new Object[0]);
        vs.addField("warehouse", new Object[0]);
        vs.addField("planscope", new Object[0]);
        vs.addField("projectnumber", new Object[0]);
        return vs;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("getdatasource".equals(actionId)) {
            ListSelectedRowCollection col = (ListSelectedRowCollection)evt.getReturnData();
            if (col == null || col.isEmpty()) {
                return;
            }
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < entryRowCount; ++i) {
                if (!"".equals(this.getModel().getValue("entrybillno", i))) continue;
                list.add(i);
            }
            if (!list.isEmpty()) {
                this.getModel().deleteEntryRows("entryentity", list.stream().mapToInt(Integer::intValue).toArray());
            }
            HashSet<Object> billSet = new HashSet<Object>(col.size());
            HashSet<Object> entrySet = new HashSet<Object>(col.size());
            String entity = "";
            for (ListSelectedRow row : col) {
                billSet.add(row.getPrimaryKeyValue());
                entrySet.add(row.getEntryPrimaryKeyValue());
                entity = row.getEntryEntityKey();
            }
            QFilter qf = entity == null ? new QFilter("id", "in", billSet) : new QFilter(entity + ".id", "in", entrySet);
            FetchDataQueryModule queryMD = DataSourceUtil.getQueryModuleByModelFilter((Long)Long.valueOf(this.getPageCache().get("dataconf")), (QFilter)qf);
            String billEntryKey = null;
            for (String selectField : queryMD.getSelFields()) {
                if (!selectField.contains("entryentity.billentryid")) continue;
                String quStr = selectField.substring(selectField.indexOf("(") + 1, selectField.indexOf(")"));
                String[] split = quStr.split("\\.");
                if (split.length < 2) break;
                billEntryKey = split[0];
                break;
            }
            try (DataSet dataSet = DataSourceUtil.getDataSetByModel((FetchDataQueryModule)queryMD, (DataSet)QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)queryMD.getMt(), (String)queryMD.getOql(), (QFilter[])queryMD.getqFilters(), null));){
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                TableValueSetter vs = this.createEntrys(model);
                this.initRowData(dataSet, Long.valueOf(this.getPageCache().get("dataconf")), billEntryKey, vs);
                model.batchCreateNewEntryRow("entryentity", vs);
                model.endInit();
                this.getView().updateView("entryentity");
                int count = this.getModel().getEntryRowCount("entryentity");
                if (count > 0) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"daterange"});
                }
            }
        }
    }

    private void initRowData(DataSet dataSet, Long resId, String billEntryKey, TableValueSetter vs) {
        RowMeta rowMeta = dataSet.getRowMeta();
        while (dataSet.hasNext()) {
            Long entryid;
            BigDecimal demandqty;
            Long requireorg;
            Long entryunit;
            Row row = dataSet.next();
            String entrybillno = this.havProperty(rowMeta, "entryentity.billnumber") ? (String)MRPUtil.convert((Object)row.getString("entryentity.billnumber"), (Object)"") : "";
            Integer entryseq = this.havProperty(rowMeta, "entryentity.billentryseq") ? (Integer)MRPUtil.convert((Object)row.getInteger("entryentity.billentryseq"), (Object)0) : Integer.valueOf(0);
            Long entrymaterial = this.havProperty(rowMeta, "entryentity.material") ? (Long)MRPUtil.convert((Object)row.get("entryentity.material"), (Object)0L) : Long.valueOf(0L);
            Long l = entryunit = this.havProperty(rowMeta, "entryentity.baseunit") ? (Long)MRPUtil.convert((Object)row.get("entryentity.baseunit"), (Object)0L) : Long.valueOf(0L);
            Long l2 = this.havProperty(rowMeta, "entryentity.productionorgunit") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.productionorgunit"), (Object)0L) : (requireorg = this.havProperty(rowMeta, "entryentity.supplyorgunit") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.supplyorgunit"), (Object)0L) : Long.valueOf(0L));
            BigDecimal bigDecimal = this.havProperty(rowMeta, "entryentity.demandqty") ? (BigDecimal)MRPUtil.convert((Object)row.get("entryentity.demandqty"), (Object)BigDecimal.ZERO) : (demandqty = this.havProperty(rowMeta, "entryentity.qty") ? (BigDecimal)MRPUtil.convert((Object)row.get("entryentity.qty"), (Object)BigDecimal.ZERO) : BigDecimal.ZERO);
            Date demanddate = this.havProperty(rowMeta, "entryentity.billdate") ? row.getDate("entryentity.billdate") : (this.havProperty(rowMeta, "entryentity.cpsdate") ? row.getDate("entryentity.cpsdate") : null);
            Long billtype = this.havProperty(rowMeta, "entryentity.billtype") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.billtype"), (Object)0L) : Long.valueOf(0L);
            Long configuredcode = this.havProperty(rowMeta, "entryentity.configuredcode") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.configuredcode"), (Object)0L) : Long.valueOf(0L);
            Long tracknumber = this.havProperty(rowMeta, "entryentity.tracknumber") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.tracknumber"), (Object)0L) : Long.valueOf(0L);
            Long auxpty = this.havProperty(rowMeta, "entryentity.materialflexprops") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.materialflexprops"), (Object)0L) : 0L;
            Long id = this.havProperty(rowMeta, "entryentity.billid") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.billid"), (Object)0L) : Long.valueOf(0L);
            Long l3 = entryid = this.havProperty(rowMeta, "entryentity.billentryid") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.billentryid"), (Object)0L) : Long.valueOf(0L);
            Long warehouse = this.havProperty(rowMeta, "entryentity.warehouse") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.warehouse"), (Object)0L) : (this.havProperty(rowMeta, "entryentity.stock") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.stock"), (Object)0L) : Long.valueOf(0L));
            Long planscope = this.havProperty(rowMeta, "entryentity.planscope") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.planscope"), (Object)0L) : Long.valueOf(0L);
            Long projectnumber = this.havProperty(rowMeta, "entryentity.projectnumber") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.projectnumber"), (Object)0L) : Long.valueOf(0L);
            vs.addRow(new Object[]{resId, entrybillno, entryseq, entrymaterial, entryunit, requireorg, demandqty, demanddate, billtype, configuredcode, tracknumber, auxpty, id, entryid, billEntryKey, warehouse, planscope, projectnumber});
        }
    }

    private boolean havProperty(RowMeta rowMeta, String field) {
        return rowMeta.getFieldIndex(field, false) >= 0;
    }
}

