/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.planexecute;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.mrp.business.helper.GlobalPlanHelper;
import kd.mmc.mrp.business.helper.PlanViewOrgHelper;
import kd.mmc.mrp.common.cache.GlobalPlanSessionCache;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.controlnode.framework.runner.MRPRunner4Config;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.MRPIntegrateFactory;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mpscmm.msplan.mrp.business.helper.PlanScopeHelper;

public class GlobalPlanPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    protected static final String ORG = "org";
    protected static final String PLANPROGRAM = "plangram";
    protected static final String ID = "id";
    protected static final String START_CAL = "startcaculate";
    private static final String MRP_CACULATE_LOG = "mrp_caculate_log";
    private static final String FLEX_CACULATE_LOG = "flex_caculate_log";
    private static final String NUMBER = "number";
    private static final String ISLLC = "isllc";
    private static final String BOMCHECK = "isbomcheck";
    private static final String ALLOWDATE = "isallowdateinpast";
    private static final String PLANDATE = "plandate";
    private static final String PLANTYPE = "plantype";
    private static final String CONFIRM_EXEC = "confirm_exec";
    private static final String CACULATELOG_CACHE = "caculateLog_cache";
    private static final String ISCOMMON = "iscommon";
    private static final String ISCUSTOMIZE = "iscustomize";
    private static final String ISSELECTION = "isselection";
    private static final String ISNOTSETUP = "isnotsetup";
    private static final String CLEARSTATUS = "clearstatus";
    private static final String IS_ENABLE_PLANSCOPE = "is_enable_planscope";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setOrgByPermission();
        String orgId = GlobalPlanSessionCache.getCache((String)ORG);
        String plan_gramId = GlobalPlanSessionCache.getCache((String)PLANPROGRAM);
        this.setOrgAndPlanGramByCache(orgId, plan_gramId);
        if (this.isEnablePlanScope()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"planscope"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"planscope"});
        }
    }

    protected void setOrgAndPlanGramByCache(String orgId, String plan_gramId) {
        if (StringUtils.isNotBlank((CharSequence)orgId) && GlobalPlanHelper.isExistF7Value((String)"bos_org", (Object)Long.valueOf(orgId))) {
            this.getModel().setValue(ORG, (Object)Long.valueOf(orgId));
            if (StringUtils.isNotBlank((CharSequence)plan_gramId) && GlobalPlanHelper.isEnableF7Value((String)this.getPlanProgram(), (Object)Long.valueOf(plan_gramId))) {
                this.getModel().setValue(PLANPROGRAM, (Object)Long.valueOf(plan_gramId));
            }
        }
    }

    public void setOrgByPermission() {
        long userId = RequestContext.get().getCurrUserId();
        String appId = StringUtils.isBlank((CharSequence)this.getView().getFormShowParameter().getAppId()) ? "mrp" : this.getView().getFormShowParameter().getAppId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)BizAppServiceHelp.getAppIdByAppNumber((String)appId), (String)this.getView().getFormShowParameter().getFormId(), (String)"47150e89000000ac");
        List orgIds = result.getHasPermOrgs();
        Set planViewOrgIds = PlanViewOrgHelper.getOrgIdsByPlanView();
        long orgid = RequestContext.get().getOrgId();
        if (!orgIds.isEmpty()) {
            this.setOrgByPermission(orgid, orgIds, planViewOrgIds);
        } else if (result.hasAllOrgPerm() && planViewOrgIds.contains(orgid)) {
            this.getModel().setValue(ORG, (Object)RequestContext.get().getOrgId());
        }
    }

    public void setOrgByPermission(long orgid, List<Long> orgIds, Set<Long> planViewOrgIds) {
        if (orgIds.contains(orgid) && planViewOrgIds.contains(orgid)) {
            this.getModel().setValue(ORG, (Object)RequestContext.get().getOrgId());
        } else {
            this.getModel().setValue(ORG, (Object)orgIds.get(0));
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit planscope;
        BasedataEdit org;
        super.registerListener(e);
        BasedataEdit planprogram = (BasedataEdit)this.getView().getControl(PLANPROGRAM);
        if (planprogram != null) {
            planprogram.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((org = (BasedataEdit)this.getView().getControl(ORG)) != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((planscope = (BasedataEdit)this.getView().getControl("planscope")) != null) {
            planscope.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Control con = (Control)e.getSource();
        String key = con.getKey();
        if (PLANPROGRAM.equals(key)) {
            Long orgId = this.checkOrgIsNull();
            if (orgId != -1L) {
                QFilter orgFilter = new QFilter("createorg.id", "=", (Object)orgId);
                QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                QFilter typeFilter = new QFilter("type", "!=", (Object)"B");
                ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
                param.getListFilterParameter().getQFilters().add(orgFilter);
                param.getListFilterParameter().getQFilters().add(statusFilter);
                param.getListFilterParameter().getQFilters().add(enableFilter);
                param.getListFilterParameter().getQFilters().add(typeFilter);
            } else {
                e.setCancel(true);
            }
        } else if (ORG.equals(key)) {
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            param.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            QFilter idFilter = new QFilter(ID, "in", (Object)PlanViewOrgHelper.getOrgIdsByPlanView());
            param.getListFilterParameter().getQFilters().add(idFilter);
        } else if ("planscope".equals(key)) {
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            DynamicObject planprogram = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)PLANPROGRAM);
            HashSet<Long> ids = new HashSet<Long>(4);
            if (planprogram != null) {
                if (!planprogram.containsProperty("orgentryentity")) {
                    planprogram = BusinessDataServiceHelper.loadSingleFromCache((Object)planprogram.getPkValue(), (String)planprogram.getDynamicObjectType().getName());
                }
                DynamicObjectCollection orgcoll = planprogram.getDynamicObjectCollection("orgentryentity");
                for (DynamicObject orgc : orgcoll) {
                    DynamicObject planscope = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)orgc, (String)"entryplanscope");
                    if (planscope == null) continue;
                    ids.add(planscope.getLong(ID));
                }
            }
            QFilter idFilter = new QFilter(ID, "in", ids);
            param.getListFilterParameter().getQFilters().add(idFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String string = key = op != null ? op.getOperateKey() : "";
        if (key.equals(START_CAL)) {
            this.beforeCalculate(e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeCalculate(BeforeDoOperationEventArgs e) {
        DynamicObject org = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)ORG);
        DynamicObject plangram = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)PLANPROGRAM);
        if (plangram == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u5212\u65b9\u6848\u3002", (String)"GlobalPlanPlugin_15", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long planId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)plangram);
        if (GlobalPlanHelper.isExistMRPRunning((Long)planId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"GlobalPlanPlugin_12", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (org != null) {
            DynamicObject caculateLog = this.createNewLog(null);
            String number = CodeRuleServiceHelper.getNumber((String)MRP_CACULATE_LOG, (DynamicObject)caculateLog, (String)org.getPkValue().toString());
            this.getPageCache().put(CACULATELOG_CACHE, number);
            if (StringUtils.isBlank((CharSequence)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"GlobalPlanPlugin_16", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u51c6\u5907\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"GlobalPlanPlugin_14", (String)"mmc-mrp-formplugin", (Object[])new Object[0])));
                try {
                    this.execGlobalPlan(number, plangram);
                }
                finally {
                    this.getView().hideLoading();
                }
            }
        } else {
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && CONFIRM_EXEC.equals(e.getCallBackId())) {
            String number = this.getPageCache().get(CACULATELOG_CACHE);
            this.runMRP4Global(number);
        }
    }

    private void execGlobalPlan(String number, DynamicObject plangram) {
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)plangram.getLong(ID), (String)this.getPlanProgram());
        int planOutLook = plan.getInt("planoutlook");
        DynamicObjectCollection orgcoll = plan.getDynamicObjectCollection("orgentryentity");
        Iterator its = orgcoll.iterator();
        StringBuilder calOrgName = new StringBuilder();
        while (its.hasNext()) {
            DynamicObject dyn = (DynamicObject)its.next();
            if (dyn.getDynamicObject("entrydemandorg") == null) continue;
            DynamicObject org = dyn.getDynamicObject("entrydemandorg");
            String orgid = org.getString(ID);
            String name = org.getString("name");
            OrgBasedCalendarModel cUtil = new OrgBasedCalendarModel(orgid);
            if (cUtil.isEmpty()) continue;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)this.getModel().getValue(PLANDATE));
            calendar.add(5, planOutLook);
            if (!calendar.getTime().after(cUtil.getMaxDate().getDate().getTime())) continue;
            if (calOrgName.length() > 0) {
                calOrgName.append('\uff0c');
            }
            calOrgName.append(name);
        }
        if (calOrgName.length() > 0) {
            this.confirmCaculateLog(calOrgName);
        } else {
            this.runMRP4Global(number);
        }
    }

    public void confirmCaculateLog(StringBuilder calOrgName) {
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CONFIRM_EXEC, (IFormPlugin)this);
        StringBuilder str = new StringBuilder();
        if (calOrgName.length() > 0) {
            str.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5b58\u5728\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f\u5927\u4e8e\u8ba1\u5212\u65e5\u5386\u6700\u5927\u65e5\u671f\uff0c\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u8fd0\u7b97\uff1f\u5982\u9009\u62e9\u662f\uff0c\u5219\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f\u53d6\u8ba1\u5212\u65e5\u5386\u7684\u6700\u5927\u65e5\u671f\u3002", (String)"GlobalPlanPlugin_13", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), calOrgName.toString()));
        }
        confirmCallBack.setView(this.getView());
        this.getView().showConfirm(str.toString(), MessageBoxOptions.YesNo, confirmCallBack);
    }

    protected void runMRP4Global(String number) {
        DynamicObject caculateLog = this.createNewLog(number);
        IMRPEnvProvider env = MRPIntegrateFactory.createMRPEnv((DynamicObject)caculateLog);
        new MRPRunner4Config().run(env);
        DynamicObject org = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)ORG);
        DynamicObject plangram = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)PLANPROGRAM);
        GlobalPlanSessionCache.putCache((String)ORG, (String)(org == null ? "" : org.getString(ID)));
        GlobalPlanSessionCache.putCache((String)PLANPROGRAM, (String)(plangram == null ? "" : plangram.getString(ID)));
        this.showLogForm(caculateLog.getLong(ID));
    }

    protected DynamicObject createNewLog(String number) {
        DynamicObject plangram = (DynamicObject)this.getModel().getValue(PLANPROGRAM);
        DynamicObject caculateLog = ORM.create().newDynamicObject(MRP_CACULATE_LOG);
        if (plangram == null) {
            return caculateLog;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        String plantype = PlanModel.getPlanType((DynamicObject)plangram);
        Long id = ORM.create().genLongId(MRP_CACULATE_LOG);
        caculateLog.set(ID, (Object)id);
        caculateLog.set(NUMBER, (Object)number);
        caculateLog.set("createorg", (Object)org);
        caculateLog.set("useorg", (Object)org);
        caculateLog.set("runtype", (Object)this.getRunType());
        caculateLog.set(PLANTYPE, (Object)plantype);
        caculateLog.set(CLEARSTATUS, (Object)Character.valueOf('A'));
        caculateLog.set("status", (Object)Character.valueOf('C'));
        caculateLog.set("enable", (Object)Character.valueOf('1'));
        caculateLog.set(PLANPROGRAM, (Object)plangram.getLong(ID));
        caculateLog.set("programnumber", (Object)plangram.getString(NUMBER));
        caculateLog.set("programname", (Object)plangram.getString("name"));
        caculateLog.set(PLANDATE, this.getModel().getValue(PLANDATE));
        caculateLog.set(ISCOMMON, plangram.get(ISCOMMON));
        caculateLog.set(ISCUSTOMIZE, plangram.get(ISCUSTOMIZE));
        caculateLog.set(ISSELECTION, plangram.get(ISSELECTION));
        caculateLog.set(ISNOTSETUP, plangram.get(ISNOTSETUP));
        caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        caculateLog.set("operatmode", (Object)this.getView().getFormShowParameter().getFormName());
        caculateLog.set("operatmodekey", (Object)this.getView().getFormShowParameter().getFormId());
        caculateLog.set("calculatestatus", (Object)"D");
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("ctrlstrategy", (Object)"7");
        caculateLog.set(ISLLC, this.getModel().getValue(ISLLC));
        caculateLog.set(BOMCHECK, this.getModel().getValue(BOMCHECK));
        caculateLog.set(ALLOWDATE, this.getModel().getValue(ALLOWDATE));
        caculateLog.set("plangramentity", (Object)this.getPlanProgram());
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)plangram.getLong(ID), (String)this.getPlanProgram(), (String)"plantags");
        DynamicObjectCollection plantags = plan.getDynamicObjectCollection("plantags");
        DynamicObjectCollection calctags = caculateLog.getDynamicObjectCollection("plantags");
        calctags.clear();
        for (DynamicObject tag : plantags) {
            DynamicObject cal = calctags.addNew();
            cal.set("fbasedataid", tag.get("fbasedataid"));
        }
        if (this.getModel().getValue("dataversion") != null) {
            DynamicObject dataVersion = (DynamicObject)this.getModel().getValue("dataversion");
            caculateLog.set("dataversion", (Object)dataVersion.getLong(ID));
        }
        if (this.getModel().getDataEntity().containsProperty("planscope")) {
            DynamicObject planscope = (DynamicObject)this.getModel().getValue("planscope");
            caculateLog.set("planscope", (Object)(planscope == null ? 0L : planscope.getLong(ID)));
        }
        if (number != null) {
            ORM.create().save(caculateLog);
            BaseDataServiceHelper.clearCache((DynamicObject)caculateLog);
        }
        return caculateLog;
    }

    protected void showLogForm(long id) {
        this.getView().close();
        BillShowParameter formShowParameter = new BillShowParameter();
        String formId = MRP_CACULATE_LOG;
        MainEntityType mt = this.getModel().getDataEntityType();
        if ("mrp_cps_runner".equals(mt.getName())) {
            formId = "mrp_cps_calc_log";
        }
        formShowParameter.setFormId(formId);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setPkId((Object)id);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam(ID, (Object)id);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (StringUtils.equalsIgnoreCase((CharSequence)e.getActionId(), (CharSequence)FLEX_CACULATE_LOG)) {
            this.getView().close();
        }
    }

    public Long checkOrgIsNull() {
        if (this.getModel().getValue(ORG) != null) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            return org.getLong(ID);
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u8ba1\u5212\u7ec4\u7ec7\u3002", (String)"GlobalPlanPlugin_17", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        return -1L;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (ORG.equals(key)) {
            this.getModel().setValue(PLANPROGRAM, null);
        } else if (PLANPROGRAM.equals(key) && this.getModel().getValue(PLANPROGRAM) != null) {
            boolean isOld = false;
            if (e.getChangeSet()[0].getOldValue() != null) {
                DynamicObject oldPlanProgram = (DynamicObject)e.getChangeSet()[0].getOldValue();
                isOld = oldPlanProgram.getBoolean("isreserve");
            }
            boolean isreserve = ((DynamicObject)this.getModel().getValue(PLANPROGRAM)).getBoolean("isreserve");
            String formId = this.getView().getFormShowParameter().getFormId();
            if (!isOld && isreserve && "mrp_globalplan".equals(formId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"MRP\u8ba1\u7b97\u5df2\u8003\u8651\u9884\u7559\uff0c\u4e0d\u652f\u6301\u5feb\u7167\u6a21\u5f0f\u3002", (String)"GlobalPlanPlugin_18", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
        }
        if (PLANPROGRAM.equals(key) && this.getModel().getDataEntity().containsProperty("planscope")) {
            this.getModel().setValue("planscope", null);
        }
    }

    protected String getPlanProgram() {
        MainEntityType mt = this.getModel().getDataEntityType();
        String planProgram = "mrp_planprogram";
        if ("mrp_cps_runner".equals(mt.getName())) {
            planProgram = "mrp_cps_planpro";
        }
        return planProgram;
    }

    protected String getRunType() {
        MainEntityType mt = this.getModel().getDataEntityType();
        String runType = "A";
        if ("mrp_cps_runner".equals(mt.getName())) {
            runType = "B";
        }
        return runType;
    }

    protected String getSelectBillId() {
        MainEntityType mt = this.getModel().getDataEntityType();
        String formId = "mrp_selectdemandbill";
        if ("mrp_cps_runner".equals(mt.getName())) {
            formId = "mrp_cps_seldemandbill";
        }
        return formId;
    }

    protected boolean isEnablePlanScope() {
        String cache = this.getPageCache().get(IS_ENABLE_PLANSCOPE);
        if (StringUtils.isBlank((CharSequence)cache)) {
            cache = PlanScopeHelper.isEnablePlanScope() ? "1" : "0";
            this.getPageCache().put(IS_ENABLE_PLANSCOPE, cache);
        }
        return "1".equals(cache);
    }
}

