/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.planexecute;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.formplugin.ext.ISelectBillAddFields;
import kd.mmc.mrp.formplugin.ext.SelectBillAddFieldsImpl;
import kd.mmc.mrp.formplugin.planexecute.SelectDemandBillPlugin;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.utils.DataSourceUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.mservice.service.datafetch.model.FetchDataQueryModule;

public class RequireBillListPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
SearchEnterListener {
    private static final String DEMANDBILL = "demandbill";
    private static final String RESOURCE_REGISTER = "resourceregister";
    private static final String MRP_RESOURCE_DATACONFIG = "mrp_resource_dataconfig";
    private static final String ENTRY_ENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String caption = formShowParameter.getCaption();
        Label label = (Label)this.getControl("labelap");
        if (label != null) {
            label.setText(caption);
        }
        this.doSearch();
    }

    private void doSearch() {
        this.doSearch(null, null);
    }

    private void doSearch(Set<String> billNos, Set<String> materialNums) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object demandbill = formShowParameter.getCustomParam(DEMANDBILL);
        Object resStr = formShowParameter.getCustomParam(RESOURCE_REGISTER);
        if (StringUtils.isNotBlank((Object)demandbill) && StringUtils.isNotBlank((Object)resStr)) {
            Long resId = Long.parseLong(resStr.toString());
            FetchDataQueryModule queryMD = DataSourceUtil.getQueryModuleByModel((Long)resId, null);
            int maxRowCount = SelectDemandBillPlugin.getMaxRowCount();
            int count = 0;
            String billEntryKey = null;
            for (String selectField : queryMD.getSelFields()) {
                if (!selectField.contains(DefaultField.RequireField.BILLENTRYID.getName().toLowerCase(Locale.ENGLISH))) continue;
                String quStr = selectField.substring(selectField.indexOf("(") + 1, selectField.indexOf(")"));
                String[] split = quStr.split("\\.");
                if (split.length < 2) break;
                billEntryKey = split[0];
                break;
            }
            HashSet<Long> mids = null;
            HashSet<String> existdata = new HashSet<String>(16);
            Object cacheValue = formShowParameter.getCustomParam("existdata");
            if (StringUtils.isNotBlank((Object)cacheValue)) {
                existdata.addAll(JSONArray.parseArray((String)cacheValue.toString(), String.class));
            }
            if (materialNums != null && !materialNums.isEmpty()) {
                mids = new HashSet<Long>(materialNums.size());
                QFilter qFilter = new QFilter("number", "in", materialNums);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"bd_material", (String)"id", (QFilter[])new QFilter[]{qFilter}, null);){
                    for (Row row : dataSet) {
                        mids.add(row.getLong(0));
                    }
                }
            }
            try (DataSet dataSet = DataSourceUtil.getDataSetByModel((FetchDataQueryModule)queryMD, (DataSet)QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)queryMD.getMt(), (String)queryMD.getOql(), (QFilter[])queryMD.getqFilters(), null));){
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                TableValueSetter vs = RequireBillListPlugin.createEntrys(model);
                count = this.initRowData(dataSet, resId, billEntryKey, vs, maxRowCount, billNos, mids, existdata);
                this.getModel().deleteEntryData(ENTRY_ENTITY);
                model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
                model.endInit();
                this.getView().updateView(ENTRY_ENTITY);
            }
            if (maxRowCount < count) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u884c\u6570(%1$s)\u8d85\u8fc7[\u9009\u5355/\u6a21\u62df\u6700\u5927\u884c\u6570\u63a7\u5236(%2$s)]\uff0c\u4ec5\u663e\u793a\u524d%3$s\u884c\u6570\u636e\u3002", (String)"RequireBillListPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), count, maxRowCount, maxRowCount));
            }
        }
    }

    public static TableValueSetter createEntrys(AbstractFormDataModel model) {
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField("entrybillno", new Object[0]);
        vs.addField("entrymaterial", new Object[0]);
        vs.addField("entryunit", new Object[0]);
        vs.addField("demandqty", new Object[0]);
        vs.addField("demanddate", new Object[0]);
        vs.addField("entrybilltype", new Object[0]);
        vs.addField("billid", new Object[0]);
        vs.addField("billentryid", new Object[0]);
        vs.addField("entryseq", new Object[0]);
        vs.addField("billentrykey", new Object[0]);
        vs.addField("requireorg", new Object[0]);
        vs.addField("billtype", new Object[0]);
        vs.addField("configuredcode", new Object[0]);
        vs.addField("tracknumber", new Object[0]);
        vs.addField("auxpty", new Object[0]);
        vs.addField("warehouse", new Object[0]);
        vs.addField("planscope", new Object[0]);
        vs.addField("runtype", new Object[0]);
        vs.addField("projectnumber", new Object[0]);
        SelectBillAddFieldsImpl defXXXSubPlugin = new SelectBillAddFieldsImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)defXXXSubPlugin, ISelectBillAddFields.class, (String)"MRP_SELECT_BILL_EXT", null);
        List results = pluginProxy.callReplaceIfPresent(p -> p.addFields(vs));
        return (TableValueSetter)results.get(0);
    }

    private int initRowData(DataSet dataSet, Long resId, String billEntryKey, TableValueSetter vs, int maxRowCount, Set<String> billNos, Set<Long> mids, Set<String> existdata) {
        Row row;
        int seq = 0;
        int count = 0;
        RowMeta rowMeta = dataSet.getRowMeta();
        boolean isBillNoMatch = billNos != null && !billNos.isEmpty();
        boolean isMaterialMatch = mids != null;
        HashSet<String> calculatedRequires = new HashSet<String>(16);
        try (DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"mrp_reqcalc_record", (String)"bill_id,billentry_id", (QFilter[])new QFilter[0], null);){
            while (dataSet1.hasNext()) {
                row = dataSet1.next();
                calculatedRequires.add(String.format("%s-%s", row.get("bill_id"), row.get("billentry_id")));
            }
        }
        SelectBillAddFieldsImpl defXXXSubPlugin = new SelectBillAddFieldsImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)defXXXSubPlugin, ISelectBillAddFields.class, (String)"MRP_SELECT_BILL_EXT", null);
        while (dataSet.hasNext()) {
            Long projectNumber;
            row = dataSet.next();
            Long id = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.BILLID.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.BILLID.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long entryid = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.BILLENTRYID.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.BILLENTRYID.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            String key = id.toString() + '-' + entryid.toString();
            if (existdata.contains(key)) continue;
            String runtype = calculatedRequires.contains(String.format("%s-%s", id, entryid)) ? "A" : "B";
            Integer entryseq = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.BILLENTRYSEQ.getName().toLowerCase(Locale.ENGLISH)) ? (Integer)MRPUtil.convert((Object)row.getInteger(DefaultField.RequireField.BILLENTRYSEQ.getName().toLowerCase(Locale.ENGLISH)), (Object)0) : Integer.valueOf(0);
            String entrybillno = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.BILLNUMBER.getName().toLowerCase(Locale.ENGLISH)) ? (String)MRPUtil.convert((Object)row.getString(DefaultField.RequireField.BILLNUMBER.getName().toLowerCase(Locale.ENGLISH)), (Object)"") : "";
            Long entrymaterial = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.MATERIAL.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.get(DefaultField.RequireField.MATERIAL.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long entryunit = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.BASEUNIT.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.get(DefaultField.RequireField.BASEUNIT.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            BigDecimal demandqty = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.QTY.getName().toLowerCase(Locale.ENGLISH)) ? (BigDecimal)MRPUtil.convert((Object)row.get(DefaultField.RequireField.QTY.getName().toLowerCase(Locale.ENGLISH)), (Object)BigDecimal.ZERO) : BigDecimal.ZERO;
            Date demanddate = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.DATE.getName().toLowerCase(Locale.ENGLISH)) ? row.getDate(DefaultField.RequireField.DATE.getName().toLowerCase(Locale.ENGLISH)) : null;
            Long requireorg = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.PRODUCTIONORGUNIT.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long billtype = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.ENTRYENTITYBILLTYPE.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.ENTRYENTITYBILLTYPE.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long configuredcode = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.CONFIGUREDCODE.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.CONFIGUREDCODE.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long tracknumber = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.TRACKNUMBER.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.TRACKNUMBER.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long auxpty = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.MATERIALFLEXPROPS.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.MATERIALFLEXPROPS.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long warehouse = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.WAREHOUSE.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.WAREHOUSE.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long planscope = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.PLANSCOPE.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.PLANSCOPE.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long l = projectNumber = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.PROJECTNUMBER.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.PROJECTNUMBER.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            if (isBillNoMatch && isMaterialMatch) {
                if (!billNos.contains(entrybillno) && !mids.contains(entrymaterial)) {
                    continue;
                }
            } else if (!isBillNoMatch ? isMaterialMatch && !mids.contains(entrymaterial) : !billNos.contains(entrybillno)) continue;
            if (++count > maxRowCount) continue;
            vs.addRow(new Object[]{++seq, entrybillno, entrymaterial, entryunit, demandqty, demanddate, resId, id, entryid, entryseq, billEntryKey, requireorg, billtype, configuredcode, tracknumber, auxpty, warehouse, planscope, runtype, projectNumber});
            pluginProxy.callReplaceIfPresent(p -> p.addValues(vs, rowMeta, row));
        }
        return count;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)"ok")) {
            this.doOk();
        }
    }

    private void doOk() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"RequireBillListPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>(selectRows.length);
        for (int i : selectRows) {
            entrys.add(this.getModel().getEntryRowEntity(ENTRY_ENTITY, i));
        }
        String str = SerializationUtils.toJsonString(this.getPageCacheList(entrys));
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(ENTRY_ENTITY, str);
        map.put("row", this.getView().getFormShowParameter().getCustomParam("row"));
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        super.entryRowDoubleClick(evt);
        this.doOk();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    private List<Map<String, Object>> getPageCacheList(List<DynamicObject> entrys) {
        ArrayList<Map<String, Object>> lists = new ArrayList<Map<String, Object>>(entrys.size());
        SelectBillAddFieldsImpl defXXXSubPlugin = new SelectBillAddFieldsImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)defXXXSubPlugin, ISelectBillAddFields.class, (String)"MRP_SELECT_BILL_EXT", null);
        for (DynamicObject entry : entrys) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            DynamicObject entrymaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrymaterial");
            DynamicObject entryunit = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entryunit");
            DynamicObject entrybilltype = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrybilltype");
            DynamicObject requireorg = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"requireorg");
            DynamicObject billtype = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"billtype");
            DynamicObject configuredcode = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"configuredcode");
            DynamicObject tracknumber = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"tracknumber");
            DynamicObject auxpty = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"auxpty");
            DynamicObject warehouse = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"warehouse");
            DynamicObject planscope = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"planscope");
            DynamicObject projectnumber = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"projectnumber");
            map.put("entrybillno", entry.get("entrybillno"));
            map.put("entrymaterial", entrymaterial == null ? Long.valueOf(0L) : entrymaterial.getPkValue());
            map.put("entryunit", entryunit == null ? Long.valueOf(0L) : entryunit.getPkValue());
            map.put("entrybilltype", entrybilltype == null ? Long.valueOf(0L) : entrybilltype.getPkValue());
            map.put("demandqty", entry.get("demandqty"));
            map.put("demanddate", entry.getDate("demanddate") == null ? null : Long.valueOf(entry.getDate("demanddate").getTime()));
            map.put("billentryid", entry.get("billentryid"));
            map.put("billid", entry.get("billid"));
            map.put("entryseq", entry.get("entryseq"));
            map.put("billentrykey", entry.get("billentrykey"));
            map.put("requireorg", requireorg == null ? Long.valueOf(0L) : requireorg.getPkValue());
            map.put("billtype", billtype == null ? Long.valueOf(0L) : billtype.getPkValue());
            map.put("configuredcode", configuredcode == null ? Long.valueOf(0L) : configuredcode.getPkValue());
            map.put("tracknumber", tracknumber == null ? Long.valueOf(0L) : tracknumber.getPkValue());
            map.put("auxpty", auxpty == null ? Long.valueOf(0L) : auxpty.getPkValue());
            map.put("warehouse", warehouse == null ? Long.valueOf(0L) : warehouse.getPkValue());
            map.put("planscope", planscope == null ? Long.valueOf(0L) : planscope.getPkValue());
            map.put("runtype", entry.get("runtype"));
            map.put("projectnumber", projectnumber == null ? Long.valueOf(0L) : projectnumber.getPkValue());
            pluginProxy.callReplaceIfPresent(p -> p.addReturnData(map, entry));
            lists.add(map);
        }
        return lists;
    }

    public void search(SearchEnterEvent e) {
        List searchFields = e.getSearchFields();
        HashSet<String> billNos = new HashSet<String>(16);
        HashSet<String> materialNums = new HashSet<String>(16);
        if (searchFields != null && !searchFields.isEmpty()) {
            for (Map map : searchFields) {
                List fieldName = (List)map.get("fieldName");
                List value = (List)map.get("value");
                for (String field : fieldName) {
                    if ("filter_entrybillno".equalsIgnoreCase(field)) {
                        billNos.addAll(value);
                        continue;
                    }
                    if (!"filter_entrymaterial".equalsIgnoreCase(field)) continue;
                    materialNums.addAll(value);
                }
            }
        }
        this.doSearch(billNos, materialNums);
    }
}

