/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.planexecute;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.mmc.mrp.business.helper.GlobalPlanHelper;
import kd.mmc.mrp.common.cache.SelectPlanSessionCache;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.common.util.FilterConditionUtil;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.utils.DataSourceUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.mservice.service.datafetch.model.FetchDataQueryModule;

public class SelectDemandBillPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String PLAN_TYPE = "plantype";
    private static final String PLAN_GRAM = "plangram";
    private static final String DEMAND_MODULE = "demandmodule";
    private static final String MRP_PLANPROGRAM = "mrp_planprogram";
    private static final String DEMANDBILL = "demandbill";
    private static final String RESOURCE_REGISTER = "resourceregister";
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String MRP_RESOURCE_DATACONFIG = "mrp_resource_dataconfig";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ADD_ENTRY = "addentry";
    private static final String SURE = "sure";
    private static final String SEARCH_BUTTONAP = "buttonap";
    private static final String FILTERDESCDS = "filterdescds";
    private static final Log logger = LogFactory.getLog(SelectDemandBillPlugin.class);

    private void createNewData(Object plangram, String planType, FormShowParameter formShowParameter) {
        this.getModel().setValue(PLAN_GRAM, plangram);
        DynamicObject plan = QueryServiceHelper.queryOne((String)(planType == null ? MRP_PLANPROGRAM : planType), (String)"id,demandmodel", (QFilter[])new QFilter[]{new QFilter("id", "=", plangram)});
        this.getModel().setValue(DEMAND_MODULE, plan == null ? null : plan.get("demandmodel"));
        this.getPageCache().put(ENTRY_ENTITY, null);
        String str = (String)formShowParameter.getCustomParam(ENTRY_ENTITY);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            List lists = SerializationUtils.fromJsonStringToList((String)str, Map.class);
            this.createEntry(lists);
        }
    }

    private void initFilter(FormShowParameter formShowParameter) {
        String planType;
        Object plangram = formShowParameter.getCustomParam(PLAN_GRAM);
        Object demandbill = formShowParameter.getCustomParam(DEMANDBILL);
        String filterStr = (String)formShowParameter.getCustomParam(FILTERGRIDAP);
        Object resStr = formShowParameter.getCustomParam(RESOURCE_REGISTER);
        String string = planType = formShowParameter.getCustomParam(PLAN_TYPE) != null ? (String)formShowParameter.getCustomParam(PLAN_TYPE) : "";
        if (StringUtils.isBlank((Object)demandbill) || StringUtils.isBlank((Object)resStr)) {
            demandbill = SelectPlanSessionCache.getCache((String)planType, (String)SelectPlanSessionCache.getDataKey((String)planType, (String)plangram.toString(), (String)DEMANDBILL));
            filterStr = SelectPlanSessionCache.getCache((String)planType, (String)SelectPlanSessionCache.getDataKey((String)planType, (String)plangram.toString(), (String)FILTERGRIDAP));
            resStr = SelectPlanSessionCache.getCache((String)planType, (String)SelectPlanSessionCache.getDataKey((String)planType, (String)plangram.toString(), (String)RESOURCE_REGISTER));
        }
        if (StringUtils.isNotBlank((Object)demandbill) && StringUtils.isNotBlank((Object)resStr) && GlobalPlanHelper.isExistF7Value((String)"bos_entityobject", (Object)demandbill) && GlobalPlanHelper.isExistF7Value((String)MRP_RESOURCE_DATACONFIG, (Object)Long.parseLong(resStr.toString()))) {
            this.getModel().setValue(DEMANDBILL, demandbill);
            this.getModel().setValue(RESOURCE_REGISTER, (Object)Long.parseLong(resStr.toString()));
            this.getPageCache().put(DEMANDBILL, demandbill.toString());
            this.getPageCache().put(RESOURCE_REGISTER, resStr.toString());
            if (StringUtils.isNotBlank((CharSequence)filterStr)) {
                this.getPageCache().put(FILTERGRIDAP, filterStr);
                this.setFilterConditionValue(filterStr, demandbill.toString(), true);
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{FILTERGRIDAP});
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object plangram = formShowParameter.getCustomParam(PLAN_GRAM);
        if (StringUtils.isNotBlank((Object)plangram)) {
            Object planType = formShowParameter.getCustomParam(PLAN_TYPE);
            this.createNewData(plangram, planType == null ? null : planType.toString(), formShowParameter);
            this.initFilter(formShowParameter);
        }
        if (formShowParameter.getCustomParam("issimulation") != null) {
            this.getModel().setValue("showcalcedreq", (Object)Boolean.TRUE);
            this.getView().setVisible(Boolean.FALSE, new String[]{"showcalcedreq"});
        }
    }

    private void createEntry(List<Map<String, Object>> lists) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (lists == null || lists.isEmpty()) {
            return;
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField("entrybillno1", new Object[0]);
        vs.addField("entrymaterial1", new Object[0]);
        vs.addField("entryunit1", new Object[0]);
        vs.addField("demandqty1", new Object[0]);
        vs.addField("demanddate1", new Object[0]);
        vs.addField("entrybilltype1", new Object[0]);
        vs.addField("billtype1", new Object[0]);
        vs.addField("billid1", new Object[0]);
        vs.addField("billentryid1", new Object[0]);
        vs.addField("entryseq1", new Object[0]);
        vs.addField("billentrykey1", new Object[0]);
        vs.addField("requireorg1", new Object[0]);
        vs.addField("configuredcode1", new Object[0]);
        vs.addField("tracknumber1", new Object[0]);
        vs.addField("auxpty1", new Object[0]);
        vs.addField("projectnumber1", new Object[0]);
        SelectDemandBillPlugin.initVs(lists, vs);
        model.batchCreateNewEntryRow("entryentity1", vs);
        model.endInit();
        this.getView().updateView("entryentity1");
    }

    public static void initVs(List<Map<String, Object>> lists, TableValueSetter vs) {
        int seq = 1;
        for (Map<String, Object> dataMap : lists) {
            Long time = (Long)MRPUtil.convert((Object)dataMap.get("demanddate"), (Object)0L);
            Date date = time != null && time > 0L ? new Date(time) : null;
            vs.addRow(new Object[]{seq++, dataMap.get("entrybillno"), dataMap.get("entrymaterial"), dataMap.get("entryunit"), dataMap.get("demandqty"), date, dataMap.get("entrybilltype"), dataMap.get("billtype"), dataMap.get("billid"), dataMap.get("billentryid"), dataMap.get("entryseq"), dataMap.get("billentrykey"), dataMap.get("requireorg"), dataMap.get("configuredcode"), dataMap.get("tracknumber"), dataMap.get("auxpty"), dataMap.get("projectnumber")});
        }
    }

    public void registerListener(EventObject e) {
        TextEdit textEdit;
        Button button;
        super.registerListener(e);
        BasedataEdit resourceregister = (BasedataEdit)this.getControl(RESOURCE_REGISTER);
        if (resourceregister != null) {
            resourceregister.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((button = (Button)this.getControl(SEARCH_BUTTONAP)) != null) {
            button.addClickListener((ClickListener)this);
        }
        if ((textEdit = (TextEdit)this.getControl(FILTERDESCDS)) != null) {
            textEdit.addClickListener((ClickListener)this);
        }
    }

    private void beforeF7ResourceRegister(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject plangram = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)PLAN_GRAM);
        if (plangram == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u6848\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8fdb\u9009\u62e9\u9700\u6c42\u754c\u9762", (String)"SelectDemandBillPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObjectCollection entrys = plangram.getDynamicObjectCollection(ENTRY_ENTITY);
        ArrayList<Object> ids = new ArrayList<Object>();
        for (DynamicObject entry : entrys) {
            DynamicObject entrydres = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)RESOURCE_REGISTER);
            DynamicObject entrydemandbill = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrydemandsrc");
            boolean ismrp = DynamicObjDataUtil.getDynamicObjectBooleanData((DynamicObject)entry, (String)"entryismrpoperat");
            if (ismrp && entrydres != null) {
                ids.add(entrydres.getPkValue());
            }
            if (entrydres == null || entrydemandbill == null) continue;
            this.getPageCache().put(entrydres.getPkValue().toString(), entrydemandbill.getPkValue().toString());
        }
        qfilters.add(new QFilter("id", "in", ids));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)RESOURCE_REGISTER)) {
            this.beforeF7ResourceRegister(evt, qfilters);
        }
        if (!qfilters.isEmpty()) {
            listShowParameter.getListFilterParameter().getQFilters().addAll(qfilters);
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        if (event == null) {
            return;
        }
        super.propertyChanged(event);
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            this.propertyChanged(changeData, propertyName);
        }
    }

    private void propertyChanged(ChangeData changeData, String propertyName) {
        Object oldObject = changeData.getOldValue();
        Object newObject = changeData.getNewValue();
        if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)DEMANDBILL, (CharSequence)propertyName)) {
            this.changeBill(propertyName);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)RESOURCE_REGISTER, (CharSequence)propertyName)) {
            this.resChanged(newObject);
        }
    }

    private void resChanged(Object newObject) {
        if (newObject instanceof DynamicObject) {
            DynamicObject res = (DynamicObject)newObject;
            this.getModel().setValue(DEMANDBILL, (Object)this.getPageCache().get(res.getPkValue().toString()));
        } else {
            this.getModel().setValue(DEMANDBILL, null);
        }
    }

    private void changeBill(String key) {
        DynamicObject type = (DynamicObject)this.getModel().getValue(DEMANDBILL);
        this.getView().updateView(FILTERGRIDAP);
        if (type == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FILTERGRIDAP});
            this.getModel().setValue(FILTERDESCDS, null);
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{FILTERGRIDAP});
            DynamicObject resData = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)RESOURCE_REGISTER);
            if (resData == null) {
                return;
            }
            String filterStr = (resData = QueryServiceHelper.queryOne((String)MRP_RESOURCE_DATACONFIG, (String)"filter_tag, filter", (QFilter[])new QFilter[]{new QFilter("id", "=", resData.getPkValue())})) != null ? resData.getString("filter_tag") : "";
            this.setFilterConditionValue(filterStr, type.getString("number"), true);
        }
    }

    private void setFilterConditionValue(String filterStr, String number, boolean changeBillType) {
        if (StringUtils.isNotBlank((CharSequence)filterStr)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
            if (changeBillType) {
                this.changedFilterByBill(DEMANDBILL);
            }
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            filterGrid.SetValue(condition);
            String filterDesc = FilterConditionUtil.translateJsonString((String)filterStr, (String)number);
            this.getModel().setValue(FILTERDESCDS, (Object)filterDesc);
        }
    }

    private void changedFilterByBill(String typeName) {
        DynamicObject currentEntity;
        if (typeName != null && (currentEntity = this.getModel().getDataEntity().getDynamicObject(typeName)) != null) {
            String entityNumber = currentEntity.getString("number");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)mainEntityType);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            filterGrid.setEntityNumber(mainEntityType.getName());
            filterGrid.setFilterColumns(cols);
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Object source = evt.getSource();
        DynamicObject bill = (DynamicObject)this.getModel().getValue(DEMANDBILL);
        DynamicObject resourceregister = (DynamicObject)this.getModel().getValue(RESOURCE_REGISTER);
        if (source instanceof Button) {
            String key2 = ((Button)source).getKey();
            if (StringUtils.equalsIgnoreCase((CharSequence)key2, (CharSequence)SEARCH_BUTTONAP) && this.checkResSource(resourceregister, bill)) {
                this.search(resourceregister, bill);
            }
        } else if (source instanceof TextEdit && StringUtils.equalsIgnoreCase((CharSequence)(key = ((TextEdit)source).getKey()), (CharSequence)FILTERDESCDS) && this.checkResSource(resourceregister, bill)) {
            this.openConditionSet(bill);
        }
    }

    private boolean checkResSource(DynamicObject resourceregister, DynamicObject bill) {
        if (resourceregister == null || bill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u6e90\u914d\u7f6e\u3002", (String)"SelectDemandBillPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void openConditionSet(DynamicObject bill) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("mrp_getdatacondition_set");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "conditionsetcallback"));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        if (bill != null) {
            String number = bill.getString("number");
            params.put("number", number);
        }
        params.put("filter", filterString);
        params.put("row", 1);
        params.put("status", "A");
        fsp.setCustomParams(params);
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map data;
        super.closedCallBack(event);
        if ("conditionsetcallback".equals(event.getActionId()) && (data = (Map)event.getReturnData()) != null) {
            String filter = (String)data.get("filter");
            String number = (String)data.get("number");
            this.setFilterConditionValue(filter, number, false);
            DynamicObject bill = (DynamicObject)this.getModel().getValue(DEMANDBILL);
            DynamicObject resourceregister = (DynamicObject)this.getModel().getValue(RESOURCE_REGISTER);
            this.search(resourceregister, bill);
        }
    }

    private FilterBuilder getFilterBuilder(DynamicObject bill) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        String billId = bill.getPkValue().toString();
        DynamicObject res = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)RESOURCE_REGISTER);
        this.getPageCache().put(FILTERGRIDAP, filterString);
        this.getPageCache().put(DEMANDBILL, billId);
        this.getPageCache().put(RESOURCE_REGISTER, res == null ? "" : res.getPkValue().toString());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billId);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, filterGridState.getFilterCondition());
        try {
            UserService userService = new UserService();
            filterBuilder.setUserService((IUserService)userService);
            filterBuilder.buildFilter(false);
        }
        catch (Exception e) {
            logger.error("\u5b58\u5728\u6709\u8fc7\u6ee4\u6761\u4ef6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            this.getView().showErrorNotification(e.toString());
            return null;
        }
        return filterBuilder;
    }

    private void doSearch(DynamicObject config, QFilter qFilter) {
        if (config != null) {
            Long resId = config.getLong("id");
            if (qFilter == null) {
                qFilter = new QFilter("1", "=", (Object)"1", true);
            }
            FetchDataQueryModule queryMD = DataSourceUtil.getQueryModuleByModelFilter((Long)resId, (QFilter)qFilter);
            int maxRowCount = SelectDemandBillPlugin.getMaxRowCount();
            int count = 0;
            String billEntryKey = null;
            for (String selectField : queryMD.getSelFields()) {
                if (!selectField.contains(DefaultField.RequireField.BILLENTRYID.getName().toLowerCase(Locale.ENGLISH))) continue;
                String quStr = selectField.substring(selectField.indexOf("(") + 1, selectField.indexOf(")"));
                String[] split = quStr.split("\\.");
                if (split.length < 2) break;
                billEntryKey = split[0];
                break;
            }
            try (DataSet dataSet = DataSourceUtil.getDataSetByModel((FetchDataQueryModule)queryMD, (DataSet)QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)queryMD.getMt(), (String)queryMD.getOql(), (QFilter[])queryMD.getqFilters(), null));){
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                TableValueSetter vs = this.createEntrys(model);
                count = this.initRowData(dataSet, resId, billEntryKey, vs, maxRowCount);
                this.getModel().deleteEntryData(ENTRY_ENTITY);
                model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
                model.endInit();
                this.getView().updateView(ENTRY_ENTITY);
            }
            if (maxRowCount < count) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u884c\u6570(%1$s)\u8d85\u8fc7[\u9009\u5355/\u6a21\u62df\u6700\u5927\u884c\u6570\u63a7\u5236(%2$s)]\uff0c\u4ec5\u663e\u793a\u524d%3$s\u884c\u6570\u636e\u3002", (String)"SelectDemandBillPlugin_9", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), count, maxRowCount, maxRowCount));
            }
        }
    }

    public static int getMaxRowCount() {
        int maxRowCount = (Integer)MRPUtil.convert((Object)EnvCfgItem.SIMULATE_MAX_ROW_COUNT.getDefaultValue(), (Object)200);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"mrp_runconfig", (String)"id,param", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)EnvCfgItem.SIMULATE_MAX_ROW_COUNT.name())});
        if (queryOne != null) {
            maxRowCount = (Integer)MRPUtil.convert((Object)queryOne.get("param"), (Object)maxRowCount);
        }
        return maxRowCount;
    }

    private int initRowData(DataSet dataSet, Long resId, String billEntryKey, TableValueSetter vs, int maxRowCount) {
        int seq = 0;
        int count = 0;
        RowMeta rowMeta = dataSet.getRowMeta();
        boolean showCalcedReq = DynamicObjDataUtil.getDataModelBooleanData((IDataModel)this.getModel(), (String)"showcalcedreq");
        HashSet<String> calculatedRequires = new HashSet<String>(16);
        if (!showCalcedReq) {
            try (DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"mrp_reqcalc_record", (String)"bill_id,billentry_id", (QFilter[])new QFilter[0], null);){
                while (dataSet1.hasNext()) {
                    Row row = dataSet1.next();
                    calculatedRequires.add(String.format("%s-%s", row.get("bill_id"), row.get("billentry_id")));
                }
            }
        }
        while (dataSet.hasNext()) {
            Long entryid;
            Row row = dataSet.next();
            if (++count > maxRowCount) continue;
            Long id = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.BILLID.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.BILLID.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long l = entryid = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.BILLENTRYID.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.BILLENTRYID.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            if (calculatedRequires.contains(String.format("%s-%s", id, entryid))) continue;
            Integer entryseq = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.BILLENTRYSEQ.getName().toLowerCase(Locale.ENGLISH)) ? (Integer)MRPUtil.convert((Object)row.getInteger(DefaultField.RequireField.BILLENTRYSEQ.getName().toLowerCase(Locale.ENGLISH)), (Object)0) : Integer.valueOf(0);
            String entrybillno = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.BILLNUMBER.getName().toLowerCase(Locale.ENGLISH)) ? (String)MRPUtil.convert((Object)row.getString(DefaultField.RequireField.BILLNUMBER.getName().toLowerCase(Locale.ENGLISH)), (Object)"") : "";
            Long entrymaterial = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.MATERIAL.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.get(DefaultField.RequireField.MATERIAL.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long entryunit = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.BASEUNIT.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.get(DefaultField.RequireField.BASEUNIT.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            BigDecimal demandqty = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.QTY.getName().toLowerCase(Locale.ENGLISH)) ? (BigDecimal)MRPUtil.convert((Object)row.get(DefaultField.RequireField.QTY.getName().toLowerCase(Locale.ENGLISH)), (Object)BigDecimal.ZERO) : BigDecimal.ZERO;
            Date demanddate = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.DATE.getName().toLowerCase(Locale.ENGLISH)) ? row.getDate(DefaultField.RequireField.DATE.getName().toLowerCase(Locale.ENGLISH)) : null;
            Long requireorg = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.PRODUCTIONORGUNIT.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long billtype = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.ENTRYENTITYBILLTYPE.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.ENTRYENTITYBILLTYPE.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long configuredcode = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.CONFIGUREDCODE.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.CONFIGUREDCODE.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long tracknumber = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.TRACKNUMBER.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.TRACKNUMBER.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long auxpty = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.MATERIALFLEXPROPS.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.MATERIALFLEXPROPS.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            Long projectNumber = SelectDemandBillPlugin.havProperty(rowMeta, DefaultField.RequireField.PROJECTNUMBER.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.PROJECTNUMBER.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("id", id);
            map.put("entryid", entryid);
            map.put("entryseq", entryseq);
            map.put("entrybillno", entrybillno);
            map.put("entrymaterial", entrymaterial);
            map.put("entryunit", entryunit);
            map.put("demandqty", demandqty);
            map.put("demanddate", demanddate);
            map.put("requireorg", requireorg);
            map.put("billtype", billtype);
            map.put("configuredcode", configuredcode);
            map.put("tracknumber", tracknumber);
            map.put("auxpty", auxpty);
            map.put("projectnumber", projectNumber);
            this.initEntryVs(map, resId, vs, ++seq, billEntryKey);
        }
        return count;
    }

    public static boolean havProperty(RowMeta rowMeta, String field) {
        return rowMeta.getFieldIndex(field, false) >= 0;
    }

    private void search(DynamicObject resourceregister, DynamicObject bill) {
        if (bill == null || resourceregister == null) {
            return;
        }
        FilterBuilder filterBuilder = this.getFilterBuilder(bill);
        if (filterBuilder == null) {
            return;
        }
        try {
            this.doSearch(resourceregister, filterBuilder.getQFilter());
        }
        catch (Exception e) {
            logger.error("\u5b57\u6bb5\u6620\u5c04\u5f02\u5e38", (Throwable)e);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u5f02\u5e38", (String)"SelectDemandBillPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
        }
    }

    private void initEntryVs(Map<String, Object> map, Long billType, TableValueSetter vs, int seq, String billEntryKey) {
        boolean isSelect = this.checkIsSelect(billType, map.get("id"), map.get("entryid"));
        vs.addRow(new Object[]{seq, map.get("entrybillno"), map.get("entrymaterial"), map.get("entryunit"), map.get("demandqty"), map.get("demanddate"), billType, map.get("id"), map.get("entryid"), isSelect, map.get("entryseq"), billEntryKey, map.get("requireorg"), map.get("billtype"), map.get("configuredcode"), map.get("tracknumber"), map.get("auxpty"), map.get("projectnumber")});
    }

    private boolean checkIsSelect(Long billType, Object id, Object entryid) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity1");
        for (DynamicObject entry : entrys) {
            Long id1 = entry.getLong("billid1");
            Long entryid1 = entry.getLong("billentryid1");
            DynamicObject entrybilltype = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrybilltype1");
            if (entrybilltype == null || !StringUtils.equalsIgnoreCase((CharSequence)billType.toString(), (CharSequence)entrybilltype.getPkValue().toString()) || !id.equals(id1) || !entryid.equals(entryid1)) continue;
            return true;
        }
        return false;
    }

    private TableValueSetter createEntrys(AbstractFormDataModel model) {
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField("entrybillno", new Object[0]);
        vs.addField("entrymaterial", new Object[0]);
        vs.addField("entryunit", new Object[0]);
        vs.addField("demandqty", new Object[0]);
        vs.addField("demanddate", new Object[0]);
        vs.addField("entrybilltype", new Object[0]);
        vs.addField("billid", new Object[0]);
        vs.addField("billentryid", new Object[0]);
        vs.addField("iselect", new Object[0]);
        vs.addField("entryseq", new Object[0]);
        vs.addField("billentrykey", new Object[0]);
        vs.addField("requireorg", new Object[0]);
        vs.addField("billtype", new Object[0]);
        vs.addField("configuredcode", new Object[0]);
        vs.addField("tracknumber", new Object[0]);
        vs.addField("auxpty", new Object[0]);
        vs.addField("projectnumber", new Object[0]);
        return vs;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key = evt.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)ADD_ENTRY, (CharSequence)key)) {
            this.doAddEntry();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SURE, (CharSequence)key)) {
            this.doSure();
        }
    }

    private void doSure() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity1");
        if (entrys.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u9700\u6c42\u6e05\u5355\u4e3a\u7a7a\u3002", (String)"SelectDemandBillPlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(ENTRY_ENTITY, null);
            return;
        }
        int maxRowCount = SelectDemandBillPlugin.getMaxRowCount();
        if (entrys.size() > maxRowCount) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u9700\u6c42\u6e05\u5355\u884c\u6570\u8d85\u8fc7[\u9009\u5355/\u6a21\u62df\u6700\u5927\u884c\u6570\u63a7\u5236(%s)]", (String)"SelectDemandBillPlugin_8", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), maxRowCount));
            return;
        }
        String str = SerializationUtils.toJsonString(this.getPageCacheList(entrys));
        this.getPageCache().put(ENTRY_ENTITY, str);
    }

    private List<Map<String, Object>> getPageCacheList(DynamicObjectCollection entrys) {
        ArrayList<Map<String, Object>> lists = new ArrayList<Map<String, Object>>();
        for (DynamicObject entry : entrys) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            DynamicObject entrymaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrymaterial1");
            DynamicObject entryunit = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entryunit1");
            DynamicObject entrybilltype = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrybilltype1");
            DynamicObject requireorg = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"requireorg1");
            DynamicObject billtype = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"billtype1");
            DynamicObject configuredcode = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"configuredcode1");
            DynamicObject tracknumber = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"tracknumber1");
            DynamicObject auxpty = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"auxpty1");
            DynamicObject projectnumber = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"projectnumber1");
            map.put("entrybillno", entry.get("entrybillno1"));
            map.put("entrymaterial", entrymaterial == null ? Long.valueOf(0L) : entrymaterial.getPkValue());
            map.put("entryunit", entryunit == null ? Long.valueOf(0L) : entryunit.getPkValue());
            map.put("entrybilltype", entrybilltype == null ? Long.valueOf(0L) : entrybilltype.getPkValue());
            map.put("demandqty", entry.get("demandqty1"));
            map.put("demanddate", entry.getDate("demanddate1") == null ? null : Long.valueOf(entry.getDate("demanddate1").getTime()));
            map.put("billentryid", entry.get("billentryid1"));
            map.put("billid", entry.get("billid1"));
            map.put("entryseq", entry.get("entryseq1"));
            map.put("billentrykey", entry.get("billentrykey1"));
            map.put("requireorg", requireorg == null ? Long.valueOf(0L) : requireorg.getPkValue());
            map.put("billtype", billtype == null ? Long.valueOf(0L) : billtype.getPkValue());
            map.put("configuredcode", configuredcode == null ? Long.valueOf(0L) : configuredcode.getPkValue());
            map.put("tracknumber", tracknumber == null ? Long.valueOf(0L) : tracknumber.getPkValue());
            map.put("auxpty", auxpty == null ? Long.valueOf(0L) : auxpty.getPkValue());
            map.put("projectnumber", projectnumber == null ? Long.valueOf(0L) : projectnumber.getPkValue());
            lists.add(map);
        }
        return lists;
    }

    private void beforeDoRemove(int[] indexs) {
        block0: for (int i : indexs) {
            DynamicObject entry = this.getModel().getEntryRowEntity("entryentity1", i);
            Long id1 = entry.getLong("billid1");
            Long entryid1 = entry.getLong("billentryid1");
            DynamicObject entrybilltype1 = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrybilltype1");
            DynamicObjectCollection onEntrys = this.getModel().getEntryEntity(ENTRY_ENTITY);
            for (int k = 0; k < onEntrys.size(); ++k) {
                DynamicObject onEntry = (DynamicObject)onEntrys.get(k);
                Long id = onEntry.getLong("billid");
                Long entryid = onEntry.getLong("billentryid");
                DynamicObject entrybilltype = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)onEntry, (String)"entrybilltype");
                if (!id.equals(id1) || !entryid.equals(entryid1) || entrybilltype1 == null || entrybilltype == null || !StringUtils.equalsIgnoreCase((CharSequence)entrybilltype1.getPkValue().toString(), (CharSequence)entrybilltype.getPkValue().toString())) continue;
                this.getModel().setValue("iselect", (Object)Boolean.FALSE, k);
                continue block0;
            }
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] indexs = e.getRowIndexs();
        String name = e.getEntryProp().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)"entryentity1", (CharSequence)name)) {
            this.beforeDoRemove(indexs);
        }
    }

    private int addEntry(int[] selectIndes, StringBuilder error, TableValueSetter vs) {
        int success = 0;
        int seq = 1;
        for (int i : selectIndes) {
            DynamicObject entry = this.getModel().getEntryRowEntity(ENTRY_ENTITY, i);
            boolean isSelect = DynamicObjDataUtil.getDynamicObjectBooleanData((DynamicObject)entry, (String)"iselect");
            String entrybillno = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entry, (String)"entrybillno");
            if (isSelect) {
                error.append(String.format(ResManager.loadKDString((String)"\u5f85\u9009\u9700\u6c42\u6e05\u5355\u7b2c%1$s\u884c\uff0c\u5355\u636e\u7f16\u53f7[%2$s]\uff1a\u5df2\u88ab\u79fb\u5165\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", (String)"SelectDemandBillPlugin_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), i + 1, entrybillno)).append("\n\r");
                continue;
            }
            this.getModel().setValue("iselect", (Object)Boolean.TRUE, i);
            DynamicObject entrymaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrymaterial");
            DynamicObject entryunit = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entryunit");
            DynamicObject entrybilltype = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrybilltype");
            DynamicObject requireorg = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"requireorg");
            DynamicObject billtype = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"billtype");
            DynamicObject configuredcode = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"configuredcode");
            DynamicObject tracknumber = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"tracknumber");
            DynamicObject auxpty = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"auxpty");
            DynamicObject projectnumber = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"projectnumber");
            vs.addRow(new Object[]{seq++, entrybillno, entrymaterial == null ? null : entrymaterial.getPkValue(), entryunit == null ? null : entryunit.getPkValue(), entry.get("demandqty"), entry.get("demanddate"), entrybilltype == null ? null : entrybilltype.getPkValue(), entry.get("billid"), entry.get("billentryid"), entry.get("entryseq"), entry.get("billentrykey"), requireorg == null ? null : requireorg.getPkValue(), billtype == null ? null : billtype.getPkValue(), configuredcode == null ? null : configuredcode.getPkValue(), tracknumber == null ? null : tracknumber.getPkValue(), auxpty == null ? null : auxpty.getPkValue(), projectnumber == null ? null : projectnumber.getPkValue()});
            ++success;
        }
        return success;
    }

    private int initAddEntryVs(int[] selectIndes, StringBuilder error, TableValueSetter vs) {
        vs.addField("seq", new Object[0]);
        vs.addField("entrybillno1", new Object[0]);
        vs.addField("entrymaterial1", new Object[0]);
        vs.addField("entryunit1", new Object[0]);
        vs.addField("demandqty1", new Object[0]);
        vs.addField("demanddate1", new Object[0]);
        vs.addField("entrybilltype1", new Object[0]);
        vs.addField("billid1", new Object[0]);
        vs.addField("billentryid1", new Object[0]);
        vs.addField("entryseq1", new Object[0]);
        vs.addField("billentrykey1", new Object[0]);
        vs.addField("requireorg1", new Object[0]);
        vs.addField("billtype1", new Object[0]);
        vs.addField("configuredcode1", new Object[0]);
        vs.addField("tracknumber1", new Object[0]);
        vs.addField("auxpty1", new Object[0]);
        vs.addField("projectnumber1", new Object[0]);
        return this.addEntry(selectIndes, error, vs);
    }

    private void doAddEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        if (entryGrid == null) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        StringBuilder error = new StringBuilder();
        int[] selectIndes = entryGrid.getSelectRows();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        int success = this.initAddEntryVs(selectIndes, error, vs);
        if (error.length() > 0) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff1a%1$s\u6761\uff0c\u5931\u8d25\uff1a%2$s\u6761", (String)"SelectDemandBillPlugin_5", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), success, selectIndes.length - success), error.toString(), MessageTypes.Default);
        } else if (success != 0) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff1a%s\u6761", (String)"SelectDemandBillPlugin_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), success));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"SelectDemandBillPlugin_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        model.batchCreateNewEntryRow("entryentity1", vs);
        model.endInit();
        this.getView().updateView("entryentity1");
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String filterString = this.getPageCache().get(FILTERGRIDAP);
        String billId = this.getPageCache().get(DEMANDBILL);
        String resId = this.getPageCache().get(RESOURCE_REGISTER);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(FILTERGRIDAP, filterString);
        map.put(DEMANDBILL, billId);
        map.put(RESOURCE_REGISTER, resId);
        DynamicObject plangram = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)PLAN_GRAM);
        String planId = plangram == null ? "" : plangram.getString("id");
        String pt = plangram != null ? plangram.getDynamicObjectType().getName() : "";
        SelectPlanSessionCache.putCache((String)pt, (String)SelectPlanSessionCache.getDataKey((String)pt, (String)planId, (String)FILTERGRIDAP), (String)(filterString == null ? "" : filterString));
        SelectPlanSessionCache.putCache((String)pt, (String)SelectPlanSessionCache.getDataKey((String)pt, (String)planId, (String)DEMANDBILL), (String)(billId == null ? "" : billId));
        SelectPlanSessionCache.putCache((String)pt, (String)SelectPlanSessionCache.getDataKey((String)pt, (String)planId, (String)RESOURCE_REGISTER), (String)(resId == null ? "" : resId));
        String str = this.getPageCache().get(ENTRY_ENTITY);
        map.put(ENTRY_ENTITY, str);
        this.getView().returnDataToParent(map);
    }
}

