/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.planexecute;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.cache.SelectMaterialPlanSessionCache;
import kd.mmc.mrp.common.util.ControlUtil;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.controlnode.framework.runner.MRPRunner4SMaterPlan;
import kd.mmc.mrp.formplugin.planexecute.GlobalPlanPlugin;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.MRPIntegrateFactory;

public class SelectMaterialPlanPlugin
extends GlobalPlanPlugin
implements BeforeF7SelectListener {
    private static final String MPDM_MATERIAL_PLAN = "mpdm_materialplan";
    private static final String BD_MATERIALGROUPDETAIL = "bd_materialgroupdetail";
    private static final String BD_MATERIALGROUP = "bd_materialgroup";
    private static final String ENTRY_MATERIAL = "entrymaterial";
    private static final String ENTRY_MATERIAL_TYPE = "entrymaterialtype";
    private static final String ENTRY_PLANSCOPE = "entryplanscope";
    private static final String ENTRY_REQUIREORG = "entryrequireorg";
    private static final String ENTRY_ENTITY = "entryentity";

    @Override
    public void afterCreateNewData(EventObject e) {
        this.setOrgByPermission();
        String orgId = SelectMaterialPlanSessionCache.getCache((String)"org");
        String plan_gramId = SelectMaterialPlanSessionCache.getCache((String)"plangram");
        this.setOrgAndPlanGramByCache(orgId, plan_gramId);
        if (this.isEnablePlanScope()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ENTRY_MATERIAL_TYPE});
            this.getView().setVisible(Boolean.TRUE, new String[]{ENTRY_PLANSCOPE, ENTRY_REQUIREORG});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{ENTRY_MATERIAL_TYPE});
            this.getView().setVisible(Boolean.FALSE, new String[]{ENTRY_PLANSCOPE, ENTRY_REQUIREORG});
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        FormOperate op = (FormOperate)e.getSource();
        String string = key = op != null ? op.getOperateKey() : "";
        if (StringUtils.equalsIgnoreCase((CharSequence)"startcaculate", (CharSequence)key)) {
            int size = this.getModel().getEntryRowCount(ENTRY_ENTITY);
            if (size <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7269\u6599\u8303\u56f4\u3002", (String)"SelectMaterialPlanPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            StringBuilder mIdx = new StringBuilder();
            StringBuilder pIdx = new StringBuilder();
            boolean isEnablePlanScope = this.isEnablePlanScope();
            for (int i = 0; i < size; ++i) {
                DynamicObject entry = this.getModel().getEntryRowEntity(ENTRY_ENTITY, i);
                DynamicObject type = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)ENTRY_MATERIAL_TYPE);
                DynamicObject material = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)ENTRY_MATERIAL);
                DynamicObject planScope = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)ENTRY_PLANSCOPE);
                if ((isEnablePlanScope || type == null) && material == null) {
                    if (mIdx.length() > 0) {
                        mIdx.append('\uff0c');
                    }
                    mIdx.append(i + 1);
                }
                if (planScope != null) continue;
                if (pIdx.length() > 0) {
                    pIdx.append('\uff0c');
                }
                pIdx.append(i + 1);
            }
            StringBuilder error = new StringBuilder();
            if (mIdx.length() > 0) {
                if (isEnablePlanScope) {
                    error.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\u8303\u56f4\u7b2c%s\u884c\uff0c\u7269\u6599\u4e3a\u7a7a\u3002", (String)"SelectMaterialPlanPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), mIdx.toString()));
                } else {
                    error.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\u8303\u56f4\u7b2c%s\u884c\uff0c\u7269\u6599\u5206\u7c7b\u548c\u7269\u6599\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u9879\u3002", (String)"SelectMaterialPlanPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), mIdx.toString()));
                }
            }
            if (isEnablePlanScope && pIdx.length() > 0) {
                if (error.length() > 0) {
                    error.append("\r\n");
                }
                error.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\u8303\u56f4\u7b2c%s\u884c\uff0c\u8ba1\u5212\u8303\u56f4\u4e3a\u7a7a\u3002", (String)"SelectMaterialPlanPlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), pIdx.toString()));
            }
            if (error.length() > 0) {
                if (error.toString().contains("\r\n")) {
                    this.getView().showMessage("", error.toString(), MessageTypes.Default);
                } else {
                    this.getView().showTipNotification(error.toString());
                }
                e.setCancel(true);
                return;
            }
        }
        super.beforeDoOperation(e);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        super.propertyChanged(event);
        String propertyName = event.getProperty().getName();
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            this.propertyChanged(changeData, propertyName);
        }
    }

    private void propertyChanged(ChangeData changeData, String propertyName) {
        Object oldObject = changeData.getOldValue();
        Object newObject = changeData.getNewValue();
        DynamicObject propertyValueCDDE = changeData.getDataEntity();
        if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)"org", (CharSequence)propertyName)) {
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"plangram", null);
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            this.getModel().createNewEntryRow(ENTRY_ENTITY);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"plangram", (CharSequence)propertyName)) {
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            this.getModel().createNewEntryRow(ENTRY_ENTITY);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ENTRY_MATERIAL, (CharSequence)propertyName) || StringUtils.equalsIgnoreCase((CharSequence)ENTRY_MATERIAL_TYPE, (CharSequence)propertyName)) {
            if (newObject == null) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{ENTRY_MATERIAL, ENTRY_MATERIAL_TYPE});
            } else {
                String otherField = StringUtils.equalsIgnoreCase((CharSequence)ENTRY_MATERIAL, (CharSequence)propertyName) ? ENTRY_MATERIAL_TYPE : ENTRY_MATERIAL;
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)otherField, null, (int)rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{otherField});
            }
            this.getModel().setValue(ENTRY_PLANSCOPE, null);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ENTRY_PLANSCOPE, (CharSequence)propertyName)) {
            DynamicObject plan = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"plangram");
            DynamicObject material = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)ENTRY_MATERIAL, (int)rowIndex);
            DynamicObject planScope = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)ENTRY_PLANSCOPE, (int)rowIndex);
            if (plan != null && material != null && planScope != null) {
                DynamicObjectCollection orgcoll = plan.getDynamicObjectCollection("orgentryentity");
                for (DynamicObject orgc : orgcoll) {
                    DynamicObject requireOrg = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)orgc, (String)"entrydemandorg");
                    DynamicObject planscope = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)orgc, (String)ENTRY_PLANSCOPE);
                    if (requireOrg == null || planscope == null) continue;
                    QFilter qFilter = new QFilter("createorg", "=", requireOrg.getPkValue());
                    qFilter.and(new QFilter("material", "=", material.getPkValue()));
                    qFilter.and(new QFilter("entrymatplanscop.planscope", "=", planScope.getPkValue()));
                    if (!StringUtils.equalsIgnoreCase((CharSequence)planScope.getString("id"), (CharSequence)planscope.getString("id")) && !QueryServiceHelper.exists((String)"msplan_matplanscop", (QFilter[])new QFilter[]{qFilter})) continue;
                    this.getModel().setValue(ENTRY_REQUIREORG, requireOrg.getPkValue(), rowIndex);
                    break;
                }
            } else {
                this.getModel().setValue(ENTRY_REQUIREORG, null, rowIndex);
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit planscope;
        BasedataEdit type;
        super.registerListener(e);
        BasedataEdit material = (BasedataEdit)this.getView().getControl(ENTRY_MATERIAL);
        if (material != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((type = (BasedataEdit)this.getView().getControl(ENTRY_MATERIAL_TYPE)) != null) {
            type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((planscope = (BasedataEdit)this.getView().getControl(ENTRY_PLANSCOPE)) != null) {
            planscope.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        int row = evt.getRow();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)ENTRY_MATERIAL) || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)ENTRY_MATERIAL_TYPE)) {
            Long orgId = this.checkOrgIsNull();
            if (orgId == null || orgId <= 0L) {
                evt.setCancel(true);
            } else {
                Set<Long> exist = this.getExistData(key);
                if (!exist.isEmpty()) {
                    qfilters.add(new QFilter("id", "not in", exist));
                }
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)ENTRY_PLANSCOPE)) {
            Long orgId = this.checkOrgIsNull();
            DynamicObject material = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)ENTRY_MATERIAL, (int)row);
            if (orgId == null || orgId <= 0L) {
                evt.setCancel(true);
            } else if (material == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u8303\u56f4\u7b2c%s\u884c\uff0c\u8bf7\u5148\u5f55\u5165\u7269\u6599\u7f16\u7801\u3002", (String)"SelectMaterialPlanPlugin_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row + 1));
                evt.setCancel(true);
            } else {
                List<Long> ids = this.getFilterPlanScopeByMaterial(material.getLong("id"));
                qfilters.add(new QFilter("id", "in", ids));
            }
        }
        if (!qfilters.isEmpty()) {
            listShowParameter.getListFilterParameter().getQFilters().addAll(qfilters);
        }
    }

    private List<Long> getFilterPlanScopeByMaterial(Long mid) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        DynamicObject org = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"org");
        DynamicObject plan = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"plangram");
        if (org != null && plan != null) {
            DynamicObjectCollection orgcoll = plan.getDynamicObjectCollection("orgentryentity");
            ArrayList<Long> requireOrgs = new ArrayList<Long>(orgcoll.size());
            for (DynamicObject orgc : orgcoll) {
                DynamicObject planscope = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)orgc, (String)ENTRY_PLANSCOPE);
                DynamicObject requireOrg = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)orgc, (String)"entrydemandorg");
                if (planscope != null) {
                    ids.add(planscope.getLong("id"));
                }
                if (requireOrg == null) continue;
                requireOrgs.add(requireOrg.getLong("id"));
            }
            QFilter qFilter = new QFilter("material", "=", (Object)mid);
            qFilter.and(new QFilter("createorg", "in", requireOrgs));
            QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
            qFilterEnable.and(new QFilter("entrymatplanscop.start_useing", "=", (Object)"1"));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"msplan_matplanscop", (String)"entrymatplanscop.planscope planscope", (QFilter[])new QFilter[]{qFilter, qFilterEnable}, null);){
                for (Row row : dataSet) {
                    ids.add(row.getLong(0));
                }
            }
        }
        return ids;
    }

    private Set<Long> getExistData(String entryField) {
        DynamicObjectCollection cols = this.getModel().getEntryEntity(ENTRY_ENTITY);
        HashSet<Long> ids = new HashSet<Long>(cols.size());
        for (DynamicObject entry : cols) {
            DynamicObject data = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)entryField);
            Long id = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)data);
            if (id <= 0L) continue;
            ids.add(id);
        }
        return ids;
    }

    @Override
    protected void runMRP4Global(String number) {
        Object entry2;
        HashSet<String> mids = new HashSet<String>(16);
        HashSet<Long> mTypeIds = new HashSet<Long>(16);
        HashMap<String, Map> org2material = new HashMap<String, Map>(this.getModel().getEntryRowCount(ENTRY_ENTITY));
        for (Object entry2 : this.getModel().getEntryEntity(ENTRY_ENTITY)) {
            DynamicObject type = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry2, (String)ENTRY_MATERIAL_TYPE);
            DynamicObject material = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry2, (String)ENTRY_MATERIAL);
            DynamicObject planscope = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry2, (String)ENTRY_PLANSCOPE);
            DynamicObject requireorg = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry2, (String)ENTRY_REQUIREORG);
            if (material != null) {
                mids.add(material.getString("id"));
                if (planscope == null || requireorg == null) continue;
                Map mid2Scope = org2material.computeIfAbsent(requireorg.getString("id"), k -> new HashMap(2));
                Set scopeKey = mid2Scope.computeIfAbsent(material.getString("id"), k -> new HashSet(2));
                scopeKey.add(planscope.getString("id"));
                continue;
            }
            if (type == null) continue;
            mTypeIds.add(type.getLong("id"));
        }
        mTypeIds.addAll(this.getAllLowerLevelType(mTypeIds));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)BD_MATERIALGROUPDETAIL, (String)"material", (QFilter[])new QFilter[]{new QFilter("group", "in", mTypeIds)}, null);
        entry2 = null;
        try {
            for (Row row : dataSet) {
                String mid = row.getString("material");
                if (mid == null || mid.equals("0")) continue;
                mids.add(mid);
            }
        }
        catch (Throwable type) {
            entry2 = type;
            throw type;
        }
        finally {
            if (dataSet != null) {
                if (entry2 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable type) {
                        ((Throwable)entry2).addSuppressed(type);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        boolean is_single_calc = DynamicObjDataUtil.getDataModelBooleanData((IDataModel)this.getModel(), (String)"is_single_calc");
        DynamicObject caculateLog = this.createNewLog(number);
        IMRPEnvProvider env = MRPIntegrateFactory.createMRPEnv((DynamicObject)caculateLog);
        new MRPRunner4SMaterPlan(mids, org2material, is_single_calc).run(env);
        DynamicObject org = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"org");
        DynamicObject plangram = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"plangram");
        SelectMaterialPlanSessionCache.putCache((String)"org", (String)(org == null ? "" : org.getString("id")));
        SelectMaterialPlanSessionCache.putCache((String)"plangram", (String)(plangram == null ? "" : plangram.getString("id")));
        this.showLogForm(caculateLog.getLong("id"));
    }

    private Set<Long> getAllLowerLevelType(Set<Long> mTypePIds) {
        HashSet<Long> mTypeIds = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)BD_MATERIALGROUP, (String)"id", (QFilter[])new QFilter[]{new QFilter("parent", "in", mTypePIds)}, null);){
            for (Row row : dataSet) {
                mTypeIds.add(row.getLong("id"));
            }
        }
        if (!mTypeIds.isEmpty()) {
            mTypeIds.addAll(this.getAllLowerLevelType(mTypeIds));
        }
        return mTypeIds;
    }
}

