/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.planexecute;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.BillStatus;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class XPlanOrderChangeLogListPlugin
extends AbstractListPlugin {
    private static final String CHANGE = "change";
    private static final String CHANGECONFIRMCALLBACK = "changeConfirmCallBack";
    private static final String ISCHECK = "ischeck";

    public void filterContainerInit(FilterContainerInitArgs args) {
        Object customParam = this.getView().getFormShowParameter().getCustomParam("billFormId");
        if (null != customParam && !StringUtils.equals((CharSequence)"mrp_xplanorderlog", (CharSequence)customParam.toString())) {
            return;
        }
        super.filterContainerInit(args);
        List produceOrgIdFilter = (List)this.getView().getFormShowParameter().getCustomParam("useorgIdFilter");
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            List defaultValues;
            String fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)"proorpurorg", (CharSequence)fieldName) || (defaultValues = filterColumn.getDefaultValues()).isEmpty() || null == produceOrgIdFilter) continue;
            defaultValues.clear();
            if (produceOrgIdFilter.size() != 1) continue;
            String produceOrgId = produceOrgIdFilter.get(0).toString();
            filterColumn.setDefaultValue(produceOrgId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if (op == null) {
            return;
        }
        String key = op.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)CHANGE)) {
            this.beforeChange(e);
        }
    }

    private void beforeChange(BeforeDoOperationEventArgs e) {
        String isCheck = this.getPageCache().get(ISCHECK);
        if ("true".equals(isCheck)) {
            this.getPageCache().remove(ISCHECK);
            return;
        }
        ListSelectedRowCollection listSelectedRows = e.getListSelectedData();
        if (listSelectedRows == null || listSelectedRows.size() <= 1) {
            return;
        }
        ArrayList<String> errmsg = new ArrayList<String>();
        StringBuilder errStr = new StringBuilder();
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            String billNo = listSelectedRow.getBillNo();
            String billStatus = listSelectedRow.getBillStatus();
            if (billStatus.equals(BillStatus.C.name())) continue;
            e.cancel = true;
            String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5355\u636e\u72b6\u6001\u8981\u4e3a\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u624d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"XPlanOrderChangeLogListPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), billNo);
            errmsg.add(msg);
            errStr.append(msg).append("\r\n");
        }
        if (errmsg.size() == listSelectedRows.size() && errmsg.size() >= 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53d8\u66f4\u5931\u8d25", (String)"XPlanOrderChangeLogListPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), errStr.toString(), MessageTypes.Default);
            return;
        }
        if (errmsg.size() != listSelectedRows.size() && errmsg.size() >= 1) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5b58\u5728%s\u6761\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\uff0c\u662f\u5426\u7ee7\u7eed\u53d8\u66f4\u5176\u4ed6\u6570\u636e?", (String)"XPlanOrderChangeLogListPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), errmsg.size()), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CHANGECONFIRMCALLBACK, (IFormPlugin)this));
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (CHANGECONFIRMCALLBACK.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put(ISCHECK, "true");
            this.getView().invokeOperation(CHANGE);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (!StringUtils.equals((CharSequence)"tblshowchangelog", (CharSequence)evt.getOperationKey())) {
            return;
        }
        ListSelectedRowCollection listSelectedData = this.getSelectedRows();
        if (listSelectedData.isEmpty()) {
            return;
        }
        ArrayList<Long> entryKeyValues = new ArrayList<Long>();
        ArrayList<Long> entryOrgValues = new ArrayList<Long>();
        for (ListSelectedRow listSelectedRow : listSelectedData) {
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            long mainOrgId = listSelectedRow.getMainOrgId();
            if (!entryOrgValues.contains(mainOrgId)) {
                entryOrgValues.add(mainOrgId);
            }
            entryKeyValues.add(Long.valueOf(primaryKeyValue.toString()));
        }
        boolean filterOrgPermission = this.filterOrgPermission(entryOrgValues);
        if (!filterOrgPermission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8ba1\u5212\u8ba2\u5355\u53d8\u66f4\u65e5\u5fd7\u201d\u67e5\u770b\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"XPlanOrderChangeLogListPlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        ListView view = (ListView)this.getView();
        String billFormId = view.getBillFormId();
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        String filterName = "srcbillid";
        if (StringUtils.equals((CharSequence)"mrp_xplanorder", (CharSequence)billFormId)) {
            filterName = "xbillid";
        }
        QFilter entryFilter = new QFilter(filterName, "in", entryKeyValues);
        filters.add(entryFilter);
        listShowParameter.setCustomParam("useorgIdFilter", entryOrgValues);
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("mrp_xplanorderlog");
        view.showForm((FormShowParameter)listShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        BillList billList;
        ListSelectedRow lsr;
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("changelogdetail".equals(afterDoOperationEventArgs.getOperateKey()) && (lsr = (billList = (BillList)this.getView().getControl("billlistap")).getCurrentSelectedRowInfo()) != null && lsr.getPrimaryKeyValue() != null) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId(lsr.getPrimaryKeyValue());
            billShowParameter.setFormId("mrp_xplanorderlog");
            billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private boolean filterOrgPermission(List<Long> entryOrgValues) {
        PermissionServiceHelper.clearAllCache();
        Long userId = RequestContext.get().getCurrUserId();
        String appId = ShowFormHelper.getBizAppId((FormShowParameter)this.getView().getFormShowParameter());
        String permItemId = "47150e89000000ac";
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)"mrp_xplanorderlog", (String)permItemId);
        if (allPermOrgs.hasAllOrgPerm()) {
            return allPermOrgs.hasAllOrgPerm();
        }
        Iterator<Long> iterator = entryOrgValues.iterator();
        List allPermissionOrgs = allPermOrgs.getHasPermOrgs();
        while (iterator.hasNext()) {
            Long produceOrgId = iterator.next();
            if (allPermissionOrgs.contains(produceOrgId)) continue;
            if (entryOrgValues.size() == 1) {
                return false;
            }
            iterator.remove();
        }
        return true;
    }
}

