/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.pls;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SchemeListPlugin
extends AbstractListPlugin {
    private static final String CONFIRM_SUBMIT = "submit";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        OperateOption option;
        Map variables;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (CONFIRM_SUBMIT.equals(formOperate.getOperateKey()) && !(variables = (option = formOperate.getOption()).getVariables()).containsKey("submitConfirm")) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            Set ids = listSelectedData.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
            QFilter filter = new QFilter("id", "in", ids);
            filter.and(new QFilter("status", "=", (Object)"A"));
            DynamicObject[] schemeList = BusinessDataServiceHelper.load((String)"mrp_pls_scheme", (String)"id, number, category,material, materialgroup, priority, workcenter, workcenter_number, ispartincalc_1, category_2, material_2, materialgroup_2", (QFilter[])filter.toArray());
            StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7269\u6599\\\u7269\u6599\u63a7\u5236\u7ec4\u5728\u5de5\u4f5c\u4e2d\u5fc3\u4e0b\u65e0\u53c2\u4e0e\u8ba1\u7b97\u80fd\u529b\u9879\uff1a", (String)"SchemeListPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            boolean isWarn = false;
            for (DynamicObject scheme : schemeList) {
                DynamicObjectCollection materialEntry = scheme.getDynamicObjectCollection("matcategoryentry");
                HashSet<String> noCalcWorkCenterSet = new HashSet<String>(materialEntry.size());
                HashMap<String, Tuple> workCenterMap = new HashMap<String, Tuple>(materialEntry.size());
                for (DynamicObject material : materialEntry) {
                    String category = material.getString("category");
                    String key = "A".equals(category) ? "material_id" : "materialgroup_id";
                    String keyNumber = "A".equals(category) ? "material.number" : "materialgroup.number";
                    Long baseDataId = material.getLong(key);
                    DynamicObjectCollection subWorkCenterEntry = material.getDynamicObjectCollection("workcentersubentry");
                    for (DynamicObject workCenter : subWorkCenterEntry) {
                        if (workCenter.getInt("priority") == 0) continue;
                        long workCenterId = workCenter.getLong("workcenter_id");
                        String noCalcWorkKey = workCenterId + category + baseDataId;
                        noCalcWorkCenterSet.add(noCalcWorkKey);
                        workCenterMap.put(noCalcWorkKey, new Tuple((Object)material.getString(keyNumber), (Object)workCenter.getString("workcenter.number")));
                    }
                }
                DynamicObjectCollection workCenterEntry = scheme.getDynamicObjectCollection("workcenterentry");
                for (DynamicObject workcenter : workCenterEntry) {
                    long workCenterId = workcenter.getLong("workcenter_number_id");
                    DynamicObjectCollection calcResultEntry = workcenter.getDynamicObjectCollection("calcresultsubentry");
                    for (DynamicObject calcResult : calcResultEntry) {
                        if (!calcResult.getBoolean("ispartincalc_1")) continue;
                        String category = calcResult.getString("category_2");
                        String key = "A".equals(category) ? "material_2_id" : "materialgroup_2_id";
                        long baseDataId = calcResult.getLong(key);
                        noCalcWorkCenterSet.remove(workCenterId + category + baseDataId);
                    }
                }
                if (noCalcWorkCenterSet.size() <= 0) continue;
                isWarn = true;
                msg.append(scheme.getString("number")).append(" : ");
                for (String noCalcWorkKey : noCalcWorkCenterSet) {
                    Tuple tuple = (Tuple)workCenterMap.get(noCalcWorkKey);
                    msg.append((String)tuple.item1).append(',').append((String)tuple.item2).append("  ");
                }
                msg.append("\r\n");
            }
            if (isWarn) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CONFIRM_SUBMIT, (IFormPlugin)this);
                String confirmMsg = ResManager.loadKDString((String)msg.toString(), (String)"SchemeEditPlugin_23", (String)"SchemeListPlugin_1", (Object[])new Object[0]);
                this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener);
                this.getView().getPageCache().put("operateKey", formOperate.getOperateKey());
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (CONFIRM_SUBMIT.equals(callBackId) && event.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("submitConfirm", "submitConfirm");
            this.getView().invokeOperation(CONFIRM_SUBMIT, operateOption);
        }
    }
}

