/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.resourceplan;

import java.io.IOException;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.MutexFactory;
import kd.bos.orm.ORM;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.mrp.business.helper.PlanViewOrgHelper;
import kd.mmc.mrp.controlnode.framework.runner.MRPRunner4Res;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.RESEnv;
import kd.mmc.mrp.res.RESErrorMessageUtil;

public class ResourcePlanExecPlugin
extends AbstractFormPlugin {
    private static final String SCHEDULING_ORG = "scheduling_org";
    private static final Log log = LogFactory.getLog(ResourcePlanExecPlugin.class);
    private static final String MRP_GLOBALPLAN = "mrp_globalplan";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button runitem = (Button)this.getControl("btncalc");
        runitem.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)BizAppServiceHelp.getAppIdByAppNumber((String)"mrp"), (String)MRP_GLOBALPLAN, (String)"47150e89000000ac");
        List orgIds = result.getHasPermOrgs();
        Set planViewOrgIds = PlanViewOrgHelper.getOrgIdsByPlanView();
        long orgid = RequestContext.get().getOrgId();
        if (!orgIds.isEmpty()) {
            this.setOrgByPermission(orgid, orgIds, planViewOrgIds);
        } else if (result.hasAllOrgPerm() && planViewOrgIds.contains(orgid)) {
            this.getModel().setValue(SCHEDULING_ORG, (Object)RequestContext.get().getOrgId());
        }
    }

    public void setOrgByPermission(long orgid, List<Long> orgIds, Set<Long> planViewOrgIds) {
        if (orgIds.contains(orgid) && planViewOrgIds.contains(orgid)) {
            this.getModel().setValue(SCHEDULING_ORG, (Object)RequestContext.get().getOrgId());
        } else {
            this.getModel().setValue(SCHEDULING_ORG, (Object)orgIds.get(0));
        }
    }

    public void click(EventObject e) {
        super.click(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (SCHEDULING_ORG.equals(key)) {
            this.getModel().setValue("scheduling_scheme", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if ("exec".equals(key)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u51c6\u5907\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"ResourcePlanExecPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0])));
            try {
                this.beforeCalculate(e);
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    private void beforeCalculate(BeforeDoOperationEventArgs e) {
        DynamicObject schedulingScheme = (DynamicObject)this.getModel().getValue("scheduling_scheme");
        String schedulingSchemeId = schedulingScheme.getPkValue().toString();
        Map lockMap = null;
        try (DataMutex mutex = MutexFactory.createDataMutex();){
            lockMap = mutex.getLockInfo(schedulingSchemeId, "mmc.mrp", "ResourcePlanExec");
        }
        catch (IOException ioException) {
            log.info("\u83b7\u53d6\u4e92\u65a5\u9501\u5f02\u5e38\u3002");
        }
        if (lockMap != null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"ResourcePlanExecPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject caculateLog = this.createNewLog(null);
        String number = CodeRuleServiceHelper.getNumber((String)"mrp_caculate_log", (DynamicObject)caculateLog, (String)((DynamicObject)this.getModel().getValue(SCHEDULING_ORG)).getPkValue().toString());
        if (StringUtils.isBlank((CharSequence)number)) {
            number = caculateLog.getString("id");
        }
        this.execSchedulingScheme(number);
    }

    private void execSchedulingScheme(String number) {
        DynamicObject caculateLog = this.createNewLog(number);
        new MRPRunner4Res().run((IMRPEnvProvider)new RESEnv(caculateLog));
        this.showLogForm((Long)caculateLog.getPkValue());
    }

    private DynamicObject createNewLog(String number) {
        DynamicObject schedulingScheme = (DynamicObject)this.getModel().getValue("scheduling_scheme");
        DynamicObject caculateLog = ORM.create().newDynamicObject("mrp_caculate_log");
        DynamicObject org = (DynamicObject)this.getModel().getValue(SCHEDULING_ORG);
        Long id = ORM.create().genLongId("mrp_caculate_log");
        caculateLog.set("id", (Object)id);
        caculateLog.set("number", (Object)number);
        caculateLog.set("createorg", (Object)org);
        caculateLog.set("useorg", (Object)org);
        caculateLog.set("status", (Object)"C");
        caculateLog.set("enable", (Object)"1");
        caculateLog.set("plantype", (Object)RESErrorMessageUtil.getExecMode((String)this.getView().getFormShowParameter().getFormId()));
        caculateLog.set("plangram", (Object)schedulingScheme.getLong("id"));
        caculateLog.set("programname", (Object)schedulingScheme.getString("name"));
        caculateLog.set("programnumber", (Object)schedulingScheme.getString("number"));
        caculateLog.set("plangramentity", (Object)"mrp_res_scheme");
        caculateLog.set("plandate", this.getModel().getValue("plandate"));
        caculateLog.set("creator", (Object)RequestContext.get().getUserId());
        caculateLog.set("operatmode", (Object)"RES");
        caculateLog.set("operatmodekey", (Object)this.getView().getFormShowParameter().getFormId());
        caculateLog.set("calculatestatus", (Object)"D");
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("ctrlstrategy", (Object)"7");
        caculateLog.set("isllc", (Object)Boolean.FALSE);
        caculateLog.set("isbomcheck", (Object)Boolean.FALSE);
        caculateLog.set("isallowdateinpast", (Object)Boolean.FALSE);
        if ("mrp_resourceassess_exec".equalsIgnoreCase(this.getView().getFormShowParameter().getFormId())) {
            caculateLog.set("runtype", (Object)"I");
        } else {
            caculateLog.set("runtype", (Object)"H");
        }
        caculateLog.set("iscommon", (Object)Boolean.FALSE);
        caculateLog.set("iscustomize", (Object)Boolean.FALSE);
        caculateLog.set("isselection", (Object)Boolean.FALSE);
        caculateLog.set("isnotsetup", (Object)Boolean.FALSE);
        if (number != null) {
            ORM.create().save(caculateLog);
            BaseDataServiceHelper.clearCache((DynamicObject)caculateLog);
        }
        return caculateLog;
    }

    private void showLogForm(Long id) {
        this.getView().close();
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("mrp_res_log");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setPkId((Object)id);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("id", (Object)id);
        formShowParameter.setCaption(this.getView().getFormShowParameter().getFormName());
        this.getView().showForm((FormShowParameter)formShowParameter);
    }
}

