/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.resourceplan;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msplan.business.helper.PlanProgramHelper;

public class ResourcePlanSchemePlugin
extends AbstractFormPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        String showMode;
        super.preOpenForm(e);
        FormShowParameter formParamter = (FormShowParameter)e.getSource();
        Map customerParam = formParamter.getCustomParams();
        if (customerParam.get("ispg") != null && "true".equalsIgnoreCase(showMode = (String)customerParam.get("ispg"))) {
            formParamter.setCaption(ResManager.loadKDString((String)"\u8d44\u6e90\u8bc4\u4f30\u65b9\u6848", (String)"ResourcePlanSchemePlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String value = (String)this.getModel().getValue("chkgroupplantype");
        this.chgStype(value, true);
        this.pStype("chkgroupplan", (String)this.getModel().getValue("chkgroupplan"));
        this.pStype("chkgrouplist", (String)this.getModel().getValue("chkgrouplist"));
        this.pStype("chkgroupreq", (String)this.getModel().getValue("chkgroupreq"));
        this.pStype("chkgroupsupply", (String)this.getModel().getValue("chkgroupsupply"));
    }

    public void afterCreateNewData(EventObject e) {
        String showMode = (String)this.getView().getFormShowParameter().getCustomParam("ispg");
        if ("true".equalsIgnoreCase(showMode)) {
            this.getModel().setValue("chkgroupplantype", (Object)"2");
            this.getModel().setValue("chkgpexec", (Object)"3");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String dn;
        switch (dn = e.getProperty().getName()) {
            case "chkgroupplantype": {
                this.chgStype((String)e.getChangeSet()[0].getNewValue(), false);
                break;
            }
            case "chkgroupplan": 
            case "chkgrouplist": 
            case "chkgroupreq": 
            case "chkgroupsupply": {
                this.pStype(dn, (String)e.getChangeSet()[0].getNewValue());
                break;
            }
            case "planmodel": 
            case "listmodel": 
            case "reqmodel": 
            case "supplymodel": {
                this.modelChange(dn, e.getChangeSet()[0].getNewValue());
                break;
            }
        }
    }

    private void modelChange(String propertyName, Object newObject) {
        String entryKey = "";
        switch (propertyName) {
            case "planmodel": {
                entryKey = "planentity";
                break;
            }
            case "listmodel": {
                entryKey = "listentity";
                break;
            }
            case "reqmodel": {
                entryKey = "reqentity";
                break;
            }
            case "supplymodel": {
                entryKey = "supplyentity";
                break;
            }
        }
        if (!(newObject instanceof DynamicObject)) {
            this.deleteEntryDate(entryKey);
        } else {
            DynamicObject resRegistConfig = (DynamicObject)newObject;
            this.createEntry(propertyName, entryKey, resRegistConfig);
        }
    }

    private void deleteEntryDate(String entryKey) {
        if (StringUtils.isNotBlank((CharSequence)entryKey) && this.hasProperty(entryKey)) {
            this.getModel().deleteEntryData(entryKey);
        }
    }

    private boolean hasProperty(String prop) {
        IDataModel model = this.getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        IDataEntityProperty property = dataEntityType.findProperty(prop);
        return property != null;
    }

    private void createEntry(String propertyName, String entryKey, DynamicObject resRegistConfig) {
        this.deleteEntryDate(entryKey);
        String fieldKey = "";
        String tagKey = "";
        switch (propertyName) {
            case "planmodel": {
                fieldKey = "planresource";
                tagKey = "planfieldtran";
                break;
            }
            case "listmodel": {
                fieldKey = "listresource";
                tagKey = "listfieldtran";
                break;
            }
            case "reqmodel": {
                fieldKey = "reqresource";
                tagKey = "reqfieldtran";
                break;
            }
            case "supplymodel": {
                fieldKey = "supplyresource";
                tagKey = "supplyfieldtran";
                break;
            }
        }
        DynamicObjectCollection resDataConfigs = this.getResourceDataConfig(resRegistConfig == null ? Long.valueOf(0L) : resRegistConfig.getPkValue(), null);
        if (resDataConfigs == null || resDataConfigs.isEmpty()) {
            return;
        }
        this.batchCreateEntrys(entryKey, fieldKey, tagKey, resDataConfigs);
    }

    private DynamicObjectCollection getResourceDataConfig(Object resRegistId, QFilter qFilter) {
        QFilter qFilterId = new QFilter("cgnumber", "=", resRegistId);
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        String selectProPerty = "id,billfieldtransfer.srcbill srcbill,billfieldtransfer.id tranid";
        QFilter[] qFilters = qFilter == null ? new QFilter[]{qFilterId, qFilterEnable} : new QFilter[]{qFilterId, qFilterEnable, qFilter};
        return QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)selectProPerty, (QFilter[])qFilters);
    }

    private void batchCreateEntrys(String entryKey, String fieldKey, String tagKey, DynamicObjectCollection resDataConfigs) {
        IFormView fv = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        this.initVs(vs, fieldKey, tagKey, resDataConfigs);
        model.batchCreateNewEntryRow(entryKey, vs);
        model.endInit();
        fv.updateView(entryKey);
    }

    private void initVs(TableValueSetter vs, String fieldKey, String tagKey, DynamicObjectCollection resDataConfigs) {
        vs.addField("seq", new Object[0]);
        vs.addField(fieldKey, new Object[0]);
        vs.addField(tagKey, new Object[0]);
        for (int i = 0; i < resDataConfigs.size(); ++i) {
            DynamicObject resDataConfig = (DynamicObject)resDataConfigs.get(i);
            Object srcbill = resDataConfig.get("srcbill");
            if (srcbill == null || !PlanProgramHelper.entityObjectIsExist((Object)srcbill)) continue;
            vs.addRow(new Object[]{i + 1, resDataConfig.get("id"), resDataConfig.get("tranid")});
        }
    }

    private void pStype(String contorlname, String val) {
        DecimalEdit te4;
        if ("chkgroupplan".equalsIgnoreCase(contorlname)) {
            te4 = (DecimalEdit)this.getView().getControl("supplyday");
            if ("1".equals(val)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"planday"});
                this.getModel().setValue("planday", (Object)0);
                te4.setMustInput(false);
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"planday"});
                te4.setMustInput(true);
            }
        }
        if ("chkgrouplist".equalsIgnoreCase(contorlname)) {
            te4 = (DecimalEdit)this.getView().getControl("supplyday");
            if ("1".equals(val)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"listday"});
                this.getModel().setValue("listday", (Object)0);
                te4.setMustInput(false);
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"listday"});
                te4.setMustInput(true);
            }
        }
        if ("chkgroupreq".equalsIgnoreCase(contorlname)) {
            te4 = (DecimalEdit)this.getView().getControl("supplyday");
            if ("1".equals(val)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"reqday"});
                this.getModel().setValue("reqday", (Object)0);
                te4.setMustInput(false);
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"reqday"});
                te4.setMustInput(true);
            }
        }
        if ("chkgroupsupply".equalsIgnoreCase(contorlname)) {
            te4 = (DecimalEdit)this.getView().getControl("supplyday");
            if ("1".equals(val)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"supplyday"});
                this.getModel().setValue("supplyday", (Object)0);
                te4.setMustInput(false);
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"supplyday"});
                te4.setMustInput(true);
            }
        }
    }

    private void chgStype(String val, boolean isload) {
        BasedataEdit te1 = (BasedataEdit)this.getView().getControl("planmodel");
        BasedataEdit te2 = (BasedataEdit)this.getView().getControl("listmodel");
        BasedataEdit te3 = (BasedataEdit)this.getView().getControl("reqmodel");
        BasedataEdit te4 = (BasedataEdit)this.getView().getControl("supplymodel");
        if ("2".equals(val)) {
            te1.setMustInput(false);
            te2.setMustInput(false);
            te3.setMustInput(true);
            te4.setMustInput(true);
            this.getModel().setValue("chkgroupplan", (Object)"1");
            this.getModel().setValue("chkgrouplist", (Object)"1");
        } else {
            te4.setMustInput(false);
            te3.setMustInput(false);
            te2.setMustInput(true);
            te1.setMustInput(true);
            this.getModel().setValue("chkgroupreq", (Object)"1");
            this.getModel().setValue("chkgroupsupply", (Object)"1");
        }
        if (!isload) {
            Tab control = (Tab)this.getView().getControl("tabap");
            control.activeTab("tabpageap5");
            this.getModel().setValue("planmodel", null);
            this.getModel().setValue("listmodel", null);
            this.getModel().setValue("reqmodel", null);
            this.getModel().setValue("supplymodel", null);
        }
    }
}

