/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.supdem;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class SupDemRangeFormPlugin
extends AbstractBillPlugIn {
    private static final String DEMAND_CONF = "demandconfig";
    private static final String SUPPLY_CONF = "supplyconfig";
    private static final String ENTRY_DEM = "demandentry";
    private static final String ENTRY_SUP = "supplyentry";
    private static final String ENTRY = "entry";
    private static final String SRC = "src";
    private static final String CONFIG = "config";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult result;
        List successPkIds;
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && !(successPkIds = (result = args.getOperationResult()).getSuccessPkIds()).isEmpty()) {
            DeleteServiceHelper.delete((String)"mrp_supdem_range", (QFilter[])new QFilter[]{new QFilter("id", "!=", successPkIds.get(0))});
        }
    }

    public void registerListener(EventObject e) {
        this.addFilter("demand");
        this.addFilter("supply");
    }

    private void addFilter(String prefix) {
        String key = prefix + CONFIG;
        String entry = prefix + ENTRY;
        BasedataEdit demand = (BasedataEdit)this.getControl(key);
        demand.addBeforeF7SelectListener(l -> {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entry);
            ArrayList<Long> demConfigs = new ArrayList<Long>(4);
            for (DynamicObject dyn : entryEntity) {
                demConfigs.add(dyn.getLong(key + "_id"));
            }
            l.getCustomQFilters().add(new QFilter("id", "not in", demConfigs));
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (DEMAND_CONF.equals(name) || SUPPLY_CONF.equals(name)) {
            String srcName = name.replace(CONFIG, SRC);
            ChangeData changeSet = e.getChangeSet()[0];
            int rowIndex = changeSet.getRowIndex();
            DynamicObject newValue = (DynamicObject)changeSet.getNewValue();
            this.setSrc(srcName, rowIndex, newValue);
        }
    }

    private void setSrc(String srcName, int rowIndex, DynamicObject newValue) {
        if (newValue == null) {
            this.getModel().setValue(srcName, null);
        } else {
            long transferId = newValue.getLong("billfieldtransfer_id");
            QFilter filter = new QFilter("id", "=", (Object)transferId);
            DynamicObject transDyn = QueryServiceHelper.queryOne((String)"mrp_billfieldtransfer", (String)"srcbill,srcbill.name", (QFilter[])new QFilter[]{filter});
            if (transDyn == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u5173\u8054\u7684\u76ee\u6807\u5b9e\u4f53\u4e3a\u7a7a\u3002", (String)"SupDemRangeFormPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue(srcName, transDyn.get("srcbill"), rowIndex);
        }
    }

    public void afterLoadData(EventObject e) {
        String[] entrys;
        for (String entry : entrys = new String[]{ENTRY_DEM, ENTRY_SUP}) {
            String srcName = entry.replace(ENTRY, SRC);
            String configName = entry.replace(ENTRY, CONFIG);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entry);
            for (DynamicObject dyn : entryEntity) {
                int seq = dyn.getInt("seq");
                DynamicObject dd = dyn.getDynamicObject(configName);
                this.setSrc(srcName, seq - 1, dd);
            }
        }
        this.getModel().setDataChanged(false);
        BillView source = (BillView)e.getSource();
        OperationStatus status = source.getFormShowParameter().getStatus();
        if (status == OperationStatus.VIEW) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"demadd", "demdel", "supadd", "supdel"});
        }
    }
}

