/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.supdem;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.filter.SearchListener;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.mmc.mrp.business.helper.PlanViewOrgHelper;
import kd.mmc.mrp.common.cache.SupplyDemandRptSessionCache;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.utils.MRPUtil;

public class SupplyDemandRptNewFormPlugin
extends AbstractReportFormPlugin
implements RowClickEventListener,
HyperLinkClickListener,
BeforeF7SelectListener,
TabSelectListener,
SearchListener {
    private static final String TB_RANGE = "mrp_supdem_rangenew";
    private static final String TB_QUERY = "mrp_supdem_rpt";
    private static final String TYPE_SCZJQD = "pom_mftstock";
    private static final String TYPE_WWZJQD = "om_mftstock";
    private static final String TYPE_XSDD = "sm_salorder";
    private static final String TYPE_WWGD = "om_mftorder";
    private static final String TYPE_CGDD = "pm_purorderbill";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button setting = (Button)this.getControl("setting");
        setting.addClickListener((ClickListener)this);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addRowClickListener((RowClickEventListener)this);
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        this.getView().setEnable(Boolean.FALSE, new String[]{"sumentry"});
        BasedataEdit supplyorg = (BasedataEdit)this.getControl("filter_org");
        supplyorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit filter_planscope = (BasedataEdit)this.getControl("filter_planscope");
        filter_planscope.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tab = (Tab)this.getControl("statspage");
        tab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit log = (BasedataEdit)this.getControl("filter_log");
        log.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        reportList = (ReportList)this.getControl("daystatsap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        reportList = (ReportList)this.getControl("weekstatsap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        reportList = (ReportList)this.getControl("monthstatsap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
        filter.addSearchListener((SearchListener)this);
    }

    public void search(SearchEvent arg0) {
        ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
        filter.setCollapse(false);
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit base = (BasedataEdit)e.getSource();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        if (StringUtils.equalsIgnoreCase((CharSequence)base.getKey(), (CharSequence)"filter_org")) {
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            formShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            QFilter idFilter = new QFilter("id", "in", (Object)PlanViewOrgHelper.getOrgIdsByPlanView());
            filterParameter.getQFilters().add(idFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)base.getKey(), (CharSequence)"filter_planscope")) {
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            HashSet<Long> ids = new HashSet<Long>(4);
            ids.add(this.getOrgPlanScope());
            DynamicObject material = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"filter_material");
            DynamicObject org = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"filter_org");
            if (material != null && org != null) {
                ids.addAll(this.getMaterialPlanScope(material, org));
            }
            QFilter idFilter = new QFilter("id", "in", ids);
            filterParameter.getQFilters().add(idFilter);
        } else if ("filter_log".equals(base.getKey())) {
            QFilter qf1 = new QFilter("runtype", "=", (Object)"A");
            qf1.and("calculatestatus", "=", (Object)"A");
            qf1.and("clearstatus", "!=", (Object)Character.valueOf('B'));
            qf1.and("operatmodekey", "=", (Object)"mrp_globalplan");
            HashSet ids = new HashSet(16);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_caculate_log", (String)"id,number", (QFilter[])new QFilter[]{qf1}, null);){
                dataSet.forEach(row -> ids.add(row.getLong("id")));
            }
            formShowParameter.setShowUsed(false);
            formShowParameter.setShowApproved(false);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
        }
    }

    private Set<Long> getMaterialPlanScope(DynamicObject material, DynamicObject org) {
        HashSet<Long> ids = new HashSet<Long>(4);
        QFilter qFilterMaterial = new QFilter("material", "=", (Object)material.getLong("id"));
        QFilter qFilterOrg = new QFilter("createorg", "=", (Object)org.getLong("id"));
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterUse = new QFilter("entrymatplanscop.start_useing", "=", (Object)Boolean.TRUE);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"msplan_matplanscop", (String)"entrymatplanscop.planscope planscope", (QFilter[])new QFilter[]{qFilterMaterial, qFilterOrg, qFilterEnable, qFilterUse}, null);){
            for (Row row : dataSet) {
                ids.add(row.getLong(0));
            }
        }
        return ids;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userId = RequestContext.get().getCurrUserId();
        String appId = StringUtils.isBlank((CharSequence)this.getView().getFormShowParameter().getAppId()) ? "mrp" : this.getView().getFormShowParameter().getAppId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)BizAppServiceHelp.getAppIdByAppNumber((String)appId), (String)this.getView().getFormShowParameter().getFormId(), (String)"47150e89000000ac");
        List orgIds = result.getHasPermOrgs();
        Set planViewOrgIds = PlanViewOrgHelper.getOrgIdsByPlanView();
        String filter_org = SupplyDemandRptSessionCache.getCache((String)"filter_org");
        String filter_planscope = SupplyDemandRptSessionCache.getCache((String)"filter_planscope");
        long orgid = RequestContext.get().getOrgId();
        Long planScopeId = 0L;
        if (filter_org != null && filter_planscope != null) {
            orgid = Long.parseLong(filter_org);
            planScopeId = Long.parseLong(filter_planscope);
        }
        if (!orgIds.isEmpty()) {
            if (orgIds.contains(orgid) && planViewOrgIds.contains(orgid)) {
                this.getModel().setValue("filter_org", (Object)orgid);
                this.getModel().setValue("filter_planscope", (Object)(planScopeId > 0L ? planScopeId : this.getOrgPlanScope()));
            }
        } else if (result.hasAllOrgPerm() && planViewOrgIds.contains(orgid)) {
            this.getModel().setValue("filter_org", (Object)orgid);
            this.getModel().setValue("filter_planscope", (Object)(planScopeId > 0L ? planScopeId : this.getOrgPlanScope()));
        }
        if (this.isStatic()) {
            QFilter qf1 = new QFilter("runtype", "=", (Object)"A");
            qf1.and("calculatestatus", "=", (Object)"A");
            qf1.and("clearstatus", "!=", (Object)Character.valueOf('B'));
            qf1.and("operatmodekey", "=", (Object)"mrp_globalplan");
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_caculate_log", (String)"id,number", (QFilter[])new QFilter[]{qf1}, (String)"startdate desc", (int)1);){
                if (!dataSet.hasNext()) return;
                Row row = dataSet.next();
                this.getModel().setValue("filter_log", row.get("id"));
                return;
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filter_log"});
        }
    }

    private Long getOrgPlanScope() {
        DynamicObject org = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"filter_org");
        if (org != null) {
            Long planScope = 0L;
            QFilter qFilterOrg = new QFilter("createorg", "=", (Object)org.getLong("id"));
            QFilter qFilterType = new QFilter("type", "=", (Object)"A");
            QFilter qFilter = new QFilter("effectuate_type", "=", (Object)"A");
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"msplan_planscope", (String)"id", (QFilter[])new QFilter[]{qFilterOrg, qFilterType}, null, (int)1);){
                if (dataSet.hasNext()) {
                    planScope = dataSet.next().getLong(0);
                }
            }
            if (QueryServiceHelper.exists((String)"msplan_planscope_whs", (QFilter[])new QFilter[]{qFilter, new QFilter("planscope", "=", (Object)planScope)})) {
                return planScope;
            }
        }
        return 0L;
    }

    public void entryRowClick(RowClickEvent evt) {
        int idx = evt.getRow();
        ReportList reportList = (ReportList)evt.getSource();
        AbstractReportListModel reportModel = (AbstractReportListModel)reportList.getReportModel();
        DynamicObject dyn = reportModel.getRowData(idx);
        if (dyn != null) {
            long mid = dyn.getLong("material_id");
            this.fillSum(mid);
        }
    }

    private void fillSum(long mid) {
        boolean flag = true;
        if (flag) {
            return;
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        AbstractReportListModel reportModel = (AbstractReportListModel)reportList.getReportModel();
        ReportTaskResult result = reportModel.getReportTaskResult();
        String resultId = result.getResultId();
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)resultId);
        List list = cacheDataSet.getList(0, cacheDataSet.getRowCount());
        if (mid == 0L && list.size() > 0) {
            Long material = ((Row)list.get(0)).getLong("material");
            mid = material == null ? 0L : material;
        }
        long mmid = mid;
        List material = list.stream().filter(x -> {
            long mt = x.getLong("material") == null ? 0L : x.getLong("material");
            return mmid == mt;
        }).collect(Collectors.toList());
        list.clear();
        HashMap<Tuple<String, String>, Set<Long>> srcOrgMap = new HashMap<Tuple<String, String>, Set<Long>>(32);
        HashSet<Long> orgIds = new HashSet<Long>(32);
        for (Row r : material) {
            Long billId = r.getLong("billid");
            String type = r.getString("srctype");
            boolean added = this.getSrcOrgMap(srcOrgMap, type, billId);
            if (added) continue;
            orgIds.add(r.getLong("org"));
        }
        Map<String, Map<Long, String>> srcNameMap = this.getSrcNameMap(srcOrgMap);
        Map<Long, String> orgNameMap = this.getOrgMap(orgIds);
        LinkedHashMap<SumSrcOrg, QTY> sumMap = new LinkedHashMap<SumSrcOrg, QTY>(32);
        for (Row r : material) {
            Long mt = r.getLong("material");
            Long cc = r.getLong("configuredcode");
            Long tn = r.getLong("tracknumber");
            Long ap = r.getLong("auxproperty");
            Long pj = r.getLong("project");
            Long ps = r.getLong("planscope");
            Long warehouse = r.getLong("warehouse");
            Long unit = r.getLong("unit");
            Long config = r.getLong("config");
            Long billId = r.getLong("billid");
            String type = r.getString("srctype");
            Long org = r.getLong("org");
            BigDecimal qty = r.getBigDecimal("qty");
            Map<Long, String> map = srcNameMap.get(type);
            String orgName = map == null ? orgNameMap.get(org) : map.get(billId);
            SumSrcOrg sumSrcOrg = new SumSrcOrg(mt, cc, tn, ap, pj, unit, config, ps, warehouse, orgName);
            sumMap.computeIfAbsent(sumSrcOrg, k -> new QTY()).add(qty);
        }
        this.setSumEntry(sumMap);
    }

    private void setSumEntry(Map<SumSrcOrg, QTY> sumMap) {
        this.getModel().deleteEntryData("sumentry");
        if (sumMap.isEmpty()) {
            return;
        }
        boolean istracknumber = (Boolean)this.getModel().getValue("istracknumber");
        boolean isproject = (Boolean)this.getModel().getValue("isproject");
        int[] sumentries = this.getModel().batchCreateNewEntryRow("sumentry", sumMap.size());
        int length = sumentries.length;
        DynamicObjectCollection cols = this.getModel().getEntryEntity("sumentry");
        int i = 0;
        BigDecimal left = BigDecimal.ZERO;
        Long lastConfig = 0L;
        Long lastauxproperty = 0L;
        Long lastProject = 0L;
        Long lastTrack = 0L;
        Long lastPlanScope = 0L;
        for (Map.Entry<SumSrcOrg, QTY> entry : sumMap.entrySet()) {
            if (i >= length) continue;
            SumSrcOrg key = entry.getKey();
            QTY value = entry.getValue();
            DynamicObject dyn = (DynamicObject)cols.get(i++);
            dyn.set("sum_material_id", (Object)key.mt);
            dyn.set("sum_configuredcode_id", (Object)key.configuredcode);
            dyn.set("sum_tracknumber_id", (Object)key.tracknumber);
            dyn.set("sum_auxproperty_id", (Object)key.auxproperty);
            dyn.set("sum_project_id", (Object)key.project);
            dyn.set("sum_planscope_id", (Object)key.planscope);
            dyn.set("sum_warehouse_id", (Object)key.warehouse);
            dyn.set("sum_config_id", (Object)key.config);
            dyn.set("sum_srcorg", (Object)key.orgNumber);
            dyn.set("sum_unit_id", (Object)key.unit);
            dyn.set("sum_qty", (Object)value.qty);
            if (Objects.equals(lastConfig, key.configuredcode) && Objects.equals(lastauxproperty, key.auxproperty) && (!isproject || Objects.equals(lastProject, key.project)) && (!istracknumber || Objects.equals(lastTrack, key.tracknumber)) && Objects.equals(lastPlanScope, key.planscope)) {
                left = left.add(value.qty);
            } else {
                left = value.qty;
                lastConfig = key.configuredcode;
                lastauxproperty = key.auxproperty;
                lastProject = key.project;
                lastTrack = key.tracknumber;
                lastPlanScope = key.planscope;
            }
            dyn.set("sum_leftqty", (Object)left);
        }
        this.getView().updateView("sumentry");
    }

    private Map<Long, String> getOrgMap(Set<Long> orgIds) {
        HashMap<Long, String> idMap = new HashMap<Long, String>(32);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"SupplyDemandRptFormPlugin.putOrgMap", (String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)}, null);){
            for (Row d : ds) {
                String join = String.join((CharSequence)" ", d.getString("number"), d.getString("name"));
                idMap.put(d.getLong("id"), join);
            }
        }
        return idMap;
    }

    public void click(EventObject evt) {
        Button bt;
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && "setting".equals(key = (bt = (Button)source).getKey()) && this.editPerm()) {
            DynamicObject queryOne = QueryServiceHelper.queryOne((String)TB_RANGE, (String)"id", null);
            if (queryOne == null) {
                this.showCreate();
            } else {
                this.showEdit(queryOne.getLong("id"));
            }
        }
    }

    private boolean editPerm() {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"0MBBBZ1L5IAW", (String)TB_QUERY, (String)"1WTPJUI3R1+2");
    }

    private void showEdit(long id) {
        BillShowParameter parameter = this.getParam();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setPkId((Object)id);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private BillShowParameter getParam() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(TB_RANGE);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setHasRight(true);
        return parameter;
    }

    private void showCreate() {
        BillShowParameter parameter = this.getParam();
        parameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String instId = String.valueOf(this.getModel().getValue("instid"));
        IPageCache cache = this.getPageCache();
        cache.remove(instId + "weekstatsap_query");
        cache.remove(instId + "monthstatsap_query");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"showdetails"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"showsums"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumtab"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"detailtab"});
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab("detailtab");
        HashMap<String, Boolean> cusParams = queryParam.getCustomParam();
        if (cusParams == null) {
            cusParams = new HashMap<String, Boolean>();
            this.getQueryParam().setCustomParam(cusParams);
        }
        cusParams.put("isStatic", this.isStatic());
        cusParams.put("isRefresh", true);
        cusParams.put("pageid", (Boolean)((Object)this.getView().getPageId()));
        ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
        filter.setCollapse(false);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        this.doSubRptQuery("daystatsap", queryParam);
        IDataModel model = this.getModel();
        DynamicObjectCollection sumRows = model.getEntryEntity("daysumentity");
        DynamicObject sumRow = (DynamicObject)sumRows.get(0);
        String cacheId = String.valueOf(queryParam.getCustomParam().get("detail_dataset_id"));
        DistributeSessionlessCache sumCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        sumRow.set("requiresum", (Object)new BigDecimal((String)sumCache.get(cacheId + "_requireSum")));
        sumRow.set("supplysum", (Object)new BigDecimal((String)sumCache.get(cacheId + "_supplySum")));
        sumRow.set("reducesum", (Object)new BigDecimal((String)sumCache.get(cacheId + "_reduceSum")));
        Map cusParams = queryParam.getCustomParam();
        cusParams.put("isRefresh", false);
        IReportCache cache = ReportCacheManager.getInstance().getCache();
        cache.setReportQueryParam(this.getView().getPageId(), queryParam);
        DynamicObject filter_material = (DynamicObject)this.getModel().getValue("filter_material");
        DynamicObject filter_org = (DynamicObject)this.getModel().getValue("filter_org");
        DynamicObject filter_planscope = (DynamicObject)this.getModel().getValue("filter_planscope");
        if (filter_material != null && filter_org != null && filter_planscope != null) {
            SupplyDemandRptSessionCache.putCache((String)"filter_org", (String)filter_org.getString("id"));
            SupplyDemandRptSessionCache.putCache((String)"filter_planscope", (String)filter_planscope.getString("id"));
        }
    }

    private void doSubRptQuery(String ctrlId, ReportQueryParam queryParam) {
        IReportCache cache = ReportCacheManager.getInstance().getCache();
        ReportList srcRpt = (ReportList)this.getControl(ctrlId);
        String pageId = this.getView().getPageId();
        DistributeSessionlessCache sumCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        queryParam.getCustomParam().put("detail_dataset_id", sumCache.get("detail_dataset_id" + pageId));
        ReportTaskParam tp = new ReportTaskParam();
        tp.setReportName(ctrlId);
        tp.setOtherParam((Object)queryParam);
        cache.setReportTaskParam(pageId, ctrlId, tp);
        srcRpt.submitTask(queryParam, (Object)String.valueOf(this.getModel().getValue("instid")));
        IPageCache pageCache = this.getPageCache();
        String instId = String.valueOf(this.getModel().getValue("instid"));
        pageCache.put(instId + ctrlId + "_query", "1");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setValue("instid", (Object)UUID.randomUUID().toString());
        this.getView().updateView("instid");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String instId;
        super.beforeClosed(e);
        try {
            instId = String.valueOf(this.getModel().getValue("instid"));
        }
        catch (Throwable ex) {
            this.getView().showMessage(ex.getMessage());
            return;
        }
        instId = instId + ".";
        DistributeSessionlessCache globalCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        globalCache.remove(instId + "queryArgs");
        globalCache.remove("detail_dataset_id" + this.getView().getPageId());
        String cacheId = String.valueOf(this.getQueryParam().getCustomParam().get("detail_dataset_id"));
        Algo.removeCacheDataSet((String)cacheId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            String key = ((Donothing)source).getOperateKey();
            Tab tab = (Tab)this.getControl("tabap");
            if ("displayswitch".equals(key)) {
                tab.activeTab("detailtab");
            } else if ("displayswitch2".equals(key)) {
                tab.activeTab("sumtab");
            }
            this.getView().updateView("tabap");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("displayswitch".equals(key)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"showdetails"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"showsums"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumtab"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"detailtab"});
            this.getView().updateView("detailtab");
        } else if ("displayswitch2".equals(key)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"showdetails"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"showsums"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumtab"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"detailtab"});
            this.getView().updateView("sumtab");
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        HashMap<String, Set> pnumberMap = new HashMap<String, Set>(32);
        HashMap<Tuple<String, String>, Set<Long>> srcOrgMap = new HashMap<Tuple<String, String>, Set<Long>>(32);
        for (Object row : rowData) {
            String string = row.getString("srctype");
            long billId = row.getLong("billid");
            if (TYPE_SCZJQD.equals(string) || TYPE_WWZJQD.equals(string)) {
                pnumberMap.computeIfAbsent(string, k -> new HashSet(8)).add(billId);
            }
            this.getSrcOrgMap(srcOrgMap, string, billId);
        }
        HashMap idParentMap = new HashMap(32);
        for (Map.Entry entry : pnumberMap.entrySet()) {
            String key = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            DataSet ds = QueryServiceHelper.queryDataSet((String)"SupplyDemandRptFormPlugin.processRowData", (String)key, (String)"id,productid.number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)value)}, null);
            Throwable throwable = null;
            try {
                HashMap<Long, String> idToParentMap = new HashMap<Long, String>();
                for (Row d : ds) {
                    idToParentMap.put(d.getLong("id"), d.getString("productid.number"));
                }
                idParentMap.put(key, idToParentMap);
            }
            catch (Throwable idToParentMap) {
                throwable = idToParentMap;
                throw idToParentMap;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable idToParentMap) {
                        throwable.addSuppressed(idToParentMap);
                    }
                    continue;
                }
                ds.close();
            }
        }
        Map<String, Map<Long, String>> srcMap = this.getSrcNameMap(srcOrgMap);
        for (DynamicObject row : rowData) {
            Map<Long, String> map;
            String srcType = row.getString("srctype");
            long billId = row.getLong("billid");
            Map idPMap = (Map)idParentMap.get(srcType);
            if (idPMap != null) {
                String pnumber = (String)idPMap.get(billId);
                row.set("parentnumber", (Object)pnumber);
            }
            if ((map = srcMap.get(srcType)) != null) {
                String srcOrg = map.get(billId);
                row.set("srcorg", (Object)srcOrg);
                continue;
            }
            String srcNumber = row.getString("org.number");
            String srcName = row.getString("org.name");
            srcNumber = srcNumber == null ? "" : srcNumber;
            srcNumber = srcNumber.trim().equalsIgnoreCase("null") ? "" : srcNumber;
            srcName = srcName == null ? "" : srcName;
            srcName = srcName.trim().equalsIgnoreCase("null") ? "" : srcName;
            row.set("srcorg", (Object)String.join((CharSequence)" ", srcNumber, srcName));
        }
    }

    private Map<String, Map<Long, String>> getSrcNameMap(Map<Tuple<String, String>, Set<Long>> srcOrgMap) {
        HashMap<String, Map<Long, String>> srcMap = new HashMap<String, Map<Long, String>>(32);
        for (Map.Entry<Tuple<String, String>, Set<Long>> entry : srcOrgMap.entrySet()) {
            Tuple<String, String> t = entry.getKey();
            String key = (String)t.t1;
            String sel = (String)t.t2;
            Set<Long> value = entry.getValue();
            DataSet ds = QueryServiceHelper.queryDataSet((String)"SupplyDemandRptFormPlugin.srcMap", (String)key, (String)sel, (QFilter[])new QFilter[]{new QFilter("id", "in", value)}, null);
            Throwable throwable = null;
            try {
                HashMap<Long, String> idMap = new HashMap<Long, String>();
                for (Row d : ds) {
                    String join = String.join((CharSequence)" ", d.getString("number"), d.getString("name"));
                    idMap.put(d.getLong("id"), join);
                }
                srcMap.put(key, idMap);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        return srcMap;
    }

    private boolean getSrcOrgMap(Map<Tuple<String, String>, Set<Long>> srcOrgMap, String srcType, long billId) {
        String sel = null;
        switch (srcType) {
            case "om_mftstock": {
                sel = "orderentryid.supplier";
                break;
            }
            case "sm_salorder": {
                sel = "customer";
                break;
            }
            case "om_mftorder": {
                sel = "treeentryentity.supplier";
                break;
            }
            case "pm_purorderbill": {
                sel = "supplier";
            }
        }
        if (sel != null) {
            sel = "(" + sel + ".name) as name,(" + sel + ".number) as number,id";
            Tuple<String, String> t = new Tuple<String, String>(srcType, sel);
            srcOrgMap.computeIfAbsent(t, k -> new HashSet(8)).add(billId);
        }
        return sel != null;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("filter_org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SupplyDemandRptFormPlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        FilterItemInfo material = filter.getFilterItem("keymaterial");
        List value = (List)material.getValue();
        if (value == null || value.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SupplyDemandRptFormPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (value.size() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009100\u4e2a\u7269\u6599\u3002", (String)"SupplyDemandRptFormPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        AppParam appParam = new AppParam("0MBBBZ1L5IAW", Long.valueOf(org.getLong("id")));
        Map mrpParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        Long supdem_range_id = (Long)MRPUtil.convert(mrpParam.get("supdem_range_id"), (Object)0L);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)TB_RANGE, (String)"mrpplan,bizplan", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supdem_range_id)});
        if (dyn == null || dyn.get("mrpplan") == null || dyn.get("bizplan") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u65b9\u6848\u201d\uff0c\u201c\u4e1a\u52a1\u65b9\u6848\u201d\u4e3a\u7a7a\uff0c\u8bf7\u5728\u201c\u7cfb\u7edf\u53c2\u6570-\u5236\u9020\u4e91-\u7269\u6599\u9700\u6c42\u8ba1\u5212\u201d\u4e0b\u8fdb\u884c\u4f9b\u9700\u8303\u56f4\u8bbe\u7f6e\u3002", (String)"SupplyDemandRptFormPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.isStatic() && filter.getDynamicObject("filter_log") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SupplyDemandRptFormPlugin_10", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void materialChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (!"filter_material".equals(name)) {
            return;
        }
        for (ChangeData changeSet : e.getChangeSet()) {
            DynamicObject newValue = (DynamicObject)changeSet.getNewValue();
            DynamicObjectCollection keymaterial = (DynamicObjectCollection)this.getModel().getValue("keymaterial");
            keymaterial.clear();
            if (newValue == null) continue;
            DynamicObject key = keymaterial.addNew();
            key.set("fbasedataid", (Object)newValue);
        }
    }

    private void planScopeChanged(String name) {
        if (!"filter_planscope".equals(name)) {
            return;
        }
        DynamicObject filter_material = (DynamicObject)this.getModel().getValue("filter_material");
        DynamicObject filter_org = (DynamicObject)this.getModel().getValue("filter_org");
        DynamicObject filter_planscope = (DynamicObject)this.getModel().getValue("filter_planscope");
        if (filter_material != null && filter_org != null && filter_planscope != null) {
            String psType = filter_planscope.getString("type");
            if ("A".equals(psType)) {
                DynamicObject planInfo = QueryServiceHelper.queryOne((String)"mpdm_materialplan", (String)"id, inter_assist_type, planmode", (QFilter[])new QFilter[]{new QFilter("masterid.id", "=", (Object)filter_material.getLong("id")), new QFilter("status", "=", (Object)"C"), BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_materialplan", (Long)filter_org.getLong("id"))});
                if (planInfo == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"MaterialPlanInfoNotFound_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long innerCopTypeId = planInfo.getLong("inter_assist_type");
                this.getModel().setValue("innercoptype", (Object)(innerCopTypeId > 0L ? innerCopTypeId : null));
                this.getModel().setValue("psplantype", (Object)planInfo.getString("planmode"));
            } else {
                DynamicObjectCollection entrys = QueryServiceHelper.query((String)"msplan_matplanscop", (String)"entrymatplanscop.plantype, entrymatplanscop.planscope, entrymatplanscop.inter_assist_type", (QFilter[])new QFilter[]{new QFilter("planscope.id", "=", (Object)filter_planscope.getLong("id")), new QFilter("createorg.id", "=", (Object)filter_org.getLong("id")), new QFilter("material.id", "=", (Object)filter_material.getLong("id"))});
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    if (entry.getLong("entrymatplanscop.planscope") != filter_planscope.getLong("id")) continue;
                    Long innerCopTypeId = entry.getLong("entrymatplanscop.inter_assist_type");
                    this.getModel().setValue("innercoptype", (Object)(innerCopTypeId > 0L ? innerCopTypeId : null));
                    this.getModel().setValue("psplantype", (Object)entry.getString("entrymatplanscop.plantype"));
                    break;
                }
            }
        }
    }

    private void resetDisplay(String name) {
        if (!"filter_material".equals(name) && !"filter_org".equals(name)) {
            return;
        }
        DynamicObject filter_material = (DynamicObject)this.getModel().getValue("filter_material");
        DynamicObject filter_org = (DynamicObject)this.getModel().getValue("filter_org");
        DynamicObject filter_planscope = (DynamicObject)this.getModel().getValue("filter_planscope");
        boolean isClearPlanScope = true;
        if (filter_org != null && filter_planscope != null) {
            HashSet<Long> ids = new HashSet<Long>(4);
            if (filter_material != null) {
                ids.addAll(this.getMaterialPlanScope(filter_material, filter_org));
            }
            ids.add(this.getOrgPlanScope());
            if (!ids.contains(filter_planscope.getLong("id"))) {
                this.getModel().setValue("filter_planscope", null);
            } else {
                this.planScopeChanged("filter_planscope");
                isClearPlanScope = false;
            }
        } else {
            this.getModel().setValue("filter_planscope", null);
        }
        if (isClearPlanScope) {
            this.getModel().setValue("innercoptype", null);
            this.getModel().setValue("psplantype", null);
        }
        boolean istracknumber = false;
        boolean isproject = false;
        DynamicObject manustrategy = null;
        if (filter_material != null && filter_org != null) {
            QFilter qFilterUseOrg = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)filter_org.getLong("id"));
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            statusFilter.and(new QFilter("enable", "=", (Object)"1"));
            QFilter mFilter = new QFilter("masterid", "=", (Object)filter_material.getLong("id"));
            QFilter[] filters = new QFilter[]{statusFilter, mFilter, qFilterUseOrg};
            String select = "id,createorg,masterid,manustrategy";
            Long manustrategyId = 0L;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"bd_materialinventoryinfo", (String)select, (QFilter[])filters, (String)"id desc");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    long createorg = row.getLong("createorg");
                    manustrategyId = row.getLong("manustrategy");
                    if (createorg != filter_org.getLong("id")) continue;
                    break;
                }
            }
            long traceDim = 1297144009797647360L;
            long projectDim = 1297144125837025280L;
            if (manustrategyId > 0L) {
                manustrategy = BusinessDataServiceHelper.loadSingle((Object)manustrategyId, (String)"bd_manustrategy");
                DynamicObjectCollection traceway = manustrategy.getDynamicObjectCollection("traceway");
                for (DynamicObject trace : traceway) {
                    long id = trace.getLong("fbasedataid.id");
                    if (id == traceDim) {
                        istracknumber = true;
                    }
                    if (id != projectDim) continue;
                    isproject = true;
                }
            }
        }
        this.getModel().setValue("manustrategy", manustrategy);
        this.getModel().setValue("istracknumber", (Object)istracknumber);
        this.getModel().setValue("isproject", (Object)isproject);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (this.isStatic()) {
            DynamicObject filter_material = (DynamicObject)this.getModel().getValue("filter_material");
            DynamicObject filter_org = (DynamicObject)this.getModel().getValue("filter_org");
            this.materialChanged(e);
            this.resetDisplay(name);
            this.planScopeChanged(name);
        } else {
            this.materialChanged(e);
            this.resetDisplay(name);
            this.planScopeChanged(name);
        }
        String propertyName = e.getProperty().getName();
        if ("filter_org".equals(propertyName) || "filter_material".equals(propertyName)) {
            DynamicObject filter_material = (DynamicObject)this.getModel().getValue("filter_material");
            DynamicObject filter_org = (DynamicObject)this.getModel().getValue("filter_org");
            if (filter_material == null || filter_org == null) {
                this.getModel().setValue("purchasegroup", null);
                this.getModel().setValue("purchaseperson", null);
            } else {
                Long purchaseOrgId = 0L;
                if (filter_org.getBoolean("fispurchase")) {
                    purchaseOrgId = filter_org.getLong("id");
                } else {
                    List purchaseOrgIds = OrgUnitServiceHelper.getAllToOrg((String)"", (String)"02", (Long)filter_org.getLong("id"), (boolean)true);
                    if (CollectionUtils.isNotEmpty((Collection)purchaseOrgIds)) {
                        purchaseOrgId = (Long)purchaseOrgIds.get(0);
                    }
                }
                HashSet<Long> materialNumberSet = new HashSet<Long>();
                Long materialId = filter_material.getLong("id");
                materialNumberSet.add(materialId);
                Map retData = (Map)DispatchServiceHelper.invokeService((String)"kd.scmc.pm.servicehelper", (String)"pm", (String)"PurApplyService", (String)"getMaterialFitOperatorNew", (Object[])new Object[]{purchaseOrgId, materialNumberSet});
                if (retData != null && !retData.isEmpty()) {
                    this.getModel().setValue("purchasegroup", ((Map)retData.get(materialId)).get("operatorgroup"));
                    this.getModel().setValue("purchaseperson", ((Map)retData.get(materialId)).get("operator"));
                } else {
                    this.getModel().setValue("purchasegroup", null);
                    this.getModel().setValue("purchaseperson", null);
                }
            }
            if (this.isStatic() && "filter_org".equals(propertyName) && this.getModel().getValue("filter_org") == null) {
                this.getModel().setValue("filter_log", null);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        if ("billtag".equals(key)) {
            HashMap<String, Object> para = new HashMap<String, Object>();
            String entity = e.getRowData().getString("srctype");
            DynamicObject obj = QueryServiceHelper.queryOne((String)entity, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(e.getRowData().getString("billid")))});
            if (obj == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"SupplyDemandDetailFormPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), e.getRowData().getString("srctype")));
                return;
            }
            if ("mds_data".equals(entity)) {
                SupplyDemandRptNewFormPlugin.getMDSData(obj.getString("id"), para);
            } else {
                para.put("formId", entity);
                para.put("pkId", obj.getString("id"));
            }
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
        } else {
            Object tmp;
            Date date;
            HashMap<String, Object> cusParams = new HashMap<String, Object>();
            cusParams.put("formId", "mrp_supdem_query_detail");
            String cacheId = String.valueOf(this.getQueryParam().getCustomParam().get("detail_dataset_id"));
            cusParams.put("detail_dataset_id", cacheId);
            cusParams.put("isStatic", this.isStatic());
            Calendar cal = Calendar.getInstance();
            DynamicObject row = e.getRowData();
            String title = ResManager.loadKDString((String)"\u4f9b\u9700\u660e\u7ec6\uff08%1$s\uff09\uff0c\u65e5\u671f\uff1a%2$s ~ %3$s", (String)"SupplyDemandRptFormPlugin_5", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
            String type = "unknown";
            String from = "";
            String to = "";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Long track = 0L;
            Long project = 0L;
            if ("displayday".equals(key)) {
                date = (Date)row.get("day");
                cusParams.put("startdate", date.getTime());
                cusParams.put("enddate", date.getTime());
                from = to = sdf.format(date);
                type = ResManager.loadKDString((String)"\u5929", (String)"SupplyDemandRptFormPlugin_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
                tmp = row.get("daytrack");
                if (tmp instanceof DynamicObject) {
                    track = ((DynamicObject)tmp).getLong("id");
                } else if (tmp instanceof Long) {
                    track = (Long)tmp;
                }
                tmp = row.get("dayproject");
                if (tmp instanceof DynamicObject) {
                    project = ((DynamicObject)tmp).getLong("id");
                } else if (tmp instanceof Long) {
                    project = (Long)tmp;
                }
            } else if ("displayweek".equals(key)) {
                date = (Date)row.get("week");
                cal.setTime(date);
                from = sdf.format(date);
                cusParams.put("startdate", date.getTime());
                cal.add(3, 1);
                cal.add(6, -1);
                to = sdf.format(cal.getTime());
                cusParams.put("enddate", cal.getTime().getTime());
                type = ResManager.loadKDString((String)"\u5468", (String)"SupplyDemandRptFormPlugin_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
                tmp = row.get("weektrack");
                if (tmp instanceof DynamicObject) {
                    track = ((DynamicObject)tmp).getLong("id");
                } else if (tmp instanceof Long) {
                    track = (Long)tmp;
                }
                tmp = row.get("weekproject");
                if (tmp instanceof DynamicObject) {
                    project = ((DynamicObject)tmp).getLong("id");
                } else if (tmp instanceof Long) {
                    project = (Long)tmp;
                }
            } else if ("displaymonth".equals(key)) {
                date = (Date)row.get("month");
                cal.setTime(date);
                from = sdf.format(date);
                cusParams.put("startdate", date.getTime());
                cal.add(2, 1);
                cal.add(6, -1);
                to = sdf.format(cal.getTime());
                cusParams.put("enddate", cal.getTime().getTime());
                type = ResManager.loadKDString((String)"\u6708", (String)"SupplyDemandRptFormPlugin_8", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
                tmp = row.get("monthtrack");
                if (tmp instanceof DynamicObject) {
                    track = ((DynamicObject)tmp).getLong("id");
                } else if (tmp instanceof Long) {
                    track = (Long)tmp;
                }
                tmp = row.get("monthproject");
                if (tmp instanceof DynamicObject) {
                    project = ((DynamicObject)tmp).getLong("id");
                } else if (tmp instanceof Long) {
                    project = (Long)tmp;
                }
            }
            cusParams.put("project", project);
            cusParams.put("tracknumber", track);
            cusParams.put("innercoptype", this.getModel().getValue("innercoptype"));
            title = String.format(title, type, from, to);
            ReportShowParameter showParameter = new ReportShowParameter();
            ReportQueryParam param = new ReportQueryParam();
            param.setCustomParam(cusParams);
            param.setFilter(this.getView().getQueryParam().getFilter());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("mrp_supdem_query_detail");
            showParameter.setCaption(title);
            showParameter.setQueryParam(param);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public static void getMDSData(String id, Map<String, Object> para) {
        Long cvrNumId = 0L;
        String formId = "";
        String newId = id;
        String algoKey = SupplyDemandRptNewFormPlugin.class.getSimpleName();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mds_data", (String)"id,fcvrnnum,fcvrnnum.vertype vertype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(id))}, null, (int)1);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                cvrNumId = row.getLong("fcvrnnum");
                String vertype = row.getString("vertype");
                formId = "0".equals(vertype) ? "mds_forecastplandata" : ("1".equals(vertype) ? "mds_mdsplandata" : "mds_dpsplandata");
            }
        }
        dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mds_plandata", (String)"id", (QFilter[])new QFilter[]{new QFilter("fcvrnnum", "=", (Object)cvrNumId)}, null, (int)1);
        var7_7 = null;
        try {
            if (dataSet.hasNext()) {
                newId = dataSet.next().getString("id");
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var7_7 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        para.put("pkId", newId);
        para.put("formId", formId);
    }

    public void tabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        IPageCache cache = this.getPageCache();
        String instId = String.valueOf(this.getModel().getValue("instid"));
        if ("weektab".equals(key) && cache.get(instId + "weekstatsap_query") == null) {
            this.doSubRptQuery("weekstatsap", this.getView().getQueryParam());
        } else if ("monthtab".equals(key) && cache.get(instId + "monthstatsap_query") == null) {
            this.doSubRptQuery("monthstatsap", this.getView().getQueryParam());
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        HashSet<String> filterKeys = new HashSet<String>(16);
        filterKeys.add("rowtype");
        filterKeys.add("billdate");
        filterKeys.add("config");
        filterKeys.add("qty");
        filterKeys.add("leftqty");
        filterKeys.add("onworkqty");
        filterKeys.add("pickedqty");
        filterKeys.add("billtag");
        filterKeys.add("supplier");
        filterKeys.add("customer");
        filterKeys.add("material");
        filterKeys.add("materialname");
        filterKeys.add("unit");
        filterKeys.add("configuredcode");
        filterKeys.add("tracknumber");
        filterKeys.add("project");
        filterKeys.add("matattr");
        filterKeys.add("useorg");
        filterKeys.add("planscope");
        filterKeys.add("warehouse");
        filterKeys.add("parentnumber");
        filterKeys.add("billnumber");
        filterKeys.add("srctype");
        filterKeys.add("billstatusfield");
        filterKeys.add("relevancebill");
        for (SortAndFilterEvent evt : allColumns) {
            if (!filterKeys.contains(evt.getColumnName())) continue;
            evt.setFilter(true);
        }
    }

    private boolean isStatic() {
        Object data = this.getView().getFormShowParameter().getCustomParam("isStatic");
        Boolean isStatic = Boolean.valueOf(String.valueOf(data));
        return isStatic == null ? false : isStatic;
    }

    private static class Tuple<T1, T2> {
        final T1 t1;
        final T2 t2;

        Tuple(T1 t1, T2 t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tuple tuple = (Tuple)o;
            return Objects.equals(this.t1, tuple.t1) && Objects.equals(this.t2, tuple.t2);
        }

        public int hashCode() {
            return Objects.hash(this.t1, this.t2);
        }
    }

    private static class QTY {
        BigDecimal qty = BigDecimal.ZERO;

        private QTY() {
        }

        void add(BigDecimal add) {
            if (add != null) {
                this.qty = this.qty.add(add);
            }
        }
    }

    private static class SumSrcOrg {
        Long mt;
        Long configuredcode;
        Long tracknumber;
        Long auxproperty;
        Long project;
        Long planscope;
        Long warehouse;
        Long unit;
        Long config;
        String orgNumber;

        SumSrcOrg(Long mt, Long configuredcode, Long tracknumber, Long auxproperty, Long project, Long unit, Long config, Long planscope, Long warehouse, String orgNumber) {
            this.mt = mt;
            this.configuredcode = configuredcode;
            this.tracknumber = tracknumber;
            this.project = project;
            this.auxproperty = auxproperty;
            this.unit = unit;
            this.config = config;
            this.planscope = planscope;
            this.warehouse = warehouse;
            this.orgNumber = orgNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SumSrcOrg sumSrcOrg = (SumSrcOrg)o;
            return Objects.equals(this.mt, sumSrcOrg.mt) && Objects.equals(this.configuredcode, sumSrcOrg.configuredcode) && Objects.equals(this.tracknumber, sumSrcOrg.tracknumber) && Objects.equals(this.project, sumSrcOrg.project) && Objects.equals(this.planscope, sumSrcOrg.planscope) && Objects.equals(this.warehouse, sumSrcOrg.warehouse) && Objects.equals(this.auxproperty, sumSrcOrg.auxproperty) && Objects.equals(this.unit, sumSrcOrg.unit) && Objects.equals(this.config, sumSrcOrg.config) && Objects.equals(this.orgNumber, sumSrcOrg.orgNumber);
        }

        public int hashCode() {
            return Objects.hash(this.mt, this.configuredcode, this.tracknumber, this.project, this.planscope, this.warehouse, this.auxproperty, this.unit, this.config, this.orgNumber);
        }
    }
}

