/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.systemparam;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;

public class MrpSystemParamPlugin
extends AbstractFormPlugin {
    private static final String FORMID_SELECTFIELD = "msplan_billfieldselect";
    private static final String FILED_NAME = "fieldname";
    private static final String FIELD_TAG = "fieldtag";
    private static final String CUSTPARAM_TREENODES = "treenodes";
    private static final String CLOSECALLBACK_FIELDSELECT = "fileld_select";
    private static final String SUPDEM_RANGE = "supdem_range";
    private static final String SUPDEM_RANGE_ID = "supdem_range_id";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String fieldname = (String)this.getModel().getValue(FILED_NAME);
        if (fieldname != null) {
            return;
        }
        this.getModel().setValue(FILED_NAME, (Object)ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u4ea4\u8d27\u65e5\u671f", (String)"MrpSystemParamPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FILED_NAME, SUPDEM_RANGE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (FILED_NAME.equals(key)) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"pm_purorderbill");
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
            parameter.setIncludePKField(true);
            parameter.setOnlyPhysicsField(true);
            TreeNode srcBillNode = this.buildBillTreeNodes(parameter);
            String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
            this.showBillFieldForm(nodesJson, CLOSECALLBACK_FIELDSELECT);
        } else if (SUPDEM_RANGE.equals(key)) {
            Long supdem_range_id = 0L;
            String supdem_range = "";
            Long orgId = 0L;
            DynamicObject org = null;
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && parentView.getModel().getDataEntity().containsProperty("orgfield") && (org = (DynamicObject)parentView.getModel().getValue("orgfield")) != null) {
                orgId = org.getLong("id");
            }
            BillShowParameter parameter = this.getParam();
            if (orgId > 0L) {
                QFilter qFilterOrg = new QFilter("org", "=", (Object)orgId);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"mrp_supdem_rangenew", (String)"id,billno", (QFilter[])new QFilter[]{qFilterOrg}, null, (int)1);){
                    if (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        supdem_range_id = row.getLong(0);
                        supdem_range = String.format("%s-%s", row.getString(1), org.getString("name"));
                    }
                }
            }
            if (supdem_range_id > 0L) {
                parameter.setStatus(OperationStatus.EDIT);
                parameter.setPkId((Object)supdem_range_id);
                this.getView().showForm((FormShowParameter)parameter);
                this.getModel().setValue(SUPDEM_RANGE_ID, (Object)supdem_range_id);
                this.getModel().setValue(SUPDEM_RANGE, (Object)supdem_range);
            } else {
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.setCustomParam("org", (Object)orgId.toString());
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    private BillShowParameter getParam() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("mrp_supdem_rangenew");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setHasRight(true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SUPDEM_RANGE));
        parameter.setAppId("mrp");
        return parameter;
    }

    private void showBillFieldForm(String nodesJson, String custumparam) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        showParameter.getCustomParams().put(CUSTPARAM_TREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, custumparam));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public TreeNode buildBillTreeNodes(BillTreeBuildParameter parameter) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List fldNodes = BillFieldEntityHelper.buildFldTreeNodes((BillTreeBuildParameter)parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && CLOSECALLBACK_FIELDSELECT.equals(closedCallBackEvent.getActionId())) {
            String fieldId = (String)returnData;
            MainEntityType srcbillMainType = MetadataServiceHelper.getDataEntityType((String)"pm_purorderbill");
            String fieldCaption = BillFieldEntityHelper.buildPropFullCaption((EntityType)srcbillMainType, (String)fieldId);
            this.getModel().setValue(FILED_NAME, (Object)fieldCaption);
            this.getModel().setValue(FIELD_TAG, (Object)fieldId);
        } else if (returnData != null && SUPDEM_RANGE.equals(closedCallBackEvent.getActionId())) {
            Map returnMap = (Map)returnData;
            Long rangeId = (Long)DataType.convertValue((DataType)DataType.LongType, returnMap.get("id"));
            String billno = (String)DataType.convertValue((DataType)DataType.StringType, returnMap.get("billno"));
            this.getModel().setValue(SUPDEM_RANGE_ID, (Object)rangeId);
            this.getModel().setValue(SUPDEM_RANGE, (Object)billno);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (SUPDEM_RANGE.equals(name)) {
            for (ChangeData changeSet : e.getChangeSet()) {
                Object newValue = changeSet.getNewValue();
                if (newValue != null && !StringUtils.isBlank((CharSequence)newValue.toString())) continue;
                this.getModel().setValue(SUPDEM_RANGE_ID, (Object)0L);
            }
        }
    }
}

