/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.task;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.mmc.mrp.business.helper.GlobalPlanHelper;
import kd.mmc.mrp.controlnode.framework.runner.MRPRunner4SPlan;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.KDCloudCPSEnv;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.PlanModel;

public class CPSRunningTask
extends AbstractTask {
    private static final String ORG_NUMBER = "org_number";
    private static final String PLAN_GRAM_NUMBER = "plan_gram_number";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.innerExecute(map);
    }

    protected DynamicObject innerExecute(Map<String, Object> map) {
        if (!map.containsKey(ORG_NUMBER)) {
            throw new KDException(new ErrorCode("ORG_NUMBER_IS_EMPTY", String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u5ea6\u4f5c\u4e1a->\u6267\u884c\u53c2\u6570->\u81ea\u5b9a\u4e49\u53c2\u6570[%s](\u8ba1\u5212\u7ec4\u7ec7\u7f16\u7801)\u3002", (String)"CPSRunningTask_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), ORG_NUMBER)), new Object[0]);
        }
        if (!map.containsKey(PLAN_GRAM_NUMBER)) {
            throw new KDException(new ErrorCode("PLAN_NUMBER_IS_EMPTY", String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u5ea6\u4f5c\u4e1a->\u6267\u884c\u53c2\u6570->\u81ea\u5b9a\u4e49\u53c2\u6570[%s](\u8ba1\u5212\u65b9\u6848\u5b9a\u4e49\u7f16\u7801)\u3002", (String)"CPSRunningTask_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), PLAN_GRAM_NUMBER)), new Object[0]);
        }
        String orgNum = (String)map.get(ORG_NUMBER);
        String planNum = (String)map.get(PLAN_GRAM_NUMBER);
        QFilter qFilterOrg = new QFilter("number", "=", (Object)orgNum);
        DynamicObject planorg = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qFilterOrg});
        if (planorg == null) {
            throw new KDException(new ErrorCode("ORG_NUMBER_NOT_EXIST", String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a:\u201c%s\u201d\u7684\u8ba1\u5212\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"CPSRunningTask_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), orgNum)), new Object[0]);
        }
        QFilter qFilter = new QFilter("number", "=", (Object)planNum);
        DynamicObject plangram = QueryServiceHelper.queryOne((String)"mrp_cps_planpro", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (plangram == null) {
            throw new KDException(new ErrorCode("PLAN_NUMBER_NOT_EXIST", String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a:\u201c%s\u201d\u7684\u9f50\u5957\u8ba1\u5212\u65b9\u6848\u5b9a\u4e49\u4e0d\u5b58\u5728\u3002", (String)"CPSRunningTask_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), planNum)), new Object[0]);
        }
        plangram = BusinessDataServiceHelper.loadSingle((Object)plangram.get("id"), (String)"mrp_cps_planpro");
        DynamicObject caculateLog = ORM.create().newDynamicObject("mrp_caculate_log");
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", map.get(ORG_NUMBER))});
        String plantype = PlanModel.getPlanType((DynamicObject)plangram);
        Long id = ORM.create().genLongId("mrp_caculate_log");
        String number = CodeRuleServiceHelper.getNumber((String)"mrp_caculate_log", (DynamicObject)caculateLog, (String)planorg.getPkValue().toString());
        if (StringUtils.isBlank((CharSequence)number)) {
            throw new KDException(new ErrorCode("CAL_LOG_NUMBER_NOT_EXIST", ResManager.loadKDString((String)"\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"CPSRunningTask_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        caculateLog.set("id", (Object)id);
        caculateLog.set("number", (Object)number);
        caculateLog.set("createorg", (Object)org);
        caculateLog.set("useorg", (Object)org);
        caculateLog.set("runtype", (Object)"B");
        caculateLog.set("plantype", (Object)plantype);
        caculateLog.set("clearstatus", (Object)Character.valueOf('A'));
        caculateLog.set("status", (Object)Character.valueOf('C'));
        caculateLog.set("enable", (Object)Character.valueOf('1'));
        caculateLog.set("plangram", (Object)plangram.getLong("id"));
        caculateLog.set("programnumber", (Object)plangram.getString("number"));
        caculateLog.set("programname", (Object)plangram.getString("name"));
        caculateLog.set("plandate", (Object)new Date());
        caculateLog.set("iscommon", plangram.get("iscommon"));
        caculateLog.set("iscustomize", plangram.get("iscustomize"));
        caculateLog.set("isselection", plangram.get("isselection"));
        caculateLog.set("isnotsetup", plangram.get("isnotsetup"));
        caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        caculateLog.set("operatmode", (Object)ResManager.loadKDString((String)"\u9f50\u5957\u5206\u6790", (String)"CPSRunningTask_5", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        caculateLog.set("operatmodekey", (Object)"mrp_cps_runner");
        caculateLog.set("calculatestatus", (Object)"D");
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("ctrlstrategy", (Object)"7");
        caculateLog.set("isllc", (Object)false);
        caculateLog.set("isbomcheck", (Object)false);
        caculateLog.set("isallowdateinpast", (Object)false);
        caculateLog.set("plangramentity", (Object)"mrp_cps_planpro");
        DynamicObjectCollection plantags = plangram.getDynamicObjectCollection("plantags");
        DynamicObjectCollection calctags = caculateLog.getDynamicObjectCollection("plantags");
        calctags.clear();
        for (DynamicObject tag : plantags) {
            DynamicObject cal = calctags.addNew();
            cal.set("fbasedataid", tag.get("fbasedataid"));
        }
        if (GlobalPlanHelper.isExistMRPRunning((Long)plangram.getLong("id"))) {
            throw new KDException(new ErrorCode("PLAN_NUMBER_IS_RUNING", ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"MRPRunningTask_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        if (number != null) {
            ORM.create().save(caculateLog);
            BaseDataServiceHelper.clearCache((DynamicObject)caculateLog);
        }
        KDCloudCPSEnv env = new KDCloudCPSEnv(caculateLog);
        CacheDatas cache = (CacheDatas)env.getService(CacheDatas.class);
        cache.init();
        PlanModel planModel = (PlanModel)env.getService(PlanModel.class);
        planModel.init();
        if (plangram.getDynamicObject("wipbillfields") != null) {
            List<String> requireBills = Arrays.asList("pom_mftstock", "om_mftstock", "mrp_planorder", "om_componentlist");
            List<String> supplyBills = Arrays.asList("pom_mftorder", "om_mftorder", "mrp_planorder", "pm_om_purorderbill");
            HashMap<String, Boolean> requireMap = new HashMap<String, Boolean>(4);
            requireMap.put("pom_mftorder", false);
            requireMap.put("om_mftorder", false);
            requireMap.put("mrp_planorder", false);
            requireMap.put("pm_om_purorderbill", false);
            DynamicObjectCollection col = plangram.getDynamicObjectCollection("entryentity");
            col.forEach(arg_0 -> CPSRunningTask.lambda$innerExecute$0(requireBills, planModel, (IMRPEnvProvider)env, requireMap, arg_0));
            col = plangram.getDynamicObjectCollection("scentryentity");
            col.forEach(arg_0 -> CPSRunningTask.lambda$innerExecute$1(supplyBills, requireMap, planModel, (IMRPEnvProvider)env, arg_0));
        }
        HashSet mIds = new HashSet(16);
        HashMap map1 = new HashMap(8);
        new MRPRunner4SPlan(map1, mIds).run((IMRPEnvProvider)env);
        return caculateLog;
    }

    private static /* synthetic */ void lambda$innerExecute$1(List supplyBills, Map requireMap, PlanModel planModel, IMRPEnvProvider env, DynamicObject entry) {
        String entity = entry.getString("entrysupplyres.id");
        if (supplyBills.contains(entity) && ((Boolean)requireMap.get(entity)).booleanValue()) {
            planModel.getEnabledSupplys().add(entry.getString("resourceregisters.id"));
            if (!entry.getBoolean("entryisscmrpoperat")) {
                env.putCustomParams("is_use_" + entry.getString("entrysupplyres.id"), "1");
            }
        }
    }

    private static /* synthetic */ void lambda$innerExecute$0(List requireBills, PlanModel planModel, IMRPEnvProvider env, Map requireMap, DynamicObject entry) {
        String entity = entry.getString("entrydemandsrc.id");
        if (requireBills.contains(entity)) {
            HashSet enabledRequires = planModel.getEnabledRequires();
            if (entry.getBoolean("entryismrpoperat")) {
                enabledRequires.remove(entry.getString("resourceregister.id"));
                env.putCustomParams("cps_resourceregister_" + entry.getString("entrydemandsrc.id"), entry.getString("resourceregister.id"));
                switch (entity) {
                    case "pom_mftstock": {
                        requireMap.put("pom_mftorder", true);
                        break;
                    }
                    case "om_mftstock": {
                        requireMap.put("om_mftorder", true);
                        break;
                    }
                    case "mrp_planorder": {
                        requireMap.put("mrp_planorder", true);
                        break;
                    }
                    case "om_componentlist": {
                        requireMap.put("pm_om_purorderbill", true);
                        break;
                    }
                }
            }
        }
    }
}

