/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.exception.ErrorCode;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.cache.MRPCacheSerializer;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.model.ArrayBasedHashMap;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;
import kd.mmc.mrp.utils.MRPUtil;

public final class MRPCacheManager {
    private static final MRPCacheManager INSTANCE = new MRPCacheManager();
    private static final String cacheRegion = "mrp";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc_fmm_mrp_region");
    private static ConcurrentHashMap<String, MRPRedisStore> storeMap = new ConcurrentHashMap();

    public static MRPCacheManager getInst() {
        return INSTANCE;
    }

    public static DistributeSessionlessCache getCache() {
        return cache;
    }

    public static MRPRedisStore getDStore(String ctxId) {
        return storeMap.computeIfAbsent(ctxId, ctx -> new MRPRedisStore(cacheRegion, ctxId));
    }

    private MRPCacheManager() {
    }

    public static void clearCache(CalEnv ctx) {
        if (MRPUtil.isByMQ()) {
            MRPCacheManager.getDStore(ctx.getMRPContextId()).close();
            storeMap.remove(ctx.getMRPContextId());
        }
    }

    public void putData(CalEnv ctx, String cacheKey, String cacheValue) {
        if (MRPUtil.isByMQ()) {
            MRPCacheManager.getDStore(ctx.getMRPContextId()).set(cacheKey, cacheValue);
        }
    }

    public String getData(CalEnv ctx, String cacheKey) {
        if (MRPUtil.isByMQ()) {
            MRPRedisStore ds = MRPCacheManager.getDStore(ctx.getMRPContextId());
            if (ds == null) {
                throw new MRPBizException(new ErrorCode("EMPTY_CACHE_STORE", String.format("mrprunner-EMPTY_CACHE_STORE: %s", ctx.getMRPContextId())));
            }
            return (String)ds.get(cacheKey);
        }
        return null;
    }

    public void putSubData(CalEnv ctx, String cacheKey, String subCacheKey, String cacheValue) {
        if (MRPUtil.isByMQ()) {
            MRPCacheManager.getDStore(ctx.getMRPContextId()).mapSet(cacheKey, subCacheKey, cacheValue);
        }
    }

    public String getSubData(CalEnv ctx, String cacheKey, String subCacheKey) {
        if (MRPUtil.isByMQ()) {
            return (String)MRPCacheManager.getDStore(ctx.getMRPContextId()).mapGet(cacheKey, subCacheKey);
        }
        return null;
    }

    public Map<String, String> getSubDataMap(CalEnv ctx, String cacheKey) {
        Map<String, String> map = this.doGetSubDataMap(ctx, cacheKey);
        if (MRPUtil.isByMQ() && MRPUtil.isZipEnabled() && map != null) {
            HashMap<String, String> ret = new HashMap<String, String>(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                ret.put(entry.getKey(), entry.getValue());
            }
            return ret;
        }
        return map;
    }

    private Map<String, String> doGetSubDataMap(CalEnv ctx, String cacheKey) {
        if (MRPUtil.isByMQ()) {
            return MRPCacheManager.getDStore(ctx.getMRPContextId()).mapGetAll(cacheKey);
        }
        return null;
    }

    public void putTypedData(CalEnv ctx, String cacheKey, Object cacheValue) {
        if (MRPUtil.isByMQ()) {
            MRPCacheManager.getDStore(ctx.getMRPContextId()).set(cacheKey, cacheValue);
        }
    }

    public <T> T getTypedData(CalEnv ctx, String cacheKey, MRPCacheSerializer<T> cs) {
        if (MRPUtil.isByMQ()) {
            return MRPCacheManager.getDStore(ctx.getMRPContextId()).get(cacheKey);
        }
        return null;
    }

    @Deprecated
    public void setBOMTableSrcData(CalEnv ctx, List<Object[]> list) {
        this.setSplitListValue(ctx, MRPRuntimeConsts.getBOMDataKey(ctx.getMRPContextId()), list, MRPUtil.getCacheSplitSize());
    }

    public void setBOMTableSrcData(CalEnv ctx, Iterator<Object[]> iter) {
        this.setSplitListValue(ctx, MRPRuntimeConsts.getBOMDataKey(ctx.getMRPContextId()), iter, MRPUtil.getCacheSplitSize());
    }

    @Deprecated
    public List<Object[]> getBOMTableSrcData(CalEnv ctx) {
        return this.getSplitListValue(ctx, MRPRuntimeConsts.getBOMDataKey(ctx.getMRPContextId()), json -> (List)JSON.parseObject((String)json, (TypeReference)new TypeReference<List<Object[]>>(){}, (Feature[])new Feature[0]));
    }

    public Iterator<Object[]> getBOMTableSrcData2(final CalEnv ctx) {
        return new Iterator<Object[]>(){
            Iterator<Object[]> iter;
            int i = 0;

            @Override
            public boolean hasNext() {
                String keyPrefix = MRPRuntimeConsts.getBOMDataKey(ctx.getMRPContextId()) + '#';
                if (this.iter == null || !this.iter.hasNext()) {
                    List list = MRPCacheManager.this.getTypedData(ctx, keyPrefix + this.i++, json -> (List)JSON.parseObject((String)json, (TypeReference)new TypeReference<List<Object[]>>(){}, (Feature[])new Feature[0]));
                    if (list == null || list.isEmpty()) {
                        return false;
                    }
                    this.iter = list.iterator();
                }
                return this.iter.hasNext();
            }

            @Override
            public Object[] next() {
                return this.iter.next();
            }
        };
    }

    public void setBOMTableSrcDataByGroup(CalEnv ctx, final BOMStructDataTable bomTbl) {
        ColumnDatas mCol = bomTbl.getCol(DefaultField.BOMField.MATERIAL.getName());
        Iterator<Comparable<?>> iter = mCol.iterator();
        while (iter.hasNext()) {
            Comparable<?> mId = iter.next();
            final List<Integer> rows = mCol.get(mId);
            this.setSplitListValue(ctx, MRPRuntimeConsts.getBOMDataKey(ctx.getMRPContextId()) + "\u0001" + mId, (Iterator<? extends Object>)new Iterator<Object[]>(){
                Iterator<Integer> innerIter;
                {
                    this.innerIter = rows.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.innerIter.hasNext();
                }

                @Override
                public Object[] next() {
                    return bomTbl.getSrcDatas().getDatas().get(this.innerIter.next());
                }
            }, MRPUtil.getCacheSplitSize());
        }
    }

    public List<Object[]> getBOMTableSrcDataByGroup(CalEnv ctx, String materialId) {
        return this.getSplitListValue(ctx, MRPRuntimeConsts.getBOMDataKey(ctx.getMRPContextId()) + "\u0001" + materialId, json -> (List)JSON.parseObject((String)json, (TypeReference)new TypeReference<List<Object[]>>(){}, (Feature[])new Feature[0]));
    }

    public void updatePlanOrders(CalEnv ctx, String materialId, List<Map<String, Object>> list, int round) {
        String cacheKey = MRPRuntimeConsts.getMaterial2PlanOrderKey(ctx.getMRPContextId(), materialId);
        String keyPrefix = cacheKey + '#';
        this.putTypedData(ctx, keyPrefix + round, list);
    }

    @Deprecated
    public void setPlanOrders(CalEnv ctx, String materialId, List<Map<String, Object>> list) {
        this.setSplitListValue(ctx, MRPRuntimeConsts.getMaterial2PlanOrderKey(ctx.getMRPContextId(), materialId), list, MRPUtil.getCacheSplitSize());
    }

    public void setPlanOrders(CalEnv ctx, String materialId, List<Map<String, Object>> list, int batchSize) {
        this.setSplitListValue(ctx, MRPRuntimeConsts.getMaterial2PlanOrderKey(ctx.getMRPContextId(), materialId), list, batchSize);
    }

    public void setPlanOrders3(CalEnv ctx, String materialId, List<Map<String, Object>> list, int batchSize, int round) {
        this.setSplitListValue(ctx, MRPRuntimeConsts.getMaterial2PlanOrderKey(ctx.getMRPContextId(), materialId), list.iterator(), batchSize, round, false);
    }

    public Map<String, Object> zipPlanOrderMap(Map<String, Object> map) {
        if (map instanceof ArrayBasedHashMap) {
            return map;
        }
        try (TraceSpan ts = Tracer.create((String)"MRPDataResolver.wrapPo", (String)"wrapPo");){
            Map<String, Integer> indexes = ArrayBasedHashMap.parseHeader(map);
            map = ArrayBasedHashMap.wrap(indexes, map);
            List entrys = (List)map.get("entryentity");
            if (entrys != null) {
                ArrayList newEntrys = new ArrayList(entrys.size());
                for (Object e : entrys) {
                    ArrayBasedHashMap ne = (ArrayBasedHashMap)e;
                    Map entryIndexes = ArrayBasedHashMap.parseHeader(ne);
                    ne = ArrayBasedHashMap.wrap(entryIndexes, ne);
                    newEntrys.add(ne);
                }
                map.put("entryentity", newEntrys);
            }
        }
        return map;
    }

    public Iterator<Map<String, Object>> getPlanOrders(final CalEnv ctx, String materialId) {
        final String cacheKey = MRPRuntimeConsts.getMaterial2PlanOrderKey(ctx.getMRPContextId(), materialId);
        return new Iterator<Map<String, Object>>(){
            Iterator<Map<String, Object>> iter;
            int i = 0;

            @Override
            public boolean hasNext() {
                String keyPrefix = cacheKey + '#';
                if (this.iter == null || !this.iter.hasNext()) {
                    List list = MRPCacheManager.this.getTypedData(ctx, keyPrefix + this.i++, json -> {
                        if (StringUtils.isEmpty((String)json)) {
                            return null;
                        }
                        try (TraceSpan ts = Tracer.create((String)"MRPDataResolver.jsonStr2PoBatch", (String)"jsonStr2PoBatch");){
                            List list = (List)JSON.parseObject((String)json, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                            return list;
                        }
                    });
                    if (list == null || list.isEmpty()) {
                        return false;
                    }
                    this.iter = list.iterator();
                }
                return this.iter.hasNext();
            }

            @Override
            public Map<String, Object> next() {
                Map<String, Object> next = this.iter.next();
                return MRPCacheManager.this.zipPlanOrderMap(next);
            }
        };
    }

    public void clearPlanOrders(CalEnv ctx, String materialId) {
        String subKey = MRPRuntimeConsts.getMaterial2PlanOrderKey(ctx.getMRPContextId(), materialId);
        this.clearBatchImpl(ctx, subKey);
    }

    private void clearBatchImpl(CalEnv ctx, String subKey) {
        String round = this.getSubData(ctx, "mrp-batch-size-summarize", subKey);
        if (StringUtils.isEmpty((String)round)) {
            return;
        }
        Integer count = Integer.valueOf(round);
        String keyPrefix = subKey + '#';
        for (int i = 0; i <= count; ++i) {
            MRPCacheManager.getDStore(ctx.getMRPContextId()).remove(keyPrefix + i);
        }
        MRPCacheManager.getDStore(ctx.getMRPContextId()).mapRemove("mrp-batch-size-summarize", subKey);
    }

    public void setReserveCache(CalEnv ctx, String materialId, List<Map<String, Object>> list) {
        this.setSplitListValue(ctx, MRPRuntimeConsts.getMaterialKey4Reserve(ctx.getMRPContextId(), materialId), list, MRPUtil.getCacheSplitSize());
    }

    public List<Map<String, Object>> getReserveCache(CalEnv ctx, String materialId) {
        return this.getSplitListValue(ctx, MRPRuntimeConsts.getMaterialKey4Reserve(ctx.getMRPContextId(), materialId), json -> (List)JSON.parseObject((String)json, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]));
    }

    public void setMaterialDetails(CalEnv ctx, String materialId, List<Map<String, Object>> list) {
        this.setSplitListValue(ctx, MRPRuntimeConsts.getMaterialKey4Balance(ctx.getMRPContextId(), materialId), list, MRPUtil.getCacheSplitSize());
    }

    public void setMaterialDetails2(CalEnv ctx, String materialId, List<Map<String, Object>> list, int batchSize, int currentBatch) {
        this.setSplitListValue(ctx, MRPRuntimeConsts.getMaterialKey4Balance(ctx.getMRPContextId(), materialId), list.iterator(), batchSize, currentBatch, true);
    }

    @Deprecated
    public List<Map<String, Object>> getMaterialDetails(CalEnv ctx, String materialId) {
        return this.getSplitListValue(ctx, MRPRuntimeConsts.getMaterialKey4Balance(ctx.getMRPContextId(), materialId), json -> (List)JSON.parseObject((String)json, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]));
    }

    public Iterator<Map<String, Object>> getMaterialDetails2(final CalEnv ctx, String materialId) {
        final String cacheKey = MRPRuntimeConsts.getMaterialKey4Balance(ctx.getMRPContextId(), materialId);
        return new Iterator<Map<String, Object>>(){
            Iterator<Map<String, Object>> iter;
            int i = 0;

            @Override
            public boolean hasNext() {
                String keyPrefix = cacheKey + '#';
                if (this.iter == null || !this.iter.hasNext()) {
                    List list = MRPCacheManager.this.getTypedData(ctx, keyPrefix + this.i++, json -> {
                        if (StringUtils.isEmpty((String)json)) {
                            return null;
                        }
                        try (TraceSpan ts = Tracer.create((String)"MRPDataResolver.jsonStr2DetailBatch", (String)"jsonStr2DetailBatch");){
                            List list = (List)JSON.parseObject((String)json, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                            return list;
                        }
                    });
                    if (list == null || list.isEmpty()) {
                        return false;
                    }
                    this.iter = list.iterator();
                }
                return this.iter.hasNext();
            }

            @Override
            public Map<String, Object> next() {
                Map<String, Object> next = this.iter.next();
                try (TraceSpan ts = Tracer.create((String)"MRPDataResolver.wrapDetail", (String)"wrapDetail");){
                    Map<String, Integer> indexes = ArrayBasedHashMap.parseHeader(next);
                    next = ArrayBasedHashMap.wrap(indexes, next);
                }
                return next;
            }
        };
    }

    public void clearMaterialDetails(CalEnv ctx, String materialId) {
        String subKey = MRPRuntimeConsts.getMaterial2PlanOrderKey(ctx.getMRPContextId(), materialId);
        this.clearBatchImpl(ctx, subKey);
    }

    public void setBOMTableColIdx(CalEnv ctx, Map<String, Integer> indexMap) {
        this.setBOMTableColIdx(ctx, indexMap, MRPUtil.getCacheSplitSize());
    }

    public void setBOMTableColIdx(CalEnv ctx, Map<String, Integer> indexMap, int batchSize) {
        this.setSplitMapValue(ctx, MRPRuntimeConsts.getBOMMetaKey(ctx.getMRPContextId()), indexMap, batchSize);
    }

    public Map<String, Integer> getBOMTableColIdx(CalEnv ctx) {
        return this.getSplitMapValue(ctx, MRPRuntimeConsts.getBOMMetaKey(ctx.getMRPContextId()), json -> (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<Map<String, Integer>>(){}, (Feature[])new Feature[0]));
    }

    public void clearData(String ctxId) {
    }

    private void setSplitListValue(CalEnv ctx, String cacheKey, Iterator<? extends Object> values, int batchSize) {
        this.setSplitListValue(ctx, cacheKey, values, batchSize, 0, true);
    }

    private void setSplitListValue(CalEnv ctx, String cacheKey, List<? extends Object> values, int batchSize) {
        this.setSplitListValue(ctx, cacheKey, values.iterator(), batchSize, 0, true);
    }

    private void setSplitListValue(CalEnv ctx, String cacheKey, Iterator<? extends Object> values, int batchSize, int round, boolean putSummarize) {
        String keyPrefix = cacheKey + '#';
        int i = 0;
        ArrayList<Object> roundData = new ArrayList<Object>(batchSize);
        while (values.hasNext()) {
            Object value = values.next();
            roundData.add(value);
            if (++i % batchSize != 0) continue;
            this.putTypedData(ctx, keyPrefix + round, roundData);
            roundData.clear();
            ++round;
        }
        if (!roundData.isEmpty()) {
            this.putTypedData(ctx, keyPrefix + round, roundData);
        }
        if (putSummarize) {
            this.putSubData(ctx, "mrp-batch-size-summarize", cacheKey, String.valueOf(round));
        }
    }

    private <T> List<T> getSplitListValue(CalEnv ctx, String cacheKey, JsonListParser<T> jsonParser) {
        List list;
        String keyPrefix = cacheKey + '#';
        LinkedList ret = new LinkedList();
        int i = 0;
        while ((list = this.getTypedData(ctx, keyPrefix + i, json -> {
            if (StringUtils.isEmpty((String)json)) {
                return null;
            }
            return jsonParser.parse(json);
        })) != null && !list.isEmpty()) {
            ret.addAll(list);
            ++i;
        }
        return ret;
    }

    private void setSplitMapValue(CalEnv ctx, String cacheKey, Map<String, Integer> values, int batchSize) {
        String keyPrefix = cacheKey + '#';
        int round = 0;
        int i = 0;
        HashMap<String, Integer> roundData = new HashMap<String, Integer>(batchSize);
        for (Map.Entry<String, Integer> entry : values.entrySet()) {
            roundData.put(entry.getKey(), entry.getValue());
            if (++i % batchSize != 0) continue;
            this.putTypedData(ctx, keyPrefix + round, roundData);
            roundData.clear();
            ++round;
        }
        if (!roundData.isEmpty()) {
            this.putTypedData(ctx, keyPrefix + round, roundData);
        }
    }

    private <T> Map<String, T> getSplitMapValue(CalEnv ctx, String cacheKey, JsonMapParser<T> jsonParser) {
        Map map;
        String keyPrefix = cacheKey + '#';
        HashMap ret = new HashMap(1024);
        int i = 0;
        while ((map = this.getTypedData(ctx, keyPrefix + i, json -> {
            if (StringUtils.isEmpty((String)json)) {
                return null;
            }
            return jsonParser.parse(json);
        })) != null && !map.isEmpty()) {
            ret.putAll(map);
            ++i;
        }
        return ret;
    }

    public static String zip(String primStr) {
        return primStr;
    }

    public static String unzip(String compressedStr) {
        return compressedStr;
    }

    private static interface JsonMapParser<T> {
        public Map<String, T> parse(String var1);
    }

    private static interface JsonListParser<T> {
        public List<T> parse(String var1);
    }
}

