/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.fomula.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import kd.mmc.mrp.framework.fomula.ExprContext;
import kd.mmc.mrp.framework.fomula.IToken;
import kd.mmc.mrp.framework.fomula.enums.TokenType;

public class TokenNode {
    private List<IToken> tokens;
    private TokenNode left;
    private TokenNode right;
    private TokenNode parent;
    private boolean isBracketNode;
    private boolean isMiddleBracketNode;

    public TokenNode(IToken token) {
        this.tokens = new ArrayList<IToken>();
        this.tokens.add(token);
    }

    public TokenNode(TokenNode node) {
        this.isBracketNode = true;
        this.left = node;
    }

    public IToken getFirst() {
        return this.tokens.get(0);
    }

    public IToken getLast() {
        return this.tokens.get(this.tokens.size() - 1);
    }

    public void addOperand(IToken token) {
        this.tokens.add(token);
    }

    public void addFirst(IToken token) {
        this.tokens.add(0, token);
    }

    public void pushOperand(IToken token) {
        this.tokens.add(0, token);
    }

    public TokenNode getLeft() {
        return this.left;
    }

    public void setLeft(TokenNode left) {
        left.parent = this;
        this.left = left;
    }

    public TokenNode getRight() {
        return this.right;
    }

    public void setRight(TokenNode right) {
        right.parent = this;
        this.right = right;
    }

    public TokenNode getRoot() {
        TokenNode parent = this;
        while (parent.parent != null) {
            parent = parent.parent;
        }
        return parent;
    }

    public boolean isFull() {
        return this.left != null && this.right != null;
    }

    public void setChild(TokenNode child) {
        child.parent = this;
        if (this.left == null) {
            this.left = child;
        } else if (this.right == null) {
            this.right = child;
        }
    }

    public void setMiddleBracketNode(boolean isMiddleBracketNode) {
        this.isMiddleBracketNode = isMiddleBracketNode;
    }

    public boolean isBracketNode() {
        return this.isBracketNode;
    }

    public boolean isSingleTokenNode() {
        return this.tokens != null && this.tokens.size() == 1;
    }

    public IToken getToken(int pos) {
        return this.tokens.get(pos);
    }

    public List<IToken> getParamTokens() {
        ArrayList<IToken> paramTokens = new ArrayList<IToken>(6);
        for (IToken token : this.tokens) {
            if (token.getType() == TokenType.COMMA) continue;
            paramTokens.add(token);
        }
        return paramTokens;
    }

    public void action(ExprContext ctx) {
        if (this.isBracketNode) {
            this.left.action(ctx);
            return;
        }
        if (this.left != null) {
            this.left.action(ctx);
        }
        if (this.right != null) {
            this.right.action(ctx);
        }
        Stack<Object> stack = ctx.getStack();
        int commaCount = 0;
        for (IToken token : this.tokens) {
            token.action(ctx);
            if (token.getType() != TokenType.COMMA) continue;
            ++commaCount;
        }
        if (commaCount != 0) {
            Object[] values = new Object[commaCount + 1];
            for (int i = commaCount; i >= 0; --i) {
                values[i] = stack.pop();
            }
            stack.push(values);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isBracketNode && this.left != null) {
            String leftStr = this.left.toString();
            sb.append('(').append(leftStr).append(')');
            return sb.toString();
        }
        if (this.isMiddleBracketNode) {
            sb.append('[');
        }
        if (this.left != null) {
            String leftStr = this.left.toString();
            sb.append(leftStr);
        }
        for (int i = 0; i < this.tokens.size(); ++i) {
            IToken token = this.tokens.get(i);
            if (i > 0 && this.tokens.get(i - 1).getType() == TokenType.COMMA) {
                sb.append(' ');
            }
            if (token == null) continue;
            String tokenStr = token.toString();
            sb.append(tokenStr);
        }
        if (this.right != null) {
            String rightStr = this.right.toString();
            sb.append(rightStr);
        }
        if (this.isMiddleBracketNode) {
            sb.append(']');
        }
        return sb.toString();
    }
}

