/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.mq;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.mq.IMRPEventManager;
import kd.mmc.mrp.framework.mq.IStats;
import kd.mmc.mrp.framework.mq.OnResponse;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.integrate.KDCloudLogRecorder;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.utils.MRPUtil;

public class DefaultOnResponse
implements OnResponse,
IStats {
    private static Log logger = LogFactory.getLog(DefaultOnResponse.class);
    private IMRPExecuteLogRecorder logRecorder;
    private IMRPEnvProvider ctx;
    private KDCloudLogRecorder.Wrapper wrapper;
    public static final String RESPONSE_DATA_COUNT = "RESPONSE_DATA_COUNT";
    public static final String DETAIL_COUNT = "DETAIL_COUNT";
    public static final String DEPENDENT_COUNT = "DEPENDENT_COUNT";
    public static final String REQUIRE_COUNT = "REQUIRE_COUNT";
    public static final String SUPPLY_COUNT = "SUPPLY_COUNT";
    private int response_data_count;
    private int detail_count;
    private int dependent_count;
    private int require_count;
    private int supply_count;

    public DefaultOnResponse(IMRPEnvProvider ctx, IMRPExecuteLogRecorder logRecorder) {
        this.ctx = ctx;
        this.logRecorder = logRecorder;
    }

    @Override
    public int getStatsCount(String fieldName) {
        if (RESPONSE_DATA_COUNT.equals(fieldName)) {
            return this.response_data_count;
        }
        if (DETAIL_COUNT.equals(fieldName)) {
            return this.detail_count;
        }
        if (DEPENDENT_COUNT.equals(fieldName)) {
            return this.dependent_count;
        }
        if (REQUIRE_COUNT.equals(fieldName)) {
            return this.require_count;
        }
        if (SUPPLY_COUNT.equals(fieldName)) {
            return this.supply_count;
        }
        return -1;
    }

    @Override
    public void resetStatsCount(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            if (RESPONSE_DATA_COUNT.equals(fieldName)) {
                this.response_data_count = 0;
                continue;
            }
            if (DETAIL_COUNT.equals(fieldName)) {
                this.detail_count = 0;
                continue;
            }
            if (DEPENDENT_COUNT.equals(fieldName)) {
                this.dependent_count = 0;
                continue;
            }
            if (REQUIRE_COUNT.equals(fieldName)) {
                this.require_count = 0;
                continue;
            }
            if (!SUPPLY_COUNT.equals(fieldName)) continue;
            this.supply_count = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void response(MRPEvent event) {
        KDCloudLogRecorder.Wrapper old = IMRPExecuteLogRecorder.LOCAL.get();
        try {
            IMRPExecuteLogRecorder.LOCAL.set(this.wrapper);
            DefaultOnResponse defaultOnResponse = this;
            synchronized (defaultOnResponse) {
                this.responseImpl(event);
            }
        }
        finally {
            IMRPExecuteLogRecorder.LOCAL.set(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void responseImpl(MRPEvent event) {
        boolean failed = event.isFailed();
        IMRPExecuteLogRecorder recorder = event.getRecorder() == null ? this.logRecorder : event.getRecorder();
        int logIdx = event.getSubStepIdx();
        long start = event.getPublishTime();
        String materialId = String.valueOf(event.getParam(MultiThreadCacheKey.KEY_MATERIAL_ID));
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mrprunner-saveplanorders-response, mid: %s, savecount: %s, evtId: %s, class: %s", materialId, event.getParam(MultiThreadCacheKey.KEY_REPLY_SAVE_COUNT), event.getEventId(), event.getClass()));
        }
        if (event.getParam(MultiThreadCacheKey.KEY_REPLY_SAVE_COUNT) != null) {
            Integer count = Integer.valueOf(String.valueOf(event.getParam(MultiThreadCacheKey.KEY_REPLY_SAVE_COUNT)));
            this.response_data_count += count.intValue();
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                if ("po".equals(String.valueOf(event.getParam(MultiThreadCacheKey.KEY_MODEL_ID)))) {
                    logger.warn(String.format("ctxid: %s, mrprunner-pocount-sum mid: %s, count: %s, sum-sount: %s", this.ctx.getMRPContextId(), materialId, count, this.response_data_count));
                } else {
                    logger.warn(String.format("ctxid: %s, mrprunner-detail-sum mid: %s, count: %s, sum-sount: %s", this.ctx.getMRPContextId(), materialId, count, this.response_data_count));
                }
            }
        }
        if (event.getParam(MultiThreadCacheKey.KEY_DETAILS) != null) {
            int[] details = (int[])JSON.parseObject((String)String.valueOf(event.getParam(MultiThreadCacheKey.KEY_DETAILS)), int[].class);
            this.require_count += details[0];
            this.supply_count += details[1];
            this.detail_count += details[2];
            this.dependent_count += details[3];
        }
        String eventId = event.getEventId();
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-ctrl-node-receive: %s", event.getMrpContextId(), eventId));
        }
        IMRPEventManager iMRPEventManager = this.ctx.getMQManager();
        synchronized (iMRPEventManager) {
            String msg;
            boolean lastEvent;
            int remainEvtCnt = this.ctx.getMQManager().getRemainEvtCount(event.getEventId());
            boolean bl = lastEvent = remainEvtCnt == 0;
            if (failed) {
                msg = MRPExecuteStatus.ERROR_STOP.getAlias();
                String exception = (String)((Object)event.getParam(MultiThreadCacheKey.KEY_SERVICE_EXCEPTION));
                if (exception != null) {
                    String errMsg = (String)((Object)event.getParam(MultiThreadCacheKey.KEY_SERVICE_EXCEPTION_DETAIL));
                    recorder.updateStepLog("entrydetailmsg_tag", errMsg);
                }
            } else {
                msg = lastEvent ? MRPExecuteStatus.FINISHED.getAlias() : MRPExecuteStatus.RUNNING.getAlias();
            }
            Serializable notUpdateRunLog = event.getParam(MultiThreadCacheKey.KEY_IS_NOT_UPDATE_RUNLOG);
            if (notUpdateRunLog == null || !MRPUtil.isTrue(notUpdateRunLog)) {
                recorder.updateSubStepLog(logIdx, "entrydetailmsg", String.format(ResManager.loadKDString((String)"\u5269\u4f59\u8ba1\u7b97\u4e8b\u4ef6\uff1a%s", (String)"DefaultOnResponse_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]), remainEvtCnt));
                recorder.updateSubStepLog(logIdx, "entryresult", msg);
                long now = System.currentTimeMillis();
                double time = (double)(now - start) / 1000.0 / 60.0;
                recorder.updateSubStepLog(logIdx, "entryoperatmin", time);
                recorder.saveStepLog(false);
            }
            event.onResponse();
        }
    }

    @Override
    public void setLogWrapper(KDCloudLogRecorder.Wrapper wrapper) {
        this.wrapper = wrapper;
    }
}

