/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.mq.rabbit;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.dynamic.DynamicQueueManagerFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.utils.MRPUtil;

public class RabbitMQEnvProvider
implements Runnable {
    private static final Log logger = LogFactory.getLog(RabbitMQEnvProvider.class);
    private int mqClearDaySpan = 10;

    public void clearUnRelatedQueues(int mqClearDaySpan, boolean isInNewThread) {
        this.mqClearDaySpan = mqClearDaySpan;
        if (isInNewThread) {
            ThreadPools.executeOnceIncludeRequestContext((String)"MRP-Ctrl-Queue-Clear", (Runnable)this);
        } else {
            this.newClearMethod();
        }
    }

    @Override
    public void run() {
        this.newClearMethod();
    }

    protected void newClearMethod() {
        Row next2;
        Throwable throwable;
        DataSet ds;
        long before;
        long today;
        ORM orm = ORM.create();
        SimpleDateFormat format = MRPUtil.createSimpleDateFormat();
        try {
            today = format.parse(format.format(new Date())).getTime();
            before = today - (long)this.mqClearDaySpan * 86400000L;
        }
        catch (Throwable e) {
            logger.error("mrprunner-clear-ctrl-queue-failed", e);
            return;
        }
        HashSet<String> status = new HashSet<String>();
        status.add(MRPExecuteStatus.ERROR_STOP.getValue());
        status.add(MRPExecuteStatus.MANU_STOP.getValue());
        status.add(MRPExecuteStatus.FINISHED.getValue());
        try {
            ds = orm.queryDataSet(RabbitMQEnvProvider.class.getName(), "mrp_caculate_log", "mrpid,machineid", new QFilter[]{new QFilter("startdate", "<", (Object)new Date(today)), new QFilter("startdate", ">=", (Object)new Date(today - 172800000L)), new QFilter("calculatestatus", "in", status)});
            throwable = null;
            try {
                while (ds.hasNext()) {
                    next2 = ds.next();
                    this.mqDelete(next2);
                }
            }
            catch (Throwable next2) {
                throwable = next2;
                throw next2;
            }
            finally {
                if (ds != null) {
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable next2) {
                            throwable.addSuppressed(next2);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.error("mrprunner-clear-ctrl-queue-failed", e);
        }
        try {
            ds = orm.queryDataSet(RabbitMQEnvProvider.class.getName(), "mrp_caculate_log", "mrpid,machineid", new QFilter[]{new QFilter("startdate", "<", (Object)new Date(today - 172800000L)), new QFilter("startdate", ">=", (Object)new Date(before)), new QFilter("calculatestatus", "=", (Object)MRPExecuteStatus.RUNNING.getValue())});
            throwable = null;
            try {
                while (ds.hasNext()) {
                    next2 = ds.next();
                    this.mqDelete(next2);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds != null) {
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.error("mrprunner-clear-ctrl-queue-failed", e);
        }
    }

    private void mqDelete(Row next) {
        String ctxId = next.getString("mrpid");
        String nodeId = next.getString("machineid");
        String ctrlQueueName = "kd.mmc.mrp.calcnode.mrp_queue." + nodeId + "." + ctxId;
        String name = QueueManager.getRealQueueName((String)"mmc", (String)ctrlQueueName);
        logger.warn("mrprunner-clear-mq-queue-data, mrpctx: " + name);
        boolean isOk = DynamicQueueManagerFactory.get((String)"mmc").deleteQueue(ctrlQueueName);
        logger.warn(String.format("mrprunner-mq-clear-result, qn: %s, isdeleted: %s", name, isOk));
    }
}

