/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.runner;

import java.util.concurrent.ConcurrentHashMap;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.mq.IMRPEventManager;
import kd.mmc.mrp.framework.runner.IMRPRunner;

public class MRPCalcManager {
    private static ConcurrentHashMap<String, IMRPRunner> runnerCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, IMRPEnvProvider> contextCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, IMRPEventManager> evtManageCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> ctxId2ManagerId = new ConcurrentHashMap();

    private MRPCalcManager() {
    }

    public static void setContext(IMRPEnvProvider ctx) {
        contextCache.put(ctx.getMRPContextId(), ctx);
    }

    public static IMRPEnvProvider getContext(String mrpContextId) {
        return contextCache.get(mrpContextId);
    }

    public static IMRPEnvProvider getContextByPlanId(String planId) {
        for (IMRPEnvProvider provider : contextCache.values()) {
            if (provider == null || !provider.getPlanId().equals(planId)) continue;
            return provider;
        }
        return null;
    }

    public static void removeContext(String mrpContextId) {
        contextCache.remove(mrpContextId);
    }

    public static IMRPRunner getRunner(String mrpContextId) {
        return runnerCache.get(mrpContextId);
    }

    public static void registRunner(String mrpContextId, IMRPRunner runner) {
        runnerCache.put(mrpContextId, runner);
    }

    public static void destroyRunner(String mrpContextId) {
        runnerCache.remove(mrpContextId);
        contextCache.remove(mrpContextId);
        String evtManagerId = ctxId2ManagerId.remove(mrpContextId);
        if (evtManagerId != null) {
            evtManageCache.remove(evtManagerId);
        }
    }

    public static void registEventManager(String mrpContextId, IMRPEventManager manager) {
        if (manager.getId() == null) {
            return;
        }
        ctxId2ManagerId.put(mrpContextId, manager.getId());
        evtManageCache.putIfAbsent(manager.getId(), manager);
    }

    public static IMRPEventManager getEventManager(String id) {
        if (id == null) {
            return null;
        }
        return evtManageCache.get(id);
    }

    public static void destroyEventManager(String id) {
        if (id == null) {
            return;
        }
        evtManageCache.remove(id);
    }
}

