/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.service;

import java.util.List;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageConsumer;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.threads.ThreadPools;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.framework.mq.MRPMQManager;
import kd.mmc.mrp.framework.mq.event.MRPEvent;

public class MRPCalcEventListener
implements Runnable {
    private static Log logger = LogFactory.getLog(MRPCalcEventListener.class);
    private static String REAL_CONSUMER_CLASS_NAME = "kd.mmc.mrp.calcnode.framework.mq.consumer.MRPCalcNodeConsumer";

    @Override
    public void run() {
        List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        for (Account account : accounts) {
            MRPRedisChannel channel = new MRPRedisChannel(account, this.createMessageConsumer());
            channel.start();
        }
    }

    private MessageConsumer createMessageConsumer() {
        MessageConsumer consumer;
        try {
            consumer = (MessageConsumer)Class.forName(REAL_CONSUMER_CLASS_NAME).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.error("mrprunner-warning: failed to init mrp consumer.", (Throwable)e);
            return null;
        }
        return consumer;
    }

    private static class MRPRedisChannel {
        private Account account;
        private MessageConsumer consumer;
        private String redis_calc_queue_name;
        private Throwable preError;

        public MRPRedisChannel(Account account, MessageConsumer consumer) {
            this.account = account;
            this.consumer = consumer;
            String accountId = account.getAccountId();
            String tenantId = account.getTenantId();
            String debugTag = System.getProperty("mq.debug.queue.tag");
            this.redis_calc_queue_name = String.format("%s\u0001%s\u0001%s\u0001calc_event_queue", accountId, tenantId, debugTag);
        }

        public void start() {
            ThreadPools.executeOnceIncludeRequestContext((String)String.format("mrp-redis-calc-event-consumer-%s(%s)-%s", this.account.getAccountName(), this.account.getAccountNumber(), this.account.getTenantId()), (Runnable)new Runnable(){

                @Override
                public void run() {
                    while (this.isRun()) {
                        try {
                            String configKey = CacheConfigKeys.getSessionlessConfigKey((String)"mrp");
                            String url = System.getProperty(configKey);
                            if (url == null) {
                                configKey = CacheConfigKeys.getSessionlessConfigKey((String)null);
                                url = System.getProperty(configKey);
                            }
                            JedisClient client = RedisFactory.getJedisClient((String)url);
                            Throwable throwable = null;
                            try {
                                while (this.isRun()) {
                                    List cmds = client.brpop(10, redis_calc_queue_name);
                                    if (cmds == null) continue;
                                    MRPEvent event = (MRPEvent)MRPRedisStore.decode(((String)cmds.get(1)).getBytes("iso8859-1"));
                                    RequestContext.set((RequestContext)event.getCtx());
                                    consumer.onMessage((Object)event, event.getEventId(), true, MRPMQManager.REDIS_EMPTY_ACKER);
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (client == null) continue;
                                if (throwable != null) {
                                    try {
                                        client.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                client.close();
                            }
                        }
                        catch (Throwable e) {
                            String msg;
                            if (preError == null) {
                                preError = e;
                                logger.error("mrprunner-redis-listening-failed.", e);
                                continue;
                            }
                            String preMsg = preError.getMessage();
                            if (StringUtils.equals((CharSequence)preMsg, (CharSequence)(msg = e.getMessage()))) continue;
                            preError = e;
                            logger.error("mrprunner-redis-listening-failed.", e);
                        }
                    }
                }
            });
        }

        private boolean isRun() {
            return true;
        }
    }
}

