/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.step;

import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.mrp.exception.MRPManuStopException;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.step.IMRPResult;
import kd.mmc.mrp.framework.step.IMRPStep;
import kd.mmc.mrp.framework.step.IMRPSubStep;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.utils.MRPUtil;

public abstract class AbstractMRPStep
implements IMRPStep {
    protected IMRPEnvProvider ctx;
    protected IMRPExecuteLogRecorder lr;
    protected int dataAmount = 0;
    protected int stepIdx = 0;
    private int percent = 0;
    protected String stepDesc = null;

    protected AbstractMRPStep(IMRPEnvProvider ctx) {
        this.ctx = ctx;
    }

    @Override
    public IMRPEnvProvider getMRPContext() {
        return this.ctx;
    }

    @Override
    public final void createStepLog(int stepIdx, int percent) {
        this.stepIdx = stepIdx;
        this.percent = percent;
        this.lr = this.ctx.createLogRecorder();
        this.lr.createStepLog(stepIdx, this.getStepDesc());
        List<IMRPSubStep> subs = this.getSubSteps();
        if (subs != null) {
            for (int i = 0; i < subs.size(); ++i) {
                IMRPSubStep sub = subs.get(i);
                this.lr.createSubStepLog(i, sub.getDesc(), stepIdx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute() {
        long start = System.currentTimeMillis();
        try {
            this.lr.updateStepLog("entryresult", MRPExecuteStatus.RUNNING.getAlias());
            try {
                this.executeWithSubs();
            }
            catch (Throwable e) {
                MRPExecuteStatus status = MRPExecuteStatus.ERROR_STOP;
                if (e instanceof MRPManuStopException) {
                    status = MRPExecuteStatus.MANU_STOP;
                }
                this.lr.updateStepLog("entryresult", status.getAlias());
                this.lr.updateStepLog("entrydetailmsg_tag", MRPUtil.getStackTrace(e));
                throw e;
            }
            String status = this.lr.getLogEntryStatus();
            if (status == null || status.isEmpty() || status.equalsIgnoreCase(MRPExecuteStatus.RUNNING.getAlias())) {
                this.lr.updateStepLog("entryresult", MRPExecuteStatus.FINISHED.getAlias());
            }
        }
        finally {
            this.lr.updateStepLog("entryprocessdata", this.dataAmount);
            String associateForm = this.getAssociateForm();
            if (this.dataAmount > 0 && StringUtils.isNotBlank((CharSequence)associateForm)) {
                this.lr.updateStepLog("associateform", associateForm);
            }
            double end = (double)(System.currentTimeMillis() - start) / 1000.0 / 60.0;
            this.lr.updateStepLog("entryoperatmin", end);
            this.lr.updateRunLog("calculatepro", this.percent);
            this.lr.saveStepLog(true);
            this.doFinally();
        }
    }

    private void executeWithSubs() {
        this.innerExecute();
        List<IMRPSubStep> subs = this.getSubSteps();
        if (subs != null) {
            for (int i = 0; i < subs.size(); ++i) {
                IMRPSubStep sub = subs.get(i);
                IMRPResult result = sub.execute();
                this.lr.updateSubStepLog(i, "entryprocessdata", result.getDataAmount());
            }
        }
    }

    protected abstract void innerExecute();

    @Override
    public List<IMRPSubStep> getSubSteps() {
        return null;
    }

    @Override
    public void setStepDescByNodeName(String nodeName) {
        this.stepDesc = nodeName;
    }

    @Override
    public String getStepDesc() {
        String fixedStepDesc = this.getStepDesc(Locale.CHINESE);
        return this.stepDesc == null ? fixedStepDesc : this.stepDesc;
    }
}

