/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IDispatchEvent;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.mq.DefaultOnResponse;
import kd.mmc.mrp.framework.mq.IMRPEventManager;
import kd.mmc.mrp.framework.mq.event.MRPDataSaveEvent;
import kd.mmc.mrp.integrate.entity.ResDataModelCollection;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;

public abstract class AbstractDispatchMRPSaveEvent
implements IDispatchEvent {
    protected CalEnv ctx;
    protected String modelId;
    protected IMRPExecuteLogRecorder logRecorder;

    protected AbstractDispatchMRPSaveEvent(CalEnv ctx, String modelId) {
        this.ctx = ctx;
        this.modelId = modelId;
        this.logRecorder = (IMRPExecuteLogRecorder)ctx.getService(IMRPExecuteLogRecorder.class);
    }

    @Override
    public int dispatchEvent() {
        ResDataModelCollection resDataModel = (ResDataModelCollection)this.ctx.getService(ResDataModelCollection.class);
        IMRPEventManager mqManager = (IMRPEventManager)this.ctx.getService(IMRPEventManager.class);
        BOMStructDataTable table = resDataModel.getBom().getTable();
        List<Set<String>> llc2m = table.getLLC();
        HashSet<String> requireLlc2m = new HashSet<String>(table.getRequireMaterials());
        DefaultOnResponse onResponse = (DefaultOnResponse)mqManager.getOnResponse();
        onResponse.resetStatsCount("RESPONSE_DATA_COUNT");
        for (Set<String> ids : llc2m) {
            for (String id : ids) {
                if (this.isNotDispatchEvent(id)) continue;
                MRPDataSaveEvent evt = new MRPDataSaveEvent();
                evt.setParam(MultiThreadCacheKey.KEY_MATERIAL_ID, (Serializable)((Object)id));
                this.saveEventSetPublicParams(evt);
                mqManager.publishCalcEvent(evt);
            }
            requireLlc2m.removeAll(ids);
        }
        for (String id : requireLlc2m) {
            if (this.isNotDispatchEvent(id)) continue;
            MRPDataSaveEvent evt = new MRPDataSaveEvent();
            evt.setParam(MultiThreadCacheKey.KEY_MATERIAL_ID, (Serializable)((Object)id));
            this.saveEventSetPublicParams(evt);
            mqManager.publishCalcEvent(evt);
        }
        mqManager.wait4Response();
        return onResponse.getStatsCount("RESPONSE_DATA_COUNT");
    }

    protected abstract boolean isNotDispatchEvent(String var1);

    protected void saveEventSetPublicParams(MRPDataSaveEvent evt) {
        evt.setParam(MultiThreadCacheKey.KEY_MODEL_ID, (Serializable)((Object)this.modelId));
        evt.setMrpContextId(this.ctx.getMRPContextId());
        evt.setRecorder(this.logRecorder);
    }
}

