/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.IMRPDataSaveResolver;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.wrapper.FieldMapping;
import kd.mmc.mrp.utils.MRPUtil;

public abstract class AbstractKDCloudDataSaver
implements IMRPDataSaveResolver {
    private int poCnt = 0;

    @Override
    public final List<Map<String, Object>> saveMapping(IMRPEnvProvider provider, List<DataBalanceTable.RSMapping> mappings) {
        ArrayList<Map<String, Object>> poList = new ArrayList<Map<String, Object>>();
        RequireDataModel requireModel = (RequireDataModel)provider.getService(RequireDataModel.class);
        List<FieldMapping> outputMappings = requireModel.getOutputMapping();
        for (int i = 0; i < mappings.size(); ++i) {
            provider.testEnvStatus();
            DataBalanceTable.RSMapping mapping = mappings.get(i);
            Map<String, Object> po = this.saveMappingImpl(provider, mapping, outputMappings);
            if (po == null) continue;
            poList.add(po);
        }
        return poList;
    }

    private Map<String, Object> saveMappingImpl(IMRPEnvProvider provider, DataBalanceTable.RSMapping mapping, List<FieldMapping> outputMappings) {
        String exp;
        RequireRowData rowData = mapping.getRequire();
        String string = exp = rowData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()) == null ? "" : String.valueOf(rowData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()));
        if (MRPUtil.hasException(exp)) {
            return null;
        }
        if (mapping.getrQty() == null) {
            mapping.setrQty(BigDecimal.ZERO);
        }
        if (mapping.isCopied() || mapping.getrQty().compareTo(BigDecimal.ZERO) <= 0) {
            return null;
        }
        Map<String, Object> po = this.resolveMapping(provider, mapping, outputMappings);
        if (po != null && mapping.isGenPlanOrder()) {
            BigDecimal orderQty = MRPUtil.convert(po.get("orderqty"), BigDecimal.ZERO);
            String mid = MRPUtil.convert(po.get("material"), "");
            if (MRPUtil.isExceededQty(orderQty)) {
                String[] strings = provider.getMaterialDataById(mid);
                throw new MRPBizException(Errors.getDetailExceededQtyError(), strings[0], po.get("demandbill"), po.get("demandseq"), orderQty.toPlainString());
            }
            return po;
        }
        return null;
    }

    @Override
    public int getCreatePoCount() {
        return this.poCnt;
    }

    @Override
    public void saveMappingAndWriteRedis(IMRPEnvProvider provider, List<DataBalanceTable.RSMapping> mappings) {
        List poList;
        int round;
        RequireDataModel requireModel = (RequireDataModel)provider.getService(RequireDataModel.class);
        List<FieldMapping> outputMappings = requireModel.getOutputMapping();
        HashMap<String, List> m2Po = new HashMap<String, List>(2);
        int batchSize = (Integer)provider.getCfgValue(EnvCfgItem.PO_REDIS_DATA_BATCH);
        HashMap<String, Integer> m2PoRound = new HashMap<String, Integer>(2);
        HashMap<String, Integer> po2Size = new HashMap<String, Integer>(2);
        for (int i = 0; i < mappings.size(); ++i) {
            Integer size;
            provider.testEnvStatus();
            DataBalanceTable.RSMapping mapping = mappings.get(i);
            Map<String, Object> po = this.saveMappingImpl(provider, mapping, outputMappings);
            if (po == null) continue;
            ++this.poCnt;
            po = MRPCacheManager.getInst().zipPlanOrderMap(po);
            String material = String.valueOf(po.get("material"));
            round = m2PoRound.getOrDefault(material, 0);
            poList = m2Po.computeIfAbsent(material, k -> new ArrayList(batchSize));
            poList.add(po);
            Integer n = size = po2Size.getOrDefault(material, 0);
            Integer n2 = size = Integer.valueOf(size + 1);
            po2Size.put(material, size);
            if (batchSize != poList.size()) continue;
            MRPCacheManager.getInst().setPlanOrders3(provider, material, poList, batchSize, round);
            poList.clear();
            m2PoRound.put(material, ++round);
        }
        for (Map.Entry entry : po2Size.entrySet()) {
            poList = (List)m2Po.get(entry.getKey());
            round = m2PoRound.getOrDefault(entry.getKey(), 0);
            if (poList != null && !poList.isEmpty()) {
                MRPCacheManager.getInst().setPlanOrders3(provider, (String)entry.getKey(), poList, batchSize, round);
            }
            MRPCacheManager.getInst().putData(provider, MRPRuntimeConsts.getPlanOrderSplitKey(provider.getMRPContextId(), (String)entry.getKey()), String.valueOf(entry.getValue()));
            MRPCacheManager.getInst().putSubData(provider, "mrp-batch-size-summarize", MRPRuntimeConsts.getMaterial2PlanOrderKey(provider.getMRPContextId(), (String)entry.getKey()), String.valueOf(round));
        }
    }

    protected abstract Map<String, Object> resolveMapping(IMRPEnvProvider var1, DataBalanceTable.RSMapping var2, List<FieldMapping> var3);
}

