/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.SqlRequest;
import kd.bos.orm.query.SqlTreeNode;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mrp.framework.IMRPDataFetcher;
import kd.mmc.mrp.framework.IMRPDataSourceResolver;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.model.wrapper.DynamicRowSet;
import kd.mmc.mrp.utils.DataSourceUtil;
import kd.mpscmm.msplan.mservice.service.datafetch.model.FetchDataQueryModule;
import kd.mpscmm.msplan.mservice.service.datasync.MMCSnapDataVisitor;

public class KDCloudDataFetcher
implements IMRPDataFetcher {
    private static final Log logger = LogFactory.getLog(KDCloudDataFetcher.class);
    protected IMRPEnvProvider ctx;
    private DynamicObject mrpDs;
    private FetchDataQueryModule dataQueryModule;
    private String resId;
    private String resNumber;
    protected String TYPE_ASC = "asc";
    protected String TYPE_DESC = "desc";

    public KDCloudDataFetcher(IMRPEnvProvider ctx) {
        this.ctx = ctx;
    }

    @Override
    public DynamicRowSet fetchDatas(String modelId, Set<String> metaCols) {
        return this.fetchDatas(modelId, metaCols, null, false);
    }

    @Override
    public DataSet queryDatas(String modelId, Set<String> metaCols, String filter, boolean isSelectFilter) {
        DataSet metaRs;
        String algoFilter;
        IMRPDataSourceResolver dataResolver;
        QFilter qFilter;
        String srcMaterial;
        boolean isFilter;
        ORM orm = ORM.create();
        this.mrpDs = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(modelId), (String)"mrp_resource_dataconfig");
        this.resId = String.valueOf(this.mrpDs.get("id"));
        this.resNumber = this.mrpDs.getString("number");
        this.dataQueryModule = filter != null && !isSelectFilter ? DataSourceUtil.getQueryModuleByModelFilter(Long.valueOf(modelId), QFilter.fromSerializedString((String)filter)) : DataSourceUtil.getQueryModuleByModel(Long.valueOf(modelId), null);
        String mt = this.dataQueryModule.getMt();
        String oql = this.dataQueryModule.getOql();
        String className = this.getClass().getName();
        QFilter[] qFilters = this.dataQueryModule.getqFilters();
        boolean bl = isFilter = filter != null && isSelectFilter;
        if (isFilter && StringUtils.isNotBlank((CharSequence)(srcMaterial = DataSourceUtil.getSrcMaterialField(this.mrpDs, (qFilter = QFilter.fromSerializedString((String)filter)).getProperty())))) {
            qFilter.__setProperty(srcMaterial);
            QFilter[] newFilters = new QFilter[qFilters.length + 1];
            System.arraycopy(qFilters, 0, newFilters, 1, qFilters.length);
            newFilters[0] = qFilter;
            qFilters = newFilters;
            isFilter = false;
        }
        DataSet ds = null;
        DynamicObject runlog = BusinessDataServiceHelper.loadSingle((String)"mrp_caculate_log", (String)"id, dataversion", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.ctx.getRunLogNumber())});
        DynamicObject dataVersion = null;
        if (runlog != null) {
            dataVersion = runlog.getDynamicObject("dataversion");
        }
        if (dataVersion != null) {
            Long versionId = dataVersion.getLong("id");
            ds = new MMCSnapDataVisitor().localFastDataVisit(versionId, null, mt, oql, qFilters, null);
        }
        if (ds == null) {
            ds = this.loadRealTimeDatas(orm, mt, qFilters, this.mrpDs, className, oql);
        }
        if ((dataResolver = this.ctx.getDataSourceResolver()) != null && (algoFilter = dataResolver.getAlgoFilterStr(this.resId, this.resNumber)) != null) {
            ds = ds.where(algoFilter);
        }
        ds = DataSourceUtil.getDataSetByModel(this.dataQueryModule, ds);
        if (isFilter) {
            QFilter qFilter2 = QFilter.fromSerializedString((String)filter);
            ds = ds.filter(qFilter2.toString());
        }
        DynamicObject transferDyn = this.mrpDs.getDynamicObject("billfieldtransfer");
        transferDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)transferDyn.getLong("id"), (String)"mrp_billfieldtransfer");
        DynamicObjectCollection fieldMappingAll = transferDyn.getDynamicObjectCollection("entryentity");
        RowMeta rowMeta = ds.getRowMeta();
        metaCols.removeIf(s -> rowMeta.getFieldIndex(s, false) < 0);
        LinkedHashSet<String> metaColList = new LinkedHashSet<String>(metaCols);
        String sorttype = transferDyn.getString("sorttype");
        String sort = "";
        if (StringUtils.equals((CharSequence)sorttype, (CharSequence)"0")) {
            sort = this.TYPE_ASC;
        } else if (StringUtils.equals((CharSequence)sorttype, (CharSequence)"1")) {
            sort = this.TYPE_DESC;
        }
        for (DynamicObject mappingEntry : fieldMappingAll) {
            boolean issortfield = mappingEntry.getBoolean("issortfield");
            if (!issortfield) continue;
            metaColList.add(mappingEntry.getString("destfieldflag"));
        }
        if (metaColList.isEmpty()) {
            metaRs = ds;
        } else {
            String[] metaArrays = metaColList.toArray(new String[0]);
            if (StringUtils.isNotBlank((CharSequence)sort)) {
                for (int i = 0; i < metaArrays.length; ++i) {
                    metaArrays[i] = String.format("%s %s", metaArrays[i], sort);
                }
            }
            metaRs = ds.orderBy(metaArrays);
        }
        return metaRs;
    }

    @Override
    public DynamicRowSet fetchDatas(String modelId, Set<String> metaCols, String filter, boolean isSelectFilter) {
        DataSet ds = this.queryDatas(modelId, metaCols, filter, isSelectFilter);
        HashMap<String, ArrayList<Object[]>> all = new HashMap<String, ArrayList<Object[]>>();
        IMRPDataSourceResolver dataResolver = this.ctx.getDataSourceResolver();
        String resId = String.valueOf(this.mrpDs.get("id"));
        String resNumber = this.mrpDs.getString("number");
        return this.visitDataSet(ds, metaCols, all, dataResolver, resId, resNumber);
    }

    private DataSet loadRealTimeDatas(ORM orm, String mt, QFilter[] filters, DynamicObject mrpDs, String className, String oql) {
        try {
            SqlTreeNode root = orm.getQuerySql(mt, oql, filters, null, 0, -1);
            KDCloudDataFetcher.logSql(this.ctx, root, mrpDs.getString("name"), mrpDs.getString("number"), className, mt);
        }
        catch (Throwable e) {
            logger.error(String.format("mrprunner-fetch-datas-%s-parseSQLFailed", className), e);
        }
        return orm.queryDataSet(className, mt, oql, filters, null);
    }

    private DynamicRowSet visitDataSet(DataSet ds, Set<String> metaCols, HashMap<String, ArrayList<Object[]>> all, IMRPDataSourceResolver dataResolver, String resId, String resNumber) {
        RowMeta meta = ds.getRowMeta();
        String[] metas = new String[meta.getFieldCount()];
        int idx = 0;
        int len = meta.getFieldCount();
        for (int i = 0; i < len; ++i) {
            String name = meta.getFieldName(i);
            metas[idx++] = name;
        }
        DynamicRowSet rs = new DynamicRowSet();
        rs.setMetas(metas);
        rs.setRows(all);
        rs.setData(ds);
        rs.setModelId(resId);
        rs.setModelNumber(resNumber);
        return rs;
    }

    public static void logSql(IMRPEnvProvider ctx, SqlTreeNode node, String dsName, String dsNumber, String className, String mt) {
        List children;
        SqlRequest req = node.getValue();
        if (req != null) {
            logger.warn(String.format("mrprunner-fetch-datas-%s, rl: %s, dsname: %s(%s), mt: %s, route: %s, sql: %s, ppk: %s", className, ctx.getRunLogNumber(), dsName, dsNumber, mt, req.getDbRoute(), req.getSql(), req.getParentFK()));
        }
        if ((children = node.getChildren()) == null) {
            return;
        }
        for (SqlTreeNode c : children) {
            KDCloudDataFetcher.logSql(ctx, c, dsName, dsNumber, className, mt);
        }
    }
}

