/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.common.consts.PlanScopeRelationConst;
import kd.mmc.mrp.exception.MRPManuStopException;
import kd.mmc.mrp.framework.IMRPDataFetcher;
import kd.mmc.mrp.framework.IMRPDataSaveResolver;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.MRPWorkCalendarManager;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.mq.DefaultOnResponse;
import kd.mmc.mrp.framework.mq.IMRPEventManager;
import kd.mmc.mrp.framework.mq.MRPMQManager;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.framework.step.IMRPCallableConfigurator;
import kd.mmc.mrp.integrate.KDCloudDataFetcher;
import kd.mmc.mrp.integrate.KDCloudDataSaver;
import kd.mmc.mrp.integrate.KDCloudLogRecorder;
import kd.mmc.mrp.integrate.KDCloudSysConfigProvider;
import kd.mmc.mrp.integrate.entity.BomDataModel;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.InventoryModel;
import kd.mmc.mrp.integrate.entity.IssuePlanModel;
import kd.mmc.mrp.integrate.entity.MtPlanInfoModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.PlanScopeModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.entity.ResDataModelCollection;
import kd.mmc.mrp.integrate.entity.RunLogModel;
import kd.mmc.mrp.integrate.entity.SupplyDataModel;
import kd.mmc.mrp.model.PrioritySettingDatas;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mmc.mrp.model.enums.CollaboratePlanBillSource;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.status.CollaboratePlanBillStatus;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.model.enums.strategy.BillSplitStrategy;
import kd.mmc.mrp.model.enums.strategy.OORBillResolveStrategy;
import kd.mmc.mrp.model.enums.strategy.PriorityLevelApplyType;
import kd.mmc.mrp.model.enums.strategy.PriorityLevelCalcMode;
import kd.mmc.mrp.model.struct.MRPCooperateParamStruct;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.ExtendDataTable;
import kd.mmc.mrp.model.table.MergeDataTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;
import kd.mmc.mrp.model.table.res.FlexFieldDataTable;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.wrapper.FieldMapping;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.vo.MergeCycleVo;
import kd.sdk.mmc.mrp.extpoint.IMRPCalcNetDemandPlugin;

public class KDCloudMRPEnv
implements IMRPEnvProvider {
    private static final Log logger = LogFactory.getLog(KDCloudMRPEnv.class);
    private static final String USER_PARAMS = "USER_PARAMS";
    private String mrpContextId = ID.longTo36Radix((long)ID.genLongId());
    private ResDataModelCollection resDataModel;
    private DataBalanceTable calcBalanceDetails;
    private List<FieldMapping> r2po = new ArrayList<FieldMapping>();
    private List<FieldMapping> b2po = new ArrayList<FieldMapping>();
    private ExtendDataTable orgRelationDatas;
    private ExtendDataTable materialExDatas;
    private PlanModel planModel;
    private MtPlanInfoModel planInfoModel;
    private InventoryModel inventoryModel;
    private PlanScopeModel planScopeModel;
    private HashMap<String, MRPCooperateParamStruct> cooperateParams = new HashMap();
    private IMRPEventManager mqManager;
    private MRPWorkCalendarManager dateManager;
    private KDCloudSysConfigProvider sysConfigManager;
    private ORM orm = ORM.create();
    private KDCloudLogRecorder logRecorder;
    private HashMap<String, String> contextParams = new HashMap();
    private volatile boolean isShutdown = false;
    private String currentMaterialId;
    private Map<Long, List<MergeCycleVo>> specialCycleCache = new HashMap<Long, List<MergeCycleVo>>();
    private CacheDatas cacheDatas;
    private Map<Class<?>, Object> services = new HashMap(8);
    private RunLogModel runLogModel;
    private Map<String, BigDecimal> richQtyMap = new HashMap<String, BigDecimal>(16);
    private Map<Long, List<DataBalanceTable.RSMapping>> rsMappingMap = new HashMap<Long, List<DataBalanceTable.RSMapping>>(16);
    private FlexFieldDataTable flexDatas;
    private Map<String, List<Map<String, Object>>> reserveCache = new HashMap<String, List<Map<String, Object>>>(2);
    private Map<String, Set<String>> removePlanOrders = new HashMap<String, Set<String>>(2);
    private Map<String, Integer> po2BomIdx = new HashMap<String, Integer>(2);
    private Map<String, Object> localCache = new HashMap<String, Object>();
    private IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin;
    private Map<String, RequireRowData> invPlanKey2Require = new HashMap<String, RequireRowData>(2);
    private Map<String, BigDecimal> poNum2RequireQty = new HashMap<String, BigDecimal>(2);
    private Map<String, Map<String, BigDecimal>> supplyOccupyQty = new HashMap<String, Map<String, BigDecimal>>(2);
    private Map<String, ArrayBlockingQueue<String>> poNumQueueMap = new HashMap<String, ArrayBlockingQueue<String>>(2);
    private int genBatch = -1;

    @Override
    public <T> T getService(Class<?> clazz) {
        return (T)this.services.get(clazz);
    }

    @Override
    public void addService(Class<?> clazz, Object service) {
        this.services.put(clazz, service);
    }

    public KDCloudMRPEnv(DynamicObject runLog) {
        this.init(runLog);
    }

    private void init(DynamicObject runLog) {
        String mrpContextId = runLog.getString("mrpid");
        if (StringUtils.isEmpty((String)mrpContextId)) {
            runLog.set("mrpid", (Object)this.mrpContextId);
            String dbKey = runLog.getDataEntityType().getDBRouteKey();
            DB.execute((DBRoute)new DBRoute(dbKey), (String)"update t_mrp_caculatelog set fmrpid = ? where fid = ? ", (Object[])new Object[]{this.mrpContextId, runLog.get("id")});
        } else {
            this.mrpContextId = mrpContextId;
        }
        this.runLogModel = new RunLogModel(this, runLog);
        this.logRecorder = new KDCloudLogRecorder(this.orm, runLog);
        this.addService(IMRPExecuteLogRecorder.class, this.logRecorder);
        this.mqManager = new MRPMQManager(this, new DefaultOnResponse(this, this.logRecorder));
        this.dateManager = new MRPWorkCalendarManager(this);
        this.sysConfigManager = new KDCloudSysConfigProvider();
        this.cacheDatas = new CacheDatas(this);
        this.planInfoModel = new MtPlanInfoModel(this);
        String entity = runLog.getString("plangramentity");
        this.planModel = "pom_planprogram".equals(entity) ? new IssuePlanModel(this) : new PlanModel(this);
        this.planScopeModel = new PlanScopeModel(this);
        this.inventoryModel = new InventoryModel(this);
        this.resDataModel = new ResDataModelCollection(this, this.planModel, runLog);
    }

    @Override
    public void replaceService(Object service) {
        Class<?> aClass = service.getClass();
        this.services.put(aClass, service);
        if (service instanceof RunLogModel) {
            this.runLogModel = (RunLogModel)service;
        } else if (service instanceof IMRPEventManager) {
            this.mqManager = (IMRPEventManager)service;
        } else if (service instanceof MRPWorkCalendarManager) {
            this.dateManager = (MRPWorkCalendarManager)service;
        } else if (service instanceof CacheDatas) {
            this.cacheDatas = (CacheDatas)service;
        } else if (service instanceof MtPlanInfoModel) {
            this.planInfoModel = (MtPlanInfoModel)service;
        } else if (service instanceof PlanModel) {
            this.planModel = (PlanModel)service;
        } else if (service instanceof ResDataModelCollection) {
            this.resDataModel = (ResDataModelCollection)service;
        }
    }

    @Override
    public ORM getORM() {
        return this.orm;
    }

    @Override
    public void setShutdown() {
        this.isShutdown = true;
    }

    @Override
    public void testEnvStatus() {
        if (this.isShutdown()) {
            throw new MRPManuStopException();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public boolean isDebugMode() {
        return false;
    }

    @Override
    public <T> T getCfgValue(EnvCfgItem item) {
        return this.sysConfigManager.getCfgValue(item);
    }

    @Override
    public PriorityLevelCalcMode getPriorityLevelCalcMode() {
        return this.planModel.getPriorityLevelCalcMode();
    }

    @Override
    public PriorityLevelApplyType getPriorityLevelApplyType() {
        return this.planModel.getPriorityLevelApplyType();
    }

    @Override
    public Object getTolerOfForward() {
        return this.planModel.getTolerOfForward();
    }

    @Override
    public Object getTolerOfDelay() {
        return this.planModel.getTolerOfDelay();
    }

    @Override
    public int getPlanOutLook() {
        return this.planModel.getPlanOutLook();
    }

    @Override
    public Object advanceAdjustPeriod() {
        return this.planModel.advanceAdjustPeriod();
    }

    @Override
    public Object delayAdjustPeriod() {
        return this.planModel.delayAdjustPeriod();
    }

    @Override
    public int requireDelayPeriod() {
        return this.planModel.requireDelayPeriod();
    }

    @Override
    public int supplyDelayPeriod() {
        return this.planModel.supplyDelayPeriod();
    }

    @Override
    public List<FieldMapping> b2r() {
        return this.resDataModel.getRequire().getR2b();
    }

    @Override
    public List<FieldMapping> r2s(boolean isDepentReq) {
        return this.resDataModel.getRequire().getR2s(isDepentReq);
    }

    @Override
    public List<FieldMapping> r2s() {
        return this.resDataModel.getRequire().getR2s();
    }

    @Override
    public List<FieldMapping> r2po() {
        return this.r2po;
    }

    @Override
    public List<FieldMapping> b2po() {
        return this.b2po;
    }

    @Override
    @Deprecated
    public List<FieldMapping> requireFields() {
        return new ArrayList<FieldMapping>();
    }

    @Override
    @Deprecated
    public List<FieldMapping> bomFields() {
        return new ArrayList<FieldMapping>();
    }

    @Override
    public HashMap<String, BillSplitStrategy> strategys() {
        return this.planModel.getStrategys();
    }

    @Override
    public String getPlanId() {
        return String.valueOf(this.runLogModel.getPlanId());
    }

    @Override
    public Long getCompOrgId() {
        return this.planModel.getCompOrgId();
    }

    @Override
    public boolean isAllowPast() {
        return this.runLogModel.isAllowPast();
    }

    @Override
    public String getRunLogNumber() {
        return this.runLogModel.getRunLogNumber();
    }

    @Override
    public DynamicObject getRunLog() {
        return this.runLogModel.getRunLog();
    }

    @Override
    public String getMRPContextId() {
        return this.mrpContextId;
    }

    @Override
    public IMRPExecuteLogRecorder createLogRecorder() {
        return this.logRecorder;
    }

    @Override
    public String getPlanOrgId() {
        return this.planModel.getPlanOrgId();
    }

    @Override
    public Set<String> getEnableMaterialIds() {
        return this.planInfoModel.getEnabledMaterialIds();
    }

    @Override
    public int initRuntimeEnv() {
        this.runLogModel.checkSnap();
        this.sysConfigManager.load();
        this.cacheDatas.init();
        this.planModel.init();
        this.resDataModel.init();
        this.planScopeModel.init();
        int dataAmount = 4;
        dataAmount += this.resDataModel.getBom().isFake() ? 0 : this.resDataModel.getBom().getFields().size();
        dataAmount += this.resDataModel.getRequire().getFields().size();
        dataAmount += this.resDataModel.getSupply().getFields().size();
        dataAmount += this.resDataModel.getBom().isFake() ? 0 : this.resDataModel.getRequire().getR2b().size();
        dataAmount += this.resDataModel.getRequire().getR2s().size();
        dataAmount += this.planModel.getEnabledRequires().size();
        dataAmount += this.planModel.getEnabledSupplys().size();
        dataAmount += this.planModel.getStrategys().size();
        return dataAmount += this.planModel.getOrgs().size();
    }

    @Override
    public void preLoadSysConfiguration() {
        this.sysConfigManager.load();
    }

    @Override
    public int initWorkCalendars() {
        return this.dateManager.initWorkCalendars();
    }

    @Override
    public RequirementDataTable requireDatas() {
        return this.resDataModel.getRequire().getTable();
    }

    @Override
    public SupplymentDataTable supplyDatas() {
        return this.resDataModel.getSupply().getTable();
    }

    @Override
    public BOMStructDataTable bomDatas() {
        return this.resDataModel.getBom().getTable();
    }

    @Override
    public DataBalanceTable calcBalanceDetails() {
        if (this.calcBalanceDetails == null) {
            this.calcBalanceDetails = new DataBalanceTable();
        }
        return this.calcBalanceDetails;
    }

    @Override
    public MRPWorkCalendarManager dateManager() {
        return this.dateManager;
    }

    @Override
    public ExtendDataTable orgRelationDatas() {
        return this.orgRelationDatas;
    }

    @Override
    public ExtendDataTable materialExtDatas() {
        return this.materialExDatas;
    }

    @Override
    public boolean isCalcNetDemand() {
        return this.runLogModel.isCalcNetDemand();
    }

    @Override
    public boolean isScrapRation() {
        return this.planModel.isScrapRation();
    }

    @Override
    public boolean isYield() {
        return this.planModel.isYield();
    }

    @Override
    public boolean isReplace() {
        return this.planModel.isReplace();
    }

    @Override
    public boolean isRelaceFirst() {
        return this.runLogModel.isRelaceFirst();
    }

    @Override
    public boolean isGenReservation() {
        return false;
    }

    @Override
    public IMRPDataSaveResolver createMappingSaver() {
        return new KDCloudDataSaver(this);
    }

    @Override
    public IMRPDataFetcher createDataFetcher() {
        return new KDCloudDataFetcher(this);
    }

    @Override
    public void clearUnRelatedReservations() {
    }

    @Override
    public HashMap<String, SupplyStruct> getPriorityRelations() {
        return this.planModel.getPriorityRelations();
    }

    @Override
    public void runTask(MRPEvent event) {
        this.mqManager.publishCalcEvent(event);
    }

    @Override
    public void wait4Response() {
        this.mqManager.wait4Response();
    }

    @Override
    public IMRPEventManager getMQManager() {
        return this.mqManager;
    }

    @Override
    public BOMStructDataTable createBOMDatas(IMRPExecuteLogRecorder lr) {
        BomDataModel bom = this.resDataModel.getBom();
        bom.fetchDatas(lr, this);
        return bom.getTable();
    }

    @Override
    public int createRequireDatas(IMRPExecuteLogRecorder lr) {
        RequireDataModel require = this.resDataModel.getRequire();
        Set<Long> collect = this.planModel.getEnabledRequires().stream().map(Long::valueOf).collect(Collectors.toSet());
        int ret = require.fetchDatas(collect, lr, this);
        this.resDataModel.getBom().getTable().getRequireMaterials().addAll(require.getTable().getSrcDataKeys());
        MRPCacheManager.getInst().putData(this, MRPRuntimeConsts.getRequireMaterialKey(this.getMRPContextId()), JSON.toJSONString(this.resDataModel.getBom().getTable().getRequireMaterials()));
        return ret;
    }

    @Override
    public MergeDataTable createMergeTable(String ruleId) {
        return this.resDataModel.getRequire().createMergeTable(ruleId);
    }

    @Override
    public String getMaterialAttr(String id, String orgId) {
        return this.planInfoModel.getMaterialAttr(id, orgId);
    }

    @Override
    public int createSupplyDatas(IMRPExecuteLogRecorder lr) {
        SupplyDataModel supply = this.resDataModel.getSupply();
        Set<Long> collect = this.planModel.getEnabledSupplys().stream().map(Long::valueOf).collect(Collectors.toSet());
        int ret = supply.fetchDatas(collect, lr, this);
        this.resDataModel.getBom().getTable().getRequireMaterials().addAll(supply.getTable().getSrcDataKeys());
        MRPCacheManager.getInst().putData(this, MRPRuntimeConsts.getRequireMaterialKey(this.getMRPContextId()), JSON.toJSONString(this.resDataModel.getBom().getTable().getRequireMaterials()));
        return ret;
    }

    @Override
    public void restoreTableDatas(String evtId, String id, String groupKey, List<Object[]> datas, boolean isRequire) {
        this.resDataModel.restoreTableDatas(evtId, id, groupKey, datas, isRequire);
    }

    @Override
    public ExtendDataTable createOrgRelationDatas() {
        HashSet<String> indexs = new HashSet<String>();
        indexs.add(DefaultField.OrgRelationField.FROM_ORG_UNIT.name());
        this.orgRelationDatas = new ExtendDataTable(this, indexs);
        ArrayList<String> cols = new ArrayList<String>();
        cols.add(DefaultField.OrgRelationField.FROM_ORG_UNIT.name());
        cols.add(DefaultField.OrgRelationField.TO_ORG_UNIT.name());
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        this.orgRelationDatas.fill(cols, datas);
        return this.orgRelationDatas;
    }

    @Override
    public ExtendDataTable createMaterialExtDatas() {
        HashSet<String> indexs = new HashSet<String>();
        indexs.add(DefaultField.CommonField.MATERIAL.name());
        indexs.add(DefaultField.MaterialExField.STORAGE_ORG_UNIT.name());
        this.materialExDatas = new ExtendDataTable(this, indexs);
        ArrayList<String> cols = new ArrayList<String>();
        cols.add(DefaultField.CommonField.MATERIAL.name());
        cols.add(DefaultField.MaterialExField.STORAGE_ORG_UNIT.name());
        cols.add(DefaultField.MaterialExField.DISPATCH_ORG_UNIT.name());
        cols.add(DefaultField.MaterialExField.MATERIAL_ATTR.name());
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        this.materialExDatas.fill(cols, datas);
        return this.materialExDatas;
    }

    @Override
    public String[] getMaterialDataById(String id) {
        return this.planInfoModel.getMaterialDataById(id);
    }

    @Override
    public String[] getOrgById(String orgId) {
        return this.cacheDatas.getOrgById(orgId);
    }

    @Override
    public void restore(String mrpContextId) {
        this.mrpContextId = mrpContextId;
        this.initRuntimeEnv();
        this.initWorkCalendars();
        this.createOrgRelationDatas();
        this.createMaterialExtDatas();
        this.restoreBOM();
    }

    @Override
    public void restoreBOM() {
        this.resDataModel.getBom().restoreBOM();
    }

    @Override
    public IMRPCallableConfigurator createCallableConfigurator() {
        return new IMRPCallableConfigurator(){
            private RequestContext bosCtx;

            @Override
            public void restore() {
                RequestContext.set((RequestContext)this.bosCtx);
            }

            @Override
            public void init() {
                this.bosCtx = RequestContext.get();
            }
        };
    }

    @Override
    public String getAdjustEffectSet() {
        return this.planModel.getAdjustEffectSet();
    }

    @Override
    public int saveCalcDetails() {
        return this.runLogModel.saveCalcDetails();
    }

    @Override
    public int saveSimulateDatas() {
        return this.runLogModel.saveCalcDetails("mrp_simulationdetail", "simulate");
    }

    @Override
    public int saveInvCalcDetails() {
        return this.runLogModel.saveCalcDetails("msplan_invlevel_detail", "invdetail");
    }

    @Override
    public String getRunModeName() {
        return this.runLogModel.getRunModeName();
    }

    @Override
    public String getRunMode() {
        return this.runLogModel.getRunMode();
    }

    @Override
    public String getRunLogPlanOrgId() {
        return this.runLogModel.getRunLogPlanOrgId();
    }

    @Override
    public void clearRuntimeEnv() {
    }

    @Override
    public void requirementMerge() {
    }

    @Override
    public Date getPlanDate() {
        return this.runLogModel.getPlanDate();
    }

    @Override
    public Long getPlanTs() {
        return this.runLogModel.getPlanTs();
    }

    @Override
    public String getRunLogPlanOrgName() {
        return this.runLogModel.getRunLogPlanOrgName();
    }

    @Override
    public void loadRequireMaterialExtProps() {
        this.resDataModel.getRequire().loadRequireMaterialExtProps();
    }

    @Override
    public void loadRequireMaterialExtProps(RequireRowData rowData) {
        this.resDataModel.getRequire().loadRequireMaterialExtProps(rowData);
    }

    @Override
    public void loadSupplyMaterialExtProps() {
        this.resDataModel.getSupply().loadSupplyMaterialExtProps();
    }

    @Override
    public void loadBOMMaterialExtProps() {
        this.resDataModel.getBom().loadBOMMaterialExtProps();
    }

    @Override
    public HashMap<Integer, String> getUnit(Object unitId) {
        return this.cacheDatas.getUnit(unitId);
    }

    @Override
    public List<Integer> sortByPriority(SupplymentDataTable table, String orgId, List<Integer> rows, String strategyId) {
        return this.resDataModel.sortByPriority(table, orgId, rows, strategyId);
    }

    @Override
    public List<Integer> sortByPriority(SupplymentDataTable supplyTbl, String orgId, List<Integer> rows, String strategyId, boolean checkCenterWarehouse) {
        return this.resDataModel.sortByPriority(supplyTbl, orgId, rows, strategyId, checkCenterWarehouse);
    }

    @Override
    public int createMaterialTableDatas() {
        HashSet mIds = new HashSet();
        String json = MRPCacheManager.getInst().getData(this, MRPRuntimeConsts.getSelectBillMaterialKey(this.getMRPContextId()));
        if (json != null) {
            mIds = new HashSet(JSON.parseArray((String)json, String.class));
        }
        if ("mrp_cps_runner".equals(this.getRunMode()) || mIds.isEmpty()) {
            return this.planInfoModel.createMaterialTableDatas();
        }
        return mIds.size();
    }

    @Override
    public boolean isMRP() {
        return this.planModel.isMRP();
    }

    @Override
    public boolean isMPS() {
        return this.planModel.isMPS();
    }

    @Override
    public boolean isReorderPoint() {
        return this.planModel.isReorderPoint();
    }

    @Override
    public HashSet<String> getRequirorgs() {
        return this.planModel.getRequirorgs();
    }

    @Override
    public List<RowData[]> createCollaborateSupply(List<RequireRowData> requires) {
        ArrayList<RowData[]> ret = new ArrayList<RowData[]>(requires.size());
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(requires.size());
        HashMap<RequireRowData, Object[]> requireToBill = new HashMap<RequireRowData, Object[]>(requires.size());
        ArrayList<Long> check = new ArrayList<Long>(this.getAllPlanTags());
        if (check.isEmpty()) {
            check.add(0L);
        }
        RequireDataModel requireDataModel = (RequireDataModel)this.getService(RequireDataModel.class);
        PlanScopeModel planScopeModel = (PlanScopeModel)this.getService(PlanScopeModel.class);
        PlanModel planModel = (PlanModel)this.getService(PlanModel.class);
        Boolean isSave = MRPUtil.convert(this.getLocalParams("immediately_save_collaborate_bills"), Boolean.TRUE);
        for (RequireRowData require : requires) {
            BigDecimal qty;
            Long tag = MRPUtil.convert(require.getValue(DefaultField.RequireField.__PLAN_TAG__.getName()), 0L);
            DynamicObject cb = this.orm.newDynamicObject(requireDataModel.getOutputCollaborativeorder());
            Object mId = require.getValue(DefaultField.RequireField.MATERIAL.getName());
            Object val = require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
            if ("1".equals(this.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner mId: %s, prodorgid: %s, prodorgid-class: %s", this.getMRPContextId(), mId, val, val == null ? "null" : val.getClass()));
            }
            Long orgId = MRPUtil.convert(val, 0L);
            String num = MRPUtil.genCollaborateTemplateNum(this, String.valueOf(orgId));
            Long id = this.orm.genLongId(requireDataModel.getOutputCollaborativeorder());
            cb.set("id", (Object)id);
            cb.set("billno", (Object)num);
            cb.set("billstatus", (Object)CollaboratePlanBillStatus.SUBMITED.getValue());
            cb.set("org", require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
            cb.set("supplyorg", require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
            cb.set("baseunit", require.getValue(DefaultField.RequireField.BASEUNIT.getName()));
            cb.set("materiel", mId);
            cb.set("auxproperty", require.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()));
            cb.set("supplyrule", require.getValue(DefaultField.RequireField.SUPPLY_STRATEGY.getName()));
            cb.set("planscope", require.getValue(DefaultField.RequireField.PLANSCOPE.getName()));
            cb.set("inwarorg", require.getValue(DefaultField.RequireField.IN_STORAGE_ORG.getName()));
            cb.set("inwarehouse", require.getValue(DefaultField.RequireField.IN_STORAGE_WAREHOUSE.getName()));
            cb.set("inwarelocation", require.getValue(DefaultField.RequireField.IN_STORAGE_SHIPPING.getName()));
            if (MRPUtil.convert(cb.get("inwarorg"), 0L) <= 0L) {
                cb.set("inwarorg", cb.get("org"));
            }
            if ((qty = MRPUtil.toBigDecimal(require.getValue(DefaultField.RequireField.QTY.getName()))).compareTo(BigDecimal.ZERO) <= 0) continue;
            qty = MRPUtil.calcYield(null, require.getValue(DefaultField.RequireField.BASEUNIT.getName()), qty, this, true);
            require.update(DefaultField.RequireField.QTY.getName(), (Object)qty);
            cb.set("demandqty", (Object)qty);
            cb.set("residualtransferqty", (Object)qty);
            cb.set("transferqty", (Object)BigDecimal.ZERO);
            String supplyOrgId = String.valueOf(require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
            Long[] values = new Long[]{MRPUtil.convert((Object)supplyOrgId, 0L), 0L, 0L};
            Object[] mftDatas = this.cacheDatas.getMftData4OrgAndMaterial(MRPUtil.convert((Object)supplyOrgId, 0L), MRPUtil.convert(mId, 0L));
            Long mftId = MRPUtil.convert(mftDatas[7], 0L);
            if (mftId > 0L) {
                String cacheKey = PlanScopeRelationConst.getRedisPlanScopeRelationKey((String)supplyOrgId, (String)String.valueOf(mId));
                if (planModel.isEnablePlanScope()) {
                    values = planScopeModel.getSupplyOrgAndWareHouse4MaterialMftInfo(mftDatas, values[0], cacheKey);
                } else {
                    values[0] = MRPUtil.convert(mftDatas[0], 0L);
                    values[1] = MRPUtil.convert(mftDatas[1], 0L);
                    values[2] = MRPUtil.convert(mftDatas[2], 0L);
                }
            }
            cb.set("supplyorgunitid", (Object)values[0]);
            cb.set("supplywarehouse", (Object)values[1]);
            cb.set("supplylocation", (Object)values[2]);
            Long date = (Long)require.getValue(DefaultField.RequireField.DATE.getName());
            String requireProductOrgUnitID = String.valueOf(require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
            OrgBasedCalendarModel sOcm = this.dateManager().get(requireProductOrgUnitID, supplyOrgId);
            SupplyStruct ss = this.getPriorityRelations().get(requireProductOrgUnitID);
            int bodtime = ss == null ? 0 : ss.getBodtime();
            date = sOcm.getDate(new Date(date), true, bodtime).getTimeInMillis();
            date = !this.isAllowPast() && date <= this.getPlanDate().getTime() ? Long.valueOf(sOcm.getDate(new Date(), false).getTimeInMillis()) : Long.valueOf(sOcm.getDate(new Date(date), true).getTimeInMillis());
            require.update(DefaultField.RequireField.DATE.getName(), (Object)date);
            cb.set("demanddate", (Object)date);
            cb.set("datasource", (Object)CollaboratePlanBillSource.CALC.getValue());
            cb.set("planprogram", (Object)planModel.getPlanId());
            cb.set("planoperatenum", (Object)this.runLogModel.getNumber());
            cb.set("creator", (Object)RequestContext.get().getCurrUserId());
            cb.set("createtime", (Object)System.currentTimeMillis());
            cb.set("modifier", (Object)RequestContext.get().getCurrUserId());
            cb.set("modifytime", (Object)System.currentTimeMillis());
            cb.set("plantags", (Object)tag);
            cb.set("materialplanid", require.getValue(DefaultField.RequireField.__MATERIALPLAN__.getName()));
            cb.set("configuredcode", require.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName()));
            cb.set("tracknumber", require.getValue(DefaultField.RequireField.TRACKNUMBER.getName()));
            cb.set("project", require.getValue(DefaultField.RequireField.PROJECTNUMBER.getName()));
            if ("mrp_simcolorder".equals(requireDataModel.getOutputCollaborativeorder())) {
                cb.set("billtype", (Object)1452159312150411264L);
            } else {
                cb.set("billtype", (Object)1302008343056875520L);
            }
            cb.set("demandbillentity", require.getValue(DefaultField.RequireField.ORIGIN_BILLENTITY.getName()) != null ? require.getValue(DefaultField.RequireField.ORIGIN_BILLENTITY.getName()) : require.getValue(DefaultField.RequireField.BILL_ENTITY.getName()));
            cb.set("demandbill", require.getValue(DefaultField.RequireField.ORIGIN_BILLNUMBER.getName()) != null ? require.getValue(DefaultField.RequireField.ORIGIN_BILLNUMBER.getName()) : require.getValue(DefaultField.RequireField.BILLNUMBER.getName()));
            cb.set("demandbillid", require.getValue(DefaultField.RequireField.ORIGIN_BILLID.getName()) != null ? require.getValue(DefaultField.RequireField.ORIGIN_BILLID.getName()) : require.getValue(DefaultField.RequireField.BILLID.getName()));
            cb.set("demandseq", require.getValue(DefaultField.RequireField.ORIGIN_BILLENTRYSEQ.getName()) != null ? require.getValue(DefaultField.RequireField.ORIGIN_BILLENTRYSEQ.getName()) : require.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()));
            cb.set("demandbillentryid", require.getValue(DefaultField.RequireField.ORIGIN_BILLENTRYID.getName()) != null ? require.getValue(DefaultField.RequireField.ORIGIN_BILLENTRYID.getName()) : require.getValue(DefaultField.RequireField.BILLENTRYID.getName()));
            if (check.contains(tag)) {
                bills.add(cb);
            }
            requireToBill.put(require, new Object[]{id, num});
            if (bills.size() != 50000) continue;
            if (isSave != null && isSave.booleanValue()) {
                this.orm.save(bills);
            }
            bills.clear();
        }
        if (bills.size() > 0) {
            if (isSave != null && isSave.booleanValue()) {
                this.orm.save(bills);
            }
            bills.clear();
        }
        for (RequireRowData require : requires) {
            Object[] billValue = requireToBill.getOrDefault(require, new Object[2]);
            RowData supply = MRPUtil.createCollaborateSupplyByRequire(this, require, billValue[0], billValue[1]);
            ret.add(new RowData[]{require, supply});
        }
        return ret;
    }

    @Override
    public int savePurForecast() {
        return 0;
    }

    @Override
    public String getRelatedSupplyBillType(int mAttr) {
        return this.planModel.getAttr2BillType().get(mAttr);
    }

    @Override
    public void tearDown() {
        BaseDataServiceHelper.clearCache((DynamicObject)this.runLogModel.getRunLog());
        this.bomDatas().clear();
        MtPlanInfoModel model = (MtPlanInfoModel)this.getService(MtPlanInfoModel.class);
        model.getMaterialPlanInfos().clear();
        this.requireDatas().clear();
        this.supplyDatas().clear();
        HashMap<String, SupplyStruct> relations = this.getPriorityRelations();
        if (relations != null) {
            for (Map.Entry<String, SupplyStruct> e : relations.entrySet()) {
                ArrayList<PrioritySettingDatas> list;
                if (e.getValue() == null || (list = e.getValue().getRequirePrioritys()) == null) continue;
                for (PrioritySettingDatas s : list) {
                    s.getRefTbl().getSrcDatas().getDatas().clear();
                }
            }
        }
    }

    @Override
    public boolean isOnWayTransfer(String orgId) {
        return this.planModel.isOnWayTransfer(orgId);
    }

    @Override
    public MRPCooperateParamStruct getMRPCooperateParamStruct(Long orgId, String materialAttr) {
        return null;
    }

    @Override
    public OORBillResolveStrategy getOORDataResolveStrategy() {
        return this.planModel.getOORDataResolveStrategy();
    }

    public HashMap<String, MRPCooperateParamStruct> getCooperateParams() {
        return this.cooperateParams;
    }

    @Override
    public int saveRuntimeData() {
        return 0;
    }

    @Override
    public void putCustomParams(String key, String value) {
        this.contextParams.put(key, value);
        MRPCacheManager.getInst().putData(this, "USER_PARAMS\u0001" + key, value);
    }

    @Override
    public String getCustomParams(String key) {
        if (!this.contextParams.containsKey(key)) {
            String value = MRPCacheManager.getInst().getData(this, "USER_PARAMS\u0001" + key);
            this.contextParams.put(key, value);
            return value;
        }
        return this.contextParams.get(key);
    }

    @Override
    public boolean isStandardPart() {
        return this.planModel.isStandardPart();
    }

    @Override
    public boolean isSpecialPart() {
        return this.planModel.isSpecialPart();
    }

    @Override
    public boolean isChoosablePart() {
        return this.planModel.isChoosablePart();
    }

    @Override
    public boolean isUnrecongnisePart() {
        return this.planModel.isUnrecongnisePart();
    }

    @Override
    public KDCloudMRPEnv copy() {
        try {
            DynamicObject runLog = this.orm.queryOne("mrp_caculate_log", "id", new QFilter[]{new QFilter("mrpid", "=", (Object)this.mrpContextId)});
            runLog = BusinessDataServiceHelper.loadSingle((Object)runLog.get("id"), (String)"mrp_caculate_log");
            KDCloudMRPEnv ret = new KDCloudMRPEnv(runLog);
            for (Field f : KDCloudMRPEnv.class.getDeclaredFields()) {
                int modifiers = f.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                AccessibleObject[] accessibleObjects = new AccessibleObject[]{f};
                AccessibleObject.setAccessible(accessibleObjects, true);
                f.set(ret, f.get(this));
            }
            ret.calcBalanceDetails = new DataBalanceTable();
            return ret;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("clone KDCloudMRPEnv failed", e);
        }
    }

    @Override
    public int[] getSupplyPrioritys() {
        return this.planModel.getSupplyPrioritys();
    }

    @Override
    public Integer getSupplyPrioritys(String resDataId) {
        return this.planModel.getSupplyPrioritys(resDataId);
    }

    @Override
    public void setCurrentResolveMaterial(String materialId) {
        this.currentMaterialId = materialId;
    }

    @Override
    public String getCurrentResolveMaterial() {
        return this.currentMaterialId;
    }

    @Override
    public void onMasterLost() {
        DynamicObject runlog = this.orm.queryOne("mrp_caculate_log", "id", new QFilter[]{new QFilter("mrpid", "=", (Object)this.mrpContextId)});
        runlog = BusinessDataServiceHelper.loadSingle((Object)runlog.get("id"), (String)"mrp_caculate_log");
        String currentStatus = runlog.getString("calculatestatus");
        if (MRPExecuteStatus.RUNNING.getValue().equals(currentStatus)) {
            KDCloudLogRecorder logRecorder = new KDCloudLogRecorder(this.orm, runlog);
            logRecorder.createStepLog(runlog.getDynamicObjectCollection("entryentity").size() + 1, Tips.getCalcEnd());
            logRecorder.updateStepLog("entryresult", MRPExecuteStatus.ERROR_STOP.getAlias());
            logRecorder.updateStepLog("entrydetailmsg", "MRPCalcMaster lost");
            logRecorder.updateStepLog("entrydetailmsg_tag", "MRPCalcMaster lost");
            logRecorder.updateRunLog("calculatestatus", MRPExecuteStatus.ERROR_STOP.getValue());
            logRecorder.saveStepLog(true);
        }
    }

    @Override
    public Long getDetailId() {
        return this.runLogModel.getDetailId();
    }

    @Override
    public Map<String, Object> getMaterialPlanInfo(String materialId, String orgId) {
        return this.planInfoModel.getMaterialPlanInfo(materialId, orgId);
    }

    @Override
    public Map<String, Object> getMaterialPlanInfo(String materialId, String orgId, Map<String, Object> extendDimVals) {
        return this.planInfoModel.getMaterialPlanInfo(materialId, orgId, extendDimVals);
    }

    @Override
    public void loadSupplyMaterialExtProps(RowData rowData) {
        this.resDataModel.getSupply().loadSupplyMaterialExtProps(rowData);
    }

    @Override
    public Object getPlanDataByParam(String param) {
        return this.planModel.getPlanDataByParam(param);
    }

    @Override
    public List<Long> getAllPlanTags() {
        return this.planModel.getAllPlanTags();
    }

    @Override
    public String[] getPlanTagInfo(String id) {
        return this.cacheDatas.getPlanTagInfo(id);
    }

    @Override
    public Map<Long, List<MergeCycleVo>> getSpecialCycleCache() {
        return this.specialCycleCache;
    }

    @Override
    public Map<String, BigDecimal> getRichQtyMap() {
        return this.richQtyMap;
    }

    @Override
    public Map<Long, List<DataBalanceTable.RSMapping>> getRsMappings() {
        return this.rsMappingMap;
    }

    @Override
    public synchronized FlexFieldDataTable getFlexDataTable() {
        if (this.flexDatas == null) {
            this.flexDatas = new FlexFieldDataTable(this, (Boolean)this.getCfgValue(EnvCfgItem.ENABLE_MATERIAL_EXT_PROPS));
        }
        return this.flexDatas;
    }

    @Override
    public Map<String, List<Map<String, Object>>> getReserveCacheData() {
        return this.reserveCache;
    }

    @Override
    public Map<String, Set<String>> getRemovePlanOrders() {
        return this.removePlanOrders;
    }

    @Override
    public Map<String, Integer> getPo2BomIdx() {
        return this.po2BomIdx;
    }

    @Override
    public void putLocalParam(String key, Object val) {
        this.localCache.put(key, val);
    }

    @Override
    public <T> T getLocalParams(String key) {
        return (T)this.localCache.get(key);
    }

    @Override
    public boolean isSpecialPlan() {
        return this.planModel.isSpecialPlan();
    }

    @Override
    public void setMRPCalcNetDemandPlugin(IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin) {
        this.imrpCalcNetDemandPlugin = imrpCalcNetDemandPlugin;
    }

    @Override
    public IMRPCalcNetDemandPlugin getMRPCalcNetDemandPlugin() {
        return this.imrpCalcNetDemandPlugin;
    }

    @Override
    public Map<String, RequireRowData> getInvPlanKey2Require() {
        return this.invPlanKey2Require;
    }

    @Override
    public Map<String, BigDecimal> getPoNum2InvRequireQty() {
        return this.poNum2RequireQty;
    }

    @Override
    public Map<String, Map<String, BigDecimal>> getSupplyOccupyQty() {
        return this.supplyOccupyQty;
    }

    @Override
    public ArrayBlockingQueue<String> getPoNumQueue(String orgId) {
        int genBatch = this.getGenBatch();
        return this.poNumQueueMap.computeIfAbsent(orgId, k -> new ArrayBlockingQueue(genBatch));
    }

    @Override
    public int getGenBatch() {
        if (this.genBatch == -1) {
            this.genBatch = MRPUtil.convert(this.getCfgValue(EnvCfgItem.GEN_PLAN_ORDER_CODE_RULE_BATCH), 0);
            int instanceQty = MRPUtil.convert(this.getCfgValue(EnvCfgItem.MRP_CONTAINER_INSTANCE_QTY), 0);
            int n = instanceQty = instanceQty <= 0 ? 1 : instanceQty;
            if (this.genBatch > 0) {
                DynamicObject runLog = this.getRunLog();
                QFilter qf1 = new QFilter("runtype", "=", (Object)runLog.getString("runtype"));
                qf1.and("calculatestatus", "=", (Object)"A");
                qf1.and("plangram", "=", (Object)runLog.getLong("plangram"));
                qf1.and("operatmodekey", "=", (Object)runLog.getString("operatmodekey"));
                Long id = 0L;
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"mrp_caculate_log", (String)"id,number", (QFilter[])new QFilter[]{qf1}, (String)"startdate desc", (int)1);){
                    if (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        id = row.getLong("id");
                    }
                }
                if (id > 0L) {
                    RequireDataModel require = (RequireDataModel)this.getService(RequireDataModel.class);
                    String outputType = require.getOutputType();
                    DynamicObject lastRunLog = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mrp_caculate_log");
                    DynamicObjectCollection entryentity = lastRunLog.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entryentity) {
                        String associateForm = entry.getString("associateform");
                        if (!outputType.equals(associateForm)) continue;
                        int entryprocessdata = entry.getInt("entryprocessdata");
                        entryprocessdata = entryprocessdata / instanceQty + (entryprocessdata % instanceQty != 0 ? 1 : 0);
                        this.genBatch = Math.min(this.genBatch, entryprocessdata);
                        break;
                    }
                }
            }
        }
        return this.genBatch;
    }

    public static interface IMaterialPlanInfoApply {
        public Map<String, Object> toMap(Map<String, Object> var1);

        public void apply(HashMap<Integer, Map<String, Object>> var1);
    }
}

