/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.KDCloudCPSEnv;
import kd.mmc.mrp.integrate.KDCloudMRPEnv;
import kd.mmc.mrp.integrate.PLSEnv;
import kd.mmc.mrp.integrate.RESEnv;

public class MRPIntegrateFactory {
    private static final Map<String, Class<? extends IMRPEnvProvider>> envProviders = new HashMap<String, Class<? extends IMRPEnvProvider>>(4);
    private static final Log logger = LogFactory.getLog(MRPIntegrateFactory.class);

    public static IMRPEnvProvider createMRPEnv(DynamicObject runlog) {
        return MRPIntegrateFactory.initEnv(runlog);
    }

    public static IMRPEnvProvider initEnv(DynamicObject runlog) {
        try {
            String runtype = runlog.getString("runtype");
            Class<KDCloudMRPEnv> clazz = envProviders.getOrDefault(runtype, KDCloudMRPEnv.class);
            Constructor<?>[] constructors = clazz.getConstructors();
            Constructor<?> con = null;
            for (Constructor<?> constructor : constructors) {
                if (constructor == null || constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != DynamicObject.class) continue;
                con = constructor;
                break;
            }
            if (con != null) {
                return (IMRPEnvProvider)con.newInstance(runlog);
            }
        }
        catch (Exception e) {
            logger.error("initEnv error", (Throwable)e);
        }
        return new KDCloudMRPEnv(runlog);
    }

    static {
        envProviders.put("A", KDCloudMRPEnv.class);
        envProviders.put("H", RESEnv.class);
        envProviders.put("I", RESEnv.class);
        envProviders.put("P", PLSEnv.class);
        envProviders.put("B", KDCloudCPSEnv.class);
    }
}

