/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.mrp.common.util.DataConversionUtil;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.exception.MRPManuStopException;
import kd.mmc.mrp.exception.PLSWarnException;
import kd.mmc.mrp.framework.IMRPDataFetcher;
import kd.mmc.mrp.framework.IMRPDataSaveResolver;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.consts.PLSErrors;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.mq.DefaultOnResponse;
import kd.mmc.mrp.framework.mq.IMRPEventManager;
import kd.mmc.mrp.framework.mq.MRPMQManager;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.framework.step.IMRPCallableConfigurator;
import kd.mmc.mrp.integrate.AbstractMRPEnv;
import kd.mmc.mrp.integrate.KDCloudLogRecorder;
import kd.mmc.mrp.integrate.KDCloudSysConfigProvider;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.pls.model.AbilityItemCalcResult;
import kd.mmc.mrp.pls.model.Category;
import kd.mmc.mrp.pls.model.DowntimePlan;
import kd.mmc.mrp.pls.model.OrderMaterialMananger;
import kd.mmc.mrp.pls.model.SchedulingScheme;
import kd.mmc.mrp.pls.model.WorkCalendarManager;
import kd.mmc.mrp.pls.model.WorkCenter;
import kd.mmc.mrp.pls.model.WorkCenterManager;
import kd.mmc.mrp.pls.model.WorkShift;
import kd.mmc.mrp.pls.model.WorkShiftManager;
import kd.mmc.mrp.pls.util.QueryUtils;
import org.apache.commons.lang3.StringUtils;

public class PLSEnv
extends AbstractMRPEnv {
    private final ORM orm = ORM.create();
    private static final String ALGO_KEY = "PLSEnv.";
    private static final Log LOG = LogFactory.getLog(PLSEnv.class);
    private final DynamicObject runLog;
    private final String mrpContextId = UUID.randomUUID().toString();
    private final KDCloudLogRecorder logRecorder;
    private final IMRPEventManager mqManager;
    private volatile boolean isShutdown = false;
    private final KDCloudSysConfigProvider sysConfigManager = new KDCloudSysConfigProvider();
    private WorkShiftManager defaultWorkShiftManager;
    private WorkCalendarManager workCalendarManager;
    private WorkCenterManager workCenterManager;
    private OrderMaterialMananger orderMaterialMananger;
    SchedulingScheme schedulingScheme;
    private QFilter[] schemeQFilters;
    private QFilter qFilter;
    private final String runLogNumber;
    private Map<Class<?>, Object> services = new HashMap(8);

    public PLSEnv(DynamicObject runLog) {
        this.runLog = runLog;
        this.runLog.set("mrpid", (Object)this.mrpContextId);
        this.runLog.set("machineid", (Object)MRPRuntimeConsts.NODE_ID);
        this.logRecorder = new KDCloudLogRecorder(this.orm, runLog);
        this.mqManager = new MRPMQManager(this, new DefaultOnResponse(this, this.logRecorder));
        this.runLogNumber = runLog.getString("number");
        this.defaultWorkShiftManager = new WorkShiftManager();
        this.addService(WorkShiftManager.class, this.defaultWorkShiftManager);
        this.workCalendarManager = new WorkCalendarManager();
        this.addService(WorkCalendarManager.class, this.workCalendarManager);
        this.workCenterManager = new WorkCenterManager();
        this.addService(WorkCenterManager.class, this.workCenterManager);
        this.orderMaterialMananger = new OrderMaterialMananger();
        this.addService(OrderMaterialMananger.class, this.orderMaterialMananger);
        this.schedulingScheme = new SchedulingScheme();
        this.addService(SchedulingScheme.class, this.schedulingScheme);
    }

    @Override
    public void replaceService(Object service) {
        Class<?> aClass = service.getClass();
        this.services.put(aClass, service);
        if (service instanceof WorkShiftManager) {
            this.defaultWorkShiftManager = (WorkShiftManager)service;
        } else if (service instanceof WorkCalendarManager) {
            this.workCalendarManager = (WorkCalendarManager)service;
        } else if (service instanceof WorkCenterManager) {
            this.workCenterManager = (WorkCenterManager)service;
        } else if (service instanceof OrderMaterialMananger) {
            this.orderMaterialMananger = (OrderMaterialMananger)service;
        } else if (service instanceof SchedulingScheme) {
            this.schedulingScheme = (SchedulingScheme)service;
        }
    }

    @Override
    public DynamicObject getRunLog() {
        return this.runLog;
    }

    @Override
    public void setFilter(QFilter qFilter) {
        LOG.info(ResManager.loadKDString((String)"\u4e8c\u5f00\u8fc7\u6ee4\u6761\u4ef6: {}", (String)"PLSEnv_16", (String)"mmc-mrp-mservice", (Object[])new Object[0]), (Object)qFilter);
        this.qFilter = qFilter;
    }

    @Override
    public <T> T getService(Class<?> clazz) {
        return (T)this.services.get(clazz);
    }

    @Override
    public void addService(Class<?> clazz, Object service) {
        this.services.put(clazz, service);
    }

    @Override
    public long getPlsSchemeId() {
        return this.schedulingScheme.getSchemeId() == null ? 0L : this.schedulingScheme.getSchemeId();
    }

    @Override
    public String getRunLogNumber() {
        return this.runLogNumber;
    }

    @Override
    public String getPlanOrgId() {
        return null;
    }

    @Override
    public String getPlanId() {
        return this.runLog.getString("plangram");
    }

    @Override
    public <T> T getCfgValue(EnvCfgItem item) {
        return this.sysConfigManager.getCfgValue(item);
    }

    @Override
    public String getMRPContextId() {
        return this.mrpContextId;
    }

    @Override
    public void setShutdown() {
        this.isShutdown = true;
    }

    @Override
    public int initRuntimeEnv() {
        this.loadSysConfiguration();
        long schemeId = this.runLog.getLong("plangram");
        this.schedulingScheme.setSchemeId(Long.valueOf(schemeId));
        String selectFields = "status, enable, cycle, workshift, classsystem, ordermodel, considerPlanDate, acrossDayShift";
        this.schemeQFilters = new QFilter[]{new QFilter("id", "=", (Object)schemeId)};
        try (DataSet dataSet = this.orm.queryDataSet("PLSEnv.getSchemeHead", "mrp_pls_scheme", selectFields, this.schemeQFilters, null, 1);){
            if (dataSet.isEmpty()) {
                throw new MRPBizException(PLSErrors.getSchemeNoExists());
            }
            Row row = dataSet.next();
            String stauts = row.getString("status");
            String enable = row.getString("enable");
            if (!"C".equals(stauts) || !"1".equals(enable)) {
                throw new MRPBizException(PLSErrors.getSchemeNoAudit());
            }
            long orderModelId = row.getLong("ordermodel");
            if (orderModelId == 0L) {
                throw new MRPBizException(PLSErrors.getOrdermodelIsNull());
            }
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)orderModelId)};
            try (DataSet orderModelDataSet = this.orm.queryDataSet("PLSEnv.initRuntimeEnv", "mrp_resourceregister_cf", "status, enable", filters, null, 1);){
                Row orderModelRow = orderModelDataSet.next();
                if (!"C".equals(orderModelRow.getString(0)) || !"1".equals(orderModelRow.getString(1))) {
                    throw new MRPBizException(PLSErrors.getOrdermodelNoAudit());
                }
            }
            this.schedulingScheme.setWorkShiftId(row.getLong("workshift"));
            this.schedulingScheme.setClassSystemId(row.getLong("classsystem"));
            this.schedulingScheme.setCycle(row.getInteger("cycle"));
            this.schedulingScheme.setConsiderPlanDate(row.getBoolean("considerplandate"));
            this.schedulingScheme.setAcrossDayShift(row.getBoolean("acrossdayshift"));
        }
        return 0;
    }

    @Override
    public int initWorkCalendars() {
        LOG.info(ResManager.loadKDString((String)"\u201c\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1\u201d\u6b63\u5728\u521d\u59cb\u5316\u751f\u4ea7\u65e5\u5386\uff0crunLogNumber: {}\u3002", (String)"PLSEnv_17", (String)"mmc-mrp-mservice", (Object[])new Object[0]), (Object)this.runLogNumber);
        CachedDataSet cacheDataSet = null;
        try {
            cacheDataSet = Algo.getCacheDataSet((String)this.getMRPContextId());
        }
        catch (Exception e) {
            return 0;
        }
        List dataSet = cacheDataSet.getList(0, cacheDataSet.getRowCount());
        this.initWorkCalendarManager(dataSet);
        this.verifyWorkCalendar(dataSet);
        LOG.info(ResManager.loadKDString((String)"[\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1]\u521d\u59cb\u5316\u751f\u4ea7\u65e5\u5386\u7ed3\u675f\uff0c{}\uff0crunLogNumber: {}", (String)"PLSEnv_18", (String)"mmc-mrp-mservice", (Object[])new Object[0]), (Object)this.workCalendarManager, (Object)this.runLogNumber);
        return this.workCalendarManager.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrderModelData() {
        Set<Long> sourceIds = this.getResourceIdSet();
        if (sourceIds.isEmpty()) {
            throw new MRPBizException(PLSErrors.getSourceorderNoExists());
        }
        HashSet<Long> productIdList = new HashSet<Long>();
        try (DataSet dataSet = null;){
            String selectFields = "orgentryentity.supplyorg";
            try (DataSet orgDataSet = this.orm.queryDataSet("PLSEnv.getSchemeProductOrg", "mrp_pls_scheme", selectFields, this.schemeQFilters);){
                if (!orgDataSet.isEmpty()) {
                    for (Row row : orgDataSet) {
                        if (row.getLong(0) == 0L) continue;
                        productIdList.add(row.getLong(0));
                    }
                }
            }
            dataSet = this.schedulingScheme.getConsiderPlanDate() != false ? DataConversionUtil.getPlsOrderDataSet(sourceIds, (Set)Sets.newHashSet((Object[])new String[]{"plan_start_date", "plan_finish_date", "order_num", "production_org"}), (boolean)false, productIdList, (QFilter)this.qFilter) : DataConversionUtil.getPlsOrderDataSet(sourceIds, (Set)Sets.newHashSet((Object[])new String[]{"plan_start_date", "order_num", "production_org"}), (boolean)false, productIdList, (QFilter)this.qFilter);
            if (dataSet == null || dataSet.isEmpty()) {
                this.schedulingScheme.setPlsOrderSize(Integer.valueOf(0));
                throw new PLSWarnException(PLSErrors.getSourceorderNoCal());
            }
            dataSet = dataSet.orderBy(new String[]{"plan_start_date", "order_num"});
            CacheHint cacheHint = new CacheHint();
            cacheHint.setCacheId(this.getMRPContextId());
            cacheHint.setTimeout(2L, TimeUnit.HOURS);
            CachedDataSet plsOrderDataSet = dataSet.cache(cacheHint);
            int plsOrderSize = plsOrderDataSet.getRowCount();
            this.schedulingScheme.setPlsOrderSize(Integer.valueOf(plsOrderSize));
            int n = plsOrderSize;
            return n;
        }
    }

    @Override
    public int initSchemeModel() {
        int dataAmount = 0;
        dataAmount += this.initWorkShiftManager();
        this.verifyHasWorkShift();
        dataAmount += this.initWorkCenterManager();
        String selectFields = "matcategoryentry.category category, matcategoryentry.materialgroup materialgroup_id, matcategoryentry.material material_id, matcategoryentry.material.masterid masterid, matcategoryentry.createorg_1 createorg_1_id, matcategoryentry.workcentersubentry.workcenter workcenter_id, matcategoryentry.workcentersubentry.priority priority";
        String orderBy = "matcategoryentry.workcentersubentry.priority desc";
        HashSet groupIdSet = new HashSet();
        StringBuilder sb = new StringBuilder(50);
        try (DataSet dataSet = this.orm.queryDataSet("PLSEnv.getMidAndWorkCenter", "mrp_pls_scheme", selectFields, this.schemeQFilters, orderBy);){
            for (Row row : dataSet) {
                if (row.getInteger("priority") == 0) continue;
                this.orderMaterialMananger.init(row, this.workCenterManager);
                this.workCenterManager.initMaterial(groupIdSet, row, sb);
            }
        }
        this.workCenterManager.initMaterialGroup(groupIdSet);
        this.verifyHasWorkCenter();
        return dataAmount += this.orderMaterialMananger.size();
    }

    private void verifyHasWorkShift() {
        Map workShiftMap = this.defaultWorkShiftManager.getAll();
        if (workShiftMap.size() == 0) {
            throw new MRPBizException(PLSErrors.getNoWorkshift());
        }
    }

    @Override
    public int saveCalcDetails() {
        return 0;
    }

    @Override
    public void testEnvStatus() {
        if (this.isShutdown()) {
            throw new MRPManuStopException();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public void runTask(MRPEvent event) {
        this.mqManager.publishCalcEvent(event);
    }

    @Override
    public void wait4Response() {
        this.mqManager.wait4Response();
    }

    @Override
    public IMRPEventManager getMQManager() {
        return this.mqManager;
    }

    @Override
    public IMRPDataSaveResolver createMappingSaver() {
        return null;
    }

    @Override
    public IMRPDataFetcher createDataFetcher() {
        return null;
    }

    @Override
    public IMRPCallableConfigurator createCallableConfigurator() {
        return new IMRPCallableConfigurator(){
            private RequestContext bosCtx;

            @Override
            public void restore() {
                RequestContext.set((RequestContext)this.bosCtx);
            }

            @Override
            public void init() {
                this.bosCtx = RequestContext.get();
            }
        };
    }

    @Override
    public IMRPExecuteLogRecorder createLogRecorder() {
        return this.logRecorder;
    }

    @Override
    public String getRunMode() {
        return this.runLog.getString("operatmodekey");
    }

    @Override
    public String getRunModeName() {
        return this.runLog.getString("operatmode");
    }

    @Override
    public String getRunLogPlanOrgId() {
        return this.runLog.getString("createorg_id");
    }

    @Override
    public void clearRuntimeEnv() {
        this.defaultWorkShiftManager = null;
        this.workCalendarManager = null;
        this.workCenterManager = null;
        this.orderMaterialMananger = null;
    }

    @Override
    public Date getPlanDate() {
        Date planDate = this.runLog.getDate("plandate");
        return planDate;
    }

    @Override
    public Long getPlanTs() {
        Date startDate = this.runLog.getDate("startdate");
        Date planDate = this.getPlanDate();
        return (startDate.getTime() - planDate.getTime()) / 1000L;
    }

    @Override
    public String getRunLogPlanOrgName() {
        return null;
    }

    @Override
    public void tearDown() {
        BaseDataServiceHelper.clearCache((DynamicObject)this.runLog);
    }

    @Override
    public void onMasterLost() {
        DynamicObject runlog = this.orm.queryOne("mrp_caculate_log", "id", new QFilter[]{new QFilter("mrpid", "=", (Object)this.mrpContextId)});
        runlog = BusinessDataServiceHelper.loadSingle((Object)runlog.get("id"), (String)"mrp_caculate_log");
        String currentStatus = runlog.getString("calculatestatus");
        if (MRPExecuteStatus.RUNNING.getValue().equals(currentStatus)) {
            KDCloudLogRecorder logRecorder = new KDCloudLogRecorder(this.orm, runlog);
            logRecorder.createStepLog(runlog.getDynamicObjectCollection("entryentity").size() + 1, Tips.getCalcEnd());
            logRecorder.updateStepLog("entryresult", MRPExecuteStatus.ERROR_STOP.getAlias());
            logRecorder.updateStepLog("entrydetailmsg", "MRPCalcMaster lost");
            logRecorder.updateStepLog("entrydetailmsg_tag", "MRPCalcMaster lost");
            logRecorder.updateRunLog("calculatestatus", MRPExecuteStatus.ERROR_STOP.getValue());
            logRecorder.saveStepLog(true);
        }
    }

    private void loadSysConfiguration() {
        this.sysConfigManager.load();
    }

    @Override
    public int getCycle() {
        return this.schedulingScheme.getCycle();
    }

    private int initWorkCenterManager() {
        Set<Long> workCenterIds = this.initWorkCenterCalcResult();
        this.initWorkCenterDowntimePlan(workCenterIds);
        return this.workCenterManager.size();
    }

    private void initWorkCenterDowntimePlan(Set<Long> workCenterIds) {
        Map<Long, Set<Long>> resourceId2WorkCenterIds = this.queryWorkCenter(workCenterIds);
        Map<Long, Set<Long>> equipmentId2ResourceIds = this.queryResource(resourceId2WorkCenterIds);
        this.queryEquipment(resourceId2WorkCenterIds, equipmentId2ResourceIds);
    }

    private Set<Long> initWorkCenterCalcResult() {
        String selectFields = "workcenterentry.workcenter_number workcenter_number_id, workcenterentry.workcenter_number.workshop workshop, workcenterentry.calcresultsubentry.ispartincalc_1 ispartincalc_1, workcenterentry.calcresultsubentry.materialgroup_2 materialgroup_2_id, workcenterentry.calcresultsubentry.material_2 material_2_id, workcenterentry.calcresultsubentry.workstype workstype, workcenterentry.calcresultsubentry.workunits workunits, workcenterentry.calcresultsubentry.precision precision, workcenterentry.calcresultsubentry.completeresult completeresult, workcenterentry.calcresultsubentry.category_2 category_2";
        try (DataSet dataSet = this.orm.queryDataSet("PLSEnv.getCalcResult", "mrp_pls_scheme", selectFields, this.schemeQFilters, null);){
            for (Row row : dataSet) {
                long workCenterId = row.getLong("workcenter_number_id");
                long workShopId = row.getLong("workshop");
                WorkCenter workCenter = this.workCenterManager.computeIfAbsent(Long.valueOf(workCenterId), k -> new WorkCenter(workCenterId, workShopId));
                if (!row.getBoolean("ispartincalc_1").booleanValue()) continue;
                long key = Category.MATERIAL.getValue().equals(row.getString("category_2")) ? row.getLong("material_2_id") : row.getLong("materialgroup_2_id");
                workCenter.put(Long.valueOf(key), new AbilityItemCalcResult(row));
            }
        }
        return this.workCenterManager.getId2WorkCenter().keySet();
    }

    private void queryEquipment(Map<Long, Set<Long>> resourceId2WorkCenterIds, Map<Long, Set<Long>> equipmentId2ResourceIds) {
        LOG.info(ResManager.loadKDString((String)"[\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1]\u67e5\u8be2\u8bbe\u5907\u8d44\u6e90\uff0cequipmentId2ResourceIds: {}\uff0crunLogNumber: {}", (String)"PLSEnv_19", (String)"mmc-mrp-mservice", (Object[])new Object[0]), equipmentId2ResourceIds.keySet(), (Object)this.runLogNumber);
        String selectFields = "id, entryentity.begintime, entryentity.endtime";
        QFilter[] filters = this.createCommonFilters(3);
        filters[0] = new QFilter("id", "in", equipmentId2ResourceIds.keySet());
        try (DataSet dataSet = this.orm.queryDataSet("PLSEnv.queryEquipment", "mpdm_equipment", selectFields, filters, "entryentity.begintime asc");){
            for (Row row : dataSet) {
                Set resourceIds = equipmentId2ResourceIds.getOrDefault(row.getLong(0), Collections.emptySet());
                for (Long resourceId : resourceIds) {
                    Set workCenterIds = resourceId2WorkCenterIds.getOrDefault(resourceId, Collections.emptySet());
                    for (Long workCenterId : workCenterIds) {
                        WorkCenter workCenter = this.workCenterManager.getWorkCenter(workCenterId);
                        if (row.getDate(1) == null || row.getDate(2) == null) continue;
                        workCenter.addDowntimePlan(new DowntimePlan(row.getDate(1), row.getDate(2)));
                    }
                }
            }
        }
        LOG.info(ResManager.loadKDString((String)"[\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1]\u67e5\u8be2\u8bbe\u5907\u8d44\u6e90\u7ed3\u675f\uff0cworkCenters: {}\uff0crunLogNumber: {}", (String)"PLSEnv_20", (String)"mmc-mrp-mservice", (Object[])new Object[0]), this.workCenterManager.getId2WorkCenter().values(), (Object)this.runLogNumber);
    }

    private Map<Long, Set<Long>> queryResource(Map<Long, Set<Long>> resourceId2WorkCenterIds) {
        LOG.info(ResManager.loadKDString((String)"[\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1]\u67e5\u8be2\u8d44\u6e90\u7ef4\u62a4\uff0cresourceIds: {}\uff0crunLogNumber: {}", (String)"PLSEnv_21", (String)"mmc-mrp-mservice", (Object[])new Object[0]), resourceId2WorkCenterIds.keySet(), (Object)this.runLogNumber);
        HashMap<Long, Set<Long>> equipmentId2ResourceIds = new HashMap<Long, Set<Long>>(16);
        HashSet<Long> resourceIdSet = new HashSet<Long>(16);
        String selectFields = "id, resourcesentryentity.itemclassvalue";
        QFilter[] filters = this.createCommonFilters(4);
        filters[0] = new QFilter("id", "in", resourceId2WorkCenterIds.keySet());
        filters[1] = new QFilter("resourcesentryentity.itemclasstype", "=", (Object)"mpdm_equipment");
        try (DataSet dataSet = this.orm.queryDataSet("PLSEnv.queryResource", "mpdm_resources", selectFields, filters, "resourcesentryentity.seq asc");){
            for (Row row : dataSet) {
                Long resourceId = row.getLong(0);
                if (!resourceIdSet.add(resourceId)) continue;
                Set set = equipmentId2ResourceIds.computeIfAbsent(row.getLong(1), k -> new HashSet());
                set.add(resourceId);
            }
        }
        LOG.info(ResManager.loadKDString((String)"[\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1]\u67e5\u8be2\u8d44\u6e90\u7ef4\u62a4\u7ed3\u675f\uff0cequipmentId2ResourceIds: {}\uff0crunLogNumber: {}", (String)"PLSEnv_22", (String)"mmc-mrp-mservice", (Object[])new Object[0]), equipmentId2ResourceIds, (Object)this.runLogNumber);
        return equipmentId2ResourceIds;
    }

    private Map<Long, Set<Long>> queryWorkCenter(Set<Long> workCenterIds) {
        LOG.info(ResManager.loadKDString((String)"[\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1]\u67e5\u8be2\u5de5\u4f5c\u4e2d\u5fc3\uff0cworkCenterIds: {}\uff0crunLogNumber: {}", (String)"PLSEnv_23", (String)"mmc-mrp-mservice", (Object[])new Object[0]), workCenterIds, (Object)this.runLogNumber);
        HashMap<Long, Set<Long>> resourceId2WorkCenterIds = new HashMap<Long, Set<Long>>(16);
        String selectFields = "id, entryresouce.resource, entryresouce.seq";
        QFilter[] filters = this.createCommonFilters(4);
        filters[0] = new QFilter("id", "in", workCenterIds);
        filters[1] = new QFilter("entryresouce.seq", "=", (Object)1);
        try (DataSet dataSet = this.orm.queryDataSet("PLSEnv.queryWorkCenter", "mpdm_workcentre", selectFields, filters);){
            for (Row row : dataSet) {
                Set set = resourceId2WorkCenterIds.computeIfAbsent(row.getLong(1), k -> new HashSet());
                set.add(row.getLong(0));
            }
        }
        LOG.info(ResManager.loadKDString((String)"[\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1]\u67e5\u8be2\u5de5\u4f5c\u4e2d\u5fc3\u7ed3\u675f\uff0cworkCenterIds: {}\uff0crunLogNumber: {}", (String)"PLSEnv_24", (String)"mmc-mrp-mservice", (Object[])new Object[0]), resourceId2WorkCenterIds, (Object)this.runLogNumber);
        return resourceId2WorkCenterIds;
    }

    private QFilter[] createCommonFilters(int length) {
        QFilter[] filters = new QFilter[length];
        filters[length - 2] = new QFilter("status", "=", (Object)"C");
        filters[length - 1] = new QFilter("enable", "=", (Object)"1");
        return filters;
    }

    private int initWorkShiftManager() {
        QFilter[] filters;
        String selectFields;
        LOG.info(ResManager.loadKDString((String)"[\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1]\u521d\u59cb\u5316\u5de5\u4f5c\u73ed\u6b21\uff0cworkShiftId: {}\uff0cclassSystemId: {}\uff0crunLogNumber: {}", (String)"PLSEnv_25", (String)"mmc-mrp-mservice", (Object[])new Object[0]), new Object[]{this.schedulingScheme.getWorkShiftId(), this.schedulingScheme.getClassSystemId(), this.runLogNumber});
        ArrayList<Long> workShiftIdList = new ArrayList<Long>();
        if (this.schedulingScheme.getClassSystemId() != 0L) {
            selectFields = "entryentity.workshift";
            filters = this.createCommonFilters(3);
            filters[0] = new QFilter("id", "in", (Object)this.schedulingScheme.getClassSystemId());
            try (DataSet dataSet = this.orm.queryDataSet("PLSEnv.queryWorkShift", "mpdm_classsystem", selectFields, filters);){
                for (Row row : dataSet) {
                    workShiftIdList.add(row.getLong(0));
                }
            }
        } else {
            workShiftIdList.add(this.schedulingScheme.getWorkShiftId());
        }
        selectFields = "id,entryentity.workstarttime, entryentity.workendtime, entryentity.iscrossday";
        filters = this.createCommonFilters(3);
        filters[0] = new QFilter("id", "in", workShiftIdList);
        String orderBy = "entryentity.workstarttime asc";
        int count = 0;
        try (DataSet dataSet = this.orm.queryDataSet("PLSEnv.initWorkShift", "mpdm_workshifts", selectFields, filters, orderBy);){
            for (Row row : dataSet) {
                this.defaultWorkShiftManager.put(Integer.valueOf(count++), new WorkShift(row.getLong(0), row.getLong(1), row.getLong(2), row.getBoolean(3).booleanValue(), true));
            }
        }
        selectFields = "workcenterentry.workcenter_number workcenter_number_id,workcenterentry.workshiftentry.iscal iscal, workcenterentry.workshiftentry.sub_workshift sub_workshift, workcenterentry.workshiftentry.workstarttime workstarttime, workcenterentry.workshiftentry.workendtime workendtime, workcenterentry.workshiftentry.worktime worktime, workcenterentry.workshiftentry.iscrossday iscrossday";
        orderBy = "workcenterentry.workcenter_number,workcenterentry.workshiftentry.workstarttime asc";
        dataSet = this.orm.queryDataSet("PLSEnv.getWorkShiftEntry", "mrp_pls_scheme", selectFields, this.schemeQFilters, orderBy);
        var7_10 = null;
        try {
            count = 0;
            for (Row row : dataSet) {
                long workCenterId = row.getLong("workcenter_number_id");
                boolean isJoinCal = row.getBoolean("iscal");
                WorkShiftManager workShiftManager = this.workCenterManager.getWorkShift(Long.valueOf(workCenterId));
                if (workShiftManager == null) {
                    workShiftManager = new WorkShiftManager();
                }
                WorkShift workShiftInfo = new WorkShift(row.getLong("sub_workshift"), row.getLong("workstarttime"), row.getLong("workendtime"), row.getBoolean("iscrossday").booleanValue(), isJoinCal);
                workShiftManager.put(Integer.valueOf(count++), workShiftInfo);
                this.workCenterManager.putWorkShift(Long.valueOf(workCenterId), workShiftManager);
            }
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var7_10 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return count;
    }

    private void verifyWorkCalendar(List<Row> rows) {
        StringBuilder sb = new StringBuilder(40);
        ArrayList<String> errorOrders = new ArrayList<String>(10);
        block0: for (Row plsOrder : rows) {
            Long orderModelKey = this.getOrderModelKey(sb, plsOrder);
            List workCenters = this.orderMaterialMananger.get(orderModelKey);
            for (WorkCenter workCenter : workCenters) {
                List workCenterWorkDates = this.workCalendarManager.getWorkCenterWorkDates(Long.valueOf(workCenter.getId()));
                if (!CollectionUtils.isEmpty((Collection)workCenterWorkDates)) continue;
                errorOrders.add(plsOrder.getString("plan_order_billno"));
                continue block0;
            }
        }
        if (!errorOrders.isEmpty()) {
            LOG.info(ResManager.loadKDString((String)"\u4ee5\u4e0b\u8ba2\u5355\u672a\u5339\u914d\u5230\u751f\u4ea7\u65e5\u5386\uff1a", (String)"PLSEnv_26", (String)"mmc-mrp-mservice", (Object[])new Object[0]) + StringUtils.join(errorOrders, (String)","));
            throw new MRPBizException(PLSErrors.getNoWorkCalendar());
        }
    }

    private void verifyHasWorkCenter() {
        int plsOrderSize = this.schedulingScheme.getPlsOrderSize();
        if (plsOrderSize != 0) {
            StringBuilder sb = new StringBuilder(40);
            ArrayList<Row> errorOrder = new ArrayList<Row>();
            CachedDataSet plsOrderDataSet = null;
            try {
                plsOrderDataSet = Algo.getCacheDataSet((String)this.getMRPContextId());
            }
            catch (Exception e) {
                return;
            }
            List plsOrders = plsOrderDataSet.getList(0, plsOrderSize);
            int length = plsOrderSize - 1;
            for (int i = 0; i <= length; ++i) {
                Row plsOrder = (Row)plsOrders.get(i);
                Long orderModelKey = this.getOrderModelKey(sb, plsOrder);
                List workCenters = this.orderMaterialMananger.get(orderModelKey);
                if (!workCenters.isEmpty()) continue;
                errorOrder.add(plsOrder);
            }
            if (errorOrder.size() > 0) {
                StringBuilder errorMsg = new StringBuilder();
                Set collect = errorOrder.stream().map(row -> row.getLong("materiel_code")).collect(Collectors.toSet());
                List valuesForDouble = QueryUtils.getPropertyValuesForDouble((String)"bd_material", collect, (String)"id,number");
                int errorOrderSize = errorOrder.size() - 1;
                for (int i = 0; i <= errorOrderSize; ++i) {
                    if (errorMsg.length() > 1000) {
                        errorMsg.append("...");
                        break;
                    }
                    Row plsOrder = (Row)errorOrder.get(i);
                    for (Tuple objectObjectTuple : valuesForDouble) {
                        if (!plsOrder.getLong("materiel_code").equals(objectObjectTuple.item1)) continue;
                        errorMsg.append(plsOrder.getString("plan_order_billno")).append(ResManager.loadKDString((String)"(\u7269\u6599\u7f16\u7801\uff1a", (String)"PLSEnv_31", (String)"mmc-mrp-mservice", (Object[])new Object[0])).append(objectObjectTuple.item2).append(')');
                        break;
                    }
                    if (i == errorOrderSize) break;
                    errorMsg.append(',');
                }
                throw new MRPBizException(PLSErrors.getNoSetWorkcent(), errorMsg);
            }
        }
    }

    private Map<Long, Long> queryWorkCenterCalendar(Set<Long> workCenterIds) {
        LOG.info(ResManager.loadKDString((String)"[\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1]\u67e5\u8be2\u5de5\u4f5c\u4e2d\u5fc3\u751f\u4ea7\u65e5\u5386\uff0cworkCenterIds: {}\uff0crunLogNumber: {}", (String)"PLSEnv_27", (String)"mmc-mrp-mservice", (Object[])new Object[0]), workCenterIds, (Object)this.runLogNumber);
        HashMap<Long, Long> calendarIdWorkCenterIds = new HashMap<Long, Long>(16);
        String selectFields = "id, calendar";
        QFilter[] filters = this.createCommonFilters(3);
        filters[0] = new QFilter("id", "in", workCenterIds);
        try (DataSet dataSet = this.orm.queryDataSet("PLSEnv.queryWorkCenter", "mpdm_workcentre", selectFields, filters);){
            for (Row row : dataSet) {
                if (row.getLong(1) == 0L) continue;
                calendarIdWorkCenterIds.put(row.getLong(0), row.getLong(1));
            }
        }
        LOG.info(ResManager.loadKDString((String)"[\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1]\u67e5\u8be2\u5de5\u4f5c\u4e2d\u5fc3\u751f\u4ea7\u65e5\u5386\u7ed3\u675f\uff0ccalendarIdWorkCenterIds: {}\uff0crunLogNumber: {}", (String)"PLSEnv_28", (String)"mmc-mrp-mservice", (Object[])new Object[0]), calendarIdWorkCenterIds, (Object)this.runLogNumber);
        return calendarIdWorkCenterIds;
    }

    private Long getOrderModelKey(StringBuilder orderSb, Row plsOrder) {
        Long materielId = plsOrder.getLong("materiel_code");
        Long productionOrgId = plsOrder.getLong("production_org");
        orderSb.setLength(0);
        orderSb.append(materielId).append('_').append(productionOrgId);
        String midAndProdOrgId = orderSb.toString();
        return this.orderMaterialMananger.getOrderModelKey(this.workCenterManager, midAndProdOrgId, materielId.longValue());
    }

    private void initWorkCalendarManager(List<Row> rows) {
        String orderBy = "dateentry.workdate asc";
        int top = this.getCycle();
        String algoKey = "PLSEnv.initWorkCalendars";
        String selectFields = "dateentry.workdate";
        Date planDate = this.getPlanDate();
        long planTs = this.getPlanTs();
        String qcp = ">";
        for (Map.Entry workShiftManagerEntry : this.workCenterManager.getAllWorkShift().entrySet()) {
            WorkShiftManager workShiftManager = (WorkShiftManager)workShiftManagerEntry.getValue();
            if (!workShiftManager.isCalcFirstDay(this.schedulingScheme.getAcrossDayShift().booleanValue(), Long.valueOf(planTs), planDate)) continue;
            qcp = ">=";
        }
        this.defaultWorkShiftManager.isCalcFirstDay(this.schedulingScheme.getAcrossDayShift().booleanValue(), Long.valueOf(planTs), planDate);
        LOG.info(ResManager.loadKDString((String)"[\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1]\u521d\u59cb\u5316\u5de5\u4f5c\u73ed\u6b21\u7ed3\u675f\uff0cworkShiftManagerMap: {}\uff0crunLogNumber: {}", (String)"PLSEnv_29", (String)"mmc-mrp-mservice", (Object[])new Object[0]), (Object)this.workCenterManager.getAllWorkShift().toString(), (Object)this.runLogNumber);
        LOG.info(ResManager.loadKDString((String)"[\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1]\u521d\u59cb\u5316\u5de5\u4f5c\u73ed\u6b21\u7ed3\u675f\uff0cdefaultWorkShiftManager: {}\uff0crunLogNumber: {}", (String)"PLSEnv_30", (String)"mmc-mrp-mservice", (Object[])new Object[0]), (Object)this.defaultWorkShiftManager.toString(), (Object)this.runLogNumber);
        QFilter[] worcentfilters = this.createCommonFilters(5);
        Set<Long> workCenterIds = this.workCenterManager.getId2WorkCenter().keySet();
        if (!workCenterIds.isEmpty()) {
            Map<Long, Long> longLongMap = this.queryWorkCenterCalendar(workCenterIds);
            for (Map.Entry<Long, Long> longLongEntry : longLongMap.entrySet()) {
                worcentfilters[0] = new QFilter("id", "=", (Object)longLongEntry.getValue());
                worcentfilters[1] = new QFilter("dateentry.workdate", qcp, (Object)planDate);
                worcentfilters[2] = new QFilter("dateentry.datetype", "=", (Object)"1");
                DataSet dataSet = this.orm.queryDataSet(algoKey, "mpdm_calendar", selectFields, worcentfilters, orderBy, top);
                Throwable throwable = null;
                try {
                    if (!dataSet.hasNext()) continue;
                    ArrayList workDays = Lists.newArrayListWithExpectedSize((int)top);
                    for (Row row2 : dataSet) {
                        workDays.add(row2.getDate(0));
                    }
                    this.workCalendarManager.putWorkCenter(longLongEntry.getKey(), (List)workDays);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataSet == null) continue;
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dataSet.close();
                }
            }
        }
        QFilter[] filters = this.createCommonFilters(6);
        filters[1] = new QFilter("isfault", "=", (Object)"1");
        filters[2] = new QFilter("dateentry.workdate", qcp, (Object)planDate);
        filters[3] = new QFilter("dateentry.datetype", "=", (Object)"1");
        HashSet<Long> prodOrgIds = new HashSet<Long>(16);
        for (Row row3 : rows) {
            prodOrgIds.add(row3.getLong("production_org"));
        }
        for (Long prodOrgId : prodOrgIds) {
            filters[0] = new QFilter("createorg", "=", (Object)prodOrgId);
            DataSet dataSet = this.orm.queryDataSet(algoKey, "mpdm_calendar", selectFields, filters, orderBy, top);
            Throwable throwable = null;
            try {
                if (!dataSet.hasNext()) continue;
                ArrayList workDays = Lists.newArrayListWithExpectedSize((int)top);
                for (Row row4 : dataSet) {
                    workDays.add(row4.getDate(0));
                }
                this.workCalendarManager.putProdOrg(prodOrgId, (List)workDays);
                rows.removeIf(row -> prodOrgId.equals(row.getLong("production_org")));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
    }

    private Set<Long> getResourceIdSet() {
        String selectFields = "datasourceentry.ispartincalc, datasourceentry.datasoure";
        try (DataSet dataSet = this.orm.queryDataSet("PLSEnv.getSourceIds", "mrp_pls_scheme", selectFields, this.schemeQFilters, null);){
            if (dataSet.isEmpty()) {
                Set<Long> set = Collections.emptySet();
                return set;
            }
            HashSet<Long> sourceIds = new HashSet<Long>();
            for (Row row : dataSet) {
                if (!row.getBoolean(0).booleanValue()) continue;
                sourceIds.add(row.getLong(1));
            }
            HashSet<Long> hashSet = sourceIds;
            return hashSet;
        }
    }
}

