/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.common.util.SerializableUtils;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.mq.event.MRPDataFetchEvent4BOM;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.ResDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.struct.ReplaceStruct;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;
import kd.mmc.mrp.model.wrapper.FieldMapping;

public class BomDataModel
extends ResDataModel {
    private static Log logger = LogFactory.getLog(BomDataModel.class);
    private String mrpContextId;
    private long resRegId;
    private DynamicObject bomModel;
    private BOMStructDataTable bomDatas;
    private List<FieldMapping> r2b;
    private Set<String> bomFields;
    private boolean isFake;
    private boolean isBOMInitialized = false;

    public BomDataModel(CalEnv env) {
        super(env);
    }

    public BomDataModel(long resRegId, List<FieldMapping> r2b, CalEnv env) {
        super(env);
        this.resRegId = resRegId;
        this.isFake = resRegId == 0L;
        this.r2b = r2b;
        this.mrpContextId = env.getMRPContextId();
        this.init();
        this.initTableCols();
        env.addService(BomDataModel.class, this);
    }

    private void init() {
        if (!this.isFake) {
            this.bomModel = BusinessDataServiceHelper.loadSingle((Object)this.resRegId, (String)"mrp_resourceregister_cf");
            this.bomFields = this.buildFields(this.bomModel);
        }
    }

    @Override
    public MRPEvent getEvent() {
        MRPDataFetchEvent4BOM event = new MRPDataFetchEvent4BOM();
        event.setMrpContextId(this.mrpContextId);
        return event;
    }

    public boolean isFake() {
        return this.isFake;
    }

    @Override
    public String getCacheKey() {
        return "BOM_MODELS";
    }

    @Override
    public DynamicObject getModel() {
        return this.bomModel;
    }

    @Override
    public BOMStructDataTable getTable() {
        return this.bomDatas;
    }

    @Override
    public Set<String> getFields() {
        return this.bomFields;
    }

    private void initTableCols() {
        HashSet<String> indexCols = new HashSet<String>();
        HashSet<String> llcCols = new HashSet<String>();
        if (this.r2b != null) {
            for (FieldMapping r : this.r2b) {
                indexCols.add(r.getTo());
                if (r.getFrom().equalsIgnoreCase(DefaultField.RequireField.MATERIAL.getName())) continue;
                llcCols.add(r.getTo());
            }
        }
        indexCols.add(DefaultField.BOMField.BOMID.getName());
        indexCols.add(DefaultField.BOMField.MATERIAL.getName());
        indexCols.add(DefaultField.BOMField.CHILDMATERIAL.getName());
        indexCols.add(DefaultField.BOMField.ENTRYID.getName());
        this.bomDatas = new BOMStructDataTable(this.env, indexCols, llcCols);
        if (!this.isFake) {
            Iterator<String> its = this.bomFields.iterator();
            int index = 0;
            while (its.hasNext()) {
                this.bomDatas.getColIdx().put(its.next().toUpperCase(), index++);
            }
        }
        int size = this.bomDatas.getColIdx().size();
        this.bomDatas.getColIdx().put(DefaultField.CommonField.__MODEL_NUMBER__.name(), size++);
        this.bomDatas.getColIdx().put(DefaultField.CommonField.__MODEL_ID__.name(), size++);
        this.bomDatas.getColIdx().put(DefaultField.BOMField.__METRICS_KEY__.name(), size++);
        this.bomDatas.getColIdx().put(DefaultField.BOMField.__BILL_ENTITY__.getName(), size++);
        this.bomDatas.getColIdx().put(DefaultField.BOMField.__SUPER_BOMID__.getName(), size++);
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.WASTAGERATE.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.WASTAGERATE.getName(), size++);
        }
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.WASTAGERATEFORMULA.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.WASTAGERATEFORMULA.getName(), size++);
        }
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.CTRLSTRATEGY.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.CTRLSTRATEGY.getName(), size++);
        }
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.ISPASSREQ.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.ISPASSREQ.getName(), size++);
        }
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.ISJUMP.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.ISJUMP.getName(), size++);
        }
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.COPTYPE.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.COPTYPE.getName(), size++);
        }
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.COPOPERATION.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.COPOPERATION.getName(), size++);
        }
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.ISCOPDATA.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.ISCOPDATA.getName(), size++);
        }
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.ENTRYMATERIALFLEXPROP.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.ENTRYMATERIALFLEXPROP.getName(), size++);
        }
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.REMARK.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.REMARK.getName(), size++);
        }
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.MATERIALFLEXPROPS.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.MATERIALFLEXPROPS.getName(), size++);
        }
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.ISSUPERBOM.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.ISSUPERBOM.getName(), size++);
        }
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.PURPOSE.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.PURPOSE.getName(), size++);
        }
        if (!this.bomDatas.getColIdx().containsKey(DefaultField.BOMField.__IS_KEY_MATERIAL__.getName())) {
            this.bomDatas.getColIdx().put(DefaultField.BOMField.__IS_KEY_MATERIAL__.getName(), size++);
        }
        this.bomDatas.getColIdx().put(DefaultField.BOMField.__EXIST_KEYPART__.getName(), size++);
        this.bomDatas.getNotNullableColMap().put(DefaultField.BOMField.MATERIAL.getName(), Long.class);
        this.bomDatas.getNotNullableColMap().put(DefaultField.BOMField.PRODUCTORGUNIT.getName(), Long.class);
        this.bomDatas.getNotNullableColMap().put(DefaultField.BOMField.CHILDMATERIAL.getName(), Long.class);
        this.bomDatas.getNotNullableColMap().put(DefaultField.BOMField.CHILDQTY.getName(), BigDecimal.class);
        this.bomDatas.getNotNullableColMap().put(DefaultField.BOMField.CHILDUNIT.getName(), Long.class);
        this.bomDatas.getNotNullableColMap().put(DefaultField.BOMField.BOMNUMBER.getName(), String.class);
        this.bomDatas.getNotNullableColMap().put(DefaultField.BOMField.BOMID.getName(), Long.class);
        this.bomDatas.getNotNullableColMap().put(DefaultField.BOMField.ENTRYID.getName(), Long.class);
        this.bomDatas.getNotNullableColMap().put(DefaultField.BOMField.CHILDTYPE.getName(), String.class);
        this.bomDatas.getNotNullableColMap().put(DefaultField.BOMField.CHILDAMTTYPE.getName(), String.class);
        this.bomDatas.getNotNullableColMap().put(DefaultField.BOMField.CHILDNUMERATOR.getName(), BigDecimal.class);
        this.bomDatas.getNotNullableColMap().put(DefaultField.BOMField.CHILDDENOMINATOR.getName(), BigDecimal.class);
        this.bomDatas.getNotNullableColMap().put(DefaultField.BOMField.CTRLSTRATEGY.getName(), String.class);
    }

    public List<FieldMapping> getR2b() {
        return this.r2b;
    }

    public void loadBOMMaterialExtProps() {
        BOMStructDataTable bomDatas = this.getTable();
        this.initMaterialPlanInfos();
    }

    public void restoreBOM() {
        if (this.isBOMInitialized) {
            return;
        }
        if (this.bomDatas == null || !this.bomDatas.getSrcDatas().getDatas().isEmpty()) {
            return;
        }
        Map<String, Integer> bomTableColIdx = MRPCacheManager.getInst().getBOMTableColIdx(this.env);
        if (bomTableColIdx.isEmpty()) {
            logger.warn(String.format("ctxid: %s, mrprunner-restoreBOM-colIdx-isNull", this.mrpContextId));
            return;
        }
        this.restoreBOM(bomTableColIdx, this.bomDatas);
        this.isBOMInitialized = true;
    }

    private void restoreBOM(Map<String, Integer> bomTableColIdx, BOMStructDataTable bomDatas) {
        if (bomDatas.getColIdx().isEmpty()) {
            bomDatas.setColIdx(bomTableColIdx);
        } else {
            bomDatas.getColIdx().putAll(bomTableColIdx);
        }
        BomDataModel.restoreBOM(this.env, bomDatas);
    }

    private static void restoreBOM(CalEnv env, BOMStructDataTable bomDatas) {
        List list;
        String requireMaterialCache;
        String shareCache = MRPCacheManager.getInst().getData(env, MRPRuntimeConsts.getBOMShareCacheKey(env.getMRPContextId()));
        if (StringUtils.isNotEmpty((String)shareCache)) {
            Map shareCacheMap = (Map)JSON.parseObject((String)shareCache, (TypeReference)new TypeReference<Map<Long, Set<Long>>>(){}, (Feature[])new Feature[0]);
            bomDatas.setShareCache(shareCacheMap);
        }
        Iterator<Object[]> datas = MRPCacheManager.getInst().getBOMTableSrcData2(env);
        bomDatas.restoreDatas(datas);
        String replaceCache = MRPCacheManager.getInst().getData(env, MRPRuntimeConsts.getReplaceStructTable(env.getMRPContextId()));
        if (StringUtils.isNotEmpty((String)replaceCache)) {
            Map replaceGroupCache = (Map)JSON.parseObject((String)replaceCache, Map.class);
            HashMap<String, ReplaceStruct> mainMaterialGroup = null;
            if (replaceGroupCache != null) {
                mainMaterialGroup = new HashMap<String, ReplaceStruct>(replaceGroupCache.size());
                for (Map.Entry entry : replaceGroupCache.entrySet()) {
                    mainMaterialGroup.put((String)entry.getKey(), (ReplaceStruct)SerializableUtils.fromSerializedString((String)((String)entry.getValue()), ReplaceStruct.class));
                }
                bomDatas.setMainMaterialGroup(mainMaterialGroup);
            }
        }
        if (StringUtils.isNotEmpty((String)(requireMaterialCache = MRPCacheManager.getInst().getData(env, MRPRuntimeConsts.getRequireMaterialKey(env.getMRPContextId())))) && (list = JSON.parseArray((String)requireMaterialCache, String.class)) != null) {
            bomDatas.setRequireMaterials(new HashSet<String>(list));
        }
    }

    public Integer compareBomVersionPriority(Long version1, Long version2, Long bomTime) {
        DynamicObject v1 = null;
        DynamicObject v2 = null;
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        if (version1 != null && version1 > 0L) {
            v1 = cacheDatas.reloadDataById("bd_bomversion", version1, "effectdate,invaliddate");
        }
        if (version2 != null && version2 > 0L) {
            v2 = cacheDatas.reloadDataById("bd_bomversion", version2, "effectdate,invaliddate");
        }
        Long valid1 = this.getDateTime(v1, "effectdate", 0L);
        Long invalid1 = this.getDateTime(v1, "invaliddate", 0x3FFFFFFFFFFFFFFFL);
        Long valid2 = this.getDateTime(v2, "effectdate", 0L);
        Long invalid2 = this.getDateTime(v2, "invaliddate", 0x3FFFFFFFFFFFFFFFL);
        boolean v1Valid = this.isValidVersion(valid1, invalid1, bomTime);
        boolean v2Valid = this.isValidVersion(valid2, invalid2, bomTime);
        if (!v1Valid && !v2Valid) {
            return 0;
        }
        if (!v1Valid) {
            return 1;
        }
        if (!v2Valid) {
            return -1;
        }
        return valid2.compareTo(valid1);
    }

    private boolean isValidVersion(Long valid, Long invalid, Long bomTime) {
        return valid <= bomTime && invalid >= bomTime;
    }

    private Long getDateTime(DynamicObject v, String timeName, Long defaultTime) {
        if (v != null && v.getDate(timeName) != null) {
            return v.getDate(timeName).getTime();
        }
        return defaultTime;
    }
}

